#!/usr/bin/perl

# makefiles.pl
# 5-22-03 by Jon Bieker
# (c)2003 Sprint


# Grab copies of existing configuration files.
system("cp -f /etc/inetd.conf ./inetd.conf.orig");
system("cp -f /etc/services ./services.orig");

# Load currently defined services
$i = 0;
open(hIn,"<services.orig");
while (<hIn>) {
  $line = $_;
  chop $line;
  
  if (substr($line,0,1) ne "#" && length($line) > 0) {
  
    $line =~ s/\s+/ /g;
    
    ($svc,$port,$junk) = split(/ /,$line);
    
    @ports[$i] = $port;
    @svcs[$i] = $svc;
    
    $i++;      
  }
}
close(hIn);

$services = @svcs;

open(hOut,">services.new");
for ($i = 0; $i < 70001; $i++) {

  $svc = "tcp_port_" . $i;
  $port = $i . "\/tcp";
  
  for ($j = 0; $j < $services; $j++) {
    if (@ports[$j] eq $port) {
      $comment = "# " . @svcs[$j];
      $j = $services;
    } else {
      $comment = "";
    }
  }
  
  $line = "$svc\t$port\t$comment\n";
  
  print hOut $line;

}
close(hOut);

open(hOut,">inetd.conf.new");
for ($i = 0; $i < 70001; $i++) {

  $svc = "tcp_port_" . $i;
  $arg = "port=" . $i;
  
  if ($i != 23) {
    $line = "$svc\tstream tcp nowait root /opt/fw_check/fw_slave $arg\n";
  } else {
    $line = "$svc\tstream tcp nowait root /usr/lbin/telnetd  telnetd\n";
  }

  print hOut $line;
}
close(hOut);



# finis

exit(0);
