/*
	hwlist.c
	5-30-01 by Jon Bieker
	(c)2001 Sprint
*/

#include "../include/include.h"
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <sys/socket.h>

#define BUFLEN 256
#define HIGHSPEEDLINKS 1000
#define LOWSPEEDLINKS 4500
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif
#define SIGNALINGPOINTS 2500

int s;

char *hostname;
char hnamebuf[MAXHOSTNAMELEN];

struct lscc {
	char linknum[5];
	struct link link;
	struct linkset ls;
	struct v35culinkinterface v35li;
	struct ifpclinkmonitoring ifpclm[7];
};

struct hscc {
	char linknum[5];
	struct link link;
	struct linkset ls;
	struct hsiclinkinterface hsli;
};

struct sites {
	int siteno;
	char name[4];
};
	
int main() 
{
	char cBuf[BUFLEN], cTmpBuf[BUFLEN], cETRBuf[BUFLEN], cETRBuf2[BUFLEN];
	char cHostname[MAXHOSTNAMELEN];
	int nI, nJ, nK, nEOF, nTmpLoc, nLinkLoc, nPPLoc, nHSLoc, nLSLoc, nDelay, nBytes, nSP;
	char lMissing,lGoodPing,lFound,lQuote,lExit;
	
	FILE *hEtr, *hLinks, *hDis, *hDis_not_PRV, *hDis_PRV, *hDom_Dis, *hHwlist, *hFile;
	FILE *hDom_Dis_not_PRV, *hEnabled, *hInternal, *hDisconnect;
	FILE *hPCS_Dis, *hPCS, *hPCS_Dis_PRV, *hPCS_PRV, *hPCS_Enabled, *hPCS_Dis_not_PRV;
	FILE *hTmp;

        int nCount;
        
	/* Structs */	
	struct sockaddr_in to;
	struct protoent *proto;

	/* High Speed */
	struct probeprocessor probeprocessor;
	struct hsics hsics;
	struct probeprocessoralarms probeprocessoralarms;
	
	/* Low Speed */
	struct e4251acardcage e4251acardcage;
	struct ifpcs ifpcs;
	struct ifcards ifcards;
	struct concentratorunits concentratorunits;
	struct e4251acardcagealarms e4251acardcagealarms;

	/* Linkset info */	
	struct linkset linkset;
	struct link link;
	struct v35culinkinterface v35culinkinterface;
	struct hsiclinkinterface hsiclinkinterface;
	
	struct lscc lscc[LOWSPEEDLINKS];
	struct hscc hscc[HIGHSPEEDLINKS];
	struct sp sp[SIGNALINGPOINTS];
	
	struct sites sites[50];
		
	sites[1].siteno = 1;
	strcpy(sites[1].name,"RIL");
	sites[2].siteno = 101;
	strcpy(sites[2].name,"RIL");
	sites[3].siteno = 2;
	strcpy(sites[3].name,"STK");
	sites[4].siteno = 102;
	strcpy(sites[4].name,"STK");
	sites[5].siteno = 3;
	strcpy(sites[5].name,"CHI");
	sites[6].siteno = 103;
	strcpy(sites[6].name,"CHI");
	sites[7].siteno = 3;
	strcpy(sites[7].name,"CHC");
	sites[8].siteno = 103;
	strcpy(sites[8].name,"CHC");
	sites[9].siteno = 2;
	strcpy(sites[9].name,"STO");
	sites[10].siteno = 102;
	strcpy(sites[10].name,"STO");
	sites[11].siteno = 4;
	strcpy(sites[11].name,"FTW");
	sites[12].siteno = 104;
	strcpy(sites[12].name,"FTW");
	sites[13].siteno = 5;
	strcpy(sites[13].name,"ATL");
	sites[14].siteno = 105;
	strcpy(sites[14].name,"ATL");
	sites[15].siteno = 6;
	strcpy(sites[15].name,"NAS");
	sites[16].siteno = 106;
	strcpy(sites[16].name,"NAS");
	sites[17].siteno = 7;
	strcpy(sites[17].name,"AKR");
	sites[18].siteno = 107;
	strcpy(sites[18].name,"AKR");
	sites[19].siteno = 8;
	strcpy(sites[19].name,"NYC");
	sites[20].siteno = 108;
	strcpy(sites[20].name,"NYC");

	printf("Hardware List\n");
	printf("5-30-01 by Jon Bieker\n");
	printf("(c)2001 Sprint\n\n");
	fflush(stdout);
	
	/****************
	*  Init Arrays  *
	****************/
	memcpy(&cBuf,0,sizeof(cBuf));
	memcpy(&cTmpBuf,0,sizeof(cTmpBuf));

	/******************
	*  Set up structs *
	******************/
	to.sin_family = AF_INET;
	to.sin_port = htons(8080);
	
	proto = getprotobyname("tcp");
	if (!proto) {
		printf("Invalid protocol: tcp\n");
		exit(1);
	}

	uselog("hwlist","");

	/*****************
	*  Get hostname  *
	*****************/
	gethostname(cHostname,sizeof(cHostname));
	
	/********************
	*  Create ETR File  *
	********************/
	if (!strcmp(cHostname,"m7server")) {
		printf("Creating ETR file...\n");
		fflush(stdout);
		
		strcpy(cBuf,". /etc/opt/platform7/share/env/p7profile ; /opt/platform7/bin/p7config -db /home/a7users/ss7gjobi/var/etr/etrfile.etr");
		system(cBuf);
		
		strcpy(cBuf,"cp /home/a7users/ss7gjobi/var/etr/etrfile.etr /opt/cronjobs/var/etr/etrfile.etr");
		system(cBuf);
		
		strcpy(cBuf,"cp /home/a7users/ss7gjobi/var/etr/etrfile.etr /home/a7users/ss7gjobi/src/etr/etrfile.etr");
		system(cBuf);
		
	}

	/******************
	*  Open ETR File  *
	******************/
	hEtr = fopen("/home/a7users/ss7gjobi/var/etr/etrfile.etr","r");
	if (!hEtr) {
		printf("Error %0d!  Couldn't open ETR file!\n",errno);
		perror(errno);
		exit(1);
	}
	
	/**************
	*  Main Loop  *
	**************/
	
	printf("Caching signaling points... ");
	fflush(stdout);
	
	nSP = 0;
	nEOF = 0;
	while (strcmp(cBuf,"[signalingpoints]") && !nEOF) {
		if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
		trim(&cBuf);
	}
	
	/* Skip comment lines */
	for (nI = 0; nI < 7; nI++) {
		fgets(cBuf,sizeof(cBuf),hEtr);
	}
	
	nSP = 0;
	while (!nEOF && strlen(cBuf) > 1) {
		if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
		
		/* Remove LF */
		cBuf[strlen(cBuf)] = 0;
	
		/* Handle quoted strings with spaces (ARRGH!) */
		lQuote = 0;
		for (nI = 0; nI < strlen(cBuf); nI++) {
			if (cBuf[nI] == 0x22 && !lQuote) {
				lQuote = 1;
			} else if (cBuf[nI] == 0x22 && lQuote) {
				lQuote = 0;
			} else if (cBuf[nI] == 0x20 && lQuote) {
				cBuf[nI] = 0x5f;
			}		
		}
		
		strcpy(sp[nSP].name,strtok(cBuf," "));
		strcpy(sp[nSP].altname,strtok(NULL," "));
		strcpy(sp[nSP].pointcode,strtok(NULL," "));
		strcpy(sp[nSP].type,strtok(NULL," "));
		strcpy(sp[nSP].capcode,strtok(NULL," "));
		strcpy(sp[nSP].site,strtok(NULL," "));
		strcpy(sp[nSP].flag,strtok(NULL," "));
		strcpy(sp[nSP].class,strtok(NULL," "));
		
/*		for (nI = 1; nI < strlen(sp[nSP].name); nI++) sp[nSP].name[nI - 1] = sp[nSP].name[nI];
		for (nI = 1; nI < strlen(sp[nSP].altname); nI++) sp[nSP].altname[nI - 1] = sp[nSP].altname[nI];
		sp[nSP].name[strlen(sp[nSP].name) - 2] = 0;
		sp[nSP].altname[strlen(sp[nSP].altname) - 2] = 0;
*/
		if (nSP < SIGNALINGPOINTS) nSP++;
		
	}

	printf("%0d SP's found.\n",nSP);
	
	printf("Caching links...\n");
	nHSLoc = nLSLoc = 0;
	nEOF = 0;
	while (strcmp(cBuf,"[linkset]") && !nEOF) {
		if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
		trim(&cBuf);
	}

	/* Locate Links */
	while (!nEOF && *strstr(cBuf,"[site]") < 1) {
					
		while (strcmp(cBuf,"[linkset]") \
			&& !nEOF) {
			
			if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
			trim(&cBuf);
		}

		if (!strcmp(cBuf,"[linkset]")) {

			fgets(cBuf,sizeof(cBuf),hEtr);
			trim(&cBuf);
			
			strcpy(linkset.monsp,strtok(cBuf," "));
			strcpy(linkset.remsp,strtok(NULL," "));
			strcpy(linkset.linktype,strtok(NULL," "));
			strcpy(linkset.norm,strtok(NULL," "));
			strcpy(linkset.name,strtok(NULL," "));

			/* Remove quotes */
			for (nI = 0; nI < strlen(linkset.name); nI++) linkset.name[nI] = linkset.name[nI+1];
			linkset.name[nI-2] = 0;

/*			printf("Linkset: %s %s %s %s %s\n\n",linkset.monsp,linkset.remsp,linkset.linktype,linkset.norm,linkset.name);
*/

		}

		/* Get all links until the next [linkset] and before EOF */
		while (strcmp(cBuf,"[linkset]") \
			&& !nEOF) {

			if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
			trim(&cBuf);

			/* Look for [link]... */
			while (strcmp(cBuf,"[link]") \
				&& !nEOF \
				&& strcmp(cBuf,"[linkset]")) {
				
				if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
				trim(&cBuf);
			}

			if (!strcmp(cBuf,"[link]")) {

				/* Read [link] lines */
				fgets(cETRBuf,sizeof(cETRBuf),hEtr);
				trim(&cETRBuf);

				fgets(cETRBuf2,sizeof(cETRBuf),hEtr);
				trim(&cETRBuf2);

				/* Concatenate the two lines */
				strcat(cETRBuf,cETRBuf2);

				strcpy(cBuf,strtok(cETRBuf,"\\\n"));
				strcpy(cETRBuf2,strtok(NULL,"\n"));
	
				for (nI = 0; nI < strlen(cETRBuf2); nI++) cETRBuf2[nI] = cETRBuf2[nI+2];
				cETRBuf2[nI-2] = 0;
	
				strcat(cBuf,cETRBuf2);
				strcpy(cETRBuf,cBuf);
	
				/* Parse [link] lines */
				strcpy(link.slc,strtok(cETRBuf," "));
				strcpy(link.link_protocol,strtok(NULL," "));
				strcpy(link.personality,strtok(NULL," "));
				strcpy(link.name,strtok(NULL," "));
				strcpy(link.altname,strtok(NULL," "));
				strcpy(link.chanA_characteristic,strtok(NULL," "));
				strcpy(link.chanA_pcr,strtok(NULL," "));
				strcpy(link.chanA_subrate_num,strtok(NULL," "));
				strcpy(link.chanA_vpi,strtok(NULL," "));
				strcpy(link.chanA_vci,strtok(NULL," "));
				strcpy(link.chanA_unscramble,strtok(NULL," "));
				strcpy(link.chanA_hec,strtok(NULL," "));
				strcpy(link.chanB_characteristic,strtok(NULL," "));
				strcpy(link.chanB_pcr,strtok(NULL," "));
				strcpy(link.chanB_subrate_num,strtok(NULL," "));
				strcpy(link.chanB_vpi,strtok(NULL," "));
				strcpy(link.chanB_vci,strtok(NULL," "));
				strcpy(link.chanB_unscramble,strtok(NULL," "));
				strcpy(link.chanB_hec,strtok(NULL," "));
				strcpy(link.linktype,strtok(NULL," "));
				strcpy(link.mon_sys,strtok(NULL," "));
				strcpy(link.status,strtok(NULL," "));

/*				printf("Link: %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n\n",link.slc,link.link_protocol,link.personality,link.name,link.altname,link.chanA_characteristic,link.chanA_pcr,link.chanA_subrate_num,link.chanA_vpi,link.chanA_vci,link.chanA_unscramble,link.chanA_hec,link.chanB_characteristic,link.chanB_pcr,link.chanB_subrate_num,link.chanB_vpi,link.chanB_vci,link.chanB_unscramble,link.chanB_hec,link.linktype,link.mon_sys,link.status);
*/
				/* Remove quotes */
				for (nI = 0; nI < strlen(link.altname); nI++) link.altname[nI] = link.altname[nI+1];
				link.altname[nI-2] = 0;
				for (nI = 0; nI < strlen(link.name); nI++) link.name[nI] = link.name[nI+1];
				link.name[nI-2] = 0;

				/* Read blank line */
				fgets(cBuf,sizeof(cBuf),hEtr);

				/* Read link monitoring type */
				fgets(cBuf,sizeof(cBuf),hEtr);
				trim(&cBuf);
				
				/* Read link monitoring info */
				if (!strcmp(cBuf,"[v35culinkinterface]")) {

					fgets(cBuf,sizeof(cBuf),hEtr);
					trim(&cBuf);

					strcpy(v35culinkinterface.site,strtok(cBuf," "));
					strcpy(v35culinkinterface.cardcage,strtok(NULL," "));
					strcpy(v35culinkinterface.ifslot,strtok(NULL," "));
					strcpy(v35culinkinterface.concentrator,strtok(NULL," "));
					strcpy(v35culinkinterface.cuconnector,strtok(NULL," "));

/*					printf("v35 CU Link Interface: Site: %s CC: %s IFSlot: %s CU: %s Conn: %s\n\n",v35culinkinterface.site,v35culinkinterface.cardcage,v35culinkinterface.ifslot,v35culinkinterface.concentrator,v35culinkinterface.cuconnector);
*/

					/*  Look for misconfigured links. */
/*					for (nJ = 0; nJ < 50; nJ++) {
						if (sites[nJ].siteno == atoi(v35culinkinterface.site)) {
							if (strncmp(link.altname,sites[nJ].name,2) \
								&& strncmp(link.altname,"PRV",3) \
								&& strncmp(link.altname,"PR-",3) \
								&& strncmp(link.altname,"DIS",3)) {
								printf("Link: %s<%s>%s\t%s %s is misconfigured!  Should be %s.\n",linkset.monsp,link.slc,linkset.remsp,link.name,link.altname,sites[nJ].name);
								nJ = 50;
							}							
						}
					}
*/
					strcpy(lscc[nLSLoc].link.slc,link.slc);
					strcpy(lscc[nLSLoc].link.status,link.status);
					strcpy(lscc[nLSLoc].link.altname,link.altname);
					strcpy(lscc[nLSLoc].ls.monsp,linkset.monsp);
					strcpy(lscc[nLSLoc].ls.remsp,linkset.remsp);
					strcpy(lscc[nLSLoc].ls.name,linkset.name);
					strcpy(lscc[nLSLoc].ls.linktype,linkset.linktype);
					strcpy(lscc[nLSLoc].link.name,link.name);
					strcpy(lscc[nLSLoc].link.altname,link.altname);
					strcpy(lscc[nLSLoc].v35li.site,v35culinkinterface.site);
					strcpy(lscc[nLSLoc].v35li.cardcage,v35culinkinterface.cardcage);
					strcpy(lscc[nLSLoc].v35li.ifslot,v35culinkinterface.ifslot);
					strcpy(lscc[nLSLoc].v35li.concentrator,v35culinkinterface.concentrator);
					strcpy(lscc[nLSLoc].v35li.cuconnector,v35culinkinterface.cuconnector);

					/* Extract the link number... */
					if (strstr(link.altname,"-")) {
						/* Make a copy of the altname */
						strcpy(cTmpBuf,link.altname);
						
						/* Throw away the first part */
						strcpy(cBuf,strtok(cTmpBuf,"-"));

						/* Throw away the second part */
						strcpy(cBuf,strtok(NULL,"-"));
						
						/* Grab the link number out of the altname */
						strcpy(cBuf,strtok(NULL,0x00));
						
						/* ... and save it in the struct */
						strcpy(lscc[nLSLoc].linknum,cBuf);
					}

					/* Read blank line */
					fgets(cBuf,sizeof(cBuf),hEtr);
				
					/* Read [ifpclinkmonitoring] line */
					fgets(cBuf,sizeof(cBuf),hEtr);
					trim(&cBuf);
					
					if (!strcmp(cBuf,"[ifpclinkmonitoring]")) {
						nJ = 0;
						while (strlen(cBuf) > 1 && nJ < 8) {
							fgets(cBuf,sizeof(cBuf),hEtr);
							trim(&cBuf);

							if (strlen(cBuf) > 1) {
								strcpy(cTmpBuf,cBuf);
								strcpy(lscc[nLSLoc].ifpclm[nJ].application,strtok(cTmpBuf," "));
								strcpy(lscc[nLSLoc].ifpclm[nJ].ifpcslot,strtok(NULL," "));
								strcpy(lscc[nLSLoc].ifpclm[nJ].linktype,strtok(NULL," "));
								nJ++;
							}
						}
					} else {
						printf("Link: %s<%s>%s\t%s %s is missing IFPC monitoring info!\n",linkset.monsp,link.slc,linkset.remsp,link.name,link.altname);
					}
					
					if (nLSLoc < LOWSPEEDLINKS) nLSLoc++;

				} else if (!strcmp(cBuf,"[hsiclinkinterface]")) {

					fgets(cBuf,sizeof(cBuf),hEtr);
					trim(&cBuf);
	
					strcpy(hsiclinkinterface.site,strtok(cBuf," "));
					strcpy(hsiclinkinterface.probeproc,strtok(NULL," "));
					strcpy(hsiclinkinterface.chAhsic,strtok(NULL," "));
					strcpy(hsiclinkinterface.chAbearer,strtok(NULL," "));
					strcpy(hsiclinkinterface.chBhsic,strtok(NULL," "));
					strcpy(hsiclinkinterface.chBbearer,strtok(NULL," "));
					strcpy(hsiclinkinterface.linktype,strtok(NULL," "));
/* 					
					printf("HSIC Link Interface: %s %s %s %s %s %s %s\n\n",hsiclinkinterface.site,hsiclinkinterface.probeproc,hsiclinkinterface.chAhsic,hsiclinkinterface.chAbearer,hsiclinkinterface.chBhsic,hsiclinkinterface.chBbearer,hsiclinkinterface.linktype);
*/
					strcpy(hscc[nHSLoc].link.slc,link.slc);
					strcpy(hscc[nHSLoc].link.status,link.status);
					strcpy(hscc[nHSLoc].link.altname,link.altname);
					strcpy(hscc[nHSLoc].ls.monsp,linkset.monsp);
					strcpy(hscc[nHSLoc].ls.remsp,linkset.remsp);
					strcpy(hscc[nHSLoc].ls.name,linkset.name);
					strcpy(hscc[nHSLoc].ls.linktype,linkset.linktype);
					strcpy(hscc[nHSLoc].link.name,link.name);
					strcpy(hscc[nHSLoc].link.altname,link.altname);
					strcpy(hscc[nHSLoc].hsli.site,hsiclinkinterface.site);
					strcpy(hscc[nHSLoc].hsli.probeproc,hsiclinkinterface.probeproc);
					strcpy(hscc[nHSLoc].hsli.chAhsic,hsiclinkinterface.chAhsic);
					strcpy(hscc[nHSLoc].hsli.chAbearer,hsiclinkinterface.chAbearer);
					strcpy(hscc[nHSLoc].hsli.chBhsic,hsiclinkinterface.chBhsic);
					strcpy(hscc[nHSLoc].hsli.chBbearer,hsiclinkinterface.chBbearer);
					strcpy(hscc[nHSLoc].hsli.linktype,hsiclinkinterface.linktype);

					/* Extract the link number... */
					if (strstr(link.altname,"-")) {
						/* Make a copy of the altname */
						strcpy(cTmpBuf,link.altname);
						
						/* Throw away the first part */
						strcpy(cBuf,strtok(cTmpBuf,"-"));
						
						/* Throw away the second part */
						strcpy(cBuf,strtok(NULL,"-"));
						
						/* Grab the link number out of the altname */
						strcpy(cBuf,strtok(NULL,0x00));

						/* ... and save it in the struct */
						strcpy(hscc[nHSLoc].linknum,cBuf);
					}

					if (nHSLoc < HIGHSPEEDLINKS) nHSLoc++;
				} else {
					printf("Link: %s<%s>%s\t%s %s is missing cardcage info!\n",linkset.monsp,link.slc,linkset.remsp,link.name,link.altname);
				}
			}
		}
	}

	/* Look for orphaned SP's */
	printf("Orphaned SP's:\n");
	nK = 0;
	for (nI = 0; nI < nSP; nI++) {
		lFound = 0;
		for (nJ = 0; nJ < nLSLoc; nJ++) {
			if (!strcmp(sp[nI].pointcode,lscc[nJ].ls.monsp) \
				|| !strcmp(sp[nI].pointcode,lscc[nJ].ls.remsp)) {
				
				lFound = 1;
				nJ = nLSLoc;
			}
		}
		if (!lFound) {
 			for (nJ = 0; nJ < nHSLoc; nJ++) {
				if (!strcmp(sp[nI].pointcode,hscc[nJ].ls.monsp) \
					|| !strcmp(sp[nI].pointcode,hscc[nJ].ls.remsp)) {
				
					lFound = 1;
					nJ = nHSLoc;
				}
 			}		
		}
		
		if (!lFound) {
			printf("%s\t%s\n",sp[nI].name,sp[nI].pointcode);
			nK++;
		}
	}
	printf("%0d orphaned SPs found.\n\n",nK - 1);

	printf("Finding low-speed equipment...\n");

	/* Move to beginning of file */
	rewind(hEtr);

        hTmp = fopen("/home/a7users/ss7gjobi/src/hwlist/ifpc_enabled.txt","w");

	/* Open links files */
	hLinks = fopen("/home/a7users/ss7gjobi/var/disabled_links/all_links.txt","w");
	hDis = fopen("/home/a7users/ss7gjobi/var/disabled_links/disabled_links.txt","w");
	hDis_not_PRV = fopen("/home/a7users/ss7gjobi/var/disabled_links/disabled_not_provisioning.txt","w");
	hDis_PRV = fopen("/home/a7users/ss7gjobi/var/disabled_links/disabled_provisioning.txt","w");
	hDom_Dis = fopen("/home/a7users/ss7gjobi/var/disabled_links/domestic_disabled_links.txt","w");
	hDom_Dis_not_PRV = fopen("/home/a7users/ss7gjobi/var/disabled_links/domestic_disabled_not_prv_links.txt","w");
	hEnabled = fopen("/home/a7users/ss7gjobi/var/disabled_links/enabled_prv.txt","w");
	hInternal = fopen("/home/a7users/ss7gjobi/var/disabled_links/internal.txt","w");
	hHwlist = fopen("/home/a7users/ss7gjobi/var/hwlist/xl_hwlist.txt","w");
	hDisconnect = fopen("/home/a7users/ss7gjobi/var/disabled_links/disconnect.txt","w");

	/* Open PCS specific files */
	hPCS = fopen("/home/a7users/ss7gjobi/var/disabled_links/pcs.txt","w");
	hPCS_Dis_PRV = fopen("/home/a7users/ss7gjobi/var/disabled_links/pcs_dis_prv.txt","w");
	hPCS_Dis = fopen("/home/a7users/ss7gjobi/var/disabled_links/pcs_dis.txt","w");
	hPCS_PRV = fopen("/home/a7users/ss7gjobi/var/disabled_links/pcs_prv.txt","w");
	hPCS_Enabled = fopen("/home/a7users/ss7gjobi/var/disabled_links/pcs_enabled_prv.txt","w");
	hPCS_Dis_not_PRV = fopen("/home/a7users/ss7gjobi/var/disabled_links/pcs_dis_not_prv.txt","w");

	/* Copy header to output files (except hwlist.txt) */
	strcpy(cBuf,"Monitored Remote . Link SLC Link Alt . Link\nSignal_Point Signal_Point Type Name Number Name Name Status No.\n\n");
	fputs(cBuf,hLinks);
	fputs(cBuf,hDis);
	fputs(cBuf,hDis_not_PRV);
	fputs(cBuf,hDis_PRV);
	fputs(cBuf,hDom_Dis);
	fputs(cBuf,hDom_Dis_not_PRV);
	fputs(cBuf,hEnabled);
	fputs(cBuf,hInternal);
	fputs(cBuf,hDisconnect);
	fputs(cBuf,hPCS);
	fputs(cBuf,hPCS_Dis_PRV);
	fputs(cBuf,hPCS_Dis_not_PRV);
	fputs(cBuf,hPCS_PRV);
	fputs(cBuf,hPCS_Dis);
	fputs(cBuf,hPCS_Enabled);
	
	nPPLoc = 0;
	nLinkLoc = 0;
	nEOF = 0;
	while (!nEOF) {
		/* Find the next [e4251acardcage] section. */
		while (strcmp(cBuf,"[e4251acardcage]") && !nEOF) {
			if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
			trim(&cBuf);

			if (!strcmp(cBuf,"[probeprocessor]")) nEOF = 1;
		}

		fgets(cBuf,sizeof(cBuf),hEtr);
		trim(&cBuf);
	
		strcpy(cTmpBuf,cBuf);
		strcpy(e4251acardcage.site,strtok(cTmpBuf," "));
		strcpy(e4251acardcage.cardcage,strtok(NULL,"\""));
					
		/* Remove trailing space */
		for (nJ = 0; nJ < strlen(e4251acardcage.cardcage) - 1; nJ++) cBuf[nJ] = e4251acardcage.cardcage[nJ];
		cBuf[nJ] = 0;
		strcpy(e4251acardcage.cardcage,cBuf);

		strcpy(e4251acardcage.location,strtok(NULL,"\""));
		strcpy(e4251acardcage.reset_period,strtok(NULL," "));
		strcpy(e4251acardcage.master_clock,strtok(NULL," "));
		strcpy(e4251acardcage.backup_clock,strtok(NULL," "));
		strcpy(e4251acardcage.severity,strtok(NULL," "));
		strcpy(e4251acardcage.clearance_period,strtok(NULL," "));

		if (strlen(e4251acardcage.site) > 0) {
			printf("\nSite: %s  CC: %s  Location: %s\n",e4251acardcage.site,e4251acardcage.cardcage,e4251acardcage.location);
		}

		/* Read blank line */
		fgets(cBuf,sizeof(cBuf),hEtr);

		/* Read [ifpcs] line */
		fgets(cBuf,sizeof(cBuf),hEtr);
		trim(&cBuf);

		lMissing = 0;
		if (strcmp(cBuf,"[ifpcs]")) {
/*			printf("Missing [ifpcs] line: |%s|\n",cBuf);
*/			lMissing = 1;
		}

		if (strstr(cBuf,"###")) nEOF = 1;
		
		if (!lMissing) {
			while (strlen(cBuf) > 1) {
				fgets(cBuf,sizeof(cBuf),hEtr);
				trim(&cBuf);

				if (strlen(cBuf) > 1) {
					strcpy(cTmpBuf,cBuf);
					strcpy(ifpcs.slot,strtok(cTmpBuf," "));
					strcpy(ifpcs.mac,strtok(NULL,"\""));
					strcpy(ifpcs.hostname,strtok(NULL," "));
					strcpy(ifpcs.ip,strtok(NULL," "));
					strcpy(ifpcs.appset,strtok(NULL," "));

					printf("\tIFPC Slot: %s  MAC: %s  Hostname: %s  IP: %s",ifpcs.slot,ifpcs.mac,ifpcs.hostname,ifpcs.ip);

					
					fputs(ifpcs.hostname,hTmp);
					fputs(",",hTmp);
					
					/********************
					*  Connect to IFPC  *
					********************/

					/* Bind to a socket */
					s = socket(AF_INET,SOCK_STREAM,proto->p_proto);
					if (s < 0) {
						printf("Error %0d creating socket!\n",errno);
						perror(errno);
						exit(1);
					}

					to.sin_addr.s_addr = inet_addr(ifpcs.ip);

					if (connect(s, (struct sockaddr *) &to, sizeof(to)) < 0) {
						printf("\tIFPC is NOT responding.\n");
						strcpy(ifpcs.status,"IFPC is NOT responding.");
					} else {
						printf("\tIFPC is responding.\n");
						strcpy(ifpcs.status,"IFPC is responding.");
					}
					
					close(s);

					lFound = 0;
					nCount = 0;
					for (nI = 0; nI < nLSLoc; nI++) {
						if (atoi(e4251acardcage.site) == atoi(lscc[nI].v35li.site) \
							&& atoi(e4251acardcage.cardcage) == atoi(lscc[nI].v35li.cardcage) \
							&& atoi(ifpcs.slot) == atoi(lscc[nI].ifpclm[0].ifpcslot)) {
							
							if (!strcmp(lscc[nI].link.status,"ENABLED")) nCount++;
							
							lFound = 1;

							printf("\t\t%s \t%0d \t%s  \t%s <%s> %s\t %s",lscc[nI].link.status,atoi(lscc[nI].linknum),lscc[nI].link.altname,lscc[nI].ls.monsp,lscc[nI].link.slc,lscc[nI].ls.remsp);

							/* Write xl_hwlist.txt info */
							strcpy(cBuf,e4251acardcage.site);
							strcat(cBuf,"\t");
							strcat(cBuf,e4251acardcage.cardcage);
							strcat(cBuf,"\t");
							strcat(cBuf,ifpcs.slot);
							strcat(cBuf,"\t");
							strcat(cBuf,ifpcs.hostname);
							strcat(cBuf,"\t");
							strcat(cBuf,ifpcs.ip);
							strcat(cBuf,"\t");
							strcat(cBuf,ifpcs.status);
							strcat(cBuf,"\t");
							strcat(cBuf,lscc[nI].link.status);
							strcat(cBuf,"\t");
							strcat(cBuf,ltoa(atoi(lscc[nI].linknum)));
							strcat(cBuf,"\t");
							strcat(cBuf,lscc[nI].link.altname);
							strcat(cBuf,"\t");
							strcat(cBuf,lscc[nI].ls.monsp);
							strcat(cBuf,"\t");
							strcat(cBuf,lscc[nI].link.slc);
							strcat(cBuf,"\t");
							strcat(cBuf,lscc[nI].ls.remsp);
							strcat(cBuf,"\n");
							
							fputs(cBuf,hHwlist);
							

							if (!strncmp(lscc[nI].link.altname,"DIS",3)) {
								printf("\tDISCONNECT PENDING!\n");
							} else {
								printf("\n");
							}

							strcpy(cBuf,lscc[nI].ls.monsp);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].ls.remsp);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].ls.linktype);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].ls.name);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].link.slc);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].link.name);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].link.altname);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].link.status);
							strcat(cBuf," ");
							strcat(cBuf,lscc[nI].linknum);
							strcat(cBuf,"\n\0");
							
							/* Write link info to all_links.txt file */
							fputs(cBuf,hLinks);

							/* Write PCS links */
							if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
								fputs(cBuf,hPCS);
							}
								
							/* Write Sprint Internal links */
							if (!strncmp(lscc[nI].ls.remsp,"253-",4)) {
								fputs(cBuf,hInternal);
							}

							/* Check for DISABLED */
							if (!strcmp(lscc[nI].link.status,"DISABLED")) {
								fputs(cBuf,hDis);

								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Dis);
								}
							}

							/* Check for DISABLED NOT PRV */
							if (!strcmp(lscc[nI].link.status,"DISABLED") \
								&& !strstr(lscc[nI].link.altname,"PRV-") \
								&& !strstr(lscc[nI].link.altname,"PR-")) {

								fputs(cBuf,hDis_not_PRV);
									
								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Dis_not_PRV);
								}

							}
							
							/* Check for DISABLED PRV */
							if (!strcmp(lscc[nI].link.status,"DISABLED") \
								&& (strstr(lscc[nI].link.altname,"PRV-") \
								|| strstr(lscc[nI].link.altname,"PR-"))) {
							
								fputs(cBuf,hDis_PRV);
									
								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Dis_PRV);
								}

							}

							/* Check for DOMESTIC DISABLED */
							if (!strcmp(lscc[nI].link.status,"DISABLED") \
								&& !strstr(lscc[nI].ls.monsp,"IN:")) {
								
								fputs(cBuf,hDom_Dis);
							}
							
							/* Check for DOMESTIC DISABLED NOT PRV */
							if (!strcmp(lscc[nI].link.status,"DISABLED") \
								&& !strstr(lscc[nI].link.altname,"PRV-") \
								&& !strstr(lscc[nI].link.altname,"PR-") \
								&& !strstr(lscc[nI].ls.monsp,"IN:")) {
							
								fputs(cBuf,hDom_Dis_not_PRV);
							}
					
							/* Check for DISCONNECT PENDING */
							if (!strncmp(lscc[nI].link.altname,"DIS",3)) {
								fputs(cBuf,hDisconnect);
							}			

							/* Check for ENABLED */
							if (!strcmp(lscc[nI].link.status,"ENABLED") \
								&& (strstr(lscc[nI].link.altname,"PRV-") \
								|| strstr(lscc[nI].link.altname,"PR-"))) {
							
								fputs(cBuf,hEnabled);
								
								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Enabled);
								}

							}
						} 
					}
					
					strcpy(cBuf,ltoa(nCount));
					strcat(cBuf,"\n");
					fputs(cBuf,hTmp);

					if (!lFound) {

						/* Write xl_hwlist.txt info */
						strcpy(cBuf,e4251acardcage.site);
						strcat(cBuf,"\t");
						strcat(cBuf,e4251acardcage.cardcage);
						strcat(cBuf,"\t");
						strcat(cBuf,ifpcs.slot);
						strcat(cBuf,"\t");
						strcat(cBuf,ifpcs.hostname);
						strcat(cBuf,"\t");
						strcat(cBuf,ifpcs.ip);
						strcat(cBuf,"\t");
						strcat(cBuf,ifpcs.status);
						strcat(cBuf,"\t");
						strcat(cBuf,"Not Built!");
						strcat(cBuf,"\t");
						strcat(cBuf,"0");
						strcat(cBuf,"\t");
						strcat(cBuf,"");
						strcat(cBuf,"\t");
						strcat(cBuf,"0-0-0");
						strcat(cBuf,"\t");
						strcat(cBuf,"0");
						strcat(cBuf,"\t");
						strcat(cBuf,"0-0-0");
						strcat(cBuf,"\n");

						fputs(cBuf,hHwlist);
					}
				}
			}		
		}
		
		/* Read [ifcards] line */
		if (!lMissing) {
			fgets(cBuf,sizeof(cBuf),hEtr);
			trim(&cBuf);
				
			if (strcmp(cBuf,"[ifcards]")) {
/*				printf("Missing [ifcards] line: |%s|\n",cBuf);
*/				lMissing = 1;
			}
		}

		if (strstr(cBuf,"###")) nEOF = 1;
		
		/* Read [ifcards] data line */
		if (!lMissing) {
			fgets(cBuf,sizeof(cBuf),hEtr);
			trim(&cBuf);

			strcpy(cTmpBuf,cBuf);
			strcpy(ifcards.slot,strtok(cTmpBuf," "));
			strcpy(ifcards.card_type,strtok(NULL," "));
			strcpy(ifcards.frame_type,strtok(NULL," "));
			strcpy(ifcards.standby_slot,strtok(NULL," "));
		}
/*		if (strlen(ifcards.slot) > 0) {
			printf("Slot: %s  Cardtype: %s  Frametype: %s  Slot2: %s\n",ifcards.slot,ifcards.card_type,ifcards.frame_type,ifcards.standby_slot);
		}		
*/

		/* Read blank line */
		if (!lMissing) {
			fgets(cBuf,sizeof(cBuf),hEtr);
		}

		if (strstr(cBuf,"###")) nEOF = 1;
		
		/* Read [concentratorunits] line */
		if (!lMissing) {
			fgets(cBuf,sizeof(cBuf),hEtr);
			trim(&cBuf);

			if (strcmp(cBuf,"[concentratorunits]")) {
/*				printf("Missing [concentratorunits] line: |%s|\n",cBuf);
*/				lMissing = 1;
			}
		}

		if (strstr(cBuf,"###")) nEOF = 1;
		
		if (!lMissing || !strcmp(cBuf,"[concentratorunits]")) {
			while (strlen(cBuf) > 1) {
				fgets(cBuf,sizeof(cBuf),hEtr);
				trim(&cBuf);

				if (strlen(cBuf) > 1) {
					strcpy(cTmpBuf,cBuf);
					strcpy(concentratorunits.slot,strtok(cTmpBuf," "));
					strcpy(concentratorunits.cu_number,strtok(NULL," "));
					strcpy(concentratorunits.cu_type,strtok(NULL," "));
/*					printf("Slot: %s  CU #%s  CU Type: %s\n",concentratorunits.slot,concentratorunits.cu_number,concentratorunits.cu_type);
*/				}	
			}		
		}
		
		/* Read [e4251acardcagealarms] line */
		if (!lMissing) {
			fgets(cBuf,sizeof(cBuf),hEtr);
			trim(&cBuf);

			if (strcmp(cBuf,"[e4251acardcagealarms]")) {
/*				printf("Missing [e4251acardcagealarms] line: |%s|\n",cBuf);
*/				lMissing = 1;
			}
		}

		if (strstr(cBuf,"###")) nEOF = 1;
		
		if (!lMissing || !strcmp(cBuf,"[e4251acardcagealarms]")) {
			while (strlen(cBuf) > 1) {
				fgets(cBuf,sizeof(cBuf),hEtr);
				trim(&cBuf);

				strcpy(cTmpBuf,cBuf);
				strcpy(e4251acardcagealarms.alarm_name,strtok(cTmpBuf," "));
				strcpy(e4251acardcagealarms.severity,strtok(NULL," "));
				strcpy(e4251acardcagealarms.enabled_level,strtok(NULL," "));

/*				if (strlen(e4251acardcagealarms.alarm_name) > 0) {
					printf("\tName: %s\tSeverity: %s\tLevel: %s\n",e4251acardcagealarms.alarm_name,e4251acardcagealarms.severity,e4251acardcagealarms.enabled_level);
				}
*/
			}		
	
		}
	}
	
	close(s);
	
	printf("\n\nFinding high-speed equipment...\n");

	/* Move to Probe Processor section */
	rewind(hEtr);

	nEOF = 0;
	while (!nEOF) {
		/* Find the next [probeprocessor] section. */
		while (strcmp(cBuf,"[probeprocessor]") && !nEOF) {
			if (fgets(cBuf,sizeof(cBuf),hEtr) == NULL) nEOF = 1;
			trim(&cBuf);
		}

		fgets(cBuf,sizeof(cBuf),hEtr);
		trim(&cBuf);

		strcpy(cTmpBuf,cBuf);
		strcpy(probeprocessor.site,strtok(cTmpBuf," "));
		strcpy(probeprocessor.pp_number,strtok(NULL," "));
		strcpy(probeprocessor.paired_pp_number,strtok(NULL," "));
		strcpy(probeprocessor.alarm_blackout,strtok(NULL," "));
		strcpy(probeprocessor.appset,strtok(NULL," "));

		if (strlen(probeprocessor.site) > 0 && probeprocessor.site[0] != 0x0a) {
			printf("\nSite: %s  PP: %s\n",probeprocessor.site,probeprocessor.pp_number);
		}
		
		/* Read blank line */
		fgets(cBuf,sizeof(cBuf),hEtr);

		/* Read [probeprocessoralarms] line */
		fgets(cBuf,sizeof(cBuf),hEtr);
		trim(&cBuf);

		lMissing = 0;
		if (strcmp(cBuf,"[probeprocessoralarms]")) {
/*			printf("Missing [probeprocessoralarms] line: |%s|\n",cBuf);
*/			lMissing = 1;
		}
		
		if (!lMissing) {
			while (strlen(cBuf) > 1) {
				fgets(cBuf,sizeof(cBuf),hEtr);
				trim(&cBuf);
			
				strcpy(cTmpBuf,cBuf);
				strcpy(probeprocessoralarms.alarm_name,strtok(cTmpBuf," "));
				strcpy(probeprocessoralarms.severity,strtok(NULL," "));
				strcpy(probeprocessoralarms.enabled_level,strtok(NULL," "));

/*				printf("\t%s\t%s\t%s\n",probeprocessoralarms.alarm_name,probeprocessoralarms.severity,probeprocessoralarms.enabled_level);
*/			}
		}	
		
		/* Read [hsics] line */
		if (!lMissing) {
			fgets(cBuf,sizeof(cBuf),hEtr);
			trim(&cBuf);

			if (strcmp(cBuf,"[hsics]")) {
/*				printf("Missing [hsics] line: |%s|\n",cBuf);
*/				lMissing = 1;
			}
		}
		
		if (!lMissing) {	
			while (strlen(cBuf) > 1) {
				fgets(cBuf,sizeof(cBuf),hEtr);
				trim(&cBuf);
			
				strcpy(cTmpBuf,cBuf);
				strcpy(hsics.hsic_number,strtok(cTmpBuf," "));
				strcpy(hsics.cc_number,strtok(NULL," "));
				strcpy(hsics.bearer_0_framing,strtok(NULL," "));
				strcpy(hsics.bearer_1_framing,strtok(NULL," "));
				strcpy(hsics.bearer_2_framing,strtok(NULL," "));
				strcpy(hsics.bearer_3_framing,strtok(NULL," "));

				if (strlen(hsics.hsic_number) > 0 && hsics.hsic_number[0] != 0x0a) {
					printf("\tSite: %s\tPP: %s\tCC: %s\tCIP: %s\n",probeprocessor.site,probeprocessor.pp_number,hsics.cc_number,hsics.hsic_number);

					for (nI = 0; nI < nHSLoc; nI++) {
						if (atoi(probeprocessor.site) == atoi(hscc[nI].hsli.site) \
							&& atoi(probeprocessor.pp_number) == atoi(hscc[nI].hsli.probeproc) \
							&& (atoi(hsics.hsic_number) == atoi(hscc[nI].hsli.chAhsic) \
							|| atoi(hsics.hsic_number) == atoi(hscc[nI].hsli.chBhsic))) {
							
							printf("\t\t%s \t%0d \t%s  \t%s <%s> %s\n",hscc[nI].link.status,atoi(hscc[nI].linknum),hscc[nI].link.altname,hscc[nI].ls.monsp,hscc[nI].link.slc,hscc[nI].ls.remsp);
							printf("\t\t\tChA HSIC: %s \tChA Bearer: %s\n\t\t\tChB HSIC: %s \tChB Bearer: %s\n",hscc[nI].hsli.chAhsic,hscc[nI].hsli.chAbearer,hscc[nI].hsli.chBhsic,hscc[nI].hsli.chBbearer);

							if (!strncmp(hscc[nI].link.altname,"DIS",3)) {
								printf("\tDISCONNECT PENDING!\n");
							} else {
								printf("\n");
							}

							strcpy(cBuf,hscc[nI].ls.monsp);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].ls.remsp);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].ls.linktype);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].ls.name);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].link.slc);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].link.name);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].link.altname);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].link.status);
							strcat(cBuf," ");
							strcat(cBuf,hscc[nI].linknum);
							strcat(cBuf,"\n\0");

							fputs(cBuf,hLinks);
							
							/* Write PCS links */
							if (!strncmp(hscc[nI].ls.remsp,"214-",4)) {
								fputs(cBuf,hPCS);
							}

							/* Write Sprint Internal links */
							if (!strncmp(hscc[nI].ls.remsp,"253-",4)) {
								fputs(cBuf,hInternal);
							}

							/* Check for DISABLED */
							if (!strcmp(hscc[nI].link.status,"DISABLED")) {
						
								fputs(cBuf,hDis);
								
								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Dis);
								}
							}
								
							/* Check for DISABLED NOT PRV */
							if (!strcmp(hscc[nI].link.status,"DISABLED") \
								&& !strstr(hscc[nI].link.altname,"PRV-") \
								&& !strstr(hscc[nI].link.altname,"PR-")) {

								fputs(cBuf,hDis_not_PRV);
								
								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Dis_not_PRV);
								}

							}
							
							/* Check for DISABLED PRV */
							if (!strcmp(hscc[nI].link.status,"DISABLED") \
								&& (strstr(hscc[nI].link.altname,"PRV-") \
								|| strstr(hscc[nI].link.altname,"PR-"))) {
							
								fputs(cBuf,hDis_PRV);

								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Dis_PRV);
								}

							}	

							/* Check for DOMESTIC DISABLED */
							if (!strcmp(hscc[nI].link.status,"DISABLED") \
								&& !strstr(hscc[nI].ls.monsp,"IN:")) {
							
								fputs(cBuf,hDom_Dis);
							}
							
							/* Check for DOMESTIC DISABLED NOT PRV */
							if (!strcmp(hscc[nI].link.status,"DISABLED") \
								&& !strstr(hscc[nI].link.altname,"PRV-") \
								&& !strstr(hscc[nI].link.altname,"PR-") \
								&& !strstr(hscc[nI].ls.monsp,"IN:")) {
								
								fputs(cBuf,hDom_Dis_not_PRV);
							}
							
							/* Check for DISCONNECT PENDING */
							if (!strncmp(hscc[nI].link.altname,"DIS",3)) {
								fputs(cBuf,hDisconnect);
							}			


							/* Check for ENABLED */
							if (!strcmp(hscc[nI].link.status,"ENABLED") \
								&& (strstr(hscc[nI].link.altname,"PRV-") \
								|| strstr(hscc[nI].link.altname,"PR-"))) {
							
								fputs(cBuf,hEnabled);
									
								/* Check for PCS */
								if (!strncmp(lscc[nI].ls.remsp,"214-",4)) {
									fputs(cBuf,hPCS_Enabled);
								}
							}
						}
					}
				}
			}
		}
	}
	
	fclose(hLinks);
	fclose(hDis);
	fclose(hDis_not_PRV);
	fclose(hDis_PRV);
	fclose(hDom_Dis);
	fclose(hDom_Dis_not_PRV);
	fclose(hEnabled);
	fclose(hInternal);
	fclose(hEtr);
	fclose(hHwlist);
	fclose(hDisconnect);
	fclose(hPCS);
	fclose(hPCS_Dis_PRV);
	fclose(hPCS_PRV);
	fclose(hPCS_Dis);
	fclose(hPCS_Enabled);
	fclose(hPCS_Dis_not_PRV);

        fclose(hTmp);
		
	printf("\nLow-speed Links: %0d \tHigh-speed Links: %0d\n",nLSLoc,nHSLoc);

	if (!strcmp(cHostname,"m7server")) {
		printf("\nDistributing files...\n");
	
		cpfile("/home/a7users/ss7gjobi/var/disabled_links/*.txt","/home/filexfer/links/");
		cpfile("/home/a7users/ss7gjobi/var/etr/etrfile.etr","/home/filexfer/etr/etrfile.etr");
		cpfile("/home/a7users/ss7gjobi/var/hwlist/*.txt","/home/filexfer/hwlist/");
		
		strcpy(cBuf,"chown filexfer:users /home/filexfer/*");
		system(cBuf);
		
		strcpy(cBuf,"chmod 755 /home/filexfer/*");
		system(cBuf);
	}
	
	printf("\nDone.\n\n");
	
	return 0;	
}

int cpfile(cSrc,cDest)
char cSrc[50];
char cDest[50];
{
	char cBuf[128];
	
	strcpy(cBuf,"cp ");
	strcat(cBuf,cSrc);
	strcat(cBuf," ");
	strcat(cBuf,cDest);
	system(cBuf);
	
	return 0;
}
