#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <utmp.h>

struct sp {
	char name[25];
	char altname[25];
	char pointcode[25];
	char type[20];
	char capcode[25];
	char site[10];
	char flag[25];
	char class[10];
};

struct linkset {
	char monsp[25];
	char remsp[25];
	char linktype[2];
	char norm[10];
	char name[25];
	char remclli[25];
};

struct newlink {
	char clli[25];
	char sptype[5];
	char opc[15];
	char dpc[15];
	int linkset;
	char slc;
	int linknum;
	char linktype[5];
	char site[5];
	char cardcage;
	char ifslot;
	char cu;
	char input;
	char ifpc;
};

struct link {
	char slc[3];
	char link_protocol[15];
	char personality[15];
	char name[25];
	char altname[25];
	char chanA_characteristic[25];
	char chanA_pcr[15];
	char chanA_subrate_num[5];
	char chanA_vpi[5];
	char chanA_vci[5];
	char chanA_unscramble[5];
	char chanA_hec[5];
	char chanB_characteristic[25];
	char chanB_pcr[15];
	char chanB_subrate_num[5];
	char chanB_vpi[5];
	char chanB_vci[5];
	char chanB_unscramble[5];
	char chanB_hec[5];
	char linktype[5];
	char mon_sys[10];
	char status[25];
	char link_num[10];	
};

struct directlinkinterface {
	char site;
	char cardcage;
	char chAslot;
	char chAbearer;
	char chAtimeslot;
	char chBslot;
	char chBbearer;
	char chBtimeslot;
	char linktype;
};

struct v35culinkinterface {
	char site[4];
	char cardcage[4];
	char ifslot[4];
	char concentrator[4];
	char cuconnector[4];
};

struct ds0culinkinterface {
	char site;
	char cardcage;
	char chAslot;
	char chAcu;
	char chAbearer;
	char chBslot;
	char chBcu;
	char chBbearer;
	char linktype;
};

struct hsiclinkinterface {
	char site[4];
	char probeproc[4];
	char chAhsic[4];
	char chAbearer[4];
	char chBhsic[4];
	char chBbearer[4];
	char linktype[5];
};

struct ifpclinkmonitoring {
	char application[10];
	char ifpcslot[4];
	char linktype[5];
};

struct probeproclinkmonitoring {
	char application[10];
	char linktype[5];
};

struct linkcapturing {
	char slot;
	char linktype;
};

struct e4251acardcage {
	char site[4];
	char cardcage[4];
	char location[25];
	char reset_period[4];
	char master_clock[25];
	char backup_clock[25];
	char severity[25];
	char clearance_period[25];
};

struct ifpcs {
	char slot[4];
	char mac[13];
	char hostname[25];
	char ip[16];
	char appset[25];
	char status[25];
};

struct ifcards {
	char slot[4];
	char card_type[13];
	char frame_type[25];
	char standby_slot[4];
};

struct e4251acardcagealarms {
	char alarm_name[25];
	char severity[25];
	char enabled_level[25];
};

struct concentratorunits {
	char slot[4];
	char cu_number[4];
	char cu_type[25];
};

struct probeprocessoralarms {
	char alarm_name[25];
	char severity[25];
	char enabled_level[25];
};

struct hsics {
	char hsic_number[4];
	char cc_number[4];
	char bearer_0_framing[25];
	char bearer_1_framing[25];
	char bearer_2_framing[25];
	char bearer_3_framing[25];
};

struct probeprocessor {
	char site[4];
	char pp_number[4];
	char paired_pp_number[4];
	char alarm_blackout[4];
	char appset[25];
};

struct userdata {
	char name[25];
	char type[15];
	char area_group[15];
	char language[3];
	char time_locale[3];
	char collating_sequence_locale[3];
	char numeric_format_locale[3];
	char default_NAM_table[15];
	char default_PC_format[15];
	char default_link_format[15];
};

struct facilities {
	char application[10];
	char flags[75];
};

struct passd {
	char username[25];
	char password[25];
	char uid[10];
	char gid[10];
	char comments[128];
	char homedir[128];
	char shell[128];
};

int uselog (cApp,cArgs)
char cApp[25];
char cArgs[1024];
{
	char cBuf[256], cHostname[25], cFilename[50], nBytes;
	time_t timer;
	FILE *hLog;
	
	struct passwd pwd;
	
	timer = time(NULL);
	pwd = *getpwuid(getuid());
	gethostname(cHostname,sizeof(cHostname));
	strcpy(cBuf,pwd.pw_name);
	strcat(cBuf,"\t");
	strcat(cBuf,cHostname);
	strcat(cBuf,"\t");
	strcat(cBuf,asctime(localtime(&timer)));
	cBuf[strlen(cBuf) - 1] = 0;
	if (strlen(cArgs) > 0) {
		strcat(cBuf,"\tArgs: ");
		strcat(cBuf,cArgs);
	} 
	strcat(cBuf,"\n");
	
	strcpy(cFilename,"/home/a7users/ss7gjobi/var/logs/");
	strcat(cFilename,cApp);
	strcat(cFilename,".log");
	
	hLog = fopen(cFilename,"a+");
	nBytes = fputs(cBuf,hLog);
	fclose(hLog);
	
	if (nBytes == strlen(cBuf)) {
		return 0;
	} else {
		return 1;
	}
}

char *readline(hFile)
	int *hFile;
{
	int nI, nBytes;
	char c[2], cBuf[1024];
	
/*	for (nI = 0; nI < sizeof(cBuf); nI++) cBuf[nI] = 0;
*/		
	nI = 0;
	c[0] = 0;
	c[1] = 0;
	nBytes = 1;
	while (nBytes > 0 && c[0] != 10 && nI < sizeof(cBuf)) {
		nBytes = read(*hFile,c,1);
		
		if (c[0] != 10 && nBytes > 0) {
			cBuf[nI++] = c[0];
		} else if (c[0] == 10 && nI == 0) {
			cBuf[nI++] = 10;
		} 		
	}

	cBuf[nI] = 0;
	return cBuf;
}

void trim(cBuf)
char *cBuf;
{
	int nI;
	
	nI = strlen(cBuf) - 1; 
		
	while (nI > 0 && (!isalnum(cBuf[nI]))) nI--;
	
	if (nI > 0 && nI < strlen(cBuf) - 1) cBuf[nI + 2] = 0;
	
	return;
}

int getlink(hFile,link)
	FILE *hFile;
	struct link *link;
{
	char cBuf[256], cETRBuf[256], cETRBuf2[256];
	int nI;
	
	/* Read [link] lines */
/*	fgets(cETRBuf,sizeof(cETRBuf),hFile);
*/
	fgets(cETRBuf,sizeof(cETRBuf),hFile);
	trim(&cETRBuf);

	fgets(cETRBuf2,sizeof(cETRBuf),hFile);
	trim(&cETRBuf2);

	strcat(cETRBuf,cETRBuf2);
	
	strcpy(cBuf,strtok(cETRBuf,"\\\n"));
	strcpy(cETRBuf2,strtok(NULL,"\n"));
	
	for (nI = 0; nI < strlen(cETRBuf2); nI++) cETRBuf2[nI] = cETRBuf2[nI+2];
	cETRBuf2[nI-2] = 0;
	
	strcat(cBuf,cETRBuf2);
	strcpy(cETRBuf,cBuf);
	
	/* Parse [link] lines */
	strcpy((*link).slc,strtok(cETRBuf," "));
	strcpy((*link).link_protocol,strtok(NULL," "));
	strcpy((*link).personality,strtok(NULL," "));
	strcpy((*link).name,strtok(NULL," "));
	strcpy((*link).altname,strtok(NULL," "));
	strcpy((*link).chanA_characteristic,strtok(NULL," "));
	strcpy((*link).chanA_pcr,strtok(NULL," "));
	strcpy((*link).chanA_subrate_num,strtok(NULL," "));
	strcpy((*link).chanA_vpi,strtok(NULL," "));
	strcpy((*link).chanA_vci,strtok(NULL," "));
	strcpy((*link).chanA_unscramble,strtok(NULL," "));
	strcpy((*link).chanA_hec,strtok(NULL," "));
	strcpy((*link).chanB_characteristic,strtok(NULL," "));
	strcpy((*link).chanB_pcr,strtok(NULL," "));
	strcpy((*link).chanB_subrate_num,strtok(NULL," "));
	strcpy((*link).chanB_vpi,strtok(NULL," "));
	strcpy((*link).chanB_vci,strtok(NULL," "));
	strcpy((*link).chanB_unscramble,strtok(NULL," "));
	strcpy((*link).chanB_hec,strtok(NULL," "));
	strcpy((*link).linktype,strtok(NULL," "));
	strcpy((*link).mon_sys,strtok(NULL," "));
	strcpy((*link).status,strtok(NULL," "));

	/* Remove quotes */
	for (nI = 0; nI < strlen((*link).altname); nI++) (*link).altname[nI] = (*link).altname[nI+1];
	(*link).altname[nI-2] = 0;

	return 0;
}

int get_probeprocessor(hFile,probeprocessor)
FILE *hFile;
struct probeprocessor *probeprocessor;
{
	char cBuf[256], cTmpBuf[256];
	int nI;

	fgets(cBuf,sizeof(cBuf),hFile);
	trim(&cBuf);
	
	strcpy(cTmpBuf,cBuf);

	strcpy((*probeprocessor).site,strtok(cTmpBuf," "));
	strcpy((*probeprocessor).pp_number,strtok(NULL," "));
	strcpy((*probeprocessor).paired_pp_number,strtok(NULL," "));
	strcpy((*probeprocessor).alarm_blackout,strtok(NULL," "));
	strcpy((*probeprocessor).appset,strtok(NULL," "));

	return 0;
}

int get_e4251acardcage(hFile,e4251acardcage)
FILE *hFile;
struct e4251acardcage *e4251acardcage;
{
	char cBuf[256], cTmpBuf[256];
	int nI;

	fgets(cBuf,sizeof(cBuf),hFile);
	trim(&cBuf);
	
	strcpy(cTmpBuf,cBuf);

	strcpy((*e4251acardcage).site,strtok(cTmpBuf," "));
	strcpy((*e4251acardcage).cardcage,strtok(NULL,"\""));
	strcpy((*e4251acardcage).location,strtok(NULL,"\""));
	strcpy((*e4251acardcage).reset_period,strtok(NULL," "));
	strcpy((*e4251acardcage).master_clock,strtok(NULL," "));
	strcpy((*e4251acardcage).backup_clock,strtok(NULL," "));
	strcpy((*e4251acardcage).severity,strtok(NULL," "));
	strcpy((*e4251acardcage).clearance_period,strtok(NULL," "));

	return 0;
}

int getlinkset(hFile,linkset)
FILE *hFile;
struct linkset *linkset;
{
	char cBuf[256];
	int nI;
	
	fgets(cBuf,sizeof(cBuf),hFile);
	trim(&cBuf);
	
	strcpy((*linkset).monsp,strtok(cBuf," "));
	strcpy((*linkset).remsp,strtok(NULL," "));
	strcpy((*linkset).linktype,strtok(NULL," "));
	strcpy((*linkset).norm,strtok(NULL," "));
	strcpy((*linkset).name,strtok(NULL," "));

	return 0;
}

int getv35if(hFile,v35if)
FILE *hFile;
struct v35culinkinterface *v35if;
{
	char cBuf[256];
	int nI;
	
	fgets(cBuf,sizeof(cBuf),hFile);
	trim(&cBuf);

	strcpy((*v35if).site,strtok(cBuf," "));
	strcpy((*v35if).cardcage,strtok(NULL," "));
	strcpy((*v35if).ifslot,strtok(NULL," "));
	strcpy((*v35if).concentrator,strtok(NULL," "));
	strcpy((*v35if).cuconnector,strtok(NULL," "));

	return 0;
}

int gethsicif(hFile,hsicif)
FILE *hFile;
struct hsiclinkinterface *hsicif;
{
	char cBuf[256];
	int nI, hEtr;
	
	fgets(cBuf,sizeof(cBuf),hFile);
	trim(&cBuf);
	
	strcpy((*hsicif).site,strtok(cBuf," "));
	strcpy((*hsicif).probeproc,strtok(NULL," "));
	strcpy((*hsicif).chAhsic,strtok(NULL," "));
	strcpy((*hsicif).chAbearer,strtok(NULL," "));
	strcpy((*hsicif).chBhsic,strtok(NULL," "));
	strcpy((*hsicif).chBbearer,strtok(NULL," "));
	strcpy((*hsicif).linktype,strtok(NULL," "));

	return 0;
}
