/*
    Linktool
    
    8-8-02 by Jon Bieker
    (c)2002 Sprint

*/

/* Includes */
#include <libpq-fe.h>

/* Include some X11 stuff */
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/ComboBox.h>
#include <Xm/Text.h>

/* Defines */
#define MAX_SITES	5000

/* Structs */
struct site_struct {
  char name[20];
};

struct enabled_struct {
  char option[10];
};

/* Globals variables */
PGconn *etr;
PGresult *result, *site;
Widget toplevel, main_win, form;
Widget menu_bar, file_menu, help_menu;
Widget cbSites, tbLinkNumber, tbAltName, cbEnabled;
Widget lblSite, lblLinkNumber, lblAltName, lblEnabled;
Widget btnLookup, btnAddChange, btnCommit;

main (int argc, char *argv[])
{

  long n;
  struct site_struct sites[MAX_SITES];
  struct enabled_struct enabled[3];
  char command[1024];

  XmString quit_string,file_string,save_string,help_string,about_string,lookup_string,addchange_string,commit_string;
  XmStringTable site_list, enabled_list;
  XtAppContext app; 
  Arg	args[10];

  /* Function decl's */
  void help_call();
  void save_call();
  void quit_call();
  void file_call();
  void lookup_call();
  void addchange_call();
  void commit_call();
  void help_about_popup();

  /* Connect to database */
  etr = PQconnectdb("hostaddr=172.20.206.55 dbname=etr user=postgres password=pgauthall");

  if (PQstatus(etr)) {
    printf("couldn't connect!\n");
  }

  result = PQexec(etr,"select distinct signalingpoints.name from signalingpoints inner join links on links.opc=signalingpoints.point_code order by signalingpoints.name;");

  site_list = (XmStringTable) XtMalloc (PQntuples(result) * sizeof (XmString));
    
  for (n = 0; n < PQntuples(result); n++) {
  
    strcpy(sites[n].name,PQgetvalue(result,n,0));
    site_list[n] = XmStringCreateLocalized (PQgetvalue(result,n,0));    
    
  }
  
  XtSetLanguageProc (NULL, NULL, NULL);
  toplevel = XtVaOpenApplication (&app, "Linktool", NULL, 0, &argc, argv, 
  	NULL, sessionShellWidgetClass, NULL);

  main_win = XtVaCreateManagedWidget("main_window",xmMainWindowWidgetClass,
  	toplevel,XmNfractionBase,3,XmNwidth,640,XmNheight,260,NULL);

  /* Create form */
  form = XmCreateForm (main_win,"form",NULL,0);
  XtManageChild (form);

  /* Create controls */
  n = 0;
  XtSetArg (args[n],XmNitems,site_list); n++;
  XtSetArg (args[n],XmNitemCount,PQntuples(result)); n++;
  cbSites = XmCreateDropDownList (form,"cbSites",args,n);

  enabled_list = (XmStringTable) XtMalloc (2 * sizeof (XmString));
  enabled_list[0] = XmStringCreateLocalized ("Disabled");
  enabled_list[1] = XmStringCreateLocalized ("Enabled");
  n = 0;
  XtSetArg (args[n],XmNitems,enabled_list); n++;
  XtSetArg (args[n],XmNitemCount,2); n++;
  cbEnabled = XmCreateDropDownList (form,"cbEnabled",args,n);
  
  tbLinkNumber = XmCreateText(form,"tbLinkNumber",args,0);
  tbAltName = XmCreateText(form,"tbAltName",args,0);
  lblSite = (Widget) XmCreateLabel(form,"Site",NULL,NULL);
  lblAltName = (Widget) XmCreateLabel(form,"Alt-Name",NULL,NULL);
  lblLinkNumber = (Widget) XmCreateLabel(form,"Link Number",NULL,NULL);
  lblEnabled = (Widget) XmCreateLabel(form,"Enabled",NULL,NULL);

  quit_string = XmStringCreateSimple("Quit");
  file_string = XmStringCreateSimple("File");
  save_string = XmStringCreateSimple("Save");
  help_string = XmStringCreateSimple("Help");
  about_string = XmStringCreateSimple("About");
  lookup_string = XmStringCreateLocalized("Get Link Info.");
  addchange_string = XmStringCreateLocalized("Add to Change List");
  commit_string = XmStringCreateLocalized("Commit to AcceSS7");
  
  XtSetArg (args[0],XmNlabelString,lookup_string);
  btnLookup = XmCreatePushButton(form,"btnLookup",args,1);
  XtAddCallback (btnLookup, XmNactivateCallback, lookup_call, NULL);

  XtSetArg (args[0],XmNlabelString,addchange_string);
  btnAddChange = XmCreatePushButton(form,"btnAddChange",args,1);
  XtAddCallback (btnAddChange, XmNactivateCallback, addchange_call, NULL);
  
  XtSetArg (args[0],XmNlabelString,commit_string);
  btnCommit = XmCreatePushButton(form,"btnCommit",args,1);
  XtAddCallback (btnCommit, XmNactivateCallback, commit_call, NULL);
  
  menu_bar = XmVaCreateSimpleMenuBar(main_win,"main_list",
  	XmVaCASCADEBUTTON, file_string, 'F',
  	XmVaCASCADEBUTTON, help_string, 'H',
  	NULL,0);
  
  file_menu = XmVaCreateSimplePulldownMenu(menu_bar,"file_menu",0,file_call,
  	XmVaPUSHBUTTON,save_string,'S',NULL,NULL,
  	XmVaPUSHBUTTON,quit_string,'Q',NULL,NULL,
  	NULL);

  help_menu = XmVaCreateSimplePulldownMenu(menu_bar,"help_menu",1,help_call,
  	XmVaPUSHBUTTON,about_string,'A',NULL,NULL,
  	NULL);

  XmStringFree(quit_string);
  XmStringFree(file_string);
  XmStringFree(save_string);
  XmStringFree(help_string);
  XmStringFree(lookup_string);
  XmStringFree(addchange_string);
  XmStringFree(commit_string);
  for (n = 0; n < PQntuples(result); n++) {
    XmStringFree(site_list[n]);
  }
  XtFree ((XtPointer) site_list);

  /* Layout controls */
  XtVaSetValues(menu_bar,
    XmNtopAttachment,XmATTACH_FORM,
    XmNleftAttachment,XmATTACH_FORM,
    XmNrightAttachment,XmATTACH_FORM,
    NULL);
  XtVaSetValues(lblSite,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,menu_bar,XmNtopOffset,10,
    XmNleftAttachment,XmATTACH_FORM,XmNleftOffset,10,
    NULL);
  XtVaSetValues(cbSites,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,lblSite,
    XmNleftAttachment,XmATTACH_FORM,XmNleftOffset,10,
    NULL);
  XtVaSetValues(lblLinkNumber,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,menu_bar,XmNtopOffset,11,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,cbSites,XmNleftOffset,20,
    NULL);
  XtVaSetValues(tbLinkNumber,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,lblLinkNumber,
    XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,XmNbottomWidget,cbSites,XmNbottomOffset,0,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,cbSites,XmNleftOffset,20,
    NULL);
  XtVaSetValues(btnLookup,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,lblLinkNumber,
    XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,XmNbottomWidget,tbLinkNumber,XmNbottomOffset,0,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,tbLinkNumber,XmNleftOffset,20,
    XmNrightAttachment,XmATTACH_FORM,XmNrightOffset,10,
    NULL);
  XtVaSetValues(lblEnabled,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,cbSites,XmNtopOffset,10,
    XmNleftAttachment,XmATTACH_FORM,XmNleftOffset,10,
    NULL);
  XtVaSetValues(cbEnabled,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,lblEnabled,
    XmNleftAttachment,XmATTACH_FORM,XmNleftOffset,10,
    XmNleftAttachment,XmATTACH_FORM,
    NULL);
  XtVaSetValues(lblAltName,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,tbLinkNumber,XmNtopOffset,11,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,cbEnabled,XmNleftOffset,20,
    NULL);
  XtVaSetValues(tbAltName,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,lblEnabled,
    XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,XmNbottomWidget,cbEnabled,XmNbottomOffset,0,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,cbEnabled,XmNleftOffset,20,
    NULL);
  XtVaSetValues(btnAddChange,
    XmNtopAttachment,XmATTACH_WIDGET,XmNtopWidget,lblAltName,
    XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,XmNbottomWidget,tbAltName,XmNbottomOffset,0,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,tbAltName,XmNleftOffset,20,
    XmNrightAttachment,XmATTACH_FORM,XmNrightOffset,10,
    NULL);
  XtVaSetValues(btnCommit,
    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,XmNtopWidget,tbAltName,XmNtopOffset,50,
    XmNbottomAttachment,XmATTACH_FORM,XmNbottomOffset,10,
    XmNleftAttachment,XmATTACH_WIDGET,XmNleftWidget,tbAltName,XmNleftOffset,20,
    XmNrightAttachment,XmATTACH_FORM,XmNrightOffset,10,
    NULL);

  /* Manage widgets */
  XtManageChild (menu_bar);
  XtManageChild (tbLinkNumber);
  XtManageChild (tbAltName);
  XtManageChild (cbSites);
  XtManageChild (cbEnabled);
  XtManageChild (lblSite);
  XtManageChild (lblEnabled);
  XtManageChild (lblAltName);
  XtManageChild (lblLinkNumber);
  XtManageChild (btnLookup);
  XtManageChild (btnAddChange);
  XtManageChild (btnCommit);
          
  /* Realize widgets */
  XtRealizeWidget (toplevel);

  /* Start the message loop */
  XtAppMainLoop (app);

}

void file_call (w, item) 
Widget w;
int item;
{
 
  switch (item) {
    case 0:
      printf("Saving...\n");
      break;
    case 1:
      PQclear(result);
      PQfinish(etr);

      exit(0);
      break;
    default:
      break; 
  }
}

void commit_call (w, item) 
Widget w;
int item;
{
  extern Widget toplevel;
  Widget dialog;
  Arg arg[5];
  XmString about_message;
  int n = 0;
  
  switch (item) {
    case 0:

      about_message = XmStringCreateLocalized("About Linktool\n\nFor support, call: 913-534-2475\n\n8-8-02 by Jon Bieker\n(c)2002 Sprint - All Rights Reserved");
      XtSetArg (arg[n],XmNmessageString,about_message); n++;
      dialog = XmCreateMessageDialog(toplevel,"About",arg,1);
      XmStringFree (about_message);
      XtUnmanageChild (XtNameToWidget (dialog, "Help"));
      XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
      
      XtManageChild(dialog);

      break;
    default:
      break; 
  }
}

void addchange_call (w, item) 
Widget w;
int item;
{
  extern Widget toplevel;
  Widget dialog;
  Arg arg[5];
  XmString about_message;
  int n = 0;
  
  switch (item) {
    case 0:

      about_message = XmStringCreateLocalized("About Linktool\n\nFor support, call: 913-534-2475\n\n8-8-02 by Jon Bieker\n(c)2002 Sprint - All Rights Reserved");
      XtSetArg (arg[n],XmNmessageString,about_message); n++;
      dialog = XmCreateMessageDialog(toplevel,"About",arg,1);
      XmStringFree (about_message);
      XtUnmanageChild (XtNameToWidget (dialog, "Help"));
      XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
      
      XtManageChild(dialog);

      break;
    default:
      break; 
  }
}

void lookup_call (Widget w, XtPointer client_data, XtPointer call_data) 
{
  extern Widget cbSites;
  extern Widget tbLinkNumber;

  PGresult *link_info;
  char command[1024];
  char site_number[5];
  
  XmComboBoxCallbackStruct *cb = (XmComboBoxCallbackStruct *) call_data;

  char *site_char = (char *) XmStringUnparse (cb->item_or_text,
                                         XmFONTLIST_DEFAULT_TAG,
                                         XmCHARSET_TEXT,
                                         XmCHARSET_TEXT,
                                         NULL, 0, XmOUTPUT_ALL);


printf("Site: %s\n",site_char);


  char *link_number = (char *) XmTextGetString(tbLinkNumber);

printf("Link Number: %s\n",link_number);

  XtFree(link_number);
  XtFree(site_char);
    
/*    
  strcpy(command,"select a7_status,linkset_name from links where link_number='");
  strcat(command,link_number);
  strcat(command,"';");

  printf("Site: %s\nCommand: %s\n",site,command);
  
  link_info = PQexec(etr,command);

  printf("Tuples: %0d\n",PQntuples(link_info));
  
  XtFree(link_number);
  XmStringFree(site);
  PQclear(link_info);
*/  
}

void help_call (w, item) 
Widget w;
int item;
{
  extern Widget toplevel;
  Widget dialog;
  Arg arg[5];
  XmString about_message;
  int n = 0;
  
  switch (item) {
    case 0:

      about_message = XmStringCreateLocalized("About Linktool\n\nFor support, call: 913-534-2475\n\n8-8-02 by Jon Bieker\n(c)2002 Sprint - All Rights Reserved");
      XtSetArg (arg[n],XmNmessageString,about_message); n++;
      dialog = XmCreateMessageDialog(toplevel,"About",arg,1);
      XmStringFree (about_message);
      XtUnmanageChild (XtNameToWidget (dialog, "Help"));
      XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
      
      XtManageChild(dialog);

      break;
    default:
      break; 
  }
}
