/*
	lock_utils.c
	11-12-01 by Jon A. Bieker
	(c)2001 Sprint
*/

#include "../include/include.h"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

char cHostname[MAXHOSTNAMELEN];
struct stat stat_p;

int main(argc,argv)
int argc;
char *argv[];
{
	/* Declare Variables */
	int nI, nJ;
	char lNC, lSA, lLock;
	char cOptions[10],cBuf[256];
	
	strcpy(cBuf,"");
	for (nI = 1; nI < argc; nI++) {
		strcat(cBuf,argv[nI]);
		strcat(cBuf," ");
	}
	uselog(argv[0],cBuf);
	
	/* Print Blurb */
	printf("\nlock_utils\n");
	printf("11-12-01 by Jon A. Bieker\n");
	printf("(c)2001 Sprint\n\n");
	
	/* Initialize flags & variables */
	lNC = lSA = lLock = 0;
	memcpy(cOptions,0,sizeof(cOptions));
	
	if (argc < 2) show_usage();
	
	/* Get hostname of current machine */
	gethostname(cHostname,sizeof(cHostname));
		
	/* Process arguments & set flags */
	for (nI = 1; nI < argc; nI++) {
		if (!strncmp(argv[nI],"-",1)) {
			if (strlen(argv[nI]) < sizeof(cOptions)) {
				strcpy(cOptions,argv[nI]);
			} else {
				show_usage();
			}
			
			for (nJ = 1; nJ < strlen(cOptions); nJ++) {				
				switch (cOptions[nJ]) {
					case 104:
						show_usage();
						break;
					case 108:		/* Lock */
						lLock = 1;
						break;
					case 117:		/* Unlock */
						lLock = 2;
						break;
					case 110:		/* Network Config */
						switch (lLock) {
							case 1:
								lNC = 1;
								break;
							case 2:
								lNC = 2;
								break;
						}
						break;					
					case 115:		/* System Admin */
						switch (lLock) {
							case 1:
								lSA = 1;
								break;
							case 2:
								lSA = 2;
								break;
						}
						break;
				}
			}
		}
	}

	switch (lNC) {
		case 1:
			lock_nc();
			break;
		case 2:
			unlock_nc();
			break;
	}	
	
	switch (lSA) {
		case 1:
			lock_sa();
			break;
		case 2:
			unlock_sa();
			break;
	}
	
	return 0;
}

int show_usage() {
	printf("\tUsage\n\t-----\n");
	printf("\t-h\tHelp. Show this screen.\n");
	printf("\t-l\tLock\n");
	printf("\t-u\tUnlock\n");
	printf("\t-n\tNetwork Config\n");
	printf("\t-s\tSystem Admin\n\n");
	printf("\tExamples\n\t--------\n");
	printf("\tTo lock Network Config:\tlock_utils -ln\n");
	printf("\tTo unlock System Admin:\tlock_utils -us\n");
	printf("\tTo lock both utilities:\tlock_utils -lns\n\n");
	printf("\tNotes\n\t-----\n");
	printf("\tLocking the utilities places a link in /var/opt/platform7/tmp to\n");
	printf("\ta file called 'acceSS7_9135342475'.  Users attempting to access\n");
	printf("\tone of the applications will be given the message that the file is\n");
	printf("\tlocked by 'acceSS7_9135342475'.\n\n");
	printf("\tUnlocking the utilities simply removes this link.\n\n");
	printf("\tOptions are processed in left-to-right order, therefore, the\n");
	printf("\tcommand 'lock_utils -lnus' would lock Network Config and unlock\n");
	printf("\tSystem Admin.  'lock_utils -lnun' would *unlock* Network Config.\n\n");
	printf("\tYou must have 'rwx' access to /var/opt/platform7/tmp.  If you don't,\n");
	printf("\tthe operation will fail!.\n\n");
	
	exit(0);
}

int lock_nc() {	
	if (!strcmp(cHostname,"m7server")) {
		if (!lstat("/var/opt/platform7/tmp/cf07_C13.tlf",&stat_p)) {
			printf("Network Config is already locked!\n");
			return;
		}
		
		system("touch /var/opt/platform7/tmp/acceSS7_9135342475");
		system("ln -s /var/opt/platform7/tmp/acceSS7_9135342475 /var/opt/platform7/tmp/uf07_C13.tlf");
		
		if (!lstat("/var/opt/platform7/tmp/cf07_C13.tlf",&stat_p)) {
			printf("Network Config could not be locked!\n");
			perror(errno);
		} else {
			printf("Network Config has been locked.\n");
		}

	} else {
		if (!lstat("/net/m7server/var/opt/platform7/tmp/cf07_C13.tlf",&stat_p)) {
			printf("Network Config is already locked!\n");
			return;
		}
		
		system("touch /net/m7server/var/opt/platform7/tmp/acceSS7_9135342475");
		system("ln -s /net/m7server/var/opt/platform7/tmp/acceSS7_9135342475 /net/m7server/var/opt/platform7/tmp/uf07_C13.tlf");
		
		if (!lstat("/net/m7server/var/opt/platform7/tmp/cf07_C13.tlf",&stat_p)) {
			printf("Network Config could not be locked!\n");
			perror(errno);
			exit(1);
		} else {
			printf("Network Config has been locked.\n");
		}

	}
	
	return 0;	
}

int unlock_nc() {
	if (!strcmp(cHostname,"m7server")) {
		system("rm -f /var/opt/platform7/tmp/uf07_C13.tlf");
		system("rm -f /var/opt/platform7/tmp/acceSS7_9135342475");

		if (lstat("/var/opt/platform7/tmp/cf07_C13.tlf",&stat_p)) {
			printf("Network Config has been unlocked!\n");
		} else {
			printf("Network Config could not be unlocked.\n");
		}

	} else {
		system("rm -f /net/m7server/var/opt/platform7/tmp/uf07_C13.tlf");
		system("rm -f /net/m7server/var/opt/platform7/tmp/acceSS7_9135342475");	
		
		if (lstat("/net/m7server/var/opt/platform7/tmp/cf07_C13.tlf",&stat_p)) {
			printf("Network Config has been unlocked!\n");
		} else {
			printf("Network Config could not be unlocked.\n");
		}

	}
	return 0;
}

int lock_sa() {
	if (!strcmp(cHostname,"m7server")) {
		if (!lstat("/var/opt/platform7/tmp/cf07_C14.tlf",&stat_p)) {
			printf("System Admin is already locked!\n");
			return;
		}

		system("touch /var/opt/platform7/tmp/acceSS7_9135342475");
		system("ln -s /var/opt/platform7/tmp/acceSS7_9135342475 /net/m7server/var/opt/platform7/tmp/uf07_C14.tlf");
		
		if (!lstat("/var/opt/platform7/tmp/cf07_C14.tlf",&stat_p)) {
			printf("System Admin could not be locked!\n");
			perror(errno);
		} else {
			printf("System Admin has been locked.\n");
		}		

	} else {
		if (!lstat("/net/m7server/var/opt/platform7/tmp/cf07_C14.tlf",&stat_p)) {
			printf("System Admin is already locked!\n");
			return;
		}

		system("touch /net/m7server/var/opt/platform7/tmp/acceSS7_9135342475");
		system("ln -s /net/m7server/var/opt/platform7/tmp/acceSS7_9135342475 /net/m7server/var/opt/platform7/tmp/uf07_C14.tlf");	

		if (!lstat("/net/m7server/var/opt/platform7/tmp/cf07_C14.tlf",&stat_p)) {
			printf("System Admin could not be locked!\n");
			perror(errno);
		} else {
			printf("System Admin has been locked.\n");
		}		
	}
	
	return 0;	
}

int unlock_sa() {
	if (!strcmp(cHostname,"m7server")) {
		system("rm -f /var/opt/platform7/tmp/uf07_C14.tlf");
		system("rm -f /var/opt/platform7/tmp/acceSS7_9135342475");
		
		if (lstat("/var/opt/platform7/tmp/cf07_C14.tlf",&stat_p)) {
			printf("System Admin has been unlocked!\n");
		} else {
			printf("System Admin could not be unlocked.\n");
		}
	} else {
		system("rm -f /net/m7server/var/opt/platform7/tmp/uf07_C14.tlf");
		system("rm -f /net/m7server/var/opt/platform7/tmp/acceSS7_9135342475");	
		
		if (lstat("/net/m7server/var/opt/platform7/tmp/cf07_C14.tlf",&stat_p)) {
			printf("System Admin has been unlocked!\n");
		} else {
			printf("System Admin could not be unlocked.\n");
		}

	}

	return 0;
}
