#!/opt/perl5/bin/perl

# p7uc.pl
# 7-31-01 by Jon A. Bieker

use IO::Socket;

# Clean up before exiting on errors
sub err_finis {
	close($sock);
	system(("rm","-f","/var/tmp/p7uc.lck"));
	exit(1);
}

#system(("clear"));
print "\np7updatecomms Wrapper Script\n";
print "7-31-01 by Jon A Bieker\n\n";

# Check for another copy of p7uc.pl already running.  If one exists, exit immediately.
if (-f "/var/tmp/p7uc.lck") {
	print "p7uc.pl is already running!  Exiting.\n";
	err_finis;
} else {
	system(("touch","/var/tmp/p7uc.lck"));
}

# Setup port 2345 in /etc/services and /etc/inetd.conf
$port = "p7uc";			# Finds port in /etc/services
#$port = 2345;			# Hardcoded (do not use)
$remote = "localhost";

# Check username
$user = `whoami`;
chop $user;

if ($user ne "root") {
	print "You must be logged in as \"root\" to use this script!  Exiting.\n";
	err_finis;
}

# Get the number of args.
$ARGC = @ARGV;

# Check for the correct number of args.
if ($ARGC < 2 || $ARGC > 2 
   || (@ARGV[0] ne "-l" && @ARGV[0] ne "-d")) {
	
	print "Usage:\tp7uc.pl [ -l | -d ] <filename>\n\n";
	err_finis;
}

# Get the name of the backup server
$command = ($ENV{"P7_INST_DIR"} . "/lbin/p7resource BackupA7HostName");
$AltSrv = `$command`;
chop $AltSrv;
	
# Get the name of the primary server
$command = ($ENV{"P7_INST_DIR"} . "/lbin/p7resource PrimaryA7HostName");
$PriSrv = `$command`;
chop $PriSrv;
	
if ($ENV{"HOSTNAME"} eq $PriSrv) {
	print "$PriSrv: Primary Server\n";

	$remote = $AltSrv;
		
} elsif ($ENV{"HOSTNAME"} eq $AltSrv) {
	print "$AltSrv: Alt Server\n";

	$remote = $PriSrv;
		
} else {
#	print $ENV{"HOSTNAME"} . ": This script must be run on one of the central servers.  Exiting.\n";
#	err_finis;
}

# Check for '-d' or '-l' option
if (@ARGV[0] eq "-d") {

	# Check for existence of output file
	if (-f @ARGV[1]) {
		print @ARGV[1] . " already exists!  Overwrite [y/N]? ";
		if (getc(STDIN) eq 'n') {
			print "File was not overwritten.  Exiting.\n";
			err_finis;
		}
	}
	# Remove old output file
	system(("rm","-f",@ARGV[1]));
	
	# Make sure it's gone
	if (-f @ARGV[1]) {
		print "Error!  Couldn't remove " . @ARGV[1] . "!  Exiting.\n";
		err_finis;
	}
	
	system(("p7updatecomms",@ARGV[0],@ARGV[1]));
	
	if (-f @ARGV[1]) {
		# Exit without errors
		exit(0);	
	} else {
		print "Error!  Couldn't write " . @ARGV[1] . "!  Exiting.\n";
		err_finis;
	}
	
} elsif (@ARGV[0] eq "-l") {

	# Check for existence of file iff '-l' option is specified
	if (! -f @ARGV[1]) {
		print @ARGV[1] . " is not a valid filename!  Exiting.\n";
		err_finis;
	}
$remote = "stage1";
	# Start p7uc_server on other machine
	$sock = new IO::Socket::INET (	PeerAddr	=> $remote,
					PeerPort	=> $port,
					Proto		=> 'tcp',
					);
					
	# Die if the socket can't be created
	if (!$sock) {
		print "p7uc: Error creating socket: $!\n";
		err_finis;
	}	
	
	# Handshaking to make sure we're talking...
	print $sock "p7uc\n";
	
	$buf = <$sock>;
	print $buf;

	$buf = <$sock>;
	print $buf;
	
#	print $ENV{P7_RUN_FILE};
#	if (-f $ENV{P7_RUN_FILE}) {
#		print " exists!\n";
#	}
}

#finis
system(("rm","-f","/var/tmp/p7uc.lck"));
close($sock);
exit(0);