#!/opt/perl5/bin/perl -w

# p7uc_server.pl
# 7-31-01 by Jon A. Bieker

use IO::Socket;

# Clean up before exiting on errors
sub err_finis {
	if ($sock) {
		close($sock);
	}
	system(("rm","-f","/var/tmp/p7uc_server.lck"));
	exit(1);
}

# Check for already running copy of p7uc_server.pl.  If one exists, exit immediately.
if (-f "/var/tmp/p7uc_server.lck") {
	print "p7uc_server.pl is already running!  Exiting.\n";
	err_finis;
} else {
	system(("touch","/var/tmp/p7uc_server.lck"));
}

# Setup port 2345 in /etc/services and /inetd.conf
$port = "p7uc";			# Finds port in /etc/services
#$port = 2345;			# Hardcoded port (do not use)
$host = `hostname`;

# Create 
$sock = new IO::Socket::INET (	LocalHost 	=> $host,
				LocalPort 	=> $port,
				Proto		=> 'tcp',
				Listen		=> 5,
				Reuse		=> 1
				);
				
if (!$sock) {
	print "p7uc_server: Error creating socket: $!\n";
	err_finis;
}

$new_sock = $sock->accept();

$lExit = 0;
while (!$lExit) {
	$buf = <$new_sock>;
	chop $buf;
	
	if ($buf eq "p7uc") {
	
		print $new_sock "p7uc_server\n";
	
	} else {
		print $new_sock ".\n";
		print "|$buf|";
	}

	print $new_sock "test received.\n";
	$lExit = 1;
}

#finis
if ($sock) {
	close($sock);
}
if ($new_sock) {
	close($new_sock);
}

system(("rm","-f","/var/tmp/p7uc_server.lck"));

exit(0);