#!/opt/perl5/bin/perl

# STP Reports
# 1-7-02 by Jon Bieker
# (c)2002 Sprint

use Pg;

print "Connecting to database...\n";
$stp = Pg::connectdb("dbname=stp user=postgres password=postgres");

print "Collecting remote site information...\n";
$rsite = $stp->exec("select distinct clli from comm;");

print "Collecting local site information...\n";
$site = $stp->exec("select switch_name,id from site order by switch_name;");

print "Generating report...\n";
for ($nSite = 0; $nSite < $site->ntuples; $nSite++) {

  print $site->getvalue($nSite,0) . "\n";
  
  $filename89 = $site->getvalue($nSite,0) . "_monthly_comm_89.txt";
  $filename90 = $site->getvalue($nSite,0) . "_monthly_comm_90.txt";
  
  open(hFile89,">" . $filename89);
  open(hFile90,">" . $filename90);
  
  $id = $site->getvalue($nSite,1);
  
  for ($nDay = 1; $nDay < 31; $nDay++) {

    $date = "2002-01-" . sprintf("%0.2d",$nDay);
  
    $c89 = $stp->exec("select time from comm where date='$date' and ipr='89' and site_id='$id' order by time;");
    $c90 = $stp->exec("select time from comm where date='$date' and ipr='90' and site_id='$id' order by time;");
    
    print "\t$date\t" . $c89->ntuples . "\n";
    print "\t$date\t" . $c90->ntuples . "\n";

    print hFile89 "$date\t" . $c89->ntuples . "\n";
    print hFile90 "$date\t" . $c90->ntuples . "\n";
    
  }  
}


# Clean up...
close(hFile90);
close(hFile89);
undef $comm;

exit(0);
