/*
	setexpire.c
	6-25-01 by Jon Bieker
	(c)2001 Sprint
*/

#include "/home/a7users/ss7gjobi/src/include/include.h"

int main () 
{
	int hFile;
	int nI, nJ, nU, nE, nEOF, nSkip, nChange, lFound;
	char cBuf[512];
	struct passwd user[1000];
	struct passwd passwd[1000];

	for (nI = 0; nI < sizeof(cBuf); nI++) cBuf[nI] = 0;

	printf("setexpire - Set Account Expiration Dates\n");
	printf("6-25-01 by Jon Bieker\n");
	printf("(c)2001 Sprint\n");

	printf("\nReading /etc/passwd... ");	
	hFile = open("/etc/passwd",O_RDONLY);
	if (hFile == -1)  {
		printf("Error %0d!  Couldn't open /etc/passwd!",errno);
		exit(1);
	}

	nU = 0;
	strcpy(cBuf,"1\0");
	while (strlen(cBuf) > 0) {
		strcpy(cBuf,readline(&hFile));
		
		strcpy(passwd[nU++].username,strtok(cBuf,":"));
		
	}
	close(hFile);
	
	printf("Done. %0d users.\n",nU);
	
	
	printf("Reading exclude.dat... ");	
	hFile = open("exclude.dat",O_RDONLY);
	if (hFile == -1)  {
		printf("Error %0d!  Couldn't open exclude.dat!",errno);
		exit(1);
	}

	nE = 0;
	nEOF = lseek(hFile,0,SEEK_END);
	lseek(hFile,0,SEEK_SET);
	while (lseek(hFile,0,SEEK_CUR) < nEOF) {
		strcpy(cBuf,readline(&hFile));
		
		strcpy(user[nE++].username,strtok(cBuf,":"));
		
	}
	close(hFile);
	
	printf("Done. %0d exclusions.\n",nE);

	nChange = nSkip = 0;
	for (nI = 0; nI < nU; nI++) {
		lFound = 0;
		for (nJ = 0; nJ < nE; nJ++) {
			if (!strcmp(passwd[nI].username,user[nJ].username) > 0) {
				printf("Skipping %s.\n",passwd[nI].username);
				nJ = nE;
				lFound = 1;
				nSkip++;
			}
		}
		
		if (!lFound && strlen(passwd[nI].username) > 0) {
			nChange++;
		
			strcpy(cBuf,"passwd -x 365 ");
			strcat(cBuf,passwd[nI].username);
			
			printf("Changing: %s\n",cBuf);
			
			system(cBuf);
		}
	}
	
	printf("\n%0d changed.  %0d skipped.\n\n",nChange,nSkip);
	
	return 0;
}