#!/opt/perl5/bin/perl -w

# 'shutdown' wrapper script
# 9-19-01 by Jon Bieker
# (c) 2001 Sprint

$ARGC = @ARGV;

if ($ARGC == 0) {
	print "Shutdown requires arguments!\n";
	print "Usage: shutdown [-r|-h] time\n\n";
	exit(1);
}

$mode = "";
$grace = 60;

foreach $a (@ARGV) {
	if ($a eq "-h" || $a eq "-r") {
		$mode = $a;
	} elsif ($a eq "now" || isdigit($a)) {
		$grace = $a;		
	}
}

if ($mode ne "-r" && $mode ne "-h") {
	print "Shutdown requires either '-r' or '-h'.\n";
	exit(1);
}

print "\n**** WARNING WARNING WARNING WARNING WARNING ****\n";
print "This command is being executed on the central\n";
print "server.  Continuing will immediately reboot the\n";
print "server causing the AcceSS7 platform to shut down.\n\n";

print "Are you sure? (Type 'yes' to confirm): ";

$query = <stdin>;
chop $query;

if (lc($query) eq "yes") {
	print "Executing...\n\n";
	print "/usr/sbin/shutdown.run $mode $grace\n";
#	system "/usr/sbin/shutdown.run $mode $grace";
	exit(0);
} else {
	exit(1);
}