/*
	ipr.c
	12-19-01 by Jon Bieker
	(c)2001 Sprint
*/

#include "../include/include.h"
#include <sys/file.h>

#define MAXBUFLEN 1024
#define MAXCODES 3000
#define MAXLINKS 5000
#define MAXSTP 8

struct comm {
	char date[9];
	char time[9];
	char seq[10];
	char count[5];
	char alarm[10];
	char alarm_stat[4];
	char device[25];
	char rep_proc[25];
	char frame[10];
	char vert[5];
	char horiz[5];
	char linknum[10];
	char code[10];
	char clli[12];
};

struct stp {
	char switch_name[10];
	char point_code[12];
	char ip_address[16];
	char real_name[25];
	struct comm comm_89[MAXCODES];
	struct comm comm_90[MAXCODES];
};

int main()
{
	/* Variable Declarations */
	char cBuf[MAXBUFLEN],cTmpBuf[MAXBUFLEN],cCode1[MAXBUFLEN],cCode2[MAXBUFLEN];
	char lEOF;
	int nI,nJ,nSTP,nCode;

	FILE *hIPR, *hOut;
	
	struct stp stp[MAXSTP];
	
	uselog("ipraudit","");
	
	printf("IPR Audit\n");
	printf("12-19-01 by Jon Bieker\n");
	printf("(c)2001 Sprint\n\n");

	
	/* Define STP's */
	strcpy(stp[0].switch_name,"CHC301");		/* Chicago 301		*/
	strcpy(stp[0].point_code,"253-193-000");
	strcpy(stp[0].ip_address,"172.20.196.226");
	strcpy(stp[0].real_name,"Chicago 301");
	strcpy(stp[1].switch_name,"FTW302");		/* Fort Worth 302	*/
	strcpy(stp[1].point_code,"253-194-000");
	strcpy(stp[1].ip_address,"172.20.198.8");
	strcpy(stp[1].real_name,"Fort Worth 302");
	strcpy(stp[2].switch_name,"STK303");		/* Stockton 303		*/
	strcpy(stp[2].point_code,"253-130-000");
	strcpy(stp[2].ip_address,"172.20.129.50");
	strcpy(stp[2].real_name,"Stockton 303");
	strcpy(stp[3].switch_name,"RIL304");		/* Rialto 304		*/
	strcpy(stp[3].point_code,"253-129-000");
	strcpy(stp[3].ip_address,"172.20.23.152");
	strcpy(stp[3].real_name,"Rialto 304");
	strcpy(stp[4].switch_name,"NAS307");		/* Nashville 307	*/
	strcpy(stp[4].point_code,"253-037-000");
	strcpy(stp[4].ip_address,"172.20.177.22");
	strcpy(stp[4].real_name,"Nashville 307");
	strcpy(stp[5].switch_name,"ATL306");		/* Atlanta 306		*/
	strcpy(stp[5].point_code,"253-066-000");
	strcpy(stp[5].ip_address,"172.20.202.172");
	strcpy(stp[5].real_name,"Atlanta 306");
	strcpy(stp[6].switch_name,"AKR314");		/* Akron 314		*/
	strcpy(stp[6].point_code,"253-038-000");
	strcpy(stp[6].ip_address,"172.20.155.25");
	strcpy(stp[6].real_name,"Akron 314");
	strcpy(stp[7].switch_name,"NYC305");		/* New York 305		*/
	strcpy(stp[7].point_code,"253-065-000");
	strcpy(stp[7].ip_address,"172.20.51.83");
	strcpy(stp[7].real_name,"New York 305");
	
	/* Read COMM 89 file */
	printf("Reading COMM89 report... ");
	fflush(stdout);
	
	hIPR = fopen("ipr_89_capture.txt","r");
	hOut = fopen("ipr_89_data.txt","a");

	lEOF = 0;
	strcpy(cBuf,"");
	while (!lEOF) {
		nCode = 0;
		cBuf[strlen(cBuf) - 1] = 0;
		while (strncmp(cBuf,"Switch Name:",12) && !lEOF) {
			if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
				
			if (!strncmp(cBuf,"Switch Name:",12) && strlen(cBuf) > 1) {
				strcpy(cTmpBuf,strtok(cBuf," "));
				strcpy(cTmpBuf,strtok(NULL," "));
				strcpy(cTmpBuf,strtok(NULL," "));
				cTmpBuf[strlen(cTmpBuf) - 1] = 0;
			
				/* Find the site name */
				for (nJ = 0; nJ < MAXSTP; nJ++) {
					if (!strcmp(cTmpBuf,stp[nJ].switch_name)) {
						nSTP = nJ;
						nJ = MAXSTP;
					}
				}
				printf("%s\n",stp[nSTP].real_name);
		
				while (strncmp(cBuf,"REPT:",5) && strncmp(cBuf,"Switch Name:",12) && !lEOF) {
					if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
				
				
					if (!strncmp(cBuf,"REPT:",5)) {
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
		
						/* Time & Date & stuff */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].date,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].time,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].alarm,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].alarm_stat,strtok(NULL," "));
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Device */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(stp[nSTP].comm_89[nCode].device,cBuf);
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Location */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].frame,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].vert,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].horiz,strtok(NULL," "));
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Reporting Processor */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].rep_proc,strtok(NULL," "));
						strcat(stp[nSTP].comm_89[nCode].rep_proc,strtok(NULL," "));
						strcat(stp[nSTP].comm_89[nCode].rep_proc,strtok(NULL," "));
						strcat(stp[nSTP].comm_89[nCode].rep_proc,strtok(NULL," "));
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Remove LF */
						cBuf[strlen(cBuf) - 1] = 0;
						
						/* Data Line */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].linknum,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].code,strtok(NULL," "));
						strcpy(stp[nSTP].comm_89[nCode].clli,strtok(NULL," "));
						strcat(stp[nSTP].comm_89[nCode].clli,strtok(NULL," "));
						strcat(stp[nSTP].comm_89[nCode].clli,strtok(NULL," "));
						
						strcpy(cBuf,stp[nSTP].comm_89[nCode].linknum);
						cBuf[strlen(cBuf) - 1] = 0;
						strcpy(stp[nSTP].comm_89[nCode].linknum,ltoa(atoi(cBuf)));
						
						strcpy(cBuf,stp[nSTP].comm_89[nCode].code);
						cBuf[strlen(cBuf) - 1] = 0;
						strcpy(stp[nSTP].comm_89[nCode].code,cBuf);
						
						strcpy(cCode1,"");
						strcpy(cCode2,"");
						
						cBuf[0] = stp[nSTP].comm_89[nCode].code[2];
						cBuf[1] = stp[nSTP].comm_89[nCode].code[3];
						cBuf[2] = 0;
						
						if (!strcmp(cBuf,"03")) {
							strcpy(cCode2,"Received an SIOS while in the aligned/ready state or proving state.");
						} else if (!strcmp(cBuf,"04")) {
							strcpy(cCode2,"Exceeded alignment retry maximum.");
						} else if (!strcmp(cBuf,"06")) {
							strcpy(cCode2,"Received either an SIO in the aligned ready state or SIE/SIN in the in-service or processor-outage state.");
						} else if (!strcmp(cBuf,"0A")) {
							strcpy(cCode2,"Excessive delays of acks.");
						} else if (!strcmp(cBuf,"0B")) {
							strcpy(cCode2,"Excessive duration of busy condition.");
						} else if (!strcmp(cBuf,"0C")) {
							strcpy(cCode2,"SUERM forced failure.");
						} else if (!strcmp(cBuf,"0D")) {
							strcpy(cCode2,"Excessive sequence number errors.");
						} else if (!strcmp(cBuf,"0E")) {
							strcpy(cCode2,"Excessive FIB errors.");
						} else if (!strcmp(cBuf,"0F")) {
							strcpy(cCode2,"Received an SIO while in the in-service state or in the processor-outage state.");
						} else if (!strcmp(cBuf,"10")) {
							strcpy(cCode2,"Received an SIOS while in the in-service state or in the processor-outage state.");
						} else if (!strcmp(cBuf,"11")) {
							strcpy(cCode2,"Z80 crash.");
						} else if (!strcmp(cBuf,"12")) {
							strcpy(cCode2,"Idle link timer time out.");
						} else if (!strcmp(cBuf,"13")) {
							strcpy(cCode2,"Self-test failed on DCC-2.");
						} else if (!strcmp(cBuf,"14")) {
							strcpy(cCode2,"5027 link controller error on DCC-2.");
						} else if (!strcmp(cBuf,"15")) {
							strcpy(cCode2,"Link number assignment error.");
						} else if (!strcmp(cBuf,"16")) {
							strcpy(cCode2,"Dual PCM highway failure on DCC-2.");
						} else if (!strcmp(cBuf,"17")) {
							strcpy(cCode2,"False Link Congestion Detected by Level 2 (T9 expired).");
						} else if (!strcmp(cBuf,"31")) {
							strcpy(cCode2,"Initiated by local management.");
						} else if (!strcmp(cBuf,"32")) {
							strcpy(cCode2,"Local processor outage.");
						} else if (!strcmp(cBuf,"33")) {
							strcpy(cCode2,"Local protocol error.");
						} else if (!strcmp(cBuf,"34")) {
							strcpy(cCode2,"Alignment not successful.");
						} else if (!strcmp(cBuf,"35")) {
							strcpy(cCode2,"Proving not successful.");
						} else if (!strcmp(cBuf,"36")) {
							strcpy(cCode2,"Remote processor outage.");
						} else if (!strcmp(cBuf,"37")) {
							strcpy(cCode2,"Remote release - Remote OOS.");
						} else if (!strcmp(cBuf,"38")) {
							strcpy(cCode2,"Remote release - protocol error.");
						} else if (!strcmp(cBuf,"39")) {
							strcpy(cCode2,"Remote release - management initiated.");
						} else if (!strcmp(cBuf,"3A")) {
							strcpy(cCode2,"Excessive delay of acknowledgement.");
						} else if (!strcmp(cBuf,"3B")) {
							strcpy(cCode2,"Excessive duration of far end receive congestion (timer_no-credit expired).");
						} else if (!strcmp(cBuf,"3C")) {
							strcpy(cCode2,"Excessive in-service error rate.");
						} else if (!strcmp(cBuf,"3D")) {
							strcpy(cCode2,"In remote loopback.");
						} else if (!strcmp(cBuf,"3E")) {
							strcpy(cCode2,"Other/unresolved OOS reason.");
						}
						
						cBuf[0] = stp[nSTP].comm_89[nCode].code[4];
						cBuf[1] = stp[nSTP].comm_89[nCode].code[5];
						cBuf[2] = 0;
						
						if (!strcmp(cBuf,"00")) {
							strcpy(cCode1,"Requested by level 3 changeover.");
						} else if (!strcmp(cBuf,"01")) {
							strcpy(cCode1,"CCLK of HSLK NIC failure.");
						} else if (!strcmp(cBuf,"02")) {
							strcpy(cCode1,"Error during alignment.");
						} else if (!strcmp(cBuf,"03")) {
							strcpy(cCode1,"Error while in service.");
						} else if (!strcmp(cBuf,"04")) {
							strcpy(cCode1,"Requested by command.");
						} else if (!strcmp(cBuf,"05")) {
							strcpy(cCode1,"LDE setmode error.");
						} else if (!strcmp(cBuf,"06")) {
							strcpy(cCode1,"Signaling link test failure.");
						} else if (!strcmp(cBuf,"07")) {
							strcpy(cCode1,"Blocked manual.");
						} else if (!strcmp(cBuf,"08")) {
							strcpy(cCode1,"Blocked auto (SIPO received on link).");
						} else if (!strcmp(cBuf,"09")) {
							strcpy(cCode1,"Blocked remote (SIPO received on link).");
						} else if (!strcmp(cBuf,"0A")) {
							strcpy(cCode1,"Inhibit remote.");
						} else if (!strcmp(cBuf,"0B")) {
							strcpy(cCode1,"Inhibit local.");
						} else if (!strcmp(cBuf,"0C")) {
							strcpy(cCode1,"HSLK blocked manual (link OOS - no SIPO on link).");
						} else if (!strcmp(cBuf,"0D")) {
							strcpy(cCode1,"HSLK proc outage (link OOS - no SIPO on link).");
						}


						printf("%s\tLink: %s\t%s\t%s\t%s\tAlarm: %s",stp[nSTP].switch_name,stp[nSTP].comm_89[nCode].linknum,stp[nSTP].comm_89[nCode].date,stp[nSTP].comm_89[nCode].time,stp[nSTP].comm_89[nCode].clli,stp[nSTP].comm_89[nCode].alarm);
						printf("\tCode 1: %s",cCode1);
						printf("\tCode 2: %s\n",cCode2);
						
						strcpy(cBuf,stp[nSTP].switch_name);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].linknum);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].date);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].time);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].clli);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].alarm);
						strcat(cBuf,"\t");
						strcat(cBuf,cCode1);
						strcat(cBuf,"\t");
						strcat(cBuf,cCode2);
						strcat(cBuf,"\n");
						
						fputs(cBuf,hOut);

						if (++nCode > MAXCODES) nCode = MAXCODES;
					}
				}
			}
		}
	}

	close(hOut);
	close(hIPR);	

exit(0);
	/* Read COMM 90 file */
	printf("Reading COMM90 report... ");
	fflush(stdout);
	
	hIPR = fopen("ipr_90_capture.txt","r");
	hOut = fopen("ipr_90_data.txt","a");

	lEOF = 0;
	strcpy(cBuf,"");
	while (!lEOF) {
		nCode = 0;
		cBuf[strlen(cBuf) - 1] = 0;
		while (strncmp(cBuf,"Switch Name:",12) && !lEOF) {
			if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
				
			if (!strncmp(cBuf,"Switch Name:",12) && strlen(cBuf) > 1) {
				strcpy(cTmpBuf,strtok(cBuf," "));
				strcpy(cTmpBuf,strtok(NULL," "));
				strcpy(cTmpBuf,strtok(NULL," "));
				cTmpBuf[strlen(cTmpBuf) - 1] = 0;
			
				/* Find the site name */
				for (nJ = 0; nJ < MAXSTP; nJ++) {
					if (!strcmp(cTmpBuf,stp[nJ].switch_name)) {
						nSTP = nJ;
						nJ = MAXSTP;
					}
				}
				printf("%s\n",stp[nSTP].real_name);
		
				while (strncmp(cBuf,"REPT:",5) && strncmp(cBuf,"Switch Name:",12) && !lEOF) {
					if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
				
				
					if (!strncmp(cBuf,"REPT:",5)) {
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
		
						/* Time & Date & stuff */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].date,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].time,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].alarm,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].alarm_stat,strtok(NULL," "));
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Device */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(stp[nSTP].comm_90[nCode].device,cBuf);
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Location */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].frame,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].vert,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].horiz,strtok(NULL," "));
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Reporting Processor */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].rep_proc,strtok(NULL," "));
						strcat(stp[nSTP].comm_90[nCode].rep_proc,strtok(NULL," "));
						strcat(stp[nSTP].comm_90[nCode].rep_proc,strtok(NULL," "));
						strcat(stp[nSTP].comm_90[nCode].rep_proc,strtok(NULL," "));
						
						if(fgets(cBuf,sizeof(cBuf),hIPR) == NULL) lEOF = 1;
						
						/* Remove LF */
						cBuf[strlen(cBuf) - 1] = 0;
						
						/* Data Line */
						strcpy(cTmpBuf,strtok(cBuf," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(cTmpBuf,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].linknum,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].code,strtok(NULL," "));
						strcpy(stp[nSTP].comm_90[nCode].clli,strtok(NULL," "));
						strcat(stp[nSTP].comm_90[nCode].clli,strtok(NULL," "));
						strcat(stp[nSTP].comm_90[nCode].clli,strtok(NULL," "));
						
						strcpy(cBuf,stp[nSTP].comm_90[nCode].linknum);
						cBuf[strlen(cBuf) - 1] = 0;
						strcpy(stp[nSTP].comm_90[nCode].linknum,ltoa(atoi(cBuf)));
						
						strcpy(cBuf,stp[nSTP].comm_90[nCode].code);
						cBuf[strlen(cBuf) - 1] = 0;
						strcpy(stp[nSTP].comm_90[nCode].code,cBuf);
						
						strcpy(cCode1,"");
						strcpy(cCode2,"");
						
						cBuf[0] = stp[nSTP].comm_90[nCode].code[4];
						cBuf[1] = stp[nSTP].comm_90[nCode].code[5];
						cBuf[2] = 0;
						
						if (!strcmp(cBuf,"12")) {
							strcpy(cCode1,"Link in service.");
						} else if (!strcmp(cBuf,"13")) {
							strcpy(cCode1,"Unblocked manual.");
						} else if (!strcmp(cBuf,"14")) {
							strcpy(cCode1,"Unblocked auto.");
						} else if (!strcmp(cBuf,"15")) {
							strcpy(cCode1,"Unblocked remote.");
						} else if (!strcmp(cBuf,"16")) {
							strcpy(cCode1,"Uninhibit remote.");
						} else if (!strcmp(cBuf,"17")) {
							strcpy(cCode1,"Uninhibit local.");
						}


						printf("%s\tLink: %s\t%s\t%s\t%s\tAlarm: %s\n",stp[nSTP].switch_name,stp[nSTP].comm_90[nCode].linknum,stp[nSTP].comm_90[nCode].date,stp[nSTP].comm_90[nCode].time,stp[nSTP].comm_90[nCode].clli,stp[nSTP].comm_90[nCode].alarm);
						printf("\tCode 1: %s\n",cCode1);
						printf("\tCode 2: %s\n\n",cCode2);
						
						strcpy(cBuf,stp[nSTP].switch_name);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].linknum);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].date);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].time);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].clli);
						strcat(cBuf,"\t");
						strcat(cBuf,stp[nSTP].comm_89[nCode].alarm);
						strcat(cBuf,"\t");
						strcat(cBuf,cCode1);
						strcat(cBuf,"\t");
						strcat(cBuf,cCode2);
						strcat(cBuf,"\n");
						
						fputs(cBuf,hOut);

						if (++nCode > MAXCODES) nCode = MAXCODES;
					}
				}
			}
		}
	}

	close(hOut);
	close(hIPR);	
	
	return 0;
}