/************************************************************************************
 * Title         : DemoTop
 * Project       : GrizzlyDemo
 *-----------------------------------------------------------------------------------
 * File          : DemoTop.v
 * Author        : Matt Clark  <matt_clark@agilent.com>
 * Created       : 06.18.2013
 * Last modified : 06.18.2013
 *-----------------------------------------------------------------------------------
 *********SVN Revision History*************
 * $Date$
 * $Author$
 * $HeadURL$
 * $Revision$
 *----------------------------------------------------------------------------------
 * Description   :
 * 
 *-----------------------------------------------------------------------------------
 **************************  Agilent Confidential  **********************************
 * All rights reserved.
 *                                   _
 *                         .-.      / \        _
 *                        /   \    /^./\__   _/ \
 *           _        .--'\/\_ \__/.      \ /    \      ___
 *          / \_    _/ ^      \/  __  :'   /\/\  /\  __/   \
 *         /    \  /    .'   _/  /  \   ^ /    \/  \/ .`'\_/\
 *        /\/\  /\/ :' __  ^/  ^/    `--./.'  ^  `-.\ _    _:\ _
 *       /    \/  \  _/  \-' __/.' ^ _   \_   .'\   _/ \ .  __/ \
 *     /\  .-   `. \/     \ / -.   _/ \ -. `_/   \ /    `._/  ^  \
 *    /  `-.__ ^   / .-'.--'    . /    --./ .-'  `-.  `-. `.  -   `.
 *   /        `.  / /       `-.  /  .-'  / .    .'  \    \  \  .-   \
 *----------------------------------------------------------------------------------
 * Copyright (c) 2013 by Agilent. This model is the confidential and
 * proprietary property of Agilent and the possession or use of this
 * file requires a written license from Agilent.
 *----------------------------------------------------------------------------------
 * Modification history / Change log :
 * 06.18.2013 : Matt Clark
 *   --Initial revision
 **********************************************************************************/

module DemoTop (
input resetAsync,
input clk100MHz,

output wire timeout,
output wire [4:0] state,
output wire ack,
output wire clk250MHz,
output wire drive0,
output wire clk250MHz_b,
output wire [15:0]zeros
);


  //////////////////////////////////////////////////////////////////////////////
  // The flying leads are connected to the FMC board.  Connector J1, FMC-LA[00:19]
  // are used in a differential fashion. [0+2*n]=_p, [1+2*n]=_n
  // They connet to FMC connector J17 that goes to the Zed board.
  // Pin Out:
  // FMC_LA00_p/n = J1 01/03 = FMC Pin G06/G07 = Xilinx Pin M19/M20
  // FMC_LA01_p/n = J1 05/07 = FMC Pin D08/D09 = Xilinx Pin N19/N20
  // FMC_LA02_p/n = J1 09/11 = FMC Pin H07/H08 = Xilinx Pin P17/P18
  // FMC_LA03_p/n = J1 13/15 = FMC Pin G09/G10 = Xilinx Pin N22/P22
  // FMC_LA04_p/n = J1 17/19 = FMC Pin H10/H11 = Xilinx Pin M21/M22
  // FMC_LA05_p/n = J1 21/23 = FMC Pin D11/D12 = Xilinx Pin J18/K18
  // FMC_LA06_p/n = J1 25/27 = FMC Pin C10/C11 = Xilinx Pin L21/L22
  // FMC_LA07_p/n = J1 29/31 = FMC Pin H13/H14 = Xilinx Pin T16/T17
  // FMC_LA08_p/n = J1 33/35 = FMC Pin G12/G13 = Xilinx Pin J21/J22
  // FMC_LA09_p/n = J1 37/39 = FMC Pin D14/D15 = Xilinx Pin R20/R21
  // FMC_LA10_p/n = J1 02/04 = FMC Pin C14/C15 = Xilinx Pin R19/T19
  // FMC_LA11_p/n = J1 06/08 = FMC Pin H16/H17 = Xilinx Pin N17/N18
  // FMC_LA12_p/n = J1 10/12 = FMC Pin G15/G16 = Xilinx Pin P20/P21
  // FMC_LA13_p/n = J1 14/16 = FMC Pin D17/D18 = Xilinx Pin L17/M17
  // FMC_LA14_p/n = J1 18/20 = FMC Pin C18/C19 = Xilinx Pin K19/K20
  // FMC_LA15_p/n = J1 22/24 = FMC Pin H19/H20 = Xilinx Pin J16/J17
  // FMC_LA16_p/n = J1 26/28 = FMC Pin G18/G19 = Xilinx Pin J20/K21
  // FMC_LA17_p/n = J1 30/32 = FMC Pin D20/D21 = Xilinx Pin B19/B20
  // FMC_LA18_p/n = J1 34/36 = FMC Pin C22/C23 = Xilinx Pin D20/C20
  // FMC_LA19_p/n = J1 38/40 = FMC Pin H22/H23 = Xilinx Pin G15/G16
  // 100 MHz clock comes in on Y9 (is it differential?)
  // Tie a push button to BTNL Pin N15
  // Switch 7 Pin M15
  // Switch 6 Pin H17
  

  assign drive0=1'b0;
  assign clk250MHz_b = ~clk250MHz;
  assign zeros=16'h0;
  
ClkGen
   inst_clkGen (
   .CLK_IN1(clk100MHz),
   .RESET(resetAsync),

   .CLK_OUT1(clk250MHz),
   .CLK_OUT2(),
   .LOCKED()
   );
  
StateMachine
   inst_stateMachine (
   .clk(clk250MHz),
   .resetAsync_n(~resetAsync),

   .state(state),
   .ack(ack),
   .timeout(timeout)
   );

endmodule
