// ChildFrm.cpp : implementation of the CChildFrame class
//


#include "stdafx.h"
#include "appwizjnk.h"
#include "ChildFrm.h"


#include "hpe1437p.h"
#include <visatype.h>
#include <vpptype.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define BLOCK_SIZE 1024

#define TACHYON_ERR(fcn,err_num,line) if (err_num) \
{ \
  char err_str [128]; \
  hpe1437_error_message (id, err_num, err_str); \
  printf (".%d:%s: '%s'\n", line, #fcn, err_str); \
  exit (1); \
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
	// TODO: add member initialization code here
	
//	ViSession   id;
//	ViStatus	vierr;
//	vierr=hpe1437_init("VXI1::130::INSTR",0,1,&id); 
//	vierr=hpe1437_close(id);

ViSession	id;
ViReal64 	data[BLOCK_SIZE];
ViInt16		range;
ViInt16		ovld;
ViInt32		i,j;
ViReal64	na,na2,ns;
ViStatus	vierr;

    vierr=hpe1437_init("VXI1::130::INSTR",HPE1437_OFF,HPE1437_ON,&id); 
    TACHYON_ERR (error, vierr, __LINE__);
	
	/* filter_bw controls the digital AAF and therefore, the measurement span */
	hpe1437_filter_bw( id, 0);
    TACHYON_ERR (error, vierr, __LINE__); 

	/* this controls the center frequency of the measurement. */
	vierr=hpe1437_frequency_setup( id, HPE1437_OFF, HPE1437_OFF,  0.0);     
    TACHYON_ERR (error, vierr, __LINE__); 

    vierr=hpe1437_data_setup( id, HPE1437_REAL, 
		                          HPE1437_32BIT, 
								  HPE1437_BLOCK, 
								  BLOCK_SIZE, 
								  HPE1437_OFF, 
								  HPE1437_VME);
    TACHYON_ERR (error, vierr, __LINE__);

	range=6;

 	vierr=hpe1437_input_range( id, range );
    TACHYON_ERR (error, vierr, __LINE__);   
	
	range=99;

	vierr=hpe1437_input_range_get( id, &range );
    TACHYON_ERR (error, vierr, __LINE__);

	printf("Range = %d\n",range);

	vierr=hpe1437_meas_start( id );
    TACHYON_ERR (error, vierr, __LINE__);

	vierr = 99;
	while(vierr !=0)
	{
		printf(".");
		vierr=hpe1437_read64( id,  data, BLOCK_SIZE, &ovld);
	}
	printf("\n");
    TACHYON_ERR (error, vierr, __LINE__);

    /* print the data */
	/* for(i=0;i<20;i++)
		printf("%lf\n",data[i]); */

	for (i=0;i<25;i++)
	{
		na=(int)(data[i]*35);
		if (na < 0)
		{
			ns = 37+na;
			na2 = na * -1;
		}
		if (na >= 0) 
		{
			ns = 37;
			na2 = na;
		}
		for(j=0;j<ns;j++) printf(" ");
		for(j=0;j<na2;j++) printf("*");
		printf("\n");
	}
    
	vierr=hpe1437_close(id);

}

CChildFrame::~CChildFrame()
{
}

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	if( !CMDIChildWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers
