/* $Header: /tachy/library/hpe1437/msc/hpe1437.h 1.24 1997/08/01 16:05:12 howardh Exp $ */
/* (C) Copyright 1996 Hewlett-Packard Company.  All Rights Reserved. */

#ifndef E1437_INCLUDED		/*Prevent multiple inclusions of this file*/
#define E1437_INCLUDED

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif


#include <visatype.h>

/* FUNCTION PARAMETER VALUES */
#define HPE1437_16BIT 1
#define HPE1437_20000KHZ 1
#define HPE1437_20480KHZ 0
#define HPE1437_32BIT 0
#define HPE1437_AC 1
#define HPE1437_ADC 1
#define HPE1437_APPEND 2
#define HPE1437_ASSERT 1
#define HPE1437_BLOCK 0
#define HPE1437_BUFFER 2
#define HPE1437_COMPLEX 1
#define HPE1437_CONTINUOUS 1
#define HPE1437_DATA_REGISTER 3
#define HPE1437_DC 0
#define HPE1437_EXT_PLL_REF 3
#define HPE1437_EXTEND 3
#define HPE1437_EXTERNAL 2
#define HPE1437_FRONT 1
#define HPE1437_GENERATE 1
#define HPE1437_IMMEDIATE 4
#define HPE1437_INSERT 3
#define HPE1437_INTEL 1
#define HPE1437_IO_HANDLE 0
#define HPE1437_IO_ADDRESS 1
#define HPE1437_LBUS 1
#define HPE1437_MAG 3
#define HPE1437_MOTOROLA 0
#define HPE1437_NEGATIVE 1
#define HPE1437_OFF 0
#define HPE1437_ON 1
#define HPE1437_OSCILLATOR 0
#define HPE1437_PIPELINE 0
#define HPE1437_POSITIVE 0
#define HPE1437_REAL 0
#define HPE1437_REAR 2
#define HPE1437_RELEASE 0
#define HPE1437_RM_HANDLE 2
#define HPE1437_USER 0
#define HPE1437_VME 0

/* RETURN PARAMETER VALUES */
#define HPE1437_SUCCESS									0x00
#define HPE1437_NO_DATA_MEASUREMENT_IN_PROGRESS			0x01
#define HPE1437_NO_DATA_MEASUREMENT_PAUSED              0x02
#define HPE1437_NO_DATA_WAITING_FOR_TRIGGER             0x03
#define HPE1437_NO_DATA_WAITING_FOR_ARM					0x04
#define HPE1437_BAD_RESOURCE_DESCRIPTOR					0x05
#define HPE1437_NO_E1437_FOUND			        		0x06
#define HPE1437_PROC_READY_TIMEOUT	        	     	0x07
#define HPE1437_MEMORY_ALLOCATION_ERROR					0x08
#define HPE1437_CAPABILITY_NOT_SUPPORTED				0x09
#define HPE1437_BAD_ERR_NO								0x0a
#define HPE1437_UNSUPPORTED_HARDWARE_CONFIG				0x0b
#define HPE1437_CANT_START								0x0c
#define HPE1437_NULL_ID									0x0d
#define HPE1437_RESOURCE_MANAGER_ERROR					0x0e
#define HPE1437_BAD_COMMAND                 			0x61
#define HPE1437_PARM_ERROR                  			0x62
#define HPE1437_CAL_SAVE_ERROR							0x64
#define HPE1437_DOWNLOAD_ERROR              			0x65
#define HPE1437_DSPCLOCK_TOO_SLOW		      			0x66
#define HPE1437_AUTOZERO_ERROR              			0x67
#define HPE1437_MODE_ERROR								0x68
#define HPE1437_START_ERROR								0x69
#define HPE1437_SELFTEST_ERROR							0x6a
#define HPE1437_INTERNAL_ERROR							0x6b
#define HPE1437_AUTORANGE_ERROR							0x6c
#define HPE1437_BYTE_SWAP_ERROR             			0x7f


/* FUNCTION PROTOTYPES FOR E1437 APPLICATION PROGRAMMING INTERFACE (API) */
ViStatus  _VI_FUNC hpe1437_attrib_get(ViSession id, ViInt16 attrib, ViPInt32 value); 
ViStatus  _VI_FUNC hpe1437_clock_dsp(ViSession id, ViInt16 dsp);
ViStatus  _VI_FUNC hpe1437_clock_dsp_get(ViSession id, ViPInt16 dspPtr);
ViStatus  _VI_FUNC hpe1437_clock_fs(ViSession id,ViReal64 fs);
ViStatus  _VI_FUNC hpe1437_clock_fs_get(ViSession id, ViPReal64 fsPtr);
ViStatus  _VI_FUNC hpe1437_clock_master(ViSession id, ViInt16 master);
ViStatus  _VI_FUNC hpe1437_clock_master_get(ViSession id, ViPInt16 masterPtr);
ViStatus  _VI_FUNC hpe1437_clock_multi_sync(ViSession id, ViInt16 sync);
ViStatus  _VI_FUNC hpe1437_clock_multi_sync_get(ViSession id, ViPInt16 syncPtr);
ViStatus  _VI_FUNC hpe1437_clock_setup(ViSession id, ViInt16 sync , ViInt16 source, ViInt16 dsp, ViInt16 master, ViReal64 fs);
ViStatus  _VI_FUNC hpe1437_clock_source(ViSession id, ViInt16 source);
ViStatus  _VI_FUNC hpe1437_clock_source_get(ViSession id, ViPInt16 sourcePtr);
ViStatus  _VI_FUNC hpe1437_close(ViSession id);
ViStatus  _VI_FUNC hpe1437_data_append_status(ViSession id, ViInt16 appendStatus);
ViStatus  _VI_FUNC hpe1437_data_append_status_get(ViSession id, ViPInt16 appendStatusPtr);
ViStatus  _VI_FUNC hpe1437_data_blocksize(ViSession id, ViInt32 blocksize);
ViStatus  _VI_FUNC hpe1437_data_blocksize_get(ViSession id, ViPInt32 blocksizePtr);
ViStatus  _VI_FUNC hpe1437_data_memsize_get(ViSession id, ViPInt16 memSizePtr);
ViStatus  _VI_FUNC hpe1437_data_mode(ViSession id, ViInt16 mode);
ViStatus  _VI_FUNC hpe1437_data_mode_get(ViSession id, ViPInt16 modePtr);
ViStatus  _VI_FUNC hpe1437_data_port(ViSession id, ViInt16 port);
ViStatus  _VI_FUNC hpe1437_data_port_get(ViSession id, ViPInt16 portPtr);
ViStatus  _VI_FUNC hpe1437_data_resolution(ViSession id, ViInt16 resolution);
ViStatus  _VI_FUNC hpe1437_data_resolution_get(ViSession id, ViPInt16 resolutionPtr);
ViStatus  _VI_FUNC hpe1437_data_setup(ViSession id,ViInt16 dType,ViInt16 resolution,ViInt16 mode,ViInt32 blocksize,ViInt16 appendStatus,ViInt16 port);
ViStatus  _VI_FUNC hpe1437_data_type(ViSession id, ViInt16 dType);
ViStatus  _VI_FUNC hpe1437_data_type_get(ViSession id, ViPInt16 dTypePtr);
ViStatus  _VI_FUNC hpe1437_data_scale_get(ViSession id, ViPReal64 scalePtr);
ViStatus  _VI_FUNC hpe1437_data_xfersize(ViSession id, ViInt32 xfersize);
ViStatus  _VI_FUNC hpe1437_data_xfersize_get(ViSession id, ViPInt32 xfersize);
ViStatus  _VI_FUNC hpe1437_diag_adccal_get(ViSession id, ViReal64 cal[]);
ViStatus  _VI_FUNC hpe1437_diag_cal(ViSession id, ViInt32 timestamp);
ViStatus  _VI_FUNC hpe1437_diag_cal_get(ViSession id, ViPInt32 timestamp);
ViStatus  _VI_FUNC hpe1437_diag_download(ViSession id);
ViStatus  _VI_FUNC hpe1437_diag_peek(ViSession id, ViInt16 wordOffset, ViPInt16 value);
ViStatus  _VI_FUNC hpe1437_diag_poke(ViSession id, ViInt16 wordOffset, ViInt16 value);
ViStatus  _VI_FUNC hpe1437_diag_poke_block(ViSession id, ViInt16 wordOffset, ViInt16 value[], ViInt16 count);
ViStatus  _VI_FUNC hpe1437_diag_reg(ViSession id, ViInt16 diag_reg, ViInt16 reg_data);
ViStatus  _VI_FUNC hpe1437_diag_reg_get(ViSession id, ViInt16 diag_reg, ViPInt16 diag_reg_dataPtr);
ViStatus  _VI_FUNC hpe1437_error_message(ViSession id,ViStatus errNum, ViPString errMessage);
ViStatus  _VI_FUNC hpe1437_error_query(ViSession id,ViPInt32 errNumPtr, ViPString errMessage);
ViStatus  _VI_FUNC hpe1437_filter_decimate(ViSession id, ViInt16 decimate);
ViStatus  _VI_FUNC hpe1437_filter_decimate_get(ViSession id, ViPInt16 decimatePtr);
ViStatus  _VI_FUNC hpe1437_filter_resp_get(ViSession id, ViReal64 resp[], ViInt32 n,ViReal64 fmin, ViReal64 fmax);
ViStatus  _VI_FUNC hpe1437_filter_setup(ViSession id,  ViInt16 sigBw,  ViInt16 decimate);
ViStatus  _VI_FUNC hpe1437_filter_bw(ViSession id, ViInt16 sigBw);
ViStatus  _VI_FUNC hpe1437_filter_bw_get(ViSession id, ViPInt16 sigBwPtr);
ViStatus  _VI_FUNC hpe1437_filter_sync(ViSession id);
ViStatus  _VI_FUNC hpe1437_frequency_center(ViSession id, ViReal64 freq);
ViStatus  _VI_FUNC hpe1437_frequency_center_get(ViSession id, ViPReal64 freqPtr);
ViStatus  _VI_FUNC hpe1437_frequency_center_raw(ViSession id, ViInt16 coarse, ViInt32 fine);
ViStatus  _VI_FUNC hpe1437_frequency_cmplxdc(ViSession id, ViInt16 cmplxDc);
ViStatus  _VI_FUNC hpe1437_frequency_cmplxdc_get(ViSession id, ViPInt16 cmplxDcPtr);
ViStatus  _VI_FUNC hpe1437_frequency_setup(ViSession id, ViInt16 cmplxDc, ViInt16 sync, ViReal64 freq);
ViStatus  _VI_FUNC hpe1437_frequency_sync(ViSession id, ViInt16 sync);
ViStatus  _VI_FUNC hpe1437_frequency_sync_get(ViSession id, ViPInt16 syncPtr);
ViStatus  _VI_FUNC hpe1437_init(ViRsrc instrDesc, ViBoolean idQuery, ViBoolean rst, ViPSession id);
ViStatus  _VI_FUNC hpe1437_input_alias_filter(ViSession id, ViInt16 antiAlias);
ViStatus  _VI_FUNC hpe1437_input_alias_filter_get(ViSession id, ViPInt16 antiAliasPtr);
ViStatus  _VI_FUNC hpe1437_input_autozero(ViSession id);
ViStatus  _VI_FUNC hpe1437_input_coupling(ViSession id, ViInt16 coupling);
ViStatus  _VI_FUNC hpe1437_input_coupling_get(ViSession id, ViPInt16 couplingPtr);
ViStatus  _VI_FUNC hpe1437_input_float(ViSession id, ViInt16 floatIn);
ViStatus  _VI_FUNC hpe1437_input_float_get(ViSession id, ViPInt16 floatInPtr);
ViStatus  _VI_FUNC hpe1437_input_range(ViSession id, ViInt16 range);
ViStatus  _VI_FUNC hpe1437_input_range_auto(ViSession id, ViReal64 sec);
ViStatus  _VI_FUNC hpe1437_input_range_get(ViSession id, ViPInt16 rangePtr);
ViStatus  _VI_FUNC hpe1437_input_setup(ViSession id, ViInt16 range, ViInt16 coupling, ViInt16 antiAlias, ViInt16 signal, ViInt16 floatIn);
ViStatus  _VI_FUNC hpe1437_input_signal(ViSession id, ViInt16 signal);
ViStatus  _VI_FUNC hpe1437_input_signal_get(ViSession id, ViPInt16 signalPtr);
ViStatus  _VI_FUNC hpe1437_interrupt_mask_get(ViSession id, ViInt16 intrNum, ViPInt16 maskPtr);
ViStatus  _VI_FUNC hpe1437_interrupt_priority_get(ViSession id, ViInt16 intrNum, ViPInt16 priorityPtr);
ViStatus  _VI_FUNC hpe1437_interrupt_restore(ViSession id);
ViStatus  _VI_FUNC hpe1437_interrupt_setup(ViSession id,  ViInt16 intrNum,  ViInt16 priority, ViInt16 mask);
ViStatus  _VI_FUNC hpe1437_lbus_mode(ViSession id, ViInt16 lbusMode);
ViStatus  _VI_FUNC hpe1437_lbus_mode_get(ViSession id, ViPInt16 lbusModePtr);
ViStatus  _VI_FUNC hpe1437_lbus_reset(ViSession id, ViInt16 lbusReset);
ViStatus  _VI_FUNC hpe1437_lbus_reset_get(ViSession id, ViPInt16 lbusResetPtr);
ViStatus  _VI_FUNC hpe1437_meas_control(ViSession id, ViInt16 idle, ViInt16 sync);
ViStatus  _VI_FUNC hpe1437_meas_start(ViSession id);
#ifdef INSTR_REAL32
ViStatus  _VI_FUNC hpe1437_read(ViSession id, ViReal32 rec[], ViInt32 sampleCount, ViPInt16 overloadPtr);
#endif
ViStatus  _VI_FUNC hpe1437_read64(ViSession id, ViReal64 rec[], ViInt32 sampleCount, ViPInt16 overloadPtr);
ViStatus  _VI_FUNC hpe1437_read_raw(ViSession id, ViPInt16 dataPtr, ViInt32 wordCount);
ViStatus  _VI_FUNC hpe1437_reset(ViSession id);
ViStatus  _VI_FUNC hpe1437_revision_query(ViSession id,ViPString driverRev, ViPString instRev);
ViStatus  _VI_FUNC hpe1437_self_test(ViSession id, ViPInt16 testResultPtr, ViPString testMessage);
ViStatus  _VI_FUNC hpe1437_status_get(ViSession id, ViPInt16 statusPtr );
ViStatus  _VI_FUNC hpe1437_trigger_adclevel(ViSession id, ViInt16 adcLevel);
ViStatus  _VI_FUNC hpe1437_trigger_adclevel_get(ViSession id, ViPInt16 adcLevelPtr);
ViStatus  _VI_FUNC hpe1437_trigger_delay(ViSession id, ViInt32 delay);
ViStatus  _VI_FUNC hpe1437_trigger_delay_get(ViSession id, ViPInt32 delayPtr);
ViStatus  _VI_FUNC hpe1437_trigger_delay_actual_get(ViSession id, ViPReal64 actualDelayPtr);
ViStatus  _VI_FUNC hpe1437_trigger_gen(ViSession id, ViInt16 gen);
ViStatus  _VI_FUNC hpe1437_trigger_gen_get(ViSession id, ViPInt16 genPtr);
ViStatus  _VI_FUNC hpe1437_trigger_maglevel(ViSession id, ViInt16 magLevel);
ViStatus  _VI_FUNC hpe1437_trigger_maglevel_get(ViSession id, ViPInt16 magLevelPtr);
ViStatus  _VI_FUNC hpe1437_trigger_phase_capture(ViSession id);
ViStatus  _VI_FUNC hpe1437_trigger_phase_actual_get(ViSession id, ViPReal64 actualPhasePtr);
ViStatus  _VI_FUNC hpe1437_trigger_setup(ViSession id, ViInt16 tType, ViInt32 delay, ViInt16 adcLevel, ViInt16 magLevel, ViInt16 slope, ViInt16 gen);
ViStatus  _VI_FUNC hpe1437_trigger_slope(ViSession id, ViInt16 slope);
ViStatus  _VI_FUNC hpe1437_trigger_slope_get(ViSession id, ViPInt16 slopePtr);
ViStatus  _VI_FUNC hpe1437_trigger_type(ViSession id, ViInt16 tType);
ViStatus  _VI_FUNC hpe1437_trigger_type_get(ViSession id, ViPInt16 tTypePtr);
ViStatus  _VI_FUNC hpe1437_wait(ViSession id);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

#endif /* E1437_INCLUDED */

