/*

UserSCAN.h

  User parameters to be used with C library and DLL

  NOTE: Some of the following functions might not be available with your
  Signametrics product. This is a superset of all functions applicable to
  all of the SMX4030 series products. Look up in the manual for specific
  product related features to verify the availability of each functions.

*/
#ifdef __GNUC__         // KCC 2003/10/20
#include <signametrics/SmLinux.h>
#endif
#define ScanUser              /* set flag to indicate this file is read */
						

#ifndef MSWIN
	#define TRUE      1
	#define FALSE     0                                                           
#endif /* MSWIN */

/* Scanner type definitions */
#define SMX4030			4030
#define SMX4032			4032


/* Scanner predefined configurations definitions */
#define TwoWire			0X00
#define FourWire		0X07
#define TwoGroups		0X19
#define SixWire			0X1E
#define FourGroups		0X2A
#define Universal		0X33
#define ColdJunction	0X38	// Select Dbus, (connect Dbus to Abus)
#define Disabled		0X4C

/* Configuration relays definitions: used in conjuction with */
/* the SCANTestConfigRelay() SCANSetConfig() SCANGetConfig() */
#define  AtoA			1
#define  BtoA			2
#define  BtoB			3
#define  CtoA			5
#define  CtoC			6
#define  DtoD			7
#define  DtoC			8

/* Close and Open states */
/* used in SetConfigRelay() and SetChannelRelay() to set relay state */
#define CLOSE		'C'		// Same as 0X43
#define	OPEN		'O'		// Same as 0X4F

// temperature units for RTD temp. and On-board temp:
#define DEG_F		'F'		// Same as 0X46
#define DEG_C		'C'		// Same as 0X43

/* Trigger definition for SCANSetTriggerOut() and SCANSetTriggerIn() */
#define POSITIVE	1		// or Leading Edge
#define NEGATIVE	0       // or Trailing Edge
#define ENABLED		1		// Trigger Enabled
#define DISABLED	0		// Trigger Disabled                                                 
