/*
 * SM204032.H: SM2040,42,44 SCAN 32bit WINDOWS DLL CLIENT HEADER FILE
 *
 * COPYRIGHT (c) 1999, Signametrics, Corp.
 * ALL RIGHTS RESERVED
 *
 * Created Jan 22,1998
 * Change history:
 *	
 */

#ifdef __GNUC__		// KCC 2003/10/20
#include <signametrics/SmLinux.h>
#endif
#define SMX4032H 

// BK 6/2/10
#pragma GCC visibility push(default)

/*
 * Driver DLL Function Prototypes
 *
 * The "nDmm" parameter must be zero in the prototype interface.
 */
#ifdef __cplusplus
extern "C" {
#endif
int  WINAPI SCANInit(int nDmm);			/* init SCAN and read cal data, retunr Error code */
int  WINAPI SCANSetConfig(int nScan, int Config);
int  WINAPI SCANGetConfig(int nScan);
int  WINAPI SCANSelectChannel(int nScan, int Chan);
int WINAPI SCANSelectChannelCmd(int nScan, int Channel);	// Polled version of SCNASelectChannel()
int WINAPI SCANSetChannelRelay(int nScan, int State, int Channel);
int WINAPI SCANSetConfigRelay(int nScan, int State, int ConfRelay);
int  WINAPI SCANErrString(int nError, LPSTR lpcBuf, int nBufLen);
int  WINAPI SCANGetID(int nDmm);
int  WINAPI SCANGetGrdVer(int nDmm);
int  WINAPI SCANGetVer(int nDmm, double *lpdVer);
BOOL  WINAPI SCANReady(int nDmm);
int  WINAPI SCANDelay(double dDelay);
BOOL  WINAPI SCANIsInitialized(int nDmm);
BOOL  WINAPI SCANTerminate(int nDmm);
int  WINAPI SCANDisArmTrigger(int nDmm);
int  WINAPI SCANGetType(int nDmm);
int WINAPI SCANTriggerOutState(int nScan, int State, int Polarity);
int WINAPI SCANTriggerInState(int nScan, int State, int Polarity);
int WINAPI SCANSetActuationTime(int nScan, double tActuate);
int WINAPI SCANGetActuationTime(int nScan, double *lpfActuateTime);
int WINAPI SCANGetShortedChannel(int nScan);
int WINAPI SCANCleanRelays(int nScan);
int WINAPI SCANTestChannelRelay(int nScan, int Channel, double *lpdSettle);
int WINAPI SCANTestChanIntegrity(int nScan, int Channel);
int WINAPI SCANTestConfigRelay(int nScan, int ConfigRelay, double *lpdT);
int WINAPI SCANTrigScan(int nScan, int nPoints);
int WINAPI SCANSetStepTime(int nScan, double tActuate);
int WINAPI SCANGetStepTime(int nScan, double *lpfStep);
int WINAPI SCANSetScanList(int nScan, int address, int data);
int WINAPI SCANGetScanList(int nScan, int address);
int WINAPI SCANAutoScan(int nScan, int nPoints);
int  WINAPI SCANGetManDate(int nScan, int *month, int *day, int *year);
int  WINAPI SCANGetHwVer(int nScan);
int WINAPI SCANSetupStep(int nScan);
int WINAPI SCANStep(int nScan);
int WINAPI SCANStepCmd(int nScan);
int WINAPI SCANGetTriggerIn(int nScan);
int WINAPI SCANSetTriggerOut(int nScan, int Level);
int WINAPI SCANTrigAutoScan(int nScan, int nPoints);
int WINAPI SCANAbort(int nScan);
int WINAPI SCANOpenAllChannels(int nScan);
int WINAPI SCANGetBusInfo(int nScan, int *bus, int *slot);
int WINAPI SCANOpenPCI(int nScan);
int WINAPI SCANClosePCI(int nScan);
int WINAPI SCANIsOpenPCI(int nScan);

#ifdef __cplusplus
}
#endif

/*
 * Error codes returned by SCAN_ functions.
 */
#define	SCAN_OKAY		0		/* no error */
#define	SCAN_E_INIT		-1		/* Error: Scanne not initialized */ 
#define	SCAN_E_IO		-2		/* Error: SCAN not responding to basic I/O operations  */
#define	SCAN_NOT_FOUND		-3		/* Error: SCAN Not found on PCI bus */
#define SCAN_ERR_HW_INIT     -4		/* Error: can't access Scanner H/W */
#define SCAN_ID_HW_ERR       -5		/* Error: Can't read ID from SCAN  */
#define SCAN_GUARD_COM       -6		/* Error: Communication error with SCAN uP */      
#define SCAN_TIMEOUT		    -7		/* Error: A communication process time-out */
#define SCAN_GUARD_XING		-8		/* Error: Optical Guard crossing is broken */
#define SCAN_CONTROLR_COM	-9		/* Error: Microcontroller communication error */
#define SCAN_OVERRUN			-10		/* Error: General Communication error */
#define SCAN_FRAME			-11		/* Error: Commincation Frame error */
#define SCAN_RCV_FIFO		-12		/* Error: Communication FIFO Receiver error */
#define SCAN_PARITY			-13		/* Error: Communication parity error */
 // PCI class of errors.
#define SCAN_CANT_OPEN_PCI	-14		/* Error: Can't open Scanner PCI device. May be in use */
#define  SCAN_PCI_ITEMS		-15		/* Error: SCANNER Driver does not have all PCI items. */


/*
 * Warning codes returned by SCAN_ functions.
 */
#define	TEST_CONNECT	101		/* Warning: Test Connector is required */
#define	OPEN_RELAY		102		/* Warning: Relay open fail */
#define	SHORT_RELAY		103		/* Warning: Relay short fail (both contacts) */
#define	BOUNCE_RELAY	104		/* Warning: Relay accessive bounce */
#define	STUCK_OPEN		105		/* Warning: Relay stuck open fail */
#define	LOW_ACTUATION	106		/* Warning: Insufficinte actuation time */
#define	LOW_RELEASE		107		/* Warning: Insufficinte release time */
#define STUCK_SHORT		108     /* Warning: Relay stuck shorted */
#define	WRONG_CONFIG	109		/* Warning: Invalid Configuration */
#define	TYPE_PARAM		110		/* Warning: Wrong Parameter for Scanner type  */
#define	SCAN_E_IS_INIT	111		/* Warning: Already initialized */
#define SCAN_WRONG_TYPE		112		/* Warning: Wrong type read from H/W */
#define SCAN_ERR_PARAMETER   113		/* Warning: wrong parameter value */                                                                              
#define FUNC_UNABLE     114		/* Warning: Function not available */      
// BK 6/2/10
#pragma GCC visibility pop

#define	SCAN_E_N	    -39		/* The total number of warnings & errors */
