#!/bin/bash

# install the libSMX403X.so library into the system directories 
# with an appropriate soname according to the release version

# su privelages are required to run this script

EXEC_PATH=$(dirname $0)

VERSION_FILE=$EXEC_PATH/.version

if [ -e $VERSION_FILE ] 
then
    . $VERSION_FILE
    
    LIB_INSTALL_DIR=/usr/lib
    INCLUDE_INSTALL_DIR=/usr/include/signametrics
    LIB_NAME=libSMX403X.so
    SO_NAME=$LIB_NAME.$MAJOR_NUMBER
#    REAL_NAME=$SO_NAME.$MINOR_NUMBER
    REAL_NAME=$SO_NAME.$MINOR_NUMBER.$BUILD_NUMBER

    cp $EXEC_PATH/lib/$LIB_NAME $LIB_INSTALL_DIR/$REAL_NAME
    cp $EXEC_PATH/lib/libSMX403X.a $LIB_INSTALL_DIR/

    rm -f $LIB_INSTALL_DIR/$SO_NAME
    rm -f $LIB_INSTALL_DIR/$LIB_NAME

    ln -s $LIB_INSTALL_DIR/$REAL_NAME $LIB_INSTALL_DIR/$SO_NAME
    ln -s $LIB_INSTALL_DIR/$SO_NAME $LIB_INSTALL_DIR/$LIB_NAME

    ldconfig -n $LIB_INSTALL_DIR

    mkdir -p $INCLUDE_INSTALL_DIR

    cp $EXEC_PATH/include/ScanUser.h $INCLUDE_INSTALL_DIR
    cp $EXEC_PATH/include/smx4032.h $INCLUDE_INSTALL_DIR
    cp $EXEC_PATH/include/SmLinux.h $INCLUDE_INSTALL_DIR

else
    echo "Unable to open file '$VERSION_FILE'"
    echo "Exiting without installing"
fi


