#include <ScanUser.h>
#include <smx4032.h>

int main(int argc, char *argv[])
{
	int iScan = 0;
	int err;
	int i;
	double version;

	if (argc == 2) {
		iScan = strtol(argv[1], NULL, 0);
		if (iScan < 0) {
			perror("strtol");
			exit(1);
		}
	} else {
		iScan = 0;
	}

	SCANGetVer(iScan, &version);
	printf("Switch Driver Version %.5f\n", version);

	err = SCANInit(iScan);
	if (err) {
		fprintf(stderr, "SCANInit: Initialization ERROR\n");

        char str[100];
        SCANErrString(err, str,100);
        fprintf(stderr,"returned error %d, %s\n",err, str);
        fprintf(stderr,"ABORTING\n");

		exit(1);
	}

	SCANSetConfig(iScan, TwoWire);	// Set to TwoWire configuration

	for (i=1; i<=35; ++i) {
	//	usleep(50000);
		SCANSelectChannel(iScan, i);    
	}

	exit (0);
}
