/*
 *   Copyright 2011, Agilent Technologies. All rights reserved.
 *
 *   Definitions of PCI DEVICE, VENDOR, AND SUBSYSTEM constants for 
 *   M918X devices.
 *
 */

#ifndef _M918X_SMX_H
#define _M918X_SMX_H

#ifdef __cplusplus
extern "C" {
#endif

/* PCI form factor */
#define SM204X_VENDOR_ID			0x10B5
#define SM204X_DEVICE_ID			0x9050

#define SM204X_SUBSYSTEM_VENDOR_ID  SM204X_VENDOR_ID
#define SM2040_SUBSYSTEM_ID			0x2136
#define SM2042_SUBSYSTEM_ID			0x2137
#define SM2044_SUBSYSTEM_ID			0x2139

/* cPCI/PXI form factor */
#define SMX204X_VENDOR_ID			0x173D
#define SMX204X_DEVICE_ID			0x2040

#define SMX204X_SUBSYSTEM_VENDOR_ID SMX204X_VENDOR_ID
#define SMX2040_SUBSYSTEM_ID		0x2136
#define SMX2042_SUBSYSTEM_ID		0x2137
#define SMX2044_SUBSYSTEM_ID		0x2139

/* SMX206X cPCI/PXI form factor */
#define SMX206X_VENDOR_ID			0x173D
#define SMX206X_DEVICE_ID			0x2060

#define SMX206X_SUBSYSTEM_VENDOR_ID	SMX206X_VENDOR_ID
#define SMX2055_SUBSYSTEM_ID		0x2055
#define SMX2060_SUBSYSTEM_ID		0x2060
#define SMX2062_SUBSYSTEM_ID		0x2062
#define SMX2064_SUBSYSTEM_ID		0x2064

/* M918X cPCI/PXI form factor */
#define AGILENT_VENDOR_ID		0x15BC

#define M9181_DEVICE_ID			0x1265
#define M9182_DEVICE_ID			0x1266
#define M9183_DEVICE_ID			0x1267

/* PCI switch */
#define SM404X_VENDOR_ID			0x10B5
#define SM404X_DEVICE_ID			0x9052
#define SM404X_SUBSYSTEM_VENDOR_ID	SM404X_VENDOR_ID
#define SM4020_SUBSYSTEM_ID			0x2259
#define SM4022_SUBSYSTEM_ID			0x2260
#define SM4040_SUBSYSTEM_ID			0x2261
#define SM4042_SUBSYSTEM_ID			0x2262

/* PXI switch */
#define SMX403X_VENDOR_ID			0x173D
#define SMX403X_DEVICE_ID			0x4032
#define SMX403X_SUBSYSTEM_VENDOR_ID	SMX403X_VENDOR_ID
#define SMX4030_SUBSYSTEM_ID		0x4030
#define SMX4032_SUBSYSTEM_ID		0x4032

#ifdef __cplusplus
}
#endif


#endif /* _M918X_SMX_H */

