/*
 *   Copyright 2011, Agilent Corporation. All rights reserved.
 *
 *   Definitions of values used by the M918X kernel module that are
 *   also needed in userspace code that accesses the driver.  
 *
 */

#ifndef _M918X_USER_H
#define _M918X_USER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "M918X_version.h"


// not sure where this shows up in the kernel
#define M918X_DRIVER_NAME "M918X"

#define M918X_DEVICE_NAME "M918X"

//  0xBB was picked for the magic number because it was listed as unused
//  in the kernel documentation file ioctl-number.txt
#define M918X_IOC_MAGIC 0xBB

// The prefix M918X_DMM_ is used in place of M918X_ in the following definitions
// to indicate values that are not the same with the SMX403X series switches.  
#define M918X_IOC_SLOT _IOR(M918X_IOC_MAGIC, 1, char[64])
#define M918X_DMM_IOC_VENDORID _IO(M918X_IOC_MAGIC, 2)
#define M918X_DMM_IOC_DEVICETYPE _IO(M918X_IOC_MAGIC, 3)
#define M918X_DMM_IOC_SERIAL_MANDATE _IO(M918X_IOC_MAGIC, 4)
#define M918X_DMM_IOC_HWVERSION_OPTCODE _IO(M918X_IOC_MAGIC, 5)
#define M918X_DMM_IOC_MANUF_COUNTRY _IO(M918X_IOC_MAGIC, 6)
#define M918X_DMM_IOC_PCI_BAR2_OFFSET _IO(M918X_IOC_MAGIC, 7)

#define M918X_IOC_MAXNR 7


#define SIGNAMET_DRIVER_NAME M918X_DRIVER_NAME
#define SIGNAMET_DEVICE_NAME M918X_DEVICE_NAME 

#define SIGNAMET_IOC_MAGIC M918X_IOC_MAGIC

#define SIGNAMET_IOC_SLOT M918X_IOC_SLOT
#define SIGNAMET_IOC_SERIAL _IO(SIGNAMET_IOC_MAGIC, 2)
#define SIGNAMET_IOC_SUBSYS_DEVTYPE _IO(SIGNAMET_IOC_MAGIC, 3)
#define SIGNAMET_IOC_HW_VERSION _IO(SIGNAMET_IOC_MAGIC, 4)
#define SIGNAMET_IOC_PCI_BAR2_OFFSET _IO(SIGNAMET_IOC_MAGIC, 5)

#define SIGNAMET_IOC_MAXNR 5
#ifdef __cplusplus
}
#endif
#endif				/* _M918X_USER_H */
