/*
 *   Copyright 2011, Agilent Technologies. All rights reserved.
 *
 *   Definition of the version of the current driver, and its shared libraries.  
 *  
 */

#ifndef _M918X_VERSION_H
#define _M918X_VERSION_H

// the version of the driver, and its associated user libraries, as three integer values.  
// the major and minor versions are used to track the version of the shared libraries. 
// all three numbers are included in the name of the release.  
//
// These values are parsed by the update_version.sh script, which is called when a new user 
// library is compiled.  update_version.sh places the valuses in a .version file which is used by 
// the rest of the installation scripts
// 
#define M918X_DRIVER_MAJOR 1
#define M918X_DRIVER_MINOR 0
#define M918X_DRIVER_BUILD 16

// M918X_DRIVER_VERSION is used by DMMGetVer on the user side 
// libraries, which uses a single double value to represent the version 
// 1.08002 = 1.08.2
#define M918X_DRIVER_VERSION (M918X_DRIVER_MAJOR + M918X_DRIVER_MINOR / 100.0 + M918X_DRIVER_BUILD / 100000.0)

#endif /* _M918X_VERSION_H */
