/******************************************************************************
 *                                                                         
 * Copyright 2011 Agilent Technologies. All rights reserved.
 *
 *****************************************************************************/
/*
 *
 *  DMMUser.h
 *
 *  COPYRIGHT (c) 2007, Signametrics, Corp.
 *  ALL RIGHTS RESERVED
 *
 *  User parameters to be used with C library and DLL
 *
 *  NOTE: Some of the following measurement and stimulus functions might not
 *  be available with your product. This is a superset of all
 *  functions and ranges which is applicable to all of the SM206X series of
 *  products. Look up in the manual for the product you have to verify the
 *  availability of these functions.
 *
 */

#ifndef DMMUser
#define DMMUser              /* set flag to indicate this file is read */
						

#ifndef MSWIN
	#define TRUE      1
	#define FALSE     0                                                           
#endif /* MSWIN */

/* DMM  COMPOSIT FUNCTION (combined function and range) definitions */
/* used in DMMSetFuncRange() and DMMGetFuncRange() */
/* VDC */
#define  VDC_240mV     0		// Volts DC 240mV range
#define  VDC_2400mV    1		// Volts DC 2.4 range
#define  VDC_24V       2		// Volts DC 24V range
#define  VDC_240V      3		// Volts DC 240V range
#define  VDC_330V      4		// Volts DC 330V range
/* VAC */
#define  VAC_240mV     5		// Volts AC 240mV range
#define  VAC_2400mV    6		// Volts AC 2.4 range
#define  VAC_24V       7		// Volts AC 24V range
#define  VAC_240V      8		// Volts AC 240V range
#define  VAC_330V      9		// Volts AC 330V range
/* IAC */
#define  IAC_2400uA    10		// Current AC 2.4mA range
#define  IAC_24mA      11		// Current AC 24mA range
#define  IAC_240mA     12		// Current AC 240mA range
#define  IAC_2400mA    13		// Current AC 2.4A range
/* IDC */
#define  IDC_240nA		14		// Current DC 240nA range (2064 models)
#define  IDC_2400nA		15		// Current DC 2.4uA range (2064 models)
#define  IDC_24uA		16		// Current DC 24uA range (2064 models)
#define  IDC_240uA		17		// Current DC 240uA range (2064 models)
#define  IDC_2400uA		18		// Current DC 2.4mA range
#define  IDC_24mA		19		// Current DC 24mA range
#define  IDC_240mA		20		// Current DC 240mA range
#define  IDC_2400mA		21		// Current DC 2.4A range
/* 4-Wire Ohms */
#define  OHM_4W_24		22		// 4 Wire 24 Ohms range
#define  OHM_4W_240		23		// 4 Wire 240 Ohms range
#define  OHM_4W_2400	24		// 4 Wire 2.4k Ohms range
#define  OHM_4W_24K		25		// 4 Wire 24k Ohms range
#define  OHM_4W_240K	26		// 4 Wire 240k Ohms range
#define  OHM_4W_2400K	27		// 4 Wire 2.4M Ohms range
#define  OHM_4W_24MEG	28		// 4 Wire 24M Ohms range
/* 2-Wire Ohms */
#define  OHM_2W_24		29		// 2 Wire 24 Ohms range
#define  OHM_2W_240		30		// 2 Wire 240 Ohms range
#define  OHM_2W_2400	31		// 2 Wire 2.4k Ohms range
#define  OHM_2W_24K		32		// 2 Wire 24k Ohms range
#define  OHM_2W_240K	33		// 2 Wire 240k Ohms range
#define  OHM_2W_2400K	34		// 2 Wire 2.4M Ohms range
#define  OHM_2W_24MEG	35		// 2 Wire 24M Ohms range
#define  OHM_2W_240MEG	36		// 2 Wire 240M Ohms range
/* Diodes */
#define	 DIODE_100n		37		//Test current = 100nA
#define	 DIODE_1u		38		// 1uA
#define	 DIODE_10u		39		// 10uA
#define	 DIODE_100u		40		// 100uA
#define	 DIODE_1m		41		// 1mA
#define	 DIODE_10m		42		// 10mA (2064 only)
// All functions below are only for 2064 type DMM.
// Module internal temperature sensor
#define	 LOCAL_TEMP		43		// Board temperature measure
/* Ramp type Capacitance */
#define  CAPS_1200p		44		// 1,200pF range
#define  CAPS_12n		45		// 12,000pF range
#define  CAPS_120n		46		// 0.12uF range
#define  CAPS_1200n		47		// 1.2uF range
#define  CAPS_12u		48		// 12uF range
#define  CAPS_120u		49		// 120uF range
#define  CAPS_1200u		50		// 1,200uF
#define  CAPS_12m		51		// 12,000uF
// RTD Types. Resistance 4 wire config. Set Ro parameters
// to be set using DMMSetRTD(nDmm, Rzero)
#define  pt385			52		// pt385 RTD
#define	 pt3911			53		// pt3911 RTD
#define  pt3916			54		// pt3916 RTD
#define	 pt3926			55		// pt3926 RTD
#define	 cu				56		// 10 or 100 Ohms Copper RTD
// VDC source
#define  VDCSource		57		// VDC source 0 to +/-10V
// VAC source
#define  VACSrc900mV	58		// VAC source 0 to 3.3V RMS
#define  VACSrc8V		59		// VAC source 0 to 7.25 RMS (20V p-p)
// DC Current source ranges. User DMMSetIDCSource() to set value
#define  IDCSource1200n	60		// IDC source 1.25uA
#define  IDCSource12u	61		// IDC source 12.5uA
#define  IDCSource120u	62		// IDC source 125uA
#define  IDCSource1200u	63		// IDC source 1.25mA
#define  IDCSource12m	64		// IDC source 12.5mA
// Leakage test with variable Voltage 
#define  Leak240n		65		// Leakage 240nA range, 0 to +/-10V source
#define  Leak2400n		66		// Leakage 2.4uA range, 0 to +/-10V source
#define  Leak24u		67		// Leakage 24uA range, 0 to +/-10V source
// Inductance Function
#define  Induct33u		68	// 33uH range for inductors
#define  Induct330u		69	// 330uH range for inductors
#define  Induct3300u	70	// 3.3mH range for inductors
#define  Induct33m		71	// 33mH range for inductors
#define  Induct330m		72	// 330mH range for inductors
#define  Induct3300m	73	// 3.3H range for inductors
//
#define  VsourceIsense	74	// Source 0 to +/-10V and measure upto 24mA. Uses the two red terminals.
//
// Extended Ohms ranges using the three internal shunts as current limiters
#define  ExOhms400k	75	// 400k range with 24uA current limit
#define  ExOhms4M	76	// 4Meg range with 2.4uA  current limit
#define  ExOhms40M	77	// 40Meg range with 240nA current limit
//

#define  ThermoCouple	81	// Thermocouples
// AC based capacitance measurement function
#define  AC_Cap24n		82	// AC based capacitance 24nF range
#define  AC_Cap240n		83	// AC based capacitance 240nF range
#define  AC_Cap2400n	84	// AC based capacitance 2.4uF range
#define  AC_Cap24u		85	// AC based capacitance 24uF range
#define  AC_Cap240u		86	// AC based capacitance 240uF range
#define  AC_Cap2400u	87	// AC based capacitance 2,400uF range
// miscelleneous functions
#define  Pulse_Gen		88	// Freee running Pulse generator 
#define  MsrRin			91	// Measure 10Meg input divider. Open all terminals
#define  SrceV_MsrI		98	// Source 0 to +/-10V and measure upto 24mA.
#define  MsrER			100	// Measure a series RC R value.

// Setting source mode to closed loop or open loop, for both,
// VDCSource function. For use with DMMSetSourceMode()
#define CLOSED_LOOP		'C'
#define	OPEN_LOOP		'O'
// temperature units for RTD temp. and On-board temp:
#define DEG_F		'F'
#define DEG_C		'C'
// RTD Connection type: 4-Wire or 3-Wire (3-Wire not implemented)
#define RTD_4_W			4
#define RTD_3_W			3

/*
 * Function values for use with DMMSetFunction() and DMMGetFunction()
 */
#define VDC				VDC_240mV		// 0	DC Volts
#define VAC				VAC_240mV		// 5	AC Volts
#define IAC				IAC_2400uA		// 10	AC Current
#define IDC				IDC_240nA		// 14	DC Current
#define OHMS4W			OHM_4W_24		// 22	4-Wire resistance
#define OHMS2W			OHM_2W_24		// 29	2-Wire resistance
#define DIODE			DIODE_100n		// 37	Diode test
#define TEMP_LCL		LOCAL_TEMP		// 43	DMM Internal temperature
#define CAPS			CAPS_1200p		// 44	Capacitance
#define RTD				pt385			// 52	4-Wire RTD
#define VDC_SRC			VDCSource		// 57	Source DC Voltage
#define VAC_SRC			VACSrc900mV		// 58	Source AC Voltage
#define IDC_SRC			IDCSource1200n	// 60	Source DC Current
#define LEAKAGE			Leak240n		// 65	Leakage test
#define INDUCTANCE		Induct33u		// 68	Inductance
#define VDCSRC_IDCSNS	VsourceIsense	// 74	Low range Source/Measure - Unspecified.
#define	EXTEND_OHMS		ExOhms400k		// 75	Extended Ohms
#define THERMO_COUPLE	ThermoCouple	// 81	Thermocouple Temperature
#define AC_CAPS			AC_Cap24n		// 82	In-Circuit Capacitance
#define PULSE_GEN		Pulse_Gen		// 88	Pulse Generator - At user's risk. No specifications !
#define RinMeasure		MsrRin			// 91	Measure high V 10Meg input divider resistance (open terminals)
#define	SRC_V_MSR_I		SrceV_MsrI		// 98   Source VDC to +/-10V & measure IDC to +/-24mA
#define	ESR				MsrER			// 100  Measures the ESR of a capacitor (Equivalent Series Resistance)


// Allowed range values for each function for use with DMMSetRange()
// AC and DC Volts
#define  _240mV    0   // five DCV ranges
#define  _2400mV   1
#define  _24V      2
#define  _240V     3
#define  _330V     4
// AC Current
#define  _2400uAAC   0		// 2.4mA
#define  _24mAAC     1		// 24mA
#define  _240mAAC    2
#define  _2400mAAC   3		// 2.4A
// DC Current
#define  _240nA		0		// 240nA (2064 type)
#define  _2400nA	1		// 2.4uA (2064 type)
#define  _24uA		2		// 24uA (2064 type)
#define  _240uA		3		// 240uA (2064 type)
#define  _2400uA	4		// 2.4mA
#define  _24mA		5		// 24mA
#define  _240mA		6		// 240mA
#define  _2400mA	7		// 2.4A
// 2 Wire and 4 Wire Ohms
#define  _24       0		// 24 Ohms range (2064 only)
#define  _240      1
#define  _2400     2
#define  _24k      3
#define  _240k     4
#define  _2400k    5
#define  _24MEG    6
#define  _240MEG   7		// 2-Wire, 2064 type only
// Diode test
#define	 _D100n		0		//Test current = 100nA
#define	 _D1u		1		// 1uA
#define	 _D10u		2		// 10uA
#define	 _D100u		3		// 100uA
#define	 _D1m		4		// 1mA
#define	 _D10m		5		// 10mA (2064 only)
//  Capacitance: Ramp type
#define  _1200p		0		// 1,200pF range
#define  _12n		1		// 12nF
#define  _120n		2		// 120nF
#define  _1200n		3		// 1.2uF
#define  _12u		4		// 12uF
#define  _120u		5		// 120uF
#define  _1200u		6		// 1,200uF
#define  _12m		7		// 12,000uF
//  Capacitance: AC Based Caps.
#define  _10n      0	// 0.01uF (10nF)
#define  _100n     1	// 0.1uF
#define  _1u       2
#define  _10u      3	// 10uF
#define  _100u     4
#define  _1m       5
#define  _10m      6
// 4-wire RTDs: five basic types. No auto-ranging allowed
// Use DMMSetRTD to modify the default Ro form 100 Ohms
#define  _pt385		0	// pt385 100 ohms
#define	 _3911		1	// pt3911 100 ohms
#define  _3916		2	// pt3916 100 ohms
#define  _3926		3	// pt3926 100 ohms
#define  _cu		4	// copper 9.035 Ohms
//  VAC Source two ranges
#define  _900mVsrc	0	// selectes the 900mV AC source range
#define  _8Vsrc		1	// selects the 8V AC source range

//  IDC Source five ranges
#define  _1uA      0 
#define  _10uA     1   // 10uA source (to 12.5uA)
#define  _100uA    2
#define  _1mA      3
#define  _10mA     4	// 10mA source (to 12.5mA)
//  Inductance measurements: six ranges
#define  _33uH     0 
#define  _330uH    1
#define  _3300uH   2 
#define  _33mH     3
#define  _330mH    4
#define  _3300mH   5
//  Extended Resistance ranges
#define  _400k		0 
#define  _4M		1
#define  _40M		2 

/*
 * Valid DMM (APERTURES) reading rate values. For use with DMMSetAperture()
 * The Aperture is the integration time of the A/D. For line cycle
 * rejection, the Apreture should be an integral number of line cycles.
 */
#define	APR_5p066s		0		// 5.0666s apreture, 60Hz rejection (~0.2rps)
#define	APR_5p12s		1		// 5.1200s aperture, 50Hz rejection (~0.2rps) 256PLC
#define	APR_2s			2		// 2.0s aperture, 60Hz rejection (~0.5rps) 120PLC
#define	APR_2p08s		3		// 2.080s aperture, 50Hz rejection (~0.5rps) 104PLC
#define	APR_1p0666s		4		// 1.06666s aperture, 60Hz rejection (~1rps)  64PLC
#define	APR_p96s		5		// 960ms aperture, 50Hz rejection (~1rps)  48PLC
#define	APR_p5333s		6		// 533.33ms aperture, 60Hz rejection (~2rps)  32PLC
#define	APR_p48s		7		// 480ms aperture, 50Hz rejection (~2rps)  24PLC
#define	APR_p2666s		8		// 266.666ms aperture, 60Hz rejection (~4rps)
// For Trigger Operations and all measurements involving the DMM buffer,
// the Aperture must be set between APR_p16s (160ms) and APR_2p5us (2.5us)
#define	APR_p16s		9		// 160.0ms aperture, 50Hz rejection (~6rps) 8PLC
#define	APR_p1333s		10		// 133.33ms aperture, 60Hz rejection (~8rps) 8PLC
#define	APR_80ms		11		// 80.00ms aperture, 50Hz rejection (~13rps) 4PLC
#define	APR_66p67ms		12		// 66.6667ms aperture, 60Hz rejection (~15rps) 4PLC
#define	APR_40ms		13		// 40.00ms aperture, 50Hz rejection (~25rps) 2PLC
#define	APR_33p33ms		14		// 33.333ms aperture, 60Hz rejection (~30rps) 2PLC
#define	APR_20ms		15		// 20.00ms aperture, 50Hz rejection (~50rps) 1PLC
#define	APR_16p67ms		16		// 16.6667ms aperture, 60Hz rejection (~60rps) 1PLC
#define	APR_10ms		17		// 10ms aperture, 400Hz rejection (~100rps)
#define	APR_8p333ms		18		// 8.333ms aperture (~120rps)
#define	APR_5ms			19		// 5ms aperture, 400Hz rejection
#define	APR_4p167ms		20		// 4.16667ms aperture
#define	APR_2p5ms		21		// 2.5ms aperture, 400Hz rejection
#define	APR_2p08ms		22		// 2.0833ms aperture
#define	APR_1p25ms		23		// 1.25ms aperture,
#define	APR_1p04ms		24		// 1.0417ms aperture
#define	APR_625us		25		// 625us aperture, Resolution Break Point and minimum aperture of SM2060
#define	APR_521us		26		// 520.83us aperture SM2064 only.
#define	APR_313us		27		// 312.5us aperture SM2064 only.
#define	APR_260us		28		// 260.42us aperture SM2064 only.
#define	APR_130us		29		// 130.21us aperture SM2064 only.
#define	APR_2p5us		30		// 2.5us aperture SM2064 only.


/*
 * SMX2055 DMMSetRate() parameters
 */
#define	RATE_1		1		// 1rps with 60Hz line rejection
#define	RATE_2		2		// 2rps with 50Hz line rejection
#define	RATE_3		3		// 3rps with 60Hz line rejection
#define	RATE_7		7		// 7rps with 50Hz line rejection
#define	RATE_14		14		// 14rps with 60Hz line rejection
#define	RATE_27		27		// 27rps with 50Hz rejection
#define	RATE_55		55		// 54rps with 60Hz rejection
#define	RATE_100	100		// 100rps with 50Hz rejection

/* Totalizer function definition */
#define LEADING		1
#define TRAILING	0      

/* Frequency counter Range definitions for DMMSetCounterRng() function */
#define	COUNTR_20HZ		7	// 1.0 Hz to 19.9Hz range (select 20Hz range)
#define	COUNTR_130HZ	6	// 19.9 Hz to 128.8Hz range
#define	COUNTR_640HZ	5	// 128.8Hz to 640Hz range
#define	COUNTR_2500HZ	4	// 640Hz to 2.56kHz range
#define	COUNTR_10kHZ	3	// 2.56kHz to 10.24kHz range
#define	COUNTR_40kHZ	2	// 10.24kHz to 40.96kHz range
#define	COUNTR_200kHZ	1	// 40.96kHz to 200 kHz range
#define	COUNTR_500kHZ	0	// 200.0kHz to 500 kHz range

// Thermocouple type definitions:
// for use with the DMMSetTCType() function.
#define BType		'B'
#define EType		'E'
#define JType		'J'
#define KType		'K'
#define NType		'N'
#define RType		'R'
#define SType		'S'
#define TType		'T'


#endif                                                   
