/*
 * COPYRIGHT (c) 2011, Agilent Technologies
 * ALL RIGHTS RESERVED
 *
 * SMX2060.H: SMX2055,SMX2060, SMX2064 DMM 32bit WINDOWS DLL CLIENT HEADER FILE
 *
 * For use with version SM2060.dll version 2.00 or greater.  This version allows
 * for legacy compatible use of Agilent M9181, M9182, M9183 DMMs alongside Signametrics
 * SMX206X series DMMs.  
 */

#ifndef SMX2060
#define SMX2060 

// BK 12/7/07 for linux
#ifdef __GNUC__
#include <M918X_Linux.h>
#endif /* __GNUC__ */

// BK 6/2/10
#pragma GCC visibility push(default) 

/*
 * Driver DLL Function Prototypes
 *
 * The "nDmm" parameter must be zero in the prototype interface.
 */
#ifdef __cplusplus
extern "C" {
#endif

int  WINAPI DMMInit(int nDmm, LPCSTR lpszCal);			/* init DMM and read cal data, retunr Error code */
int WINAPI DMMOpenPCI(int nDmm);
int WINAPI DMMSetSourceMode(int nDmm, int mode);
int WINAPI DMMGetSourceMode(int nDmm);
int  WINAPI DMMSetAperture(int nDmm, int nAperture);		/* set DMM Measurement Aperture. Lookup values in dmmuser.h */
int  WINAPI DMMSetFuncRange(int nDmm, int nFnRange);	/* set DMM function & range */
int  WINAPI DMMRead(int nDmm, double  *lpfValue);	/* read a single DMM measurement */
int  WINAPI DMMSetAutoRange(int nDmm, int bAuto);		/* control DMM auto-range mode, default: no autorange */
int  WINAPI DMMErrString(int nError, LPSTR lpcBuf, int nBufLen);	/* return DMM error strinb associated with nError */
int  WINAPI DMMReadStr(int nDmm, LPSTR lpszReading);	/* return DMM reading as string */
int  WINAPI DMMSetFunction(int nDmm, int nFunction);	/* set DMM function */
int  WINAPI DMMSetRange(int nDmm, int nRange);			/* set DMM range */
int  WINAPI DMMSetRelative(int nDmm, int bRelative);	/* set DMM relative mode TRUE/FALSE */
int  WINAPI DMMGetRange(int nDmm);                      /* return the DMM current range */
int  WINAPI DMMGetAperture(int nDmm, double  *lpdRate);  /* return the Measurement rate value */
int  WINAPI DMMReadNorm(int nDmm, double  *lpdRes);  /* make a measurement and return value at base units */
int  WINAPI DMMGetFuncRange(int nDmm);                  /* return combined function/range code */
int  WINAPI DMMGetFunction(int nDmm);                   /* return function */
int  WINAPI DMMIsAutoRange(int nDmm);                  /* return autorange status */
int  WINAPI DMMCalibrate(int nDmm);                     /* Self calibrate DMM */
int  WINAPI DMMGetID(int nDmm);                         /* Get card ID/serial number */
int  WINAPI DMMGetGrdVer(int nDmm);                     /* Get guarded S/W version code */
int  WINAPI DMMGetVer(int nDmm, double  *lpdVer);    /* Get main S/W version */ 
int  WINAPI DMMIsRelative(int nDmm);                   /* return relative flag state */
int  WINAPI DMMReadPeriod(int nDmm, double  *lpdRes); /* read DMM counter period (while in AC) */
int  WINAPI DMMReady(int nDmm);							// Test for DMM ready status following Trigger Event
int  WINAPI DMMReadFrequency(int nDmm, double  *lpdFreq); // Make a single frequency measurement
int  WINAPI DMMFrequencyStr(int nDmm, LPSTR lpszReading);	// Make a single freq. measure, return string
int  WINAPI DMMPeriodStr(int nDmm, LPSTR lpszReading); // Make a single period measure, return string
int  WINAPI DMMArmTrigger(int nDmm, int nSamples);		// Arm H/W trigger. DMM will wait till event, or Disarm command
int  WINAPI DMMReadBuffer(int nDmm, double  *lpdRes); // Read single entry of Capture buffer, following DMMReady()
int  WINAPI DMMArmAnalogTrigger(int nDmm, int nSamples, double dLevel); // Arm threshold trigger
int  WINAPI DMMReadBufferStr(int nDmm, LPSTR lpszReading); // string version of DMMReadBuffer()
int  WINAPI DMMTrigger(int nDmm, int nSamples);			/* soft trigger */
int  WINAPI DMMIsInitialized(int nDmm); /* is it ready */
int  WINAPI DMMTerminate(int nDmm);					// Disable a DMM in multiple DMM system
int  WINAPI DMMGetCalDate(int nDmm, LPSTR lpszDate);	// Return date of last calibration
int  WINAPI DMMDisarmTrigger(int nDmm);					// Abort current trigger operation
int  WINAPI DMMGetMin(int nDmm, double  *lpfRes);	// Read Min reading value
int  WINAPI DMMGetMax(int nDmm, double  *lpfRes);	// Read Max reading value
int  WINAPI DMMGetMinStr(int nDmm, LPSTR lpszReading);	// String version of DMMReadMin
int  WINAPI DMMGetMaxStr(int nDmm, LPSTR lpszReading);	// String version of DMMReadMax
int  WINAPI DMMClearMinMax(int nDmm);					// Reset Min/Max values
int  WINAPI DMMReadWidth(int nDmm, int iPol, double  *lpdNeg); // read pulse widths and period
int  WINAPI DMMWidthStr(int nDmm, int iPol, LPSTR lpszNegWidth);// String version of DMMReadWidth
int  WINAPI DMMSetCompThreshold(int nDmm, double dTrheshold);	// Set AC Comperator Threshold DAC
int  WINAPI DMMStartTotalizer(int nDmm, int Edge);			// Clear and start totalizer operation
int  WINAPI DMMStopTotalizer(int nDmm);						// Terminate Totalizer operation
int  WINAPI DMMReadTotalizer(int nDmm, int * count);		// Read accumulated totalizer count
int WINAPI DMMSetTempUnits(int nDmm, int C_or_F);			// Set temperature measurement units
int WINAPI DMMSetDCVSource(int nDmm, double voltage);		// Set DCV source voltage
int WINAPI DMMSetACVSource(int nDmm, double level, double frequency);	// Set ACV source for RMS voltage and frequency
int  WINAPI DMMGetDeviation(int nDmm, double  *lpfRes);		// Read deviation relative to last application of Relative
int  WINAPI DMMGetDeviatStr(int nDmm, LPSTR lpszReading);	// String version of DMMReadDeviation
int WINAPI DMMGetdB(int nDmm, double  *lpdRes);				// Read dB deviation relative to last application of Relative
int WINAPI DMMGetdBStr(int nDmm, char *pstrDB);				// String version of DMMReaddB()
int WINAPI DMMSetRTD(int nDmm, double Rzero);				// Selecte RTD type and its Ro
int  WINAPI DMMOpenTerminalCal(int nDmm);					// Perform open terminal calibration. Necessary for L metering
int WINAPI DMMSetDCISource(int nDmm, double Rzero);			// Set the DC current source value
int  WINAPI DMMSetTrimDAC(int nDmm, int Value);				// Set the Fine DAC value. Applicable to sources
int  WINAPI DMMDisableTrimDAC(int nDmm);					// Disable Trim DAC (good thing to do when done using it)
int  WINAPI DMMReadDutyCycle(int nDmm, double  *lpdDcy);	// Read Duty cycle
int  WINAPI DMMDutyCycleStr(int nDmm,LPSTR lpszDutyCycle);	// String version
int WINAPI DMMReadPeakToPeak(int nDmm, double * dPtp);		// Make a single peak-to-peak measurement: Slow
int WINAPI DMMReadCrestFactor(int nDmm, double * dCrest);	// Make a crest factor measurement: Slow
int WINAPI DMMReadMedian(int nDmm, double * dMedian);		// Read signal Median value: Slow
int WINAPI DMMReadInductorQ(int nDmm, double *Q);			// Read inductor's Q.
int WINAPI DMMSetInductFreq(int nDmm, double frq);			// set stimulus freqeuncy for inductance and Q measuremetns
int  WINAPI DMMGetType(int nDmm);							// Read DMM type from H/W
int WINAPI DMMGetSourceFreq(int nDmm, double *frq);			// read source frequency
int  WINAPI DMMGetManDate(int nDmm, int *month, int *day, int *year);
int WINAPI DMMLoadCalFile(int nDmm, LPCSTR lpszCalFile);	// Reload Cal File
int  WINAPI DMMGetHwVer(int nDmm);							// Get the Hardware Version code
//int WINAPI SetTotalizerDivider(int nDmm, int divider);	    // SM2064S option function. Effects counter/totalizer
int WINAPI DMMSetCapsAveSamp(int nDmm, int average, int samples);	// Fine tuning of capacitance speed. Use carefully.
int WINAPI DMMSetTrigRead(int nDmm, int nSettle, int m, int edge);
int WINAPI DMMReadMeasurement(int nDmm, double  *value);
int WINAPI DMMSetBuffTrigRead(int nDmm, int nSettle, int m, int edge);
int WINAPI DMMBurstRead(int nDmm, int iSettle, int iMeasurements);
int WINAPI DMMBurstBuffRead(int nDmm, int iSettle, int iMeasurements);
int WINAPI DMMGetBusInfo(int nDmm, int *bus, int *slot);
int WINAPI DMMClosePCI(int nDmm);
int WINAPI DMMSetCounterRng(int nDmm, int CtrRangge);
int WINAPI DMMCleanRelay(int nDmm, int Relay, int times);
int WINAPI DMMSetTCType(int nDmm, int type);		// Set Thermocouple type (see DMMUser.h)
int WINAPI DMMGetTCType(int nDmm);
int WINAPI DMMSetSensorParams(int nDmm, double a, double m, double b);
int WINAPI DMMSetCJTemp(int nDmm, double temp);
int WINAPI DMMReadCJTemp(int nDmm, double *CJTemp);
int WINAPI DMMGetCJTemp(int nDmm, double *CJTemp);
int WINAPI DMMOpenCalACCaps(int nDmm); // AC based loaded caps
int WINAPI DMMSetACCapsLevel(int nDmm, double V);
int WINAPI DMMGetACCapsR(int nDmm, double * r);
int WINAPI DMMSetOffsetOhms(int nDmm, int bOffsetOhms);	// Set Offset Ohms flag.
int WINAPI DMMSetSync(int nDmm, int bEnabled, int iPolarity); // Set DMM Synce output
int WINAPI DMMSetFastRMS(int nDmm, int bFast);		// Select RMS Filter
int WINAPI DMMSetTrigPolarity(int nDmm, int iPolarity);
int WINAPI DMMSetReadInterval(int nDmm, double dTime);
int WINAPI DMMGetTriggerInfo(int nDmm, int * EmptySamples, int * PreTrigSamples, int * BufCycles);
int WINAPI ClearBuffer(int nDmm);
int WINAPI DMMGetBufferSize(int nDmm, int * lpiLength);
int WINAPI DMMGetReadInterval(int nDmm, double * dTime);
int  WINAPI DMMDelayedTrigger(int nDmm, double delay, int iSamples);
int  WINAPI DMMSetReference(int nDmm, double ref);
int WINAPI DMMSetPXITrigger(int nDmm, int TrigIn, int TrigOut);
int WINAPI DMMTriggerBurst(int nDmm, int iSamples, int iEvents, int iEdge);
int  WINAPI DMMSetRate(int nDmm, int nRate);	// SMX2050 function
int  WINAPI DMMGetRate(int nDmm, double *lpdRate);	// SMX2050 function
int  WINAPI DMMGetDiffMnMxStr(int nDmm, LPSTR lpszReading);
int WINAPI DMMUnlockCounter(int nDmm);
int  WINAPI DMMSetPLC(int nDmm, int LineFreqeuncy, int N);
// int  WINAPI DMMSetPulseGen(int nDmm,  int PosWidth, int NegWidth, int Count);
int  WINAPI DMMSetPulseGen(int nDmm,  double PosWidth, double NegWidth, int Count);
int  WINAPI DMMSetDutyCycle(int nDmm,  double dFreq, double dPercent);
int WINAPI DMMReadHiSense(int nDmm, double *lpdRes);
int WINAPI DMMReadLoSense(int nDmm, double *lpdRes);
int WINAPI DMMReadHiLoSense(int nDmm, double *lpdRes);
int WINAPI DMMReadTestV(int nDmm, double *lpdVal);
int  WINAPI DMMGetHwOption(int nDmm);
int WINAPI DMMReadInductorR(int nDmm, double *R);
int WINAPI DMMSetACCapsDelay(int nDmm, double d);
int WINAPI DMMReadSR(int nDmm, double C, double * sR);
int WINAPI DMMGetCounterRange(int nDmm);
int WINAPI DMMSetSourceRes(int nDmm, double resistance);
int WINAPI DMMEnableMessages(int nDmm, BOOL State);
int WINAPI DMMGetAverageVAC(int nDmm, double freq, double * val);
int WINAPI DMMGetLowFreqVRMS(int nDmm, double freq, double * val);
int WINAPI DMMGetTrigger(int nDmm);
int WINAPI DMMWaitForTrigger(int nDmm);
int WINAPI DMMOutputSync(int nDmm, int iMode, double dWidth);
int  WINAPI DMMTrigMsrCompStop(int nDmm, BOOL Direction, double dTarget);
int WINAPI DMMSetSRfreqeuncy(int nDmm, double frequency);

int WINAPI DMMSetTCoffset(int nDmm, double offset); // set user defined thermocouple offset, in microvolts
int WINAPI DMMGetTCoffset(int nDmm, double * offset); // get user defined thermocouple offset, in microvolts 

int WINAPI DMMSyncAndWaitTrig(int nDmm);
int WINAPI DMMArmExtTrigger(int nDmm, int iPreTrig, int iPostTrig); // Agilent version of DMMArmTrigger()
int WINAPI DMMArmLevelTrigger(int nDmm, int iPreTrig, int iPostTrig, double dLevel);
//int WINAPI DMMArmNTriggers(int nDmm, int iTriggers, int iSamples);
int WINAPI DMMSetDCVSourceRead(int nDmm, double voltage, double * reading);

int WINAPI ExpandAgilCalFile(LPCSTR lpszEncryptFile, LPCSTR lpszTextFile);
int WINAPI DMMDelydTriggers(int nDmm, double delay, int iTriggers);
int WINAPI DMMBuffDelayedRead(int nDmm, double delay, int iSamples);
int  WINAPI MeasureSourceResistance(int nDmm);
int WINAPI SetOffset(int nDmm, double offset);
int WINAPI WrCalStoreToFile(int nDmm, LPCSTR lpszCal, int mode);
int WINAPI TranslateLgcyCalFile(int nDmm, LPCSTR lpszLegacyFile, LPCSTR lpszCalFile);

int WINAPI DMMSetSleepPeriod(long usecs); 
#ifdef __cplusplus
}
#endif

/*
 * Error codes returned by the DLL. Use DMMErrString to retrieve Error description
 */
#define	DMM_OKAY_2060		0	// no error
#define	DMM_E_CAL_2060		-1	// cannot find valid calibration file
#define	HI_SPD_XING_2060		-2	// High Speed Guard Crossing error
#define	DMM_E_INIT_2060		-3	// Dmm not initialized
#define	DMM_E_IO_2060		-4	// DMM not responding
#define	NOT_FOUND_2060		-5	// DMM Not found on PCI bus
#define	DMM_E_CAL_R_2060		-6	// cannot find valid calibration record
#define ERR_AD_HW_2060       -7	// A/D does not respond. H/W error
#define ERR_HW_INIT_2060     -8	// can't access H/W, wrong address of fail
#define NO_CAL_RECORD_2060   -9	// can't find cal record for DMM
#define ID_HW_ERR_2060       -10	// Can't read ID from DMM
#define TRIGG_ERR_2060        -11	// Trigger circuit error
#define GUARD_COM_2060       -12	// Communication error with DMM uP      
#define TIMEOUT_2060		    -13	// process timed out Error
#define GUARD_XING_2060		-14	// Guard crossing is broken
#define CONTROLR_COM_2060	-15	// Microcontroller communication error
#define OVERRUN_2060			-16 // Communication Overrun error
#define FRAME_2060			-17 // Communication Frame error
#define RCV_FIFO_2060		-18 // Com receive Fifo error
#define PARITY_2060			-19 // Com parity error
#define WRONG_TYPE_2060		-20 // Wrong Cal record for DMM type
#define WRONG_GRD_VER_2060	-21 // MCU Firmwhare does not support operation 
#define CANT_OPEN_PCI_2060	-22	// Can't open PCI device. Already open ?
#define PCI_ITEMS_2060		-23	// Card does not have all PCI items.
#define GENERAL_ERR_2060		-24 // General Error
#define NO_HS_OG_2060		-25 // High speed Out Guard comm not operating/available
#define CAL_STORE_2060		-26 // Error reading Cal record from local storage
#define CREAT_CAL_FILE_2060	-27 // Can't create named cal file to write to
#define OPEN_CAL_FILE_2060	-28 // Can't open cal file for reading cal record
#define CREAT_CAL_RCRD_2060	-29 // Can't create on-board Cal Record
#define READ_CAL_RCRD_2060	-30 // Error reading cal file. May be localization issue; expecting ',' rather than '.'
#define OUT_GRD_LOOP_2060	-31 // OutGuard Local Loopback comm test fail
#define ERR_VISA_2060       -32 // VISA layer communication error - should not be necessary in linux, but the error is kept as a placeholder
#define E2PROM_PARAM_CS		-33	// Checksum or other error in E2Prom customer parameter Store.
#define E2PROM_CAL_CS		-34	// Checksum or other error in E2Prom calibration store.
#define UNKNOWN_DEVICE_2060 -35 // Device/vendor id does not match a DMM this driver can communicate with

#define	DMM_E_N		    -35 // Error Limit: the lowest error value allowed


/*
 * Warning codes returned by the DLL. Use DMMErrString to retrieve Error description
 * Values are above 100 since string retrieving functions such as DMMReadStr() return
 * the string length, which could be 1 to 80
 */
#define	APERTR_TOO_HIGH_2060	101	// Aperture is too high (code too low) for this Operation
#define	DMM_E_FUNC_2060		102	// Invalid function value used
#define	DMM_E_RNG_2060		103	// Invalid range value used
#define	DMM_CNT_RNG_2060		104	// DMM counter out of range
#define	DMM_E_IS_INIT_2060	105	// Dmm already initialized: in use
#define CAP_RATE_ERR_2060	106	// Can't change Aperture or Read Interval in Cap mode.
#define ERR_FUNC_2060		107	// Illegal function selection
#define ERR_APERTURE_2060	108	// Wrong Aperture selected, see rate definition
#define TRIG_SAMPL_ERR_2060	109	// Wrong number of Trigger samples
#define ERR_PARAMETER_2060	110	// wrong parameter value                                                                             
#define UN_CALIBRATED_2060	111	// Expired Calibration. Needs service
#define	TOO_COLD_2060		112	// Temperature too low
#define	TOO_HOT_2060			113	// Temperature too high
#define	BAD_TC_TYPE_2060		114	// Wrong TC type
#define	MC_STOP_2060			115	// Microcontroller was stopped/interruped during an operation
#define	POS_FS_2060			116	// Positive Over Range
#define	NEG_FS_2060			117	// Negative Over Range
#define	BUSY_2060			118	// DMM is busy, wait for ready
#define FUNC_INACTIVE_2060   119	// Function can not be selected, or not available for this type DMM.
#define NOT_OPEN_2060		120	// Test Terminals Are not Open during Open Cal operation, 
#define READ_INTERVL_2060	121	// Read Interval value incompatible with Aperture, 
#define FAIL_OPEN_CAL_2060	122 // Failed to perform Open-Cal operation
#define CAL_2usOffset_2060	123	// Failed to Cal offset in 2.5uS Aperture
#define CAL_2usGain_2060		124	// Failed to Cal gain in 2.5uS Aperture
#define OFFSET_TOO_HIGH		125	// V source offset too high for Open Cal compensation.

#define	DMM_E_P				125	// the maximum warning value used

// BK 6/2/10
#pragma GCC visibility pop

#endif
