#!/bin/bash

# install the libM918X.so library into the system directories 
# with an appropriate soname according to the release version

# su privelages are required to run this script

EXEC_PATH=$(dirname $0)

VERSION_FILE=$EXEC_PATH/.version

if [ -e $VERSION_FILE ] 
then
    . $VERSION_FILE

    LIB_INSTALL_DIR=/usr/lib
    INCLUDE_INSTALL_DIR=/usr/include/agilent
# The library provided is a 32bit library, regardless of the system. 
# On 64bit systems it runs in compatibility mode.  
# Only the kernel driver is compiled for 64bits on relevant systems.  
    #if [uname -a | grep -c x86_64 > 0]
#    if [ `uname -a | grep -c x86_64` -gt 0 ]
#    then
#	LIB_SRC_PATH=$EXEC_PATH/lib/x86_64
#    else
    	LIB_SRC_PATH=$EXEC_PATH/lib/i386
#    fi
    
    LIB_NAME=libM918X.so
    SO_NAME=$LIB_NAME.$MAJOR_NUMBER
#    REAL_NAME=$SO_NAME.$MINOR_NUMBER
    REAL_NAME=$SO_NAME.$MINOR_NUMBER.$BUILD_NUMBER

    cp $LIB_SRC_PATH/$LIB_NAME $LIB_INSTALL_DIR/$REAL_NAME

    rm -f $LIB_INSTALL_DIR/$SO_NAME
    rm -f $LIB_INSTALL_DIR/$LIB_NAME

    ln -s $LIB_INSTALL_DIR/$REAL_NAME $LIB_INSTALL_DIR/$SO_NAME
    ln -s $LIB_INSTALL_DIR/$SO_NAME $LIB_INSTALL_DIR/$LIB_NAME

    ldconfig -n $LIB_INSTALL_DIR

    mkdir -p $INCLUDE_INSTALL_DIR

    cp $EXEC_PATH/include/DMMUser.h $INCLUDE_INSTALL_DIR
    cp $EXEC_PATH/include/SMX2060.h $INCLUDE_INSTALL_DIR
    cp $EXEC_PATH/include/M918X_Linux.h $INCLUDE_INSTALL_DIR

else
    echo "Unable to open file '$VERSION_FILE'"
    echo "Exiting without installing"
fi


