#include <SMX2060.h>
#include <DMMUser.h>

// check for any errors and print error messages to the screen
// pass in the return value of any M918X API function
int fault(int err) {
	char str[100];
	if (err < 0) {
        DMMErrString(err, str,100);
		printf("DMM Error %d: %s\n",err, str);
	}
	else if ((err > 100) && (err < DMM_E_P)) {
        DMMErrString(err, str,100);
		printf("DMM Warning %d: %s\n",err, str);
	}
	return err;
}

int main (int argc, char *argv[])
{
	int j;
	int err;
	char result[16];
	double value;
	int nDmm = 0;
	double version;
	int hwver;
	int id;
	int type;

	if (argc == 2) {	// Argument count = 2 like in "sm-vdc 1"
		nDmm = strtol(argv[1], NULL, 0);
		if (nDmm < 0 || nDmm >= 64) {
			fprintf(stderr, "Invalid nDmm = %d\n", nDmm); 
			exit(1);
		}
	}

	fault(DMMGetVer(nDmm, &version));
	printf("DMM Driver Version %.5f\n", version);

	printf("DMMInit... \n"); 
	fflush(0);
    err = fault(DMMInit(nDmm, "sm60cal.dat"));
	if( err ) {
		exit(1);
	}


	printf("DMMGetID...\n");
	id = fault(DMMGetID(nDmm));
	printf("DMM Card ID %d\n", id);
	fflush(stdout);
	
	hwver = fault(DMMGetHwVer(nDmm));
	printf("DMM Hardware Version %d\n", hwver);

	type = fault(DMMGetType(nDmm));
	printf("DMM type %d\n", type);

	printf("DMMSetFunction ...\n");
	fault(DMMSetFunction(nDmm, VDC));              // Set to VDC function

	printf("DMMSetRange ...\n");
	//fault(DMMSetRange(nDmm, _240mV));             // set to 240mV  range
	fault(DMMSetRange(nDmm, _2400mV));             // set to 2V  range
//	fault(DMMSetRange(nDmm, _240V));           

	if (fault(DMMGetType(nDmm)) == 2055) {
		printf("DMMSetRate ... \n");
		fault(DMMSetRate(nDmm, RATE_2));
	}
	else {
		printf("DMMSetAperture ...\n");
		fault(DMMSetAperture(nDmm, APR_p1333s));       // 10 readings per sec
	}

//	for(j=0; j<25; j++) {
	while (1) {
		fault(DMMReadNorm(nDmm, &value));
//		DMMReadStr(nDmm, result);
//		printf("DMMReadNorm, DMMReadStr ... %lf, %s\n", value, result);
		printf("DMMReadNorm %lf\n", value);
	}
    DMMTerminate(nDmm);
    exit(0);
}
