#include <SMX2060.h>
#include <DMMUser.h>

//#include <sys/time.h>
#include <time.h>

int fault (int errornum) {
  if (errornum != 0) {
    char str[100];
    DMMErrString(errornum, str,100);
    fprintf(stderr,"ERROR %d:::::%s\n",errornum,str);
  }
  return errornum;
}


// ~ microsecond precision
double gettime(){
  struct timeval tv;
  gettimeofday(&tv,NULL);
  return tv.tv_sec + tv.tv_usec / 1000000.0;
}

int main (int argc, char *argv[])
{
	int i;
	//	char result[16];
	double value;
	int nDmm = 0;   
	int num_readings;
    int dmm_aperture;

	// parse arguments
	if (argc == 4) {	
        nDmm = strtol(argv[1], NULL, 0);
		dmm_aperture = strtol(argv[2], NULL, 0);
		num_readings = strtol(argv[3], NULL, 0);
	}
	else	{
	  fprintf(stderr,"ERROR:  improper arguments, use following format...\n");
	  fprintf(stderr,"speedtests nDmm dmm_aperture num_readings\n");
	  exit(1);
	}

	printf("DMMInit ... "); fflush(0);
	i = fault(DMMInit(nDmm, "sm60cal.dat"));   // initialize SM2064 #0
	if( i < 0 ) {
		fprintf(stderr, "DMMInit: Initialization ERROR\n");
		exit(1);
	}
	printf("OK\n");

	printf("DMMSetFunction ...\n");
	fault(DMMSetFunction(nDmm, VDC));   

	printf("DMMSetRange ...\n");
	fault(DMMSetRange(nDmm, _240V));               // and to 330V  range
                    // put in high range to avoid out of range issues

    //	DMMSetRate(nDmm,dmm_rate);
    fault(DMMSetAperture(nDmm,dmm_aperture));

    fault(DMMSetReadInterval(nDmm,0));

	//	time_t start_time;
	//	time_t finish_time;
	double start_time;
	double finish_time;
	int error_code;

    // needed to achieve the fastest measurement rates
    fault(DMMSetSleepPeriod(-1));
	
	// get start time
	start_time = gettime();

	for(i=0;i<num_readings;i++) {
		error_code = DMMRead(nDmm, &value);
		//printf("DMMRead ... %lf \n", value);
		if ( error_code != 0) {
		  char str[100];
		  DMMErrString(error_code, str,100);
		  fprintf(stderr,"DMMRead returned error %d, ABORTING\n",error_code);
		  fprintf(stderr,"%s\n",str);
		  exit(1);
		}
		//DMMReadStr(nDmm, result);
		//printf("DMMRead, DMMReadStr ... %lf, %s\n", value, result);
	}

	finish_time = gettime();

	double time_diff = finish_time - start_time;
    double actual_aperture;

	fault(DMMGetAperture(nDmm,&actual_aperture));

    // NOTE the reading rate will generally be less then the aperture because
    // of setup and data transfer time before and after the reading is taken
    // use DMMSetReadInterval with DMMSetAperture to set specific measurement rates

    fprintf(stdout,"specified aperture:  %f\n",actual_aperture);
	fprintf(stdout,"1.0 / aperture:      %f\n", 1.0 / actual_aperture);
	fprintf(stdout,"readings/sec:        %f\n",((double)num_readings)/time_diff);
	fprintf(stdout,"number of readings:  %d\n",num_readings);
    fprintf(stdout,"elapsed time:        %f\n",time_diff);
	fprintf(stdout,"cpu usage:             \n\n\n");

    exit(0);

    fault(DMMTerminate(nDmm));
}
