/* cscpiv.h for hpux, DOS, Lynx, WINDOWS 3.1, WIN32*/
#ifndef _COMPSCPI_INCLUDED
#define _COMPSCPI_INCLUDED
#include <visa.h>		/* for ViSession type, io routines */
#include <string.h>		/* for memcpy, strcpy generated by cscpipp */
/*This include file contains all of the typedefs necessary to make
the driver portable. This amounts to definitions of integer types etc..
It also has the function declarations for functions called by the user.
*/
#if defined _WIN32
/* MS used to import enum table symbols from dll's */
#define CSCPI_IMPORT __declspec(dllimport)
#elif defined __WIN32__
/* Borlang used to import enum table symbols from dll's */
#define CSCPI_IMPORT __import
#else
#define CSCPI_IMPORT
#endif
#ifdef __cplusplus
extern "C" {
#endif

typedef ViChar   int8;
typedef ViInt16  int16;
typedef ViInt32  int32;

typedef ViInt16  int_tiny;


typedef ViReal32 float32;
typedef ViReal64 float64;
typedef ViByte   uint8;
typedef ViUInt16 uint16;
typedef ViUInt32 uint32;

typedef ViUInt16 uint_tiny;
typedef ViInt16  INDEX;

typedef ViPChar  PTR;
typedef ViInt32  OFFSET;

/* types used by the execute routines to access the parameter
   information in the in,out structures */
    
typedef ViString HPSL_STRING;

typedef struct {
    ViInt32 length;
    ViPChar array;
} HPSL_INT8_ARRAY;

typedef struct {
    ViInt32 length;
    ViPByte array;
} HPSL_UINT8_ARRAY;

typedef struct {
    ViInt16  num;
    ViInt16  suffix;
} HPSL_INT16;

typedef struct {
    ViInt32 num;
    ViInt16 suffix;
} HPSL_INT32;

typedef struct {
    ViUInt16 num;
    ViInt16  suffix;
} HPSL_UINT16;

typedef struct {
    ViUInt32 num;
    ViInt16  suffix;
} HPSL_UINT32;

typedef struct {
    ViReal32  num;
    ViInt16  suffix;
} HPSL_FLOAT32;

typedef struct {
    ViReal64  num;
    ViInt16  suffix;
} HPSL_FLOAT64;

typedef struct {
    ViInt32    value;
    ViInt16 base;
} HPSL_NON_DECIMAL;

typedef struct {
    ViInt16 length;
    ViPChar buffer;
} HPSL_EXPRESSION;

typedef ViInt16      HPSL_BOOLEAN;
typedef ViChar       HPSL_CHAR[14];  /* this only needs to be 13. Is 14
					 to guarantee 2-byte alignment */

typedef ViInt16      HPSL_ENUM;

typedef struct {
    ViInt16 length;
    ViPChar block;
} HPSL_SHORT_BLOCK;

typedef struct {
    ViInt32 length;
    ViPChar block;
} HPSL_LONG_BLOCK;

typedef struct {
    ViInt16 length;
    ViPChar buffer;
} HPSL_ARB_ASCII;

typedef struct {
    ViInt16 length;
    ViPChar buffer;
} HPSL_MACRO_BLOCK;

typedef struct {
    ViPChar queries;
    ViPChar verbatim;
} HPSL_LRN_SPECIAL;

typedef struct {
    ViInt32  length;
    ViPInt16 array;
} HPSL_INT16_ARRAY;

typedef struct {
    ViInt32   length;
    ViPReal64 array;
} HPSL_FLOAT64_ARRAY;

typedef struct {
    ViInt32   length;
    ViPReal32 array;
} HPSL_FLOAT32_ARRAY;

typedef struct chan_struct {
    struct chan_struct * next;
    ViInt32 number;
    ViInt16 type;
} HPSL_CHANNEL_LIST, *HPSL_CHANNEL_PTR;

typedef struct {
	int (*formatter)(void* , const void*, const void*, void* );
#if defined __hppa || defined _WIN32 || defined __WIN32__
	int pad;
#endif
	ViInt32 length;
	ViAddr  array;
} HPSL_GENERIC;

typedef struct {
	int (*formatter)(void* , const void*, const void*, void* );
	ViReal64 num;
} HPSL_GENERIC_64;

/* added for 1450*/
typedef struct {
    ViInt32 value;
    ViInt16 base;
    ViInt16 width;
} HPSL_INT32_PROG;

typedef struct {
    ViInt32    length;
    void     (*initiate)();
    void     (*terminate)();
} HPSL_LIST_SPEC;


extern void	char_to_char(char* dest, const char *data, ViSession id, char *fail);
extern HPSL_BOOLEAN	char_to_bool(const char *data, ViSession id, char *fail);
extern HPSL_ENUM char_to_enum(const void* enum_table, const char *data,
			      ViSession id, char *fail);
extern void enum_to_char(char *dest, const void* enum_table, int enumerated);
#if defined(MSDOS) || defined(__MSDOS__)
extern void __huge* cscpi_hmemcpy(void __huge *dest, void __huge *src, long size);
#endif
extern ViStatus	instr_clear(ViSession sicl_inst, int (*driver)());
extern void*	instr_misc( ViSession sicl_inst);
extern void	instr_onsrq(ViSession sicl_inst, ViHndlr srqhandle);
extern ViStatus	instr_pmt(  ViSession sicl_inst, int (*driver)());
extern ViStatus	instr_poll( ViSession sicl_inst, unsigned short *stbptr);
extern ViStatus	instr_query(ViSession sicl_inst, int (*driver)(), const void *in,
			    void *out);
extern ViStatus instr_send( ViSession sicl_inst, int (*driver)(), const void *in);
extern ViStatus instr_getdata( ViSession sicl_inst, ViPAddr data);
extern ViStatus instr_setdata( ViSession sicl_inst, ViAddr data);
extern ViStatus instr_gettimeout( ViSession sicl_inst, ViPUInt32 timeout);
extern ViStatus instr_settimeout( ViSession sicl_inst, ViUInt32 timeout);
extern long instr_error_head( ViSession sicl_inst);
extern int	os_init(void);
extern ViSession	os_open(const char* address, int (*header_fn)());
extern int	os_close(ViSession sicl_inst);
extern void	cscpi_exe(ViSession sicl_inst, char *command, ViInt32 length,
			      char *result, ViInt32 result_length);
extern void	cscpi_exe_fildes(ViSession sicl_inst, int in, int out);
extern void	cscpi_exe_stream(ViSession sicl_inst, void * fin, void *fout);
extern void	cscpi_overlap(ViUInt16);
extern ViUInt16 cscpi_get_overlap(void);
extern ViUInt16 cscpi_get_int_level(void);
#if defined _WINDOWS || defined _Windows || defined _WIN32 || defined __WIN32__
extern void	cscpi_onerror(void (*cscpi_error)(ViSession sicl_inst, int error_number));
#else
void		cscpi_error(ViSession sicl_inst, int error_number);
#endif
#if defined _WINDOWS || defined _Windows || defined _WIN32 || defined __WIN32__
#define cscpi_open_error (*cscpi_get_open_error())
extern int*	cscpi_get_open_error(void);	/* for debugging INST_OPEN */
#else
extern int	cscpi_open_error;	/* for debugging INST_OPEN */
#endif

#ifdef __cplusplus
}
#endif
#ifdef lint
extern void INST_STARTUP(void);
extern void INST_CLOSE(ViSession);
#define INST_DECL(id, driver, type) ViSession id;
#define INST_EXTERN(id, driver, type)  extern ViSession id;
#define INST_EXT(id, driver, type)  extern ViSession id;
#define INST_PARAM(id, driver, type)  ViSession id
extern INST_OPEN(ViSession, const char*);
extern INST_SEND(ViSession, const char*, ...);
extern INST_QUERY(ViSession, const char*, const char*, ...);
extern INST_READSTB(ViSession, unsigned char*);
extern INST_CLEAR(ViSession);
extern INST_TRIGGER(ViSession);
extern INST_ONSRQ(ViSession, void (*)(ViSession));
#endif				/* lint */
#endif				/* whole file */
