' Copyright (C) 1996 - 2001 Agilent Technologies
' VXIplug&play Instrument Driver for the Agilent E1411

'/*================================*/
'/*           HPE1411              */
'/*================================*/
'/* WIN Framework Revision: 3.0    */
'/* Driver Revision:    A.02.11    */
'/* Firmware Revision:  A.08.00    */
'/*                     G.08.00    */
'/*================================*/
'
'/*=============================*/
'/* Source Files:               */
'/*=============================*/
'/*   hpe1411.c                 */
'/*   hpe1411.h                 */
'/*=============================*/
'
'/*=============================*/
'/* WIN Framework Files         */
'/*=============================*/
'/*   hpe1411.def               */
'/*   hpe1411.mak               */
'/*   hpe1411.bas               */
'/*=============================*/

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Common Error numbers start at BFFC0D00

Global Const hpe1411_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1411_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1411_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1411_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1411_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1411_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1411_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Parameter errors not in VPP 3.4
Global Const hpe1411_INSTR_ERROR_PARAMETER9                   = &HBFFC0D20&
Global Const hpe1411_INSTR_ERROR_PARAMETER10                  = &HBFFC0D21&
Global Const hpe1411_INSTR_ERROR_PARAMETER11                  = &HBFFC0D22&
Global Const hpe1411_INSTR_ERROR_PARAMETER12                  = &HBFFC0D23&
Global Const hpe1411_INSTR_ERROR_PARAMETER13                  = &HBFFC0D24&
Global Const hpe1411_INSTR_ERROR_PARAMETER14                  = &HBFFC0D25&
Global Const hpe1411_INSTR_ERROR_PARAMETER15                  = &HBFFC0D26&
Global Const hpe1411_INSTR_ERROR_PARAMETER16                  = &HBFFC0D27&
Global Const hpe1411_INSTR_ERROR_PARAMETER17                  = &HBFFC0D28&
Global Const hpe1411_INSTR_ERROR_PARAMETER18                  = &HBFFC0D29&

' Used by Status System Functions
Global Const hpe1411_USER_ERROR_HANDLER                       = -1

Global Const hpe1411_ESR_OPC                                  = 601
Global Const hpe1411_ESR_QUERY_ERROR                          = 603
Global Const hpe1411_ESR_DEVICE_DEPENDENT_ERROR               = 604
Global Const hpe1411_ESR_EXECUTION_ERROR                      = 605
Global Const hpe1411_ESR_COMMAND_ERROR                        = 606

Global Const hpe1411_OPER_CAL                                 = 801

' Used by Function hpe1411_timeOut
Global Const hpe1411_TIMEOUT_MAX                              = 2147483647&
Global Const hpe1411_TIMEOUT_MIN                              = 0&


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1411_init Lib "hpe1411_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1411_close Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_reset Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_self_test Lib "hpe1411_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1411_error_query Lib "hpe1411_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1411_error_message Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1411_revision_query Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' other standard functions 

Declare Function hpe1411_dcl Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_errorQueryDetect Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function hpe1411_errorQueryDetect_Q Lib "hpe1411_32.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function hpe1411_opc Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_opc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, opc As Integer) As Long

Declare Function hpe1411_readStatusByte_Q Lib "hpe1411_32.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function hpe1411_statCond_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal happening As Long, pCondition As Integer) As Long

Declare Function hpe1411_statEvenClr Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_statEven_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal happening As Long, pEvent As Integer) As Long

Declare Function hpe1411_timeOut Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function hpe1411_timeOut_Q Lib "hpe1411_32.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function hpe1411_trg Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_wai Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_scpi Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal size As Long, ByVal scpi_cmd As String) As Long

Declare Function hpe1411_scpi_q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal size As Long, ByVal scpi_cmd As String, ByVal resp_size As Long, ByVal resp_string As String) As Long


'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1411_calLfr
Global Const hpe1411_CAL_LFR_MAX                          = 60
Global Const hpe1411_CAL_LFR_MIN                          = 50
Global Const hpe1411_CAL_LFR_50                           = 50
Global Const hpe1411_CAL_LFR_60                           = 60

' Used by Function hpe1411_calVal
Global Const hpe1411_CAL_VALUE_MAX                        = 1200000.0
Global Const hpe1411_CAL_VALUE_MIN                        = -305.0

' Used by Function hpe1411_confTemp
Global Const hpe1411_TRANS_FRTD_385                       = 0
Global Const hpe1411_TRANS_FRTD_392                       = 1
Global Const hpe1411_TRANS_FTHERM_2252                    = 2
Global Const hpe1411_TRANS_FTHERM_5000                    = 3
Global Const hpe1411_TRANS_FTHERM_10000                   = 4

' Used by Function hpe1411_confTempList
'    hpe1411_TRANS_FRTD_385
'    hpe1411_TRANS_FRTD_392
'    hpe1411_TRANS_FTHERM_2252
'    hpe1411_TRANS_FTHERM_5000
'    hpe1411_TRANS_FTHERM_10000
Global Const hpe1411_TRANS_RTD_385                        = 5
Global Const hpe1411_TRANS_RTD_392                        = 6
Global Const hpe1411_TRANS_THERM_2252                     = 7
Global Const hpe1411_TRANS_THERM_5000                     = 8
Global Const hpe1411_TRANS_THERM_10000                    = 9
Global Const hpe1411_TRANS_TC_B                           = 10
Global Const hpe1411_TRANS_TC_E                           = 11
Global Const hpe1411_TRANS_TC_J                           = 12
Global Const hpe1411_TRANS_TC_K                           = 13
Global Const hpe1411_TRANS_TC_N14                         = 14
Global Const hpe1411_TRANS_TC_N28                         = 15
Global Const hpe1411_TRANS_TC_R                           = 16
Global Const hpe1411_TRANS_TC_S                           = 17
Global Const hpe1411_TRANS_TC_T                           = 18

' Used by Function hpe1411_conf_Q
Global Const hpe1411_CONFQ_FRES                           = 0
Global Const hpe1411_CONFQ_VOLT_AC                        = 1
Global Const hpe1411_CONFQ_VOLT_DC                        = 2
Global Const hpe1411_CONFQ_RES                            = 3
Global Const hpe1411_CONFQ_STR_QUAR                       = 4
Global Const hpe1411_CONFQ_STR_HBEN                       = 5
Global Const hpe1411_CONFQ_STR_HPO                        = 6
Global Const hpe1411_CONFQ_STR_FBEN                       = 7
Global Const hpe1411_CONFQ_STR_FPO                        = 8
Global Const hpe1411_CONFQ_STR_FBP                        = 9
Global Const hpe1411_CONFQ_STR_QTEN                       = 10
Global Const hpe1411_CONFQ_STR_QCOM                       = 11
Global Const hpe1411_CONFQ_STR_UNST                       = 12
Global Const hpe1411_CONFQ_TEMP                           = 13
'    hpe1411_TRANS_FRTD_385
'    hpe1411_TRANS_FRTD_392
'    hpe1411_TRANS_FTHERM_2252
'    hpe1411_TRANS_FTHERM_5000
'    hpe1411_TRANS_FTHERM_10000
'    hpe1411_TRANS_RTD_385
'    hpe1411_TRANS_RTD_392
'    hpe1411_TRANS_THERM_2252
'    hpe1411_TRANS_THERM_5000
'    hpe1411_TRANS_THERM_10000
'    hpe1411_TRANS_TC_B
'    hpe1411_TRANS_TC_E
'    hpe1411_TRANS_TC_J
'    hpe1411_TRANS_TC_K
'    hpe1411_TRANS_TC_N14
'    hpe1411_TRANS_TC_N28
'    hpe1411_TRANS_TC_R
'    hpe1411_TRANS_TC_S
'    hpe1411_TRANS_TC_T

' Used by Function hpe1411_configure
Global Const hpe1411_CONF_FRES                            = 0
Global Const hpe1411_CONF_VOLT_AC                         = 1
Global Const hpe1411_CONF_VOLT_DC                         = 2

' Used by Function hpe1411_configureList
Global Const hpe1411_CONF_LIST_FRES                       = 0
Global Const hpe1411_CONF_LIST_VOLT_AC                    = 1
Global Const hpe1411_CONF_LIST_VOLT_DC                    = 2
Global Const hpe1411_CONF_LIST_RES                        = 3
Global Const hpe1411_CONF_LIST_STR_QUAR                   = 4
Global Const hpe1411_CONF_LIST_STR_HBEN                   = 5
Global Const hpe1411_CONF_LIST_STR_HPO                    = 6
Global Const hpe1411_CONF_LIST_STR_FBEN                   = 7
Global Const hpe1411_CONF_LIST_STR_FPO                    = 8
Global Const hpe1411_CONF_LIST_STR_FBP                    = 9
Global Const hpe1411_CONF_LIST_STR_QTEN                   = 10
Global Const hpe1411_CONF_LIST_STR_QCOM                   = 11
Global Const hpe1411_CONF_LIST_STR_UNST                   = 12

' Used by Function hpe1411_fetc_Q
Global Const hpe1411_DATA_ARRAY_LEN_MAX                   = 1048576
Global Const hpe1411_DATA_ARRAY_LEN_MIN                   = 1

' Used by Function hpe1411_func
Global Const hpe1411_FUNC_FRES                            = 0
Global Const hpe1411_FUNC_VOLT_AC                         = 1
Global Const hpe1411_FUNC_VOLT_DC                         = 2

' Used by Function hpe1411_func_Q
'    hpe1411_FUNC_FRES
'    hpe1411_FUNC_VOLT_AC
'    hpe1411_FUNC_VOLT_DC

' Used by Function hpe1411_measTempList_Q
'    hpe1411_TRANS_FRTD_385
'    hpe1411_TRANS_FRTD_392
'    hpe1411_TRANS_FTHERM_2252
'    hpe1411_TRANS_FTHERM_5000
'    hpe1411_TRANS_FTHERM_10000
'    hpe1411_TRANS_RTD_385
'    hpe1411_TRANS_RTD_392
'    hpe1411_TRANS_THERM_2252
'    hpe1411_TRANS_THERM_5000
'    hpe1411_TRANS_THERM_10000
'    hpe1411_TRANS_TC_B
'    hpe1411_TRANS_TC_E
'    hpe1411_TRANS_TC_J
'    hpe1411_TRANS_TC_K
'    hpe1411_TRANS_TC_N14
'    hpe1411_TRANS_TC_N28
'    hpe1411_TRANS_TC_R
'    hpe1411_TRANS_TC_S
'    hpe1411_TRANS_TC_T
'    hpe1411_DATA_ARRAY_LEN_MAX
'    hpe1411_DATA_ARRAY_LEN_MIN

' Used by Function hpe1411_measTemp_Q
'    hpe1411_TRANS_FRTD_385
'    hpe1411_TRANS_FRTD_392
'    hpe1411_TRANS_FTHERM_2252
'    hpe1411_TRANS_FTHERM_5000
'    hpe1411_TRANS_FTHERM_10000

' Used by Function hpe1411_measureList_Q
'    hpe1411_CONF_LIST_FRES
'    hpe1411_CONF_LIST_VOLT_AC
'    hpe1411_CONF_LIST_VOLT_DC
'    hpe1411_CONF_LIST_RES
'    hpe1411_CONF_LIST_STR_QUAR
'    hpe1411_CONF_LIST_STR_HBEN
'    hpe1411_CONF_LIST_STR_HPO
'    hpe1411_CONF_LIST_STR_FBEN
'    hpe1411_CONF_LIST_STR_FPO
'    hpe1411_CONF_LIST_STR_FBP
'    hpe1411_CONF_LIST_STR_QTEN
'    hpe1411_CONF_LIST_STR_QCOM
'    hpe1411_CONF_LIST_STR_UNST
'    hpe1411_DATA_ARRAY_LEN_MAX
'    hpe1411_DATA_ARRAY_LEN_MIN

' Used by Function hpe1411_measure_Q
'    hpe1411_CONF_FRES
'    hpe1411_CONF_VOLT_AC
'    hpe1411_CONF_VOLT_DC

' Used by Function hpe1411_memVmeAddr
Global Const hpe1411_MEM_VME_ADDR_MAX                     = 14680056
Global Const hpe1411_MEM_VME_ADDR_MIN                     = 2097152

' Used by Function hpe1411_memVmeSize
Global Const hpe1411_MEM_VME_SIZE_MAX                     = 12582912
Global Const hpe1411_MEM_VME_SIZE_MIN                     = 0

' Used by Function hpe1411_outpTtlt_M
Global Const hpe1411_TTLT_LINE_MAX                        = 7
Global Const hpe1411_TTLT_LINE_MIN                        = 0

' Used by Function hpe1411_outpTtlt_M_Q
'    hpe1411_TTLT_LINE_MAX
'    hpe1411_TTLT_LINE_MIN

' Used by Function hpe1411_poissonInitList
Global Const hpe1411_GFAC_MAX                             = 1.0e3
Global Const hpe1411_GFAC_MIN                             = 1.0e-9
Global Const hpe1411_POIS_MAX                             = 2.0
Global Const hpe1411_POIS_MIN                             = 1.0e-4

' Used by Function hpe1411_read_Q
'    hpe1411_DATA_ARRAY_LEN_MAX
'    hpe1411_DATA_ARRAY_LEN_MIN

' Used by Function hpe1411_resAper
Global Const hpe1411_APER_MAX                             = 320.0e-3
Global Const hpe1411_APER_MIN                             = 10.0e-6

' Used by Function hpe1411_resNplc
Global Const hpe1411_NPLC_MAX                             = 16.0
Global Const hpe1411_NPLC_MIN                             = 0.0005

' Used by Function hpe1411_resRang
Global Const hpe1411_RES_RANG_MAX                         = 1048576.0
Global Const hpe1411_RES_RANG_MIN                         = 0.0
Global Const hpe1411_RES_RANG_250                         = 255.0
Global Const hpe1411_RES_RANG_2K                          = 2047.0
Global Const hpe1411_RES_RANG_16K                         = 16383.0
Global Const hpe1411_RES_RANG_131K                        = 131071.0
Global Const hpe1411_RES_RANG_1M                          = 1048575

' Used by Function hpe1411_resRes
Global Const hpe1411_RES_RES_MAX                          = 64.0
Global Const hpe1411_RES_RES_MIN                          = 61.0e-6
Global Const hpe1411_RES_RES_61U                          = 61.05e-6
Global Const hpe1411_RES_RES_244U                         = 244.2e-6
Global Const hpe1411_RES_RES_488U                         = 488.3e-6
Global Const hpe1411_RES_RES_1_MILLI                      = 976.6e-6
Global Const hpe1411_RES_RES_2_MILLI                      = 1.954e-3
Global Const hpe1411_RES_RES_4_MILLI                      = 3.91e-3
Global Const hpe1411_RES_RES_8_MILLI                      = 7.813e-3
Global Const hpe1411_RES_RES_16_MILLI                     = 15.63e-3
Global Const hpe1411_RES_RES_32_MILLI                     = 31.3e-3
Global Const hpe1411_RES_RES_63_MILLI                     = 62.51e-3
Global Const hpe1411_RES_RES_125_MILLI                    = 125.1e-3
Global Const hpe1411_RES_RES_250_MILLI                    = 250.1e-3
Global Const hpe1411_RES_RES_500_MILLI                    = 500.1e-3
Global Const hpe1411_RES_RES_1                            = 1.01
Global Const hpe1411_RES_RES_4                            = 4.01
Global Const hpe1411_RES_RES_8                            = 8.01
Global Const hpe1411_RES_RES_32                           = 32.01
Global Const hpe1411_RES_RES_64                           = 64.0

' Used by Function hpe1411_routFunc
Global Const hpe1411_SWITCH_CARD_MAX                      = 99
Global Const hpe1411_SWITCH_CARD_MIN                      = 1
Global Const hpe1411_ROUT_FUNC_WIRE1                      = 0
Global Const hpe1411_ROUT_FUNC_WIRE2                      = 1
Global Const hpe1411_ROUT_FUNC_WIRE2x64                   = 2
Global Const hpe1411_ROUT_FUNC_WIRE3                      = 3
Global Const hpe1411_ROUT_FUNC_WIRE4                      = 4
Global Const hpe1411_ROUT_FUNC_WIRE1X2                    = 5
Global Const hpe1411_ROUT_FUNC_WIRE1X4                    = 6
Global Const hpe1411_ROUT_FUNC_WIRE1X8                    = 7
Global Const hpe1411_ROUT_FUNC_WIRE2x2                    = 8
Global Const hpe1411_ROUT_FUNC_WIRE2x4                    = 9
Global Const hpe1411_ROUT_FUNC_WIRE2x8                    = 10
Global Const hpe1411_ROUT_FUNC_WIRE4X2                    = 11
Global Const hpe1411_ROUT_FUNC_WIRE4X4                    = 12
Global Const hpe1411_ROUT_FUNC_NONE                       = 13

' Used by Function hpe1411_routFunc_Q
'    hpe1411_SWITCH_CARD_MAX
'    hpe1411_SWITCH_CARD_MIN
'    hpe1411_ROUT_FUNC_WIRE1
'    hpe1411_ROUT_FUNC_WIRE2
'    hpe1411_ROUT_FUNC_WIRE2x64
'    hpe1411_ROUT_FUNC_WIRE3
'    hpe1411_ROUT_FUNC_WIRE4
'    hpe1411_ROUT_FUNC_WIRE1X2
'    hpe1411_ROUT_FUNC_WIRE1X4
'    hpe1411_ROUT_FUNC_WIRE1X8
'    hpe1411_ROUT_FUNC_WIRE2x2
'    hpe1411_ROUT_FUNC_WIRE2x4
'    hpe1411_ROUT_FUNC_WIRE2x8
'    hpe1411_ROUT_FUNC_WIRE4X2
'    hpe1411_ROUT_FUNC_WIRE4X4
'    hpe1411_ROUT_FUNC_NONE

' Used by Function hpe1411_sampCoun
Global Const hpe1411_SAMP_COUN_MAX                        = 16777215
Global Const hpe1411_SAMP_COUN_MIN                        = 1

' Used by Function hpe1411_sampSour
Global Const hpe1411_SAMP_SOUR_IMM                        = 0
Global Const hpe1411_SAMP_SOUR_TIM                        = 1

' Used by Function hpe1411_sampSour_Q
'    hpe1411_SAMP_SOUR_IMM
'    hpe1411_SAMP_SOUR_TIM

' Used by Function hpe1411_sampTim
Global Const hpe1411_SAMP_TIM_MAX                         = 65.534e-3
Global Const hpe1411_SAMP_TIM_MIN                         = 76.0e-6

' Used by Function hpe1411_sample
'    hpe1411_SAMP_COUN_MAX
'    hpe1411_SAMP_COUN_MIN
'    hpe1411_SAMP_SOUR_IMM
'    hpe1411_SAMP_SOUR_TIM
'    hpe1411_SAMP_TIM_MAX
'    hpe1411_SAMP_TIM_MIN

' Used by Function hpe1411_sample_Q
'    hpe1411_SAMP_SOUR_IMM
'    hpe1411_SAMP_SOUR_TIM

' Used by Function hpe1411_strGfacList
'    hpe1411_GFAC_MAX
'    hpe1411_GFAC_MIN

' Used by Function hpe1411_strGfacList_Q
Global Const hpe1411_RESP_ARRAY_LEN_MAX                   = 3850
Global Const hpe1411_RESP_ARRAY_LEN_MIN                   = 1

' Used by Function hpe1411_strPoisList
'    hpe1411_POIS_MAX
'    hpe1411_POIS_MIN

' Used by Function hpe1411_strPoisList_Q
'    hpe1411_RESP_ARRAY_LEN_MAX
'    hpe1411_RESP_ARRAY_LEN_MIN

' Used by Function hpe1411_strUnstList
Global Const hpe1411_UNST_REF_MAX                         = 300.0
Global Const hpe1411_UNST_REF_MIN                         = -300.0

' Used by Function hpe1411_strUnstList_Q
'    hpe1411_RESP_ARRAY_LEN_MAX
'    hpe1411_RESP_ARRAY_LEN_MIN

' Used by Function hpe1411_strainConst_Q
'    hpe1411_RESP_ARRAY_LEN_MAX
'    hpe1411_RESP_ARRAY_LEN_MIN

' Used by Function hpe1411_strainInitList
'    hpe1411_GFAC_MAX
'    hpe1411_GFAC_MIN

' Used by Function hpe1411_systCdes_Q
'    hpe1411_SWITCH_CARD_MAX
'    hpe1411_SWITCH_CARD_MIN

' Used by Function hpe1411_systCtyp_Q
'    hpe1411_SWITCH_CARD_MAX
'    hpe1411_SWITCH_CARD_MIN

' Used by Function hpe1411_systLfr
Global Const hpe1411_SYST_LFR_MAX                         = 60
Global Const hpe1411_SYST_LFR_MIN                         = 50
Global Const hpe1411_SYST_LFR_50                          = 50
Global Const hpe1411_SYST_LFR_60                          = 60

' Used by Function hpe1411_timedFetch_Q
'    hpe1411_TIMEOUT_MAX
'    hpe1411_TIMEOUT_MIN
'    hpe1411_DATA_ARRAY_LEN_MAX
'    hpe1411_DATA_ARRAY_LEN_MIN

' Used by Function hpe1411_trigCoun
Global Const hpe1411_TRIG_COUN_MAX                        = 16777215
Global Const hpe1411_TRIG_COUN_MIN                        = 1

' Used by Function hpe1411_trigDel
Global Const hpe1411_TRIG_DEL_MAX                         = 16.777215
Global Const hpe1411_TRIG_DEL_MIN                         = 0.0

' Used by Function hpe1411_trigSour
Global Const hpe1411_TRIG_SOUR_BUS                        = 0
Global Const hpe1411_TRIG_SOUR_EXT                        = 1
Global Const hpe1411_TRIG_SOUR_HOLD                       = 2
Global Const hpe1411_TRIG_SOUR_IMM                        = 3
Global Const hpe1411_TRIG_SOUR_TTLT0                      = 4
Global Const hpe1411_TRIG_SOUR_TTLT1                      = 5
Global Const hpe1411_TRIG_SOUR_TTLT2                      = 6
Global Const hpe1411_TRIG_SOUR_TTLT3                      = 7
Global Const hpe1411_TRIG_SOUR_TTLT4                      = 8
Global Const hpe1411_TRIG_SOUR_TTLT5                      = 9
Global Const hpe1411_TRIG_SOUR_TTLT6                      = 10
Global Const hpe1411_TRIG_SOUR_TTLT7                      = 11

' Used by Function hpe1411_trigSour_Q
'    hpe1411_TRIG_SOUR_BUS
'    hpe1411_TRIG_SOUR_EXT
'    hpe1411_TRIG_SOUR_HOLD
'    hpe1411_TRIG_SOUR_IMM
'    hpe1411_TRIG_SOUR_TTLT0
'    hpe1411_TRIG_SOUR_TTLT1
'    hpe1411_TRIG_SOUR_TTLT2
'    hpe1411_TRIG_SOUR_TTLT3
'    hpe1411_TRIG_SOUR_TTLT4
'    hpe1411_TRIG_SOUR_TTLT5
'    hpe1411_TRIG_SOUR_TTLT6
'    hpe1411_TRIG_SOUR_TTLT7

' Used by Function hpe1411_trigger
'    hpe1411_TRIG_COUN_MAX
'    hpe1411_TRIG_COUN_MIN
'    hpe1411_TRIG_DEL_MAX
'    hpe1411_TRIG_DEL_MIN
'    hpe1411_TRIG_SOUR_BUS
'    hpe1411_TRIG_SOUR_EXT
'    hpe1411_TRIG_SOUR_HOLD
'    hpe1411_TRIG_SOUR_IMM
'    hpe1411_TRIG_SOUR_TTLT0
'    hpe1411_TRIG_SOUR_TTLT1
'    hpe1411_TRIG_SOUR_TTLT2
'    hpe1411_TRIG_SOUR_TTLT3
'    hpe1411_TRIG_SOUR_TTLT4
'    hpe1411_TRIG_SOUR_TTLT5
'    hpe1411_TRIG_SOUR_TTLT6
'    hpe1411_TRIG_SOUR_TTLT7

' Used by Function hpe1411_trigger_Q
'    hpe1411_TRIG_SOUR_BUS
'    hpe1411_TRIG_SOUR_EXT
'    hpe1411_TRIG_SOUR_HOLD
'    hpe1411_TRIG_SOUR_IMM
'    hpe1411_TRIG_SOUR_TTLT0
'    hpe1411_TRIG_SOUR_TTLT1
'    hpe1411_TRIG_SOUR_TTLT2
'    hpe1411_TRIG_SOUR_TTLT3
'    hpe1411_TRIG_SOUR_TTLT4
'    hpe1411_TRIG_SOUR_TTLT5
'    hpe1411_TRIG_SOUR_TTLT6
'    hpe1411_TRIG_SOUR_TTLT7

' Used by Function hpe1411_voltAcAper
'    hpe1411_APER_MAX
'    hpe1411_APER_MIN

' Used by Function hpe1411_voltAcNplc
'    hpe1411_NPLC_MAX
'    hpe1411_NPLC_MIN

' Used by Function hpe1411_voltAcRang
Global Const hpe1411_VOLT_AC_RANG_MAX                     = 300.0
Global Const hpe1411_VOLT_AC_RANG_MIN                     = 0.0
Global Const hpe1411_VOLT_AC_RANG_87MV                    = 0.0874
Global Const hpe1411_VOLT_AC_RANG_700MV                   = 0.699
Global Const hpe1411_VOLT_AC_RANG_5V                      = 5.599
Global Const hpe1411_VOLT_AC_RANG_44V                     = 44.79
Global Const hpe1411_VOLT_AC_RANG_300V                    = 299.9

' Used by Function hpe1411_voltAcRes
Global Const hpe1411_VOLT_RES_MAX                         = 10.0
Global Const hpe1411_VOLT_RES_MIN                         = 29.81e-9
Global Const hpe1411_VOLT_RES_30_NANO                     = 29.81e-9
Global Const hpe1411_VOLT_RES_120_NANO                    = 119.3e-9
Global Const hpe1411_VOLT_RES_238_NANO                    = 238.5e-9
Global Const hpe1411_VOLT_RES_477_NANO                    = 477.0e-9
Global Const hpe1411_VOLT_RES_954_NANO                    = 954.0e-9
Global Const hpe1411_VOLT_RES_2_MICRO                     = 1.91e-6
Global Const hpe1411_VOLT_RES_4_MICRO                     = 3.815e-6
Global Const hpe1411_VOLT_RES_8_MICRO                     = 7.63e-6
Global Const hpe1411_VOLT_RES_15_MICRO                    = 15.26e-6
Global Const hpe1411_VOLT_RES_30_MICRO                    = 30.52e-6
Global Const hpe1411_VOLT_RES_61_MICRO                    = 61.04-6
Global Const hpe1411_VOLT_RES_122_MICRO                   = 122.1e-6
Global Const hpe1411_VOLT_RES_244_MICRO                   = 244.15e-6
Global Const hpe1411_VOLT_RES_488_MICRO                   = 488.3e-6
Global Const hpe1411_VOLT_RES_2_MILLI                     = 1.954e-3
Global Const hpe1411_VOLT_RES_4_MILLI                     = 3.91e-3
Global Const hpe1411_VOLT_RES_16_MILLI                    = 15.626e-3
Global Const hpe1411_VOLT_RES_32_MILLI                    = 33.3e-3

' Used by Function hpe1411_voltDcAper
'    hpe1411_APER_MAX
'    hpe1411_APER_MIN

' Used by Function hpe1411_voltDcNplc
'    hpe1411_NPLC_MAX
'    hpe1411_NPLC_MIN

' Used by Function hpe1411_voltDcRang
Global Const hpe1411_VOLT_DC_RANG_MAX                     = 300.0
Global Const hpe1411_VOLT_DC_RANG_MIN                     = -300.0
Global Const hpe1411_VOLT_DC_RANG_125MV                   = 125.0e-3
Global Const hpe1411_VOLT_DC_RANG_1V                      = 1.0
Global Const hpe1411_VOLT_DC_RANG_8V                      = 8.0
Global Const hpe1411_VOLT_DC_RANG_64V                     = 64.0
Global Const hpe1411_VOLT_DC_RANG_300V                    = 300.0

' Used by Function hpe1411_voltDcRang_Q
'    hpe1411_VOLT_DC_RANG_125MV
'    hpe1411_VOLT_DC_RANG_1V
'    hpe1411_VOLT_DC_RANG_8V
'    hpe1411_VOLT_DC_RANG_64V
'    hpe1411_VOLT_DC_RANG_300V

' Used by Function hpe1411_voltDcRes
'    hpe1411_VOLT_RES_MAX
'    hpe1411_VOLT_RES_MIN
'    hpe1411_VOLT_RES_30_NANO
'    hpe1411_VOLT_RES_120_NANO
'    hpe1411_VOLT_RES_238_NANO
'    hpe1411_VOLT_RES_477_NANO
'    hpe1411_VOLT_RES_954_NANO
'    hpe1411_VOLT_RES_2_MICRO
'    hpe1411_VOLT_RES_4_MICRO
'    hpe1411_VOLT_RES_8_MICRO
'    hpe1411_VOLT_RES_15_MICRO
'    hpe1411_VOLT_RES_30_MICRO
'    hpe1411_VOLT_RES_61_MICRO
'    hpe1411_VOLT_RES_122_MICRO
'    hpe1411_VOLT_RES_244_MICRO
'    hpe1411_VOLT_RES_488_MICRO
'    hpe1411_VOLT_RES_2_MILLI
'    hpe1411_VOLT_RES_4_MILLI
'    hpe1411_VOLT_RES_16_MILLI
'    hpe1411_VOLT_RES_32_MILLI


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1411_abor Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_calAll_Q Lib "hpe1411_32.dll" (ByVal vi As Long, result As Integer) As Long

Declare Function hpe1411_calLfr Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal calLfr As Integer) As Long

Declare Function hpe1411_calLfr_Q Lib "hpe1411_32.dll" (ByVal vi As Long, calLfr As Integer) As Long

Declare Function hpe1411_calStrList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1411_calVal Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal value As Double) As Long

Declare Function hpe1411_calZeroAuto Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal calZeroAuto As Integer) As Long

Declare Function hpe1411_calZeroAuto_Q Lib "hpe1411_32.dll" (ByVal vi As Long, calZeroAuto As Integer) As Long

Declare Function hpe1411_confFres Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_confTemp Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal transducer As Integer) As Long

Declare Function hpe1411_confTempList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal transducer As Integer, ByVal channelList As String) As Long

Declare Function hpe1411_confVoltAc Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_confVoltDc Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_conf_Q Lib "hpe1411_32.dll" (ByVal vi As Long, func As Integer, autoRange As Integer, range As Double, resolution As Double, transducer As Integer) As Long

Declare Function hpe1411_configure Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal func As Integer) As Long

Declare Function hpe1411_configureList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal func As Integer, ByVal channelList As String) As Long

Declare Function hpe1411_fetc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, readings As Double, ByVal dataArrayLen As Long) As Long

Declare Function hpe1411_func Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal func As Integer) As Long

Declare Function hpe1411_func_Q Lib "hpe1411_32.dll" (ByVal vi As Long, func As Integer) As Long

Declare Function hpe1411_initImm Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_measFres_Q Lib "hpe1411_32.dll" (ByVal vi As Long, reading As Double) As Long

Declare Function hpe1411_measTempList_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal transducer As Integer, ByVal channelList As String, readings As Double, ByVal dataArrayLen As Long) As Long

Declare Function hpe1411_measTemp_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal transducer As Integer, reading As Double) As Long

Declare Function hpe1411_measVoltAc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, reading As Double) As Long

Declare Function hpe1411_measVoltDc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, reading As Double) As Long

Declare Function hpe1411_measureList_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal func As Integer, ByVal channelList As String, readings As Double, ByVal dataArrayLen As Long) As Long

Declare Function hpe1411_measure_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal func As Integer, reading As Double) As Long

Declare Function hpe1411_memVmeAddr Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal memVmeAddr As Long) As Long

Declare Function hpe1411_memVmeAddr_Q Lib "hpe1411_32.dll" (ByVal vi As Long, memVmeAddr As Long) As Long

Declare Function hpe1411_memVmeSize Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal memVmeSize As Long) As Long

Declare Function hpe1411_memVmeSize_Q Lib "hpe1411_32.dll" (ByVal vi As Long, memVmeSize As Long) As Long

Declare Function hpe1411_memVmeStat Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal memVmeStat As Integer) As Long

Declare Function hpe1411_memVmeStat_Q Lib "hpe1411_32.dll" (ByVal vi As Long, memVmeStat As Integer) As Long

Declare Function hpe1411_outpTtlt_M Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal ttltLine As Integer, ByVal ttltStat As Integer) As Long

Declare Function hpe1411_outpTtlt_M_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal ttltLine As Integer, ttltStat As Integer) As Long

Declare Function hpe1411_poissonInitList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal gageFactor As Double, ByVal poissonRatio As Double, ByVal channelList As String) As Long

Declare Function hpe1411_read_Q Lib "hpe1411_32.dll" (ByVal vi As Long, readings As Double, ByVal dataArrayLen As Long) As Long

Declare Function hpe1411_resAper Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal resAper As Double) As Long

Declare Function hpe1411_resAper_Q Lib "hpe1411_32.dll" (ByVal vi As Long, resAper As Double) As Long

Declare Function hpe1411_resNplc Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal resNplc As Double) As Long

Declare Function hpe1411_resNplc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, resNplc As Double) As Long

Declare Function hpe1411_resOcom Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal resOcom As Integer) As Long

Declare Function hpe1411_resOcom_Q Lib "hpe1411_32.dll" (ByVal vi As Long, resOcom As Integer) As Long

Declare Function hpe1411_resRang Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal autoRange As Integer, ByVal range As Double) As Long

Declare Function hpe1411_resRang_Q Lib "hpe1411_32.dll" (ByVal vi As Long, autoRange As Integer, range As Double) As Long

Declare Function hpe1411_resRes Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal resRes As Double) As Long

Declare Function hpe1411_resRes_Q Lib "hpe1411_32.dll" (ByVal vi As Long, resRes As Double) As Long

Declare Function hpe1411_routFunc Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal mode As Integer) As Long

Declare Function hpe1411_routFunc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal card As Integer, mode As Integer) As Long

Declare Function hpe1411_sampCoun Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal sampCoun As Long) As Long

Declare Function hpe1411_sampCoun_Q Lib "hpe1411_32.dll" (ByVal vi As Long, sampCoun As Long) As Long

Declare Function hpe1411_sampSour Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal sampSour As Integer) As Long

Declare Function hpe1411_sampSour_Q Lib "hpe1411_32.dll" (ByVal vi As Long, sampSour As Integer) As Long

Declare Function hpe1411_sampTim Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal sampTim As Double) As Long

Declare Function hpe1411_sampTim_Q Lib "hpe1411_32.dll" (ByVal vi As Long, sampTim As Double) As Long

Declare Function hpe1411_sample Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal count As Long, ByVal source As Integer, ByVal period As Double) As Long

Declare Function hpe1411_sample_Q Lib "hpe1411_32.dll" (ByVal vi As Long, count As Long, source As Integer, period As Double) As Long

Declare Function hpe1411_strGfacList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal gageFactor As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strGfacList_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal respArrayLen As Integer, factors As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strPoisList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal poisson As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strPoisList_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal respArrayLen As Integer, ratios As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strUnstList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal reference As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strUnstList_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal respArrayLen As Integer, reference As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strainConst_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal respArrayLen As Integer, gageFact As Double, poissonRatio As Double, refVolt As Double, ByVal channelList As String) As Long

Declare Function hpe1411_strainInitList Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal gageFactor As Double, ByVal channelList As String) As Long

Declare Function hpe1411_systCdes_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal cardDesc As String) As Long

Declare Function hpe1411_systCtyp_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal cardType As String) As Long

Declare Function hpe1411_systLfr Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal systLfr As Integer) As Long

Declare Function hpe1411_systLfr_Q Lib "hpe1411_32.dll" (ByVal vi As Long, systLfr As Integer) As Long

Declare Function hpe1411_timedFetch_Q Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal timeOut As Long, readings As Double, ByVal dataArrayLen As Long) As Long

Declare Function hpe1411_trigCoun Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal trigCoun As Long) As Long

Declare Function hpe1411_trigCoun_Q Lib "hpe1411_32.dll" (ByVal vi As Long, trigCoun As Long) As Long

Declare Function hpe1411_trigDel Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal autoDelay As Integer, ByVal delay As Double) As Long

Declare Function hpe1411_trigDel_Q Lib "hpe1411_32.dll" (ByVal vi As Long, autoDelay As Integer, delay As Double) As Long

Declare Function hpe1411_trigImm Lib "hpe1411_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1411_trigSour Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal trigSour As Integer) As Long

Declare Function hpe1411_trigSour_Q Lib "hpe1411_32.dll" (ByVal vi As Long, trigSour As Integer) As Long

Declare Function hpe1411_trigger Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal count As Long, ByVal autoDelay As Integer, ByVal delay As Double, ByVal source As Integer) As Long

Declare Function hpe1411_trigger_Q Lib "hpe1411_32.dll" (ByVal vi As Long, count As Long, autoDelay As Integer, delay As Double, source As Integer) As Long

Declare Function hpe1411_voltAcAper Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal voltAcAper As Double) As Long

Declare Function hpe1411_voltAcAper_Q Lib "hpe1411_32.dll" (ByVal vi As Long, voltAcAper As Double) As Long

Declare Function hpe1411_voltAcNplc Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal voltAcNplc As Double) As Long

Declare Function hpe1411_voltAcNplc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, voltAcNplc As Double) As Long

Declare Function hpe1411_voltAcRang Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal autoRange As Integer, ByVal range As Double) As Long

Declare Function hpe1411_voltAcRang_Q Lib "hpe1411_32.dll" (ByVal vi As Long, autoRange As Integer, range As Double) As Long

Declare Function hpe1411_voltAcRes Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal voltAcRes As Double) As Long

Declare Function hpe1411_voltAcRes_Q Lib "hpe1411_32.dll" (ByVal vi As Long, voltAcRes As Double) As Long

Declare Function hpe1411_voltDcAper Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal voltDcAper As Double) As Long

Declare Function hpe1411_voltDcAper_Q Lib "hpe1411_32.dll" (ByVal vi As Long, voltDcAper As Double) As Long

Declare Function hpe1411_voltDcNplc Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal voltDcNplc As Double) As Long

Declare Function hpe1411_voltDcNplc_Q Lib "hpe1411_32.dll" (ByVal vi As Long, voltDcNplc As Double) As Long

Declare Function hpe1411_voltDcRang Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal autoRange As Integer, ByVal range As Double) As Long

Declare Function hpe1411_voltDcRang_Q Lib "hpe1411_32.dll" (ByVal vi As Long, autoRange As Integer, range As Double) As Long

Declare Function hpe1411_voltDcRes Lib "hpe1411_32.dll" (ByVal vi As Long, ByVal voltDcRes As Double) As Long

Declare Function hpe1411_voltDcRes_Q Lib "hpe1411_32.dll" (ByVal vi As Long, voltDcRes As Double) As Long

