
/*#line 1 "hpe1411.cs"*/
/* Copyright (C) 1996-2001 Agilent Technologies      */
/* VXIplug&play Instrument Driver for the Agilent E1411  */

/*================================*/
/*           HPE1411              */
/*================================*/
/* WIN95/NT Framework Rev: 3.0    */
/*================================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1411.c                 */
/*   hpe1411.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   hpe1411.def               */
/*   hpe1411.mak               */
/*   hpe1411.bas               */
/*=============================*/

#include <stdlib.h>		/* prototype for malloc() */
#include <string.h>		/* prototype for strcpy() */
#include <stdio.h>		/* prototype for sprintf() */
#include <malloc.h>		/* needed for halloc and hfree */
#include "cscpiv.h"		/* includes cscpi and visa calls */
#include <windows.h>
#define INSTR_CALLBACKS		/* needed to get handler types in hpe1411.h */
#include "hpe1411.h"

/**********/
/* Special Block handling header functions follow. */
/**********/

ViStatus hpe1411_print_header( ViSession vi,
                            ViInt32   length );

ViStatus hpe1411_printDab8( ViSession vi,
                         ViInt32   length,
                         ViChar    *buffer );


ViStatus hpe1411_printDab16Swap( ViSession vi,
                              ViInt32   length,
                              ViPInt16  b      );


ViStatus hpe1411_printDab64swap( ViSession vi,
                              ViInt32   length,
                              ViPReal64 b       );


ViStatus hpe1411_scan8( ViSession vi,
                     ViInt32   max_length,
                     ViPChar   b,
                     ViPInt32  rtn_count  );


ViStatus hpe1411_scan16( ViSession vi,
                      ViInt32   max_length,
                      ViPChar   b,
                      ViPInt32  rtn_count,
                      ViBoolean swap        );


ViStatus hpe1411_scan64( ViSession vi,
                      ViInt32   max_length,
                      ViPReal64 f64_array,
                      ViPInt32  rtn_count,
                      ViBoolean swap        );

#define hpe1411_MODEL_CODE 0xff38	
#define hpe1411_MANF_ID     4095
#define hpe1411_IDN_STRING  "HEWLETT-PACKARD,E1411"
#define hpe1411_IDN_STRING2  "HEWLETT-PACKARD,E1326"

#define hpe1411_REV_CODE "A.02.11"  /* Driver Revision */	/* ??? you must change this */

#define hpe1411_ERR_MSG_LENGTH 256  /* size of error message buffer */

#define hpe1411_MAX_STAT_HAP 7		    /* number of happenings */
#define hpe1411_MAX_STAT_REG 4		    /* number of IEEE 488.2 status registers */

/* this has to match the index of the ESR register in hpe1411_accessInfo[] */
#define hpe1411_ESR_REG_IDX 2

/* this needs to match the index location of hpe1411_USER_ERROR_HANDLER
 * in the hpe1411_statusHap[] array.  Normally, this is zero.
 */
#define hpe1411_USER_ERROR_HANDLER_IDX 0

/*=============================================================== 
 *
 *  All messages are stored in this area to aid in localization 
 *
 *=============================================================== 
 */


#define hpe1411_MSG_VI_OPEN_ERR 				\
	"vi was zero.  Was the hpe1411_init() successful?"

#define hpe1411_MSG_CONDITION					\
	"condition"
	/* hpe1411_statCond_Q() */

#define hpe1411_MSG_EVENT						\
	"event"	
	/* hpe1411_statEvent_Q() */

#define hpe1411_MSG_EVENT_HDLR_INSTALLED				\
	"event handler is already installed for event happening"
	/* hpe1411_statEvent_Q() */

#define hpe1411_MSG_EVENT_HDLR_INST2				\
	"Only 1 handler can be installed at a time."	
	/* hpe1411_statEvent_Q() */


#define hpe1411_MSG_INVALID_HAPPENING				\
	"is not a valid happening."
	/* hpe1411_statCond_Q() */
	/* hpe1411_statEven_Q() */
	/* hpe1411_statEvenHdlr() */
	/* hpe1411_statEvenHdlr_Q() */

#define hpe1411_MSG_NOT_QUERIABLE					\
	"is not queriable."	
	/* hpe1411_statCond_Q() */
	/* hpe1411_statEven_Q() */


#define hpe1411_MSG_IN_FUNCTION					\
	"in function" 		
	/* hpe1411_error_message() */

#define hpe1411_MSG_INVALID_STATUS					\
  	"Parameter 2 is invalid"				\
	"in function hpe1411_error_message()."
	/* hpe1411_error_message() */

#define hpe1411_MSG_INVALID_STATUS_VALUE				\
	"is not a valid viStatus value."
	/* hpe1411_error_message() */

#define  hpe1411_MSG_INVALID_VI					\
  	"Parameter 1 is invalid"				\
	" in function hpe1411_error_message()"			\
	".  Using an inactive ViSession may cause this error."	\
	"  Was the instrument driver closed prematurely?"
	/* hpe1411_message_query() */

#define hpe1411_MSG_NO_ERRORS					\
	"No Errors"
	/* hpe1411_error_message() */

#define hpe1411_MSG_SELF_TEST_FAILED 				\
	"Self test failed." 	
	/* hpe1411_self_test() */

#define hpe1411_MSG_SELF_TEST_PASSED 				\
	"Self test passed."
	/* hpe1411_self_test() */

/* the following messages are used by the functions to check parameters */

#define hpe1411_MSG_BOOLEAN   "Expected 0 or 1; Got %d"

#define hpe1411_MSG_REAL   "Expected %lg to %lg; Got %lg"
   
#define hpe1411_MSG_INT   "Expected %hd to %hd; Got %hd"

#define hpe1411_MSG_LONG   "Expected %ld to %ld; Got %ld"

#define hpe1411_MSG_LOOKUP "Error converting string response to integer"

#define hpe1411_MSG_NO_MATCH "Could not match string %s"

/* 
 * static error message 
 */

#define VI_ERROR_PARAMETER1_MSG				\
	"Parameter 1 is invalid"

#define VI_ERROR_PARAMETER2_MSG				\
	"Parameter 2 is invalid"

#define VI_ERROR_PARAMETER3_MSG				\
	"Parameter 3 is invalid"

#define VI_ERROR_PARAMETER4_MSG				\
	"Parameter 4 is invalid"

#define VI_ERROR_PARAMETER5_MSG				\
	"Parameter 5 is invalid"

#define VI_ERROR_PARAMETER6_MSG				\
	"Parameter 6 is invalid"

#define VI_ERROR_PARAMETER7_MSG				\
	"Parameter 7 is invalid"

#define VI_ERROR_PARAMETER8_MSG				\
	"Parameter 8 is invalid"

#define VI_ERROR_PARAMETER9_MSG				\
	"Parameter 9 is invalid"

#define VI_ERROR_PARAMETER10_MSG			\
	"Parameter 10 is invalid"

#define VI_ERROR_PARAMETER11_MSG			\
	"Parameter 11 is invalid"

#define VI_ERROR_PARAMETER12_MSG			\
	"Parameter 12 is invalid"

#define VI_ERROR_PARAMETER13_MSG			\
	"Parameter 13 is invalid"

#define VI_ERROR_PARAMETER14_MSG			\
	"Parameter 14 is invalid"

#define VI_ERROR_PARAMETER15_MSG			\
	"Parameter 15 is invalid"

#define VI_ERROR_PARAMETER16_MSG			\
	"Parameter 16 is invalid"

#define VI_ERROR_PARAMETER17_MSG			\
	"Parameter 17 is invalid"

#define VI_ERROR_PARAMETER18_MSG			\
	"Parameter 18 is invalid"

#define VI_ERROR_FAIL_ID_QUERY_MSG				\
	"Instrument IDN does not match."

#define INSTR_ERROR_INV_SESSION_MSG 				\
	"ViSession (parmeter 1) was not created by this driver"

#define INSTR_ERROR_NULL_PTR_MSG				\
	"NULL pointer detected"

#define INSTR_ERROR_RESET_FAILED_MSG				\
	"reset failed"

#define INSTR_ERROR_UNEXPECTED_MSG 				\
	"An unexpected error occurred"

#define INSTR_ERROR_DETECTED_MSG			\
	"Instrument Error Detected, call hpe1411_error_query()."

#define INSTR_ERROR_OVERLOAD_MSG			\
	"Device Dependent Error - possible overload, connect Lo to Com ."

#define INSTR_ERROR_LOOKUP_MSG   				\
	"String not found in table"

/*================================================================*/

#define hpe1411_DEBUG_CHK_THIS( vi, thisPtr) 			\
	/* check for NULL user data */				\
	if( 0 == thisPtr)					\
	{							\
 		hpe1411_LOG_STATUS(                             	\
		  vi, NULL, hpe1411_INSTR_ERROR_INV_SESSION );	\
	}							\
	{							\
		ViSession defRM;				\
								\
		/* This should never fail */			\
		errStatus = viGetAttribute( vi,                 \
			VI_ATTR_RM_SESSION, &defRM);		\
		if( VI_SUCCESS > errStatus )			\
		{						\
 			hpe1411_LOG_STATUS(				\
			  vi, NULL, hpe1411_INSTR_ERROR_UNEXPECTED );	\
		}						\
		if( defRM != thisPtr->defRMSession)		\
		{						\
 			hpe1411_LOG_STATUS(				\
			  vi, NULL, hpe1411_INSTR_ERROR_INV_SESSION );	\
		}						\
	}

#define hpe1411_DEBUG_CHK_NULL_PTR( vi, ptr) 			\
	if( 0 == ptr) 						\
	{							\
 		hpe1411_LOG_STATUS( 				\
		   vi, NULL, hpe1411_INSTR_ERROR_NULL_PTR );	\
	}

#define hpe1411_CDE_INIT( funcname)  				\
	strcpy(thisPtr->errFuncName, funcname);			\
	thisPtr->errNumber = VI_SUCCESS;			\
	thisPtr->errMessage[0] = 0;

#define hpe1411_CDE_MESSAGE( message ) 	 			\
	strcpy(thisPtr->errMessage, message)

#define hpe1411_CDE_ERROR( status)					\
	thisPtr->errNumber = status		




struct hpe1411_eventHdlrStruct
{
	hpe1411_InstrEventHandler eventHandler;
	ViAddr userData;
};

struct hpe1411_globals
{
	ViSession			defRMSession;

	ViStatus			errNumber;
	char 				errFuncName[40];
	char				errMessage[160];

	ViBoolean			errQueryDetect;

	ViInt32 			driverEventArray[hpe1411_MAX_STAT_REG];
	ViInt32 			numEventHandlers;
	struct hpe1411_eventHdlrStruct	eventHandlerArray[hpe1411_MAX_STAT_HAP];
	ViBoolean			e1406; /* 1 if gpib to 1406*/

	ViBoolean			dirtyBit; /* 1 if hpe1411_scpi called */
        /* Setting this to VI_TRUE,
         * will prevent I/O from occuring in an SRQ
         * This is needed, because VTL 3.0 doesn't provide
         * an atomic write/read operations.  Don't want
         * to do I/O if the driver is in the middle of
         * a read from the instrument.
         */
        ViBoolean                       blockSrqIO;
        ViInt32                         countSrqIO;
};
/* add the following to the globals data structure */

/* Note: for debugging, you can add __FILE__, __LINE__ as parameters
 * to hpe1411_LOG_STATUS, and ViString filename, and ViInt32 lineNumber to
 * hpe1411_statusUpdate() in order to determine exactly where an error
 * occured in a driver.
 */
#define hpe1411_LOG_STATUS( vi, thisPtr, status ) 	\
  return hpe1411_statusUpdate( vi, thisPtr, status)

/* declare this here since it is called by statusUpdate */
static void hpe1411_srqTraverse(ViSession vi, ViInt32 eventReg);

static ViStatus hpe1411_statusUpdate(
  ViSession vi,
  struct hpe1411_globals *thisPtr,
  ViStatus status
  )
{
	ViInt32  eventQ;

	/* ALL functions exit through here.
	 *
	 * this allows errors to be trapped and
	 * a user error handler could be called.
	 */

	/* can do nothing without state structure*/
	if (!thisPtr) return status;

	/* Check if user wants to query the instrument state.
         * This is only done, if the vi is valid and 
         * no other errors has occured.
         */
	if( VI_TRUE == thisPtr->errQueryDetect && 
            VI_SUCCESS <= status &&
            vi != VI_NULL )
	{
		/* assume IEEE 488.2 Instrument and query standard
                 * status event register for a parser error
                 */	
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			status = viPrintf(vi, "*esr?\n");
			if( VI_SUCCESS <= status) 
			{

				status = viScanf(vi, "%ld%*t\n", &eventQ);
			}  /* viPrintf was successful */
		} 
		else
		{
			{{ struct {double p1[1];} out_;
/*#line 398 "hpe1411.cs"*/
{extern com_esr_q();if (!instr_query(vi,com_esr_q,(void*)0,&out_)){
/*#line 398 "hpe1411.cs"*/
*&eventQ=(*(HPSL_INT16*)out_.p1).num;}}}}
		}
		if( VI_SUCCESS <= status)
		{

		    /* update driver's copy of the esr register 
       		     * This index 'hpe1411_ESR_REG_IDX' should 
		     * match the access event register array 
		     * and correspond to the 
      		     * standard event status register.
       		     */
		    thisPtr->driverEventArray[hpe1411_ESR_REG_IDX] = 
		      thisPtr->driverEventArray[hpe1411_ESR_REG_IDX] | eventQ;

		    /* see if the instrument thinks an error occured */
		    if( (  0x04 /* Query Error */
                      | 0x10 /* Execution Error */
                      | 0x20 /* Command Error */
                    ) & eventQ )
		    {
			/* set our error status, to indicate that a 
			 * instrument error occured.
                         */
			status =  hpe1411_INSTR_ERROR_DETECTED;
		    } 
                    else if( 0x08 & eventQ ) /* Device Dependent Error */
                    {
			status =  hpe1411_INSTR_ERROR_OVERLOAD;
                    }
		} /* INST_QUERY or viScanf was successful */
	} /* if we need to query the instrument */	

        /* check if we need to service SRQ events */
        if( 0 != thisPtr->countSrqIO && VI_NULL != vi )
        {
            ViStatus errStatus;

            /* suspend event processing for now */
            errStatus = viEnableEvent( vi,
              VI_EVENT_SERVICE_REQ, VI_SUSPEND_HNDLR, VI_NULL);
            if( VI_SUCCESS > errStatus )
            {
                /* an existing error message has priority */
                if( VI_SUCCESS <= status)
                {
                    /* no existing error message, so set new error */
                    status = errStatus;
                }
            } /* if - an error occured */
            else
            {
                /* reset the srq counter */
                thisPtr->countSrqIO = 0;

                /* recursively traverse status byte */
                hpe1411_srqTraverse( vi, 0);

                /* re-enable event processing */
                errStatus = viEnableEvent( vi, VI_EVENT_SERVICE_REQ,
                  VI_HNDLR, VI_NULL);
                if( VI_SUCCESS > errStatus )
                {
                    /* an existing error message has priority */
                    if( VI_SUCCESS <= status)
                    {
                        /* no existing error message, so set new error */
                        status = errStatus;
                    }
                } /* if - an error occured */

            } /* else - no error in viEnableEvent */

        } /* if - srq needs servicing */

        /* unblock IO in SRQs */
        thisPtr->blockSrqIO = VI_FALSE;

	/* store the context dependent error number */
	hpe1411_CDE_ERROR(status);

	/* if an error occurs, see if the user has an error handler enabled */
        if( status != hpe1411_INSTR_ERROR_DETECTED &&
            status != hpe1411_INSTR_ERROR_OVERLOAD &&
	    VI_SUCCESS > status &&
	    thisPtr->eventHandlerArray[
	        hpe1411_USER_ERROR_HANDLER_IDX].eventHandler)
	{
		/* call the users handler */
		thisPtr->eventHandlerArray[
		    hpe1411_USER_ERROR_HANDLER_IDX].eventHandler(
			vi, (ViInt32)status, 
			thisPtr->eventHandlerArray[
			    hpe1411_USER_ERROR_HANDLER_IDX].userData);
	}

	/* return the appropriate error number */
	return status;
}





/* 
 * Error Message Structures
 */

struct instrErrStruct
{
	ViStatus errStatus;
	ViString errMessage;
};

const static struct instrErrStruct instrErrMsgTable[] =
{
        { VI_ERROR_PARAMETER1,	VI_ERROR_PARAMETER1_MSG },
        { VI_ERROR_PARAMETER2,	VI_ERROR_PARAMETER2_MSG },
        { VI_ERROR_PARAMETER3,	VI_ERROR_PARAMETER3_MSG },
        { VI_ERROR_PARAMETER4,	VI_ERROR_PARAMETER4_MSG },
        { VI_ERROR_PARAMETER5,	VI_ERROR_PARAMETER5_MSG },
        { VI_ERROR_PARAMETER6,	VI_ERROR_PARAMETER6_MSG },
        { VI_ERROR_PARAMETER7,	VI_ERROR_PARAMETER7_MSG },
        { VI_ERROR_PARAMETER8,	VI_ERROR_PARAMETER8_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER9,	VI_ERROR_PARAMETER9_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER10,	VI_ERROR_PARAMETER10_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER11,	VI_ERROR_PARAMETER11_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER12,	VI_ERROR_PARAMETER12_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER13,	VI_ERROR_PARAMETER13_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER14,	VI_ERROR_PARAMETER14_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER15,	VI_ERROR_PARAMETER15_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER16,	VI_ERROR_PARAMETER16_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER17,	VI_ERROR_PARAMETER17_MSG },
        { hpe1411_INSTR_ERROR_PARAMETER18,	VI_ERROR_PARAMETER18_MSG },
        { VI_ERROR_FAIL_ID_QUERY,	VI_ERROR_FAIL_ID_QUERY_MSG },

	{ hpe1411_INSTR_ERROR_INV_SESSION,	INSTR_ERROR_INV_SESSION_MSG },
        { hpe1411_INSTR_ERROR_NULL_PTR,	INSTR_ERROR_NULL_PTR_MSG },
        { hpe1411_INSTR_ERROR_RESET_FAILED,INSTR_ERROR_RESET_FAILED_MSG },
        { hpe1411_INSTR_ERROR_UNEXPECTED,	INSTR_ERROR_UNEXPECTED_MSG },
	{ hpe1411_INSTR_ERROR_DETECTED,	INSTR_ERROR_DETECTED_MSG },
	{ hpe1411_INSTR_ERROR_OVERLOAD,	INSTR_ERROR_OVERLOAD_MSG },
	{ hpe1411_INSTR_ERROR_LOOKUP,	INSTR_ERROR_LOOKUP_MSG },
};

/* macros for testing parameters */
#define hpe1411_CHK_BOOLEAN( my_val, err ) if( hpe1411_chk_boolean( thisPtr, my_val) ) hpe1411_LOG_STATUS( vi, thisPtr, err);

static ViBoolean hpe1411_chk_boolean(
  struct hpe1411_globals *thisPtr,
  ViBoolean my_val)
{
   char message[hpe1411_ERR_MSG_LENGTH];
   if( (my_val != VI_TRUE) && (my_val != VI_FALSE) )
   {
      /* true = parameter is invalid */
      sprintf(message, hpe1411_MSG_BOOLEAN, my_val);	
      hpe1411_CDE_MESSAGE(message);				
      /* true = parameter is invalid */
      return VI_TRUE;
   }

   /* false = okay */
   return VI_FALSE;
}


#define hpe1411_CHK_REAL_RANGE( my_val, min, max, err ) if( hpe1411_chk_real_range( thisPtr, my_val, min, max) ) hpe1411_LOG_STATUS( vi, thisPtr, err);

static ViBoolean hpe1411_chk_real_range( 
  struct hpe1411_globals *thisPtr,
  ViReal64 my_val,
  ViReal64 min,
  ViReal64 max)
{
   char message[hpe1411_ERR_MSG_LENGTH];

   if ( ( my_val < min ) || (my_val > max) )  			
   {								
      sprintf(message, hpe1411_MSG_REAL, min, max, my_val);	
      hpe1411_CDE_MESSAGE(message);				
      /* true = parameter is invalid */
      return VI_TRUE;
   }
   return VI_FALSE;
} 
   
#define hpe1411_CHK_INT_RANGE( my_val, min, max, err ) if( hpe1411_chk_int_range( thisPtr, my_val, min, max) ) hpe1411_LOG_STATUS( vi, thisPtr, err);

static ViBoolean hpe1411_chk_int_range( 
  struct hpe1411_globals *thisPtr,
  ViInt16 my_val,
  ViInt16 min,
  ViInt16 max)
{
   char message[hpe1411_ERR_MSG_LENGTH];

   if ( ( my_val < min ) || (my_val > max) )  			
   {								
      sprintf(message, hpe1411_MSG_INT, min, max, my_val);	
      hpe1411_CDE_MESSAGE(message);				
      /* true = parameter is invalid */
      return VI_TRUE;
   }
   return VI_FALSE;
} 
   
   
#define hpe1411_CHK_LONG_RANGE( my_val, min, max, err ) if( hpe1411_chk_long_range( thisPtr, my_val, min, max) ) hpe1411_LOG_STATUS( vi, thisPtr, err);

static ViBoolean hpe1411_chk_long_range( 
  struct hpe1411_globals *thisPtr,
  ViInt32 my_val,
  ViInt32 min,
  ViInt32 max)
{
   char message[hpe1411_ERR_MSG_LENGTH];

   if ( ( my_val < min ) || (my_val > max) )  			
   {								
      sprintf(message, hpe1411_MSG_LONG, min, max, my_val);	
      hpe1411_CDE_MESSAGE(message);				
      /* true = parameter is invalid */
      return VI_TRUE;
   }
   return VI_FALSE;
} 
   
   
#define hpe1411_CHK_ENUM( my_val, limit, err ) if( hpe1411_chk_enum( thisPtr, my_val, limit) ) hpe1411_LOG_STATUS( vi, thisPtr, err);

/* utility routine which searches for a string in an array of strings. */
/* This is used by the CHK_ENUM macro */
static ViBoolean hpe1411_chk_enum (
  struct hpe1411_globals *thisPtr,
  ViInt16 my_val,
  ViInt16 limit)
{
    char message[hpe1411_ERR_MSG_LENGTH];

    if ( ( my_val < 0 ) || (my_val > limit) )  			
    {								
        sprintf(message, hpe1411_MSG_INT, 0, limit, my_val);	
        hpe1411_CDE_MESSAGE(message);				
        /* true = parameter is invalid */
        return VI_TRUE;
    }

    return VI_FALSE;
}



/*  ==========================================================================  
     This function searches an array of strings for a specific string and     
     returns its index.  If successful, a VI_SUCCESS is returned, 
     else hpe1411_INSTR_ERROR_LOOKUP is returned.
    ======================================================================== */
ViStatus hpe1411_findIndex (struct hpe1411_globals *thisPtr,
			const char * const array_of_strings[],
			  /*last entry in array must be 0 */
			const char *string, /* string read from instrument */
			ViPInt16 index) /* result index */
{
    ViInt16 i;
    ViInt16 my_len;
    char search_str[20];
    char message[80];

    strcpy(search_str, string);

  /* get rid of newline if present in string */
  /* needed because %s includes newline in some VTL's */
    my_len = strlen(search_str);
    if (search_str[my_len - 1] == '\n')
       search_str[my_len - 1] = '\0';

    for (i = 0; array_of_strings[i]; i++)
    {
	if (!strcmp (array_of_strings[i], search_str))
	{
	    *index = i;
	    return VI_SUCCESS;
	}
    }

  /* if we got here, we did not find it */
    sprintf(message, hpe1411_MSG_NO_MATCH, search_str);	
    hpe1411_CDE_MESSAGE(message);				
    return hpe1411_INSTR_ERROR_LOOKUP;
}

static const ViStatus cscpi_error_to_vi_error[] = {
	VI_ERROR_SYSTEM_ERROR,
	VI_ERROR_SYSTEM_ERROR, /* should never happen*/
	VI_ERROR_FAIL_ID_QUERY, /* 2 wrong card type*/
	VI_ERROR_ALLOC,		/* 3 out of memory*/
	VI_ERROR_INV_RSRC_NAME, /* 4 bad address*/
	VI_ERROR_RSRC_NFOUND,	/* 5 open failed*/
	VI_ERROR_SYSTEM_ERROR, /*  6 open go system error*/
	VI_ERROR_SYSTEM_ERROR, /*  7 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  8 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  9 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  10 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  11 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  12 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  13 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  14 internal errors*/
};


/****************************************************************************
hpe1411_init
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | InstrDesc                                         ViRsrc      IN
  |   ---------------------------------------------------------------------
  |  | The Instrument Description.
  |  |
  |  | Examples: VXI::5, GPIB-VXI::128::INSTR
   ------------------------------------------------------------------------
  | id_query                                          ViBoolean   IN
  |   ---------------------------------------------------------------------
  |  | if( VI_TRUE) Perform In-System Verification.
  |  | if(VI_FALSE) Do not perform In-System Verification
   ------------------------------------------------------------------------
  | do_reset                                          ViBoolean   IN
  |   ---------------------------------------------------------------------
  |  | IF( VI_TRUE) Perform Reset Operation.
  |  | if(VI_FALSE) Do not perform Reset operation
   ------------------------------------------------------------------------
  | vi                                                ViPSession  OUT
  |   ---------------------------------------------------------------------
  |  | Instrument Handle. This is VI_NULL if an error occurred
  |  | during the init.

*****************************************************************************/

ViStatus _VI_FUNC hpe1411_init (
  ViRsrc InstrDesc, 
  ViBoolean id_query,
  ViBoolean do_reset,
  ViPSession vi )
{
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;
	ViSession defRM;
	ViUInt16 intf;

	ViUInt16 manfId;
	ViUInt16 modelCode;

	ViInt32 idx;

	*vi = VI_NULL;

 
	/* Find the Default Resource Manager */
	errStatus = viOpenDefaultRM( &defRM);
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_SYSTEM_ERROR 
		 *         VI_ERROR_ALLOC
		 */
		hpe1411_LOG_STATUS( *vi, NULL, errStatus);
	}

	/* Open a session to the instrument */
	errStatus = viOpen( defRM, InstrDesc, VI_NULL, VI_NULL, vi);
	if( VI_SUCCESS > errStatus)
	{
		/* can't open using vtl, try register based open*/
		intf = VI_INTF_VXI;
		goto gpib_check_done;
	}
	
	if( errStatus = viGetAttribute( *vi, VI_ATTR_INTF_TYPE, &intf) )
	{
		viClose( *vi);
		viClose( defRM);
		*vi = VI_NULL;
		hpe1411_LOG_STATUS( *vi, NULL, errStatus);
	}

	/* check for 1406 internal driver by reading *IDN? of 0 and
		*IDN? of secondary for this address*/
	if (intf == VI_INTF_GPIB_VXI)
	{
		char gpibdesc[64];
		ViUInt16 num, primary, secondary;
		ViSession vi1406;
		char idn_buf[256];

		/* Can't use VI_ATTR_INTF_NUM since
		/* HP VTL 3.0 has a defect which returns 7 instead of 0*/
		/* Read the number from the descriptor instead, assuming
			it's GPIB-VXIn.
		/* Set the GPIB board number is the same had the GPIB-VXI 
			board number*/
		if (memcmp(InstrDesc, "GPIB-VXI", 8) || 
			InstrDesc[8] < '0' || InstrDesc[8] > '9')
			num = 0;
		else
			num = (ViUInt16) atoi(InstrDesc+8);
		viGetAttribute(*vi, VI_ATTR_GPIB_PRIMARY_ADDR, &primary);
		sprintf(gpibdesc, "GPIB%hd::%hd::0", num,	primary);
		errStatus = viOpen( defRM, gpibdesc, VI_NULL, VI_NULL, 
					&vi1406);
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		/* try sending an IDN? to 1406 */
		viSetAttribute(vi1406, VI_ATTR_TMO_VALUE, 1000); 
		errStatus = viClear(vi1406);
		if (errStatus < VI_SUCCESS)
		{
			viClose(vi1406);
			goto gpib_check_done;
		}

		errStatus = viPrintf(vi1406, "*IDN?\n");
		if (errStatus < VI_SUCCESS)
		{
			viClose(vi1406);
			goto gpib_check_done;
		}

		/* it worked, try getting response and check it*/
		errStatus = viScanf( vi1406, "%t", idn_buf);
		viClose(vi1406);
		if (errStatus < VI_SUCCESS || 
				memcmp(idn_buf, "HEWLETT-PACKARD,E140", 20))
			goto gpib_check_done;

		/* try sending an IDN? to the card drivers*/
		viSetAttribute(*vi, VI_ATTR_TMO_VALUE, 1000); 
		errStatus = viClear(*vi);
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		errStatus = viPrintf(*vi, "*IDN?\n");
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		/* it worked, try getting response*/
		errStatus = viScanf( *vi, "%t", idn_buf);
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		/* got an answer so switch vi to gpib mode */
		viGetAttribute(*vi, VI_ATTR_GPIB_SECONDARY_ADDR, &secondary);
		sprintf(gpibdesc, "GPIB%hd::%hd::%hd", num, primary, secondary);
		viClose(*vi);
		errStatus = viOpen( defRM, gpibdesc, VI_NULL, VI_NULL, vi);
		if( errStatus < VI_SUCCESS)
		{ /* this should never happen*/	
			viClose( defRM);
			*vi = VI_NULL;
			hpe1411_LOG_STATUS( *vi, NULL, errStatus);
		}
		intf = VI_INTF_GPIB;
	}

gpib_check_done:

	/* get memory for instance specific globals */
	thisPtr = (struct hpe1411_globals *)malloc(sizeof( struct hpe1411_globals) );
	if( 0 == thisPtr)
	{
		viClose( defRM);	/* also closes vi session */
		*vi = VI_NULL;
		hpe1411_LOG_STATUS(*vi, NULL, VI_ERROR_ALLOC);
	}

	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		/* associate memory with session, should not fail because
		 *   session is valid; and attribute is defined, supported,
		 *   and writable.
		 */
		errStatus = viSetAttribute( 
		              *vi, 
			      VI_ATTR_USER_DATA, 
		              (ViAttrState)thisPtr); 
		if( VI_SUCCESS > errStatus)
		{
			viClose( *vi);
			viClose( defRM);	/* also closes vi session */
			*vi = VI_NULL;
			hpe1411_LOG_STATUS(*vi, NULL, errStatus);
		}
		thisPtr->e1406 = 1;
	}
	else
	{
		/* reg based drivers open their own sessions*/
		viClose( defRM);	/* also closes vi session */

		/* start pos if not started*/
		os_init();/* STARTUP */

		{extern vm_header_fn();*vi = os_open(InstrDesc,vm_header_fn);}

		if (!*vi)
		{
			if (cscpi_open_error >= 0 && cscpi_open_error <= 14)
				hpe1411_LOG_STATUS(*vi, NULL,
			       	cscpi_error_to_vi_error[cscpi_open_error]);
			else
				hpe1411_LOG_STATUS(*vi, NULL, VI_ERROR_SYSTEM_ERROR);
		}

		/* associate memory with session */
		instr_setdata(*vi, thisPtr); 
		thisPtr->e1406 = 0;
	}
	/* initialize instance globals */
	viGetAttribute( *vi, VI_ATTR_RM_SESSION, &thisPtr->defRMSession);
        thisPtr->errNumber = VI_SUCCESS;
	thisPtr->errFuncName[0] = 0;
	thisPtr->errMessage[0] = 0;
	thisPtr->errQueryDetect = VI_FALSE;
        thisPtr->blockSrqIO = VI_FALSE;
        thisPtr->countSrqIO = 0;
        thisPtr->dirtyBit = 0;


	for( idx=0;idx<hpe1411_MAX_STAT_REG; idx++)
	{
	    thisPtr->driverEventArray[idx] = 0;
	}
	thisPtr->numEventHandlers = 0;
	for( idx=0;idx<hpe1411_MAX_STAT_HAP; idx++)
	{
	    thisPtr->eventHandlerArray[idx].eventHandler = NULL;
	    thisPtr->eventHandlerArray[idx].userData = 0;
	}
	
	if( VI_TRUE == do_reset ) 
	{
		/* call the reset function to reset the instrument */
		if( hpe1411_dcl(*vi)<VI_SUCCESS || hpe1411_reset(*vi)< VI_SUCCESS )
		{
			/* ignore any errors in PREFIX_close */
			hpe1411_close( *vi);
                        *vi=VI_NULL;
			hpe1411_LOG_STATUS( *vi, NULL, 
			  hpe1411_INSTR_ERROR_RESET_FAILED);
		}
		Sleep(100);
	}

	if( VI_TRUE == id_query ) 
	{
		char     idn_buf[256];

		/* find the interface type */
		if( errStatus = viGetAttribute( *vi, VI_ATTR_INTF_TYPE, &intf) )
		{	
			/* Errors: VI_ERROR_NSUP_ATTR */

			/* ignore any errors in PREFIX_close */
			hpe1411_close( *vi);
                        *vi=VI_NULL;
	
			hpe1411_LOG_STATUS( *vi, NULL, errStatus);
		}

		switch( intf)
		{
			case VI_INTF_GPIB:
				if (
				    viPrintf(*vi, "*IDN?\n") < VI_SUCCESS ||
				    viScanf(*vi, "%t", idn_buf) < VI_SUCCESS ||
				    /* check for a idn match */
				    strncmp(idn_buf, hpe1411_IDN_STRING, 
					    strlen(hpe1411_IDN_STRING))   
				    )
                		{   
					/* ignore any errors in PREFIX_close */
					hpe1411_close( *vi);
                                        *vi=VI_NULL;
					hpe1411_LOG_STATUS( *vi, NULL,
					  VI_ERROR_FAIL_ID_QUERY);
                		}

				break;

			case VI_INTF_VXI:
			case VI_INTF_GPIB_VXI:
	
				/* find the VXI manfacturer's ID */
				errStatus = viGetAttribute( *vi, 
				    VI_ATTR_MANF_ID, &manfId);
				if( VI_SUCCESS > errStatus)
				{	
					/* Errors: VI_ERROR_NSUP_ATTR */
	
					/* ignore any errors in PREFIX_close */
					hpe1411_close( *vi);
                                        *vi=VI_NULL;
	
					hpe1411_LOG_STATUS( *vi, NULL,
					  errStatus);
				}

				/* find the instrument's model code */
				errStatus = viGetAttribute( *vi, 
				    VI_ATTR_MODEL_CODE, 
		       		(ViPAttrState)(&modelCode)); 
				if( VI_SUCCESS > errStatus)
				{	
					/* Errors: VI_ERROR_NSUP_ATTR */
					/* Note: this should never happen 
					 *   with a VXI instrument
					 */

					/* ignore any errors in PREFIX_close */
					hpe1411_close( *vi);
                                        *vi=VI_NULL;
					hpe1411_LOG_STATUS( *vi, NULL, errStatus);
				}

				if( (manfId != hpe1411_MANF_ID) || 
				    (modelCode != hpe1411_MODEL_CODE) )
				{
					/* ignore any errors in PREFIX_close */
					hpe1411_close( *vi);
                                        *vi = VI_NULL;

					hpe1411_LOG_STATUS( *vi, NULL,
					  VI_ERROR_FAIL_ID_QUERY);
				}

				break;

			default:
				/* ignore any errors in PREFIX_close */
				hpe1411_close( *vi);
				*vi = VI_NULL;
				hpe1411_LOG_STATUS( *vi, NULL,
				  hpe1411_INSTR_ERROR_UNEXPECTED);

		}	

	} /* if - id_query */

 /* set the format to REAL,64 for data transfers */

        if (thisPtr->e1406)
        {
    	    errStatus = viPrintf(*vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( *vi, thisPtr, errStatus );
            }
        }
        else
            {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 1056 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 1056 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 1056 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 1056 "hpe1411.cs"*/
{extern vm_format();instr_send(*vi,vm_format,&in_);}}}

	hpe1411_LOG_STATUS( *vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
hpe1411_close
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_close (
  ViSession vi )
{
	ViUInt16 intf;
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;
	ViSession defRM;

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		hpe1411_LOG_STATUS( vi, NULL, errStatus);
	}
	hpe1411_DEBUG_CHK_THIS( vi, thisPtr);

	/* free memory */
	if( thisPtr)		
	{
            ViStatus e;
	    /* make sure there is something to free */
	    if (thisPtr->e1406)
	    {
		/* retrieve Resource Management session */
		defRM = thisPtr->defRMSession;
		/* close the vi and RM sessions */
		e = viClose( defRM);
		free( thisPtr);
                return e;
	    }
	    else
	    {
		free( thisPtr);
		os_close(vi);
	    }

	}	
        else
        {
		os_close(vi);
        }

	return VI_SUCCESS;
}


/****************************************************************************
hpe1411_reset
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_reset (
  ViSession vi )
{
	ViUInt16 intf;
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		hpe1411_LOG_STATUS( vi, NULL, errStatus);
	}
	hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
	hpe1411_CDE_INIT( "hpe1411_reset");

	if (thisPtr->e1406)
	{
	    errStatus = viPrintf( vi, "*RST\n");
	    if( VI_SUCCESS > errStatus)
	    {
	        hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
	    }
	    errStatus = viPrintf( vi, "FORM REAL,64\n");
	}
	else
	{
	    {{ 
/*#line 1172 "hpe1411.cs"*/
{extern vm_rst();instr_send(vi,vm_rst,(void*)0);}}}
	    {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 1173 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 1173 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 1173 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 1173 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
	}
	if( VI_SUCCESS > errStatus)
	{
	    hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
	}

        thisPtr->dirtyBit = 0; /* clear dirty bit */

	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}


/****************************************************************************
hpe1411_self_test
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | test_result                                       ViPInt16    OUT
  |   ---------------------------------------------------------------------
  |  | Numeric result from self-test operation
  |  |
  |  | 0 = no error ( test passed)
  |  | 1 = failure
   ------------------------------------------------------------------------
  | test_message                                      ViChar _VI_FAR []OUT
  |   ---------------------------------------------------------------------
  |  | Self-test status message.  This is limited to 256 characters.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_self_test (
  ViSession vi,
  ViPInt16 test_result,
  ViChar _VI_FAR test_message[])
{
	ViUInt16 intf;
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;

	/* initialize output parameters */
	*test_result = -1; 
	test_message[0] = 0; 

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		hpe1411_LOG_STATUS( vi, NULL, errStatus);
	}
	hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
	hpe1411_CDE_INIT( "hpe1411_self_test");

	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

		errStatus = viPrintf( vi, "*TST?\n");
		if( VI_SUCCESS > errStatus)
		{	
		
			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}

		errStatus = viScanf( vi, "%hd%*t", test_result);
	}
	else
	{
		{{ struct {double p1[1];} out_;
/*#line 1253 "hpe1411.cs"*/
{extern vm_tst_q();if (!instr_query(vi,vm_tst_q,(void*)0,&out_)){
/*#line 1253 "hpe1411.cs"*/
*test_result=(*(HPSL_INT16*)out_.p1).num;}}}}
	}
	if( VI_SUCCESS > errStatus)
	{
		*test_result = -1; 
		
		hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
	}

	switch( *test_result)
	{
           case 0:
              sprintf(test_message, hpe1411_MSG_SELF_TEST_PASSED);
              break;

	      /*??? add instrument specific cases here*/

           default:
              sprintf(test_message, hpe1411_MSG_SELF_TEST_FAILED);
              break;
        }

	
	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
hpe1411_error_query
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | error_number                                      ViPInt32    OUT
  |   ---------------------------------------------------------------------
  |  | Instruments error code
   ------------------------------------------------------------------------
  | error_message                                     ViChar _VI_FAR []OUT
  |   ---------------------------------------------------------------------
  |  | Instrument's error message.  This is limited to 256 characters.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_error_query (
  ViSession vi,
  ViPInt32 error_number,
  ViChar _VI_FAR error_message[])
{
	ViUInt16 intf;
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;

	/* initialize output parameters */
	*error_number = -1; 
	error_message[0] = 0; 

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		hpe1411_LOG_STATUS( vi, NULL, errStatus);
	}
	hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
	hpe1411_CDE_INIT( "hpe1411_error_query");

	/* get the error number */
	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

	        errStatus = viPrintf( vi, "SYST:ERR?\n");
		if( VI_SUCCESS > errStatus)
		{

			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* get the error number */
		errStatus = viScanf( vi, "%ld,%t", error_number, error_message);
		/* check for error during the scan */
        	if( VI_SUCCESS > errStatus)
		{
			*error_number = -1; 
			error_message[0] = 0; 
			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* get rid of extra LF at the end of the error_message */
		error_message[strlen(error_message)-1] = 0;
	}
	else
	{
        	{{ struct {double p1[1];double p2[1];} out_;
/*#line 1355 "hpe1411.cs"*/
{extern syst_err_q();if (!instr_query(vi,syst_err_q,(void*)0,&out_)){
/*#line 1355 "hpe1411.cs"*/
*error_number=(*(HPSL_INT16*)out_.p1).num;
/*#line 1355 "hpe1411.cs"*/
(void)strcpy((error_message),*(HPSL_STRING*)out_.p2);}}}}
	}

	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
hpe1411_error_message
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init().
  |  | This may be VI_NULL.
   ------------------------------------------------------------------------
  | error_number                                      ViStatus    IN
  |   ---------------------------------------------------------------------
  |  | The error return value from an instrument driver function
   ------------------------------------------------------------------------
  | message                                           ViChar _VI_FAR []OUT
  |   ---------------------------------------------------------------------
  |  | Error message string.  This is limited to 256 characters.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_error_message (
  ViSession vi,
  ViStatus error_number,
  ViChar _VI_FAR message[])
{
	ViUInt16 intf;
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;  
	ViInt32 idx;

	/* initialize output parameters */
	message[0] = 0;

	thisPtr = NULL;

	/* try to find a thisPtr */
	if( VI_NULL != vi)
	{
	    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
		if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
		{
			errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
		}
		else
		{
			errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
		}
		if( VI_SUCCESS > errStatus)
		{
			/* Errors: VI_ERROR_INV_SESSION	*/
			strcpy( message, hpe1411_MSG_INVALID_VI);
			hpe1411_LOG_STATUS( vi, NULL, errStatus);
		}
		hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
	} 

	if( VI_SUCCESS == error_number)
	{
		sprintf( message, hpe1411_MSG_NO_ERRORS);
		hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	}

	/* return the static error message */
	for(idx=0; 
	    idx < (sizeof instrErrMsgTable / 
	           sizeof( struct instrErrStruct));
	    idx++)
	{
		/* check for a matching error number */
		if( instrErrMsgTable[idx].errStatus == error_number)
		{
			if( (thisPtr) &&
			    (thisPtr->errNumber == error_number))
			{
				/* context dependent error
				 * message is available.
				 */
				sprintf( message,
				  "%s " hpe1411_MSG_IN_FUNCTION " %s() %s",
		          	  instrErrMsgTable[idx].errMessage,
				  thisPtr->errFuncName,
				  thisPtr->errMessage);
			}
			else
			{
				/* No context dependent eror 
				 * message available so copy 
				 * the static error message
				 */
				strcpy( message,
		          	  instrErrMsgTable[idx].errMessage);

			}
            
			hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
		}
	}


	/* try VTL/VISA to see if it exists there 
	 *
	 * At this point vi is either VALID or VI_NULL
	 */
	errStatus = viStatusDesc(vi, error_number, message);
	if( VI_SUCCESS == errStatus)
	{
		/* check for a context dependent error message */
		if( (thisPtr) &&
		    (thisPtr->errNumber == error_number))
		{
			/* context dependent error
			 * message is available.
			 */
			strcat( message, " ");
			strcat( message, hpe1411_MSG_IN_FUNCTION);
			strcat( message, " ");
			strcat( message, thisPtr->errFuncName);
			strcat( message, "() ");
			strcat( message, thisPtr->errMessage);
		}

		/* VTL found an error message, so return success */
		hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	}

	/* if we have a VI_NULL, then we need to return a error message */
	if( VI_NULL == vi)
	{
		strcpy(message, hpe1411_MSG_VI_OPEN_ERR);
		hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	} 

	/* user passed in a invalid status */
	sprintf( message, 
	  hpe1411_MSG_INVALID_STATUS
	  "  %ld"
	  hpe1411_MSG_INVALID_STATUS_VALUE
	  , (long)error_number );
	
	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
}


/****************************************************************************
hpe1411_revision_query
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession      IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | driver_rev                                ViChar _VI_FAR []      OUT
  |   ---------------------------------------------------------------------
  |  | Instrument driver revision.  This is limited to 256 characters.
   ------------------------------------------------------------------------
  | instr_rev                                 ViChar _VI_FAR []      OUT
  |   ---------------------------------------------------------------------
  |  | Instrument firmware revision.  This is limited to 256 characters.

*****************************************************************************/

ViStatus _VI_FUNC hpe1411_revision_query (
  ViSession vi,
  ViChar _VI_FAR driver_rev[],
  ViChar _VI_FAR instr_rev[])
{
	ViUInt16 intf;
	struct hpe1411_globals *thisPtr;
	ViStatus errStatus;
        char temp_str[256];		/* temp hold for instr rev string */
        char *last_comma;		/* last comma in *IDN string */

	/* initialize output parameters */
        driver_rev[0] = 0; 
	instr_rev[0] = 0; 

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
			vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		hpe1411_LOG_STATUS( vi, NULL, errStatus);
	}
	hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
	hpe1411_CDE_INIT( "hpe1411_revision_query");

	sprintf( driver_rev, "%s", hpe1411_REV_CODE);

	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

		if( errStatus = viPrintf( vi, "*IDN?\n"))
		{
        		driver_rev[0] = 0; 

			hpe1411_LOG_STATUS( vi, thisPtr, errStatus); 
		}

		if( errStatus = viScanf( vi, "%s%*t", temp_str))
		{
        		driver_rev[0] = 0; 
			instr_rev[0] = 0; 
		 
			hpe1411_LOG_STATUS( vi, thisPtr, errStatus); 
		}
	}
	else
	{
		{{ struct {double p1[1];} out_;
/*#line 1579 "hpe1411.cs"*/
{extern vm_idn_q();if (!instr_query(vi,vm_idn_q,(void*)0,&out_)){
/*#line 1579 "hpe1411.cs"*/
(void)memcpy((temp_str),(*(HPSL_ARB_ASCII*)out_.p1).buffer,(*(HPSL_ARB_ASCII*)out_.p1).length);
/*#line 1579 "hpe1411.cs"*/
(temp_str)[(*(HPSL_ARB_ASCII*)out_.p1).length]='\0';}}}}
	}
	
        last_comma = strrchr(temp_str,',');
	/* error and exit if last comma not found */
        if (!last_comma) 
        {
           instr_rev[0] = 0;
	   hpe1411_CDE_MESSAGE("no last comma found in IDN string" ); 
	   hpe1411_LOG_STATUS( vi, thisPtr, hpe1411_INSTR_ERROR_UNEXPECTED); 
        }

        strcpy(instr_rev, last_comma+1);
	
	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS); 
}

/****************************************************************************
hpe1411_timeOut
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | timeOut                                           ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | This value sets the I/O timeout for all functions in
  |  | the driver. It is specified in milliseconds.

*****************************************************************************/
/* ----------------------------------------------------------------------- */
/* Purpose:  Changes the timeout value of the instrument.  Input is in     */
/*           milliseconds.                                                 */
/* ----------------------------------------------------------------------- */
ViStatus _VI_FUNC hpe1411_timeOut (ViSession vi, ViInt32 timeOut)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;
   

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(
			vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus)
   {
	/* Errors: VI_ERROR_INV_SESSION	*/
	hpe1411_LOG_STATUS( vi, NULL, errStatus);
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_timeOut" );

   hpe1411_CHK_LONG_RANGE( timeOut, 1, 2147483647, VI_ERROR_PARAMETER2 );

   if (thisPtr->e1406)
   {
	errStatus = viSetAttribute(vi, VI_ATTR_TMO_VALUE, timeOut);
   }
   else
   {
	errStatus = instr_settimeout(vi, timeOut);
   }
   if ( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
   }

   hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_timeOut_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | pTimeOut                                          ViPInt32    OUT
  |   ---------------------------------------------------------------------
  |  | This is the minimum timeout period that the driver
  |  | can be set to. It is specified in milliseconds.

*****************************************************************************/
/* ----------------------------------------------------------------------- */
/* Purpose:  Returns the current setting of the timeout value of the       */
/*           instrument in milliseconds.                                   */
/* ----------------------------------------------------------------------- */
ViStatus _VI_FUNC hpe1411_timeOut_Q (ViSession vi, ViPInt32 timeOut)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS( vi, NULL, errStatus );
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_timeOut_Q" );

   if (thisPtr->e1406)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_TMO_VALUE, timeOut );
   }
   else
   {
	errStatus = instr_gettimeout(vi, timeOut );
   }
   if( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
   }

   hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_errorQueryDetect
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | errorQueryDetect                                  ViBoolean   IN
  |   ---------------------------------------------------------------------
  |  | Boolean which enables (VI_TRUE) or disables (VI_FALSE)
  |  | automatic instrument error querying.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_errorQueryDetect( 
  ViSession vi, 
  ViBoolean errDetect)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus ) 
   { 
	hpe1411_LOG_STATUS( vi, NULL, errStatus ); 
   }

   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_errorQueryDetect" );

   hpe1411_CHK_BOOLEAN( errDetect, VI_ERROR_PARAMETER2 );

   thisPtr->errQueryDetect = errDetect;

   hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_errorQueryDetect_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | pErrDetect                                        ViPBoolean  OUT
  |   ---------------------------------------------------------------------
  |  | Boolean indicating if automatic instrument error
  |  | querying is performed.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_errorQueryDetect_Q( 
  ViSession vi, 
  ViPBoolean pErrDetect)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus ) 
   { 
	hpe1411_LOG_STATUS( vi, NULL, errStatus ); 
   }

   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_errorQueryDetect_Q" );

   *pErrDetect = thisPtr->errQueryDetect;

   hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_dcl
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_dcl( 
  ViSession vi)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus ) 
   { 
	hpe1411_LOG_STATUS( vi, NULL, errStatus ); 
   }

   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_dcl" );

   if (thisPtr->e1406)
   {
	errStatus = viClear(vi);
	if( VI_SUCCESS > errStatus) { hpe1411_LOG_STATUS( vi, thisPtr, errStatus ); }	
   }
   else
   {
   	{extern vm_hpsl_dcas();instr_clear(vi,vm_hpsl_dcas);}
   }

   hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_opc
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_opc (ViSession vi )
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS(vi, NULL, errStatus );
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_opc" );

   if (thisPtr->e1406)
   {
	errStatus = viPrintf(vi,"*OPC\n");
	if( VI_SUCCESS > errStatus)
	{
		hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
	}
   }
   else
   {
	{{ 
/*#line 1896 "hpe1411.cs"*/
{extern vm_opc();instr_send(vi,vm_opc,(void*)0);}}}
   }

   hpe1411_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_opc_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | opc                                               ViPInt16    OUT
  |   ---------------------------------------------------------------------
  |  | returns a 1 when all pending instruments commands are completed

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_opc_Q (ViSession vi, ViPInt16 opc)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS(vi, NULL, errStatus );
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_opc_Q" );
 
   if (thisPtr->e1406)
   {
	thisPtr->blockSrqIO = VI_TRUE;

	errStatus = viPrintf(vi,"*OPC?\n");
	if( VI_SUCCESS > errStatus)
	{
		hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
	}

	errStatus = viScanf(vi, "%hd%*t", opc);
	if( VI_SUCCESS > errStatus)
	{
		hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
	}
   }
   else
   {
	{{ struct {double p1[1];} out_;
/*#line 1956 "hpe1411.cs"*/
{extern vm_opc_q();if (!instr_query(vi,vm_opc_q,(void*)0,&out_)){
/*#line 1956 "hpe1411.cs"*/
*opc=1;}}}}
   }

   hpe1411_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_wai
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_wai (ViSession vi)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if ( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS(vi, NULL, errStatus );
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_wai" );

   if (thisPtr->e1406)
   {
	errStatus = viPrintf(vi,"*WAI\n");
	if (VI_SUCCESS > errStatus)
	{
		hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
	}
   }
   else
   {
	{{ 
/*#line 2004 "hpe1411.cs"*/
{extern vm_wai();instr_send(vi,vm_wai,(void*)0);}}}
   }

   hpe1411_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
hpe1411_trg
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_trg (ViSession vi)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if ( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS(vi, NULL, errStatus );
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_trg" );

   if (thisPtr->e1406)
   {
	errStatus = viPrintf(vi,"*TRG\n");
	if ( VI_SUCCESS > errStatus)
	{
		hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
	}
   }
   else
   {
	{{ 
/*#line 2052 "hpe1411.cs"*/
{extern vm_special_trg();instr_send(vi,vm_special_trg,(void*)0);}}}
   }

   hpe1411_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}


/****************************************************************************
hpe1411_readStatusByte_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | statusByte                                        ViPInt16    OUT
  |   ---------------------------------------------------------------------
  |  | returns the contents of the status byte

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_readStatusByte_Q(ViSession vi, ViPInt16 statusByte)
{
   ViUInt16 intf;
   ViStatus errStatus = 0;
   struct hpe1411_globals *thisPtr;
   ViUInt16 stb;

   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
	errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
	errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
   }
   if ( VI_SUCCESS > errStatus)
   {
      hpe1411_LOG_STATUS(vi, NULL, errStatus );
   }
   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_readStatusByte_Q" );

   if (thisPtr->e1406)
   {
	errStatus = viReadSTB(vi,&stb);
	if( VI_SUCCESS > errStatus)
	{
		hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
	}
   }
   else
   {
	instr_poll(vi,&stb);
   }

   *statusByte = (ViInt16)stb;

   hpe1411_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/******************************************************
 * INSTR_DEVELOPER: Take out what you don't need ???
 ******************************************************
 */


ViInt32 hpe1411_statusHap[hpe1411_MAX_STAT_HAP] = {
hpe1411_USER_ERROR_HANDLER,

hpe1411_ESR_OPC,
hpe1411_ESR_QUERY_ERROR,
hpe1411_ESR_DEVICE_DEPENDENT_ERROR,
hpe1411_ESR_EXECUTION_ERROR,
hpe1411_ESR_COMMAND_ERROR,

hpe1411_OPER_CAL,
};


/* Assumes we have driver copies of the event register.  This is needed
 * because in IEEE 488.2, the event register are cleared after they are 
 * read.  Since the event register contains several events, we need to
 * keep this information around to pass back to the user.
 */


struct hpe1411_statusAccess {
ViInt32 registerIdx; 
ViString condQry;
ViString eventQry;
ViString enableCmd;
};

const struct hpe1411_statusAccess hpe1411_accessInfo[hpe1411_MAX_STAT_REG] = {
{0, 	"",	 		"*STB?",		"*SRE"},
{400, 	"STAT:QUES:COND?",	"STAT:QUES:EVEN?",	"STAT:QUES:ENAB"},
{600,	"",			"*ESR?",			"*ESE"},
{800, 	"STAT:OPER:COND?",	"STAT:OPER:EVEN?",	"STAT:OPER:ENAB"}
};

/* this will return the index associated with the happening */
ViBoolean hpe1411_findHappeningIdx(
  ViInt32 happening,
  ViPInt32 pIdx)
{
	/* Note: this is a linear search, for faster access this
	 * could be done as a binary search since the data is arrange
	 * in order numerically.
	 */
	for( *pIdx=0; *pIdx<hpe1411_MAX_STAT_HAP; *pIdx = *pIdx + 1)
	{
		if( hpe1411_statusHap[*pIdx] == happening)
		{
			return VI_TRUE;
		}	
	}

	return VI_FALSE;
}

/* this will return the index that corresponds with regNum */
static ViBoolean hpe1411_findAccessIdx(
  ViInt32 regNum,
  ViPInt32 pIdx )
{
	for(*pIdx=0; *pIdx<hpe1411_MAX_STAT_REG; *pIdx = *pIdx + 1)
	{
		if( regNum == hpe1411_accessInfo[*pIdx].registerIdx)
		{	
			return VI_TRUE;
		}
	}
	return VI_FALSE;
}

static ViStatus hpe1411_readAllEvents( 
  ViSession vi)
{
	ViUInt16 intf;
	ViInt32 idx;
	ViStatus errStatus;
	ViInt32 eventResp;
        struct hpe1411_globals *thisPtr;

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
   	if( VI_SUCCESS > errStatus) 
   	{
   	   hpe1411_LOG_STATUS( vi, NULL, errStatus );
   	}
   	hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
        

	/* read all events and update driver events */
	for(idx=0; idx<hpe1411_MAX_STAT_REG; idx++)
	{
		/* if there is an event query */
		if( 0 != strlen(hpe1411_accessInfo[idx].eventQry))
		{
			/* okay - query the instrument for event */
			if (thisPtr->e1406)
			{
				thisPtr->blockSrqIO = VI_TRUE;

				errStatus = viPrintf(vi,
				  "%s\n", hpe1411_accessInfo[idx].eventQry);
				if( VI_SUCCESS > errStatus)
				{
					return errStatus;
				}

				/* get the response */
				errStatus = viScanf(vi, "%ld%*t", &eventResp);
				if( VI_SUCCESS > errStatus )
				{
					return errStatus;
				}
			}
			else
			{
				ViChar resp_str[100];

				cscpi_exe(vi,
					  hpe1411_accessInfo[idx].eventQry,
					  strlen(hpe1411_accessInfo[idx].eventQry),
					  resp_str,
					  sizeof(resp_str)
					  );
				/* get the response */
				eventResp = atol(resp_str);
			}

			/* update the driver events copy of instr events */
			thisPtr->driverEventArray[idx] = 	
			  thisPtr->driverEventArray[idx] | eventResp;

		} /* if - an event query exists */

	} /* for - all status registers */

	return VI_SUCCESS;

} /* hpe1411_readAllEvents() */


/* this recursive routine traverse the IEEE 488.2 status structures and
 * processes events.
 */
static void hpe1411_srqTraverse(
  ViSession vi,
  ViInt32 eventReg)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
	ViInt32 accessIdx;
	ViInt32 hapIdx;
	ViUInt16 Status;
	ViInt32 eventVal;
	ViInt32 happening;
	ViInt32 bitPos;
	ViStatus errStatus;

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
   	if( VI_SUCCESS > errStatus) 
	{
		/* error couldn't get attribute */
		return;  
	}

	if( VI_FALSE == hpe1411_findAccessIdx( eventReg, &accessIdx))
	{
		/* couldn't find register num 
		 *   don't know what to do so leave 
		 */
		return;
	}

	if( 0 == eventReg )
	{
		/* need to read status byte through VTL instead of SCPI */
		if (thisPtr->e1406)
		{
			if( viReadSTB( vi, &Status))
			{
				/* an error occured */
				return;
			}
		}
		else
		{
			instr_poll(vi,&Status);
		}
		eventVal = (ViInt32)Status;
	}
	else
	{
		/* find the event in the table */
		if( 0 != strlen(hpe1411_accessInfo[accessIdx].eventQry))
		{
			/* query instrument to find what event(s) occured. */
			if (thisPtr->e1406)
			{
				if( viPrintf(vi,"%s\n",
					 hpe1411_accessInfo[accessIdx].eventQry))
				{
					/* an error occured */
					return;
				}

				if( viScanf(vi,"%ld%*t\n", &eventVal)) 
				{
					/* an error occured */
					return;
				}
			}
			else
			{
				ViChar resp_str[100];

				cscpi_exe(vi,
					  hpe1411_accessInfo[accessIdx].eventQry,
					  strlen(hpe1411_accessInfo[accessIdx].eventQry),
					  resp_str,
					  sizeof(resp_str)
					  );
				/* get the response */
				eventVal = atol(resp_str);
			}
		}
		else
		{
			/* error - no events for this status register */
			return;
		}
	} /* else - not status byte */

	/* update driver events */
	thisPtr->driverEventArray[accessIdx] = 
	  thisPtr->driverEventArray[accessIdx] | eventVal;

	for( bitPos = 0; bitPos < 16; bitPos++)
	{
		/* check for an event occurance */
		if( eventVal & (1 << bitPos) )
		{
			/* find happening index */
			happening = eventReg + bitPos + 1;
			if( VI_TRUE == 
			       hpe1411_findHappeningIdx( happening, &hapIdx) )
			{
				/* does event have a handler enabled? */
				if( thisPtr->eventHandlerArray[hapIdx].eventHandler)
				{
					/* call the users handler */
			    	thisPtr->eventHandlerArray[hapIdx].eventHandler(
			    	  vi, happening, 
			    	  thisPtr->eventHandlerArray[hapIdx].userData);
				}				
			}

		} /* if - event occured */

		/* check for more status registers */
		if( VI_TRUE == hpe1411_findAccessIdx( happening*100, &accessIdx))
		{
			/* need to traverse these other registers */
			hpe1411_srqTraverse( vi, happening*100);
		}

	} /* for - all bits in the event */
}


/* this is the SRQ event handler for hpib*/
ViStatus _VI_FUNCH hpe1411_srqHdlr(
  ViSession vi,
  ViEventType eventType,
  ViEvent event,
  ViAddr userData)
{
	/* the only reason we should get called is for a Service Request */	

	/* for VTL 3.0 we always need to return VI_SUCCESS, therefore
	 * we will ignore any VTL errors at this level.
	 */

        struct hpe1411_globals *thisPtr;

        if(VI_SUCCESS > 
	  viGetAttribute( vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr) )
	{
		/* error couldn't get attribute, 
		 * but we lie and return VI_SUCCESS */
		return VI_SUCCESS;  
	}

	/* check if it is okay to do I/O in SRQ handler */
	if( VI_TRUE == thisPtr->blockSrqIO)
	{
	    /* not okay to do I/O so just update srq count */
	    thisPtr->countSrqIO = thisPtr->countSrqIO + 1;
     	    return VI_SUCCESS;  
	}

	/* suspend event processing for now */
	viEnableEvent( vi, VI_EVENT_SERVICE_REQ, VI_SUSPEND_HNDLR, VI_NULL);

	/* recursively traverse status byte */
	hpe1411_srqTraverse( vi, 0);

	/* re-enable event processing */
       	viEnableEvent( vi, VI_EVENT_SERVICE_REQ, VI_HNDLR, VI_NULL);

	/* always return VI_SUCCESS */
	return VI_SUCCESS;
} 


/* this is the simulated SRQ event handler for register based*/
ViStatus _VI_FUNCH hpe1411_rb_srqHdlr(
  ViSession vi,
  ViEventType eventType,
  ViEvent event,
  ViAddr userData)
{
	hpe1411_srqTraverse( vi, 0);
	return VI_SUCCESS;
} 



/****************************************************************************
hpe1411_statCond_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | The following conditions can occur on the instrument:
  |  |
  |  |          Macro Name      Value   Description
  |  |        ---------------------------------------------
  |  |        hpe1411_OPER_CAL	801	Calibrating
  |  |
  |  | Conditions are transient in nature, and this function reports
  |  | the current setting of the condition. A 1 is returned if the
  |  | condition is currently true, and 0 is returned if the condition
  |  | is currently false.
  |  |
   ------------------------------------------------------------------------
  | pCondition                                        ViPBoolean  OUT
  |   ---------------------------------------------------------------------
  |  | VI_TRUE  = condition is currently set
  |  | VI_FALSE = condition is currently not set

*****************************************************************************/

ViStatus _VI_FUNC hpe1411_statCond_Q(
  ViSession vi,
  ViInt32	happening,
  ViPBoolean	pCondition 
)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
        ViStatus errStatus;
	ViInt32 hapIdx;
	ViInt32 accessIdx;
	ViInt32 cond_q;
	ViInt32 regNum;
	ViInt32 bitNum;
	char errMsg[256];

        /* initialize output parameters */
	*pCondition = VI_FALSE;

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
        if( VI_SUCCESS > errStatus)
        {
                /* Errors: VI_ERROR_INV_SESSION */
                hpe1411_LOG_STATUS( vi, NULL, errStatus);
        }
        hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
        hpe1411_CDE_INIT( "hpe1411_statCond_Q");

	/* check validity of happening */
	if( (hpe1411_USER_ERROR_HANDLER ==  happening) ||
            (VI_FALSE == hpe1411_findHappeningIdx( happening, &hapIdx) ))
	{
		sprintf(errMsg,"%hd " hpe1411_MSG_INVALID_HAPPENING, happening);
		hpe1411_CDE_MESSAGE( errMsg);
		
		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	regNum = happening / 100;
	bitNum = happening % 100;

	/* get access index */
	if( VI_FALSE == hpe1411_findAccessIdx( regNum * 100, &accessIdx))
	{
		
		hpe1411_LOG_STATUS( vi, thisPtr, hpe1411_INSTR_ERROR_UNEXPECTED);
	}

	if( 0 == strlen(hpe1411_accessInfo[accessIdx].condQry))
	{
		char errMsg[256];

		/* unable to query the condition */
		sprintf(errMsg, hpe1411_MSG_CONDITION
                        "%hd" hpe1411_MSG_NOT_QUERIABLE, happening);
		hpe1411_CDE_MESSAGE(errMsg); 
		
		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	else
	{
		/* okay - query the instrument for condition */
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			errStatus = viPrintf(vi,
			  "%s\n", hpe1411_accessInfo[accessIdx].condQry);
			if( 0 > errStatus)
			{
					hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}

			/* get the condition response */
			errStatus = viScanf(vi, "%ld%*t", &cond_q);
			if( 0 > errStatus )
			{
					hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar resp_str[100];

			cscpi_exe(vi,
				  hpe1411_accessInfo[accessIdx].condQry,
			  strlen(hpe1411_accessInfo[accessIdx].condQry),
				  resp_str,
				  sizeof(resp_str)
				  );
			/* get the condition response  */
			cond_q = atol(resp_str);
		}
		
		/* check appropriate condition bit */
		if( cond_q & (1 << (bitNum-1)) )
		{
			*pCondition = VI_TRUE;
		}
		else
		{
			*pCondition = VI_FALSE;
		}
	}

	
	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	


/****************************************************************************
hpe1411_statEven_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | Happenings refer to something that happens. These can refer
  |  | to conditions or events. All of the conditions listed in the
  |  | hpe1411_statCond_Q() function will be detected as events as
  |  | well.   An event may be registered when a condition changes
  |  | state from  VI_FALSE to VI_TRUE.
  |  |
   ------------------------------------------------------------------------
  | pEvent                                            ViPBoolean  OUT
  |   ---------------------------------------------------------------------
  |  | VI_TRUE  = event occured sometime between event readings
  |  | VI_FALSE = the event did not occur between event readings

*****************************************************************************/

ViStatus _VI_FUNC hpe1411_statEven_Q(
  ViSession vi,
  ViInt32	happening,
  ViPBoolean	pEvent
)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
        ViStatus errStatus;
	ViInt32 hapIdx;
	ViInt32 accessIdx;
	ViInt32 event_q;
	ViInt32 regNum;
	ViInt32 bitNum;
	ViInt32 mask;
	char errMsg[256];

        /* initialize output parameters */
	*pEvent = VI_FALSE;

    	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute( vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
        if( VI_SUCCESS > errStatus)
        {
                /* Errors: VI_ERROR_INV_SESSION */
                hpe1411_LOG_STATUS( vi, NULL, errStatus);
        }
        hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
        hpe1411_CDE_INIT( "hpe1411_statEven_Q");

	/* check validity of happening */
	if( (hpe1411_USER_ERROR_HANDLER == happening) ||
            (VI_FALSE == hpe1411_findHappeningIdx( happening, &hapIdx) ))
	{
		sprintf(errMsg,"%hd " hpe1411_MSG_INVALID_HAPPENING, happening);
		hpe1411_CDE_MESSAGE( errMsg);
		
		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	regNum = happening / 100;
	bitNum = happening % 100;

	/* get access index */
	if( VI_FALSE == hpe1411_findAccessIdx( regNum * 100, &accessIdx))
	{
		
		hpe1411_LOG_STATUS( vi, thisPtr, hpe1411_INSTR_ERROR_UNEXPECTED);
	}

	/* see if we can query the event from the instrument */
	if( 0 == strlen(hpe1411_accessInfo[accessIdx].eventQry))
	{
		char errMsg[256];

		/* unable to query the event */
		sprintf(errMsg, hpe1411_MSG_EVENT
		  "%hd" hpe1411_MSG_NOT_QUERIABLE, happening);
		hpe1411_CDE_MESSAGE(errMsg); 
		
		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	else
	{
		/* okay - query the instrument for event */
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			errStatus = viPrintf(vi,
			  "%s\n", hpe1411_accessInfo[accessIdx].eventQry);
			if( 0 > errStatus)
			{

				hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}

			/* get the response */
			errStatus = viScanf(vi, "%ld%*t", &event_q);
			if( 0 > errStatus )
			{

				hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar resp_str[100];

			cscpi_exe(vi,
				  hpe1411_accessInfo[accessIdx].eventQry,
				  strlen(hpe1411_accessInfo[accessIdx].eventQry),
				  resp_str,
				  sizeof(resp_str)
				  );
			/* get the response */
			event_q = atol(resp_str);
		}

		/* update the driver events copy of instrument events */
		thisPtr->driverEventArray[accessIdx] = 	
		  thisPtr->driverEventArray[accessIdx] | event_q;

		/* check state of event bit */
		mask = 1 << (bitNum -1);
		if( thisPtr->driverEventArray[accessIdx] & mask )
		{
			*pEvent = VI_TRUE;

			/* clear event bit in driver events */
			thisPtr->driverEventArray[accessIdx] = 	
		 	  thisPtr->driverEventArray[accessIdx] & (~mask);
		}
		else
		{
			*pEvent = VI_FALSE;

			/* event bit in driver event array
			 * is already cleared 
			 */
		}
	}

	
	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	


/****************************************************************************
hpe1411_statEvenHdlr
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | Happenings refer to something that happens. These can refer to
  |  | conditions or events. Happenings are enumerated as ViInt32
  |  | numbers.  Only events can have happenings associated with it.
  |  |
   ------------------------------------------------------------------------
  | eventHandler                           hpe1411_InstrEventHandler  IN
  |   ---------------------------------------------------------------------
  |  | This is either NULL or a pointer to the user specified
  |  | event handler.  A NULL disables the event handler.
  |  |
  |  | An event handler has the following prototype:
  |  |
  |  | typedef void (_VI_FUNCH _VI_PTR  hpe1411_InstrEventHandler)(
  |  | ViSession vi,
  |  | ViInt32 happening,
  |  | ViAddr userData
  |  | );
   ------------------------------------------------------------------------
  | userData                                          ViAddr      IN
  |   ---------------------------------------------------------------------
  |  | This is a pointer that is passed to the handler when the
  |  | specified event occurs.  This can be used by the programmer
  |  | to pass additional information to the handler.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_statEvenHdlr(
  ViSession vi,
  ViInt32 happening,
  hpe1411_InstrEventHandler eventHandler,
  ViAddr userData
)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
        ViStatus errStatus;
	ViInt32 hapIdx;
	ViInt32 accessIdx;
	ViInt32 propagate;
	ViInt32 regNum;
	ViInt32 bitNum;
	ViInt32 enableMask;
	char errMsg[80];

        /* initialize output parameters */

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
        if( VI_SUCCESS > errStatus)
        {
                /* Errors: VI_ERROR_INV_SESSION */
                hpe1411_LOG_STATUS( vi, NULL, errStatus);
        }
        hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
        hpe1411_CDE_INIT( "hpe1411_statEvenHdlr");

	if( hpe1411_USER_ERROR_HANDLER == happening)
	{
		/* store handler and user data */
		thisPtr->eventHandlerArray[
                   hpe1411_USER_ERROR_HANDLER_IDX].eventHandler = eventHandler;
		thisPtr->eventHandlerArray[
                   hpe1411_USER_ERROR_HANDLER_IDX].userData = userData;
		hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	}

	/* check validity of happening */
	if( VI_FALSE == hpe1411_findHappeningIdx( happening, &hapIdx) )
	{

		sprintf(errMsg,"%ld " hpe1411_MSG_INVALID_HAPPENING, 
		  (long)happening);
		hpe1411_CDE_MESSAGE( errMsg);
		
		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	regNum = happening / 100;
	bitNum = happening % 100;

	/* suspend SRQ events - if handler is installed */
	if( thisPtr->e1406 && 0 > thisPtr->numEventHandlers)
	{
		errStatus = viEnableEvent( vi,VI_EVENT_SERVICE_REQ ,
		  VI_SUSPEND_HNDLR, VI_NULL);
		if( errStatus)
		{
                	
                	hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}
	}	

	/* see if we want to enable or disable the handler */
	if( NULL != eventHandler)
	{
		/* see if event handler already exists */		
		if( NULL == thisPtr->eventHandlerArray[hapIdx].eventHandler )
		{
			/* okay - no event handler */
			thisPtr->numEventHandlers =
			  thisPtr->numEventHandlers + 1;
		}
		else
		{
			/* reenable SRQ events - if handler is installed */
			if( thisPtr->e1406 && 0 > thisPtr->numEventHandlers)
			{
				errStatus = viEnableEvent( vi,
				  VI_EVENT_SERVICE_REQ, VI_HNDLR, VI_NULL);
				if( errStatus)
				{
               			 	
                			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
				}
			}	

			/* error - event handler already exists */
			sprintf(errMsg, 
			  hpe1411_MSG_EVENT_HDLR_INSTALLED
			  " %ld.  "
			  hpe1411_MSG_EVENT_HDLR_INST2, (long)happening);
			
			hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
			
		}

		/* store handler and user data */
		thisPtr->eventHandlerArray[hapIdx].eventHandler = eventHandler;
		thisPtr->eventHandlerArray[hapIdx].userData = userData;

		/* do we need to install the event handler? */
		if( 1 == thisPtr->numEventHandlers)
		{
			/* install the event handler */
			if (thisPtr->e1406)
			{
				errStatus = viInstallHandler(vi, 
				  VI_EVENT_SERVICE_REQ, hpe1411_srqHdlr, VI_NULL);
				if( errStatus)
				{
               				hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
				}

				/* enable events */
				errStatus = viEnableEvent( vi,
				  VI_EVENT_SERVICE_REQ, VI_HNDLR, VI_NULL);
				if( errStatus)
				{
        	        		hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
				}
			}
			else
			{
				instr_onsrq(vi,hpe1411_rb_srqHdlr);
			}
		}

	} /* if - install event handler */
	else
	{
		/* see if event handler already exists */		
		if( NULL != thisPtr->eventHandlerArray[hapIdx].eventHandler )
		{
			/* okay - no event handler */
			thisPtr->numEventHandlers =
			  thisPtr->numEventHandlers - 1;
		}

		/* clear handler and user data */
		thisPtr->eventHandlerArray[hapIdx].eventHandler = NULL;
		thisPtr->eventHandlerArray[hapIdx].userData = NULL;

		/* do we need to uninstall the event handler? */
		if( 0 == thisPtr->numEventHandlers)
		{
			/* disable SRQ events */
			if (thisPtr->e1406)
			{
				errStatus = viDisableEvent( vi,
				  VI_EVENT_SERVICE_REQ ,VI_HNDLR);
				if( VI_SUCCESS > errStatus)
				{

	     		          	hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
				}

				/* flush any pending SRQ events */
				errStatus = viDiscardEvents( vi,
				  VI_EVENT_SERVICE_REQ ,VI_SUSPEND_HNDLR);
				if( VI_SUCCESS > errStatus)
				{
        	       			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
				}

				/* uninstall the event handler */
				errStatus = viUninstallHandler(vi, 
				  VI_EVENT_SERVICE_REQ, hpe1411_srqHdlr, VI_NULL);
				if( VI_SUCCESS > errStatus && 
				    VI_ERROR_INV_HNDLR_REF != errStatus)
				{
        	       			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
				}
			}
			else
			{
				instr_onsrq(vi,0);
			}

		}

		/* remove all stale events */
		errStatus = hpe1411_readAllEvents( vi);
		if( VI_SUCCESS > errStatus)
		{
               		hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}

	} /* else - remove event handler */

	/* enable event bits to propagate through the IEEE 488.2 
	 * status system and eventually assert SRQ.
	 */
	propagate = happening;
	while( propagate > 0)
	{
		regNum = propagate / 100;
		bitNum = propagate % 100;

		/* get access index */
		if( VI_FALSE == hpe1411_findAccessIdx( regNum * 100, &accessIdx))
		{
			hpe1411_CDE_MESSAGE( "hpe1411_findAccessIdx failed");
			hpe1411_LOG_STATUS( vi, thisPtr, hpe1411_INSTR_ERROR_UNEXPECTED);
		}

		/* query enable value from instrument */
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			errStatus = viPrintf( vi, "%s?\n",
				 hpe1411_accessInfo[accessIdx].enableCmd);
			if( VI_SUCCESS > errStatus)
			{
				hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}

			/* read back the response */
			errStatus = viScanf( vi, "%ld%*t", &enableMask);
			if( VI_SUCCESS > errStatus)
			{
				hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar cmd_str[100];
			ViChar resp_str[100];

			sprintf(cmd_str, "%s?\n", 
			        hpe1411_accessInfo[accessIdx].enableCmd);

			cscpi_exe( vi, cmd_str, strlen(cmd_str),
				  resp_str, sizeof(resp_str) );
			/* get the response */
			enableMask = atol(resp_str);
		}

		/* enable/disable  the corresponding event bit */
		if( NULL != eventHandler)
		{
			/* enable event bit */
			enableMask = enableMask | (1 << (bitNum - 1));
		}	
		else
		{
			/* disable event bit */
			enableMask = enableMask & (~(1 << (bitNum - 1)));
		}

		/* write back the new enable mask */
		if (thisPtr->e1406)
		{
			errStatus = viPrintf( vi, "%s %hd\n",
			   hpe1411_accessInfo[accessIdx].enableCmd,
			   enableMask);
			if( VI_SUCCESS > errStatus)
			{
			
				hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar cmd_str[100];

			sprintf(cmd_str, "%s %hd\n", 
			        hpe1411_accessInfo[accessIdx].enableCmd,
			        enableMask);
			cscpi_exe( vi, cmd_str, strlen(cmd_str), 0, 0);
		}

		if( NULL == eventHandler)
		{
			/* for disabling events, only disable the
			 * lowest level.
			 */
			propagate = 0;
		}
		else
		{
			propagate = propagate / 100;
		}

	} /* while - propagate */

	
	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	


/****************************************************************************
hpe1411_statEvenHdlr_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32 happeningIN
  |   ---------------------------------------------------------------------
  |  | Happenings refer to something that happens.  These can refer to
  |  | conditions or events.  Happenings are enumerated as ViInt32
  |  | numbers.
  |  |
   ------------------------------------------------------------------------
  | pEventHandler                     hpe1411_InstrPEventHandler      OUT
  |   ---------------------------------------------------------------------
  |  | This is the definition of a hpe1411_InstrPEventHandler:
  |  |
  |  | typedef void (_VI_PTR _VI_PTR hpe1411_InstrPEventHandler)(
  |  | ViSession vi,
  |  | ViInt32 happening,
  |  | ViAddr userData
  |  | );
   ------------------------------------------------------------------------
  | pUserData                                         ViPAddr     OUT
  |   ---------------------------------------------------------------------
  |  | This is a pointer to the userData that was registered
  |  | with the handler.

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_statEvenHdlr_Q(
  ViSession vi,
  ViInt32 happening,
  hpe1411_InstrPEventHandler pEventHandler,
  ViPAddr pUserData)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
        ViStatus errStatus;
	ViInt32 hapIdx;
	char errMsg[80];

        /* initialize output parameters */

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
        if( VI_SUCCESS > errStatus)
        {
                /* Errors: VI_ERROR_INV_SESSION */
                hpe1411_LOG_STATUS( vi, NULL, errStatus);
        }
        hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
        hpe1411_CDE_INIT( "hpe1411_statEvenHdlr_Q");

	/* check validity of happening */
	if( hpe1411_USER_ERROR_HANDLER == happening)
	{
		hapIdx = hpe1411_USER_ERROR_HANDLER_IDX;
	}
	else if( VI_FALSE == hpe1411_findHappeningIdx( happening, &hapIdx) )
	{
		sprintf(errMsg,"%hd " hpe1411_MSG_INVALID_HAPPENING, happening);
		hpe1411_CDE_MESSAGE( errMsg);
		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	*((void **)pEventHandler) = (void *)thisPtr->eventHandlerArray[hapIdx].eventHandler;
	*pUserData = thisPtr->eventHandlerArray[hapIdx].userData;

	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
hpe1411_statEvenHdlrDelAll
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_statEvenHdlrDelAll(
  ViSession vi)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
        ViStatus errStatus;

        /* initialize output parameters */

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
        if( VI_SUCCESS > errStatus)
        {
                /* Errors: VI_ERROR_INV_SESSION */
                hpe1411_LOG_STATUS( vi, NULL, errStatus);
        }
        hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
        hpe1411_CDE_INIT( "hpe1411_statEvenHdlrDelAll");

	/* disable SRQ events */
	if (thisPtr->e1406)
	{
		errStatus = viDisableEvent( vi,VI_EVENT_SERVICE_REQ ,VI_HNDLR);
		if( VI_SUCCESS > errStatus)
		{
        	       	hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* flush any pending SRQ events */
		errStatus = viDiscardEvents( vi,VI_EVENT_SERVICE_REQ ,VI_SUSPEND_HNDLR);
		if( VI_SUCCESS > errStatus)
		{
        	       	hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* uninstall the event handler */
		errStatus = viUninstallHandler(vi, 
		  VI_EVENT_SERVICE_REQ, hpe1411_srqHdlr, VI_NULL);
		if( VI_SUCCESS > errStatus && 
		    VI_ERROR_INV_HNDLR_REF != errStatus)
		{
        		hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}
	}
	else
	{
		instr_onsrq(vi,0);
	}

	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
hpe1411_statEvenClr
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()

*****************************************************************************/
ViStatus _VI_FUNC hpe1411_statEvenClr(
  ViSession vi
)
{
	ViUInt16 intf;
        struct hpe1411_globals *thisPtr;
        ViStatus errStatus;
	ViInt32 idx;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
			vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViAddr) &thisPtr);
	}
        if( VI_SUCCESS > errStatus)
        {
                /* Errors: VI_ERROR_INV_SESSION */
                hpe1411_LOG_STATUS( vi, NULL, errStatus);
        }
        hpe1411_DEBUG_CHK_THIS( vi, thisPtr);
        hpe1411_CDE_INIT( "hpe1411_statEvenClr");

	/* clear instrument events */
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi, "*CLS\n");
		if( VI_SUCCESS > errStatus)
		{
			hpe1411_LOG_STATUS( vi, thisPtr, errStatus);
		}
	}
	else
	{
		{{ 
/*#line 3308 "hpe1411.cs"*/
{extern vm_cls();instr_send(vi,vm_cls,(void*)0);}}}
	}

	/* clear driver copy of instrument events */
	for(idx=0; idx<hpe1411_MAX_STAT_REG; idx++)
	{
		thisPtr->driverEventArray[idx] = 0;
	}

	hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
hpe1411_scpi
*****************************************************************************
   SCPI command interpretor for NON-query commands.
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | size                                              ViInt32    IN
  |   ---------------------------------------------------------------------
  |  | Size of the scpi_cmmd string (in bytes).
  |  |
   ------------------------------------------------------------------------
  | scpi_cmmd                                         ViString     IN
  |   ---------------------------------------------------------------------
  |  | Null terminated text string containing SCPI command to send. 
  |  | (Should contain the <RTN> as last char of string.)
  |  |
*****************************************************************************/
ViStatus _VI_FUNC hpe1411_scpi(ViSession vi,
  ViInt32 size, ViString scpi_cmmd)
{
   ViInt32  bogus_size=50;             /* Parameter required for cscpi_exe() */
   ViChar   bogus_array[50];           /* Parameter required for cscpi_exe() */
   //ViUInt32 rtn_size;                  /* Require parameter for viWrite().   */
   ViUInt16 intf;
   ViStatus errStatus;
   struct   hpe1411_globals *thisPtr;

   
   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if ( (intf!=VI_INTF_VXI) && (intf!=VI_INTF_GPIB_VXI) )
   {
       errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
       errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
   }

   if (errStatus<VI_SUCCESS)
   {
      hpe1411_LOG_STATUS( vi, 0, errStatus );
   }

   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_scpi" );

   /* set the dirty bit to indicate user may have changed format on us */
   thisPtr->dirtyBit = 1;

   /* If (message-based I/O) then write to instrument. */
   if (thisPtr->e1406)
   {
      errStatus = viPrintf(vi, "%s\n", scpi_cmmd);
   }
   else  /* Must be register-based I/O */
   {
      cscpi_exe(vi, scpi_cmmd, size, bogus_array, bogus_size);
   }

   hpe1411_LOG_STATUS( vi, thisPtr, errStatus );

} /* hpe1411_scpi() */


/****************************************************************************
hpe1411_scpi_Q
*****************************************************************************
   SCPI command interpretor for query commands.

   (Note: this command will hang (timeout) if a NON-query SCPI command is sent
          while communicating in message-based mode (E1406).)
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from hpe1411_init()
   ------------------------------------------------------------------------
  | size                                              ViInt32    IN
  |   ---------------------------------------------------------------------
  |  | Size of the command string (in bytes).
  |  |
   ------------------------------------------------------------------------
  | scpi_cmmd                                         ViString     IN
  |   ---------------------------------------------------------------------
  |  | Null terminated text string containing SCPI query command to send. 
  |  | (Command string should end with the <RTN> char.)
  |  |
   ------------------------------------------------------------------------
  | resp_size                                         ViInt32    IN
  |   ---------------------------------------------------------------------
  |  | Size of response string (resp_string[]).
  |  |
   ------------------------------------------------------------------------
  | resp_string                                       ViPChar     OUT
  |   ---------------------------------------------------------------------
  |  | Text string for receiving query input into.
  |  |
*****************************************************************************/
ViStatus _VI_FUNC hpe1411_scpi_Q(ViSession vi,
  ViInt32 size, ViString scpi_cmmd,
  ViInt32 resp_size, ViChar _VI_FAR resp_string[])
{
   ViUInt16 intf;
   //ViUInt32 rtn_size;
   ViInt16 cmmdLen;
   ViStatus errStatus;
   struct   hpe1411_globals *thisPtr;


   viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
   if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
   {
       errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
   }
   else
   {
       errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
   }

   if (errStatus < VI_SUCCESS)
   {
      hpe1411_LOG_STATUS( vi, 0, errStatus );
   }

   hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
   hpe1411_CDE_INIT( "hpe1411_scpi_Q" );

   cmmdLen=strlen(scpi_cmmd);
   if (scpi_cmmd[cmmdLen - 1] == '\n')
       scpi_cmmd[cmmdLen-1] = '\0';

   /* If (message-based I/O) then write to instrument. */
   if (thisPtr->e1406)
   {
      errStatus = viPrintf(vi, "%s\n", scpi_cmmd);

      /* If (SCPI command sent successfully) then read response. */
      if ( !(errStatus<VI_SUCCESS) )
         errStatus = viScanf(vi, "%t", resp_string);
        
   }
   else  /* Must be register-based I/O */
   {
      cscpi_exe(vi, scpi_cmmd, size, resp_string, resp_size);
   }

   hpe1411_LOG_STATUS( vi, thisPtr, errStatus );

} /* hpe1411_scpi_Q() */


/*
 * VTL Formatted I/O note:
 *    It is poor form to mix VTL formatted and non-formatted I/O calls
 *    in close proximity (buffering conflicts may result).
 *
 *    - When scanning formatted data, do not mix formatted and non-formatted
 *      I/O calls for a single transaction. After you have scanned all of
 *      the formatted I/O data, then it is safe to use non-formatted I/O.
 *    - When outputting formatted data, make sure to call viFlush() prior
 *      to calling non-formatted I/O functions.
 */      



/************
 * Print IEEE 488.s Definite Arbitrary Block header (to be followed by block).
 *
 * The header is of the form:
 *      #xddddd
 *   Where: [ddddd] is the length of the block in ASCII decimal form
 *          [x]     is the number of digits in the [ddddd] ASCII length string.
 * 
 * For example if the block length was 1234 bytes long, the header would be:
 *      #41234.
 ************/
ViStatus hpe1411_print_header(ViSession vi, ViInt32 length)
{
    ViChar    lenBuf[32];
    ViChar    header[32];
    ViUInt32  retCount;
    ViBoolean send_end_state;
    ViStatus  errStatus;
    int       i;
    int       digits;

    digits = 0;

    /* Put decimal representation into lenBuf. */
    /* NOTE: the number is built backwards; lowest order digit stored first. */
    while (length)
    {
        lenBuf[digits] = '0' + (char)(length % 10);
        digits += 1;
        length /= 10;
    }

    header[0] = '#';                            /* Start DAB w/# */
    header[1] = digits + '0';                   /* Convert digits to ASCII */

    /* NOTE: order here different because number stored in reverse order. */
    for (i=0; i<digits; i++)
        header[i+2] = lenBuf[digits-1-i];

    /* Fetch current END state. */
    errStatus = viGetAttribute(vi, VI_ATTR_SEND_END_EN, &send_end_state);
    if (errStatus < VI_SUCCESS) return(errStatus);

    /* Configure for not outputting END from I/O. */
    errStatus = viSetAttribute(vi, VI_ATTR_SEND_END_EN, VI_FALSE);
    if (errStatus < VI_SUCCESS) return(errStatus);

    /* Output the DAB to the instrument (#n[digits]). */
    errStatus =  viWrite(vi, header, (digits+2), (ViPUInt32)&retCount);
    if (errStatus < VI_SUCCESS) return(errStatus);

    /* Restore previous END state for I/O. */
    errStatus = viSetAttribute(vi, VI_ATTR_SEND_END_EN, send_end_state);
    if (errStatus < VI_SUCCESS) return(errStatus);

    return(errStatus);

} /* hpe1411_print_header() */



/************
 * Print the data in buffer <b> of <length> bytes,
 * as an IEEE 488.2 Definite Arbitrary Block.
 * This function may be used for outputting any block type that does not
 * contain data formats that need to be swapped from LittleEndian<->BigEndian
 * formats.
 ************/
ViStatus hpe1411_printDab8(ViSession vi, ViInt32 length, ViChar *buffer)
{
    ViStatus status;
    ViUInt32 retCount;


    status = hpe1411_print_header(vi, length);
    if (status < VI_SUCCESS) return(status);

    return( viWrite(vi, buffer, (ViUInt32)length, &retCount) );

} /* hpe1411_print8() */



/************
 * Print buffer <b> of <length> 16bit words,
 * byte reverse each word prior to outputting.
 ************/
ViStatus hpe1411_printDab16Swap(ViSession vi, ViInt32 length, ViPInt16 b)
{
    ViStatus status;
    ViChar buf[32];
    ViPChar p;
    ViUInt32 bi;
    ViUInt32 c;

    /* First output DAB header. */
    status = hpe1411_print_header(vi, length*2);
    if (status < VI_SUCCESS)
        return(status);

    /* Then output block in 32byte chunks, up to last 32byte chunk. */
    p = (ViPChar) b;
    while ( p < (ViPChar)(b+(length*2)-32) )
    {
        /* First swap bytes within each 2byte word of the 16 word buffer. */
        buf[0] = p[1];    buf[1] = p[0];
        buf[2] = p[3];    buf[3] = p[2];
        buf[4] = p[5];    buf[5] = p[4];
        buf[6] = p[7];    buf[7] = p[6];
        buf[8] = p[9];    buf[9] = p[8];
        buf[10] = p[11];  buf[11] = p[10];
        buf[12] = p[13];  buf[13] = p[12];
        buf[14] = p[15];  buf[15] = p[14];
        buf[16] = p[17];  buf[17] = p[16];
        buf[18] = p[19];  buf[19] = p[18];
        buf[20] = p[21];  buf[21] = p[20];
        buf[22] = p[23];  buf[23] = p[22];
        buf[24] = p[25];  buf[25] = p[24];
        buf[26] = p[27];  buf[27] = p[26];
        buf[28] = p[29];  buf[29] = p[28];
        buf[30] = p[31];  buf[31] = p[30];

        /* Then print this 32 byte buffer. */
        p += 32;
        status = viWrite(vi, buf, 32, &c);
        if (status < VI_SUCCESS)
            return(status);
    }

    bi = 0;
    /* Finally, output the last <32 bytes. */
    while ( p < (ViPChar)(b+length*2) )
    {
        buf[bi]   = p[1];
        buf[bi+1] = p[0];
        bi+=2;
        p+=2;
    }
    return( viWrite(vi, buf, bi, &c) );

} /* hpe1411_print16Swap() */



/************
 * Output buffer <b> containing <length> 8 byte words,
 * byte reversed by 8 (used to swap float64's).
 ************/
ViStatus hpe1411_printDab64swap(ViSession vi, ViInt32 length, ViPReal64 b)
{
    ViStatus  status;
    ViChar    buf[32];
    ViPChar   p;
    ViUInt32  c;
    ViUInt32  bi;


    /* Print DAB header. */
    status = hpe1411_print_header(vi, length*8);
    if (status < VI_SUCCESS)
        return(status);

    p = (ViPChar) b;

    /* Swap 4 8byte words into 32byte buffer, then output buffer.     */
    /* (Repeat until you reach the last 4 8byte words in buffer <b>.) */
    while (p < (ViPChar)b+(length*8)-32)
    {
        /* Swap Word 1. */
        buf[0] = p[7];    buf[1] = p[6];
        buf[2] = p[5];    buf[3] = p[4];
        buf[4] = p[3];    buf[5] = p[2];
        buf[6] = p[1];    buf[7] = p[0];

        /* Swap Word 2. */
        buf[8]  = p[15];  buf[9]  = p[14];
        buf[10] = p[13];  buf[11] = p[12];
        buf[12] = p[11];  buf[13] = p[10];
        buf[14] = p[9];   buf[15] = p[8];

        /* Swap Word 3. */
        buf[16] = p[23];  buf[17] = p[22];
        buf[18] = p[21];  buf[19] = p[20];
        buf[20] = p[19];  buf[21] = p[18];
        buf[22] = p[17];  buf[23] = p[16];

        /* Swap Word 4. */
        buf[24] = p[31];  buf[25] = p[30];
        buf[26] = p[29];  buf[27] = p[28];
        buf[28] = p[27];  buf[29] = p[26];
        buf[30] = p[25];  buf[31] = p[24];

        /* Write 4 swapped words. */
        status = viWrite(vi, buf, 32, &c);
        if (status < VI_SUCCESS)
            return(status);

        /* Advance to next word. */
        p += 32;

    }

    bi = 0;

    /* Handle final 1,2,3, or 4 words here.                 */
    /* First, load into buffer array (up to 4 8byte words). */
    while (p < ((ViPChar)b+(length*8)) )
    {
        /* Byte Swap this word and place in buffer. */
        buf[bi]   = p[7];
        buf[bi+1] = p[6];
        buf[bi+2] = p[5];
        buf[bi+3] = p[4];
        buf[bi+4] = p[3];
        buf[bi+5] = p[2];
        buf[bi+6] = p[1];
        buf[bi+7] = p[0];
    
        bi+=8;                      /* Count chars in buffer. */
        p+=8;                       /* Advance to next word in callers array. */

    } /* While-loop */

    /* Write final buffer w/1,2,3,or4 words in it). */
    return( viWrite(vi, buf, bi, &c) );

} /* hpe1411_print64Swap() */



/************
 * Scan from session <vi> upto <max_length> bytes into buffer <b>.
 ************/
/************
 * FUNCTION:   hpe1411_scan8()
 * PURPOSE:    Reads a block from input, placing block of bytes into caller's
 *             array.
 *             (No swapping ever needs to be done w/byte arrays.)
 * ALGORITHM:  Read length.
 *             Read Buffer.
 * PARAMS:     vi          - VTL session
 *             max_length  - number of byte values that can be stored in b
 *             b           - array to store float64 values.
 *             rtn_count   - count of number of 16bit words scanned.
 ************/
ViStatus hpe1411_scan8( ViSession vi,
                     ViInt32   max_length,
                     ViPChar   b,
                     ViPInt32  rtn_count )
{
    ViStatus status;
    ViChar   c[2];
    ViChar   length_str[16];
    ViInt16  l;
    ViInt32  length;
    ViInt32  nbytes;

    /* Get size <n> of DAB #ndddd (or 0 of indefinite block, #0).*/
    status = viScanf(vi, "%2c", c);
    if (status < VI_SUCCESS)
        return(status);
    l = c[1]-'0';

    /* If (DAB type block w/#nddd) */
    if (l)
    {
        /* Scan the rest of the digits in the DAB header. */
        status = viScanf(vi, "%#c", &l, length_str);
        if (status < VI_SUCCESS)
            return(status);

        length = atol(length_str);
        nbytes = length;
        if (max_length<length)
        {
            /* Read what you can, and discard the rest. */
            status = viScanf(vi, "%#s*t", &nbytes, b);
            *rtn_count = nbytes;
            return(VI_ERROR_PARAMETER2);    /* Caller's array too small. */
        }

        /* Get data. */
        status = viScanf(vi, "%#c%*t", &nbytes, b);

        /* Return count of number of bytes scanned (VTL Spec unclear). */
        *rtn_count = nbytes;
    }
    else /* We have an indefinite block. */
    {
        /* Read data up to max_length, else end of input.  */
        /* %t format reads to next END, else until nbytes. */
        nbytes = max_length;
        status = viScanf(vi, "%#t%*t", &nbytes, b);
        *rtn_count = nbytes;
    }

    return(status);

} /* hpe1411_scan8() */



/************
 * FUNCTION:   hpe1411_scan16()
 * PURPOSE:    Reads a block from input, placing block of bytes into caller's
 *             array. If caller requests it,  swaps all 2byte 16bit words
 *             appropriately from Motorola to Intel format.
 * ALGORITHM:  Read length.
 *             Read Buffer.
 *             if (swapping requested)
 *                Byte Swap 2 byte words.
 * PARAMS:     vi          - VTL session
 *             max_length  - number of int16 values that can be stored in b
 *             b           - array to store float64 values.
 *             rtn_count   - count of number of 16bit words scanned.
 *             swap        - if == VI_TRUE, then does byte swapping.
 ************/
ViStatus hpe1411_scan16( ViSession vi,
                      ViInt32   max_length,
                      ViPChar   b,
                      ViPInt32  rtn_count,
                      ViBoolean swap        )
{
   ViStatus status;
   ViChar c[2];
   ViChar length_str[16];
   ViInt16 digits;
   ViInt32 length;
   ViInt32 nbytes;
   ViInt32 n_bytes;
   ViInt32 i;

   /* Read Header (should be #[1-9], if #0 then Indefinite Block. */
   status = viScanf(vi, "%2c", c);
   if (status < VI_SUCCESS)
      return(status);
   digits = c[1]-'0';   /* c[0] is the # */

   /* If digits was not [0-9] then syntax problem, blow away input and return */
   if ( (digits<0) || (9<digits) )
   {
      status = viScanf(vi, "%*t");                         /* Clear input. */
      return(VI_ERROR_INV_RESPONSE);
   }

   /* If (Definite Arbitrary Block) */
   if (digits != 0)
   {
      status = viScanf(vi, "%#c", &digits, length_str);
      if (status < VI_SUCCESS)
         return(status);
      length = atol(length_str);
      if ( length > (max_length*2) )
      {
         /* Caller's array too small, read what you can & discard rest. */
         status = viScanf(vi, "%#c%*t",(max_length*2), b);
         return(VI_ERROR_PARAMETER2);          /* Caller's length too small. */
      }

      /* Read known length array data.                                       */
      /* NOTE: VPP # references an integer, may be problems if array <31bit. */
      n_bytes = length*2;
      status = viScanf(vi, "%#c%*t", &n_bytes, b);
 
      /* Return count of number of bytes scanned (VTL Spec unclear). */
      *rtn_count = n_bytes/2;
   }
   else  /* Indefinite Arbitrary Block */
   {
      /* Read data up to max_length, else end of input.  */
      /* %t format reads to next END, else until nbytes. */
      nbytes = max_length*2;
      status = viScanf(vi, "%#t%*t", &nbytes, b);
      *rtn_count = nbytes/2;
   }

   if (swap == VI_TRUE)
   {
      /* Byte reverse. */
      for (i=0; i<length/2; i++)
      {
         ViChar c;

          c = b[1];
          b[1] = b[0];
          b[0] = c;
          b += 2;    /* b is pointer to data bytes (char), increment it */
      }

   } /* If(swapping) */

   return(status);

} /* hpe1411_scan16() */



/************
 * FUNCTION:   hpe1411_scan64()
 * PURPOSE:    Reads an (Indef/Def) Arbitrary Block from input, placing the 
 *             byte array into the callers array. If the caller requests byte
 *             swapping, then swaps all 8byte 64bit words appropriately from
 *             Motorola to Intel format.
 * ALGORITHM:  Read length.
 *             Read Buffer.
 *             if (swapping needed)
 *                 Byte swap 8 byte words.
 * RETURNS: 
 *             VI_ERROR_INV_RESPONSE  - invalid response from instrument.
 *             VI_ERROR_PARAMETER2    - array length too short.
 *             VI_SUCCESS             - no errors.
 * PARAMS:     vi          - VTL session
 *             max_length  - # of float64 vals that can be stored in f64_array
 *             f64_array   - array to store float64 values.
 *             rtn_count  - pointer to count of float64 readings made.
 *             swap        - if == VI_TRUE, then swap bytes to Little Endian.
 ************/
ViStatus hpe1411_scan64( ViSession vi,
                      ViInt32   max_length,
                      ViPReal64 f64_array,
                      ViPInt32  rtn_count,
                      ViBoolean swap         )
{
   ViStatus rtn_code;
   ViChar   c[2];
   ViChar   length_str[16];
   ViInt32  nbytes;
   ViUInt32 digits;
   ViInt32  i;
   char fmtStr[40];


   /* Initially, no readings made. */
   *rtn_count  = 0;

   /* Read Header (should be #[1-9], if #0 then Indefinite Block. */
   rtn_code = viScanf(vi, "%2c", c);
   if (rtn_code < VI_SUCCESS)
      return(rtn_code);

   /* Convert 1st digit to integer. */
   digits = c[1]-'0';   /* c[0] is the # */

   /* If digits was not [0-9] then syntax problem, blow away input and return */
   if ( (digits<0) || (9<digits) )
   {
      rtn_code = viScanf(vi, "%*t");                         /* Clear input. */
      return(VI_ERROR_INV_RESPONSE);
   }

   if (digits==0)
   {
      /* Is (Indefinite Block) */
      /* Read data up to max_length, else end of input.  */
      /* %nnnc format reads to next END, else until nnn bytes. */
      nbytes = max_length*8;
   }
   else  /* Must be DAB. */
   {
      /* Scan DAB array count. */
      sprintf(fmtStr,"%%%ldc", digits);
       rtn_code = viScanf(vi, fmtStr, length_str);
     if (rtn_code < VI_SUCCESS)
         return(rtn_code);

      length_str[digits]='\0';   /* null terminate the string */
      nbytes = atol(length_str);

      /* Verify that caller's array is big enough. */
      if ( (max_length*8) < nbytes )
         return(VI_ERROR_PARAMETER2);    /* Caller's array too small. */
   }

   sprintf(fmtStr,"%%%ldc%%*t", nbytes);

   /* if we got to here, all is well, do the read */
   rtn_code = viScanf(vi, fmtStr, (unsigned char*)f64_array);

   if (rtn_code < VI_SUCCESS)
      return(rtn_code);

   *rtn_count = nbytes/8;

   /* If (caller requests byte swapping) */
   if (swap == VI_TRUE)
   {
      unsigned char src[8];

      /* Byte Swap (bytes [0->7] into bytes [7->0]). */
      for (i=0; i<(*rtn_count); i++)
      {
         /* Place the 8 byte double into src[8]. */
         *((double *)src) = *((double *)(&f64_array[i]));

         /* Now swap the byte order. */
         ((unsigned char *)(&f64_array[i]))[0] =  ((unsigned char*)(src))[7];
         ((unsigned char *)(&f64_array[i]))[1] =  ((unsigned char*)(src))[6];
         ((unsigned char *)(&f64_array[i]))[2] =  ((unsigned char*)(src))[5];
         ((unsigned char *)(&f64_array[i]))[3] =  ((unsigned char*)(src))[4];
         ((unsigned char *)(&f64_array[i]))[4] =  ((unsigned char*)(src))[3];
         ((unsigned char *)(&f64_array[i]))[5] =  ((unsigned char*)(src))[2];
         ((unsigned char *)(&f64_array[i]))[6] =  ((unsigned char*)(src))[1];
         ((unsigned char *)(&f64_array[i]))[7] =  ((unsigned char*)(src))[0];
      } /* For-Loop */

   } /* If (swapping needed) */
      
   return(rtn_code);

} /* hpe1411_scan64() */

ViStatus _VI_FUNC hpe1411_findRsrc(
  ViInt16 arraySize,
  char rsrcList[][80],
  ViRsrc rsrcDesc,
  ViPInt16 matches )
{
	ViStatus errStatus;
	ViSession defRM;
	ViUInt16 manfId;
	ViUInt16 modelCode;
        ViFindList foundList;
        char instrDesc[256];
        ViUInt32 retCnt, i;
        ViSession vi;
	ViUInt16 intf;
	char idn_buf[256];
        ViInt16 success;

	*matches = 0;

	/* Find the Default Resource Manager */
	if( errStatus = viOpenDefaultRM( &defRM) )
	{
		/* Errors: VI_ERROR_SYSTEM_ERROR 
		 *         VI_ERROR_ALLOC
		 */
		hpe1411_LOG_STATUS( VI_NULL, NULL, errStatus);
	}

        /* go get the first instrument of type rsrcDesc */
        if (errStatus = viFindRsrc( defRM, rsrcDesc, &foundList, &retCnt,
                                    instrDesc) )
        {
		/* Errors: VI_ERROR_INV_SESSION
		 *         VI_ERROR_INV_OBJECT
		 *         VI_ERROR_NSUP_OPER
		 *         VI_ERROR_INV_EXPR
		 *         VI_ERROR_RSRC_NFOUND
		 */
		hpe1411_LOG_STATUS( VI_NULL, NULL, errStatus);
	}
  
        /* check out all the instruments found to see if they are 
         * ones this driver supports.  Note that we fall through if
         * the retCnt is 0 (no instruments found).
        */
        for (i=0; i<retCnt; i++)
        {
            /* find the next one if not first time through this loop */
            if (i)
            {
        	if (errStatus = viFindNext( foundList, instrDesc) )
        	{
		    /* Errors: VI_ERROR_INV_SESSION
		     *         VI_ERROR_INV_OBJECT
		     *         VI_ERROR_NSUP_OPER
		     *         VI_ERROR_RSRC_NFOUND
		     */
		    hpe1411_LOG_STATUS( VI_NULL, NULL, errStatus);
		}
            }

       /* if not GPIB-VXI or VXI, then don't open it because some vendors'
          VTL crashes if try to open GPIB only stuff.
       */
            if (strstr(instrDesc,"VXI")==0 )  
               continue;

	    if( errStatus = viOpen( defRM, instrDesc, VI_NULL, VI_NULL, &vi) )
	    {	
		/* Errors: VI_ERROR_NSUP_OPER
		 *         VI_ERROR_INV_RSRC_NAME
		 *         VI_ERROR_INV_ACC_MODE
		 *         VI_ERROR_RSRC_NFOUND
		 *         VI_ERROR_ALLOC
		 */
		hpe1411_LOG_STATUS(VI_NULL, NULL, errStatus);
	    }

	    /* find the interface type */
	    if( errStatus = viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf) )
	    {	
		/* Errors: VI_ERROR_NSUP_ATTR */

               /* Unexpected error, so close things and exit via LOG_STATUS */
		viClose( vi);
		viClose( defRM);	/* also closes vi session */
	
		hpe1411_LOG_STATUS( VI_NULL, NULL, errStatus);
	    }

            /* initialize success flag, model code and manuf ID */
            success = 0;
            manfId = 0;
            modelCode = 0;
	    switch( intf)
	    {
	        case VI_INTF_GPIB:
		    /* check for a idn match
                     * need strncmp due to \n EOI imbedded in %t
                     */
		    viPrintf(vi, "*IDN?\n");
		    viScanf(vi, "%t", idn_buf); 

                    /* if we find a hpe1411, indicate success */
                    if( strncmp( idn_buf, hpe1411_IDN_STRING, 21) == 0)
                        success = 1;

		    break;

		    case VI_INTF_VXI:
		    case VI_INTF_GPIB_VXI:
	
			/* look for a matching VXI manfacturer's ID */
			if( errStatus = viGetAttribute(vi, VI_ATTR_MANF_ID,
                            &manfId) )
			{	
			    /* Errors: VI_ERROR_NSUP_ATTR */
               		    /* Unexpected error, so close things and exit
                             * via LOG_STATUS
                            */
			    viClose( vi);
			    viClose( defRM);	/* also closes vi session */
			}

                        if( errStatus = viGetAttribute(vi,
                           VI_ATTR_MODEL_CODE, (ViPAttrState)(&modelCode)) )
			{	
			    /* Errors: VI_ERROR_NSUP_ATTR */
			    /* Note: this should never happen 
			     *   with a VXI instrument
			     */

               		    /* Unexpected error, so close things and exit
                             * via LOG_STATUS
                            */
			    viClose( vi);
			    viClose( defRM);	/* also closes vi session */
			}


			if( (manfId == hpe1411_MANF_ID) && 
			    (modelCode == hpe1411_MODEL_CODE) )
			{

			    success = 1;
			}

			break;

		    default:
               		/* Should not get here, if we do, close things and exit
                         * via LOG_STATUS
                         */
			viClose( vi);
			viClose( defRM);	/* also closes vi session */
			hpe1411_LOG_STATUS(vi, NULL,
                            hpe1411_INSTR_ERROR_UNEXPECTED);

             }	

             /* Close this one and possibly go open another */
	     viClose( vi);

             if (success)
             {
                 *matches += 1;
                 if ( *matches <= arraySize)
                     strcpy( rsrcList[*matches - 1], instrDesc);
                 else
                 {
                    /* assume someone only wanted the first n found, so
                     * once we find that many, exit successfully via
                     * LOG_STATUS.
                    */

                    hpe1411_LOG_STATUS(VI_NULL, NULL, VI_SUCCESS);
                 }
             }

        }

        /* We are done, so close the Default Resource Manager */
        viClose( defRM );

        hpe1411_LOG_STATUS(VI_NULL, NULL, VI_SUCCESS);

} /* end of hpe1411_findRsrc */


/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_abor
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Aborts a measurement in progress, the trigger system is
 *           returned to the idle state.  No other settings are affected.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_abor(ViSession vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_abor" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"ABOR\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ 
/*#line 4242 "hpe1411.cs"*/
{extern vm_abort();instr_send(vi,vm_abort,(void*)0);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calAll_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine is not for general usage.  This routine is used to
 *           actively calibrate the instrument.  This should only be done
 *           periodically and by someone who has read the service manual and
 *           is familiar with the calibration procedure for this instrument. 
 *           See the service manual for the proper usage of this
 *           command/routine.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 result
 * OUT       
 *            Returns the result of the calibration.  This will be 0 if
 *           sucessful.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calAll_Q(ViSession vi,
  ViPInt16 result)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calAll_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CAL?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",result);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 4313 "hpe1411.cs"*/
{extern vm_cal_all_q();if (!instr_query(vi,vm_cal_all_q,(void*)0,&out_)){
/*#line 4313 "hpe1411.cs"*/
*result=(*(HPSL_INT16*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calLfr
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine selects the line reference frequency used by the A
 *           to D converter.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 calLfr
 * IN        
 *            Indicates the desired line reference frequency; the legal
 *           values are 50 and 60.
 * 
 *      MAX = hpe1411_CAL_LFR_MAX   60
 *      MIN = hpe1411_CAL_LFR_MIN   50
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calLfr(ViSession vi,
  ViInt16 calLfr)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calLfr" );

    hpe1411_CHK_INT_RANGE(calLfr
                         ,hpe1411_CAL_LFR_MIN
                         ,hpe1411_CAL_LFR_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CAL:LFR %hd\n",calLfr);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 4382 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(calLfr);
/*#line 4382 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 4382 "hpe1411.cs"*/
{extern vm_lfre();instr_send(vi,vm_lfre,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calLfr_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of the reference line
 *           frequency.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 calLfr
 * OUT       
 *            Returns the current setting of the reference line frequency,
 *           either 50 or 60.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calLfr_Q(ViSession vi,
  ViPInt16 calLfr)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calLfr_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CAL:LFR?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",calLfr);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 4449 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 4449 "hpe1411.cs"*/
{extern vm_lfre_q();if (!instr_query(vi,vm_lfre_q,&in_,&out_)){
/*#line 4449 "hpe1411.cs"*/
*calLfr=(*(HPSL_INT16*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calStrList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine measures the unstrained reference voltage on the
 *           specified channels.
 *            This must be done before any strain measurements are taken on a
 *           channel. Failure to do so will result in inaccurate data.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            The desired channels on which to measure the unstrained
 *           reference.  The allowable settings depend on which strain
 *           switches are in the mainframe and configured for use by the
 *           voltmeter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calStrList(ViSession vi,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calStrList" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CAL:STR (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+30);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "CAL:STR (@");
        strcat(cmd, channelList);
        strcat(cmd, ")");
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calVal
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine is not for general usage.  This routine is used to
 *           actively calibrate the instrument.  This should only be done
 *           periodically and by someone who has read the service manual and
 *           is familiar with the calibration procedure for this instrument. 
 *           See the service manual for the proper usage of this
 *           command/routine.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 value
 * IN        
 *            The value being applied for the voltmeter to calibrate itself
 *           against.  This is usually and AC voltage, DC voltage, or
 *           Resistance standard.
 * 
 *      MAX = hpe1411_CAL_VALUE_MAX   1200000.0
 *      MIN = hpe1411_CAL_VALUE_MIN   -305.0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calVal(ViSession vi,
  ViReal64 value)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calVal" );

    hpe1411_CHK_REAL_RANGE(value
                          ,hpe1411_CAL_VALUE_MIN
                          ,hpe1411_CAL_VALUE_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CAL:VAL %g\n",value);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[2];} in_;
/*#line 4606 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT64*)in_.p1)->num=(value);
/*#line 4606 "hpe1411.cs"*/
((HPSL_FLOAT64*)in_.p1)->suffix=0;
/*#line 4606 "hpe1411.cs"*/
{extern vm_cal_val();instr_send(vi,vm_cal_val,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calZeroAuto
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Turns Autozero on or off.  If 0 (OFF), then the voltmeter will
 *           make one zero measurement (with the input disabled) and subtract
 *           this value from all subsequent measurements.  If 1 (ON), the
 *           voltmeter makes a zero measurement after each reading and
 *           subtracts this "zero value" from the measurement before
 *           returning the result.  Using the AutoZero ON setting will give
 *           the most accurate measurements, but will result in slower acquisition times.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean calZeroAuto
 * IN        
 *            OFF (0) disables or ON (1) enables autozero measurements.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calZeroAuto(ViSession vi,
  ViBoolean calZeroAuto)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calZeroAuto" );

    hpe1411_CHK_BOOLEAN(calZeroAuto,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CAL:ZERO:AUTO %u\n",calZeroAuto);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 4676 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(calZeroAuto);
/*#line 4676 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 4676 "hpe1411.cs"*/
{extern vm_azero();instr_send(vi,vm_azero,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_calZeroAuto_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of the AutoZero
 *           feature.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean calZeroAuto
 * OUT       
 *            Returns a value of either 0 (OFF) or 1 (ON).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_calZeroAuto_Q(ViSession vi,
  ViPBoolean calZeroAuto)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_calZeroAuto_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CAL:ZERO:AUTO?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",calZeroAuto);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 4742 "hpe1411.cs"*/
{extern vm_azero_q();if (!instr_query(vi,vm_azero_q,(void*)0,&out_)){
/*#line 4742 "hpe1411.cs"*/
*calZeroAuto=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_confFres
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure resistance in Four Wire
 *           mode.  Use this routine when specific voltmeter parameters need
 *           to be changed from their default values (listed below).  The
 *           measurement process will not begin until the hpe1411_initImm
 *           function is called.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_confFres(ViSession vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_confFres" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:FRES\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 4800 "hpe1411.cs"*/
in_.sub1= 3;
/*#line 4800 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 4800 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 4800 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 4800 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_confTemp
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure temperature.  Use this
 *           routine when specific voltmeter parameters need to be changed
 *           from their default values (listed below).  The measurement
 *           process will not begin until the hpe1411_initImm function is
 *           called.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 transducer
 * IN        
 *            Used to specify the transducer type to use for measurement. 
 *           The allowable types are defined as macros as shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_confTemp_transducer_a[] = {"FRTD,385",
        "FRTD,392","FTH,2252","FTH,5000","FTH,10000",0};
ViStatus _VI_FUNC hpe1411_confTemp(ViSession vi,
  ViInt16 transducer)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_confTemp" );

    hpe1411_CHK_ENUM(transducer,4,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:TEMP %s\n",
               hpe1411_confTemp_transducer_a[transducer]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *comma;
        char myfunc[40];
        ViReal64 trans_type;
    
        /* CSCPI expects the transducer type to be a numeric */
        sprintf(myfunc, hpe1411_confTemp_transducer_a[transducer]);
        comma = strchr(myfunc, ',');
        *comma = '\0';
        comma++;
        trans_type = atof(comma);
    
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 4880 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_FRTDFTH05[];char f_=0;
/*#line 4880 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_FRTDFTH05,
                  myfunc,vi, &f_);
/*#line 4880 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_FLOAT32*)in_.p2)->num=((float)trans_type);
/*#line 4880 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p2)->suffix=0;
/*#line 4880 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 4880 "hpe1411.cs"*/
if (!f_) {extern vm_conft();instr_send(vi,vm_conft,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_confTempList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure temperature.  Use this
 *           routine when specific voltmeter parameters need to be changed
 *           from their default values (listed below).  The measurement
 *           process will not begin until the hpe1411_initImm function is
 *           called.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 transducer
 * IN        
 *            Used to specify the transducer type to use for measurement. 
 *           The allowable types are defined as macros as shown below.
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The desired channels to scan.  The allowable settings depend on
 *           which switches are in the mainframe and configured for use by
 *           the voltmeter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_confTempList_transducer_a[] = {
        "FRTD,385","FRTD,392","FTH,2252","FTH,5000","FTH,10000",
        "RTD,385","RTD,392","THER,2252","THER,5000","THER,10000","TC,B",
        "TC,E","TC,J","TC,K","TC,N14","TC,N28","TC,R","TC,S","TC,T",0};
ViStatus _VI_FUNC hpe1411_confTempList(ViSession vi,
  ViInt16 transducer,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_confTempList" );

    hpe1411_CHK_ENUM(transducer,18,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:TEMP %s,(@%s)\n",
               hpe1411_confTempList_transducer_a[transducer],channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+40);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
        sprintf(cmd, "CONF:TEMP %s,(@",
                hpe1411_confTempList_transducer_a[transducer]);
        strcat(cmd, channelList);
        strcat(cmd, ")");
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_confVoltAc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure AC voltage.  Use this
 *           routine when specific voltmeter parameters need to be changed
 *           from their default values (listed below).  The measurement
 *           process will not begin until the hpe1411_initImm function is
 *           called.
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_confVoltAc(ViSession vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_confVoltAc" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:VOLT:AC\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 5036 "hpe1411.cs"*/
in_.sub1= 1;
/*#line 5036 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5036 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 5036 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 5036 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_confVoltDc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure DC voltage.  Use this
 *           routine when specific voltmeter parameters need to be changed
 *           from their default values (listed below).  The measurement
 *           process will not begin until the hpe1411_initImm function is
 *           called.
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_confVoltDc(ViSession vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_confVoltDc" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:VOLT\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 5097 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 5097 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5097 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 5097 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 5097 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_conf_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Returns the current configuration settings of the voltmeter.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 func
 * OUT       
 *            Returns an integer representing the current configuration
 *           function.  The values are as shown below.
 *           
 * 
 * PARAM 3 : ViPBoolean autoRange
 * OUT       
 *            The current setting of auto ranging is returned in this
 *           variable.  If a 1 is returned, auto ranging is enabled, if 0, it
 *           is disabled.
 * 
 * PARAM 4 : ViPReal64 range
 * OUT       
 *            The instrument's current range setting is returned in this
 *           variable.  If a -1.0 is returned, the range was "DEFault".  A
 *           -1.0 is always returned in this parameter if the function is
 *           temperature or strain.
 * 
 * PARAM 5 : ViPReal64 resolution
 * OUT       
 *            The present resolution setting is returned in this parameter. 
 *           If the function is temperature or strain, a -1.0 (DEFault) is
 *           always returned here.
 * 
 * PARAM 6 : ViPInt16 transducer
 * OUT       
 *            The current transducer type setting is returned in this
 *           parameter as an integer value.  If the current function is not
 *           TEMPerature, then a -1 will be returned, otherwise an integer
 *           representing type is returned.  The mapping is represented in
 *           macros as shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_conf_Q_func_a[] = {"FRES","VOLT:AC",
        "VOLT:DC","RES","STR:QUAR","STR:HBEN","STR:HPO","STR:FBEN",
        "STR:FPO","STR:FBP","STR:QTEN","STR:QCOM","STR:UNST","TEMP",0};
static const char * const hpe1411_conf_Q_transducer_a[] = {"FRTD,385",
        "FRTD,392","FTH,2252","FTH,5000","FTH,10000","RTD,385","RTD,392",
        "THER,2252","THER,5000","THER,10000","TC,B","TC,E","TC,J","TC,K",
        "TC,N14","TC,N28","TC,R","TC,S","TC,T",0};
ViStatus _VI_FUNC hpe1411_conf_Q(ViSession vi,
  ViPInt16 func,
  ViPBoolean autoRange,
  ViPReal64 range,
  ViPReal64 resolution,
  ViPInt16 transducer)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    //char func_str[32];
    //char transducer_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_conf_Q" );

    {
    ViChar resp[180];
    char *end_field;	   /* end of current field, usually comma or space */
    
    if (thisPtr->e1406)
    {
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CONF?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t", resp);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        if (resp[1] == 'S')  /* must be strain */
        {
            end_field = strchr(&resp[1], '"');
            *end_field = '\0';
        
            /* determine which function it is */
            if (errStatus = hpe1411_findIndex(thisPtr, hpe1411_conf_Q_func_a,
                                  &resp[1], func) )
            {
                hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
            }
        
            /* mark the range, resolution and transducer as invalid */
            *range = -1;
            *resolution = -1;
            *transducer = -1;
           
            /* indicate autoRange is enabled */
            *autoRange = 1;
        }
        else if(resp[1] == 'T')  /* must be temperature */
        {
            /* mark the range and resolution as invalid */
            *range = -1;
            *resolution = -1;
           
            /* indicate autoRange is enabled */
            *autoRange = 1;
        
            /* return string looks like "TEMP RTD,385" */
            /* skip past TEMP and space */
            end_field = strchr(&resp[6], '"');
            *end_field = '\0';
        
            /* determine which transducer type it is */
            if (errStatus = hpe1411_findIndex(thisPtr, hpe1411_conf_Q_transducer_a,
                                  &resp[6], transducer) )
            {
                hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
            }
        
        }
        else if(resp[1] == 'V')  /* is voltage */
        {
            /* mark transducer as invalid */
            *transducer = -1;
        
            if (resp[5] == ':')  /* have "VOLT:AC range,res" */
            {
        	*func = hpe1411_CONF_VOLT_AC;
                *range = atof(&resp[8]);
            }
            else	/* we have "VOLT range,res" */
            {
        	*func = hpe1411_CONF_VOLT_DC;
                *range = atof(&resp[5]);
            }
            end_field = strchr(&resp[6], ',');
            end_field++;
            *resolution = atof(end_field);
        
            /* get autorange */
            errStatus = viPrintf(vi,"VOLT:RANG:AUTO?\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
        
            errStatus = viScanf(vi,"%hd%*t",autoRange);
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
        
        }  /* end if voltage */
        
        else if(resp[1] == 'R' || resp[1] == 'F')  /* is RES or FRES */
        {
            /* mark transducer as invalid */
            *transducer = -1;
        
            /* get autorange, and range and resolution */
            if (resp[2] == 'E')  /* have "RES rang,res"  */
            {
        	*func = hpe1411_CONFQ_RES;
                *range = atof(&resp[4]);
            }
            else	/* we have "FRES range,res" */
            {
        	*func = hpe1411_CONFQ_FRES;
                *range = atof(&resp[5]);
            }
            end_field = strchr(&resp[6], ',');
            end_field++;
            *resolution = atof(end_field);
        
            /* get autorange */
            errStatus = viPrintf(vi,"VOLT:RANG:AUTO?\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
        
            errStatus = viScanf(vi,"%hd%*t",autoRange);
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
        
        }  /* end if RES or FRES */
        
        else   /* we did not recognize the type */
        {
            /* mark transducer, range, and resolution as invalid */
            *transducer = -1;
            *range = -1;
            *resolution = -1;
        
            hpe1411_CDE_MESSAGE("Unrecognized function type" );
            hpe1411_LOG_STATUS( vi, thisPtr, hpe1411_INSTR_ERROR_UNEXPECTED );
        
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 5332 "hpe1411.cs"*/
{extern vm_conf_q();if (!instr_query(vi,vm_conf_q,(void*)0,&out_)){
/*#line 5332 "hpe1411.cs"*/
(void)strcpy((resp),*(HPSL_STRING*)out_.p1);}}}}
    
        if (resp[0] == 'S')  /* must be strain */
        {
        
            /* determine which function it is */
            if (errStatus = hpe1411_findIndex(thisPtr, hpe1411_conf_Q_func_a,
                                  resp, func) )
            {
                hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
            }
        
            /* mark the range, resolution and transducer as invalid */
            *range = -1;
            *resolution = -1;
            *transducer = -1;
           
            /* indicate autoRange is enabled */
            *autoRange = 1;
        }
        else if(resp[0] == 'T')  /* must be temperature */
        {
            /* mark the range and resolution as invalid */
            *range = -1;
            *resolution = -1;
           
            /* indicate autoRange is enabled */
            *autoRange = 1;
        
            /* return string looks like "TEMP RTD,385" */
            /* skip past TEMP and space */
            /* determine which transducer type it is */
            if (errStatus = hpe1411_findIndex(thisPtr, hpe1411_conf_Q_transducer_a,
                                  &resp[5], transducer) )
            {
                hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
            }
        
        }
        else if(resp[0] == 'V')  /* is voltage */
        {
            /* mark transducer as invalid */
            *transducer = -1;
        
            if (resp[4] == ':')  /* have "VOLT:AC range,res" */
            {
        	    *func = hpe1411_CONF_VOLT_AC;
                *range = atof(&resp[7]);
            }
            else	/* we have "VOLT range,res" */
            {
        	    *func = hpe1411_CONF_VOLT_DC;
                *range = atof(&resp[4]);
            }
            end_field = strchr(&resp[6], ',');
            end_field++;
            *resolution = atof(end_field);
        
            {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 5390 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 5390 "hpe1411.cs"*/
{extern vm_vrang_auto_q();if (!instr_query(vi,vm_vrang_auto_q,&in_,&out_)){
/*#line 5390 "hpe1411.cs"*/
*autoRange=*(HPSL_BOOLEAN*)out_.p1;}}}}
        
        }  /* end if voltage */
        
        else if(resp[0] == 'R' || resp[0] == 'F')  /* is RES or FRES */
        {
            /* mark transducer as invalid */
            *transducer = -1;
        
            /* get autorange, and range and resolution */
            if (resp[1] == 'E')  /* have "RES rang,res"  */
            {
        	*func = hpe1411_CONFQ_RES;
                *range = atof(&resp[3]);
            }
            else	/* we have "FRES range,res" */
            {
        	*func = hpe1411_CONFQ_FRES;
                *range = atof(&resp[4]);
            }
            end_field = strchr(&resp[6], ',');
            end_field++;
            *resolution = atof(end_field);
        
            /* get autorange */
            {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 5415 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 5415 "hpe1411.cs"*/
{extern vm_vrang_auto_q();if (!instr_query(vi,vm_vrang_auto_q,&in_,&out_)){
/*#line 5415 "hpe1411.cs"*/
*autoRange=*(HPSL_BOOLEAN*)out_.p1;}}}}
        
        }  /* end if RES or FRES */
    
        else   /* we did not recognize the type */
        {
            /* mark transducer, range, and resolution as invalid */
            *transducer = -1;
            *range = -1;
            *resolution = -1;
        
            hpe1411_CDE_MESSAGE("Unrecognized function type" );
            hpe1411_LOG_STATUS( vi, thisPtr, hpe1411_INSTR_ERROR_UNEXPECTED );
        
        }
    }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_configure
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure the specified function. 
 *           Use this routine when specific voltmeter parameters need to be
 *           changed from their default values (listed below).  The
 *           measurement process will not begin until the hpe1411_initImm
 *           function is called.
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument..
 * 
 * PARAM 2 : ViInt16 func
 * IN        
 *            The desired function to configure the voltmeter to measure. 
 *           The allowable settings are shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_configure_func_a[] = {"FRES","VOLT:AC",
        "VOLT:DC",0};
ViStatus _VI_FUNC hpe1411_configure(ViSession vi,
  ViInt16 func)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_configure" );

    hpe1411_CHK_ENUM(func,2,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:%s\n",hpe1411_configure_func_a[func]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        switch (func)
        {
            case hpe1411_CONF_VOLT_AC:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 5503 "hpe1411.cs"*/
in_.sub1= 1;
/*#line 5503 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5503 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 5503 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 5503 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
    	break;
    
            case hpe1411_CONF_FRES:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 5507 "hpe1411.cs"*/
in_.sub1= 3;
/*#line 5507 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5507 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 5507 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 5507 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
    	break;
    
            case hpe1411_CONF_VOLT_DC:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 5511 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 5511 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5511 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 5511 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 5511 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
    	break;
            
            /* should never get here, but if do, send VOLT:DC */
    	default:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;
/*#line 5516 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 5516 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5516 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 5516 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 5516 "hpe1411.cs"*/
{extern vm_conf();instr_send(vi,vm_conf,&in_);}}}
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_configureList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure the specified function on
 *           the specified channels.  Use this routine when specific
 *           voltmeter parameters need to be changed from their default
 *           values (listed below).  The measurement process will not begin
 *           until the hpe1411_initImm function is called.
 *            For Temperature measurements use the confTemp or confTempList
 *           functions, for Strain measurements use the confStrList function.
 *           
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 func
 * IN        
 *            The desired function to configure the voltmeter to measure. 
 *           The allowable settings are shown below.
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The desired channels to scan.  The allowable settings depend on
 *           which switches are in the mainframe and configured for use by
 *           the voltmeter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_configureList_func_a[] = {"FRES",
        "VOLT:AC","VOLT","RES","STR:QUAR","STR:HBEN","STR:HPO",
        "STR:FBEN","STR:FPO","STR:FBP","STR:QTEN","STR:QCOM","STR:UNST",0};
ViStatus _VI_FUNC hpe1411_configureList(ViSession vi,
  ViInt16 func,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_configureList" );

    hpe1411_CHK_ENUM(func,12,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CONF:%s (@%s)\n",
               hpe1411_configureList_func_a[func],channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+45);
    	long old_error;
    
    	if (!cmd)
    	{
    		hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	sprintf(cmd, "CONF:%s (@", hpe1411_configureList_func_a[func]);
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    	free(cmd);
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
    	}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_fetc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine returns readings stored in memory from the last
 *           measurement operation.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 _VI_FAR readings[]
 * OUT       
 *            The array of double which will hold the readings.  Make sure it
 *           is large enough to hold the data.
 * 
 * PARAM 3 : ViInt32 dataArrayLen
 * IN        
 *            Indicates the size of the array "readings".
 * 
 *      MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
 *      MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_fetc_Q(ViSession vi,
  ViReal64 _VI_FAR readings[],
  ViInt32 dataArrayLen)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_fetc_Q" );

    hpe1411_CHK_LONG_RANGE(dataArrayLen
                          ,hpe1411_DATA_ARRAY_LEN_MIN
                          ,hpe1411_DATA_ARRAY_LEN_MAX
                          ,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        thisPtr->blockSrqIO = VI_TRUE;
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        errStatus = viPrintf(vi, "FETC?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 0); 
    #else
/*#line 5705 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 1); 
    #endif
/*#line 5707 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        ViInt32 trigCount,sampCount;
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 5717 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 5717 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 5717 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 5717 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }

        /* Since INST_QUERY doesn't check array length, do a manual check */
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 5722 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5722 "hpe1411.cs"*/
{extern vm_trig_count_q();if (!instr_query(vi,vm_trig_count_q,&in_,&out_)){
/*#line 5722 "hpe1411.cs"*/
*&trigCount=(*(HPSL_INT32*)out_.p1).num;}}}}
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 5723 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 5723 "hpe1411.cs"*/
{extern vm_samp_count_q();if (!instr_query(vi,vm_samp_count_q,&in_,&out_)){
/*#line 5723 "hpe1411.cs"*/
*&sampCount=(*(HPSL_INT32*)out_.p1).num;}}}}
        if(dataArrayLen < (trigCount*sampCount)) {
            hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
    
        /* INST_QUERY strips IEEE header and gets byte order correct */
        {{ struct {double p1[2];} out_;
/*#line 5729 "hpe1411.cs"*/
{extern vm_fetch_q();if (!instr_query(vi,vm_fetch_q,(void*)0,&out_)){
/*#line 5729 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 5729 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(readings,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_func
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This selects the measurement function consisting of 4-wire
 *           resistance, DC voltage, and AC voltage.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument..
 * 
 * PARAM 2 : ViInt16 func
 * IN        
 *            This parameter is an integer which represents the voltmeter
 *           function that is desired.  The mapping is represented in macros
 *           as shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_func_func_a[] = {"FRES","VOLT:AC",
        "VOLT",0};
ViStatus _VI_FUNC hpe1411_func(ViSession vi,
  ViInt16 func)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_func" );

    hpe1411_CHK_ENUM(func,2,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"FUNC \"%s\"\n",hpe1411_func_func_a[func]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char myFunc[40];
    
        sprintf(myFunc, "FUNC \"%s\"\n", hpe1411_func_func_a[func]);
        cscpi_exe(vi, myFunc, strlen(myFunc), 0, 0);
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_func_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of the function.  Note
 *           that if you have configured the instrument for Temperature, the
 *           function returned is either VOLT, RES or FRES depending on the
 *           transducer type selected.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 func
 * OUT       
 *            Returns an integer representing the current function setting. 
 *           The mapping is as shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_func_Q_func_a[] = {"FRES","VOLT:AC",
        "VOLT",0};
ViStatus _VI_FUNC hpe1411_func_Q(ViSession vi,
  ViPInt16 func)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    //char func_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_func_Q" );

    {
    char temp_str[40];
    char *quote;
    
       if (thisPtr->e1406)
       {
           errStatus = viPrintf(vi,"FUNC?\n");
           if (errStatus < VI_SUCCESS)
           {
               hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
           }
    
           errStatus = viScanf(vi, "%s%*t", temp_str);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
    
           /* get rid of leading and trailing quotes */
           quote = strchr(&temp_str[1],'"');	/* get pointer to last quote */
           *quote = '\0';			/* replace quote with \0 */
        
           errStatus = hpe1411_findIndex(thisPtr, hpe1411_func_func_a,
                          &temp_str[1], func);
       }
       else
       {
           {{ struct {double p1[1];} out_;
/*#line 5880 "hpe1411.cs"*/
{extern vm_func_q();if (!instr_query(vi,vm_func_q,(void*)0,&out_)){
/*#line 5880 "hpe1411.cs"*/
(void)strcpy((temp_str),*(HPSL_STRING*)out_.p1);}}}}
        
           errStatus = hpe1411_findIndex(thisPtr, hpe1411_func_func_a,
                          temp_str, func);
       }
    
       if (errStatus < VI_SUCCESS)
       {
          hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
       }
    
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_initImm
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Places the voltmeter in the wait-for-trigger state and stores
 *           readings in voltmeter memory when a trigger occurs. The new
 *           readings replace the readings in memory from previous commands.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_initImm(ViSession vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_initImm" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"INIT\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ 
/*#line 5946 "hpe1411.cs"*/
{extern vm_init();instr_send(vi,vm_init,(void*)0);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measFres_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure resistance in the
 *           Four-wire mode, and takes a reading using the default settings
 *           forced by the configure.  This is the simplest way to take a
 *           reading with the voltmeter.  If the default settings are
 *           acceptable, and a single reading is all that is desired, then
 *           this routine is the one to use.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 reading
 * OUT       
 *            The measurement result is returned in this parameter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_measFres_Q(ViSession vi,
  ViPReal64 reading)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measFres_Q" );

    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi, "MEAS:FRES?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many,
                            0); 
    #else
/*#line 6026 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many,
                            1); 
    #endif
/*#line 6029 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6038 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6038 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6038 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6038 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        /* Note: INST_QUERY will strip IEEE header and get byte order correct*/
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6043 "hpe1411.cs"*/
in_.sub1= 3;
/*#line 6043 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6043 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6043 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6043 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6043 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6043 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measTempList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure temperature and takes a
 *           reading on each of the specified channels using the default
 *           settings forced by the configure. This is the simplest way to
 *           take a reading with the voltmeter.  If the default settings are
 *           acceptable, and a single reading per channel is all that is
 *           desired, then this routine is the one to use.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 transducer
 * IN        
 *            Used to specify the transducer type to use for measurement. 
 *           The allowable types are defined as macros as shown below.
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The desired channels to scan.  The allowable settings depend on
 *           which switches are in the mainframe and configured for use by
 *           the voltmeter.
 * 
 * PARAM 4 : ViReal64 _VI_FAR readings[]
 * OUT       
 *            The measurement result is returned in this parameter.  It is up
 *           to the user to make sure the array is at least as large as the
 *           channelList specified.
 * 
 * PARAM 5 : ViInt32 dataArrayLen
 * IN        
 *            Indicates the size of the array "readings".
 * 
 *      MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
 *      MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_measTempList_Q_transducer_a[] = {
        "FRTD,385","FRTD,392","FTH,2252","FTH,5000","FTH,10000",
        "RTD,385","RTD,392","THER,2252","THER,5000","THER,10000","TC,B",
        "TC,E","TC,J","TC,K","TC,N14","TC,N28","TC,R","TC,S","TC,T",0};
ViStatus _VI_FUNC hpe1411_measTempList_Q(ViSession vi,
  ViInt16 transducer,
  ViString channelList,
  ViReal64 _VI_FAR readings[],
  ViInt32 dataArrayLen)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measTempList_Q" );

    hpe1411_CHK_ENUM(transducer,18,VI_ERROR_PARAMETER2);
    hpe1411_CHK_LONG_RANGE(dataArrayLen
                          ,hpe1411_DATA_ARRAY_LEN_MIN
                          ,hpe1411_DATA_ARRAY_LEN_MAX
                          ,VI_ERROR_PARAMETER5);

    { /* Custom I/O code. */
    
       char       * cmmdStr;         /* holds command for cscpi_exe call */
#ifdef WIN32 
       char       * resultStr;       /* holds result from cscpi_exe call */
#else
/*#line 6136 "hpe1411.cs"*/
       char _huge * resultStr;       /* holds result from cscpi_exe call */
#endif
/*#line 6138 "hpe1411.cs"*/
       ViInt32      resultLength;    /* size of resultStr array.     */
       ViInt32      readingCnt;     /* count of # of readings returned. */
       ViInt32      numBytes;        /* number of bytes in DAB block     */
       int          numDigits;       /* number of digits in DAB header   */
       ViInt32      i;               /* loop counter.                    */
       char         digitStr[256];    /* temporary array to read byte cnt */
       char         func_str[256];    /* temp string to hold MEAS:<func>? */
    
    
       /* get func_str syntax */
       sprintf(func_str, "MEAS:TEMP? %s,", hpe1411_measTempList_Q_transducer_a[transducer]);
    
       /* Acquire memory for cscpi_exe() call.          */
       /*   (commandString+space+(@+channelList+)+rtn+null.) */
       cmmdStr = (char *) malloc( strlen(func_str) + 3 + strlen(channelList) + 3 );
       if (cmmdStr == NULL)
          hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    
       /* Form textual SCPI command. */
       sprintf(cmmdStr,"%s(@%s)",func_str, channelList);
    
       /* Command is in cmmdStr, execute it as reg or mssg based cmmd. */
       if (thisPtr->e1406)
       {
          ViInt32 how_many;	/* number of readings returned */
    
          /* Check dirty bit and change data format if necessary */
          if (thisPtr->dirtyBit)
          {
             errStatus = viPrintf(vi, "FORM REAL,64\n");
             if (errStatus < VI_SUCCESS)
             {
                free(cmmdStr);
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
             }
    
             thisPtr->dirtyBit = 0;
          }
    
          /* keep SRQ from interrupting us */
          thisPtr->blockSrqIO = VI_TRUE;
    
          /* Write this command w/block parameter to instr (already has RTN). */
          errStatus = viPrintf(vi, "%s\n", cmmdStr);
          if (errStatus < VI_SUCCESS)
          {
             free(cmmdStr);
             hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
          }
    
          /* Fetch DAB response array back from instrument. */
          /* Add code here to handle block data */
          /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
          errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 0); 
    #else
/*#line 6194 "hpe1411.cs"*/
          errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 1); 
    #endif
/*#line 6196 "hpe1411.cs"*/
          if (errStatus < VI_SUCCESS)
          {
              free(cmmdStr);
              hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
          }
    
       }  /* If (E1406 mode) */
    
       else  /* Must be Register-based I/O mode */
       {
          /* Acquire memory for cscpi_exe()/mssg-based call response.  */
          /*   (array length*sizefloat64 + DAB header + DAB tailer.    */
          resultLength = (dataArrayLen*((ViInt32)sizeof(ViReal64))) + 12L + 2L;
          
          resultStr = NULL;  /* initialize this */
    
          /* make sure memory is power of 2 if greater than 131k bytes */
#ifdef WIN32 
          resultStr = (char *) malloc(resultLength);
         
#else
/*#line 6217 "hpe1411.cs"*/
          resultStr = (char __huge *) halloc(resultLength, 1);
#endif
/*#line 6219 "hpe1411.cs"*/
    
          if (resultStr == NULL)
          {
             free(cmmdStr);
             hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
          }
    
          if (thisPtr->dirtyBit)
          {
             {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6228 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6228 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6228 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6228 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    
    	 thisPtr->dirtyBit = 0;
          }
    
          /* Use run-time parse call to process command. */
          cscpi_exe( vi, cmmdStr, strlen(cmmdStr), resultStr, resultLength );
    
          /* Now process DAB array from query response. */
          if (resultStr[0] != '#')
          {
             free(cmmdStr);
#ifdef WIN32 
            free(resultStr);
#else
/*#line 6243 "hpe1411.cs"*/
            hfree(resultStr);
#endif
/*#line 6245 "hpe1411.cs"*/
             hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_INV_EXPR );
          }
    
          /* Evaluate the number of digits in header (first number). */
          numDigits = resultStr[1] - 48;               /* recall ASCII 0 = 48 */
    
          /* Sanity check value (0<=n<=9). */
          if ( (numDigits<0) || (9<numDigits) )
          {
             free(cmmdStr);
#ifdef WIN32 
            free(resultStr);
#else
/*#line 6258 "hpe1411.cs"*/
            hfree(resultStr);
#endif
/*#line 6260 "hpe1411.cs"*/
             hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_SYSTEM_ERROR );
          }
    
          /* Make copy of byte count string and null terminate. */
          for (i=0L ; i<numDigits; i++)
             digitStr[i] = resultStr[2L+i];
          digitStr[numDigits] = '\0';
    
          /* Now convert byte count into integer variable (base 10). */
          /* (Note: sscanf() not available for Win dlls.)            */
          numBytes = (ViInt32) atol(digitStr);
    
          /* Assess how many readings in buffer. */
          readingCnt = numBytes/((ViInt32)(sizeof(ViReal64)));
    
          /* Transfer temporary array to caller's array.         */
          /* (Note: DAB contains 64bit floats in native format.) */
          /* fmemcpy can handle __huge arrays.                   */
#ifdef WIN32
         memcpy( (void  *)  readings,
                    (void  *) &resultStr[2+numDigits],
                    (size_t)         numBytes                    );
#else
/*#line 6283 "hpe1411.cs"*/
         _fmemcpy( (void __huge *)  readings,
                    (void __huge *) &resultStr[2+numDigits],
                    (size_t)         numBytes                    );
#endif    
/*#line 6287 "hpe1411.cs"*/
    #ifndef B_ENDIAN
          /* Must swap bytes to convert to Intel format. */
          for (i=0; i<readingCnt; i++)
             SWAP_FLOAT64(&readings[i]);
    #endif
/*#line 6292 "hpe1411.cs"*/
    
          free(cmmdStr);
#ifdef WIN32 
            free(resultStr);
#else
/*#line 6297 "hpe1411.cs"*/
            hfree(resultStr);
#endif
/*#line 6299 "hpe1411.cs"*/
    
       } /* Else, must be Register-based */
    
    } /* Custom I/O code. */
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measTemp_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure temperature in degrees
 *           Celcius and takes a reading using the default settings forced by
 *           the configure.  This is the simplest way to take a reading with
 *           the voltmeter.  If the default settings are acceptable, and a
 *           single reading is all that is desired, then this routine is the
 *           one to use.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 transducer
 * IN        
 *            Used to specify the transducer type to use for measurement. 
 *           The allowable types are defined as macros as shown below.
 * 
 * PARAM 3 : ViPReal64 reading
 * OUT       
 *            A single measurement result is returned in this parameter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_measTemp_Q_transducer_a[] = {"FRTD,385",
        "FRTD,392","FTH,2252","FTH,5000","FTH,10000",0};
ViStatus _VI_FUNC hpe1411_measTemp_Q(ViSession vi,
  ViInt16 transducer,
  ViPReal64 reading)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measTemp_Q" );

    hpe1411_CHK_ENUM(transducer,4,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"MEAS:TEMP? %s\n",
               hpe1411_confTemp_transducer_a[transducer]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, 1, reading, &how_many, 0); 
    #else
/*#line 6390 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, 1, reading, &how_many, 1); 
    #endif
/*#line 6392 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *comma;
        char myfunc[40];
        ViReal64 trans_type;
    
        /* CSCPI expects the transducer type to be a numeric */
        sprintf(myfunc, hpe1411_confTemp_transducer_a[transducer]);
        comma = strchr(myfunc, ',');
        *comma = '\0';
        comma++;
        trans_type = atof(comma);
    
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6412 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6412 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6412 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6412 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6416 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_FRTDFTH05[];char f_=0;
/*#line 6416 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_FRTDFTH05,myfunc,vi, &f_);
/*#line 6416 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_FLOAT32*)in_.p2)->num=(trans_type);
/*#line 6416 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p2)->suffix=0;
/*#line 6416 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6416 "hpe1411.cs"*/
if (!f_) {extern vm_meast_q();if (!instr_query(vi,vm_meast_q,&in_,&out_)){
/*#line 6416 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6416 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measVoltAc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure AC voltage and takes a
 *           reading using the default settings forced by the configure. 
 *           This is the simplest way to take a reading with the voltmeter. 
 *           If the default settings are acceptable, and a single reading is
 *           all that is desired, then this routine is the one to use.
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 reading
 * OUT       
 *            The measurement result is returned in this parameter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_measVoltAc_Q(ViSession vi,
  ViPReal64 reading)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measVoltAc_Q" );

    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi, "MEAS:VOLT:AC?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many, 0); 
    #else
/*#line 6497 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many, 1); 
    #endif
/*#line 6499 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6508 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6508 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6508 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6508 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        /* Note: INST_QUERY will strip IEEE header and get byte order correct*/
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6513 "hpe1411.cs"*/
in_.sub1= 1;
/*#line 6513 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6513 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6513 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6513 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6513 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6513 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measVoltDc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure DC voltage and takes a
 *           reading using the default settings forced by the configure. 
 *           This is the simplest way to take a reading with the voltmeter. 
 *           If the default settings are acceptable, and a single reading is
 *           all that is desired, then this routine is the one to use.
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 reading
 * OUT       
 *            The measurement result is returned in this parameter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_measVoltDc_Q(ViSession vi,
  ViPReal64 reading)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measVoltDc_Q" );

    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi, "MEAS:VOLT?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many, 0); 
    #else
/*#line 6594 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many, 1); 
    #endif
/*#line 6596 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6605 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6605 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6605 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6605 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        /* Note: INST_QUERY will strip IEEE header and get byte order correct*/
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6610 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 6610 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6610 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6610 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6610 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6610 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6610 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measureList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure the specified function on
 *           the specified switch channels, and takes the readings.  Use this
 *           routine when the default parameters are acceptable.  For
 *           Temperature measurements, use the measTemp function.
 *           
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 func
 * IN        
 *            The desired function to configure the voltmeter to measure. 
 *           The allowable settings are as shown below.
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The desired channels to scan.  The allowable settings depend on
 *           which switches are in the mainframe and configured for use by
 *           the voltmeter.
 * 
 * PARAM 4 : ViReal64 _VI_FAR readings[]
 * OUT       
 *            The result of the measurement is returned in this parameter.
 * 
 * PARAM 5 : ViInt32 dataArrayLen
 * IN        
 *            Indicates the size of the array "readings".
 * 
 *      MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
 *      MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_measureList_Q_func_a[] = {"FRES",
        "VOLT:AC","VOLT","RES","STR:QUAR","STR:HBEN","STR:HPO",
        "STR:FBEN","STR:FPO","STR:FBP","STR:QTEN","STR:QCOM","STR:UNST",0};
ViStatus _VI_FUNC hpe1411_measureList_Q(ViSession vi,
  ViInt16 func,
  ViString channelList,
  ViReal64 _VI_FAR readings[],
  ViInt32 dataArrayLen)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measureList_Q" );

    hpe1411_CHK_ENUM(func,12,VI_ERROR_PARAMETER2);
    hpe1411_CHK_LONG_RANGE(dataArrayLen
                          ,hpe1411_DATA_ARRAY_LEN_MIN
                          ,hpe1411_DATA_ARRAY_LEN_MAX
                          ,VI_ERROR_PARAMETER5);

    { /* Custom I/O code. */
    
       char       * cmmdStr;         /* holds command for cscpi_exe call */
#ifdef WIN32
       char       * resultStr;       /* holds result from cscpi_exe call */
#else
/*#line 6702 "hpe1411.cs"*/
       char _huge * resultStr;       /* holds result from cscpi_exe call */
#endif
/*#line 6704 "hpe1411.cs"*/
       ViInt32      resultLength;    /* size of resultStr array.     */
       ViInt32      readingCnt;     /* count of # of readings returned. */
       ViInt32      numBytes;        /* number of bytes in DAB block     */
       int          numDigits;       /* number of digits in DAB header   */
       ViInt32      i;               /* loop counter.                    */
       char         digitStr[11];    /* temporary array to read byte cnt */
       char         func_str[32];    /* temp string to hold MEAS:<func>? */
    
    
       /* get func_str syntax */
       sprintf(func_str, "MEAS:%s?", hpe1411_measureList_Q_func_a[func]);
    
       /* Acquire memory for cscpi_exe() call.          */
       /*   (commandString+space+(@+channelList+)+rtn+null.) */
       cmmdStr = (char *) malloc( strlen(func_str) + 3 + strlen(channelList) + 3 );
       if (cmmdStr == NULL)
          hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    
       /* Form textual SCPI command. */
       sprintf(cmmdStr,"%s (@%s)",func_str,channelList);
    
       /* Command is in cmmdStr, execute it as reg or mssg based cmmd. */
       if (thisPtr->e1406)
       {
          ViInt32 how_many;	/* number of readings returned */
    
          /* Check dirty bit and change data format if necessary */
          if (thisPtr->dirtyBit)
          {
             errStatus = viPrintf(vi, "FORM REAL,64\n");
             if (errStatus < VI_SUCCESS)
             {
                free(cmmdStr);
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
             }
    
             thisPtr->dirtyBit = 0;
          }
    
          /* keep SRQ from interrupting us */
          thisPtr->blockSrqIO = VI_TRUE;
    
          /* Write this command w/block parameter to instr (already has RTN). */
          errStatus = viPrintf(vi, "%s\n", cmmdStr);
          if (errStatus < VI_SUCCESS)
          {
             free(cmmdStr);
             hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
          }
    
          /* Fetch DAB response array back from instrument. */
          /* Add code here to handle block data */
          /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
          errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 0); 
    #else
/*#line 6760 "hpe1411.cs"*/
          errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 1); 
    #endif
/*#line 6762 "hpe1411.cs"*/
          if (errStatus < VI_SUCCESS)
          {
              free(cmmdStr);
              hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
          }
    
       }  /* If (E1406 mode) */
    
       else  /* Must be Register-based I/O mode */
       {
          /* Acquire memory for cscpi_exe()/mssg-based call response.  */
          /*   (array length*sizefloat64 + DAB header + DAB tailer.    */
          resultLength = (dataArrayLen*((ViInt32)sizeof(ViReal64))) + 12L + 2L;
          
          resultStr = NULL;  /* initialize this */
    
#ifdef WIN32 
          resultStr = (char *) malloc(resultLength);
         
#else
/*#line 6782 "hpe1411.cs"*/
          resultStr = (char __huge *) halloc(resultLength, 1);
#endif
/*#line 6784 "hpe1411.cs"*/
    
          if (resultStr == NULL)
          {
             free(cmmdStr);
             hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
          }
    
          if (thisPtr->dirtyBit)
          {
             {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6793 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6793 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6793 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6793 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    
    	 thisPtr->dirtyBit = 0;
          }
    
          /* Use run-time parse call to process command. */
          cscpi_exe( vi, cmmdStr, strlen(cmmdStr), resultStr, resultLength );
    
          /* Now process DAB array from query response. */
          if (resultStr[0] != '#')
          {
             free(cmmdStr);
#ifdef WIN32 
            free(resultStr);
#else
/*#line 6808 "hpe1411.cs"*/
            hfree(resultStr);
#endif
/*#line 6810 "hpe1411.cs"*/
             hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_INV_EXPR );
          }
    
          /* Evaluate the number of digits in header (first number). */
          numDigits = resultStr[1] - 48;               /* recall ASCII 0 = 48 */
    
          /* Sanity check value (0<=n<=9). */
          if ( (numDigits<0) || (9<numDigits) )
          {
             free(cmmdStr);
#ifdef WIN32 
            free(resultStr);
#else
/*#line 6823 "hpe1411.cs"*/
            hfree(resultStr);
#endif
/*#line 6825 "hpe1411.cs"*/
             hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_SYSTEM_ERROR );
          }
    
          /* Make copy of byte count string and null terminate. */
          for (i=0L ; i<numDigits; i++)
             digitStr[i] = resultStr[2L+i];
          digitStr[numDigits] = '\0';
    
          /* Now convert byte count into integer variable (base 10). */
          /* (Note: sscanf() not available for Win dlls.)            */
          numBytes = (ViInt32) atol(digitStr);
    
          /* Assess how many readings in buffer. */
          readingCnt = numBytes/((ViInt32)(sizeof(ViReal64)));
    
          /* Transfer temporary array to caller's array.         */
          /* (Note: DAB contains 64bit floats in native format.) */
          /* fmemcpy can handle __huge arrays.                   */
 #ifdef WIN32
          memcpy( (void  *)  readings,
                    (void  *) &resultStr[2+numDigits],
                    (size_t)         numBytes                    );
#else
/*#line 6848 "hpe1411.cs"*/
          _fmemcpy( (void __huge *)  readings,
                    (void __huge *) &resultStr[2+numDigits],
                    (size_t)         numBytes                    );
#endif
/*#line 6852 "hpe1411.cs"*/
    
    #ifndef B_ENDIAN
          /* Must swap bytes to convert to Intel format. */
          for (i=0; i<readingCnt; i++)
             SWAP_FLOAT64(&readings[i]);
    #endif
/*#line 6858 "hpe1411.cs"*/
    
          free(cmmdStr);
#ifdef WIN32 
            free(resultStr);
#else
/*#line 6863 "hpe1411.cs"*/
            hfree(resultStr);
#endif
/*#line 6865 "hpe1411.cs"*/
    
       } /* Else, must be Register-based */
    
    } /* Custom I/O code. */
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_measure_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Configures the instrument to measure the specified function and
 *           takes a reading.  Use this routine when the default parameters
 *           are acceptable.
 *            Note that no range and resolution parameters are necessary. 
 *           The voltmeter defaults the range and resolution, and
 *           auto-ranging is enabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 func
 * IN        
 *            The desired function to configure the voltmeter to measure. 
 *           The allowable settings are as shown below.
 * 
 * PARAM 3 : ViPReal64 reading
 * OUT       
 *            The result of the measurement is returned in this parameter.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_measure_Q_func_a[] = {"FRES","VOLT:AC",
        "VOLT:DC",0};
ViStatus _VI_FUNC hpe1411_measure_Q(ViSession vi,
  ViInt16 func,
  ViPReal64 reading)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_measure_Q" );

    hpe1411_CHK_ENUM(func,2,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"MEAS:%s?\n",hpe1411_measure_Q_func_a[func]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many, 0); 
    #else
/*#line 6955 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, reading, &how_many, 1); 
    #endif
/*#line 6957 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 6966 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 6966 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 6966 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 6966 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        switch (func)
        {
            case hpe1411_CONF_VOLT_AC:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6973 "hpe1411.cs"*/
in_.sub1= 1;
/*#line 6973 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6973 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6973 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6973 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6973 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6973 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    	break;
    
            case hpe1411_CONF_FRES:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6977 "hpe1411.cs"*/
in_.sub1= 3;
/*#line 6977 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6977 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6977 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6977 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6977 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6977 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    	break;
    
            case hpe1411_CONF_VOLT_DC:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6981 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 6981 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6981 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6981 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6981 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6981 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6981 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    	break;
            
            /* should never get here, but if do, send VOLT:DC */
    	default:
               {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];short p3_type; char p3_type_pad[6]; double p3[1];} in_;struct {double p1[2];} out_;
/*#line 6986 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 6986 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 6986 "hpe1411.cs"*/
in_.p2_type= -1;
/*#line 6986 "hpe1411.cs"*/
in_.p3_type= -1;
/*#line 6986 "hpe1411.cs"*/
{extern vm_meas_q();if (!instr_query(vi,vm_meas_q,&in_,&out_)){
/*#line 6986 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 6986 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(reading,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_memVmeAddr
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the address of the external memory board in A24 memory
 *           address space.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 memVmeAddr
 * IN        
 *            Sets A24 address of external memory card.
 * 
 *      MAX = hpe1411_MEM_VME_ADDR_MAX   14680056
 *      MIN = hpe1411_MEM_VME_ADDR_MIN   2097152
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_memVmeAddr(ViSession vi,
  ViInt32 memVmeAddr)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_memVmeAddr" );

    hpe1411_CHK_LONG_RANGE(memVmeAddr
                          ,hpe1411_MEM_VME_ADDR_MIN
                          ,hpe1411_MEM_VME_ADDR_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"MEM:VME:ADDR %ld\n",memVmeAddr);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 7055 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(memVmeAddr);
/*#line 7055 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 7055 "hpe1411.cs"*/
{extern vm_mem_addr();instr_send(vi,vm_mem_addr,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_memVmeAddr_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of memVmeAddr
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt32 memVmeAddr
 * OUT       
 *            Returns current A24 memory address of memory card.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_memVmeAddr_Q(ViSession vi,
  ViPInt32 memVmeAddr)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_memVmeAddr_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"MEM:VME:ADDR?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%ld%*t",memVmeAddr);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 7120 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 7120 "hpe1411.cs"*/
{extern vm_mem_addr_q();if (!instr_query(vi,vm_mem_addr_q,&in_,&out_)){
/*#line 7120 "hpe1411.cs"*/
*memVmeAddr=(*(HPSL_INT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_memVmeSize
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the size, in bytes, of the external VME memory card.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 memVmeSize
 * IN        
 *            Sets byte sixe of external VME memory card.
 * 
 *      MAX = hpe1411_MEM_VME_SIZE_MAX   12582912
 *      MIN = hpe1411_MEM_VME_SIZE_MIN   0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_memVmeSize(ViSession vi,
  ViInt32 memVmeSize)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_memVmeSize" );

    hpe1411_CHK_LONG_RANGE(memVmeSize
                          ,hpe1411_MEM_VME_SIZE_MIN
                          ,hpe1411_MEM_VME_SIZE_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"MEM:VME:SIZE %ld\n",memVmeSize);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 7187 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(memVmeSize);
/*#line 7187 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 7187 "hpe1411.cs"*/
{extern vm_mem_size();instr_send(vi,vm_mem_size,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_memVmeSize_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of memVmeSize
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt32 memVmeSize
 * OUT       
 *            Returns current byte size value of external VME memory card.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_memVmeSize_Q(ViSession vi,
  ViPInt32 memVmeSize)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_memVmeSize_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"MEM:VME:SIZE?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%ld%*t",memVmeSize);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 7252 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 7252 "hpe1411.cs"*/
{extern vm_mem_size_q();if (!instr_query(vi,vm_mem_size_q,&in_,&out_)){
/*#line 7252 "hpe1411.cs"*/
*memVmeSize=(*(HPSL_INT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_memVmeStat
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Enables or disables use of external VME memory card for reading
 *           storage.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean memVmeStat
 * IN        
 *            OFF (0) disables or ON (1) enables external VME memory card.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_memVmeStat(ViSession vi,
  ViBoolean memVmeStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_memVmeStat" );

    hpe1411_CHK_BOOLEAN(memVmeStat,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"MEM:VME:STAT %u\n",memVmeStat);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 7317 "hpe1411.cs"*/
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((memVmeStat)!=0);
/*#line 7317 "hpe1411.cs"*/
{extern vm_mem_state();instr_send(vi,vm_mem_state,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_memVmeStat_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of memVmeStat
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean memVmeStat
 * OUT       
 *            Returns 0 if external VME memory is disabled, or 1 if  enabled.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_memVmeStat_Q(ViSession vi,
  ViPBoolean memVmeStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_memVmeStat_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"MEM:VME:STAT?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",memVmeStat);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 7382 "hpe1411.cs"*/
{extern vm_mem_state_q();if (!instr_query(vi,vm_mem_state_q,(void*)0,&out_)){
/*#line 7382 "hpe1411.cs"*/
*memVmeStat=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_outpTtlt_M
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Enables or disables routing of the "Voltmetr Complete" signal
 *           to the specified VXIbus trigger line on the backplane P2
 *           connector.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 ttltLine
 * IN        
 *            Specifies the TTLtrg line.
 * 
 *      MAX = hpe1411_TTLT_LINE_MAX   7
 *      MIN = hpe1411_TTLT_LINE_MIN   0
 * 
 * PARAM 3 : ViBoolean ttltStat
 * IN        
 *            OFF (0) disables or ON (1) enables "Voltmeter Complete" pulse
 *           for the specified trigger line.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_outpTtlt_M(ViSession vi,
  ViInt16 ttltLine,
  ViBoolean ttltStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_outpTtlt_M" );

    hpe1411_CHK_INT_RANGE(ttltLine
                         ,hpe1411_TTLT_LINE_MIN
                         ,hpe1411_TTLT_LINE_MAX
                         ,VI_ERROR_PARAMETER2);

    hpe1411_CHK_BOOLEAN(ttltStat,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"OUTP:TTLT%hd %hu\n",ttltLine,ttltStat);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 7462 "hpe1411.cs"*/
in_.sub1= ttltLine;
/*#line 7462 "hpe1411.cs"*/
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((ttltStat)!=0);
/*#line 7462 "hpe1411.cs"*/
{extern vm_out_ttltrg();instr_send(vi,vm_out_ttltrg,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_outpTtlt_M_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of outpTtltrg.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 ttltLine
 * IN        
 *            Specifies the TTLTrg trigger line to be queried.
 * 
 *      MAX = hpe1411_TTLT_LINE_MAX   7
 *      MIN = hpe1411_TTLT_LINE_MIN   0
 * 
 * PARAM 3 : ViPBoolean ttltStat
 * OUT       
 *            Returns 0 if "Voltmeter Complete" is disabled, or 1 if enabled.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_outpTtlt_M_Q(ViSession vi,
  ViInt16 ttltLine,
  ViPBoolean ttltStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_outpTtlt_M_Q" );

    hpe1411_CHK_INT_RANGE(ttltLine
                         ,hpe1411_TTLT_LINE_MIN
                         ,hpe1411_TTLT_LINE_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"OUTP:TTLT%hd?\n",ttltLine);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",ttltStat);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 7540 "hpe1411.cs"*/
in_.sub1= ttltLine;
/*#line 7540 "hpe1411.cs"*/
{extern vm_out_ttltrg_q();if (!instr_query(vi,vm_out_ttltrg_q,&in_,&out_)){
/*#line 7540 "hpe1411.cs"*/
*ttltStat=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_poissonInitList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets the gage factor, Poisson ratio, and measures
 *           the unstrained reference voltage for each channel in the list. 
 *           Before taking Poisson measurements, these constants need to be
 *           set.
 *            The gage factor, Poisson ratio, and unstrained reference
 *           voltage are used by the voltmeter to calculate the Poisson
 *           strain value on a channel.
 *            These settings must be done once after the instrument is
 *           powered on and before any Poisson strain measurements are taken
 *           on a channel.  Failure to do so will result in inaccurate data.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 gageFactor
 * IN        
 *            The gage factor to use for the strain measurement.
 * 
 *      MAX = hpe1411_GFAC_MAX   1.0e3
 *      MIN = hpe1411_GFAC_MIN   1.0e-9
 * 
 * PARAM 3 : ViReal64 poissonRatio
 * IN        
 *            The poisson ratio to use when measuring poisson configurations.
 * 
 *      MAX = hpe1411_POIS_MAX   2.0
 *      MIN = hpe1411_POIS_MIN   1.0e-4
 * 
 * PARAM 4 : ViString channelList
 * IN        
 *            The channel(s) that will receive new constants.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_poissonInitList(ViSession vi,
  ViReal64 gageFactor,
  ViReal64 poissonRatio,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_poissonInitList" );

    hpe1411_CHK_REAL_RANGE(gageFactor
                          ,hpe1411_GFAC_MIN
                          ,hpe1411_GFAC_MAX
                          ,VI_ERROR_PARAMETER2);

    hpe1411_CHK_REAL_RANGE(poissonRatio
                          ,hpe1411_POIS_MIN
                          ,hpe1411_POIS_MAX
                          ,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        errStatus=viPrintf(vi,"STR:GFAC %lg,(@%s);POIS %lg,(@%s);:CAL:STR (@%s)\n",
                  gageFactor, channelList, poissonRatio, channelList, channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+45);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:GFAC %lg,(@%s)", gageFactor, channelList);
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
    
        sprintf(cmd, "STR:POIS %lg,(@%s);:CAL:STR (@%s)",
              poissonRatio, channelList, channelList);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    
        free(cmd);
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_read_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Places the voltmeter in the wait-for-trigger state and
 *           transfers readings directly to the output buffer after receiving
 *           a trigger.  Because voltmeter memory is not used to store the
 *           readings, there is no restriction on the sample count and
 *           trigger count.  Because the readings are formatted before being
 *           sent to the output buffer, the sample rate is not as high as the
 *           one attainable using the hpe1411_initImm and hpe1411_fetc_Q routines.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 _VI_FAR readings[]
 * OUT       
 *            Returns the readings taken by the voltmeter.  The array pointer
 *           passed in must point to an array large enough to hold the data. 
 *           If the array is not large enough, bad things may happen as we
 *           index off the end of the array.
 * 
 * PARAM 3 : ViInt32 dataArrayLen
 * IN        
 *            Indicates the size of the array "readings".
 * 
 *      MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
 *      MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_read_Q(ViSession vi,
  ViReal64 _VI_FAR readings[],
  ViInt32 dataArrayLen)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_read_Q" );

    hpe1411_CHK_LONG_RANGE(dataArrayLen
                          ,hpe1411_DATA_ARRAY_LEN_MIN
                          ,hpe1411_DATA_ARRAY_LEN_MAX
                          ,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi, "READ?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, readings, &how_many,
                            0); 
    #else
/*#line 7753 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, hpe1411_MAX_RDGS64, readings, &how_many,
                            1); 
    #endif
/*#line 7756 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 7765 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 7765 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 7765 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 7765 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        /* Note: INST_QUERY will strip IEEE header and get byte order correct*/
        {{ struct {double p1[2];} out_;
/*#line 7770 "hpe1411.cs"*/
{extern vm_read_q();if (!instr_query(vi,vm_read_q,(void*)0,&out_)){
/*#line 7770 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 7770 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(readings,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resAper
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the integration time in seconds for resistance
 *           measurements.  The voltmeter rounds values UP to the nearest
 *           time possible. See also the hpe1411_resRes and hpe1411_resNplc
 *           functions because changing aperture affects the setting on those
 *           two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 resAper
 * IN        
 *            Sets the integration time in seconds (Aperture) for resistance
 *           measurements. Input values are rounded UP to the nearest
 *           aperture time shown in the table below.
 *           
 *            Aperture is one of three ways to set the resolution of the
 *           reading.  The other two are resolution and NPLC.  The
 *           relationships between range, resolution, aperture and NPLC's
 *           (Number Power Line Cycles) is shown below.
 *            Aperture is determined by the NPLC setting; for example, for 1
 *           power line cycle of 60 Hz power, the aperture is 16.7
 *           milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power
 *           source were 50 Hz instead of 60 Hz, the above numbers would be
 *           20.0 milliseconds and 320 milliseconds respectively.
 *            In the following table, resolution is shown as a function of
 *           range and integration time given in Power Line Cycles (PLCs). 
 *           The associated aperture is shown for 60 Hz power.
 *                   -----------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)       |
 *                   | Aperture for 60 Hz power                           |
 *           -------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125  |  0.005   | .0005 PLC |
 *            Ohms   |  267ms  | 16.7ms  |  2.5ms  |  100us   |  10us     |
 *           -------------------------------------------------------------
 *               256 |   61e-6 | 244e-6  |  976e-6 | 7.812e-3 | 15.625e-3 |
 *              2048 |  488e-6 | 1.95e-3 | 7.812e-3|  62.5e-3 |    125e-3 |
 *             16384 |  3.9e-3 | 15.63e-3| 62.5e-3 |   0.5    |    1.0    |
 *            131072 | 31.2e-3 | 125e-3  |  0.5    |   4.0    |    8.0    |
 *           1048576 |  250e-3 |   1.0   |  4.0    |  32.0    |   64.0    |
 *           -------------------------------------------------------------
 *                   |                Resolution in Ohms                  |
 *                    ----------------------------------------------------
 * 
 *      MAX = hpe1411_APER_MAX   320.0e-3
 *      MIN = hpe1411_APER_MIN   10.0e-6
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resAper(ViSession vi,
  ViReal64 resAper)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resAper" );

    hpe1411_CHK_REAL_RANGE(resAper
                          ,hpe1411_APER_MIN
                          ,hpe1411_APER_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"RES:APER %g\n",resAper);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 7871 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 7871 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(resAper);
/*#line 7871 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 7871 "hpe1411.cs"*/
{extern vm_aper();instr_send(vi,vm_aper,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resAper_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of resAper
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 resAper
 * OUT       
 *            Returns the current resistance aperture time value.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resAper_Q(ViSession vi,
  ViPReal64 resAper)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resAper_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"RES:APER?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",resAper);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 7936 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 7936 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 7936 "hpe1411.cs"*/
{extern vm_raper_q();if (!instr_query(vi,vm_raper_q,&in_,&out_)){
/*#line 7936 "hpe1411.cs"*/
*resAper=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resNplc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the integration time in power line cycles (PLCs) for
 *           resistance measurements. The voltmeter rounds values UP to the
 *           nearest NPLC value. See also the hpe1411_resRes and
 *           hpe1411_resAper functions because changing NPLC affects the
 *           setting on those two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 resNplc
 * IN        
 *            Sets the Number of Power Line Cycles (NPLCs)  for resistance
 *           measurements. Input values are rounded UP to the nearest
 *           aperture time shown in the table below.
 *           
 *            NPLC is one of three ways to set the resolution of the reading.
 *            The other two are resolution and aperture.  The relationships
 *           between range, resolution, aperture and NPLC's (Number Power
 *           Line Cycles) is shown below.
 *            Aperture is determined by the NPLC setting; for example, for 1
 *           power line cycle of 60 Hz power, the aperture is 16.7
 *           milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power
 *           source were 50 Hz instead of 60 Hz, the above numbers would be
 *           20.0 milliseconds and 320 milliseconds respectively.
 *            In the following table, resolution is shown as a function of
 *           range and integration time given in Power Line Cycles (PLCs). 
 *           The associated aperture is shown for 60 Hz power.
 *                   -----------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)       |
 *                   | Aperture for 60 Hz power                           |
 *           -------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125  |  0.005   | .0005 PLC |
 *            Ohms   |  267ms  | 16.7ms  |  2.5ms  |  100us   |  10us     |
 *           -------------------------------------------------------------
 *               256 |   61e-6 | 244e-6  |  976e-6 | 7.812e-3 | 15.625e-3 |
 *              2048 |  488e-6 | 1.95e-3 | 7.812e-3|  62.5e-3 |    125e-3 |
 *             16384 |  3.9e-3 | 15.63e-3| 62.5e-3 |   0.5    |    1.0    |
 *            131072 | 31.2e-3 | 125e-3  |  0.5    |   4.0    |    8.0    |
 *           1048576 |  250e-3 |   1.0   |  4.0    |  32.0    |   64.0    |
 *           -------------------------------------------------------------
 *                   |                Resolution in Ohms                  |
 *                    ----------------------------------------------------
 * 
 *      MAX = hpe1411_NPLC_MAX   16.0
 *      MIN = hpe1411_NPLC_MIN   0.0005
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resNplc(ViSession vi,
  ViReal64 resNplc)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resNplc" );

    hpe1411_CHK_REAL_RANGE(resNplc
                          ,hpe1411_NPLC_MIN
                          ,hpe1411_NPLC_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"RES:NPLC %g\n",resNplc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8037 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8037 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(resNplc);
/*#line 8037 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 8037 "hpe1411.cs"*/
{extern vm_nplc();instr_send(vi,vm_nplc,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resNplc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of resNplc
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 resNplc
 * OUT       
 *            Returns current resistance PLC value.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resNplc_Q(ViSession vi,
  ViPReal64 resNplc)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resNplc_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"RES:NPLC?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",resNplc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 8102 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8102 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 8102 "hpe1411.cs"*/
{extern vm_rnplc_q();if (!instr_query(vi,vm_rnplc_q,&in_,&out_)){
/*#line 8102 "hpe1411.cs"*/
*resNplc=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resOcom
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Enables or disables the offset compensated ohms function (on
 *           30, 300, and 3k ohm ranges only).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean resOcom
 * IN        
 *            OFF (0) disables or ON (1) enables the resistance offset
 *           compensated ohms measurements.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resOcom(ViSession vi,
  ViBoolean resOcom)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resOcom" );

    hpe1411_CHK_BOOLEAN(resOcom,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"RES:OCOM %u\n",resOcom);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8168 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8168 "hpe1411.cs"*/
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((resOcom)!=0);
/*#line 8168 "hpe1411.cs"*/
{extern vm_res_ocom();instr_send(vi,vm_res_ocom,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resOcom_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of resOcom
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean resOcom
 * OUT       
 *            Returns 0 for offset compensated ohms off or 1 for offset
 *           compensated ohms on.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resOcom_Q(ViSession vi,
  ViPBoolean resOcom)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resOcom_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"RES:OCOM?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",resOcom);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 8234 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8234 "hpe1411.cs"*/
{extern vm_res_ocom_q();if (!instr_query(vi,vm_res_ocom_q,&in_,&out_)){
/*#line 8234 "hpe1411.cs"*/
*resOcom=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resRang
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the range for resistance measurements and
 *           disables/enables the auto ranging feature.  If the resRangAuto
 *           parameter is 1 (ON) then the value sent in resRang parameter is
 *           ignored.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean autoRange
 * IN        
 *            Enables (1) or disables (0) the auto ranging feature.
 * 
 *      MIN = VI_TRUE   1
 * 
 * PARAM 3 : ViReal64 range
 * IN        
 *            If auto ranging is enabled (resRangAuto = 1), then this
 *           parameter is ignored. If auto ranging is disabled (resRangAuto =
 *           0), the mulitmeter is set to the nearest range greater than or
 *           equal to the value specified.  The possible range settings on
 *           the voltmeter are defined in macros as shown below.
 * 
 *      MAX = hpe1411_RES_RANG_MAX   1048576.0
 *      MIN = hpe1411_RES_RANG_MIN   0.0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resRang(ViSession vi,
  ViBoolean autoRange,
  ViReal64 range)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resRang" );

    hpe1411_CHK_BOOLEAN(autoRange,VI_ERROR_PARAMETER2);

    hpe1411_CHK_REAL_RANGE(range
                          ,hpe1411_RES_RANG_MIN
                          ,hpe1411_RES_RANG_MAX
                          ,VI_ERROR_PARAMETER3);

        if (thisPtr->e1406)
        {
            /* if AUTO range, then ignore the range parameter */
            if (autoRange) 	/* is AUTO RANGE */
            {
               errStatus = viPrintf(vi,"RES:RANG:AUTO ON\n" );
            }
            else
            {
    	/* if not auto range, then sending range will turn AUTO OFF */
                errStatus = viPrintf(vi,"RES:RANG %lg\n", range );
            }
            if (errStatus < VI_SUCCESS)
                hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
        }
        else
        {
            /* if AUTO range, then ignore the range parameter;
    	 * else send a range, which will turn AUTO OFF
            */
            if (autoRange)
                {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8328 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8328 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_BOOLEAN*)in_.p1= 1;
/*#line 8328 "hpe1411.cs"*/
{extern vm_rang_auto();instr_send(vi,vm_rang_auto,&in_);}}}
            else
                {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8330 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8330 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=((float)range );
/*#line 8330 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 8330 "hpe1411.cs"*/
{extern vm_range();instr_send(vi,vm_range,&in_);}}}
        }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resRang_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of resistance range
 *           and the auto ranging setting.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean autoRange
 * OUT       
 *            Returns the current setting: enabled (1) or disabled (0) of the
 *           auto ranging feature.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * PARAM 3 : ViPReal64 range
 * OUT       
 *            Returns the resistance range setting.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resRang_Q(ViSession vi,
  ViPBoolean autoRange,
  ViPReal64 range)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resRang_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"RES:RANG:AUTO?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",autoRange);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viPrintf(vi,"RES:RANG?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",range);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 8415 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8415 "hpe1411.cs"*/
{extern vm_rrang_auto_q();if (!instr_query(vi,vm_rrang_auto_q,&in_,&out_)){
/*#line 8415 "hpe1411.cs"*/
*autoRange=*(HPSL_BOOLEAN*)out_.p1;}}}}
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 8416 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8416 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 8416 "hpe1411.cs"*/
{extern vm_rrange_q();if (!instr_query(vi,vm_rrange_q,&in_,&out_)){
/*#line 8416 "hpe1411.cs"*/
*range=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resRes
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the resolution for resistance measurements.  The
 *           minimum value of resolution is a function of range, so not all
 *           ranges can do all of the resolutions listed above.  For a more
 *           consistant method of specifying resolution, use the resNplc or
 *           resAper functions to specify resolution in terms of integration
 *           or aperture time.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 resRes
 * IN        
 *            Specifies the resolution for resistance measurements.  Note
 *           that resolution is is really determined by aperture or NPLC
 *           settings, and so the minimum aperture on A GIVEN RANGE
 *           determines the resolution; thus 61 microOhms of resolution is
 *           only possible on the lowest range, and if selected on a higher
 *           range will result in an error from the instrument.  See below for the settings possible.
 *            Also, selecting a resolution changes the aperture and NPLC
 *           settings, see the table below for the interactions of Range,
 *           Resolution, Aperture, and NPLCs.
 *           
 *                   -----------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)       |
 *                   | Aperture for 60 Hz power                           |
 *           -------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125  |  0.005   | .0005 PLC |
 *            Ohms   |  267ms  | 16.7ms  |  2.5ms  |  100us   |  10us     |
 *           -------------------------------------------------------------
 *               256 |   61e-6 | 244e-6  |  976e-6 | 7.812e-3 | 15.625e-3 |
 *              2048 |  488e-6 | 1.95e-3 | 7.812e-3|  62.5e-3 |    125e-3 |
 *             16384 |  3.9e-3 | 15.63e-3| 62.5e-3 |   0.5    |    1.0    |
 *            131072 | 31.2e-3 | 125e-3  |  0.5    |   4.0    |    8.0    |
 *           1048576 |  250e-3 |   1.0   |  4.0    |  32.0    |   64.0    |
 *           -------------------------------------------------------------
 *                   |                Resolution in Ohms                  |
 *                    ----------------------------------------------------
 * 
 *      MAX = hpe1411_RES_RES_MAX   64.0
 *      MIN = hpe1411_RES_RES_MIN   61.0e-6
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resRes(ViSession vi,
  ViReal64 resRes)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resRes" );

    hpe1411_CHK_REAL_RANGE(resRes
                          ,hpe1411_RES_RES_MIN
                          ,hpe1411_RES_RES_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"RES:RES %g\n",resRes);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8512 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8512 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(resRes);
/*#line 8512 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 8512 "hpe1411.cs"*/
{extern vm_res();instr_send(vi,vm_res,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_resRes_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of resolution.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 resRes
 * OUT       
 *            The returned value is the current resolution setting.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_resRes_Q(ViSession vi,
  ViPReal64 resRes)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_resRes_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"RES:RES?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",resRes);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 8577 "hpe1411.cs"*/
in_.sub1= 2;
/*#line 8577 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 8577 "hpe1411.cs"*/
{extern vm_rres_q();if (!instr_query(vi,vm_rres_q,&in_,&out_)){
/*#line 8577 "hpe1411.cs"*/
*resRes=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_routFunc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This selects the operational mode of the specified E1460, E8460,
 *           or E8462 switch card.  Note: Not all modes are available for each
 *           card.  For this command to work, the voltmeter must have been
 *           opened such that the switch card is part of the voltmeter
 *           virtual instrument.  See the instrument help and the
 *           hpe1411_init routine for more information regarding opening the
 *           voltmeter with switches.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument..
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            This parameter is an integer which represents which of the
 *           switch cards connected to the voltmeter will have its function
 *           changed.
 * 
 *      MAX = hpe1411_SWITCH_CARD_MAX   99
 *      MIN = hpe1411_SWITCH_CARD_MIN   1
 * 
 * PARAM 3 : ViInt16 mode
 * IN        
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_routFunc_mode_a[] = {"WIRE1","WIRE2",
        "WIRE2X64","WIRE3","WIRE4","WIRE1X2","WIRE1X4","WIRE1X8",
        "WIRE2X2","WIRE2X4","WIRE2X8","WIRE4X2","WIRE4X4","NONE",0};
ViStatus _VI_FUNC hpe1411_routFunc(ViSession vi,
  ViInt16 card,
  ViInt16 mode)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_routFunc" );

    hpe1411_CHK_INT_RANGE(card
                         ,hpe1411_SWITCH_CARD_MIN
                         ,hpe1411_SWITCH_CARD_MAX
                         ,VI_ERROR_PARAMETER2);

    hpe1411_CHK_ENUM(mode,13,VI_ERROR_PARAMETER3);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"ROUT:FUNC %hd,%s\n",card,hpe1411_routFunc_mode_a[mode]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 8660 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_WIRE1WIRE217[];char f_=0;
/*#line 8660 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
/*#line 8660 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 8660 "hpe1411.cs"*/
in_.p2_type= 2;*(HPSL_ENUM*)in_.p2=char_to_enum(E1326_enum_WIRE1WIRE217,hpe1411_routFunc_mode_a[mode],vi, &f_);
/*#line 8660 "hpe1411.cs"*/
if (!f_) {extern vm_sw_func();instr_send(vi,vm_sw_func,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_routFunc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current mode of the E1460, E8460 or
 *           E8462 switch at the card location specified.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            This parameter is an integer which represents which of the
 *           switch cards connected to the voltmeter will have its function
 *           queried.
 * 
 *      MAX = hpe1411_SWITCH_CARD_MAX   99
 *      MIN = hpe1411_SWITCH_CARD_MIN   1
 * 
 * PARAM 3 : ViPInt16 mode
 * OUT       
 *            The current mode setting of the selected switch card is
 *           returned as an integer representing a setting.  The values
 *           returned are defined as macros shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_routFunc_Q_mode_a[] = {"WIRE1","WIRE2",
        "WIRE2X64","WIRE3","WIRE4","WIRE1X2","WIRE1X4","WIRE1X8",
        "WIRE2X2","WIRE2X4","WIRE2X8","WIRE4X2","WIRE4X4","NONE",0};
ViStatus _VI_FUNC hpe1411_routFunc_Q(ViSession vi,
  ViInt16 card,
  ViPInt16 mode)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    char mode_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_routFunc_Q" );

    hpe1411_CHK_INT_RANGE(card
                         ,hpe1411_SWITCH_CARD_MIN
                         ,hpe1411_SWITCH_CARD_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"ROUT:FUNC? %hd\n",card);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%s%*t",mode_str);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 8747 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_WIRE1WIRE217[];
/*#line 8747 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
/*#line 8747 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 8747 "hpe1411.cs"*/
{extern vm_sw_func_q();if (!instr_query(vi,vm_sw_func_q,&in_,&out_)){
/*#line 8747 "hpe1411.cs"*/
enum_to_char(mode_str, E1326_enum_WIRE1WIRE217, *(HPSL_ENUM*)out_.p1);}}}}
    }
    errStatus = hpe1411_findIndex(thisPtr,hpe1411_routFunc_Q_mode_a,
        mode_str, mode);
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }

    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sampCoun
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Specifies the number of readings per trigger.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 sampCoun
 * IN        
 *            Sets the number of readings per trigger.  The allowable range
 *           is as follows.
 * 
 *      MAX = hpe1411_SAMP_COUN_MAX   16777215
 *      MIN = hpe1411_SAMP_COUN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_sampCoun(ViSession vi,
  ViInt32 sampCoun)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sampCoun" );

    hpe1411_CHK_LONG_RANGE(sampCoun
                          ,hpe1411_SAMP_COUN_MIN
                          ,hpe1411_SAMP_COUN_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"SAMP:COUN %ld\n",sampCoun);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8822 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(sampCoun);
/*#line 8822 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 8822 "hpe1411.cs"*/
{extern vm_samp_count();instr_send(vi,vm_samp_count,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sampCoun_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of sample count.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt32 sampCoun
 * OUT       
 *            Returns the latest number of readings per trigger (values
 *           between 1 and 16777215).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_sampCoun_Q(ViSession vi,
  ViPInt32 sampCoun)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sampCoun_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SAMP:COUN?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%ld%*t",sampCoun);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 8888 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 8888 "hpe1411.cs"*/
{extern vm_samp_count_q();if (!instr_query(vi,vm_samp_count_q,&in_,&out_)){
/*#line 8888 "hpe1411.cs"*/
*sampCoun=(*(HPSL_INT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sampSour
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the pacing source for the sample rate when the sample
 *           count is greater than 1.  If immediate is specified, samples
 *           will occur as soon as possilble.  If timer is specified, then a
 *           period of time will occur between each reading.  This period of
 *           time is specified by the hpe1411_sampTim function.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 sampSour
 * IN        
 *            Selects the pacing source to be either immediate or timer.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_sampSour_sampSour_a[] = {"IMM","TIM",0};
ViStatus _VI_FUNC hpe1411_sampSour(ViSession vi,
  ViInt16 sampSour)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sampSour" );

    hpe1411_CHK_ENUM(sampSour,1,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"SAMP:SOUR %s\n",hpe1411_sampSour_sampSour_a[sampSour]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 8953 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_IMMTIM02[];char f_=0;
/*#line 8953 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_IMMTIM02,hpe1411_sampSour_sampSour_a[sampSour],vi, &f_);
/*#line 8953 "hpe1411.cs"*/
if (!f_) {extern vm_samp_sour();instr_send(vi,vm_samp_sour,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sampSour_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the present setting of the sample source.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 sampSour
 * OUT       
 *            Returns the presently set sample source.  This will be one of
 *           the following values.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_sampSour_Q_sampSour_a[] = {"IMM","TIM",0};
ViStatus _VI_FUNC hpe1411_sampSour_Q(ViSession vi,
  ViPInt16 sampSour)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    char sampSour_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sampSour_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SAMP:SOUR?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%s%*t",sampSour_str);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 9021 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_IMMTIM02[];
/*#line 9021 "hpe1411.cs"*/
{extern vm_samp_sour_q();if (!instr_query(vi,vm_samp_sour_q,(void*)0,&out_)){
/*#line 9021 "hpe1411.cs"*/
enum_to_char(sampSour_str, E1326_enum_IMMTIM02, *(HPSL_ENUM*)out_.p1);}}}}
    }
    errStatus = hpe1411_findIndex(thisPtr,hpe1411_sampSour_Q_sampSour_a,
        sampSour_str, sampSour);
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }

    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sampTim
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects period (in seconds) between samples when sample count
 *           is > 1 and the sample source is set to TIMer.  If the sample
 *           source is not TIM, this value is accepted but not used.  The
 *           resolution on sample timer is 1.0e-6 seconds.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 sampTim
 * IN        
 *            Sets the period between readings in a burst of readings.
 * 
 *      MAX = hpe1411_SAMP_TIM_MAX   65.534e-3
 *      MIN = hpe1411_SAMP_TIM_MIN   76.0e-6
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_sampTim(ViSession vi,
  ViReal64 sampTim)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sampTim" );

    hpe1411_CHK_REAL_RANGE(sampTim
                          ,hpe1411_SAMP_TIM_MIN
                          ,hpe1411_SAMP_TIM_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"SAMP:TIM %g\n",sampTim);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 9098 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(sampTim);
/*#line 9098 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 9098 "hpe1411.cs"*/
{extern vm_samp_timer();instr_send(vi,vm_samp_timer,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sampTim_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of sample timer.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 sampTim
 * OUT       
 *            Returns the current sample timer value.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_sampTim_Q(ViSession vi,
  ViPReal64 sampTim)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sampTim_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SAMP:TIM?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",sampTim);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 9163 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 9163 "hpe1411.cs"*/
{extern vm_samp_timer_q();if (!instr_query(vi,vm_samp_timer_q,&in_,&out_)){
/*#line 9163 "hpe1411.cs"*/
*sampTim=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sample
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets up the sample parameters on the voltmeter in
 *           a single function call.  Note that each of the sample settings
 *           in this call may also be set individually by the function of a
 *           similar name as the parameter (i.e. sample source can also be
 *           set by function hpe1411_sampSour() ).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 count
 * IN        
 *            Specifies the number of samples that will be taken with each
 *           trigger event. Normally, the voltmeter only has enough memory to
 *           store 4096 readings.  This limits the trigger count * sample
 *           count to be <= 4096.  If you require more readings than this,
 *           see the hpe1411_read_Q function for a way to get data directly
 *           from the voltmeter without storing the data into memory first.
 * 
 *      MAX = hpe1411_SAMP_COUN_MAX   16777215
 *      MIN = hpe1411_SAMP_COUN_MIN   1
 * 
 * PARAM 3 : ViInt16 source
 * IN        
 *            Selects the sample source to be either 0 (IMMediate) or 1
 *           (TIMer).  Source TIM(er) causes the voltmeter to wait for a
 *           period defined by the hpe1411_sampTim() function between each
 *           sample if sample count is greater than 1.  Source IMMediate will
 *           cause samples to occur as soon as the voltmeter is ready to
 *           sample.  Macros are defined for these two settings as shown below.
 * 
 * PARAM 4 : ViReal64 period
 * IN        
 *            Selects period (in seconds) between samples when sample count
 *           is > 1 and the sample source is set to TIMer.  If the sample
 *           source is not TIM, this value is accepted but not used.
 *           
 *            Note that the sample timer period must be longer than the
 *           current setting of aperture (hpe1411_resAper,
 *           hpe1411_voltAcAper, or hpe1411_voltDcAper).  See the
 *           hpe1411_sampTim function description for information on what the
 *           allowable values are.
 *            Also note that the TIMer period does not occur between the
 *           trigger and the first sample, use the hpe1411_trigDel() function
 *           to add delay at that point.  The minimum and maximum allowable
 *           settings are defined as macros, shown below.
 * 
 *      MAX = hpe1411_SAMP_TIM_MAX   65.534e-3
 *      MIN = hpe1411_SAMP_TIM_MIN   76.0e-6
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_sample_source_a[] = {"IMM","TIM",0};
ViStatus _VI_FUNC hpe1411_sample(ViSession vi,
  ViInt32 count,
  ViInt16 source,
  ViReal64 period)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sample" );

    hpe1411_CHK_LONG_RANGE(count
                          ,hpe1411_SAMP_COUN_MIN
                          ,hpe1411_SAMP_COUN_MAX
                          ,VI_ERROR_PARAMETER2);

    hpe1411_CHK_ENUM(source,1,VI_ERROR_PARAMETER3);

    if(source) { /* check correct range if TIMER */
      hpe1411_CHK_REAL_RANGE(period
                          ,hpe1411_SAMP_TIM_MIN
                          ,hpe1411_SAMP_TIM_MAX
                          ,VI_ERROR_PARAMETER4);
    }

    if( (period< hpe1411_SAMP_TIM_MIN) || (period > hpe1411_SAMP_TIM_MAX ))
    {
      if (thisPtr->e1406)
      {
        errStatus = viPrintf(vi,"SAMP:COUN %ld;SOUR %s\n",
                 count, hpe1411_sample_source_a[source] );
    
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
      }
      else
      {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 9284 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(
                 count);
/*#line 9284 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 9284 "hpe1411.cs"*/
{extern vm_samp_count();instr_send(vi,vm_samp_count,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 9284 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_IMMTIM02[];char f_=0;
/*#line 9284 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_IMMTIM02,hpe1411_sample_source_a[source] ,vi, &f_);
/*#line 9284 "hpe1411.cs"*/
if (!f_) {extern vm_samp_sour();instr_send(vi,vm_samp_sour,&in_);}}}
      }
    }
    else {
      if (thisPtr->e1406)
      {
        errStatus = viPrintf(vi,"SAMP:COUN %ld;SOUR %s;TIM %lg\n",
                 count, hpe1411_sample_source_a[source], period );
    
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
      }
      else
      {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 9301 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(
                 count);
/*#line 9301 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 9301 "hpe1411.cs"*/
{extern vm_samp_count();instr_send(vi,vm_samp_count,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 9301 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_IMMTIM02[];char f_=0;
/*#line 9301 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_IMMTIM02,hpe1411_sample_source_a[source],vi, &f_);
/*#line 9301 "hpe1411.cs"*/
if (!f_) {extern vm_samp_sour();instr_send(vi,vm_samp_sour,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 9301 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=((float)period );
/*#line 9301 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 9301 "hpe1411.cs"*/
{extern vm_samp_timer();instr_send(vi,vm_samp_timer,&in_);}}}
      }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_sample_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine returns all of the settings related to sampling on
 *           the voltmeter.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt32 count
 * OUT       
 *            Returns the number of samples that will be taken with each
 *           trigger event.
 * 
 * PARAM 3 : ViPInt16 source
 * OUT       
 *            Returns the currently selected sample source represented as an
 *           integer as follows.
 * 
 * PARAM 4 : ViPReal64 period
 * OUT       
 *            Returns the period (in seconds) between samples. This period is
 *           only used if sample source is TIMer.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_sample_Q_source_a[] = {"IMM","TIM",0};
ViStatus _VI_FUNC hpe1411_sample_Q(ViSession vi,
  ViPInt32 count,
  ViPInt16 source,
  ViPReal64 period)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    //char source_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_sample_Q" );

    {
    char source_str[32];
    
    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SAMP:COUN? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%ld%*t", count);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        errStatus = viPrintf(vi,"SAMP:TIM? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t", period);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        errStatus = viPrintf(vi,"SAMP:SOUR? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%s%*t", source_str);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 9409 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 9409 "hpe1411.cs"*/
{extern vm_samp_count_q();if (!instr_query(vi,vm_samp_count_q,&in_,&out_)){
/*#line 9409 "hpe1411.cs"*/
*count=(*(HPSL_INT32*)out_.p1).num;}}}}
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 9410 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 9410 "hpe1411.cs"*/
{extern vm_samp_timer_q();if (!instr_query(vi,vm_samp_timer_q,&in_,&out_)){
/*#line 9410 "hpe1411.cs"*/
*period=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
        {{ struct {double p1[1];} out_;
/*#line 9411 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_IMMTIM02[];
/*#line 9411 "hpe1411.cs"*/
{extern vm_samp_sour_q();if (!instr_query(vi,vm_samp_sour_q,(void*)0,&out_)){
/*#line 9411 "hpe1411.cs"*/
enum_to_char(source_str, E1326_enum_IMMTIM02, *(HPSL_ENUM*)out_.p1);}}}}
    }
    
    errStatus = hpe1411_findIndex(thisPtr,hpe1411_sample_source_a,
            source_str, source);
    if (errStatus < VI_SUCCESS)
        hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strGfacList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets the gage factor for each channel in the list.
 *            The gage factor is used by the voltmeter to calculate the
 *           strain value on a channel.
 *            This setting must be done once after the instrument is powered
 *           on and before any strain measurements are taken on a channel. 
 *           Failure to do so will result in inaccurate data.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 gageFactor
 * IN        
 *            The gage factor to use for the strain measurement.
 * 
 *      MAX = hpe1411_GFAC_MAX   1.0e3
 *      MIN = hpe1411_GFAC_MIN   1.0e-9
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The channels that will be set to the new gageFactor setting.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strGfacList(ViSession vi,
  ViReal64 gageFactor,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strGfacList" );

    hpe1411_CHK_REAL_RANGE(gageFactor
                          ,hpe1411_GFAC_MIN
                          ,hpe1411_GFAC_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"STR:GFAC %lg,(@%s)\n", gageFactor, channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+45);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:GFAC %lg,(@", gageFactor);
        strcat(cmd, channelList);
        strcat(cmd, ")");
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strGfacList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the present gage factor setting on the
 *           specified channels.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 respArrayLen
 * IN        
 *            The size of the array to hold the gage factors returned.
 * 
 *      MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
 *      MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
 * 
 * PARAM 3 : ViReal64 _VI_FAR factors[]
 * OUT       
 *            The gage factor(s) for the channel(s) specifed are returned in
 *           this parameter.
 * 
 * PARAM 4 : ViString channelList
 * IN        
 *            The channels that will be queried for their gage factor
 *           settings.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strGfacList_Q(ViSession vi,
  ViInt16 respArrayLen,
  ViReal64 _VI_FAR factors[],
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strGfacList_Q" );

    hpe1411_CHK_INT_RANGE(respArrayLen
                         ,hpe1411_RESP_ARRAY_LEN_MIN
                         ,hpe1411_RESP_ARRAY_LEN_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        ViInt16 i;
        char separator;
    
        thisPtr->blockSrqIO = VI_TRUE;
    
        errStatus = viPrintf(vi,"STR:GFAC? (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* get readings, note they will be separated by , if more than 1 */
        for (i=0; i<respArrayLen; i++)
        {
           errStatus = viScanf(vi, "%lg%c", &factors[i], &separator);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
        
           /* if not comma, must be last reading */
           if (separator != ',')
           {
        
            /* get rid of any left over stuff */
              errStatus = viFlush(vi, VI_READ_BUF_DISCARD);
              if (errStatus < VI_SUCCESS)
              {
                 hpe1411_CDE_MESSAGE( "Error flushing buffer" );
                 hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
              }
    	  break;	/* get out of for loop, no more readings */
           }
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+30);
        long old_error;
        size_t resultLen;
        char *resultStr;
        char *comma;
        char *next;
        ViInt16 i;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:GFAC? (@");
        strcat(cmd, channelList);
        strcat(cmd, ")");
        old_error = instr_error_head(vi);
    
        /* 14 chars per number + comma + LF + NULL */
        resultLen = respArrayLen*14 + respArrayLen + 2;
        resultStr = malloc(resultLen);
    
        cscpi_exe(vi, cmd, strlen(cmd), resultStr, resultLen);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER4);
        }
        
        next = resultStr;
        comma = strchr(resultStr,',');
        i=0;
        while (comma != NULL)
        {
            comma++;
    	factors[i++] = atof(next);
            next = comma;
            comma = strchr(next,',');
        }
    
        /* convert last, or possibly the only number */
        factors[i] = atof(next);
        free(resultStr);
    	
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strPoisList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets the Poisson ratio for each channel specified
 *           in the list. The Poisson ratio is used by the voltmeter whenever
 *           Poisson measurements are made on that channel.
 *           
 *            This setting must be done once after the instrument is powered
 *           on and before any Poisson measurements are taken on a channel. 
 *           Failure to do so will result in inaccurate data.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 poisson
 * IN        
 *            The poisson ratio to use when measuring poisson configurations.
 * 
 *      MAX = hpe1411_POIS_MAX   2.0
 *      MIN = hpe1411_POIS_MIN   1.0e-4
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The channel(s) to receive the poisson ratio setting specified.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strPoisList(ViSession vi,
  ViReal64 poisson,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strPoisList" );

    hpe1411_CHK_REAL_RANGE(poisson
                          ,hpe1411_POIS_MIN
                          ,hpe1411_POIS_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"STR:POIS %lg,(@%s)\n", poisson, channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+40);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:POIS %lg,(@%s)", poisson, channelList);
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strPoisList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the present Poisson ratio setting on the
 *           specified channels.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 respArrayLen
 * IN        
 *            The size of the array to hold the Poisson ratios returned.
 * 
 *      MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
 *      MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
 * 
 * PARAM 3 : ViReal64 _VI_FAR ratios[]
 * OUT       
 *            The Poisson ratio(s) for the channel(s) specifed are returned
 *           in this parameter.
 * 
 * PARAM 4 : ViString channelList
 * IN        
 *            The channels that will be queried for their Poisson ratio
 *           settings.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strPoisList_Q(ViSession vi,
  ViInt16 respArrayLen,
  ViReal64 _VI_FAR ratios[],
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strPoisList_Q" );

    hpe1411_CHK_INT_RANGE(respArrayLen
                         ,hpe1411_RESP_ARRAY_LEN_MIN
                         ,hpe1411_RESP_ARRAY_LEN_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        ViInt16 i;
        char separator;
    
        thisPtr->blockSrqIO = VI_TRUE;
    
        errStatus = viPrintf(vi,"STR:POIS? (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* get readings, note they will be separated by , if more than 1 */
        for (i=0; i<respArrayLen; i++)
        {
           errStatus = viScanf(vi, "%lg%c", &ratios[i], &separator);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
        
           /* if not comma, must be last reading */
           if (separator != ',')
           {
        
            /* get rid of any left over stuff */
              errStatus = viFlush(vi, VI_READ_BUF_DISCARD);
              if (errStatus < VI_SUCCESS)
              {
                 hpe1411_CDE_MESSAGE( "Error flushing buffer" );
                 hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
              }
    	  break;	/* get out of for loop, no more readings */
           }
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+30);
        long old_error;
        size_t resultLen;
        char *resultStr;
        char *comma;
        char *next;
        ViInt16 i;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:POIS? (@%s)", channelList);
        old_error = instr_error_head(vi);
    
        /* 14 chars per number + comma + LF + NULL */
        resultLen = respArrayLen*14 + respArrayLen + 2;
        resultStr = malloc(resultLen);
    
        cscpi_exe(vi, cmd, strlen(cmd), resultStr, resultLen);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER4);
        }
        
        next = resultStr;
        comma = strchr(resultStr,',');
        i=0;
        while (comma != NULL)
        {
            comma++;
    	ratios[i++] = atof(next);
            next = comma;
            comma = strchr(next,',');
        }
    
        /* convert last, or possibly the only number */
        ratios[i] = atof(next);
        free(resultStr);
    	
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strUnstList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets the unstrained reference voltage for each
 *           channel specified in the list.  The unstrained reference value
 *           is used by the voltmeter to calculate strain on a given channel.
 *           
 *            This command is used when it is desirable to download data from
 *           a pre-stored table of unstrained references to each channel. 
 *           This would normally be done when the channel(s) are currently
 *           under some strain and it is not desirable to unload them to get
 *           an unstrained measurement via the hpe1411_calStr function.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 reference
 * IN        
 *            The unstrained reference voltage value.
 * 
 *      MAX = hpe1411_UNST_REF_MAX   300.0
 *      MIN = hpe1411_UNST_REF_MIN   -300.0
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The channel(s) to receive the unstrained reference value
 *           specified.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strUnstList(ViSession vi,
  ViReal64 reference,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strUnstList" );

    hpe1411_CHK_REAL_RANGE(reference
                          ,hpe1411_UNST_REF_MIN
                          ,hpe1411_UNST_REF_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"STR:UNST %lg,(@%s)\n", reference, channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+40);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:UNST %lg,(@%s)", reference, channelList);
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strUnstList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the present unstrained reference voltage
 *           setting on the specified channels.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 respArrayLen
 * IN        
 *            The size of the array to hold the unstrained reference voltage
 *           values returned.
 * 
 *      MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
 *      MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
 * 
 * PARAM 3 : ViReal64 _VI_FAR reference[]
 * OUT       
 *            The unstrained reference voltage setting(s) for the channel(s)
 *           specifed are returned in this parameter.
 * 
 * PARAM 4 : ViString channelList
 * IN        
 *            The channels that will be queried for their unstrained
 *           reference voltage settings.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strUnstList_Q(ViSession vi,
  ViInt16 respArrayLen,
  ViReal64 _VI_FAR reference[],
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strUnstList_Q" );

    hpe1411_CHK_INT_RANGE(respArrayLen
                         ,hpe1411_RESP_ARRAY_LEN_MIN
                         ,hpe1411_RESP_ARRAY_LEN_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        ViInt16 i;
        char separator;
    
        thisPtr->blockSrqIO = VI_TRUE;
    
        errStatus = viPrintf(vi,"STR:UNST? (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* get readings, note they will be separated by , if more than 1 */
        for (i=0; i<respArrayLen; i++)
        {
           errStatus = viScanf(vi, "%lg%c", &reference[i], &separator);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
        
           /* if not comma, must be last reading */
           if (separator != ',')
           {
        
            /* get rid of any left over stuff */
              errStatus = viFlush(vi, VI_READ_BUF_DISCARD);
              if (errStatus < VI_SUCCESS)
              {
                 hpe1411_CDE_MESSAGE( "Error flushing buffer" );
                 hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
              }
    	  break;	/* get out of for loop, no more readings */
           }
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+30);
        long old_error;
        size_t resultLen;
        char *resultStr;
        char *comma;
        char *next;
        ViInt16 i;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:UNST? (@%s)", channelList);
        old_error = instr_error_head(vi);
    
        /* 14 chars per number + comma + LF + NULL */
        resultLen = respArrayLen*14 + respArrayLen + 2;
        resultStr = malloc(resultLen);
    
        cscpi_exe(vi, cmd, strlen(cmd), resultStr, resultLen);
        free(cmd);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER4);
        }
        
        next = resultStr;
        comma = strchr(resultStr,',');
        i=0;
        while (comma != NULL)
        {
            comma++;
    	reference[i++] = atof(next);
            next = comma;
            comma = strchr(next,',');
        }
    
        /* convert last, or possibly the only number */
        reference[i] = atof(next);
        free(resultStr);
    	
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strainConst_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the present settings of gage factor,
 *           unstrained reference voltage, and Poisson ratio on the specified
 *           channels.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 respArrayLen
 * IN        
 *            The size of the arrays to hold the gage factors, unstrained
 *           references and poisson ratios returned.
 * 
 *      MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
 *      MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
 * 
 * PARAM 3 : ViReal64 _VI_FAR gageFact[]
 * OUT       
 *            The gage factor(s) for the channel(s) specifed are returned in
 *           this parameter.
 * 
 * PARAM 4 : ViReal64 _VI_FAR poissonRatio[]
 * OUT       
 *            The Poisson ratio(s) for the channel(s) specifed are returned
 *           in this parameter.
 * 
 * PARAM 5 : ViReal64 _VI_FAR refVolt[]
 * OUT       
 *            The unstrained reference voltage(s) for the channel(s) specifed
 *           are returned in this parameter.
 * 
 * PARAM 6 : ViString channelList
 * IN        
 *            The channels that will be queried for their strain parameters.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strainConst_Q(ViSession vi,
  ViInt16 respArrayLen,
  ViReal64 _VI_FAR gageFact[],
  ViReal64 _VI_FAR poissonRatio[],
  ViReal64 _VI_FAR refVolt[],
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strainConst_Q" );

    hpe1411_CHK_INT_RANGE(respArrayLen
                         ,hpe1411_RESP_ARRAY_LEN_MIN
                         ,hpe1411_RESP_ARRAY_LEN_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        ViInt16 i;
        char separator;
    
        thisPtr->blockSrqIO = VI_TRUE;
    
        errStatus = viPrintf(vi,"STR:GFAC? (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* get readings, note they will be separated by , if more than 1 */
        for (i=0; i<respArrayLen; i++)
        {
           errStatus = viScanf(vi, "%lg%c", &gageFact[i], &separator);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
        
           /* if not comma, must be last reading */
           if (separator != ',')
           {
        
            /* get rid of any left over stuff */
              errStatus = viFlush(vi, VI_READ_BUF_DISCARD);
              if (errStatus < VI_SUCCESS)
              {
                 hpe1411_CDE_MESSAGE( "Error flushing buffer" );
                 hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
              }
    	  break;	/* get out of for loop, no more readings */
           }
        }
    
        errStatus = viPrintf(vi,"STR:UNST? (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* get readings, note they will be separated by , if more than 1 */
        for (i=0; i<respArrayLen; i++)
        {
           errStatus = viScanf(vi, "%lg%c", &refVolt[i], &separator);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
        
           /* if not comma, must be last reading */
           if (separator != ',')
           {
        
            /* get rid of any left over stuff */
              errStatus = viFlush(vi, VI_READ_BUF_DISCARD);
              if (errStatus < VI_SUCCESS)
              {
                 hpe1411_CDE_MESSAGE( "Error flushing buffer" );
                 hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
              }
    	  break;	/* get out of for loop, no more readings */
           }
        }
    
        errStatus = viPrintf(vi,"STR:POIS? (@%s)\n", channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* get readings, note they will be separated by , if more than 1 */
        for (i=0; i<respArrayLen; i++)
        {
           errStatus = viScanf(vi, "%lg%c", &poissonRatio[i], &separator);
           if (errStatus < VI_SUCCESS)
           {
              hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
           }
        
           /* if not comma, must be last reading */
           if (separator != ',')
           {
        
            /* get rid of any left over stuff */
              errStatus = viFlush(vi, VI_READ_BUF_DISCARD);
              if (errStatus < VI_SUCCESS)
              {
                 hpe1411_CDE_MESSAGE( "Error flushing buffer" );
                 hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
              }
    	  break;	/* get out of for loop, no more readings */
           }
        }
    
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+30);
        long old_error;
        size_t resultLen;
        char *resultStr;
        char *comma;
        char *next;
        ViInt16 i;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:GFAC? (@");
        strcat(cmd, channelList);
        strcat(cmd, ")");
        old_error = instr_error_head(vi);
    
        /* 14 chars per number + comma + LF + NULL */
        resultLen = respArrayLen*14 + respArrayLen + 2;
        resultStr = malloc(resultLen);
    
        cscpi_exe(vi, cmd, strlen(cmd), resultStr, resultLen);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER4);
        }
        
        next = resultStr;
        comma = strchr(resultStr,',');
        i=0;
        while (comma != NULL)
        {
            comma++;
    	gageFact[i++] = atof(next);
            next = comma;
            comma = strchr(next,',');
        }
    
        /* convert last, or possibly the only number */
        gageFact[i] = atof(next);
    	
        /* now get the unstrained reference voltages */
        sprintf(cmd, "STR:UNST? (@");
        strcat(cmd, channelList);
        strcat(cmd, ")");
    
        cscpi_exe(vi, cmd, strlen(cmd), resultStr, resultLen);
        next = resultStr;
        comma = strchr(resultStr,',');
        i=0;
        while (comma != NULL)
        {
            comma++;
    	refVolt[i++] = atof(next);
            next = comma;
            comma = strchr(next,',');
        }
    
        /* convert last, or possibly the only number */
        refVolt[i] = atof(next);
    	
        /* now get the Poisson Ratios */
        sprintf(cmd, "STR:POIS? (@");
        strcat(cmd, channelList);
        strcat(cmd, ")");
    
        cscpi_exe(vi, cmd, strlen(cmd), resultStr, resultLen);
        free(cmd);
        
        next = resultStr;
        comma = strchr(resultStr,',');
        i=0;
        while (comma != NULL)
        {
            comma++;
    	poissonRatio[i++] = atof(next);
            next = comma;
            comma = strchr(next,',');
        }
    
        /* convert last, or possibly the only number */
        poissonRatio[i] = atof(next);
        free(resultStr);
    	
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_strainInitList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets the gage factor and measures the unstrained
 *           reference voltage for each channel in the list.  Before taking
 *           strain measurements, both of these constants need to be set.
 *           
 *            The gage factor and unstrained reference voltage are used by
 *           the voltmeter to calculate the strain value on a channel.
 *           
 *            This setting must be done once after the instrument is powered
 *           on and before any strain measurements are taken on a channel. 
 *           Failure to do so will result in inaccurate data.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 gageFactor
 * IN        
 *            The gage factor to use for the strain measurement.
 * 
 *      MAX = hpe1411_GFAC_MAX   1.0e3
 *      MIN = hpe1411_GFAC_MIN   1.0e-9
 * 
 * PARAM 3 : ViString channelList
 * IN        
 *            The channel(s) that will receive new constants.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_strainInitList(ViSession vi,
  ViReal64 gageFactor,
  ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_strainInitList" );

    hpe1411_CHK_REAL_RANGE(gageFactor
                          ,hpe1411_GFAC_MIN
                          ,hpe1411_GFAC_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"STR:GFAC %lg,(@%s);:CAL:STR (@%s)\n",
               gageFactor, channelList, channelList);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        char *cmd = malloc(strlen(channelList)+45);
        long old_error;
    
        if (!cmd)
        {
    	hpe1411_CDE_ERROR( VI_ERROR_ALLOC );
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
        }
    
        sprintf(cmd, "STR:GFAC %lg,(@", gageFactor);
        strcat(cmd, channelList);
        strcat(cmd, ")");
        old_error = instr_error_head(vi);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        if (old_error != instr_error_head(vi))
        { /* must have been bad channel list*/
    	hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER3);
        }
        sprintf(cmd, "CAL:STR (@%s)", channelList);
        cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
        free(cmd);
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_systCdes_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the selected card number for its model
 *           description.  The answer is a string such as "Dual 32 Channel
 *           2-Wire Relay Mux".
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            This parameter is an integer which represents which of the
 *           switch cards connected to the voltmeter will have its type
 *           queried.
 * 
 *      MAX = hpe1411_SWITCH_CARD_MAX   99
 *      MIN = hpe1411_SWITCH_CARD_MIN   1
 * 
 * PARAM 3 : ViChar _VI_FAR cardDesc[]
 * OUT       
 *            The model description of the specified switch card is returned
 *           in this string.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_systCdes_Q(ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR cardDesc[])
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_systCdes_Q" );

    hpe1411_CHK_INT_RANGE(card
                         ,hpe1411_SWITCH_CARD_MIN
                         ,hpe1411_SWITCH_CARD_MAX
                         ,VI_ERROR_PARAMETER2);

    *cardDesc = 0;
    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SYST:CDES? %hd\n",card);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",cardDesc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        if(cardDesc[0])
          cardDesc[strlen(cardDesc)-1] = 0;
        else {
            hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2 );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 10618 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
/*#line 10618 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 10618 "hpe1411.cs"*/
{extern vm_systcdes_q();if (!instr_query(vi,vm_systcdes_q,&in_,&out_)){
/*#line 10618 "hpe1411.cs"*/
(void)strcpy((cardDesc),*(HPSL_STRING*)out_.p1);}}}}
        if(!*cardDesc) {
            hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2 );
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_systCtyp_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the selected card number for its model
 *           type.  The answer is a string such as
 *           "HEWLETT-PACKARD,E1460A,0,A.02.00".  This string is of the
 *           format "manufacturer,model,serial number,firmware revision".
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            This parameter is an integer which represents which of the
 *           switch cards connected to the voltmeter will have its type
 *           queried.
 * 
 *      MAX = hpe1411_SWITCH_CARD_MAX   99
 *      MIN = hpe1411_SWITCH_CARD_MIN   1
 * 
 * PARAM 3 : ViChar _VI_FAR cardType[]
 * OUT       
 *            The model number description of the specified switch card is
 *           returned in this string.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_systCtyp_Q(ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR cardType[])
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_systCtyp_Q" );

    hpe1411_CHK_INT_RANGE(card
                         ,hpe1411_SWITCH_CARD_MIN
                         ,hpe1411_SWITCH_CARD_MAX
                         ,VI_ERROR_PARAMETER2);

    *cardType = 0;
    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SYST:CTYP? %hd\n",card);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",cardType);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        if(cardType[0])
          cardType[strlen(cardType)-1] = 0;
        else {
            hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2 );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 10711 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
/*#line 10711 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 10711 "hpe1411.cs"*/
{extern vm_systctyp_q();if (!instr_query(vi,vm_systctyp_q,&in_,&out_)){
/*#line 10711 "hpe1411.cs"*/
(void)memcpy((cardType),(*(HPSL_ARB_ASCII*)out_.p1).buffer,(*(HPSL_ARB_ASCII*)out_.p1).length);
/*#line 10711 "hpe1411.cs"*/
(cardType)[(*(HPSL_ARB_ASCII*)out_.p1).length]='\0';}}}}
        if(!*cardType) {
            hpe1411_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2 );
        }
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_systLfr
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine selects the line reference frequency used by the A
 *           to D converter. This function is provided for compatibility with
 *           other voltmeters which use the SYSTem:LFRequency command instead
 *           of CALibration:LFRequency command.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 systLfr
 * IN        
 *            Indicates the desired line reference frequency; the legal
 *           values are 50 or 60.
 * 
 *      MAX = hpe1411_SYST_LFR_MAX   60
 *      MIN = hpe1411_SYST_LFR_MIN   50
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_systLfr(ViSession vi,
  ViInt16 systLfr)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_systLfr" );

    hpe1411_CHK_INT_RANGE(systLfr
                         ,hpe1411_SYST_LFR_MIN
                         ,hpe1411_SYST_LFR_MAX
                         ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CAL:LFR %hd\n",systLfr);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 10785 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(systLfr);
/*#line 10785 "hpe1411.cs"*/
((HPSL_INT16*)in_.p1)->suffix=0;
/*#line 10785 "hpe1411.cs"*/
{extern vm_lfre();instr_send(vi,vm_lfre,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_systLfr_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of the reference line
 *           frequency. This function is provided for compatibility with
 *           other voltmeters which use the SYSTem:LFRequency? command
 *           instead of CALibration:LFRequency? command.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 systLfr
 * OUT       
 *            Returns the current setting of the reference line frequency;
 *           either 50 or 60 Hz.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_systLfr_Q(ViSession vi,
  ViPInt16 systLfr)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_systLfr_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CAL:LFR?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",systLfr);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 10854 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 10854 "hpe1411.cs"*/
{extern vm_lfre_q();if (!instr_query(vi,vm_lfre_q,&in_,&out_)){
/*#line 10854 "hpe1411.cs"*/
*systLfr=(*(HPSL_INT16*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_timedFetch_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine returns readings stored in memory from the last
 *           measurement operation.  The timeOut parameter allows a time out
 *           value to be used only during this function, with the original
 *           time out value being re-stored after the data is fetched.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 timeOut
 * IN        
 *            The value (in milli-seconds) to set the time out value to for
 *           the duration of this function.  When the function completes, the
 *           original time out value is re-stored.
 * 
 *      MAX = hpe1411_TIMEOUT_MAX   2147483647
 *      MIN = hpe1411_TIMEOUT_MIN   0
 * 
 * PARAM 3 : ViReal64 _VI_FAR readings[]
 * OUT       
 *            The array of double which will hold the readings.  Make sure it
 *           is large enough to hold all the data.
 * 
 * PARAM 4 : ViInt32 dataArrayLen
 * IN        
 *            Indicates the size of the array "readings".
 * 
 *      MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
 *      MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_timedFetch_Q(ViSession vi,
  ViInt32 timeOut,
  ViReal64 _VI_FAR readings[],
  ViInt32 dataArrayLen)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_timedFetch_Q" );

    hpe1411_CHK_LONG_RANGE(timeOut
                          ,hpe1411_TIMEOUT_MIN
                          ,hpe1411_TIMEOUT_MAX
                          ,VI_ERROR_PARAMETER2);

    hpe1411_CHK_LONG_RANGE(dataArrayLen
                          ,hpe1411_DATA_ARRAY_LEN_MIN
                          ,hpe1411_DATA_ARRAY_LEN_MAX
                          ,VI_ERROR_PARAMETER4);

    {  /* begin I/O code */
    ViInt32 saveTimeOut;
    
    errStatus = viGetAttribute(vi, VI_ATTR_TMO_VALUE, &saveTimeOut );
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }
        
    errStatus = viSetAttribute(vi, VI_ATTR_TMO_VALUE, timeOut);
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }
    
    if (thisPtr->e1406)
    {
        ViInt32 how_many;
    
        thisPtr->blockSrqIO = VI_TRUE;
        if (thisPtr->dirtyBit)
        {
    	errStatus = viPrintf(vi, "FORM REAL,64\n");
            if (errStatus < VI_SUCCESS)
            {
                /* re-store original timeOut value before exiting */
                viSetAttribute(vi, VI_ATTR_TMO_VALUE, saveTimeOut);
    
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
    	thisPtr->dirtyBit = 0;
        }
    
        errStatus = viPrintf(vi, "FETC?\n");
        if (errStatus < VI_SUCCESS)
        {
            /* re-store original timeOut value before exiting */
            viSetAttribute(vi, VI_ATTR_TMO_VALUE, saveTimeOut);
    
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        /* last parameter indicates to byte swap the readings */
    #ifdef B_ENDIAN
        errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 0); 
    #else
/*#line 10981 "hpe1411.cs"*/
        errStatus = hpe1411_scan64(vi, dataArrayLen, readings, &how_many, 1); 
    #endif
/*#line 10983 "hpe1411.cs"*/
        if (errStatus < VI_SUCCESS)
        {
            /* re-store original timeOut value before exiting */
            viSetAttribute(vi, VI_ATTR_TMO_VALUE, saveTimeOut);
    
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (thisPtr->dirtyBit)
        {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
/*#line 10995 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1= 1;
/*#line 10995 "hpe1411.cs"*/
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num= 64;
/*#line 10995 "hpe1411.cs"*/
((HPSL_INT16*)in_.p2)->suffix=0;
/*#line 10995 "hpe1411.cs"*/
{extern vm_format();instr_send(vi,vm_format,&in_);}}}
    	thisPtr->dirtyBit = 0;
        }
    
        /* INST_QUERY strips IEEE header and gets byte order correct */
        {{ struct {double p1[2];} out_;
/*#line 11000 "hpe1411.cs"*/
{extern vm_fetch_q();if (!instr_query(vi,vm_fetch_q,(void*)0,&out_)){
/*#line 11000 "hpe1411.cs"*/
if ((*(HPSL_GENERIC*)out_.p1).formatter)
/*#line 11000 "hpe1411.cs"*/
(*(*(HPSL_GENERIC*)out_.p1).formatter)(readings,&(*(HPSL_GENERIC*)out_.p1).length,(void*)0, instr_misc(vi));}}}}
    }
    
    /* re-store original timeOut value before exiting */
    viSetAttribute(vi, VI_ATTR_TMO_VALUE, saveTimeOut);
    
    }  /* end I/O code */
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigCoun
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Specifies the trigger count.  This is the number of "bursts" of
 *           samples that will be taken.  Normally, the voltmeter only has
 *           enough memory to store 4096 readings.  This limits the trigger
 *           count * number of samples to be <= 4096. If you require more
 *           readings than this, see the hpe1411_read_Q function for a way to
 *           get data directly from the voltmeter without storing the data
 *           into memory first.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 trigCoun
 * IN        
 *            Sets the number of triggers issued.
 * 
 *      MAX = hpe1411_TRIG_COUN_MAX   16777215
 *      MIN = hpe1411_TRIG_COUN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_trigCoun(ViSession vi,
  ViInt32 trigCoun)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigCoun" );

    hpe1411_CHK_LONG_RANGE(trigCoun
                          ,hpe1411_TRIG_COUN_MIN
                          ,hpe1411_TRIG_COUN_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"TRIG:COUN %ld\n",trigCoun);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11078 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(trigCoun);
/*#line 11078 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 11078 "hpe1411.cs"*/
{extern vm_trig_count();instr_send(vi,vm_trig_count,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigCoun_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of trigger count.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt32 trigCoun
 * OUT       
 *            Returns the number of trigger counts set.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_trigCoun_Q(ViSession vi,
  ViPInt32 trigCoun)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigCoun_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"TRIG:COUN?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%ld%*t",trigCoun);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 11143 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 11143 "hpe1411.cs"*/
{extern vm_trig_count_q();if (!instr_query(vi,vm_trig_count_q,&in_,&out_)){
/*#line 11143 "hpe1411.cs"*/
*trigCoun=(*(HPSL_INT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigDel
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets delay period between receipt of trigger and start of
 *           measurement.  One use of this would be to specify a longer delay
 *           to give a signal extra time to settle after a relay closure
 *           before measurement.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean autoDelay
 * IN        
 *            Enables (1) or disables (0) the auto delay feature.
 * 
 * PARAM 3 : ViReal64 delay
 * IN        
 *            Sets delay period between receipt of trigger and start of
 *           measurement.  This value is ignored and not used if the
 *           trigDelAuto parameter is enabled (1).
 * 
 *      MAX = hpe1411_TRIG_DEL_MAX   16.777215
 *      MIN = hpe1411_TRIG_DEL_MIN   0.0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_trigDel(ViSession vi,
  ViBoolean autoDelay,
  ViReal64 delay)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigDel" );

    hpe1411_CHK_BOOLEAN(autoDelay,VI_ERROR_PARAMETER2);

    hpe1411_CHK_REAL_RANGE(delay
                          ,hpe1411_TRIG_DEL_MIN
                          ,hpe1411_TRIG_DEL_MAX
                          ,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        /* if AUTO delay, then ignore the delay parameter */
        if (autoDelay) 	/* is AUTO RANGE */
        {
           errStatus = viPrintf(vi,"TRIG:DEL:AUTO ON\n" );
        }
        else
        {
    	/* if not auto delay, then sending delay will turn AUTO OFF */
            errStatus = viPrintf(vi,"TRIG:DEL %lg\n", delay );
        }
        if (errStatus < VI_SUCCESS)
            hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
    }
    else
    {
        /* if AUTO delay, then ignore the delay parameter;
    	 * else send a delay, which will turn AUTO OFF
        */
        if (autoDelay) 	/* is AUTO RANGE */
            {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11233 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_BOOLEAN*)in_.p1= 1;
/*#line 11233 "hpe1411.cs"*/
{extern vm_trig_del_a();instr_send(vi,vm_trig_del_a,&in_);}}}
        else
            {{ struct {short p1_type; char p1_type_pad[6]; double p1[2];} in_;
/*#line 11235 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT64*)in_.p1)->num=((float)delay );
/*#line 11235 "hpe1411.cs"*/
((HPSL_FLOAT64*)in_.p1)->suffix=0;
/*#line 11235 "hpe1411.cs"*/
{extern vm_trig_delay();instr_send(vi,vm_trig_delay,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigDel_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of trigger delay.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean autoDelay
 * OUT       
 *            Returns current setting of auto delay feature.
 * 
 * PARAM 3 : ViPReal64 delay
 * OUT       
 *            Returns current trigger delay period.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_trigDel_Q(ViSession vi,
  ViPBoolean autoDelay,
  ViPReal64 delay)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigDel_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"TRIG:DEL:AUTO?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",autoDelay);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viPrintf(vi,"TRIG:DEL?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",delay);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 11315 "hpe1411.cs"*/
{extern vm_trig_del_a_q();if (!instr_query(vi,vm_trig_del_a_q,(void*)0,&out_)){
/*#line 11315 "hpe1411.cs"*/
*autoDelay=*(HPSL_BOOLEAN*)out_.p1;}}}}
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[2];} out_;
/*#line 11316 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 11316 "hpe1411.cs"*/
{extern vm_trig_delay_q();if (!instr_query(vi,vm_trig_delay_q,&in_,&out_)){
/*#line 11316 "hpe1411.cs"*/
*delay=(*(HPSL_FLOAT64*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigImm
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Causes a trigger to occur immediately if the voltmeter is in
 *           the wait-for-trigger state.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_trigImm(ViSession vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigImm" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"TRIG\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ 
/*#line 11371 "hpe1411.cs"*/
{extern vm_trig_imm();instr_send(vi,vm_trig_imm,(void*)0);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigSour
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the trigger source to which the voltmeter is to
 *           respond.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 trigSour
 * IN        
 *            Selects the trigger source, as follows.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_trigSour_trigSour_a[] = {"BUS","EXT",
        "HOLD","IMM","TTLT0","TTLT1","TTLT2","TTLT3","TTLT4","TTLT5",
        "TTLT6","TTLT7",0};
ViStatus _VI_FUNC hpe1411_trigSour(ViSession vi,
  ViInt16 trigSour)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigSour" );

    hpe1411_CHK_ENUM(trigSour,11,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"TRIG:SOUR %s\n",hpe1411_trigSour_trigSour_a[trigSour]);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11435 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_BUSEXT20[];char f_=0;
/*#line 11435 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_BUSEXT20,hpe1411_trigSour_trigSour_a[trigSour],vi, &f_);
/*#line 11435 "hpe1411.cs"*/
if (!f_) {extern vm_trig_sour();instr_send(vi,vm_trig_sour,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigSour_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of the trigger source.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 trigSour
 * OUT       
 *            Returns an integer representing one of the following trigger
 *           sources.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_trigSour_Q_trigSour_a[] = {"BUS","EXT",
        "HOLD","IMM","TTLT0","TTLT1","TTLT2","TTLT3","TTLT4","TTLT5",
        "TTLT6","TTLT7",0};
ViStatus _VI_FUNC hpe1411_trigSour_Q(ViSession vi,
  ViPInt16 trigSour)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    char trigSour_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigSour_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"TRIG:SOUR?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%s%*t",trigSour_str);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
/*#line 11505 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_BUSEXT20[];
/*#line 11505 "hpe1411.cs"*/
{extern vm_trig_sour_q();if (!instr_query(vi,vm_trig_sour_q,(void*)0,&out_)){
/*#line 11505 "hpe1411.cs"*/
enum_to_char(trigSour_str, E1326_enum_BUSEXT20, *(HPSL_ENUM*)out_.p1);}}}}
    }
    errStatus = hpe1411_findIndex(thisPtr,hpe1411_trigSour_Q_trigSour_a,
        trigSour_str, trigSour);
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }

    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigger
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine sets up the trigger system with a single function
 *           call.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 count
 * IN        
 *            Specifies the trigger count.  This is the number of "bursts" of
 *           samples that will be taken.  Normally, the voltmeter only has
 *           enough memory to store 4096 readings.  This limits the trigger
 *           count * number of samples to be <= 4096. If you require more
 *           readings than this, see the hpe1411_read_Q function for a way to
 *           get data directly from the voltmeter without storing the data
 *           into memory first.  The min and max values of trigger count are
 *           defined as macros shown below.
 * 
 *      MAX = hpe1411_TRIG_COUN_MAX   16777215
 *      MIN = hpe1411_TRIG_COUN_MIN   1
 * 
 * PARAM 3 : ViBoolean autoDelay
 * IN        
 *            Enables (1) or disables (0) selection of an automatic trigger
 *           delay.  This is the time period from receipt of the trigger
 *           until the start of the first reading.  The automatic delay
 *           varies by function, but may be changed by the user with the
 *           delay parameter when autoDelay is set to OFF (0).
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * PARAM 4 : ViReal64 delay
 * IN        
 *            This specifies the amount of time (in seconds) to delay after
 *           receipt of the trigger before taking the first sample.  This
 *           value is ignored if autoDelay is ON (1).  The usual reason for
 *           specifying a specific delay time is to allow extra time for a
 *           relay to settle when measurement signals are being switched
 *           (multiplexed) to the voltmeter.  The min and max values for
 *           delay are defined in the following macros.
 * 
 *      MAX = hpe1411_TRIG_DEL_MAX   16.777215
 *      MIN = hpe1411_TRIG_DEL_MIN   0.0
 * 
 * PARAM 5 : ViInt16 source
 * IN        
 *            Selects the trigger source.  The allowable choices are
 *           represented in macros as shown below.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_trigger_source_a[] = {"BUS","EXT",
        "HOLD","IMM","TTLT0","TTLT1","TTLT2","TTLT3","TTLT4","TTLT5",
        "TTLT6","TTLT7",0};
ViStatus _VI_FUNC hpe1411_trigger(ViSession vi,
  ViInt32 count,
  ViBoolean autoDelay,
  ViReal64 delay,
  ViInt16 source)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigger" );

    hpe1411_CHK_LONG_RANGE(count
                          ,hpe1411_TRIG_COUN_MIN
                          ,hpe1411_TRIG_COUN_MAX
                          ,VI_ERROR_PARAMETER2);

    hpe1411_CHK_BOOLEAN(autoDelay,VI_ERROR_PARAMETER3);

    hpe1411_CHK_REAL_RANGE(delay
                          ,hpe1411_TRIG_DEL_MIN
                          ,hpe1411_TRIG_DEL_MAX
                          ,VI_ERROR_PARAMETER4);

    hpe1411_CHK_ENUM(source,11,VI_ERROR_PARAMETER5);
    if (thisPtr->e1406)
    {
        if (autoDelay)
            errStatus = viPrintf(vi,"TRIG:COUN %ld;SOUR %s;DEL:AUTO 1\n",
                 count, hpe1411_trigger_source_a[source] );
        else
            errStatus = viPrintf(vi,"TRIG:COUN %ld;SOUR %s;DEL %lg\n",
                 count, hpe1411_trigger_source_a[source], delay );
    
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        if (autoDelay)
            {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11638 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(
                 count);
/*#line 11638 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 11638 "hpe1411.cs"*/
{extern vm_trig_count();instr_send(vi,vm_trig_count,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11638 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_BUSEXT20[];char f_=0;
/*#line 11638 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_BUSEXT20,hpe1411_trigger_source_a[source] ,vi, &f_);
/*#line 11638 "hpe1411.cs"*/
if (!f_) {extern vm_trig_sour();instr_send(vi,vm_trig_sour,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11638 "hpe1411.cs"*/
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= 1;
/*#line 11638 "hpe1411.cs"*/
{extern vm_trig_del_a();instr_send(vi,vm_trig_del_a,&in_);}}}
        else
            {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11641 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_INT32*)in_.p1)->num=(
                 count);
/*#line 11641 "hpe1411.cs"*/
((HPSL_INT32*)in_.p1)->suffix=0;
/*#line 11641 "hpe1411.cs"*/
{extern vm_trig_count();instr_send(vi,vm_trig_count,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11641 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_BUSEXT20[];char f_=0;
/*#line 11641 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(E1326_enum_BUSEXT20,hpe1411_trigger_source_a[source],vi, &f_);
/*#line 11641 "hpe1411.cs"*/
if (!f_) {extern vm_trig_sour();instr_send(vi,vm_trig_sour,&in_);}}{ struct {short p1_type; char p1_type_pad[6]; double p1[2];} in_;
/*#line 11641 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT64*)in_.p1)->num=(delay );
/*#line 11641 "hpe1411.cs"*/
((HPSL_FLOAT64*)in_.p1)->suffix=0;
/*#line 11641 "hpe1411.cs"*/
{extern vm_trig_delay();instr_send(vi,vm_trig_delay,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_trigger_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries all of the trigger system settings in a
 *           single call.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt32 count
 * OUT       
 *            Returns the trigger count.
 * 
 * PARAM 3 : ViPBoolean autoDelay
 * OUT       
 *            Returns the current setting of automatic trigger delay: 1 (ON)
 *           or 0 (OFF).
 * 
 * PARAM 4 : ViPReal64 delay
 * OUT       
 *            Returns the current setting of trigger delay.  If autoDelay is
 *           1 (ON), then the delay returned is the value automatically set
 *           by the voltmeter; otherwise, the delay returned is the one
 *           previously set by the user.
 * 
 * PARAM 5 : ViPInt16 source
 * OUT       
 *            Returns the current setting of trigger source.  This will be an
 *           integer that represents one of the following settings:
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const hpe1411_trigger_Q_source_a[] = {"BUS","EXT",
        "HOLD","IMM","TTLT0","TTLT1","TTLT2","TTLT3","TTLT4","TTLT5",
        "TTLT6","TTLT7",0};
ViStatus _VI_FUNC hpe1411_trigger_Q(ViSession vi,
  ViPInt32 count,
  ViPBoolean autoDelay,
  ViPReal64 delay,
  ViPInt16 source)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;
    //char source_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_trigger_Q" );

    {
    char source_str[32];
    
    if (thisPtr->e1406)
    {
    
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"TRIG:COUN? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%ld%*t", count);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        errStatus = viPrintf(vi,"TRIG:DEL:AUTO? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t", autoDelay);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        errStatus = viPrintf(vi,"TRIG:DEL? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t", delay);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
        errStatus = viPrintf(vi,"TRIG:SOUR? \n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%s%*t", source_str);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    
    }
    else
    {
    
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 11770 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 11770 "hpe1411.cs"*/
{extern vm_trig_count_q();if (!instr_query(vi,vm_trig_count_q,&in_,&out_)){
/*#line 11770 "hpe1411.cs"*/
*count=(*(HPSL_INT32*)out_.p1).num;}}}}
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[2];} out_;
/*#line 11771 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 11771 "hpe1411.cs"*/
{extern vm_trig_delay_q();if (!instr_query(vi,vm_trig_delay_q,&in_,&out_)){
/*#line 11771 "hpe1411.cs"*/
*delay=(*(HPSL_FLOAT64*)out_.p1).num;}}}}
        {{ struct {double p1[1];} out_;
/*#line 11772 "hpe1411.cs"*/
{extern vm_trig_del_a_q();if (!instr_query(vi,vm_trig_del_a_q,(void*)0,&out_)){
/*#line 11772 "hpe1411.cs"*/
*autoDelay=*(HPSL_BOOLEAN*)out_.p1;}}}}
        {{ struct {double p1[1];} out_;
/*#line 11773 "hpe1411.cs"*/
extern CSCPI_IMPORT void *E1326_enum_BUSEXT20[];
/*#line 11773 "hpe1411.cs"*/
{extern vm_trig_sour_q();if (!instr_query(vi,vm_trig_sour_q,(void*)0,&out_)){
/*#line 11773 "hpe1411.cs"*/
enum_to_char(source_str, E1326_enum_BUSEXT20, *(HPSL_ENUM*)out_.p1);}}}}
    }
    
    errStatus = hpe1411_findIndex(thisPtr,hpe1411_trigger_Q_source_a,
            source_str, source);
    if (errStatus < VI_SUCCESS)
        hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcAper
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the integration time in seconds for AC voltage
 *           measurements. The voltmeter rounds values either up or down to
 *           the nearest time possible. See also the hpe1411_voltAcRes and
 *           hpe1411_voltAcNplc functions because changing aperture affects
 *           the setting on those two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 voltAcAper
 * IN        
 *            Sets the integration time in seconds (aperture) for AC voltage
 *           measurements. Input values are rounded UP to the nearest
 *           aperture time shown in the table below.
 *           
 *            Aperture is one of three ways to set the resolution of the
 *           reading.  The other two are voltAcRes and voltAcNplc.  The
 *           relationships between range, resolution, aperture and NPLC's
 *           (Number Power Line Cycles) is shown below.
 *            Aperture is determined by the NPLC setting; for example, for 1
 *           power line cycle of 60 Hz power, the aperture is 16.7
 *           milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power
 *           source were 50 Hz instead of 60 Hz, the above numbers would be
 *           20.0 milliseconds and 320 milliseconds respectively.
 *            In the following table, resolution is shown as a function of
 *           range and integration time given in Power Line Cycles (PLCs). 
 *           The associated aperture is shown for 60 Hz power.
 *           
 *                   ------------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)        |
 *                   | Aperture for 60 Hz power                            |
 *           --------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 *            Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
 *           --------------------------------------------------------------
 *            0.0875 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
 *              0.70 |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
 *              5.6  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
 *             44.8  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 *            300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|   64.0    |
 *           --------------------------------------------------------------
 *                   |        Resolution (n=e-9, u=e-6, m=e-3)             |
 *                    -----------------------------------------------------
 * 
 *      MAX = hpe1411_APER_MAX   320.0e-3
 *      MIN = hpe1411_APER_MIN   10.0e-6
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcAper(ViSession vi,
  ViReal64 voltAcAper)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcAper" );

    hpe1411_CHK_REAL_RANGE(voltAcAper
                          ,hpe1411_APER_MIN
                          ,hpe1411_APER_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"VOLT:APER %g\n",voltAcAper);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 11881 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 11881 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(voltAcAper);
/*#line 11881 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 11881 "hpe1411.cs"*/
{extern vm_aper();instr_send(vi,vm_aper,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcAper_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltage aperture.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 voltAcAper
 * OUT       
 *            Returns current integration time setting in seconds for AC
 *           voltage measurements.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcAper_Q(ViSession vi,
  ViPReal64 voltAcAper)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcAper_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:APER?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",voltAcAper);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 11947 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 11947 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 11947 "hpe1411.cs"*/
{extern vm_vaper_q();if (!instr_query(vi,vm_vaper_q,&in_,&out_)){
/*#line 11947 "hpe1411.cs"*/
*voltAcAper=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcNplc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the integration time in Power Line Cycles (PLC) for AC
 *           voltage measurements. The voltmeter rounds values UP to the
 *           nearest time. See also the hpe1411_voltAcRes and
 *           hpe1411_voltAcAper functions because changing NPLC affects the
 *           setting on those two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 voltAcNplc
 * IN        
 *            Sets the integration time in Power Line Cycles (PLCs) for AC
 *           voltage measurements.  Input values are rounded UP to the
 *           nearest aperture time shown in the table below.
 *           
 *            NPLC is one of three ways to set the resolution of the reading.
 *            The other two are voltAcRes and voltAcAper.  The relationships
 *           between range, resolution, aperture and NPLC's (Number Power
 *           Line Cycles) is shown below.
 *            Aperture is determined by the NPLC setting; for example, for 1
 *           power line cycle of 60 Hz power, the aperture is 16.7
 *           milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power
 *           source were 50 Hz instead of 60 Hz, the above numbers would be
 *           20.0 milliseconds and 320 milliseconds respectively.
 *            In the following table, resolution is shown as a function of
 *           range and integration time given in Power Line Cycles (PLCs). 
 *           The associated aperture is shown for 60 Hz power.
 *           
 *                   ------------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)        |
 *                   | Aperture for 60 Hz power                            |
 *           --------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 *            Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
 *           --------------------------------------------------------------
 *            0.0875 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
 *              0.70 |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
 *              5.6  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
 *             44.8  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 *            300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|   64.0    |
 *           --------------------------------------------------------------
 *                   |        Resolution (n=e-9, u=e-6, m=e-3)             |
 *                    -----------------------------------------------------
 * 
 *      MAX = hpe1411_NPLC_MAX   16.0
 *      MIN = hpe1411_NPLC_MIN   0.0005
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcNplc(ViSession vi,
  ViReal64 voltAcNplc)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcNplc" );

    hpe1411_CHK_REAL_RANGE(voltAcNplc
                          ,hpe1411_NPLC_MIN
                          ,hpe1411_NPLC_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"VOLT:NPLC %g\n",voltAcNplc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12049 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12049 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(voltAcNplc);
/*#line 12049 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 12049 "hpe1411.cs"*/
{extern vm_nplc();instr_send(vi,vm_nplc,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcNplc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltage number of
 *           power line cycles integration time (NPLC's).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 voltAcNplc
 * OUT       
 *            Returns the current integration time in PLCs for AC voltage
 *           measurements.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcNplc_Q(ViSession vi,
  ViPReal64 voltAcNplc)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcNplc_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:NPLC?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",voltAcNplc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 12116 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12116 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 12116 "hpe1411.cs"*/
{extern vm_vnplc_q();if (!instr_query(vi,vm_vnplc_q,&in_,&out_)){
/*#line 12116 "hpe1411.cs"*/
*voltAcNplc=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcRang
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the range for the AC voltage measurements.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean autoRange
 * IN        
 *            Enables (1) or disables (0) the auto ranging feature.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * PARAM 3 : ViReal64 range
 * IN        
 *            Sets the AC voltage range, as follows.
 * 
 *      MAX = hpe1411_VOLT_AC_RANG_MAX   300.0
 *      MIN = hpe1411_VOLT_AC_RANG_MIN   0.0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcRang(ViSession vi,
  ViBoolean autoRange,
  ViReal64 range)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcRang" );

    hpe1411_CHK_BOOLEAN(autoRange,VI_ERROR_PARAMETER2);

    hpe1411_CHK_REAL_RANGE(range
                          ,hpe1411_VOLT_AC_RANG_MIN
                          ,hpe1411_VOLT_AC_RANG_MAX
                          ,VI_ERROR_PARAMETER3);

        if (thisPtr->e1406)
        {
            /* if AUTO range, then ignore the range parameter */
            if (autoRange) 	/* is AUTO RANGE */
            {
               errStatus = viPrintf(vi,"VOLT:RANG:AUTO ON\n" );
            }
            else
            {
    	/* if not auto range, then sending range will turn AUTO OFF */
                errStatus = viPrintf(vi,"VOLT:RANG %lg\n", range );
            }
            if (errStatus < VI_SUCCESS)
                hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
        }
        else
        {
            /* if AUTO range, then ignore the range parameter;
    	 * else send a range, which will turn AUTO OFF
            */
            if (autoRange) 	/* is AUTO RANGE */
                {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12204 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12204 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_BOOLEAN*)in_.p1= 1;
/*#line 12204 "hpe1411.cs"*/
{extern vm_rang_auto();instr_send(vi,vm_rang_auto,&in_);}}}
            else
                {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12206 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12206 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=((float)range );
/*#line 12206 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 12206 "hpe1411.cs"*/
{extern vm_range();instr_send(vi,vm_range,&in_);}}}
        }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcRang_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltage range.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean autoRange
 * OUT       
 *            Returns the current setting: enabled (1) or disabled (0) of the
 *           auto ranging feature.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * PARAM 3 : ViPReal64 range
 * OUT       
 *            Returns the current AC voltage range setting.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcRang_Q(ViSession vi,
  ViPBoolean autoRange,
  ViPReal64 range)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcRang_Q" );

        if (thisPtr->e1406)
        {
            thisPtr->blockSrqIO = VI_TRUE;
            errStatus = viPrintf(vi,"VOLT:RANG:AUTO?\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
            errStatus = viScanf(vi,"%hd%*t",autoRange);
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
            errStatus = viPrintf(vi,"VOLT:AC:RANG?\n");
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
            errStatus = viScanf(vi,"%lg%*t",range);
            if (errStatus < VI_SUCCESS)
            {
                hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
            }
        }
        else
        {
            {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 12290 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12290 "hpe1411.cs"*/
{extern vm_vrang_auto_q();if (!instr_query(vi,vm_vrang_auto_q,&in_,&out_)){
/*#line 12290 "hpe1411.cs"*/
*autoRange=*(HPSL_BOOLEAN*)out_.p1;}}}}
            {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 12291 "hpe1411.cs"*/
in_.sub1= 1;
/*#line 12291 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 12291 "hpe1411.cs"*/
{extern vm_vrange_q();if (!instr_query(vi,vm_vrange_q,&in_,&out_)){
/*#line 12291 "hpe1411.cs"*/
*range=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
        }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcRes
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the resolution for AC voltage measurements.  See also
 *           the hpe1411_voltAcAper or hpe1411_voltAcNplc functions because
 *           changing the resolution affects the setting on those two
 *           functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 voltAcRes
 * IN        
 *            Specifies the resolution for AC voltage measurements.  Note
 *           that resolution is is really determined by aperture or NPLC
 *           settings, and so the minimum aperture on A GIVEN RANGE
 *           determines the resolution; thus 29.8 nanoVolts of resolution is
 *           only possible on the lowest range, and if selected on a higher
 *           range will result in an error from the instrument.  See below for the settings possible.
 *            Also, selecting a resolution changes the aperture and NPLC
 *           settings, see the table below for the interactions of Range,
 *           Resolution, Aperture, and NPLCs.
 *           
 *                   ------------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)        |
 *                   | Aperture for 60 Hz power                            |
 *           --------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 *            Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
 *           --------------------------------------------------------------
 *            0.0875 | 29.81 nV |  119 nV|    477 nV|  3.815 uV|   7.63 uV |
 *              0.70 |   238 nV |  954 nV|  3.815 uV|  30.52 uV|  61.04 uV |
 *              5.6  |  1.91 uV | 7.63 uV| 30.52  uV| 244.14 uV| 488.3  uV |
 *             44.8  | 15.26 uV |61.04 uV| 244.15 uV|  1.953 mV|   3.91 mV |
 *            300.0  |122.1  uV |488.3 uV|  1.954 mV| 15.625 mV|  31.25 mV |
 *           --------------------------------------------------------------
 *                   |        Resolution (n=e-9, u=e-6, m=e-3)             |
 *                    -----------------------------------------------------
 * 
 *      MAX = hpe1411_VOLT_RES_MAX   10.0
 *      MIN = hpe1411_VOLT_RES_MIN   29.81e-9
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcRes(ViSession vi,
  ViReal64 voltAcRes)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcRes" );

    hpe1411_CHK_REAL_RANGE(voltAcRes
                          ,hpe1411_VOLT_RES_MIN
                          ,hpe1411_VOLT_RES_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"VOLT:RES %g\n",voltAcRes);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12385 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12385 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(voltAcRes);
/*#line 12385 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 12385 "hpe1411.cs"*/
{extern vm_res();instr_send(vi,vm_res,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltAcRes_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltage resolution.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 voltAcRes
 * OUT       
 *            Returns current AC voltage resolution.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltAcRes_Q(ViSession vi,
  ViPReal64 voltAcRes)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltAcRes_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:RES?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",voltAcRes);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 12450 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12450 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 12450 "hpe1411.cs"*/
{extern vm_vres_q();if (!instr_query(vi,vm_vres_q,&in_,&out_)){
/*#line 12450 "hpe1411.cs"*/
*voltAcRes=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcAper
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the integration time in seconds for DC voltage
 *           measurements. The voltmeter rounds values UP to the nearest
 *           time. See also the hpe1411_voltDcRes and hpe1411_voltDcNplc
 *           functions because changing aperture affects the setting on those
 *           two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 voltDcAper
 * IN        
 *            Sets the integration time in seconds (aperture) for DC voltage
 *           measurements. Input values are rounded UP to the nearest
 *           aperture time shown in the table below.
 *           
 *            Aperture is one of three ways to set the resolution of the
 *           reading.  The other two are voltDcRes and voltDcNplc.  The
 *           relationships between range, resolution, aperture and NPLC's
 *           (Number Power Line Cycles) is shown below.
 *            Aperture is determined by the NPLC setting; for example, for 1
 *           power line cycle of 60 Hz power, the aperture is 16.7
 *           milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power
 *           source were 50 Hz instead of 60 Hz, the above numbers would be
 *           20.0 milliseconds and 320 milliseconds respectively.
 *            In the following table, resolution is shown as a function of
 *           range and integration time given in Power Line Cycles (PLCs). 
 *           The associated aperture is shown for 60 Hz power.
 *           
 *                   ------------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)        |
 *                   | Aperture for 60 Hz power                            |
 *           --------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 *            Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
 *           --------------------------------------------------------------
 *             0.125 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
 *              1.0  |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
 *              8.0  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
 *             64.0  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 *            300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|  31.25 mV |
 *           --------------------------------------------------------------
 *                   |        Resolution (n=e-9, u=e-6, m=e-3)             |
 *                    -----------------------------------------------------
 * 
 *      MAX = hpe1411_APER_MAX   320.0e-3
 *      MIN = hpe1411_APER_MIN   10.0e-6
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcAper(ViSession vi,
  ViReal64 voltDcAper)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcAper" );

    hpe1411_CHK_REAL_RANGE(voltDcAper
                          ,hpe1411_APER_MIN
                          ,hpe1411_APER_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"VOLT:APER %g\n",voltDcAper);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12552 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12552 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(voltDcAper);
/*#line 12552 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 12552 "hpe1411.cs"*/
{extern vm_aper();instr_send(vi,vm_aper,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcAper_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltDcAper
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 voltDcAper
 * OUT       
 *            Returns current integration time setting in seconds for DC
 *           voltage measurements.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcAper_Q(ViSession vi,
  ViPReal64 voltDcAper)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcAper_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:APER?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",voltDcAper);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 12618 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12618 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 12618 "hpe1411.cs"*/
{extern vm_vaper_q();if (!instr_query(vi,vm_vaper_q,&in_,&out_)){
/*#line 12618 "hpe1411.cs"*/
*voltDcAper=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcNplc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Sets the integration time in Power Line Cycles (PLC) for DC
 *           voltage measurements. The voltmeter rounds values UP to the
 *           nearest time. See also the hpe1411_voltDcRes and
 *           hpe1411_voltDcAper functions because changing NPLC affects the
 *           setting on those two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 voltDcNplc
 * IN        
 *            Sets the integration time in Power Line Cycles (PLCs) for DC
 *           voltage measurements.  Input values are rounded UP to the
 *           nearest aperture time shown in the table below.
 *           
 *            NPLC is one of three ways to set the resolution of the reading.
 *            The other two are voltDcRes and voltDcAper.  The relationships
 *           between range, resolution, aperture and NPLC's (Number Power
 *           Line Cycles) is shown below.
 *            Aperture is determined by the NPLC setting; for example, for 1
 *           power line cycle of 60 Hz power, the aperture is 16.7
 *           milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power
 *           source were 50 Hz instead of 60 Hz, the above numbers would be
 *           20.0 milliseconds and 320 milliseconds respectively.
 *            In the following table, resolution is shown as a function of
 *           range and integration time given in Power Line Cycles (PLCs). 
 *           The associated aperture is shown for 60 Hz power.
 *           
 *                   ------------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)        |
 *                   | Aperture for 60 Hz power                            |
 *           --------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 *            Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
 *           --------------------------------------------------------------
 *             0.125 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
 *              1.0  |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
 *              8.0  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
 *             64.0  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 *            300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|  31.25 mV |
 *           --------------------------------------------------------------
 *                   |        Resolution (n=e-9, u=e-6, m=e-3)             |
 *                    -----------------------------------------------------
 * 
 *      MAX = hpe1411_NPLC_MAX   16.0
 *      MIN = hpe1411_NPLC_MIN   0.0005
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcNplc(ViSession vi,
  ViReal64 voltDcNplc)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcNplc" );

    hpe1411_CHK_REAL_RANGE(voltDcNplc
                          ,hpe1411_NPLC_MIN
                          ,hpe1411_NPLC_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"VOLT:NPLC %g\n",voltDcNplc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12720 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12720 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(voltDcNplc);
/*#line 12720 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 12720 "hpe1411.cs"*/
{extern vm_nplc();instr_send(vi,vm_nplc,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcNplc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltage number of
 *           power line cycles integration time (NPLC's).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 voltDcNplc
 * OUT       
 *            Returns the current integration time in power line cycles
 *           (PLCs) for DC voltage measurements.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcNplc_Q(ViSession vi,
  ViPReal64 voltDcNplc)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcNplc_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:NPLC?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",voltDcNplc);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 12787 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12787 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 12787 "hpe1411.cs"*/
{extern vm_vnplc_q();if (!instr_query(vi,vm_vnplc_q,&in_,&out_)){
/*#line 12787 "hpe1411.cs"*/
*voltDcNplc=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcRang
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the range for the DC volts measurements.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean autoRange
 * IN        
 *            Enables (1) or disables (0) the auto ranging feature.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * PARAM 3 : ViReal64 range
 * IN        
 *            Sets the DC voltage range to the nearest range >= to the level
 *           specified.  The actual voltmeter ranges are as follows.
 * 
 *      MAX = hpe1411_VOLT_DC_RANG_MAX   300.0
 *      MIN = hpe1411_VOLT_DC_RANG_MIN   -300.0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcRang(ViSession vi,
  ViBoolean autoRange,
  ViReal64 range)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcRang" );

    hpe1411_CHK_BOOLEAN(autoRange,VI_ERROR_PARAMETER2);

    hpe1411_CHK_REAL_RANGE(range
                          ,hpe1411_VOLT_DC_RANG_MIN
                          ,hpe1411_VOLT_DC_RANG_MAX
                          ,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        /* if AUTO range, then ignore the range parameter */
        if (autoRange) 	/* is AUTO RANGE */
        {
           errStatus = viPrintf(vi,"VOLT:RANG:AUTO ON\n" );
        }
        else
        {
    	/* if not auto range, then sending range will turn AUTO OFF */
            errStatus = viPrintf(vi,"VOLT:RANG %lg\n", range );
        }
        if (errStatus < VI_SUCCESS)
            hpe1411_LOG_STATUS(vi, thisPtr, errStatus );
    }
    else
    {
        /* if AUTO range, then ignore the range parameter;
    	 * else send a range, which will turn AUTO OFF
        */
        if (autoRange) 	/* is AUTO RANGE */
            {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12876 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12876 "hpe1411.cs"*/
in_.p1_type= 2;*(HPSL_BOOLEAN*)in_.p1= 1;
/*#line 12876 "hpe1411.cs"*/
{extern vm_rang_auto();instr_send(vi,vm_rang_auto,&in_);}}}
        else
            {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 12878 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12878 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=((float)range );
/*#line 12878 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 12878 "hpe1411.cs"*/
{extern vm_range();instr_send(vi,vm_range,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcRang_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltDcRang
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean autoRange
 * OUT       
 *            Returns the current setting: enabled (1) or disabled (0) of the
 *           auto ranging feature.
 * 
 *      MAX = VI_TRUE   1
 *      MIN = VI_FALSE   0
 * 
 * PARAM 3 : ViPReal64 range
 * OUT       
 *            Returns the currently used DC voltage range. This will be one
 *           of the following.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcRang_Q(ViSession vi,
  ViPBoolean autoRange,
  ViPReal64 range)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcRang_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:RANG:AUTO?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",autoRange);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viPrintf(vi,"VOLT:RANG?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",range);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
/*#line 12963 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12963 "hpe1411.cs"*/
{extern vm_vrang_auto_q();if (!instr_query(vi,vm_vrang_auto_q,&in_,&out_)){
/*#line 12963 "hpe1411.cs"*/
*autoRange=*(HPSL_BOOLEAN*)out_.p1;}}}}
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 12964 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 12964 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 12964 "hpe1411.cs"*/
{extern vm_vrange_q();if (!instr_query(vi,vm_vrange_q,&in_,&out_)){
/*#line 12964 "hpe1411.cs"*/
*range=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcRes
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  Selects the resolution for DC voltage measurements.
 *            See also the hpe1411_voltDcAper and hpe1411_voltDcNplc
 *           functions because changing resolution affects the setting on
 *           those two functions as well (they are coupled).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViReal64 voltDcRes
 * IN        
 *            Specifies the resolution for DC voltage measurements.  Note
 *           that resolution is is really determined by aperture or NPLC
 *           settings, and so the minimum aperture on A GIVEN RANGE
 *           determines the resolution; thus 29.8 nanoVolts of resolution is
 *           only possible on the lowest range, and if selected on a higher
 *           range will result in an error from the instrument.  See below for the settings possible.
 *            Also, selecting a resolution changes the aperture and NPLC
 *           settings, see the table below for the interactions of Range,
 *           Resolution, Aperture, and NPLCs.
 *           
 *                   ------------------------------------------------------|
 *                   | Integration time in Power Line Cycles (PLCs)        |
 *                   | Aperture for 60 Hz power                            |
 *           --------------------------------------------------------------
 *           Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 *            Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
 *           --------------------------------------------------------------
 *             0.125 | 29.81 nV |  119 nV|    477 nV|  3.815 uV|   7.63 uV |
 *              1.0  |   238 nV |  954 nV|  3.815 uV|  30.52 uV|  61.04 uV |
 *              8.0  |  1.91 uV | 7.63 uV| 30.52  uV| 244.14 uV| 488.3  uV |
 *             64.0  | 15.26 uV |61.04 uV| 244.15 uV|  1.953 mV|   3.91 mV |
 *            300.0  |122.1  uV |488.3 uV|  1.954 mV| 15.625 mV|  31.25 mV |
 *           --------------------------------------------------------------
 *                   |        Resolution (n=e-9, u=e-6, m=e-3)             |
 *                    -----------------------------------------------------
 * 
 *      MAX = hpe1411_VOLT_RES_MAX   10.0
 *      MIN = hpe1411_VOLT_RES_MIN   29.81e-9
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcRes(ViSession vi,
  ViReal64 voltDcRes)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcRes" );

    hpe1411_CHK_REAL_RANGE(voltDcRes
                          ,hpe1411_VOLT_RES_MIN
                          ,hpe1411_VOLT_RES_MAX
                          ,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"VOLT:RES %g\n",voltDcRes);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
/*#line 13058 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 13058 "hpe1411.cs"*/
in_.p1_type= 0;((HPSL_FLOAT32*)in_.p1)->num=(voltDcRes);
/*#line 13058 "hpe1411.cs"*/
((HPSL_FLOAT32*)in_.p1)->suffix=0;
/*#line 13058 "hpe1411.cs"*/
{extern vm_res();instr_send(vi,vm_res,&in_);}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC hpe1411_voltDcRes_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  This routine queries the current setting of voltage resolution.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPReal64 voltDcRes
 * OUT       
 *            Returns current DC voltage resolution.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "hpe1411_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC hpe1411_voltDcRes_Q(ViSession vi,
  ViPReal64 voltDcRes)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct hpe1411_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViAddr) &thisPtr);
    }
    if (errStatus < VI_SUCCESS)
    {
       hpe1411_LOG_STATUS( vi, 0, errStatus );
    }

    hpe1411_DEBUG_CHK_THIS( vi, thisPtr );
    hpe1411_CDE_INIT( "hpe1411_voltDcRes_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"VOLT:RES?\n");
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%lg%*t",voltDcRes);
        if (errStatus < VI_SUCCESS)
        {
            hpe1411_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
/*#line 13123 "hpe1411.cs"*/
in_.sub1= 0;
/*#line 13123 "hpe1411.cs"*/
in_.p1_type= -1;
/*#line 13123 "hpe1411.cs"*/
{extern vm_vres_q();if (!instr_query(vi,vm_vres_q,&in_,&out_)){
/*#line 13123 "hpe1411.cs"*/
*voltDcRes=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
    }
    hpe1411_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}
