s        I    -;        
                                    hpe1411     HPE1411                                         ViInt16     ViInt32    ViReal64     
  	ViInt16 []     
  	ViInt32 []       
ViReal64 []      ViRsrc     	 	ViSession     	  ViChar []      ViStatus     	 	ViBoolean      	 ViBoolean []      ViString       Agilent 5.5 digit Multimeter     G    High Level Control provides easy control over the instrument's subsystems and provides access to the most common instrument features.  For finer control or for accessing specialized instrument capabilities use Low Level Control functions.

High Level Control functions are recommended for learning how to use the instrument.          Measure functions provide a method for making voltage, resistance, period, frequency, and temperature measurements. The measure functions in this node are for the stand alone voltmeter.         These functions allow measurements to occur via Agilent switchcards connected to the voltmeter. Measurements of strain, 2-wire and 4-wire ohms, AC and DC voltage, and temperature are supported.

To use the following functions you must have called 'Initialize' with a description that indicated multiple devices attached to the voltmeter.  See the help for the 'Initialize' function for more details.         The voltmeter's current measurement settings can be configured with these functions.  Note that there are two choices for measurement type based on whether or not the voltmeter is configured with Agilent switch cards.

If using the 'Measurement Type Using Switches' node, you must have opened the instrument with an instrument description that included the switch logical addresses in the string. See the help under the 'Initialize' choice for more details.

After changing the desired settings, select 'Read using Current Settings' to take the readings and bring back the data.

Additional configuration settings are available in the 'Low Level Control' functions.          This selects the type of measurements to make.  The voltmeter alone (without switchcards) can measure voltage, 4-wire resistance, and temperature using 4-wire resistance methods.     8    This selects the type of measurements to make via Agilent switchcard(s).  To use these functions, you must have first opened the instrument with an instrument description that included the switch logical addresses.  See the help for the 'Initialize' function for details and examples.

There are measurements for voltage, 2-wire and 4-wire resistance, temperature, and strain.

Note that strain measurements require you to initialize some settings like gage factor and unstrained reference voltage. See the 'Strain Initialization' menu for the applicable functions.         These functions control the constants that are used to convert readings into strain units on each switch channel. These constants include the gage factor, unstrained reference voltage, and Poisson ratio.

Most applications will only need to use the 'Initialize Strain Constants' menu.  However, those taking Poisson measurements will also need to use the 'Poisson Ratio Setup' menu as well.      |    Sample functions control the sampling subsystem of the voltmeter.  This includes sample count, sample source, and period.          The trigger subsystem is used to synchronize device action(s) with events.  The trigger subsystem provides services such as selecting trigger source, trigger delay, etc.         Low Level Control provides find control over the instrument. They are used for accessing specialized instrument capabilities and provide the most sophisticated and highest performance method for controlling the instrument.

Low Level Control functions are recommended for sophisticated users who need the best performance from their instrument driver or who need to access specialized capabilities.     H    The voltmeter's current measurement settings can be configured with these functions.  In order to complete a measurement it is necessary to select 'Initiate a Measurement' followed by a 'Fetch Data from Instrument' in the Low Level Control functions or use 'Read using Current Settings' from the High Level Control functions.          This selects the functional mode that the voltmeter will be operating in.  This can be 2 wire resistance, 4 wire resistance, DC Volts, and AC Volts.          This subsystem is used to configure DC Voltage settings such as range, resolutions, aperture, and number of Power Line Cycles.      D    This subsystem is used to configure the AC voltage range setting.          This subsystem is used to configure Resistance measurement settings such as range, resolutions, compensations, aperture, and number of Power Line Cycles.          These functions control the constants that are used to convert readings into strain units.  These include the gage factor, Poisson ratio, and unstrained reference voltage.      |    Sample functions control the sampling subsystem of the voltmeter.  This includes sample count, sample source, and period.         This section contains functions that allow you to change or query the mode of an Agilent E1460 switch, query the type of a switch card, or the description of a switch card.  These functions only apply to Agilent switches that are configured as part of a voltmeter virtual instrument.          The trigger subsystem is used to synchronize device action(s) with events.  The trigger subsystem provides services such as selecting trigger sources, trigger delays, etc.          The trigger output section determines if the voltmeter complete signal should be routed to one of the VXI TTL trigger lines.      C    VME memory allows control over an external source of VME memory.      .    This subsystem performs system calibration.      d    Status functions obtain the current status of the instrument or the status of pending operations.          Events indicate that something happened to the instrument. The event subsystem provides functions for reading events and clearing all events.          The synchronization subsystem provides functions that are used to synchronize instrument measurements by monitoring the status of pending operations.          Utility functions provide a variety of operations that affect the instrument.  These include sending SCPI commands to the instrument, self test, reset, error handling, service recalibration, etc.          These functions allow the user to send SCPI syntax strings directly to the instrument, and obtain the response data from a query.     A    Error Handling functions deal with error conditions.  There are two types of errors - driver errors and instrument errors. Driver errors are errors in parameters that are passed to functions.  Instrument errors are errors that occur on the instrument. Instrument errors may not be automatically detected by the driver.          This is used for automatically querying the instrument for instrument errors.  Normally, it is up to the user to manually check the instrument for errors.          Timeout functions are used to set the timeout period for the driver.  The timeout value may have to be changed when taking measurements which take a long time to complete.      v    WARNING:  These functions are for use by service trained technicians.  They are used to recalibrate the instrument.     Y    The initialize function initializes the software connection to the instrument and optionally verifies that instrument is in the system.  In addition, it may perform any necessary actions to place the instrument in its reset state.

If the hpe1411_init() function encounters an error, then the value of the vi output parameter will be VI_NULL.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".          The Instrument Description. Examples: VXI0::5, GPIB-VXI0::128::INSTR, and for a voltmeter at 72 with switch cards at 73 and 74:  VXI0::(72,73,74)::INSTR.      c    if( VI_TRUE) Perform In-System Verification. if(VI_FALSE) Do not perform In-System Verification.      U    IF( VI_TRUE) Perform Reset operation. if(VI_FALSE) Do not perform Reset operation.      K    Instrument Handle. This is VI_NULL if an error occurred during the init.     l       Status                            
 "         InstrDesc                          / u        id_query                            /        reset                              y /o        vi                                 	           
"GPIB::9::7"   On VI_TRUE Off VI_FALSE   On VI_TRUE Off VI_FALSE    	               Configures the instrument to measure the specified function and takes a reading.  Use this routine when the default parameters are acceptable.

Note that no range and resolution parameters are necessary.  The voltmeter defaults the range and resolution, and auto-ranging is enabled.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     L    The desired function to configure the voltmeter to measure.  The allowable settings are as shown below. 

 Macro Name          Value  Description
-----------------------------------------------------------
 hpe1411_CONF_FRES       0  4-Wire Resistance
 hpe1411_CONF_VOLT_AC    1  AC Voltage
 hpe1411_CONF_VOLT_DC    2  DC Voltage
     ?    The result of the measurement is returned in this parameter.     #Y       Status                            # "         vi                                $" /         func                              %v /A        reading                            	           0              d4-Wire Resistance hpe1411_CONF_FRES AC Voltage hpe1411_CONF_VOLT_AC DC Voltage hpe1411_CONF_VOLT_DC    	          J    Configures the instrument to measure temperature in degrees Celcius and takes a reading using the default settings forced by the configure.  This is the simplest way to take a reading with the voltmeter.  If the default settings are acceptable, and a single reading is all that is desired, then this routine is the one to use.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Used to specify the transducer type to use for measurement.  The allowable types are defined as macros as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_TRANS_FRTD_385        0  4-Wire RTD, alpha=0.00385
 hpe1411_TRANS_FRTD_392        1  4-Wire RTD, alpha=0.00392
 hpe1411_TRANS_FTHERM_2252     2  4-Wire Thermistor,2252 Ohm
 hpe1411_TRANS_FTHERM_5000     3  4-Wire Thermistor,5000 Ohm
 hpe1411_TRANS_FTHERM_10000    4  4-Wire Thermistor,10000 Ohm
     =    A single measurement result is returned in this parameter.     (s       Status                            ) "         vi                                )< /         transducer                        +Y /A        reading                            	           0              4-Wire RTD, alpha=0.00385 hpe1411_TRANS_FRTD_385 4-Wire RTD, alpha=0.00392 hpe1411_TRANS_FRTD_392 4-Wire Thermistor,2252 Ohm hpe1411_TRANS_FTHERM_2252 4-Wire Thermistor,5000 Ohm hpe1411_TRANS_FTHERM_5000 4-Wire Thermistor,10000 Ohm hpe1411_TRANS_FTHERM_10000    	          }    Configures the instrument to measure the specified function on the specified switch channels, and takes the readings.  Use this routine when the default parameters are acceptable.  For Temperature measurements, use the measTemp function.

Note that no range and resolution parameters are necessary.  The voltmeter defaults the range and resolution, and auto-ranging is enabled.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         The desired function to configure the voltmeter to measure.  The allowable settings are as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_CONF_LIST_FRES        0  4-Wire Resistance
 hpe1411_CONF_LIST_VOLT_AC     1  AC Voltage
 hpe1411_CONF_LIST_VOLT_DC     2  DC Voltage
 hpe1411_CONF_LIST_RES         3  2-Wire Resistance
 hpe1411_CONF_LIST_STR_QUAR    4  1/4 Bridge Strain
 hpe1411_CONF_LIST_STR_HBEN    5  1/2 Bridge Bend Strain
 hpe1411_CONF_LIST_STR_HPO     6  1/2 Bridge Pois. Strain
 hpe1411_CONF_LIST_STR_FBEN    7  Full Bridge Bend Strain
 hpe1411_CONF_LIST_STR_FPO     8  Full Bridge Pois. Strain
 hpe1411_CONF_LIST_STR_FBP     9  Full Bridge Bend Pois. Strain
 hpe1411_CONF_LIST_STR_QTEN   10  Tension shunt diag. Strain
 hpe1411_CONF_LIST_STR_QCOM   11  Compression shunt diag. Strain
 hpe1411_CONF_LIST_STR_UNST   12  Unstrained ref. voltage
         The desired channels to scan.  The allowable settings depend on which switches are in the mainframe and configured for use by the voltmeter.      ?    The result of the measurement is returned in this parameter.          Indicates the size of the array "readings". 

MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
    /&       Status                            / "         vi                                / - K       func                              3 -|        channelList                       4:  K        readings                          4 |       dataArrayLen                       	           0           
  m4-Wire Resistance hpe1411_CONF_LIST_FRES AC Voltage hpe1411_CONF_LIST_VOLT_AC DC Voltage hpe1411_CONF_LIST_VOLT_DC 2-Wire Resistance hpe1411_CONF_LIST_RES 1/4 Bridge Strain hpe1411_CONF_LIST_STR_QUAR 1/2 Bridge Bend Strain hpe1411_CONF_LIST_STR_HBEN 1/2 Bridge Pois. Strain hpe1411_CONF_LIST_STR_HPO Full Bridge Bend Strain hpe1411_CONF_LIST_STR_FBEN Full Bridge Pois. Strain hpe1411_CONF_LIST_STR_FPO Full Bridge Bend Pois. Strain hpe1411_CONF_LIST_STR_FBP Tension shunt diag. Strain hpe1411_CONF_LIST_STR_QTEN Compression shunt diag. Strain hpe1411_CONF_LIST_STR_QCOM Unstrained ref. voltage hpe1411_CONF_LIST_STR_UNST    "100"    	                     
          c    Configures the instrument to measure temperature and takes a reading on each of the specified channels using the default settings forced by the configure. This is the simplest way to take a reading with the voltmeter.  If the default settings are acceptable, and a single reading per channel is all that is desired, then this routine is the one to use.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Used to specify the transducer type to use for measurement.  The allowable types are defined as macros as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_TRANS_FRTD_385        0  4-Wire RTD, alpha=0.00385
 hpe1411_TRANS_FRTD_392        1  4-Wire RTD, alpha=0.00392
 hpe1411_TRANS_FTHERM_2252     2  4-Wire Thermistor,2252 Ohm
 hpe1411_TRANS_FTHERM_5000     3  4-Wire Thermistor,5000 Ohm
 hpe1411_TRANS_FTHERM_10000    4  4-Wire Thermistor,10000 Ohm
 hpe1411_TRANS_RTD_385         5  RTD, alpha=0.00385
 hpe1411_TRANS_RTD_392         6  RTD, alpha=0.00392
 hpe1411_TRANS_THERM_2252      7  Thermistor,2252 Ohm
 hpe1411_TRANS_THERM_5000      8  Thermistor,5000 Ohm
 hpe1411_TRANS_THERM_10000     9  Thermistor,10000 Ohm
 hpe1411_TRANS_TC_B           10  Thermocouple, type B
 hpe1411_TRANS_TC_E           11  Thermocouple, type E
 hpe1411_TRANS_TC_J           12  Thermocouple, type J
 hpe1411_TRANS_TC_K           13  Thermocouple, type K
 hpe1411_TRANS_TC_N14         14  Thermocouple, type N14
 hpe1411_TRANS_TC_N28         15  Thermocouple, type N28
 hpe1411_TRANS_TC_R           16  Thermocouple, type R
 hpe1411_TRANS_TC_S           17  Thermocouple, type S
 hpe1411_TRANS_TC_T           18  Thermocouple, type T
         The desired channels to scan.  The allowable settings depend on which switches are in the mainframe and configured for use by the voltmeter.          The measurement result is returned in this parameter.  It is up to the user to make sure the array is at least as large as the channelList specified.          Indicates the size of the array "readings". 

MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
    :k       Status                            ; "         vi                                ;4 - K       transducer                        @Q -|        channelList                       @  K        readings                          A |       dataArrayLen                       	           0              N4-Wire RTD, alpha=0.00385 hpe1411_TRANS_FRTD_385 4-Wire RTD, alpha=0.00392 hpe1411_TRANS_FRTD_392 4-Wire Thermistor,2252 Ohm hpe1411_TRANS_FTHERM_2252 4-Wire Thermistor,5000 Ohm hpe1411_TRANS_FTHERM_5000 4-Wire Thermistor,10000 Ohm hpe1411_TRANS_FTHERM_10000 RTD, alpha=0.00385 hpe1411_TRANS_RTD_385 RTD, alpha=0.00392 hpe1411_TRANS_RTD_392 Thermistor,2252 Ohm hpe1411_TRANS_THERM_2252 Thermistor,5000 Ohm hpe1411_TRANS_THERM_5000 Thermistor,10000 Ohm hpe1411_TRANS_THERM_10000 Thermocouple, type B hpe1411_TRANS_TC_B Thermocouple, type E hpe1411_TRANS_TC_E Thermocouple, type J hpe1411_TRANS_TC_J Thermocouple, type K hpe1411_TRANS_TC_K Thermocouple, type N14 hpe1411_TRANS_TC_N14 Thermocouple, type N28 hpe1411_TRANS_TC_N28 Thermocouple, type R hpe1411_TRANS_TC_R Thermocouple, type S hpe1411_TRANS_TC_S Thermocouple, type T hpe1411_TRANS_TC_T    "100"    	                     
              Configures the instrument to measure the specified function.  Use this routine when specific voltmeter parameters need to be changed from their default values (listed below).  The measurement process will not begin until the hpe1411_initImm function is called.

Note that no range and resolution parameters are necessary.  The voltmeter defaults the range and resolution, and auto-ranging is enabled.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      !    The handle to the instrument..     I    The desired function to configure the voltmeter to measure.  The allowable settings are shown below. 

 Macro Name          Value  Description
-----------------------------------------------------------
 hpe1411_CONF_FRES       0  4-Wire Resistance
 hpe1411_CONF_VOLT_AC    1  AC Voltage
 hpe1411_CONF_VOLT_DC    2  DC Voltage
    H       Status                            I% "         vi                                IN /=        func                               	           0              d4-Wire Resistance hpe1411_CONF_FRES AC Voltage hpe1411_CONF_VOLT_AC DC Voltage hpe1411_CONF_VOLT_DC        Configures the instrument to measure temperature.  Use this routine when specific voltmeter parameters need to be changed from their default values (listed below).  The measurement process will not begin until the hpe1411_initImm function is called.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Used to specify the transducer type to use for measurement.  The allowable types are defined as macros as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_TRANS_FRTD_385        0  4-Wire RTD, alpha=0.00385
 hpe1411_TRANS_FRTD_392        1  4-Wire RTD, alpha=0.00392
 hpe1411_TRANS_FTHERM_2252     2  4-Wire Thermistor,2252 Ohm
 hpe1411_TRANS_FTHERM_5000     3  4-Wire Thermistor,5000 Ohm
 hpe1411_TRANS_FTHERM_10000    4  4-Wire Thermistor,10000 Ohm
    L       Status                            Mh "         vi                                M /X        transducer                         	           0              4-Wire RTD, alpha=0.00385 hpe1411_TRANS_FRTD_385 4-Wire RTD, alpha=0.00392 hpe1411_TRANS_FRTD_392 4-Wire Thermistor,2252 Ohm hpe1411_TRANS_FTHERM_2252 4-Wire Thermistor,5000 Ohm hpe1411_TRANS_FTHERM_5000 4-Wire Thermistor,10000 Ohm hpe1411_TRANS_FTHERM_10000   .    Configures the instrument to measure the specified function on the specified channels.  Use this routine when specific voltmeter parameters need to be changed from their default values (listed below).  The measurement process will not begin until the hpe1411_initImm function is called.

For Temperature measurements use the confTemp or confTempList functions, for Strain measurements use the confStrList function.

Note that no range and resolution parameters are necessary.  The voltmeter defaults the range and resolution, and auto-ranging is enabled.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         The desired function to configure the voltmeter to measure.  The allowable settings are shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_CONF_LIST_FRES        0  4-Wire Resistance
 hpe1411_CONF_LIST_VOLT_AC     1  AC Voltage
 hpe1411_CONF_LIST_VOLT_DC     2  DC Voltage
 hpe1411_CONF_LIST_RES         3  2-Wire Resistance
 hpe1411_CONF_LIST_STR_QUAR    4  1/4 Bridge Strain
 hpe1411_CONF_LIST_STR_HBEN    5  1/2 Bridge Bend Strain
 hpe1411_CONF_LIST_STR_HPO     6  1/2 Bridge Pois. Strain
 hpe1411_CONF_LIST_STR_FBEN    7  Full Bridge Bend Strain
 hpe1411_CONF_LIST_STR_FPO     8  Full Bridge Pois. Strain
 hpe1411_CONF_LIST_STR_FBP     9  Full Bridge Bend Pois. Strain
 hpe1411_CONF_LIST_STR_QTEN   10  Tension shunt diag. Strain
 hpe1411_CONF_LIST_STR_QCOM   11  Compression shunt diag. Strain
 hpe1411_CONF_LIST_STR_UNST   12  Unstrained ref. voltage
         The desired channels to scan.  The allowable settings depend on which switches are in the mainframe and configured for use by the voltmeter.     S       Status                            TF "         vi                                Tn / x       func                              X /A        channelList                        	           0           
  m4-Wire Resistance hpe1411_CONF_LIST_FRES AC Voltage hpe1411_CONF_LIST_VOLT_AC DC Voltage hpe1411_CONF_LIST_VOLT_DC 2-Wire Resistance hpe1411_CONF_LIST_RES 1/4 Bridge Strain hpe1411_CONF_LIST_STR_QUAR 1/2 Bridge Bend Strain hpe1411_CONF_LIST_STR_HBEN 1/2 Bridge Pois. Strain hpe1411_CONF_LIST_STR_HPO Full Bridge Bend Strain hpe1411_CONF_LIST_STR_FBEN Full Bridge Pois. Strain hpe1411_CONF_LIST_STR_FPO Full Bridge Bend Pois. Strain hpe1411_CONF_LIST_STR_FBP Tension shunt diag. Strain hpe1411_CONF_LIST_STR_QTEN Compression shunt diag. Strain hpe1411_CONF_LIST_STR_QCOM Unstrained ref. voltage hpe1411_CONF_LIST_STR_UNST    "100"        Configures the instrument to measure temperature.  Use this routine when specific voltmeter parameters need to be changed from their default values (listed below).  The measurement process will not begin until the hpe1411_initImm function is called.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Used to specify the transducer type to use for measurement.  The allowable types are defined as macros as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_TRANS_FRTD_385        0  4-Wire RTD, alpha=0.00385
 hpe1411_TRANS_FRTD_392        1  4-Wire RTD, alpha=0.00392
 hpe1411_TRANS_FTHERM_2252     2  4-Wire Thermistor,2252 Ohm
 hpe1411_TRANS_FTHERM_5000     3  4-Wire Thermistor,5000 Ohm
 hpe1411_TRANS_FTHERM_10000    4  4-Wire Thermistor,10000 Ohm
 hpe1411_TRANS_RTD_385         5  RTD, alpha=0.00385
 hpe1411_TRANS_RTD_392         6  RTD, alpha=0.00392
 hpe1411_TRANS_THERM_2252      7  Thermistor,2252 Ohm
 hpe1411_TRANS_THERM_5000      8  Thermistor,5000 Ohm
 hpe1411_TRANS_THERM_10000     9  Thermistor,10000 Ohm
 hpe1411_TRANS_TC_B           10  Thermocouple, type B
 hpe1411_TRANS_TC_E           11  Thermocouple, type E
 hpe1411_TRANS_TC_J           12  Thermocouple, type J
 hpe1411_TRANS_TC_K           13  Thermocouple, type K
 hpe1411_TRANS_TC_N14         14  Thermocouple, type N14
 hpe1411_TRANS_TC_N28         15  Thermocouple, type N28
 hpe1411_TRANS_TC_R           16  Thermocouple, type R
 hpe1411_TRANS_TC_S           17  Thermocouple, type S
 hpe1411_TRANS_TC_T           18  Thermocouple, type T
         The desired channels to scan.  The allowable settings depend on which switches are in the mainframe and configured for use by the voltmeter.     ]%       Status                            ] "         vi                                ] / x       transducer                        c /A        channelList                        	           0             N4-Wire RTD, alpha=0.00385 hpe1411_TRANS_FRTD_385 4-Wire RTD, alpha=0.00392 hpe1411_TRANS_FRTD_392 4-Wire Thermistor,2252 Ohm hpe1411_TRANS_FTHERM_2252 4-Wire Thermistor,5000 Ohm hpe1411_TRANS_FTHERM_5000 4-Wire Thermistor,10000 Ohm hpe1411_TRANS_FTHERM_10000 RTD, alpha=0.00385 hpe1411_TRANS_RTD_385 RTD, alpha=0.00392 hpe1411_TRANS_RTD_392 Thermistor,2252 Ohm hpe1411_TRANS_THERM_2252 Thermistor,5000 Ohm hpe1411_TRANS_THERM_5000 Thermistor,10000 Ohm hpe1411_TRANS_THERM_10000 Thermocouple, type B hpe1411_TRANS_TC_B Thermocouple, type E hpe1411_TRANS_TC_E Thermocouple, type J hpe1411_TRANS_TC_J Thermocouple, type K hpe1411_TRANS_TC_K Thermocouple, type N14 hpe1411_TRANS_TC_N14 Thermocouple, type N28 hpe1411_TRANS_TC_N28 Thermocouple, type R hpe1411_TRANS_TC_R Thermocouple, type S hpe1411_TRANS_TC_S Thermocouple, type T hpe1411_TRANS_TC_T    "100"    ?    Returns the current configuration settings of the voltmeter.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Returns an integer representing the current configuration function.  The values are as shown below.


 Macro Name            Value  Description
-----------------------------------------------------------
 hpe1411_CONFQ_FRES        0  4-Wire Resistance
 hpe1411_CONFQ_VOLT_AC     1  AC Voltage
 hpe1411_CONFQ_VOLT_DC     2  DC Voltage
 hpe1411_CONFQ_RES         3  2-Wire Resistance
 hpe1411_CONFQ_STR_QUAR    4  Quarter Bridge Strain
 hpe1411_CONFQ_STR_HBEN    5  Half Bridge Bending Strain
 hpe1411_CONFQ_STR_HPO     6  Half Bridge Poisson Strain
 hpe1411_CONFQ_STR_FBEN    7  Full Bridge Bending Strain
 hpe1411_CONFQ_STR_FPO     8  Full Bridge Poisson Strain
 hpe1411_CONFQ_STR_FBP     9  Full Bridge Bend Pois. Strain
 hpe1411_CONFQ_STR_QTEN   10  Tension shunt diag. Strain
 hpe1411_CONFQ_STR_QCOM   11  Compression shunt diag. Strain
 hpe1411_CONFQ_STR_UNST   12  Unstrained ref. voltage
 hpe1411_CONFQ_TEMP       13  Temperature
         The current setting of auto ranging is returned in this variable.  If a 1 is returned, auto ranging is enabled, if 0, it is disabled.          The instrument's current range setting is returned in this variable.  If a -1.0 is returned, the range was "DEFault".  A -1.0 is always returned in this parameter if the function is temperature or strain.          The present resolution setting is returned in this parameter.  If the function is temperature or strain, a -1.0 (DEFault) is always returned here.         The current transducer type setting is returned in this parameter as an integer value.  If the current function is not TEMPerature, then a -1 will be returned, otherwise an integer representing type is returned.  The mapping is represented in macros as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_TRANS_FRTD_385        0  4-Wire RTD, alpha=0.00385
 hpe1411_TRANS_FRTD_392        1  4-Wire RTD, alpha=0.00392
 hpe1411_TRANS_FTHERM_2252     2  4-Wire Thermistor,2252 Ohm
 hpe1411_TRANS_FTHERM_5000     3  4-Wire Thermistor,5000 Ohm
 hpe1411_TRANS_FTHERM_10000    4  4-Wire Thermistor,10000 Ohm
 hpe1411_TRANS_RTD_385         5  RTD, alpha=0.00385
 hpe1411_TRANS_RTD_392         6  RTD, alpha=0.00392
 hpe1411_TRANS_THERM_2252      7  Thermistor,2252 Ohm
 hpe1411_TRANS_THERM_5000      8  Thermistor,5000 Ohm
 hpe1411_TRANS_THERM_10000     9  Thermistor,10000 Ohm
 hpe1411_TRANS_TC_B           10  Thermocouple, type B
 hpe1411_TRANS_TC_E           11  Thermocouple, type E
 hpe1411_TRANS_TC_J           12  Thermocouple, type J
 hpe1411_TRANS_TC_K           13  Thermocouple, type K
 hpe1411_TRANS_TC_N14         14  Thermocouple, type N14
 hpe1411_TRANS_TC_N28         15  Thermocouple, type N28
 hpe1411_TRANS_TC_R           16  Thermocouple, type R
 hpe1411_TRANS_TC_S           17  Thermocouple, type S
 hpe1411_TRANS_TC_T           18  Thermocouple, type T
    h4       Status                            h "         vi                                h / Y        func                              l /         autoRange                         m? /o        range                             n          resolution                        n A        transducer                         	           0    	            	            	           	           	               This routine sets the gage factor and measures the unstrained reference voltage for each channel in the list.  Before taking strain measurements, both of these constants need to be set.

The gage factor and unstrained reference voltage are used by the voltmeter to calculate the strain value on a channel.

This setting must be done once after the instrument is powered on and before any strain measurements are taken on a channel.  Failure to do so will result in inaccurate data.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      v    The gage factor to use for the strain measurement. 

MAX = hpe1411_GFAC_MAX   1.0e3
MIN = hpe1411_GFAC_MIN   1.0e-9
     2    The channel(s) that will receive new constants.     x       Status                            x "         vi                                x /        gageFactor                        yV /A        channelList                        	           0 ?}t@@     >.&֕@                     "100"       This routine sets the gage factor, Poisson ratio, and measures the unstrained reference voltage for each channel in the list.  Before taking Poisson measurements, these constants need to be set.

The gage factor, Poisson ratio, and unstrained reference voltage are used by the voltmeter to calculate the Poisson strain value on a channel.

These settings must be done once after the instrument is powered on and before any Poisson strain measurements are taken on a channel.  Failure to do so will result in inaccurate data.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      v    The gage factor to use for the strain measurement. 

MAX = hpe1411_GFAC_MAX   1.0e3
MIN = hpe1411_GFAC_MIN   1.0e-9
         The poisson ratio to use when measuring poisson configurations. 

MAX = hpe1411_POIS_MAX   2.0
MIN = hpe1411_POIS_MIN   1.0e-4
     2    The channel(s) that will receive new constants.     |       Status                            }a "         vi                                } / c       gageFactor                        ~ /        poissonRatio                      ~ /o        channelList                        	           0 ?}t@@     >.&֕@                  ?*6j@       ?6C-?333333              "100"        This routine queries the present settings of gage factor, unstrained reference voltage, and Poisson ratio on the specified channels.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The size of the arrays to hold the gage factors, unstrained references and poisson ratios returned. 

MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
     Q    The gage factor(s) for the channel(s) specifed are returned in this parameter.      S    The Poisson ratio(s) for the channel(s) specifed are returned in this parameter.      b    The unstrained reference voltage(s) for the channel(s) specifed are returned in this parameter.      A    The channels that will be queried for their strain parameters.            Status                            s "         vi                                 / c       respArrayLen                      X /         gageFact                           /o        poissonRatio                                refVolt                           v A        channelList                        	           0      
                 	            	            	            "100"   #    This routine sets up the sample parameters on the voltmeter in a single function call.  Note that each of the sample settings in this call may also be set individually by the function of a similar name as the parameter (i.e. sample source can also be set by function hpe1411_sampSour() ).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Specifies the number of samples that will be taken with each trigger event. Normally, the voltmeter only has enough memory to store 4096 readings.  This limits the trigger count * sample count to be <= 4096.  If you require more readings than this, see the hpe1411_read_Q function for a way to get data directly from the voltmeter without storing the data into memory first. 

MAX = hpe1411_SAMP_COUN_MAX   16777215
MIN = hpe1411_SAMP_COUN_MIN   1
    '    Selects the sample source to be either 0 (IMMediate) or 1 (TIMer).  Source TIM(er) causes the voltmeter to wait for a period defined by the hpe1411_sampTim() function between each sample if sample count is greater than 1.  Source IMMediate will cause samples to occur as soon as the voltmeter is ready to sample.  Macros are defined for these two settings as shown below. 

 Macro Name           Value  Description
-----------------------------------------------------------
 hpe1411_SAMP_SOUR_IMM    0  Immediate
 hpe1411_SAMP_SOUR_TIM    1  Timer
        Selects period (in seconds) between samples when sample count is > 1 and the sample source is set to TIMer.  If the sample source is not TIM, this value is accepted but not used.

Note that the sample timer period must be longer than the current setting of aperture (hpe1411_resAper, hpe1411_voltAcAper, or hpe1411_voltDcAper).  See the hpe1411_sampTim function description for information on what the allowable values are.

Also note that the TIMer period does not occur between the trigger and the first sample, use the hpe1411_trigDel() function to add delay at that point.  The minimum and maximum allowable settings are defined as macros, shown below. 

MAX = hpe1411_SAMP_TIM_MAX   65.534e-3
MIN = hpe1411_SAMP_TIM_MIN   76.0e-6
           Status                            S "         vi                                { / c       count                             E /         source                            t /y       period                             	           0                    < Immediate hpe1411_SAMP_SOUR_IMM Timer hpe1411_SAMP_SOUR_TIM >tͣ]?Ƭ!?F
?                    Q    This routine returns all of the settings related to sampling on the voltmeter.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      L    Returns the number of samples that will be taken with each trigger event.         Returns the currently selected sample source represented as an integer as follows. 

 Macro Name           Value  Description
-----------------------------------------------------------
 hpe1411_SAMP_SOUR_IMM    0  Immediate
 hpe1411_SAMP_SOUR_TIM    1  Timer
     g    Returns the period (in seconds) between samples. This period is only used if sample source is TIMer.     Q       Status                             "         vi                                 / Y        count                             n /         source                            | /o        period                             	           0    	            	            	           G    This routine sets up the trigger system with a single function call.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     #    Specifies the trigger count.  This is the number of "bursts" of samples that will be taken.  Normally, the voltmeter only has enough memory to store 4096 readings.  This limits the trigger count * number of samples to be <= 4096. If you require more readings than this, see the hpe1411_read_Q function for a way to get data directly from the voltmeter without storing the data into memory first.  The min and max values of trigger count are defined as macros shown below. 

MAX = hpe1411_TRIG_COUN_MAX   16777215
MIN = hpe1411_TRIG_COUN_MIN   1
    L    Enables (1) or disables (0) selection of an automatic trigger delay.  This is the time period from receipt of the trigger until the start of the first reading.  The automatic delay varies by function, but may be changed by the user with the delay parameter when autoDelay is set to OFF (0). 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
        This specifies the amount of time (in seconds) to delay after receipt of the trigger before taking the first sample.  This value is ignored if autoDelay is ON (1).  The usual reason for specifying a specific delay time is to allow extra time for a relay to settle when measurement signals are being switched (multiplexed) to the voltmeter.  The min and max values for delay are defined in the following macros. 

MAX = hpe1411_TRIG_DEL_MAX   16.777215
MIN = hpe1411_TRIG_DEL_MIN   0.0
        Selects the trigger source.  The allowable choices are represented in macros as shown below. 

 Macro Name             Value  Description
-----------------------------------------------------------
 hpe1411_TRIG_SOUR_BUS      0  Bus
 hpe1411_TRIG_SOUR_EXT      1  Ext Trig BNC Connector
 hpe1411_TRIG_SOUR_HOLD     2  Hold
 hpe1411_TRIG_SOUR_IMM      3  Immediate
 hpe1411_TRIG_SOUR_TTLT0    4  TTL Trigger Line 0
 hpe1411_TRIG_SOUR_TTLT1    5  TTL Trigger Line 1
 hpe1411_TRIG_SOUR_TTLT2    6  TTL Trigger Line 2
 hpe1411_TRIG_SOUR_TTLT3    7  TTL Trigger Line 3
 hpe1411_TRIG_SOUR_TTLT4    8  TTL Trigger Line 4
 hpe1411_TRIG_SOUR_TTLT5    9  TTL Trigger Line 5
 hpe1411_TRIG_SOUR_TTLT6   10  TTL Trigger Line 6
 hpe1411_TRIG_SOUR_TTLT7   11  TTL Trigger Line 7
    x       Status                             "         vi                                A / G       count                             l /         autoDelay                          /&       delay                              /|       source                             	           0                     On VI_TRUE Off VI_FALSE ?[|߾Z@0                                       Bus hpe1411_TRIG_SOUR_BUS Ext Trig BNC Connector hpe1411_TRIG_SOUR_EXT Hold hpe1411_TRIG_SOUR_HOLD Immediate hpe1411_TRIG_SOUR_IMM TTL Trigger Line 0 hpe1411_TRIG_SOUR_TTLT0 TTL Trigger Line 1 hpe1411_TRIG_SOUR_TTLT1 TTL Trigger Line 2 hpe1411_TRIG_SOUR_TTLT2 TTL Trigger Line 3 hpe1411_TRIG_SOUR_TTLT3 TTL Trigger Line 4 hpe1411_TRIG_SOUR_TTLT4 TTL Trigger Line 5 hpe1411_TRIG_SOUR_TTLT5 TTL Trigger Line 6 hpe1411_TRIG_SOUR_TTLT6 TTL Trigger Line 7 hpe1411_TRIG_SOUR_TTLT7    L    This routine queries all of the trigger system settings in a single call.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Returns the trigger count.      M    Returns the current setting of automatic trigger delay: 1 (ON) or 0 (OFF).          Returns the current setting of trigger delay.  If autoDelay is 1 (ON), then the delay returned is the value automatically set by the voltmeter; otherwise, the delay returned is the one previously set by the user.         Returns the current setting of trigger source.  This will be an integer that represents one of the following settings: 

 Macro Name             Value  Description
-----------------------------------------------------------
 hpe1411_TRIG_SOUR_BUS      0  Bus
 hpe1411_TRIG_SOUR_EXT      1  Ext Trig BNC Connector
 hpe1411_TRIG_SOUR_HOLD     2  Hold
 hpe1411_TRIG_SOUR_IMM      3  Immediate
 hpe1411_TRIG_SOUR_TTLT0    4  TTL Trigger Line 0
 hpe1411_TRIG_SOUR_TTLT1    5  TTL Trigger Line 1
 hpe1411_TRIG_SOUR_TTLT2    6  TTL Trigger Line 2
 hpe1411_TRIG_SOUR_TTLT3    7  TTL Trigger Line 3
 hpe1411_TRIG_SOUR_TTLT4    8  TTL Trigger Line 4
 hpe1411_TRIG_SOUR_TTLT5    9  TTL Trigger Line 5
 hpe1411_TRIG_SOUR_TTLT6   10  TTL Trigger Line 6
 hpe1411_TRIG_SOUR_TTLT7   11  TTL Trigger Line 7
           Status                            @ "         vi                                h / =        count                              /         autoDelay                          /        delay                              /        source                             	           0    	            	            	           	               Places the voltmeter in the wait-for-trigger state and transfers readings directly to the output buffer after receiving a trigger.  Because voltmeter memory is not used to store the readings, there is no restriction on the sample count and trigger count.  Because the readings are formatted before being sent to the output buffer, the sample rate is not as high as the one attainable using the hpe1411_initImm and hpe1411_fetc_Q routines.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Returns the readings taken by the voltmeter.  The array pointer passed in must point to an array large enough to hold the data.  If the array is not large enough, bad things may happen as we index off the end of the array.          Indicates the size of the array "readings". 

MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
    !       Status                             "         vi                                 /         readings                           /K       dataArrayLen                       	           0    	                     
               Places the voltmeter in the wait-for-trigger state and stores readings in voltmeter memory when a trigger occurs. The new readings replace the readings in memory from previous commands.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     '       Status                             "         vi                                 	           0    w    Aborts a measurement in progress, the trigger system is returned to the idle state.  No other settings are affected.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.            Status                             "         vi                                 	           0        This routine returns readings stored in memory from the last measurement operation.  The timeOut parameter allows a time out value to be used only during this function, with the original time out value being re-stored after the data is fetched.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The value (in milli-seconds) to set the time out value to for the duration of this function.  When the function completes, the original time out value is re-stored. 

MAX = hpe1411_TIMEOUT_MAX   2147483647
MIN = hpe1411_TIMEOUT_MIN   0
     h    The array of double which will hold the readings.  Make sure it is large enough to hold all the data.          Indicates the size of the array "readings". 

MAX = hpe1411_DATA_ARRAY_LEN_MAX   1048576
MIN = hpe1411_DATA_ARRAY_LEN_MIN   1
    -       Status                             "         vi                                 / c       timeOut                            /         readings                          \ /y       dataArrayLen                       	           0                     	                     
           [    Causes a trigger to occur immediately if the voltmeter is in the wait-for-trigger state.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.            Status                            < "         vi                                 	           0        This function sends a BUS trigger to the instrument.  The instrument should be in the wait-for-trigger state (see hpe1411_initImm), and the trigger source should be "BUS" for this to work properly. instrument.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().            Status                            \ "         vi                                 	           0    e    This selects the measurement function consisting of 4-wire resistance, DC voltage, and AC voltage.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      !    The handle to the instrument..     p    This parameter is an integer which represents the voltmeter function that is desired.  The mapping is represented in macros as shown below. 

 Macro Name          Value  Description
-----------------------------------------------------------
 hpe1411_FUNC_FRES       0  4-Wire Resistance
 hpe1411_FUNC_VOLT_AC    1  AC Voltage
 hpe1411_FUNC_VOLT_DC    2  DC Voltage
    ~       Status                             "         vi                                H /=        func                               	           0              d4-Wire Resistance hpe1411_FUNC_FRES AC Voltage hpe1411_FUNC_VOLT_AC DC Voltage hpe1411_FUNC_VOLT_DC        This routine queries the current setting of the function.  Note that if you have configured the instrument for Temperature, the function returned is either VOLT, RES or FRES depending on the transducer type selected.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     B    Returns an integer representing the current function setting.  The mapping is as shown below. 

 Macro Name          Value  Description
-----------------------------------------------------------
 hpe1411_FUNC_FRES       0  4-Wire Resistance
 hpe1411_FUNC_VOLT_AC    1  AC Voltage
 hpe1411_FUNC_VOLT_DC    2  DC Voltage
           Status                            g "         vi                                 /         func                               	           0    	            3    Selects the range for the DC volts measurements.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      _    Enables (1) or disables (0) the auto ranging feature. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
        Sets the DC voltage range to the nearest range >= to the level specified.  The actual voltmeter ranges are as follows. 

 Macro Name                     Value  Description
-----------------------------------------------------------
 hpe1411_VOLT_DC_RANG_125MV  125.0e-3  125.0e-3
 hpe1411_VOLT_DC_RANG_1V          1.0  1.0
 hpe1411_VOLT_DC_RANG_8V          8.0  8.0
 hpe1411_VOLT_DC_RANG_64V        64.0  64.0
 hpe1411_VOLT_DC_RANG_300V      300.0  300.0

MAX = hpe1411_VOLT_DC_RANG_MAX   300.0
MIN = hpe1411_VOLT_DC_RANG_MIN   -300.0
           Status                            q "         vi                                 /         autoRange                           /        range                              	           0   On VI_TRUE Off VI_FALSE              125.0e-3 hpe1411_VOLT_DC_RANG_125MV 1.0 hpe1411_VOLT_DC_RANG_1V 8.0 hpe1411_VOLT_DC_RANG_8V 64.0 hpe1411_VOLT_DC_RANG_64V 300.0 hpe1411_VOLT_DC_RANG_300V    9    This routine queries the current setting of voltDcRang          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Returns the current setting: enabled (1) or disabled (0) of the auto ranging feature. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
        Returns the currently used DC voltage range. This will be one of the following. 

 Macro Name                     Value  Description
-----------------------------------------------------------
 hpe1411_VOLT_DC_RANG_125MV  125.0e-3  125.0e-3
 hpe1411_VOLT_DC_RANG_1V          1.0  1.0
 hpe1411_VOLT_DC_RANG_8V          8.0  8.0
 hpe1411_VOLT_DC_RANG_64V        64.0  64.0
 hpe1411_VOLT_DC_RANG_300V      300.0  300.0
           Status                            Ǭ "         vi                                 /         autoRange                         [ /A        range                              	           0    	            	               Selects the resolution for DC voltage measurements. See also the hpe1411_voltDcAper and hpe1411_voltDcNplc functions because changing resolution affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     1    Specifies the resolution for DC voltage measurements.  Note that resolution is is really determined by aperture or NPLC settings, and so the minimum aperture on A GIVEN RANGE determines the resolution; thus 29.8 nanoVolts of resolution is only possible on the lowest range, and if selected on a higher range will result in an error from the instrument.  See below for the settings possible.

Also, selecting a resolution changes the aperture and NPLC settings, see the table below for the interactions of Range, Resolution, Aperture, and NPLCs.

        ------------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)        |
        | Aperture for 60 Hz power                            |
--------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
--------------------------------------------------------------
  0.125 | 29.81 nV |  119 nV|    477 nV|  3.815 uV|   7.63 uV |
   1.0  |   238 nV |  954 nV|  3.815 uV|  30.52 uV|  61.04 uV |
   8.0  |  1.91 uV | 7.63 uV| 30.52  uV| 244.14 uV| 488.3  uV |
  64.0  | 15.26 uV |61.04 uV| 244.15 uV|  1.953 mV|   3.91 mV |
 300.0  |122.1  uV |488.3 uV|  1.954 mV| 15.625 mV|  31.25 mV |
--------------------------------------------------------------
        |        Resolution (n=e-9, u=e-6, m=e-3)             |
         -----------------------------------------------------

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1411_VOLT_RES_30_NANO     29.81e-9  29.81e-9 (range = 0.0875 V)
 hpe1411_VOLT_RES_120_NANO    119.3e-9  119.3e-9 (range = 0.0875 V)
 hpe1411_VOLT_RES_238_NANO    238.5e-9  238.5e-9 (ranges <= 0.70 V)
 hpe1411_VOLT_RES_477_NANO    477.0e-9  477.0e-9 (ranges <= 0.70 V)
 hpe1411_VOLT_RES_954_NANO    954.0e-9  954.0e-9 (ranges <= 0.70 V)
 hpe1411_VOLT_RES_2_MICRO      1.91e-6  1.91e-6 (ranges <= 5.6 V)
 hpe1411_VOLT_RES_4_MICRO     3.815e-6  3.815e-6 (ranges <= 5.6 V)
 hpe1411_VOLT_RES_8_MICRO      7.63e-6  7.63e-6 (ranges <= 5.6 V)
 hpe1411_VOLT_RES_15_MICRO    15.26e-6  15.26e-6 (ranges <= 44.8 V)
 hpe1411_VOLT_RES_30_MICRO    30.52e-6  30.52e-6 (ranges <= 44.8 V)
 hpe1411_VOLT_RES_61_MICRO     61.04-6  61.04-6 (ranges <= 44.8 V)
 hpe1411_VOLT_RES_122_MICRO   122.1e-6  122.1e-6 (all ranges)
 hpe1411_VOLT_RES_244_MICRO  244.15e-6  244.15e-6 (all ranges)
 hpe1411_VOLT_RES_488_MICRO   488.3e-6  488.3e-6 (all ranges)
 hpe1411_VOLT_RES_2_MILLI     1.954e-3  1.954e-3 (all ranges)
 hpe1411_VOLT_RES_4_MILLI      3.91e-3  3.91e-3 (all ranges)
 hpe1411_VOLT_RES_16_MILLI   15.626e-3  15.626e-3 (all ranges)
 hpe1411_VOLT_RES_32_MILLI     33.3e-3  33.3e-3(all ranges)

MAX = hpe1411_VOLT_RES_MAX   10.0
MIN = hpe1411_VOLT_RES_MIN   29.81e-9
           Status                            ̅ "         vi                                ̭ /        voltDcRes                        M 3                                          c b                                            	           0             29.81e-9 (range = 0.0875 V) hpe1411_VOLT_RES_30_NANO 119.3e-9 (range = 0.0875 V) hpe1411_VOLT_RES_120_NANO 238.5e-9 (ranges <= 0.70 V) hpe1411_VOLT_RES_238_NANO 477.0e-9 (ranges <= 0.70 V) hpe1411_VOLT_RES_477_NANO 954.0e-9 (ranges <= 0.70 V) hpe1411_VOLT_RES_954_NANO 1.91e-6 (ranges <= 5.6 V) hpe1411_VOLT_RES_2_MICRO 3.815e-6 (ranges <= 5.6 V) hpe1411_VOLT_RES_4_MICRO 7.63e-6 (ranges <= 5.6 V) hpe1411_VOLT_RES_8_MICRO 15.26e-6 (ranges <= 44.8 V) hpe1411_VOLT_RES_15_MICRO 30.52e-6 (ranges <= 44.8 V) hpe1411_VOLT_RES_30_MICRO 61.04-6 (ranges <= 44.8 V) hpe1411_VOLT_RES_61_MICRO 122.1e-6 (all ranges) hpe1411_VOLT_RES_122_MICRO 244.15e-6 (all ranges) hpe1411_VOLT_RES_244_MICRO 488.3e-6 (all ranges) hpe1411_VOLT_RES_488_MICRO 1.954e-3 (all ranges) hpe1411_VOLT_RES_2_MILLI 3.91e-3 (all ranges) hpe1411_VOLT_RES_4_MILLI 15.626e-3 (all ranges) hpe1411_VOLT_RES_16_MILLI 33.3e-3(all ranges) hpe1411_VOLT_RES_32_MILLI    =WARNING: Changing Resolution also changes NPLC and Aperture!    6See Help/Control for more specifics on this coupling.    B    This routine queries the current setting of voltage resolution.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      )    Returns current DC voltage resolution.     j       Status                             "         vi                                3 /         voltDcRes                          	           0    	              Sets the integration time in seconds for DC voltage measurements. The voltmeter rounds values UP to the nearest time. See also the hpe1411_voltDcRes and hpe1411_voltDcNplc functions because changing aperture affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     \    Sets the integration time in seconds (aperture) for DC voltage measurements. Input values are rounded UP to the nearest aperture time shown in the table below.

Aperture is one of three ways to set the resolution of the reading.  The other two are voltDcRes and voltDcNplc.  The relationships between range, resolution, aperture and NPLC's (Number Power Line Cycles) is shown below.

Aperture is determined by the NPLC setting; for example, for 1 power line cycle of 60 Hz power, the aperture is 16.7 milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power source were 50 Hz instead of 60 Hz, the above numbers would be 20.0 milliseconds and 320 milliseconds respectively.

In the following table, resolution is shown as a function of range and integration time given in Power Line Cycles (PLCs).  The associated aperture is shown for 60 Hz power.

        ------------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)        |
        | Aperture for 60 Hz power                            |
--------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
--------------------------------------------------------------
  0.125 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
   1.0  |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
   8.0  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
  64.0  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|  31.25 mV |
--------------------------------------------------------------
        |        Resolution (n=e-9, u=e-6, m=e-3)             |
         -----------------------------------------------------

MAX = hpe1411_APER_MAX   320.0e-3
MIN = hpe1411_APER_MIN   10.0e-6
    A       Status                             "         vi                                
 /        voltDcAper                       M 3                                          c b                                            	           0 ? D??zG{>h?L              =WARNING: Changing Aperture also changes NPLC and Resolution!    6See Help/Control for more specifics on this coupling.    9    This routine queries the current setting of voltDcAper          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      S    Returns current integration time setting in seconds for DC voltage measurements.     m       Status                             "         vi                                6 /         voltDcAper                         	           0    	          %    Sets the integration time in Power Line Cycles (PLC) for DC voltage measurements. The voltmeter rounds values UP to the nearest time. See also the hpe1411_voltDcRes and hpe1411_voltDcAper functions because changing NPLC affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     Z    Sets the integration time in Power Line Cycles (PLCs) for DC voltage measurements.  Input values are rounded UP to the nearest aperture time shown in the table below.

NPLC is one of three ways to set the resolution of the reading.  The other two are voltDcRes and voltDcAper.  The relationships between range, resolution, aperture and NPLC's (Number Power Line Cycles) is shown below.

Aperture is determined by the NPLC setting; for example, for 1 power line cycle of 60 Hz power, the aperture is 16.7 milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power source were 50 Hz instead of 60 Hz, the above numbers would be 20.0 milliseconds and 320 milliseconds respectively.

In the following table, resolution is shown as a function of range and integration time given in Power Line Cycles (PLCs).  The associated aperture is shown for 60 Hz power.

        ------------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)        |
        | Aperture for 60 Hz power                            |
--------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
--------------------------------------------------------------
  0.125 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
   1.0  |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
   8.0  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
  64.0  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|  31.25 mV |
--------------------------------------------------------------
        |        Resolution (n=e-9, u=e-6, m=e-3)             |
         -----------------------------------------------------

MAX = hpe1411_NPLC_MAX   16.0
MIN = hpe1411_NPLC_MIN   0.0005
    z       Status                             "         vi                                C /        voltDcNplc                       M 3                                          c b                                            	           0 ?Z6;7
@0      ?@bM?                    =WARNING: Changing NPLC also changes Aperture and Resolution!    6See Help/Control for more specifics on this coupling.    m    This routine queries the current setting of voltage number of power line cycles integration time (NPLC's).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      `    Returns the current integration time in power line cycles (PLCs) for DC voltage measurements.            Status                            y "         vi                                 /         voltDcNplc                         	           0    	           5    Selects the range for the AC voltage measurements.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      _    Enables (1) or disables (0) the auto ranging feature. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
        Sets the AC voltage range, as follows. 

 Macro Name                   Value  Description
-----------------------------------------------------------
 hpe1411_VOLT_AC_RANG_87MV   0.0874  0.0875
 hpe1411_VOLT_AC_RANG_700MV   0.699  0.70
 hpe1411_VOLT_AC_RANG_5V      5.599  5.6
 hpe1411_VOLT_AC_RANG_44V     44.79  44.8
 hpe1411_VOLT_AC_RANG_300V    299.9  300.0

MAX = hpe1411_VOLT_AC_RANG_MAX   300.0
MIN = hpe1411_VOLT_AC_RANG_MIN   0.0
           Status                             "         vi                                 /         autoRange                         2 /y        range                              	           0   On VI_TRUE Off VI_FALSE              0.0875 hpe1411_VOLT_AC_RANG_87MV 0.70 hpe1411_VOLT_AC_RANG_700MV 5.6 hpe1411_VOLT_AC_RANG_5V 44.8 hpe1411_VOLT_AC_RANG_44V 300.0 hpe1411_VOLT_AC_RANG_300V    =    This routine queries the current setting of voltage range.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Returns the current setting: enabled (1) or disabled (0) of the auto ranging feature. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
     0    Returns the current AC voltage range setting.            Status                             "         vi                                 /         autoRange                         2 /A        range                              	           0    	            	               Selects the resolution for AC voltage measurements.  See also the hpe1411_voltAcAper or hpe1411_voltAcNplc functions because changing the resolution affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     1    Specifies the resolution for AC voltage measurements.  Note that resolution is is really determined by aperture or NPLC settings, and so the minimum aperture on A GIVEN RANGE determines the resolution; thus 29.8 nanoVolts of resolution is only possible on the lowest range, and if selected on a higher range will result in an error from the instrument.  See below for the settings possible.

Also, selecting a resolution changes the aperture and NPLC settings, see the table below for the interactions of Range, Resolution, Aperture, and NPLCs.

        ------------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)        |
        | Aperture for 60 Hz power                            |
--------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
--------------------------------------------------------------
 0.0875 | 29.81 nV |  119 nV|    477 nV|  3.815 uV|   7.63 uV |
   0.70 |   238 nV |  954 nV|  3.815 uV|  30.52 uV|  61.04 uV |
   5.6  |  1.91 uV | 7.63 uV| 30.52  uV| 244.14 uV| 488.3  uV |
  44.8  | 15.26 uV |61.04 uV| 244.15 uV|  1.953 mV|   3.91 mV |
 300.0  |122.1  uV |488.3 uV|  1.954 mV| 15.625 mV|  31.25 mV |
--------------------------------------------------------------
        |        Resolution (n=e-9, u=e-6, m=e-3)             |
         -----------------------------------------------------

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1411_VOLT_RES_30_NANO     29.81e-9  29.81e-9 (range = 0.0875 V)
 hpe1411_VOLT_RES_120_NANO    119.3e-9  119.3e-9 (range = 0.0875 V)
 hpe1411_VOLT_RES_238_NANO    238.5e-9  238.5e-9 (ranges <= 0.70 V)
 hpe1411_VOLT_RES_477_NANO    477.0e-9  477.0e-9 (ranges <= 0.70 V)
 hpe1411_VOLT_RES_954_NANO    954.0e-9  954.0e-9 (ranges <= 0.70 V)
 hpe1411_VOLT_RES_2_MICRO      1.91e-6  1.91e-6 (ranges <= 5.6 V)
 hpe1411_VOLT_RES_4_MICRO     3.815e-6  3.815e-6 (ranges <= 5.6 V)
 hpe1411_VOLT_RES_8_MICRO      7.63e-6  7.63e-6 (ranges <= 5.6 V)
 hpe1411_VOLT_RES_15_MICRO    15.26e-6  15.26e-6 (ranges <= 44.8 V)
 hpe1411_VOLT_RES_30_MICRO    30.52e-6  30.52e-6 (ranges <= 44.8 V)
 hpe1411_VOLT_RES_61_MICRO     61.04-6  61.04-6 (ranges <= 44.8 V)
 hpe1411_VOLT_RES_122_MICRO   122.1e-6  122.1e-6 (all ranges)
 hpe1411_VOLT_RES_244_MICRO  244.15e-6  244.15e-6 (all ranges)
 hpe1411_VOLT_RES_488_MICRO   488.3e-6  488.3e-6 (all ranges)
 hpe1411_VOLT_RES_2_MILLI     1.954e-3  1.954e-3 (all ranges)
 hpe1411_VOLT_RES_4_MILLI      3.91e-3  3.91e-3 (all ranges)
 hpe1411_VOLT_RES_16_MILLI   15.626e-3  15.626e-3 (all ranges)
 hpe1411_VOLT_RES_32_MILLI     33.3e-3  33.3e-3(all ranges)

MAX = hpe1411_VOLT_RES_MAX   10.0
MIN = hpe1411_VOLT_RES_MIN   29.81e-9
   M       Status                            "         vi                                /        voltAcRes                        M 3                                          c b                                            	           0             29.81e-9 (range = 0.0875 V) hpe1411_VOLT_RES_30_NANO 119.3e-9 (range = 0.0875 V) hpe1411_VOLT_RES_120_NANO 238.5e-9 (ranges <= 0.70 V) hpe1411_VOLT_RES_238_NANO 477.0e-9 (ranges <= 0.70 V) hpe1411_VOLT_RES_477_NANO 954.0e-9 (ranges <= 0.70 V) hpe1411_VOLT_RES_954_NANO 1.91e-6 (ranges <= 5.6 V) hpe1411_VOLT_RES_2_MICRO 3.815e-6 (ranges <= 5.6 V) hpe1411_VOLT_RES_4_MICRO 7.63e-6 (ranges <= 5.6 V) hpe1411_VOLT_RES_8_MICRO 15.26e-6 (ranges <= 44.8 V) hpe1411_VOLT_RES_15_MICRO 30.52e-6 (ranges <= 44.8 V) hpe1411_VOLT_RES_30_MICRO 61.04-6 (ranges <= 44.8 V) hpe1411_VOLT_RES_61_MICRO 122.1e-6 (all ranges) hpe1411_VOLT_RES_122_MICRO 244.15e-6 (all ranges) hpe1411_VOLT_RES_244_MICRO 488.3e-6 (all ranges) hpe1411_VOLT_RES_488_MICRO 1.954e-3 (all ranges) hpe1411_VOLT_RES_2_MILLI 3.91e-3 (all ranges) hpe1411_VOLT_RES_4_MILLI 15.626e-3 (all ranges) hpe1411_VOLT_RES_16_MILLI 33.3e-3(all ranges) hpe1411_VOLT_RES_32_MILLI    =WARNING: Changing Resolution also changes NPLC and Aperture!    6See Help/Control for more specifics on this coupling.    B    This routine queries the current setting of voltage resolution.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      )    Returns current AC voltage resolution.           Status                           t "         vi                                /         voltAcRes                          	           0    	          1    Sets the integration time in seconds for AC voltage measurements. The voltmeter rounds values either up or down to the nearest time possible. See also the hpe1411_voltAcRes and hpe1411_voltAcNplc functions because changing aperture affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     \    Sets the integration time in seconds (aperture) for AC voltage measurements. Input values are rounded UP to the nearest aperture time shown in the table below.

Aperture is one of three ways to set the resolution of the reading.  The other two are voltAcRes and voltAcNplc.  The relationships between range, resolution, aperture and NPLC's (Number Power Line Cycles) is shown below.

Aperture is determined by the NPLC setting; for example, for 1 power line cycle of 60 Hz power, the aperture is 16.7 milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power source were 50 Hz instead of 60 Hz, the above numbers would be 20.0 milliseconds and 320 milliseconds respectively.

In the following table, resolution is shown as a function of range and integration time given in Power Line Cycles (PLCs).  The associated aperture is shown for 60 Hz power.

        ------------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)        |
        | Aperture for 60 Hz power                            |
--------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
--------------------------------------------------------------
 0.0875 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
   0.70 |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
   5.6  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
  44.8  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|   64.0    |
--------------------------------------------------------------
        |        Resolution (n=e-9, u=e-6, m=e-3)             |
         -----------------------------------------------------

MAX = hpe1411_APER_MAX   320.0e-3
MIN = hpe1411_APER_MIN   10.0e-6
          Status                           c "         vi                                /        voltAcAper                       M 3                                          c b                                            	           0 ? D??zG{>h?L              =WARNING: Changing Aperture also changes NPLC and Resolution!    6See Help/Control for more specifics on this coupling.    @    This routine queries the current setting of voltage aperture.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      S    Returns current integration time setting in seconds for AC voltage measurements.            Status                           ! "         vi                               ! /         voltAcAper                         	           0    	          %    Sets the integration time in Power Line Cycles (PLC) for AC voltage measurements. The voltmeter rounds values UP to the nearest time. See also the hpe1411_voltAcRes and hpe1411_voltAcAper functions because changing NPLC affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     Z    Sets the integration time in Power Line Cycles (PLCs) for AC voltage measurements.  Input values are rounded UP to the nearest aperture time shown in the table below.

NPLC is one of three ways to set the resolution of the reading.  The other two are voltAcRes and voltAcAper.  The relationships between range, resolution, aperture and NPLC's (Number Power Line Cycles) is shown below.

Aperture is determined by the NPLC setting; for example, for 1 power line cycle of 60 Hz power, the aperture is 16.7 milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power source were 50 Hz instead of 60 Hz, the above numbers would be 20.0 milliseconds and 320 milliseconds respectively.

In the following table, resolution is shown as a function of range and integration time given in Power Line Cycles (PLCs).  The associated aperture is shown for 60 Hz power.

        ------------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)        |
        | Aperture for 60 Hz power                            |
--------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125   |  0.005   | .0005 PLC |
 Volts  |  267ms  | 16.7ms  |  2.5ms   |  100us   |  10us     |
--------------------------------------------------------------
 0.0875 |  29.8 nV| 119 nV  |  476 nV  | 3.814 uV |  7.629 uV |
   0.70 |  238 nV | 953 nV  | 3.814 uV | 30.517 uV| 61.035 uV |
   5.6  | 1.907 uV| 7.629 uV| 30.517 uV| 244.14 uV| 488.281 uV|
  44.8  |15.258 uV|61.035 uV| 244.14 uV| 1.953 mV | 3.906 mV  |
 300.0  |122.07 uV|488.28 uV| 1.953 mV | 15.625 mV|   64.0    |
--------------------------------------------------------------
        |        Resolution (n=e-9, u=e-6, m=e-3)             |
         -----------------------------------------------------

MAX = hpe1411_NPLC_MAX   16.0
MIN = hpe1411_NPLC_MIN   0.0005
   $       Status                           $ "         vi                               $ /        voltAcNplc                       M 3                                          c b                                            	           0 ?Z6;7
@0      ?@bM?                    =WARNING: Changing NPLC also changes Aperture and Resolution!    6See Help/Control for more specifics on this coupling.    m    This routine queries the current setting of voltage number of power line cycles integration time (NPLC's).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      L    Returns the current integration time in PLCs for AC voltage measurements.    .`       Status                           / "         vi                               /) /         voltAcNplc                         	           0    	               Selects the range for resistance measurements and disables/enables the auto ranging feature.  If the resRangAuto parameter is 1 (ON) then the value sent in resRang parameter is ignored.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      L    Enables (1) or disables (0) the auto ranging feature. 

MIN = VI_TRUE   1
        If auto ranging is enabled (resRangAuto = 1), then this parameter is ignored. If auto ranging is disabled (resRangAuto = 0), the mulitmeter is set to the nearest range greater than or equal to the value specified.  The possible range settings on the voltmeter are defined in macros as shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_RES_RANG_250      255.0  256.0
 hpe1411_RES_RANG_2K      2047.0  2048.0
 hpe1411_RES_RANG_16K    16383.0  16384.0
 hpe1411_RES_RANG_131K  131071.0  131072.0
 hpe1411_RES_RANG_1M     1048575  1048576

MAX = hpe1411_RES_RANG_MAX   1048576.0
MIN = hpe1411_RES_RANG_MIN   0.0
   0       Status                           1 "         vi                               1 /         autoRange                        2 /        range                              	           0   On VI_TRUE Off VI_FALSE              256.0 hpe1411_RES_RANG_250 2048.0 hpe1411_RES_RANG_2K  16384.0 hpe1411_RES_RANG_16K 131072.0 hpe1411_RES_RANG_131K 1048576 hpe1411_RES_RANG_1M    ]    This routine queries the current setting of resistance range and the auto ranging setting.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Returns the current setting: enabled (1) or disabled (0) of the auto ranging feature. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
     (    Returns the resistance range setting.    6       Status                           7w "         vi                               7 /         autoRange                        8& /A        range                              	           0    	            	          J    Selects the resolution for resistance measurements.  The minimum value of resolution is a function of range, so not all ranges can do all of the resolutions listed above.  For a more consistant method of specifying resolution, use the resNplc or resAper functions to specify resolution in terms of integration or aperture time.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Specifies the resolution for resistance measurements.  Note that resolution is is really determined by aperture or NPLC settings, and so the minimum aperture on A GIVEN RANGE determines the resolution; thus 61 microOhms of resolution is only possible on the lowest range, and if selected on a higher range will result in an error from the instrument.  See below for the settings possible.

Also, selecting a resolution changes the aperture and NPLC settings, see the table below for the interactions of Range, Resolution, Aperture, and NPLCs.

        -----------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)       |
        | Aperture for 60 Hz power                           |
-------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125  |  0.005   | .0005 PLC |
 Ohms   |  267ms  | 16.7ms  |  2.5ms  |  100us   |  10us     |
-------------------------------------------------------------
    256 |   61e-6 | 244e-6  |  976e-6 | 7.812e-3 | 15.625e-3 |
   2048 |  488e-6 | 1.95e-3 | 7.812e-3|  62.5e-3 |    125e-3 |
  16384 |  3.9e-3 | 15.63e-3| 62.5e-3 |   0.5    |    1.0    |
 131072 | 31.2e-3 | 125e-3  |  0.5    |   4.0    |    8.0    |
1048576 |  250e-3 |   1.0   |  4.0    |  32.0    |   64.0    |
-------------------------------------------------------------
        |                Resolution in Ohms                  |
         ----------------------------------------------------

 Macro Name                    Value  Description
-----------------------------------------------------------
 hpe1411_RES_RES_61U        61.05e-6  61.05e-6 (range = 256 Ohm)
 hpe1411_RES_RES_244U       244.2e-6  244.2e-6 (range = 256 Ohm)
 hpe1411_RES_RES_488U       488.3e-6  488.3e-6 (ranges <= 2048 Ohm)
 hpe1411_RES_RES_1_MILLI    976.6e-6  976.6e-6 (ranges <= 2048 Ohm)
 hpe1411_RES_RES_2_MILLI    1.954e-3  1.954e-3 (if ranges <= 2048 Ohm)
 hpe1411_RES_RES_4_MILLI     3.91e-3  3.91e-3 (ranges <= 16384 Ohm)
 hpe1411_RES_RES_8_MILLI    7.813e-3  7.813e-3 (ranges <= 16384 Ohm)
 hpe1411_RES_RES_16_MILLI   15.63e-3  15.63e-3 (ranges <= 16384 Ohm)
 hpe1411_RES_RES_32_MILLI    31.3e-3  31.3e-3 (ranges <= 131072 Ohm)
 hpe1411_RES_RES_63_MILLI   62.51e-3  62.51e-3 (ranges <= 131072 Ohm)
 hpe1411_RES_RES_125_MILLI  125.1e-3  125.1e-3 (ranges <= 131072 Ohm)
 hpe1411_RES_RES_250_MILLI  250.1e-3  250.1e-3 (All ranges)
 hpe1411_RES_RES_500_MILLI  500.1e-3  500.1e-3 (All ranges)
 hpe1411_RES_RES_1              1.01  1.0 (All ranges)
 hpe1411_RES_RES_4              4.01  4.0 (All ranges)
 hpe1411_RES_RES_8              8.01  8.0 (All ranges)
 hpe1411_RES_RES_32            32.01  32.0 (All ranges)
 hpe1411_RES_RES_64             64.0  64.0 (All ranges)

MAX = hpe1411_RES_RES_MAX   64.0
MIN = hpe1411_RES_RES_MIN   61.0e-6
   :       Status                           ;F "         vi                               ;n /        resRes                           M 3                                          c b                                            	           0             d61.05e-6 (range = 256 Ohm) hpe1411_RES_RES_61U 244.2e-6 (range = 256 Ohm) hpe1411_RES_RES_244U 488.3e-6 (ranges <= 2048 Ohm) hpe1411_RES_RES_488U 976.6e-6 (ranges <= 2048 Ohm) hpe1411_RES_RES_1_MILLI 1.954e-3 (if ranges <= 2048 Ohm) hpe1411_RES_RES_2_MILLI 3.91e-3 (ranges <= 16384 Ohm) hpe1411_RES_RES_4_MILLI 7.813e-3 (ranges <= 16384 Ohm) hpe1411_RES_RES_8_MILLI 15.63e-3 (ranges <= 16384 Ohm) hpe1411_RES_RES_16_MILLI 31.3e-3 (ranges <= 131072 Ohm) hpe1411_RES_RES_32_MILLI 62.51e-3 (ranges <= 131072 Ohm) hpe1411_RES_RES_63_MILLI 125.1e-3 (ranges <= 131072 Ohm) hpe1411_RES_RES_125_MILLI 250.1e-3 (All ranges) hpe1411_RES_RES_250_MILLI 500.1e-3 (All ranges) hpe1411_RES_RES_500_MILLI 1.0 (All ranges) hpe1411_RES_RES_1 4.0 (All ranges) hpe1411_RES_RES_4 8.0 (All ranges) hpe1411_RES_RES_8 32.0 (All ranges) hpe1411_RES_RES_32 64.0 (All ranges) hpe1411_RES_RES_64    =WARNING: Changing Resolution also changes NPLC and Aperture!    6See Help/Control for more specifics on this coupling.    :    This routine queries the current setting of resolution.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      8    The returned value is the current resolution setting.    K       Status                           L` "         vi                               L /         resRes                             	           0    	           a    Enables or disables the offset compensated ohms function (on 30, 300, and 3k ohm ranges only).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          OFF (0) disables or ON (1) enables the resistance offset compensated ohms measurements. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
   M       Status                           N "         vi                               N /        resOcom                            	           0    On VI_TRUE Off VI_FALSE    6    This routine queries the current setting of resOcom          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      Q    Returns 0 for offset compensated ohms off or 1 for offset compensated ohms on.    PH       Status                           P "         vi                               Q /         resOcom                            	           0    	               Sets the integration time in seconds for resistance measurements.  The voltmeter rounds values UP to the nearest time possible. See also the hpe1411_resRes and hpe1411_resNplc functions because changing aperture affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     G    Sets the integration time in seconds (Aperture) for resistance measurements. Input values are rounded UP to the nearest aperture time shown in the table below.

Aperture is one of three ways to set the resolution of the reading.  The other two are resolution and NPLC.  The relationships between range, resolution, aperture and NPLC's (Number Power Line Cycles) is shown below.

Aperture is determined by the NPLC setting; for example, for 1 power line cycle of 60 Hz power, the aperture is 16.7 milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power source were 50 Hz instead of 60 Hz, the above numbers would be 20.0 milliseconds and 320 milliseconds respectively.

In the following table, resolution is shown as a function of range and integration time given in Power Line Cycles (PLCs).  The associated aperture is shown for 60 Hz power.
        -----------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)       |
        | Aperture for 60 Hz power                           |
-------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125  |  0.005   | .0005 PLC |
 Ohms   |  267ms  | 16.7ms  |  2.5ms  |  100us   |  10us     |
-------------------------------------------------------------
    256 |   61e-6 | 244e-6  |  976e-6 | 7.812e-3 | 15.625e-3 |
   2048 |  488e-6 | 1.95e-3 | 7.812e-3|  62.5e-3 |    125e-3 |
  16384 |  3.9e-3 | 15.63e-3| 62.5e-3 |   0.5    |    1.0    |
 131072 | 31.2e-3 | 125e-3  |  0.5    |   4.0    |    8.0    |
1048576 |  250e-3 |   1.0   |  4.0    |  32.0    |   64.0    |
-------------------------------------------------------------
        |                Resolution in Ohms                  |
         ----------------------------------------------------

MAX = hpe1411_APER_MAX   320.0e-3
MIN = hpe1411_APER_MIN   10.0e-6
   SK       Status                           S "         vi                               T /        resAper                          M 3                                          c b                                            	           0 ? D??zG{>h?L              =WARNING: Changing Aperture also changes NPLC and Resolution!    6See Help/Control for more specifics on this coupling.    6    This routine queries the current setting of resAper          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      6    Returns the current resistance aperture time value.    ]_       Status                           ^  "         vi                               ^( /         resAper                            	           0    	          &    Sets the integration time in power line cycles (PLCs) for resistance measurements. The voltmeter rounds values UP to the nearest NPLC value. See also the hpe1411_resRes and hpe1411_resAper functions because changing NPLC affects the setting on those two functions as well (they are coupled).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     @    Sets the Number of Power Line Cycles (NPLCs)  for resistance measurements. Input values are rounded UP to the nearest aperture time shown in the table below.

NPLC is one of three ways to set the resolution of the reading.  The other two are resolution and aperture.  The relationships between range, resolution, aperture and NPLC's (Number Power Line Cycles) is shown below.

Aperture is determined by the NPLC setting; for example, for 1 power line cycle of 60 Hz power, the aperture is 16.7 milliseconds, for 16 PLCs, it is 267 milliseconds.  If the power source were 50 Hz instead of 60 Hz, the above numbers would be 20.0 milliseconds and 320 milliseconds respectively.

In the following table, resolution is shown as a function of range and integration time given in Power Line Cycles (PLCs).  The associated aperture is shown for 60 Hz power.
        -----------------------------------------------------|
        | Integration time in Power Line Cycles (PLCs)       |
        | Aperture for 60 Hz power                           |
-------------------------------------------------------------
Range   |  16 PLCs|  1 PLC  |  0.125  |  0.005   | .0005 PLC |
 Ohms   |  267ms  | 16.7ms  |  2.5ms  |  100us   |  10us     |
-------------------------------------------------------------
    256 |   61e-6 | 244e-6  |  976e-6 | 7.812e-3 | 15.625e-3 |
   2048 |  488e-6 | 1.95e-3 | 7.812e-3|  62.5e-3 |    125e-3 |
  16384 |  3.9e-3 | 15.63e-3| 62.5e-3 |   0.5    |    1.0    |
 131072 | 31.2e-3 | 125e-3  |  0.5    |   4.0    |    8.0    |
1048576 |  250e-3 |   1.0   |  4.0    |  32.0    |   64.0    |
-------------------------------------------------------------
        |                Resolution in Ohms                  |
         ----------------------------------------------------

MAX = hpe1411_NPLC_MAX   16.0
MIN = hpe1411_NPLC_MIN   0.0005
   `P       Status                           ` "         vi                               a /        resNplc                          M 3                                          c b                                            	           0 ?Z6;7
@0      ?@bM?                    =WARNING: Changing NPLC also changes Aperture and Resolution!    6See Help/Control for more specifics on this coupling.    6    This routine queries the current setting of resNplc          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      (    Returns current resistance PLC value.    j]       Status                           j "         vi                               k& /         resNplc                            	           0    	               This routine measures the unstrained reference voltage on the specified channels. This must be done before any strain measurements are taken on a channel. Failure to do so will result in inaccurate data.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The desired channels on which to measure the unstrained reference.  The allowable settings depend on which strain switches are in the mainframe and configured for use by the voltmeter.    l       Status                           m "         vi                               m /         channelList                        	           0    "100"    c    This routine queries the present unstrained reference voltage setting on the specified channels.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The size of the array to hold the unstrained reference voltage values returned. 

MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
     j    The unstrained reference voltage setting(s) for the channel(s) specifed are returned in this parameter.      U    The channels that will be queried for their unstrained reference voltage settings.    o       Status                           p9 "         vi                               pa / c       respArrayLen                     q
 /         reference                        q| /o        channelList                        	           0      
                 	            "100"       This routine sets the unstrained reference voltage for each channel specified in the list.  The unstrained reference value is used by the voltmeter to calculate strain on a given channel.

This command is used when it is desirable to download data from a pre-stored table of unstrained references to each channel.  This would normally be done when the channel(s) are currently under some strain and it is not desirable to unload them to get an unstrained measurement via the hpe1411_calStr function.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      s    The unstrained reference voltage value. 

MAX = hpe1411_UNST_REF_MAX   300.0
MIN = hpe1411_UNST_REF_MIN   -300.0
     F    The channel(s) to receive the unstrained reference value specified.    u       Status                           u "         vi                               u /        reference                        vb /A        channelList                        	           0 ?Q@r     r                           "100"   H    This routine sets the gage factor for each channel in the list.  The gage factor is used by the voltmeter to calculate the strain value on a channel.

This setting must be done once after the instrument is powered on and before any strain measurements are taken on a channel.  Failure to do so will result in inaccurate data.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      v    The gage factor to use for the strain measurement. 

MAX = hpe1411_GFAC_MAX   1.0e3
MIN = hpe1411_GFAC_MIN   1.0e-9
     ?    The channels that will be set to the new gageFactor setting.    y       Status                           y "         vi                               y /        gageFactor                       z` /A        channelList                        	           0 ?}t@@     >.&֕@                     "100"    R    This routine queries the present gage factor setting on the specified channels.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The size of the array to hold the gage factors returned. 

MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
     Q    The gage factor(s) for the channel(s) specifed are returned in this parameter.      D    The channels that will be queried for their gage factor settings.    |       Status                           | "         vi                               | / c       respArrayLen                     }u /         factors                          } /o        channelList                        	           0      
                 	            "100"   b    This routine sets the Poisson ratio for each channel specified in the list. The Poisson ratio is used by the voltmeter whenever Poisson measurements are made on that channel.

This setting must be done once after the instrument is powered on and before any Poisson measurements are taken on a channel.  Failure to do so will result in inaccurate data.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The poisson ratio to use when measuring poisson configurations. 

MAX = hpe1411_POIS_MAX   2.0
MIN = hpe1411_POIS_MIN   1.0e-4
     A    The channel(s) to receive the poisson ratio setting specified.           Status                           k "         vi                                /        poisson                           /A        channelList                        	           0 ?*6j@       ?6C-?333333              "100"    T    This routine queries the present Poisson ratio setting on the specified channels.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The size of the array to hold the Poisson ratios returned. 

MAX = hpe1411_RESP_ARRAY_LEN_MAX   3850
MIN = hpe1411_RESP_ARRAY_LEN_MIN   1
     S    The Poisson ratio(s) for the channel(s) specifed are returned in this parameter.      F    The channels that will be queried for their Poisson ratio settings.           Status                           { "         vi                                / c       respArrayLen                     7 /         ratios                            /o        channelList                        	           0      
                 	            "100"    0    Specifies the number of readings per trigger.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Sets the number of readings per trigger.  The allowable range is as follows. 

MAX = hpe1411_SAMP_COUN_MAX   16777215
MIN = hpe1411_SAMP_COUN_MIN   1
   ^       Status                            "         vi                               ' /        sampCoun                           	           0                      <    This routine queries the current setting of sample count.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      U    Returns the latest number of readings per trigger (values between 1 and 16777215).           Status                           s "         vi                                /         sampCoun                           	           0    	           0    Selects the pacing source for the sample rate when the sample count is greater than 1.  If immediate is specified, samples will occur as soon as possilble.  If timer is specified, then a period of time will occur between each reading.  This period of time is specified by the hpe1411_sampTim function.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Selects the pacing source to be either immediate or timer. 

 Macro Name           Value  Description
-----------------------------------------------------------
 hpe1411_SAMP_SOUR_IMM    0  Immediate
 hpe1411_SAMP_SOUR_TIM    1  Timer
          Status                            "         vi                                /         sampSour                           	           0  < Immediate hpe1411_SAMP_SOUR_IMM Timer hpe1411_SAMP_SOUR_TIM    A    This routine queries the present setting of the sample source.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Returns the presently set sample source.  This will be one of the following values. 

 Macro Name           Value  Description
-----------------------------------------------------------
 hpe1411_SAMP_SOUR_IMM    0  Immediate
 hpe1411_SAMP_SOUR_TIM    1  Timer
          Status                            "         vi                                /         sampSour                           	           0    	                Selects period (in seconds) between samples when sample count is > 1 and the sample source is set to TIMer.  If the sample source is not TIM, this value is accepted but not used.  The resolution on sample timer is 1.0e-6 seconds.

         VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Sets the period between readings in a burst of readings. 

MAX = hpe1411_SAMP_TIM_MAX   65.534e-3
MIN = hpe1411_SAMP_TIM_MIN   76.0e-6
   h       Status                           	 "         vi                               1 /        sampTim                            	           0 >tͣ]?Ƭ!?F
?              <    This routine queries the current setting of sample timer.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      *    Returns the current sample timer value.           Status                            "         vi                                /         sampTim                            	           0    	               This routine queries the selected card number for its model type.  The answer is a string such as "HEWLETT-PACKARD,E1460A,0,A.02.00".  This string is of the format "manufacturer,model,serial number,firmware revision".          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          This parameter is an integer which represents which of the switch cards connected to the voltmeter will have its type queried. 

MAX = hpe1411_SWITCH_CARD_MAX   99
MIN = hpe1411_SWITCH_CARD_MIN   1
     X    The model number description of the specified switch card is returned in this string.    |       Status                            "         vi                               E /        card                              /A        cardType                           	           0       c                 	                This routine queries the selected card number for its model description.  The answer is a string such as "Dual 32 Channel 2-Wire Relay Mux".          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          This parameter is an integer which represents which of the switch cards connected to the voltmeter will have its type queried. 

MAX = hpe1411_SWITCH_CARD_MAX   99
MIN = hpe1411_SWITCH_CARD_MIN   1
     Q    The model description of the specified switch card is returned in this string.           Status                            "         vi                                /        card                              /A        cardDesc                           	           0       c                 	           H    This selects the operational mode of the specified E1460 switch card.  For this command to work, the voltmeter must have been opened such that the switch card is part of the voltmeter virtual instrument.  See the instrument help and the hpe1411_init routine for more information regarding opening the voltmeter with switches.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      !    The handle to the instrument..          This parameter is an integer which represents which of the switch cards connected to the voltmeter will have its function changed. 

MAX = hpe1411_SWITCH_CARD_MAX   99
MIN = hpe1411_SWITCH_CARD_MIN   1
    =    
 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_ROUT_FUNC_WIRE1       0  1-Wire
 hpe1411_ROUT_FUNC_WIRE2       1  2-Wire
 hpe1411_ROUT_FUNC_WIRE2x64    2  2-WireX64
 hpe1411_ROUT_FUNC_WIRE3       3  3-Wire
 hpe1411_ROUT_FUNC_WIRE4       4  4-Wire
   ^       Status                            "         vi                               ( /        card                              /        mode                               	           0       c                            1-Wire hpe1411_ROUT_FUNC_WIRE1 2-Wire hpe1411_ROUT_FUNC_WIRE2 2-WireX64 hpe1411_ROUT_FUNC_WIRE2x64 3-Wire hpe1411_ROUT_FUNC_WIRE3 4-Wire hpe1411_ROUT_FUNC_WIRE4    \    This routine queries the current mode of the E1460 switch at the card location specified.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          This parameter is an integer which represents which of the switch cards connected to the voltmeter will have its function queried. 

MAX = hpe1411_SWITCH_CARD_MAX   99
MIN = hpe1411_SWITCH_CARD_MIN   1
        The current mode setting of the selected E1460 switch card is returned as an integer representing a setting.  The values returned are defined as macros shown below. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1411_ROUT_FUNC_WIRE1       0  1-Wire
 hpe1411_ROUT_FUNC_WIRE2       1  2-Wire
 hpe1411_ROUT_FUNC_WIRE2x64    2  2-WireX64
 hpe1411_ROUT_FUNC_WIRE3       3  3-Wire
 hpe1411_ROUT_FUNC_WIRE4       4  4-Wire
   Q       Status                            "         vi                                /        card                              /A        mode                               	           0       c                 	            C    Selects the trigger source to which the voltmeter is to respond.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Selects the trigger source, as follows. 

 Macro Name             Value  Description
-----------------------------------------------------------
 hpe1411_TRIG_SOUR_BUS      0  Bus
 hpe1411_TRIG_SOUR_EXT      1  Ext Trig BNC Connector
 hpe1411_TRIG_SOUR_HOLD     2  Hold
 hpe1411_TRIG_SOUR_IMM      3  Immediate
 hpe1411_TRIG_SOUR_TTLT0    4  TTL Trigger Line 0
 hpe1411_TRIG_SOUR_TTLT1    5  TTL Trigger Line 1
 hpe1411_TRIG_SOUR_TTLT2    6  TTL Trigger Line 2
 hpe1411_TRIG_SOUR_TTLT3    7  TTL Trigger Line 3
 hpe1411_TRIG_SOUR_TTLT4    8  TTL Trigger Line 4
 hpe1411_TRIG_SOUR_TTLT5    9  TTL Trigger Line 5
 hpe1411_TRIG_SOUR_TTLT6   10  TTL Trigger Line 6
 hpe1411_TRIG_SOUR_TTLT7   11  TTL Trigger Line 7
   ,       Status                            "         vi                                /        trigSour                           	           0             Bus hpe1411_TRIG_SOUR_BUS Ext Trig BNC Connector hpe1411_TRIG_SOUR_EXT Hold hpe1411_TRIG_SOUR_HOLD Immediate hpe1411_TRIG_SOUR_IMM TTL Trigger Line 0 hpe1411_TRIG_SOUR_TTLT0 TTL Trigger Line 1 hpe1411_TRIG_SOUR_TTLT1 TTL Trigger Line 2 hpe1411_TRIG_SOUR_TTLT2 TTL Trigger Line 3 hpe1411_TRIG_SOUR_TTLT3 TTL Trigger Line 4 hpe1411_TRIG_SOUR_TTLT4 TTL Trigger Line 5 hpe1411_TRIG_SOUR_TTLT5 TTL Trigger Line 6 hpe1411_TRIG_SOUR_TTLT6 TTL Trigger Line 7 hpe1411_TRIG_SOUR_TTLT7    B    This routine queries the current setting of the trigger source.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.         Returns an integer representing one of the following trigger sources. 

 Macro Name             Value  Description
-----------------------------------------------------------
 hpe1411_TRIG_SOUR_BUS      0  Bus
 hpe1411_TRIG_SOUR_EXT      1  Ext Trig BNC Connector
 hpe1411_TRIG_SOUR_HOLD     2  Hold
 hpe1411_TRIG_SOUR_IMM      3  Immediate
 hpe1411_TRIG_SOUR_TTLT0    4  TTL Trigger Line 0
 hpe1411_TRIG_SOUR_TTLT1    5  TTL Trigger Line 1
 hpe1411_TRIG_SOUR_TTLT2    6  TTL Trigger Line 2
 hpe1411_TRIG_SOUR_TTLT3    7  TTL Trigger Line 3
 hpe1411_TRIG_SOUR_TTLT4    8  TTL Trigger Line 4
 hpe1411_TRIG_SOUR_TTLT5    9  TTL Trigger Line 5
 hpe1411_TRIG_SOUR_TTLT6   10  TTL Trigger Line 6
 hpe1411_TRIG_SOUR_TTLT7   11  TTL Trigger Line 7
          Status                           K "         vi                               s /         trigSour                           	           0    	               Specifies the trigger count.  This is the number of "bursts" of samples that will be taken.  Normally, the voltmeter only has enough memory to store 4096 readings.  This limits the trigger count * number of samples to be <= 4096. If you require more readings than this, see the hpe1411_read_Q function for a way to get data directly from the voltmeter without storing the data into memory first.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      o    Sets the number of triggers issued. 

MAX = hpe1411_TRIG_COUN_MAX   16777215
MIN = hpe1411_TRIG_COUN_MIN   1
          Status                           U "         vi                               } /        trigCoun                           	           0                      =    This routine queries the current setting of trigger count.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      ,    Returns the number of trigger counts set.            Status                            "         vi                                /         trigCoun                           	           0    	                Sets delay period between receipt of trigger and start of measurement.  One use of this would be to specify a longer delay to give a signal extra time to settle after a relay closure before measurement.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      6    Enables (1) or disables (0) the auto delay feature.          Sets delay period between receipt of trigger and start of measurement.  This value is ignored and not used if the trigDelAuto parameter is enabled (1). 

MAX = hpe1411_TRIG_DEL_MAX   16.777215
MIN = hpe1411_TRIG_DEL_MIN   0.0
          Status                           / "         vi                               W /         autoDelay                         /K       delay                              	           0   On VI_TRUE Off VI_FALSE ?[|߾Z@0        ?6              =    This routine queries the current setting of trigger delay.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      1    Returns current setting of auto delay feature.      (    Returns current trigger delay period.           Status                            "         vi                                /         autoDelay                         /A        delay                              	           0    	            	               Enables or disables routing of the "Voltmetr Complete" signal to the specified VXIbus trigger line on the backplane P2 connector.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      _    Specifies the TTLtrg line. 

MAX = hpe1411_TTLT_LINE_MAX   7
MIN = hpe1411_TTLT_LINE_MIN   0
         OFF (0) disables or ON (1) enables "Voltmeter Complete" pulse for the specified trigger line. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
          Status                           M "         vi                               u /        ttltLine                          /]        ttltStat                           	           0                          On VI_TRUE Off VI_FALSE    :    This routine queries the current setting of outpTtltrg.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      u    Specifies the TTLTrg trigger line to be queried. 

MAX = hpe1411_TTLT_LINE_MAX   7
MIN = hpe1411_TTLT_LINE_MIN   0
     B    Returns 0 if "Voltmeter Complete" is disabled, or 1 if enabled.           Status                           e "         vi                               ō /        ttltLine                         
 /A        ttltStat                           	           0                          	            M    Sets the address of the external memory board in A24 memory address space.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          Sets A24 address of external memory card. 

MAX = hpe1411_MEM_VME_ADDR_MAX   14680056
MIN = hpe1411_MEM_VME_ADDR_MIN   2097152
   Ǳ       Status                           R "         vi                               z /        memVmeAddr                         	           0                        9    This routine queries the current setting of memVmeAddr          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      5    Returns current A24 memory address of memory card.           Status                           ʬ "         vi                                /         memVmeAddr                         	           0    	            <    Sets the size, in bytes, of the external VME memory card.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      }    Sets byte sixe of external VME memory card. 

MAX = hpe1411_MEM_VME_SIZE_MAX   12582912
MIN = hpe1411_MEM_VME_SIZE_MIN   0
          Status                           ̲ "         vi                                /        memVmeSize                         	           0                          9    This routine queries the current setting of memVmeSize          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      ?    Returns current byte size value of external VME memory card.    g       Status                            "         vi                               0 /         memVmeSize                         	           0    	            K    Enables or disables use of external VME memory card for reading storage.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      f    OFF (0) disables or ON (1) enables external VME memory card. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
   І       Status                           ' "         vi                               O /         memVmeStat                         	           0    On VI_TRUE Off VI_FALSE    9    This routine queries the current setting of memVmeStat          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      B    Returns 0 if external VME memory is disabled, or 1 if  enabled.           Status                           j "         vi                               Ӓ /         memVmeStat                         	           0    	               Turns Autozero on or off.  If 0 (OFF), then the voltmeter will make one zero measurement (with the input disabled) and subtract this value from all subsequent measurements.  If 1 (ON), the voltmeter makes a zero measurement after each reading and subtracts this "zero value" from the measurement before returning the result.  Using the AutoZero ON setting will give the most accurate measurements, but will result in slower acquisition times.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      c    OFF (0) disables or ON (1) enables autozero measurements. 

MAX = VI_TRUE   1
MIN = VI_FALSE   0
   ]       Status                            "         vi                               & /         calZeroAuto                        	           0   On VI_TRUE Off VI_FALSE    D    This routine queries the current setting of the AutoZero feature.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      /    Returns a value of either 0 (OFF) or 1 (ON).    ب       Status                           I "         vi                               q /         calZeroAuto                        	           0    	                This routine selects the line reference frequency used by the A to D converter. This function is provided for compatibility with other voltmeters which use the SYSTem:LFRequency command instead of CALibration:LFRequency command.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.     3    Indicates the desired line reference frequency; the legal values are 50 or 60. 

 Macro Name         Value  Description
-----------------------------------------------------------
 hpe1411_SYST_LFR_50   50  50
 hpe1411_SYST_LFR_60   60  60

MAX = hpe1411_SYST_LFR_MAX   60
MIN = hpe1411_SYST_LFR_MIN   50
   S       Status                            "         vi                                /        systLfr                            	           0  . 50 hpe1411_SYST_LFR_50 60 hpe1411_SYST_LFR_60        This routine queries the current setting of the reference line frequency. This function is provided for compatibility with other voltmeters which use the SYSTem:LFRequency? command instead of CALibration:LFRequency? command.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      S    Returns the current setting of the reference line frequency; either 50 or 60 Hz.    #       Status                            "         vi                                /         systLfr                            	           0    	            A    This routine returns the contents of the status byte register.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().      B    The contents of the status byte are returned in this parameter.    L       Status                            "         vi                               ' /         statusByte                         	           0    	               This function is used to determine the current condition (VI_TRUE or VI_FALSE) of a specified happening.

The happening input parameter corresponds to a valid condition value. (see the happening parameter description above for more information).

The pCondition output parameter represents the current state of a condition. It is either VI_TRUE (condition is true) or VI_FALSE (condition is not true).

Many conditions may be latched into event registers so that the setting in a event register represents the occurrence of a condition since the last query of the event register. Use the hpe1411_statEven_Q() function to detect conditions that come and go during the course of a measurement.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().     #    Conditions are transient in nature, and this function reports the current setting of the condition.

The following conditions can occur on the instrument: 

 Macro Name      Value  Description
-----------------------------------------------------------
 hpe1411_OPER_CAL  801  Calibrating
     T    VI_TRUE  = condition is currently set.
VI_FALSE = condition is currently not set.
          Status                            "         vi                                / x       happening                         /A        pCondition                         	           0               Calibrating hpe1411_OPER_CAL    	               This function indicates if an event has occurred since the last time the event was queried.  This function can be used as a history mechanism to record when an event occurred.  By repeated polling, a program can determine if or when an event occurs.

The happening input parameter corresponds to a valid happening value. (see happening section for more information).

The pEvent output parameter indicates if an event has occurred since the last time this routine was called. The output values are either VI_TRUE (event occurred since last query) or VI_FALSE (event did not occur since last query).

The event happening is automatically cleared each time the hpe1411_statEvent_Q() function is invoked.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().         Happenings refer to something that happens. These can refer to conditions or events. Some of the conditions listed in the hpe1411_statCond_Q() function will be detected as events as well.   An event may be registered when a condition changes state from  VI_FALSE to VI_TRUE.

The following events are detected by this instrument: 

 Macro Name                        Value  Description
-----------------------------------------------------------
 hpe1411_ESR_OPC                     601  Operation Complete
 hpe1411_ESR_QUERY_ERROR             603  Query Error
 hpe1411_ESR_DEVICE_DEPENDENT_ERROR  604  Device Dependent Error
 hpe1411_ESR_EXECUTION_ERROR         605  Execution Error
 hpe1411_ESR_COMMAND_ERROR           606  Command Error
     x    VI_TRUE  = event occurred sometime between event readings.
VI_FALSE = the event did not occur between event readings.
   2       Status                            "         vi                               
 /         happening                         /A        pEvent                             	           0               Operation Complete hpe1411_ESR_OPC  Query Error hpe1411_ESR_QUERY_ERROR Device Dependent Error hpe1411_ESR_DEVICE_DEPENDENT_ERROR Execution Error hpe1411_ESR_EXECUTION_ERROR Command Error hpe1411_ESR_COMMAND_ERROR    	            k    This function will clear the status system of all events.

This will not affect conditions or callbacks.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().           Status                           e "         vi                                 	           0        This function sends an IEEE Operation Complete (*OPC) to the instrument. This causes the instrument to set the hpe1411_ESR_OPC event when the pending operation completes.  See the hpe1411_statEven_Q function.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().           Status                            "         vi                                 	           0        This function sends an IEEE Operation Complete Query (*OPC?) to the instrument to aid in synchronization with other instruments or processes. When the operation completes, this function returns 1.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().          *OPC? response, always 1.           Status                            "         vi                                /         opc                                	           0    	                This function sends an IEEE Wait To Continue (*WAI) command to the instrument to aid in synchronization with other instruments or processes.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().    l       Status                           
 "         vi                                 	           0    >    This function interprets a (non-query) SCPI command string.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      l    Size of the <scpi_cmmd> array. 

MAX = hpe1411_SCPI_SIZE_MAX   2147483647
MIN = hpe1411_SCPI_SIZE_MIN   1
     8    String containing the scpi_command (null terminated).           Status                            "         vi                                /        size                             E /A        scpi_cmmd                          	           0          
           	"*RST\n"        This function interprets a query type SCPI command string, passing the query response back in the caller's <resp_string> array.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      p    Size of the <scpi_cmmd> array. 

MAX = hpe1411_SCPI_Q_SIZE_MAX   2147483647
MIN = hpe1411_SCPI_Q_SIZE_MIN   1
     8    String containing the scpi_command (null terminated).      |    Size of the <resp_string> array. 

MAX = hpe1411_SCPI_Q_RESP_SIZE_MAX   2147483647
MIN = hpe1411_SCPI_Q_RESP_SIZE_MIN   1
         String into which the response to the <scpi_cmmd> command will be placed; the size must by declared in the <resp_size> parameter.           Status                            "         vi                                / G       size                             X /         scpi_cmmd                         /&       resp_size                          /        resp_string                        	           0          
           
"*IDN?\n"          x           	           R    This function sends a device clear (DCL) to the instrument.

A device clear will abort the current operation and enable the instrument to accept a new command or query.

This is particularly useful in situations where it is not possible to determine the instrument state.  This situation may occur in an error handler.  In this case, it is customary to send a device clear before issuing a new instrument driver function.  The device clear ensures that the instrument will be able to begin processing the new commands.

Error handlers can be set up using the hpe1411_statEvenHdlr() function.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().           Status                           9 "         vi                                 	           0    }    The error message function translates the error return value from an instrument driver function to a user-readable string.      W    VI_SUCCESS           : No error
VI_ERROR_PARAMETER2  : The ViStatus error is invalid
     G    Instrument Handle returned from hpe1411_init(). This may be VI_NULL.      =    The error return value from an instrument driver function.      <    Error message string.  This is limited to 256 characters.    s       Status                            "         vi                               ! /         error                            f /A        message                            	           0    0    	           R    hpe1411_error_query returns the error numbers and corresponding error messages in the error queue of a switchbox.  See Appendix of the manual for a listing of the instrument error numbers and messages.

Instrument errors may occur when a user places the instrument in a bad state such as sending an invalid sequence of coupled commands.

Instrument errors can be detected either by polling or by callbacks.  Automatic polling can be accomplished by using the hpe1411_errorQueryDetect() function.  A callback can be set up for the any instrument errors that are detected by the status system.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().          Instrument's error code.      B    Instrument's error message.  This is limited to 256 characters.    
       Status                            "         vi                                /         error                             /A        error_message                      	           0    	            	               This function enables (VI_TRUE) or disables (VI_FALSE) automatic instrument error checking.

If automatic error checking is enabled then the driver will query the instrument for an error at the end of each function call.

Automatic error checking should only be used in a polling environment.  Automatic error checking should be disabled (VI_FALSE) when instrument error callbacks are utilized.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().     *    Boolean which enables (VI_TRUE) or disables (VI_FALSE) automatic instrument error querying. if VI_TRUE this will query the instrument for an error before returning from all driver functions.

if VI_FALSE this will not query the instrument for an error before returning from all driver functions.           Status                           u "         vi                                /         errorQueryDetect                   	           0    On VI_TRUE Off VI_FALSE    o    This function indicates if automatic instrument error detection is enabled (VI_TRUE) or disabled (VI_FALSE).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().      J    Boolean indicating if automatic instrument error querying is performed.    #       Status                            "         vi                                /         pErrDetect                         	           0    	               The reset function places the instrument in a default state. Before issuing this function, it may be necessary to send a device clear to ensure that the instrument can execute a reset.  A device clear can be issued by invoking hpe1411_dcl().

Reset will affect the following state:

Function:   VOLT:DC

Range:      8.0 V, AutoRange ON

Resolution: NPLC=1

Cal AutoZero:  ON

Resistance Offset Compensation: ON

Sample:  Source=IMMediate, Count=1

Trigger:   Source=IMMediate, Count=1, DelayAuto=ON

Output TTL Triggers:  State=OFF on all

VME Memory:  Address=0x200000, State=OFF, Size=0

Reset does not affect the status system or clear any errors.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().           Status                           B "         vi                                 	           0        The self-test function causes the instrument to perform a self-test and returns the result of that self-test.  This is used to verify that an instrument is operating properly.  A failure may indicate a potential hardware problem.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().      I    Numeric result from self-test operation.

0 = no error ( test passed)

     @    Self-test status message.  This is limited to 256 characters.           Status                            "         vi                                /         test_result                       /A        test_message                       	           0    	            	                The timeout function sets a minimum timeout value for driver I/O transactions in milliseconds. The timeout period may vary on computer platforms.

The default timeout period is 2 seconds.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().          This value sets the I/O timeout for all functions in the driver. It is specified in milliseconds. 

MAX = hpe1411_TIMEOUT_MAX   2147483647
MIN = hpe1411_TIMEOUT_MIN   0
          Status                            "         vi                                /        timeOut                            	           0                         The timeout query function returns the timeout value for driver I/O transactions in milliseconds.

The timeout period may vary on computer platforms.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().      e    This is the minimum timeout period that the driver can be set to. It is specified in milliseconds.           Status                            "         vi                                /         pTimeOut                           	           0    	            u    The revision function returns the revision of the instrument driver and the firmware of the instrument being used.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().      B    Instrument driver revision.  This is limited to 256 characters.      D    Instrument firmware revision.  This is limited to 256 characters.    !       Status                           "5 "         vi                               "o /         driver_rev                       " /A        instr_rev                          	           0    	            	           E    This routine is not for general usage.  This routine is used to actively calibrate the instrument.  This should only be done periodically and by someone who has read the service manual and is familiar with the calibration procedure for this instrument.  See the service manual for the proper usage of this command/routine.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.      G    Returns the result of the calibration.  This will be 0 if sucessful.    %O       Status                           % "         vi                               & /         result                             	           0    	           E    This routine is not for general usage.  This routine is used to actively calibrate the instrument.  This should only be done periodically and by someone who has read the service manual and is familiar with the calibration procedure for this instrument.  See the service manual for the proper usage of this command/routine.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".           The handle to the instrument.          The value being applied for the voltmeter to calibrate itself against.  This is usually and AC voltage, DC voltage, or Resistance standard. 

MAX = hpe1411_CAL_VALUE_MAX   1200000.0
MIN = hpe1411_CAL_VALUE_MIN   -305.0
   (p       Status                           ) "         vi                               )9 /        value                              	           0 @^EA2O    s                               The close function terminates the software connection to the instrument and deallocates system resources.  It is generally a good programming habit to close the instrument handle when the program is done using the instrument.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1411_error_message".      2    Instrument Handle returned from hpe1411_init().    +       Status                           , "         vi                                 	           0                  K-    init                                     "3  %     K-    measure_Q                                '!  +     K-    measTemp_Q                               -  5	     K-    measureList_Q                            9   B     K-    measTempList_Q                           F  J     K-    configure                                K  O     K-    confTemp                                 Qo  X     K-    configureList                            \   c     K-    confTempList                             g  tc     K-    conf_Q                                   v#  y     K-    strainInitList                           z  ~     K-    poissonInitList                          C       K-    strainConst_Q                              ]     K-    sample                                          K-    sample_Q                                 )       K-    trigger                                  K       K-    trigger_Q                                `  [     K-    read_Q                                   c       K-    initImm                                  k       K-    abor                                     .       K-    timedFetch_Q                             8  d     K-    trigImm                                         K-    trg                                             K-    func                                            K-    func_Q                                     !     K-    voltDcRang                                      K-    voltDcRang_Q                                    K-    voltDcRes                                   d     K-    voltDcRes_Q                                 n     K-    voltDcAper                               ,       K-    voltDcAper_Q                             M       K-    voltDcNplc                               c  	     K-    voltDcNplc_Q                                    K-    voltAcRang                                 j     K-    voltAcRang_Q                            g O     K-    voltAcRes                                     K-    voltAcRes_Q                                   K-    voltAcAper                                "     K-    voltAcAper_Q                            " ,-     K-    voltAcNplc                              - /}     K-    voltAcNplc_Q                            09 4     K-    resRang                                 6q 8V     K-    resRang_Q                               9S Fw     K-    resRes                                  K} L     K-    resRes_Q                                M O?     K-    resOcom                                 P
 Qj     K-    resOcom_Q                               R& [c     K-    resAper                                 ]! ^f     K-    resAper_Q                               _" ha     K-    resNplc                                 j kV     K-    resNplc_Q                               l nt     K-    calStrList                              o- q     K-    strUnstList_Q                           s v     K-    strUnstList                             w z     K-    strGfacList                             { ~     K-    strGfacList_Q                           ` e     K-    strPoisList                             ~      K-    strPoisList_Q                           &      K-    sampCoun                                      K-    sampCoun_Q                                    K-    sampSour                                      K-    sampSour_Q                              w      K-    sampTim                                       K-    sampTim_Q                                u     K-    systCtyp_Q                              }      K-    systCdes_Q                               A     K-    routFunc                                      K-    routFunc_Q                                    K-    trigSour                                ` b     K-    trigSour_Q                                    K-    trigCoun                                      K-    trigCoun_Q                                    K-    trigDel                                  #     K-    trigDel_Q                                 k     K-    outpTtlt_M                              Ă T     K-    outpTtlt_M_Q                            \      K-    memVmeAddr                                    K-    memVmeAddr_Q                             _     K-    memVmeSize                              & w     K-    memVmeSize_Q                            3 ѽ     K-    memVmeStat                              ҈      K-    memVmeStat_Q                            Ԙ ב     K-    calZeroAuto                             \ ٨     K-    calZeroAuto_Q                           d W     K-    systLfr                                 8 G     K-    systLfr_Q                                q     K-    readStatusByte_Q                        - M     K-    statCond_Q                              j {     K-    statEven_Q                              Q      K-    statEvenClr                                   K-    opc                                     K      K-    opc_Q                                    G     K-    wai                                           K-    scpi                                           K-    scpi_Q                                  > s     K-    dcl                                           K-    error_message                            B     K-    error_query                             
?      K-    errorQueryDetect                         P     K-    errorQueryDetect_Q                       |     K-    reset                                    [     K-    self_test                               X      K-    timeOut                                 s  [     K-    timeOut_Q                               ! #     K-    revision_query                          $ &g     K-    calAll_Q                                '# *     K-    calVal                                  * ,     K-    close                                                                      DInitialize                          High Level Control                  Measure                              DMeasure Volts and Ohms               DMeasure Temperature                 Measure Using Switches               DMeasure Strain, Volts and Ohms       DMeasure Temperature                 bConfigure Current Settings          Measurement Type                     DVolts and Ohms Setup                 DTemperature Setup                   Measurement Type Using Switches      DStrain, Volts and Ohms Setup         DTemperature Setup                    DMeasurement Type Query              Strain Initialization                DInitialize Strain Constants          DInitialize Poisson Constants         DStrain Constants Query              Sample                               DSample Setup                         DSample Query                        
Trigger                              DTrigger Setup                        DTrigger Query                        DRead using Current Settings         
Low Level Control                    DInitiate Measurement                 DAbort Measurement                    DFetch Data from Instrument           DExecute Immediate Trigger            DExecute Bus Trigger                 eConfigure                           Function                             DFunction Setup                       DFunction Query                      TDC Voltage                           DDC Voltage Range Setup               DDC Voltage Range Query               DDC Voltage Resolution Setup          DDC Voltage Resolution Query          DDC Voltage Aperture Setup            DDC Voltage Aperture Query            DDC Voltage NPLC Setup                DDC Voltage NPLC Query               AC Voltage                           DAC Voltage Range Setup               DAC Voltage Range Query               DAC Voltage Resolution Setup          DAC Voltage Resolution Query          DAC Voltage Aperture Setup            DAC Voltage Aperture Query            DAC Voltage NPLC Setup                DAC Voltage NPLC Query               )Resistance                           DResistance Range Setup               DResistance Range Query               DResistance Resolution Setup          DResistance Resolution Query          DResistance Compensation Setup        DResistance Compensation Query        DResistance Aperture Setup            DResistance Aperture Query            DResistance NPLC Setup                DResistance NPLC Query               Strain Initialization                DMeasure Unstrained Reference         DUnstrained Reference Query           DDownload Unstrained Refs.            DGage Factor Setup                    DGage Factor Query                    DPoisson Ratio Setup                  DPoisson Ratio Query                 Sample                               DSample Count Setup                   DSample Count Query                   DSample Source Setup                  DSample Source Query                  DSample Timer Setup                   DSample Timer Query                  Switch Card Properties               DSwitch Type Query                    DSwitch Description Query             DE1460 Function Setup                 DE1460 Function Query                -Trigger                              DTrigger Source Setup                 DTrigger Source Query                 DTrigger Count Setup                  DTrigger Count Query                  DTrigger Delay Setup                  DTrigger Delay Query                 Trigger Output                       DTrigger Output Setup                 DTrigger Output Query                jVME Memory                           DVME Memory Address Setup             DVME Memory Address Query             DVME Memory Size Setup                DVME Memory Size Query                DVME Memory State Setup               DVME Memory State Query              Calibration                          DAutozero State Setup                 DAutozero State Query                 DLine Freq Calibration Setup          DLine Freq Calibration Query         Status                               DRead Status Byte                     DCondition Query                     WEvent                                DEvent Query                          DClear All Events                    Synchronization                      DOperation Complete                   DOperation Complete Query             DWait To Continue                    Utility                             ]SCPI Command Interpretor             DSCPI Non-Query Command               DSCPI Query Command                   DDevice Clear                        Error Handling                       DDriver Error Message Query           DQuery Instrument for Error          2Auto Instrument Error Detection      DAuto Error Detection Setup           DAuto Error Detection Query           DReset                                DSelf Test                           Time Out                             DTime Out Setup                       DTime Out Query                       DRevision Query                      Service Recalibration                DCalibrate All Query                  DCalibration Value Setting            DClose                           