/* Copyright (C) 1995-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1411*/

#ifndef hpe1411_INCLUDE 
#define hpe1411_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif


/*================================*/
/*           HPE1411              */
/*================================*/
/* WIN95/NT Framework Rev: 3.0    */
/* Driver Revision:    A.02.10    */
/* Firmware Revision:  A.08.00    */
/*                     G.08.00    */
/*================================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1411.c                 */
/*   hpe1411.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   hpe1411.def               */
/*   hpe1411.mak               */
/*   hpe1411.bas               */
/*=============================*/

/******  Returned error status values *****/
/* HP Common Error numbers start at BFFC0D00 */
#define hpe1411_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1411_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1411_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1411_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1411_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1411_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1411_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */
#define hpe1411_INSTR_ERROR_OVERLOAD      (_VI_ERROR+0x3FFC0D08L) /* 0xBFFC0D08 */

/* Parameter errors not in VPP 3.4 */
#define hpe1411_INSTR_ERROR_PARAMETER9	(_VI_ERROR+0x3FFC0D20L)/* 0xBFFC0D20 */
#define hpe1411_INSTR_ERROR_PARAMETER10	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D21 */
#define hpe1411_INSTR_ERROR_PARAMETER11	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D22 */
#define hpe1411_INSTR_ERROR_PARAMETER12	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D23 */
#define hpe1411_INSTR_ERROR_PARAMETER13	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D24 */
#define hpe1411_INSTR_ERROR_PARAMETER14	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D25 */
#define hpe1411_INSTR_ERROR_PARAMETER15	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D26 */
#define hpe1411_INSTR_ERROR_PARAMETER16	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D27 */
#define hpe1411_INSTR_ERROR_PARAMETER17	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D28 */
#define hpe1411_INSTR_ERROR_PARAMETER18	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D29 */

#define hpe1411_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define hpe1411_STB_MAV				5 

#define hpe1411_ESR_OPC				601
#define hpe1411_ESR_QUERY_ERROR			603
#define hpe1411_ESR_DEVICE_DEPENDENT_ERROR		604
#define hpe1411_ESR_EXECUTION_ERROR			605
#define hpe1411_ESR_COMMAND_ERROR			606

#define hpe1411_OPER_CAL				801

/******   Used by Function hpe1411_timeOut   *****/
#define  hpe1411_TIMEOUT_MAX  2147483647
#define  hpe1411_TIMEOUT_MIN  0

/* slightly less than (maximum 32 bit integer) / 8; arbitrarily big */     
#define hpe1411_MAX_RDGS64	268400000

#define SWAP_FLOAT64(dest) \
 { unsigned char    src[8];                                        \
      *((double *)src) = *((double *)dest);                        \
      ((unsigned char *)(dest))[0] =  ((unsigned char*)(src))[7];  \
      ((unsigned char *)(dest))[1] =  ((unsigned char*)(src))[6];  \
      ((unsigned char *)(dest))[2] =  ((unsigned char*)(src))[5];  \
      ((unsigned char *)(dest))[3] =  ((unsigned char*)(src))[4];  \
      ((unsigned char *)(dest))[4] =  ((unsigned char*)(src))[3];  \
      ((unsigned char *)(dest))[5] =  ((unsigned char*)(src))[2];  \
      ((unsigned char *)(dest))[6] =  ((unsigned char*)(src))[1];  \
      ((unsigned char *)(dest))[7] =  ((unsigned char*)(src))[0];  \
 }

ViStatus _VI_FUNC hpe1411_findRsrc (
  ViInt16 arraySize,
  char rsrcList[][80],
  ViRsrc rsrcDesc,
  ViPInt16 matches );

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC hpe1411_init (ViRsrc InstrDesc, ViBoolean id_query,
                            ViBoolean do_reset, ViPSession vi );


ViStatus _VI_FUNC hpe1411_scpi(ViSession vi,
                               ViInt32 size,
                               ViString scpi_cmmd );

ViStatus _VI_FUNC hpe1411_scpi_Q(ViSession vi,
                                 ViInt32 size,
                                 ViString scpi_cmmd,
                                 ViInt32 resp_size,
                                 ViChar _VI_FAR resp_string[] );


ViStatus _VI_FUNC hpe1411_close (ViSession vi);

ViStatus _VI_FUNC hpe1411_reset (ViSession vi);

ViStatus _VI_FUNC hpe1411_self_test (ViSession vi, ViPInt16 test_result,
                                 ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC hpe1411_error_query (ViSession vi, ViPInt32 error_number,
                                   ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1411_error_message (ViSession vi, ViStatus error_number,
                                     ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1411_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
                                      ViChar _VI_FAR instr_rev[]);

/* HP other standard functions */

ViStatus _VI_FUNC hpe1411_dcl(ViSession vi);

ViStatus _VI_FUNC hpe1411_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC hpe1411_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC hpe1411_opc(ViSession vi);

ViStatus _VI_FUNC hpe1411_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC hpe1411_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC hpe1411_statCond_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pCondition);

ViStatus _VI_FUNC hpe1411_statEvenClr(ViSession vi);

ViStatus _VI_FUNC hpe1411_statEven_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  hpe1411_InstrEventHandler)(
        ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC hpe1411_statEvenHdlr(ViSession vi, ViInt32 happening,       
                                   hpe1411_InstrEventHandler eventHandler,
                                   ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR hpe1411_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC hpe1411_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     hpe1411_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC hpe1411_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC hpe1411_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC hpe1411_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC hpe1411_trg(ViSession vi);

ViStatus _VI_FUNC hpe1411_wai(ViSession vi);


/* Instr Specific Functions follow */


/******   Used by Function hpe1411_calLfr   *****/
#define  hpe1411_CAL_LFR_MAX  60
#define  hpe1411_CAL_LFR_MIN  50
#define  hpe1411_CAL_LFR_50  50
#define  hpe1411_CAL_LFR_60  60


/******   Used by Function hpe1411_calVal   *****/
#define  hpe1411_CAL_VALUE_MAX  1200000.0
#define  hpe1411_CAL_VALUE_MIN  -305.0


/******   Used by Function hpe1411_confTemp   *****/
#define  hpe1411_TRANS_FRTD_385  0
#define  hpe1411_TRANS_FRTD_392  1
#define  hpe1411_TRANS_FTHERM_2252  2
#define  hpe1411_TRANS_FTHERM_5000  3
#define  hpe1411_TRANS_FTHERM_10000  4


/******   Used by Function hpe1411_confTempList   *****/
/*  hpe1411_TRANS_FRTD_385  */
/*  hpe1411_TRANS_FRTD_392  */
/*  hpe1411_TRANS_FTHERM_2252  */
/*  hpe1411_TRANS_FTHERM_5000  */
/*  hpe1411_TRANS_FTHERM_10000  */
#define  hpe1411_TRANS_RTD_385  5
#define  hpe1411_TRANS_RTD_392  6
#define  hpe1411_TRANS_THERM_2252  7
#define  hpe1411_TRANS_THERM_5000  8
#define  hpe1411_TRANS_THERM_10000  9
#define  hpe1411_TRANS_TC_B  10
#define  hpe1411_TRANS_TC_E  11
#define  hpe1411_TRANS_TC_J  12
#define  hpe1411_TRANS_TC_K  13
#define  hpe1411_TRANS_TC_N14  14
#define  hpe1411_TRANS_TC_N28  15
#define  hpe1411_TRANS_TC_R  16
#define  hpe1411_TRANS_TC_S  17
#define  hpe1411_TRANS_TC_T  18


/******   Used by Function hpe1411_conf_Q   *****/
#define  hpe1411_CONFQ_FRES  0
#define  hpe1411_CONFQ_VOLT_AC  1
#define  hpe1411_CONFQ_VOLT_DC  2
#define  hpe1411_CONFQ_RES  3
#define  hpe1411_CONFQ_STR_QUAR  4
#define  hpe1411_CONFQ_STR_HBEN  5
#define  hpe1411_CONFQ_STR_HPO  6
#define  hpe1411_CONFQ_STR_FBEN  7
#define  hpe1411_CONFQ_STR_FPO  8
#define  hpe1411_CONFQ_STR_FBP  9
#define  hpe1411_CONFQ_STR_QTEN  10
#define  hpe1411_CONFQ_STR_QCOM  11
#define  hpe1411_CONFQ_STR_UNST  12
#define  hpe1411_CONFQ_TEMP  13
/*  hpe1411_TRANS_FRTD_385  */
/*  hpe1411_TRANS_FRTD_392  */
/*  hpe1411_TRANS_FTHERM_2252  */
/*  hpe1411_TRANS_FTHERM_5000  */
/*  hpe1411_TRANS_FTHERM_10000  */
/*  hpe1411_TRANS_RTD_385  */
/*  hpe1411_TRANS_RTD_392  */
/*  hpe1411_TRANS_THERM_2252  */
/*  hpe1411_TRANS_THERM_5000  */
/*  hpe1411_TRANS_THERM_10000  */
/*  hpe1411_TRANS_TC_B  */
/*  hpe1411_TRANS_TC_E  */
/*  hpe1411_TRANS_TC_J  */
/*  hpe1411_TRANS_TC_K  */
/*  hpe1411_TRANS_TC_N14  */
/*  hpe1411_TRANS_TC_N28  */
/*  hpe1411_TRANS_TC_R  */
/*  hpe1411_TRANS_TC_S  */
/*  hpe1411_TRANS_TC_T  */


/******   Used by Function hpe1411_configure   *****/
#define  hpe1411_CONF_FRES  0
#define  hpe1411_CONF_VOLT_AC  1
#define  hpe1411_CONF_VOLT_DC  2


/******   Used by Function hpe1411_configureList   *****/
#define  hpe1411_CONF_LIST_FRES  0
#define  hpe1411_CONF_LIST_VOLT_AC  1
#define  hpe1411_CONF_LIST_VOLT_DC  2
#define  hpe1411_CONF_LIST_RES  3
#define  hpe1411_CONF_LIST_STR_QUAR  4
#define  hpe1411_CONF_LIST_STR_HBEN  5
#define  hpe1411_CONF_LIST_STR_HPO  6
#define  hpe1411_CONF_LIST_STR_FBEN  7
#define  hpe1411_CONF_LIST_STR_FPO  8
#define  hpe1411_CONF_LIST_STR_FBP  9
#define  hpe1411_CONF_LIST_STR_QTEN  10
#define  hpe1411_CONF_LIST_STR_QCOM  11
#define  hpe1411_CONF_LIST_STR_UNST  12


/******   Used by Function hpe1411_fetc_Q   *****/
#define  hpe1411_DATA_ARRAY_LEN_MAX  1048576
#define  hpe1411_DATA_ARRAY_LEN_MIN  1


/******   Used by Function hpe1411_func   *****/
#define  hpe1411_FUNC_FRES  0
#define  hpe1411_FUNC_VOLT_AC  1
#define  hpe1411_FUNC_VOLT_DC  2


/******   Used by Function hpe1411_func_Q   *****/
/*  hpe1411_FUNC_FRES  */
/*  hpe1411_FUNC_VOLT_AC  */
/*  hpe1411_FUNC_VOLT_DC  */


/******   Used by Function hpe1411_measTempList_Q   *****/
/*  hpe1411_TRANS_FRTD_385  */
/*  hpe1411_TRANS_FRTD_392  */
/*  hpe1411_TRANS_FTHERM_2252  */
/*  hpe1411_TRANS_FTHERM_5000  */
/*  hpe1411_TRANS_FTHERM_10000  */
/*  hpe1411_TRANS_RTD_385  */
/*  hpe1411_TRANS_RTD_392  */
/*  hpe1411_TRANS_THERM_2252  */
/*  hpe1411_TRANS_THERM_5000  */
/*  hpe1411_TRANS_THERM_10000  */
/*  hpe1411_TRANS_TC_B  */
/*  hpe1411_TRANS_TC_E  */
/*  hpe1411_TRANS_TC_J  */
/*  hpe1411_TRANS_TC_K  */
/*  hpe1411_TRANS_TC_N14  */
/*  hpe1411_TRANS_TC_N28  */
/*  hpe1411_TRANS_TC_R  */
/*  hpe1411_TRANS_TC_S  */
/*  hpe1411_TRANS_TC_T  */
/*  hpe1411_DATA_ARRAY_LEN_MAX  */
/*  hpe1411_DATA_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_measTemp_Q   *****/
/*  hpe1411_TRANS_FRTD_385  */
/*  hpe1411_TRANS_FRTD_392  */
/*  hpe1411_TRANS_FTHERM_2252  */
/*  hpe1411_TRANS_FTHERM_5000  */
/*  hpe1411_TRANS_FTHERM_10000  */


/******   Used by Function hpe1411_measureList_Q   *****/
/*  hpe1411_CONF_LIST_FRES  */
/*  hpe1411_CONF_LIST_VOLT_AC  */
/*  hpe1411_CONF_LIST_VOLT_DC  */
/*  hpe1411_CONF_LIST_RES  */
/*  hpe1411_CONF_LIST_STR_QUAR  */
/*  hpe1411_CONF_LIST_STR_HBEN  */
/*  hpe1411_CONF_LIST_STR_HPO  */
/*  hpe1411_CONF_LIST_STR_FBEN  */
/*  hpe1411_CONF_LIST_STR_FPO  */
/*  hpe1411_CONF_LIST_STR_FBP  */
/*  hpe1411_CONF_LIST_STR_QTEN  */
/*  hpe1411_CONF_LIST_STR_QCOM  */
/*  hpe1411_CONF_LIST_STR_UNST  */
/*  hpe1411_DATA_ARRAY_LEN_MAX  */
/*  hpe1411_DATA_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_measure_Q   *****/
/*  hpe1411_CONF_FRES  */
/*  hpe1411_CONF_VOLT_AC  */
/*  hpe1411_CONF_VOLT_DC  */


/******   Used by Function hpe1411_memVmeAddr   *****/
#define  hpe1411_MEM_VME_ADDR_MAX  14680056
#define  hpe1411_MEM_VME_ADDR_MIN  2097152


/******   Used by Function hpe1411_memVmeSize   *****/
#define  hpe1411_MEM_VME_SIZE_MAX  12582912
#define  hpe1411_MEM_VME_SIZE_MIN  0


/******   Used by Function hpe1411_outpTtlt_M   *****/
#define  hpe1411_TTLT_LINE_MAX  7
#define  hpe1411_TTLT_LINE_MIN  0


/******   Used by Function hpe1411_outpTtlt_M_Q   *****/
/*  hpe1411_TTLT_LINE_MAX  */
/*  hpe1411_TTLT_LINE_MIN  */


/******   Used by Function hpe1411_poissonInitList   *****/
#define  hpe1411_GFAC_MAX  1.0e3
#define  hpe1411_GFAC_MIN  1.0e-9
#define  hpe1411_POIS_MAX  2.0
#define  hpe1411_POIS_MIN  1.0e-4


/******   Used by Function hpe1411_read_Q   *****/
/*  hpe1411_DATA_ARRAY_LEN_MAX  */
/*  hpe1411_DATA_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_resAper   *****/
#define  hpe1411_APER_MAX  320.0e-3
#define  hpe1411_APER_MIN  9.9999e-6


/******   Used by Function hpe1411_resNplc   *****/
#define  hpe1411_NPLC_MAX  16.0
#define  hpe1411_NPLC_MIN  0.0005


/******   Used by Function hpe1411_resRang   *****/
#define  hpe1411_RES_RANG_MAX  1048576.0
#define  hpe1411_RES_RANG_MIN  0.0
#define  hpe1411_RES_RANG_250  255.0
#define  hpe1411_RES_RANG_2K   2047.0
#define  hpe1411_RES_RANG_16K  16383.0
#define  hpe1411_RES_RANG_131K  131071.0
#define  hpe1411_RES_RANG_1M  1048575


/******   Used by Function hpe1411_resRes   *****/
#define  hpe1411_RES_RES_MAX  64.0
#define  hpe1411_RES_RES_MIN  61.0e-6
#define  hpe1411_RES_RES_61U  61.05e-6
#define  hpe1411_RES_RES_244U  244.2e-6
#define  hpe1411_RES_RES_488U  488.3e-6
#define  hpe1411_RES_RES_1_MILLI  976.6e-6
#define  hpe1411_RES_RES_2_MILLI  1.954e-3
#define  hpe1411_RES_RES_4_MILLI  3.91e-3
#define  hpe1411_RES_RES_8_MILLI  7.813e-3
#define  hpe1411_RES_RES_16_MILLI  15.63e-3
#define  hpe1411_RES_RES_32_MILLI  31.3e-3
#define  hpe1411_RES_RES_63_MILLI  62.51e-3
#define  hpe1411_RES_RES_125_MILLI  125.1e-3
#define  hpe1411_RES_RES_250_MILLI  250.1e-3
#define  hpe1411_RES_RES_500_MILLI  500.1e-3
#define  hpe1411_RES_RES_1  1.01
#define  hpe1411_RES_RES_4  4.01
#define  hpe1411_RES_RES_8  8.01
#define  hpe1411_RES_RES_32  32.01
#define  hpe1411_RES_RES_64  64.0


/******   Used by Function hpe1411_routFunc   *****/
#define  hpe1411_SWITCH_CARD_MAX  99
#define  hpe1411_SWITCH_CARD_MIN  1
#define  hpe1411_ROUT_FUNC_WIRE1  0
#define  hpe1411_ROUT_FUNC_WIRE2  1
#define  hpe1411_ROUT_FUNC_WIRE2x64  2
#define  hpe1411_ROUT_FUNC_WIRE3  3
#define  hpe1411_ROUT_FUNC_WIRE4  4
#define  hpe1411_ROUT_FUNC_WIRE1X2 5
#define  hpe1411_ROUT_FUNC_WIRE1X4 6
#define  hpe1411_ROUT_FUNC_WIRE1X8 7
#define  hpe1411_ROUT_FUNC_WIRE2x2 8
#define  hpe1411_ROUT_FUNC_WIRE2x4 9
#define  hpe1411_ROUT_FUNC_WIRE2x8 10
#define  hpe1411_ROUT_FUNC_WIRE4X2 11
#define  hpe1411_ROUT_FUNC_WIRE4X4 12
#define  hpe1411_ROUT_FUNC_NONE    13


/******   Used by Function hpe1411_routFunc_Q   *****/
/*  hpe1411_SWITCH_CARD_MAX  */
/*  hpe1411_SWITCH_CARD_MIN  */
/*  hpe1411_ROUT_FUNC_WIRE1  */
/*  hpe1411_ROUT_FUNC_WIRE2  */
/*  hpe1411_ROUT_FUNC_WIRE2x64  */
/*  hpe1411_ROUT_FUNC_WIRE3  */
/*  hpe1411_ROUT_FUNC_WIRE4  */
/*  hpe1411_ROUT_FUNC_WIRE1X2 */
/*  hpe1411_ROUT_FUNC_WIRE1X4 */
/*  hpe1411_ROUT_FUNC_WIRE1X8 */
/*  hpe1411_ROUT_FUNC_WIRE2x2 */
/*  hpe1411_ROUT_FUNC_WIRE2x4 */
/*  hpe1411_ROUT_FUNC_WIRE2x8 */
/*  hpe1411_ROUT_FUNC_WIRE4X2 */
/*  hpe1411_ROUT_FUNC_WIRE4X4 */
/*  hpe1411_ROUT_FUNC_NONE    */


/******   Used by Function hpe1411_sampCoun   *****/
#define  hpe1411_SAMP_COUN_MAX  16777215
#define  hpe1411_SAMP_COUN_MIN  1


/******   Used by Function hpe1411_sampSour   *****/
#define  hpe1411_SAMP_SOUR_IMM  0
#define  hpe1411_SAMP_SOUR_TIM  1


/******   Used by Function hpe1411_sampSour_Q   *****/
/*  hpe1411_SAMP_SOUR_IMM  */
/*  hpe1411_SAMP_SOUR_TIM  */


/******   Used by Function hpe1411_sampTim   *****/
#define  hpe1411_SAMP_TIM_MAX  65.534e-3
#define  hpe1411_SAMP_TIM_MIN  76.0e-6


/******   Used by Function hpe1411_sample   *****/
/*  hpe1411_SAMP_COUN_MAX  */
/*  hpe1411_SAMP_COUN_MIN  */
/*  hpe1411_SAMP_SOUR_IMM  */
/*  hpe1411_SAMP_SOUR_TIM  */
/*  hpe1411_SAMP_TIM_MAX  */
/*  hpe1411_SAMP_TIM_MIN  */


/******   Used by Function hpe1411_sample_Q   *****/
/*  hpe1411_SAMP_SOUR_IMM  */
/*  hpe1411_SAMP_SOUR_TIM  */


/******   Used by Function hpe1411_strGfacList   *****/
/*  hpe1411_GFAC_MAX  */
/*  hpe1411_GFAC_MIN  */


/******   Used by Function hpe1411_strGfacList_Q   *****/
#define  hpe1411_RESP_ARRAY_LEN_MAX  3850
#define  hpe1411_RESP_ARRAY_LEN_MIN  1


/******   Used by Function hpe1411_strPoisList   *****/
/*  hpe1411_POIS_MAX  */
/*  hpe1411_POIS_MIN  */


/******   Used by Function hpe1411_strPoisList_Q   *****/
/*  hpe1411_RESP_ARRAY_LEN_MAX  */
/*  hpe1411_RESP_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_strUnstList   *****/
#define  hpe1411_UNST_REF_MAX  300.0
#define  hpe1411_UNST_REF_MIN  -300.0


/******   Used by Function hpe1411_strUnstList_Q   *****/
/*  hpe1411_RESP_ARRAY_LEN_MAX  */
/*  hpe1411_RESP_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_strainConst_Q   *****/
/*  hpe1411_RESP_ARRAY_LEN_MAX  */
/*  hpe1411_RESP_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_strainInitList   *****/
/*  hpe1411_GFAC_MAX  */
/*  hpe1411_GFAC_MIN  */


/******   Used by Function hpe1411_systCdes_Q   *****/
/*  hpe1411_SWITCH_CARD_MAX  */
/*  hpe1411_SWITCH_CARD_MIN  */


/******   Used by Function hpe1411_systCtyp_Q   *****/
/*  hpe1411_SWITCH_CARD_MAX  */
/*  hpe1411_SWITCH_CARD_MIN  */


/******   Used by Function hpe1411_systLfr   *****/
#define  hpe1411_SYST_LFR_MAX  60
#define  hpe1411_SYST_LFR_MIN  50
#define  hpe1411_SYST_LFR_50  50
#define  hpe1411_SYST_LFR_60  60


/******   Used by Function hpe1411_timedFetch_Q   *****/
#define  hpe1411_TIMEOUT_MAX  2147483647
#define  hpe1411_TIMEOUT_MIN  0
/*  hpe1411_DATA_ARRAY_LEN_MAX  */
/*  hpe1411_DATA_ARRAY_LEN_MIN  */


/******   Used by Function hpe1411_trigCoun   *****/
#define  hpe1411_TRIG_COUN_MAX  16777215
#define  hpe1411_TRIG_COUN_MIN  1


/******   Used by Function hpe1411_trigDel   *****/
#define  hpe1411_TRIG_DEL_MAX  16.777215
#define  hpe1411_TRIG_DEL_MIN  0.0


/******   Used by Function hpe1411_trigSour   *****/
#define  hpe1411_TRIG_SOUR_BUS  0
#define  hpe1411_TRIG_SOUR_EXT  1
#define  hpe1411_TRIG_SOUR_HOLD  2
#define  hpe1411_TRIG_SOUR_IMM  3
#define  hpe1411_TRIG_SOUR_TTLT0  4
#define  hpe1411_TRIG_SOUR_TTLT1  5
#define  hpe1411_TRIG_SOUR_TTLT2  6
#define  hpe1411_TRIG_SOUR_TTLT3  7
#define  hpe1411_TRIG_SOUR_TTLT4  8
#define  hpe1411_TRIG_SOUR_TTLT5  9
#define  hpe1411_TRIG_SOUR_TTLT6  10
#define  hpe1411_TRIG_SOUR_TTLT7  11


/******   Used by Function hpe1411_trigSour_Q   *****/
/*  hpe1411_TRIG_SOUR_BUS  */
/*  hpe1411_TRIG_SOUR_EXT  */
/*  hpe1411_TRIG_SOUR_HOLD  */
/*  hpe1411_TRIG_SOUR_IMM  */
/*  hpe1411_TRIG_SOUR_TTLT0  */
/*  hpe1411_TRIG_SOUR_TTLT1  */
/*  hpe1411_TRIG_SOUR_TTLT2  */
/*  hpe1411_TRIG_SOUR_TTLT3  */
/*  hpe1411_TRIG_SOUR_TTLT4  */
/*  hpe1411_TRIG_SOUR_TTLT5  */
/*  hpe1411_TRIG_SOUR_TTLT6  */
/*  hpe1411_TRIG_SOUR_TTLT7  */


/******   Used by Function hpe1411_trigger   *****/
/*  hpe1411_TRIG_COUN_MAX  */
/*  hpe1411_TRIG_COUN_MIN  */
/*  hpe1411_TRIG_DEL_MAX  */
/*  hpe1411_TRIG_DEL_MIN  */
/*  hpe1411_TRIG_SOUR_BUS  */
/*  hpe1411_TRIG_SOUR_EXT  */
/*  hpe1411_TRIG_SOUR_HOLD  */
/*  hpe1411_TRIG_SOUR_IMM  */
/*  hpe1411_TRIG_SOUR_TTLT0  */
/*  hpe1411_TRIG_SOUR_TTLT1  */
/*  hpe1411_TRIG_SOUR_TTLT2  */
/*  hpe1411_TRIG_SOUR_TTLT3  */
/*  hpe1411_TRIG_SOUR_TTLT4  */
/*  hpe1411_TRIG_SOUR_TTLT5  */
/*  hpe1411_TRIG_SOUR_TTLT6  */
/*  hpe1411_TRIG_SOUR_TTLT7  */


/******   Used by Function hpe1411_trigger_Q   *****/
/*  hpe1411_TRIG_SOUR_BUS  */
/*  hpe1411_TRIG_SOUR_EXT  */
/*  hpe1411_TRIG_SOUR_HOLD  */
/*  hpe1411_TRIG_SOUR_IMM  */
/*  hpe1411_TRIG_SOUR_TTLT0  */
/*  hpe1411_TRIG_SOUR_TTLT1  */
/*  hpe1411_TRIG_SOUR_TTLT2  */
/*  hpe1411_TRIG_SOUR_TTLT3  */
/*  hpe1411_TRIG_SOUR_TTLT4  */
/*  hpe1411_TRIG_SOUR_TTLT5  */
/*  hpe1411_TRIG_SOUR_TTLT6  */
/*  hpe1411_TRIG_SOUR_TTLT7  */


/******   Used by Function hpe1411_voltAcAper   *****/
/*  hpe1411_APER_MAX  */
/*  hpe1411_APER_MIN  */


/******   Used by Function hpe1411_voltAcNplc   *****/
/*  hpe1411_NPLC_MAX  */
/*  hpe1411_NPLC_MIN  */


/******   Used by Function hpe1411_voltAcRang   *****/
#define  hpe1411_VOLT_AC_RANG_MAX  300.0
#define  hpe1411_VOLT_AC_RANG_MIN  0.0
#define  hpe1411_VOLT_AC_RANG_87MV  0.0874
#define  hpe1411_VOLT_AC_RANG_700MV  0.699
#define  hpe1411_VOLT_AC_RANG_5V  5.599
#define  hpe1411_VOLT_AC_RANG_44V  44.79
#define  hpe1411_VOLT_AC_RANG_300V  299.9


/******   Used by Function hpe1411_voltAcRes   *****/
#define  hpe1411_VOLT_RES_MAX  10.0
#define  hpe1411_VOLT_RES_MIN  29.81e-9
#define  hpe1411_VOLT_RES_30_NANO  29.81e-9
#define  hpe1411_VOLT_RES_120_NANO  119.3e-9
#define  hpe1411_VOLT_RES_238_NANO  238.5e-9
#define  hpe1411_VOLT_RES_477_NANO  477.0e-9
#define  hpe1411_VOLT_RES_954_NANO  954.0e-9
#define  hpe1411_VOLT_RES_2_MICRO  1.91e-6
#define  hpe1411_VOLT_RES_4_MICRO  3.815e-6
#define  hpe1411_VOLT_RES_8_MICRO  7.63e-6
#define  hpe1411_VOLT_RES_15_MICRO  15.26e-6
#define  hpe1411_VOLT_RES_30_MICRO  30.52e-6
#define  hpe1411_VOLT_RES_61_MICRO  61.04-6
#define  hpe1411_VOLT_RES_122_MICRO  122.1e-6
#define  hpe1411_VOLT_RES_244_MICRO  244.15e-6
#define  hpe1411_VOLT_RES_488_MICRO  488.3e-6
#define  hpe1411_VOLT_RES_2_MILLI  1.954e-3
#define  hpe1411_VOLT_RES_4_MILLI  3.91e-3
#define  hpe1411_VOLT_RES_16_MILLI  15.626e-3
#define  hpe1411_VOLT_RES_32_MILLI  33.3e-3


/******   Used by Function hpe1411_voltDcAper   *****/
/*  hpe1411_APER_MAX  */
/*  hpe1411_APER_MIN  */


/******   Used by Function hpe1411_voltDcNplc   *****/
/*  hpe1411_NPLC_MAX  */
/*  hpe1411_NPLC_MIN  */


/******   Used by Function hpe1411_voltDcRang   *****/
#define  hpe1411_VOLT_DC_RANG_MAX  300.0
#define  hpe1411_VOLT_DC_RANG_MIN  -300.0
#define  hpe1411_VOLT_DC_RANG_125MV  125.0e-3
#define  hpe1411_VOLT_DC_RANG_1V  1.0
#define  hpe1411_VOLT_DC_RANG_8V  8.0
#define  hpe1411_VOLT_DC_RANG_64V  64.0
#define  hpe1411_VOLT_DC_RANG_300V  300.0


/******   Used by Function hpe1411_voltDcRang_Q   *****/
/*  hpe1411_VOLT_DC_RANG_125MV  */
/*  hpe1411_VOLT_DC_RANG_1V  */
/*  hpe1411_VOLT_DC_RANG_8V  */
/*  hpe1411_VOLT_DC_RANG_64V  */
/*  hpe1411_VOLT_DC_RANG_300V  */


/******   Used by Function hpe1411_voltDcRes   *****/
/*  hpe1411_VOLT_RES_MAX  */
/*  hpe1411_VOLT_RES_MIN  */
/*  hpe1411_VOLT_RES_30_NANO  */
/*  hpe1411_VOLT_RES_120_NANO  */
/*  hpe1411_VOLT_RES_238_NANO  */
/*  hpe1411_VOLT_RES_477_NANO  */
/*  hpe1411_VOLT_RES_954_NANO  */
/*  hpe1411_VOLT_RES_2_MICRO  */
/*  hpe1411_VOLT_RES_4_MICRO  */
/*  hpe1411_VOLT_RES_8_MICRO  */
/*  hpe1411_VOLT_RES_15_MICRO  */
/*  hpe1411_VOLT_RES_30_MICRO  */
/*  hpe1411_VOLT_RES_61_MICRO  */
/*  hpe1411_VOLT_RES_122_MICRO  */
/*  hpe1411_VOLT_RES_244_MICRO  */
/*  hpe1411_VOLT_RES_488_MICRO  */
/*  hpe1411_VOLT_RES_2_MILLI  */
/*  hpe1411_VOLT_RES_4_MILLI  */
/*  hpe1411_VOLT_RES_16_MILLI  */
/*  hpe1411_VOLT_RES_32_MILLI  */

ViStatus _VI_FUNC hpe1411_abor  (ViSession vi);

ViStatus _VI_FUNC hpe1411_calAll_Q  (ViSession vi, ViPInt16 result);

ViStatus _VI_FUNC hpe1411_calLfr  (ViSession vi, ViInt16 calLfr);

ViStatus _VI_FUNC hpe1411_calLfr_Q  (ViSession vi, ViPInt16 calLfr);

ViStatus _VI_FUNC hpe1411_calStrList  (ViSession vi, ViString channelList);

ViStatus _VI_FUNC hpe1411_calVal  (ViSession vi, ViReal64 value);

ViStatus _VI_FUNC hpe1411_calZeroAuto  (ViSession vi, ViBoolean calZeroAuto);

ViStatus _VI_FUNC hpe1411_calZeroAuto_Q  (ViSession vi, ViPBoolean calZeroAuto);

ViStatus _VI_FUNC hpe1411_confFres  (ViSession vi);

ViStatus _VI_FUNC hpe1411_confTemp  (ViSession vi, ViInt16 transducer);

ViStatus _VI_FUNC hpe1411_confTempList  (ViSession vi, ViInt16 transducer, ViString channelList);

ViStatus _VI_FUNC hpe1411_confVoltAc  (ViSession vi);

ViStatus _VI_FUNC hpe1411_confVoltDc  (ViSession vi);

ViStatus _VI_FUNC hpe1411_conf_Q  (ViSession vi, ViPInt16 func, ViPBoolean autoRange, ViPReal64 range, ViPReal64 resolution, ViPInt16 transducer);

ViStatus _VI_FUNC hpe1411_configure  (ViSession vi, ViInt16 func);

ViStatus _VI_FUNC hpe1411_configureList  (ViSession vi, ViInt16 func, ViString channelList);

ViStatus _VI_FUNC hpe1411_fetc_Q  (ViSession vi, ViReal64 _VI_FAR readings[], ViInt32 dataArrayLen);

ViStatus _VI_FUNC hpe1411_func  (ViSession vi, ViInt16 func);

ViStatus _VI_FUNC hpe1411_func_Q  (ViSession vi, ViPInt16 func);

ViStatus _VI_FUNC hpe1411_initImm  (ViSession vi);

ViStatus _VI_FUNC hpe1411_measFres_Q  (ViSession vi, ViPReal64 reading);

ViStatus _VI_FUNC hpe1411_measTempList_Q  (ViSession vi, ViInt16 transducer, ViString channelList, ViReal64 _VI_FAR readings[], ViInt32 dataArrayLen);

ViStatus _VI_FUNC hpe1411_measTemp_Q  (ViSession vi, ViInt16 transducer, ViPReal64 reading);

ViStatus _VI_FUNC hpe1411_measVoltAc_Q  (ViSession vi, ViPReal64 reading);

ViStatus _VI_FUNC hpe1411_measVoltDc_Q  (ViSession vi, ViPReal64 reading);

ViStatus _VI_FUNC hpe1411_measureList_Q  (ViSession vi, ViInt16 func, ViString channelList, ViReal64 _VI_FAR readings[], ViInt32 dataArrayLen);

ViStatus _VI_FUNC hpe1411_measure_Q  (ViSession vi, ViInt16 func, ViPReal64 reading);

ViStatus _VI_FUNC hpe1411_memVmeAddr  (ViSession vi, ViInt32 memVmeAddr);

ViStatus _VI_FUNC hpe1411_memVmeAddr_Q  (ViSession vi, ViPInt32 memVmeAddr);

ViStatus _VI_FUNC hpe1411_memVmeSize  (ViSession vi, ViInt32 memVmeSize);

ViStatus _VI_FUNC hpe1411_memVmeSize_Q  (ViSession vi, ViPInt32 memVmeSize);

ViStatus _VI_FUNC hpe1411_memVmeStat  (ViSession vi, ViBoolean memVmeStat);

ViStatus _VI_FUNC hpe1411_memVmeStat_Q  (ViSession vi, ViPBoolean memVmeStat);

ViStatus _VI_FUNC hpe1411_outpTtlt_M  (ViSession vi, ViInt16 ttltLine, ViBoolean ttltStat);

ViStatus _VI_FUNC hpe1411_outpTtlt_M_Q  (ViSession vi, ViInt16 ttltLine, ViPBoolean ttltStat);

ViStatus _VI_FUNC hpe1411_poissonInitList  (ViSession vi, ViReal64 gageFactor, ViReal64 poissonRatio, ViString channelList);

ViStatus _VI_FUNC hpe1411_read_Q  (ViSession vi, ViReal64 _VI_FAR readings[], ViInt32 dataArrayLen);

ViStatus _VI_FUNC hpe1411_resAper  (ViSession vi, ViReal64 resAper);

ViStatus _VI_FUNC hpe1411_resAper_Q  (ViSession vi, ViPReal64 resAper);

ViStatus _VI_FUNC hpe1411_resNplc  (ViSession vi, ViReal64 resNplc);

ViStatus _VI_FUNC hpe1411_resNplc_Q  (ViSession vi, ViPReal64 resNplc);

ViStatus _VI_FUNC hpe1411_resOcom  (ViSession vi, ViBoolean resOcom);

ViStatus _VI_FUNC hpe1411_resOcom_Q  (ViSession vi, ViPBoolean resOcom);

ViStatus _VI_FUNC hpe1411_resRang  (ViSession vi, ViBoolean autoRange, ViReal64 range);

ViStatus _VI_FUNC hpe1411_resRang_Q  (ViSession vi, ViPBoolean autoRange, ViPReal64 range);

ViStatus _VI_FUNC hpe1411_resRes  (ViSession vi, ViReal64 resRes);

ViStatus _VI_FUNC hpe1411_resRes_Q  (ViSession vi, ViPReal64 resRes);

ViStatus _VI_FUNC hpe1411_routFunc  (ViSession vi, ViInt16 card, ViInt16 mode);

ViStatus _VI_FUNC hpe1411_routFunc_Q  (ViSession vi, ViInt16 card, ViPInt16 mode);

ViStatus _VI_FUNC hpe1411_sampCoun  (ViSession vi, ViInt32 sampCoun);

ViStatus _VI_FUNC hpe1411_sampCoun_Q  (ViSession vi, ViPInt32 sampCoun);

ViStatus _VI_FUNC hpe1411_sampSour  (ViSession vi, ViInt16 sampSour);

ViStatus _VI_FUNC hpe1411_sampSour_Q  (ViSession vi, ViPInt16 sampSour);

ViStatus _VI_FUNC hpe1411_sampTim  (ViSession vi, ViReal64 sampTim);

ViStatus _VI_FUNC hpe1411_sampTim_Q  (ViSession vi, ViPReal64 sampTim);

ViStatus _VI_FUNC hpe1411_sample  (ViSession vi, ViInt32 count, ViInt16 source, ViReal64 period);

ViStatus _VI_FUNC hpe1411_sample_Q  (ViSession vi, ViPInt32 count, ViPInt16 source, ViPReal64 period);

ViStatus _VI_FUNC hpe1411_strGfacList  (ViSession vi, ViReal64 gageFactor, ViString channelList);

ViStatus _VI_FUNC hpe1411_strGfacList_Q  (ViSession vi, ViInt16 respArrayLen, ViReal64 _VI_FAR factors[], ViString channelList);

ViStatus _VI_FUNC hpe1411_strPoisList  (ViSession vi, ViReal64 poisson, ViString channelList);

ViStatus _VI_FUNC hpe1411_strPoisList_Q  (ViSession vi, ViInt16 respArrayLen, ViReal64 _VI_FAR ratios[], ViString channelList);

ViStatus _VI_FUNC hpe1411_strUnstList  (ViSession vi, ViReal64 reference, ViString channelList);

ViStatus _VI_FUNC hpe1411_strUnstList_Q  (ViSession vi, ViInt16 respArrayLen, ViReal64 _VI_FAR reference[], ViString channelList);

ViStatus _VI_FUNC hpe1411_strainConst_Q  (ViSession vi, ViInt16 respArrayLen, ViReal64 _VI_FAR gageFact[], ViReal64 _VI_FAR poissonRatio[], ViReal64 _VI_FAR refVolt[], ViString channelList);

ViStatus _VI_FUNC hpe1411_strainInitList  (ViSession vi, ViReal64 gageFactor, ViString channelList);

ViStatus _VI_FUNC hpe1411_systCdes_Q  (ViSession vi, ViInt16 card, ViChar _VI_FAR cardDesc[]);

ViStatus _VI_FUNC hpe1411_systCtyp_Q  (ViSession vi, ViInt16 card, ViChar _VI_FAR cardType[]);

ViStatus _VI_FUNC hpe1411_systLfr  (ViSession vi, ViInt16 systLfr);

ViStatus _VI_FUNC hpe1411_systLfr_Q  (ViSession vi, ViPInt16 systLfr);

ViStatus _VI_FUNC hpe1411_timedFetch_Q  (ViSession vi, ViInt32 timeOut, ViReal64 _VI_FAR readings[], ViInt32 dataArrayLen);

ViStatus _VI_FUNC hpe1411_trigCoun  (ViSession vi, ViInt32 trigCoun);

ViStatus _VI_FUNC hpe1411_trigCoun_Q  (ViSession vi, ViPInt32 trigCoun);

ViStatus _VI_FUNC hpe1411_trigDel  (ViSession vi, ViBoolean autoDelay, ViReal64 delay);

ViStatus _VI_FUNC hpe1411_trigDel_Q  (ViSession vi, ViPBoolean autoDelay, ViPReal64 delay);

ViStatus _VI_FUNC hpe1411_trigImm  (ViSession vi);

ViStatus _VI_FUNC hpe1411_trigSour  (ViSession vi, ViInt16 trigSour);

ViStatus _VI_FUNC hpe1411_trigSour_Q  (ViSession vi, ViPInt16 trigSour);

ViStatus _VI_FUNC hpe1411_trigger  (ViSession vi, ViInt32 count, ViBoolean autoDelay, ViReal64 delay, ViInt16 source);

ViStatus _VI_FUNC hpe1411_trigger_Q  (ViSession vi, ViPInt32 count, ViPBoolean autoDelay, ViPReal64 delay, ViPInt16 source);

ViStatus _VI_FUNC hpe1411_voltAcAper  (ViSession vi, ViReal64 voltAcAper);

ViStatus _VI_FUNC hpe1411_voltAcAper_Q  (ViSession vi, ViPReal64 voltAcAper);

ViStatus _VI_FUNC hpe1411_voltAcNplc  (ViSession vi, ViReal64 voltAcNplc);

ViStatus _VI_FUNC hpe1411_voltAcNplc_Q  (ViSession vi, ViPReal64 voltAcNplc);

ViStatus _VI_FUNC hpe1411_voltAcRang  (ViSession vi, ViBoolean autoRange, ViReal64 range);

ViStatus _VI_FUNC hpe1411_voltAcRang_Q  (ViSession vi, ViPBoolean autoRange, ViPReal64 range);

ViStatus _VI_FUNC hpe1411_voltAcRes  (ViSession vi, ViReal64 voltAcRes);

ViStatus _VI_FUNC hpe1411_voltAcRes_Q  (ViSession vi, ViPReal64 voltAcRes);

ViStatus _VI_FUNC hpe1411_voltDcAper  (ViSession vi, ViReal64 voltDcAper);

ViStatus _VI_FUNC hpe1411_voltDcAper_Q  (ViSession vi, ViPReal64 voltDcAper);

ViStatus _VI_FUNC hpe1411_voltDcNplc  (ViSession vi, ViReal64 voltDcNplc);

ViStatus _VI_FUNC hpe1411_voltDcNplc_Q  (ViSession vi, ViPReal64 voltDcNplc);

ViStatus _VI_FUNC hpe1411_voltDcRang  (ViSession vi, ViBoolean autoRange, ViReal64 range);

ViStatus _VI_FUNC hpe1411_voltDcRang_Q  (ViSession vi, ViPBoolean autoRange, ViPReal64 range);

ViStatus _VI_FUNC hpe1411_voltDcRes  (ViSession vi, ViReal64 voltDcRes);

ViStatus _VI_FUNC hpe1411_voltDcRes_Q  (ViSession vi, ViPReal64 voltDcRes);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1411_INCLUDE */

