'  Sub Example2_Click ( )

'******************************************************************************
'* hp548xx Instrument Driver EXAMPLE #2 for Visual Basic                                     
'*                                                                            
'* To try this example, paste the code into the Declarations section of a form
'* and  then press F5 and click the form.
'*
'*                                                                           
'*     hp548xx_init                                                          
'*     hp548xx_close                                                         
'*     hp548xx_reset                                                         
'*     hp548xx_revision_query                                                
'*     hp548xx_timeOut                                                       
'*     hp548xx_self_test                                                     
'*     hp548xx_error_message                                                 
'*     hp548xx_error_query                                                   
'*                                                                            
'* Illustrates the use of several HP utility functions:                       
'*                                                                            
'*     hp548xx_errorQueryDetect                                              
'*          Sets the driver to check the instrument for errors.               
'*     hp548xx_cmd                                                           
'*          Sends a command string to the instrument.  In this example,       
'*          it sends a command which generates an error which then            
'*          illustrates the use of hp548xx_error_query and                   
'*          hp548xx_error_message (in the vb_err ).  It is also used     
'*          to send a command that clears event status registers.             
'*                                                                            
'* One of the most interesting things about this example is the error         
'*   detection portion, most of the second half of the program.  After        
'*   trying it out, you might think that setting errorQueryDetect to          
'*   true is a great idea!  In fact, it's not a bad idea for the hp548xx,    
'*   but beware of the potential performance impact.  With errorQueryDetect   
'*   set on, the instrument is queried at least once, if not several times,   
'*   for all functions which access the instrument.  If your application      
'*   is sensitive to performance, this might make the application too slow.   
'* One effective strategy is to create and debug your application with        
'*   errorQueryDetect set on, then remove it and leave it off for production  
'*   applications.                                                            
'*                                                                            
'******************************************************************************

Private Sub Form_Click ()

Dim errStatus     As Long
Dim vi            As Long
Dim err_msg		As String * 256
Dim inst_err_nbr	As Long
Dim inst_err_msg	As String * 256

Dim driver_rev		As String * 256
Dim instr_rev		As String * 256
Dim test_result		As Integer
Dim test_message	As String * 256


'  Initialize the instrument.
errStatus = hp548xx_init("GPIB0::7::INSTR", 1, 1, vi)

If ((errStatus < VI_SUCCESS) Or (vi = VI_NULL)) Then

	msg = "init failed with return code " & errStatus
	If (vi <> VI_NULL) Then
		errStatus = hp548xx_error_message(vi, errStatus, err_msg)
		msg = msg & ",  Error Status: " & errStatus
		msg = msg & ",  Error Message: " & err_msg
	End If
	MsgBox msg, vbInformation
	End
End If


'  Query the instrument for instrument revision and the driver for
'  driver revision, and print both.

errStatus = hp548xx_revision_query(vi, driver_rev, instr_rev)
vb_err vi, errStatus
       MsgBox driver_rev
       MsgBox instr_rev

'  Run an instrument self-test.  Print the test result (0 or an
'  instrument error number) and a message describing the error.

'  This function sets instrument timeout  to 50 seconds.
errStatus = hp548xx_timeOut(vi, 50000)
vb_err vi, errStatus

errStatus = hp548xx_self_test(vi, test_result, test_message)
vb_err vi, errStatus
       MsgBox "Error Number" & test_result
       MsgBox test_message


'  Reset the instrument.

errStatus = hp548xx_reset(vi)
vb_err vi, errStatus
'  Execute a SCPI command which is guaranteed to fail after reset.
'    Note that the driver does not query the instrument for the
'    error, and so no error is reported.  Instrument errors are
'    not reported if errorQueryDetect is set to false (the
'    default).
'  Further on in this example, errorQueryDetect is set to true and
'    the same command is run to show how to detect instrument
'    errors.

errStatus = hp548xx_cmd(vi, ":VIEW CHAN5")
vb_err vi, errStatus
'  Clear the instrument's event status registers.  This in effect
'    clears the instrument error.
'  If this is not executed, the error_QueryDetect function below
'    will report an error after it executes - the error from the
'    command executed above. 

errStatus = hp548xx_cmd(vi, "*CLS")
vb_err vi, errStatus

'  Execute a reset.  This executes *RST.
'    Note that the reset will not clear the instrument error.

errStatus = hp548xx_reset(vi)
vb_err vi, errStatus

'  Turn on error detection.  If error detection is not turned on,
'    the driver will not attempt to detect instrument errors.

errStatus = hp548xx_errorQueryDetect(vi, 1)

vb_err vi, errStatus

'  Execute a SCPI command which is guaranteed to fail after reset.
'    This will force the execution of hp548xx_error_message, which
'    returns driver errors, and hp548xx_error_query, which returns
'    instrument errors.  Both of these functions are called vb_err.

errStatus = hp548xx_cmd(vi, ":VIEW CHAN5")
vb_err vi, errStatus

msg = "Executing the :VIEW CHAN5 command after the errorQueryDetect should "
msg = msg & "return an error and pop the error off of the instrument stack"

MsgBox msg


'  Reading instrument errors pops the error queue in the instrument
'  If the instrument is queried again, the queue is empty.

errStatus = hp548xx_error_query(vi, inst_err_nbr, inst_err_msg)
vb_err vi, errStatus

msg = "A second error query call to the instrument returns no error (even "
msg = msg & "though the display still shows an error) - it was popped "
msg = msg + "the first time it was queried."
MsgBox msg, vbInformation
msg = "Instrument Error : " & inst_err_nbr & ", " & inst_err_msg

MsgBox msg						

'  Close the instrument.  Don't bother checking for errors.

errStatus = hp548xx_close(vi)
vb_err vi, errStatus

MsgBox "program complete"

End Sub							

Sub vb_err (vi As Long, errStatus As Long)

Dim inst_err 		As Long
Dim err_message 	As String * 250
Dim i 			As Long
Dim retStatus 		As Long

Dim nl
nl = Chr(10)

If VI_SUCCESS > errStatus Then

    'Send a device clear to ensure communication with 'the instrument.
    retStatus = hp548xx_dcl(vi)

    
    If (hp548xx_INSTR_ERROR_DETECTED = errStatus) Then

            'query the instrument for the error
	retStatus = hp548xx_error_query(vi, inst_err, err_message)
	retStatus = hp548xx_error_message(vi, inst_err, err_message)

            msg = "CHECK :Instrument Error :" & inst_err & nl & "Error Message = " & err_message
	MsgBox msg
    Else
            'get the driver error message
	retStatus = hp548xx_error_message(vi, errStatus, err_message)
	msg = "CHECK :Driver Error :" & errStatus & nl & "Error MEssage = " & err_message

MsgBox msg
    End If

End If
' optionally reset the instrument, close the instrument handle 

'retStatus=hp548xx_reset(vi)
'retStatus=hp548xx_close(vi)

End Sub
