/***************************************************************************** 
  Hp548xx Instrument Driver EXAMPLE #3                                       
                                                                              
  Illustrates the use of the command passthrough functions:                   
                                                                              
      hp548xx_cmd                                                            

      hp548xx_cmdReal64_Q                                                    
                                                                              
  This program  illustrates the use of the command passthrough functions       
    required for this instrument.  All of the instrument's commands, can be 
    executed using these functions.  This program gives some idea of how
    flexible they  are, and provides some techniques for programming  the 
    instrument using them.   

                                                                              
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "hp548xx.h"


void check_err (ViSession vi, ViStatus errStatus)
{
    ViInt32  inst_err;
    ViChar   err_message[256];

    if(VI_SUCCESS > errStatus)
    {
            /* Send a device clear to ensure communication with			*/
            /*   the instrument											*/

        hp548xx_dcl(vi);


            /* If the driver is set to detect instrument errors,		*/
            /*   and an instrument error is detected, the error			*/
            /*   code is hp548xx_INSTR_ERROR_DETECTED (see				*/
            /*   hp548xx.h).  In this case, query the instrument		*/
            /*   for the error and display it.							*/
            /* Otherwise, the error is a driver error.  Query the		*/
            /*   driver for the error and display it.					*/

        if(hp548xx_INSTR_ERROR_DETECTED == errStatus)	
        {
            hp548xx_error_query(vi, &inst_err, err_message); 
            hp548xx_error_message(vi, inst_err, err_message); 
            printf("Instrument Error : %ld, %s\n", inst_err, err_message); 
        }
        else
        {
            hp548xx_error_message(vi, errStatus, err_message); 
            printf("Driver Error : %ld, %s\n", errStatus, err_message);
        }

            /* Optionally reset the instrument, close the				*/
            /*   instrument handle, and exit the program				*/
    /* hp548xx_reset(vi);	*/
    /* hp548xx_close(vi);	*/
    /* exit(errStatus);		*/
   }
return;
}    

void main ( )
{

ViStatus    err_status;
ViSession   vi;
ViChar      err_msg[256];
ViReal64    meas_val;

/*  Initialize the instrument.  Note that this function will verify		*/
/*  that the instrument specified is an hp548xx (id_query=VI_TRUE)		*/
/*  and will send a reset to the instrument (do_reset=VI_TRUE)			*/

err_status = hp548xx_init("GPIB0::7::INSTR", VI_TRUE, VI_TRUE, &vi);

if (   ( err_status < VI_SUCCESS )
    || ( vi == VI_NULL ) )
{
    printf("\ninit failed with return code %d.\n", err_status);
    if ( vi != VI_NULL )
    {
        hp548xx_error_message(vi,err_status,err_msg);
        printf("  Error Status:  %d\n", err_status);
        printf("  Error Message: %s\n", err_msg);
    }
    exit (err_status);
}

err_status = hp548xx_errorQueryDetect(vi, VI_TRUE);
check_err(vi,err_status);

/* Set the instrument timeout to 50 Secs								*/ 
err_status = hp548xx_timeOut(vi,50000);
check_err(vi,err_status);

/* Set the instrument Channel 1 to View									*/ 
err_status = hp548xx_cmd(vi, ":VIEW CHAN1");
check_err(vi,err_status);

/* Free run mode.														*/
err_status = hp548xx_cmd(vi, ":RUN");
check_err(vi,err_status);

/* Autoscaling operation 												*/ 
err_status = hp548xx_cmd(vi, ":AUT");
check_err(vi,err_status);

/* The following functions measure the Parameters like 

   Negative Width, Positive Width, Period, Frequency.					*/

err_status = hp548xx_cmd(vi, ":MEAS:NWID CHAN1");
check_err(vi,err_status);
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:NWID? CHAN1", &meas_val);
check_err(vi,err_status);
printf("The measured Negative Width is %lg\n", meas_val);  


err_status = hp548xx_cmd(vi, ":MEAS:PWID CHAN1");
check_err(vi,err_status);
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:PWID? CHAN1", &meas_val);
check_err(vi,err_status);
printf("The measured Positive Width is %lg\n", meas_val);  

err_status = hp548xx_cmd(vi, ":MEAS:PER CHAN1");
check_err(vi,err_status);
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:PER? CHAN1", &meas_val);
check_err(vi,err_status);
printf("The measured Period is %lg\n", meas_val);  

err_status = hp548xx_cmd(vi, ":MEAS:FREQ CHAN1");
check_err(vi,err_status);
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:FREQ? CHAN1", &meas_val);
check_err(vi,err_status);
printf("The measured Frequency is %lg\n", meas_val);  

/*  Close the instrument.                                 				*/

err_status = hp548xx_close(vi);
printf("\nProgram complete.");
}
