' Sub Example4_Click ( )
'********************************************************************************************
'* hp548xx Instrument Driver EXAMPLE #4 for Visual Basic                                     
'*
'* To try this example, paste the code into the Declarations section of a form
'* and  then press F5 and click the form.
'*
'*                                                                            
'* This program illustrates the use of the command passthrough functions.     

'* This program gives some idea of how to use the passthrough functions        
'* to program the instrument.                                                 
'*
'* This program measures the waveform parameters like Negative width,
'* Positive Width, Period, Frequency.                                                                     
'*
'* This program uses the following passthrough functions:                     
'*                                                                            
'*     hp548xx_cmd                                                          
'*     hp548xx_cmdReal64_Q                                                   
'********************************************************************************************
Private Sub Form_Click ()

Dim err_status		As Long
Dim vi			As Long
Dim meas_val		As Double
    
'  Initialize the instrument.
err_status = hp548xx_init("GPIB0::7::INSTR", 1, 1, vi)

If ((err_status < VI_SUCCESS) Or (vi = VI_NULL)) Then

msg = "init failed with return code " & err_status
	If (vi <> VI_NULL) Then
		err_status = hp548xx_error_message(vi, err_status, err_msg)
		msg = msg & ",  Error Status: " & err_status
		msg = msg & ",  Error Message: " & err_msg
	End If
	MsgBox msg, vbInformation
	End
End If


'*  This function enables  automatic instrument error checking
err_status = hp548xx_errorQueryDetect(vi, 1)
vb_err vi, err_status

'*  This function sets instrument timeout  to 30 seconds.*

err_status = hp548xx_timeOut(vi, 30000)

'   Display Message on Instrument Sreen
err_status = hp548xx_displayData(vi, 1, 1,"This is a Passthrough Function Test")
vb_err vi, err_status

'   Set the instrument Analog Channel to View 
err_status = hp548xx_cmd(vi, ":VIEW CHAN1")
vb_err vi, err_status

'   Set the instrument Analog Channel to View 
err_status = hp548xx_cmd(vi, ":RUN")
vb_err vi, err_status

'   Autoscaling operation on channel1
err_status = hp548xx_cmd(vi, ":AUT")
vb_err vi, err_status

'  Queries the value of Negative Width
err_status = hp548xx_cmd(vi, ":MEAS:NWID CHAN1")
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:NWID? CHAN1", meas_val#)
msg = "The measured Negative Width is: " & meas_val & Chr$(13) & Chr(10)
MsgBox msg

'  Queries the value of Positive Width
err_status = hp548xx_cmd(vi, ":MEAS:PWID CHAN1")
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:PWID? CHAN1", meas_val#)
msg = "The measured Positive Width is: " & meas_val & Chr$(13) & Chr(10)
MsgBox msg

'  Queries the value of Period
err_status = hp548xx_cmd(vi, ":MEAS:PER CHAN1")
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:PER? CHAN1", meas_val#)
msg = "The measured Period is: " & meas_val & Chr$(13) & Chr(10)
MsgBox msg

'  Queries the value of Frequency
err_status = hp548xx_cmd(vi, ":MEAS:FREQ CHAN1")
err_status = hp548xx_cmdReal64_Q(vi, ":MEAS:FREQ? CHAN1", meas_val#)
msg = "The measured Frequency is: " & meas_val & Chr$(13) & Chr(10)
MsgBox msg

MsgBox "program complete"

'  Close the Instrument
err_status = hp548xx_close(vi)
vb_err vi, err_status

End Sub


Sub vb_err (vi As Long, errStatus As Long)

Dim inst_err 		As Long
Dim err_message 	As String * 250
Dim i 			As Long
Dim retStatus 		As Long

Dim nl
nl = Chr(10)

If VI_SUCCESS > errStatus Then

    'Send a device clear to ensure communication with 'the instrument.
    retStatus = hp548xx_dcl(vi)

    
    If (hp548xx_INSTR_ERROR_DETECTED = errStatus) Then

            'query the instrument for the error
	retStatus = hp548xx_error_query(vi, inst_err, err_message)
	retStatus = hp548xx_error_message(vi, inst_err, err_message)

            msg = "CHECK :Instrument Error :" & inst_err & nl & "Error Message = " & err_message
	MsgBox msg
    Else
            'get the driver error message
	retStatus = hp548xx_error_message(vi, errStatus, err_message)
	msg = "CHECK :Driver Error :" & errStatus & nl & "Error MEssage = " & err_message

MsgBox msg
    End If

End If
' optionally reset the instrument, close the instrument handle 

'retStatus=hp548xx_reset(vi)
'retStatus=hp548xx_close(vi)

End Sub
