/***************************************************************************** 
  Hp548xx Instrument Driver EXAMPLE PROGRAM #5                              
                                                                              
  This program gives some idea of how to use the subsystem functions        
  to program the instrument                                                                            
   
  This Program implements the following function

  hp548xx_MeasureAll_Q                                                             

 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "hp548xx.h"

void check_err (ViSession vi, ViStatus errStatus)
{
    ViInt32     inst_err;
    ViChar      err_message[256];

    if(VI_SUCCESS > errStatus)
    {
            /* Send a device clear to ensure communication with     	*/
            /*   the instrument.                                    	*/

        	hp548xx_dcl(vi);

            /* If the driver is set to detect instrument errors,    	*/
            /*   and an instrument error is detected, the error     	*/
            /*   code is hp548xx_INSTR_ERROR_DETECTED (see          	*/
            /*   hp548xx.h).  In this case, query the instrument    	*/
            /*   for the error and display it.                      	*/
            /* Otherwise, the error is a driver error.  Query the   	*/
            /*   driver for the error and display it.               	*/


        if(hp548xx_INSTR_ERROR_DETECTED == errStatus)	
        {
            hp548xx_error_query(vi, &inst_err, err_message); 
            hp548xx_error_message(vi, inst_err, err_message); 			
            printf("Instrument Error : %ld, %s\n", inst_err, err_message); 
        }
        else
        {
            hp548xx_error_message(vi, errStatus, err_message); 			
            printf("Driver Error : %ld, %s\n", errStatus, err_message);
        }

            /* Optionally reset the instrument, close the       	    */
            /*   instrument handle, and exit the program.          		*/

    /* hp548xx_reset(vi); */
    /* hp548xx_close(vi); */
   		exit(errStatus);   	
    }
return;
}

void main ( )
{
ViStatus    err_status;
ViSession   vi;
ViChar		err_msg[256];
ViReal64	result[24];

err_status = hp548xx_init("GPIB0::7::INSTR",VI_TRUE,VI_TRUE,&vi) ;

if (   ( err_status < VI_SUCCESS )|| ( vi == VI_NULL ) )
{
	printf("\ninit failed with return code %d.\n", err_status);
	if ( vi != VI_NULL )
	{
		hp548xx_error_message(vi,err_status,err_msg);
		printf("  Error Status:  %d\n", err_status);
		printf("  Error Message: %s\n", err_msg);
	}
	exit (err_status);
}

/*  This function enables  automatic instrument error checking 			*/
err_status = hp548xx_errorQueryDetect(vi, VI_TRUE);
check_err( vi, err_status);

/*  This function sets instrument timeout  to 30 seconds.				*/

err_status = hp548xx_timeOut(vi, 30000);
check_err( vi, err_status);

/*  This function sets to Autoscale 									*/
err_status = hp548xx_autoscale(vi);
check_err (vi, err_status);

/*   Display Message on Instrument Sreen 								*/
err_status = hp548xx_displayData(vi, 1, 1,"This is a Measure Subsytem Program");
check_err (vi, err_status);

err_status = hp548xx_measureAll_Q(vi, hp548xx_MEAS_SOURCE_CHAN,hp548xx_CH_F_W_1, result);

check_err (vi, err_status);
printf("FREQUENCY	%.2e\n",result[hp548xx_MEAS_FREQUENCY	]);
printf("PERIOD		%.2e\n",result[hp548xx_MEAS_PERIOD		]);
printf("PWIDTH		%.2e\n",result[hp548xx_MEAS_PWIDTH		]);
printf("NWIDTH		%.2e\n",result[hp548xx_MEAS_NWIDTH		]);
printf("RISETIME	%.2e\n",result[hp548xx_MEAS_RISETIME	]);
printf("FALLTIME	%.2e\n",result[hp548xx_MEAS_FALLTIME	]);
printf("DUTYCYCLE	%.2e\n",result[hp548xx_MEAS_DUTYCYCLE	]);
printf("VRMS_CYC_AC	%.2e\n",result[hp548xx_MEAS_VRMS_CYC_AC	]);
printf("VRMS_CYC_DC	%.2e\n",result[hp548xx_MEAS_VRMS_CYC_DC	]);
printf("VRMS_DIS_AC	%.2e\n",result[hp548xx_MEAS_VRMS_DIS_AC	]);
printf("VRMS_DIS_DC	%.2e\n",result[hp548xx_MEAS_VRMS_DIS_DC	]);
printf("VMAX		%.2e\n",result[hp548xx_MEAS_VMAX		]);
printf("VMIN		%.2e\n",result[hp548xx_MEAS_VMIN		]);
printf("VTOP		%.2e\n",result[hp548xx_MEAS_VTOP		]);
printf("VBASE		%.2e\n",result[hp548xx_MEAS_VBASE		]);
printf("VAVG_CYC	%.2e\n",result[hp548xx_MEAS_VAVG_CYC	]);
printf("VAVG_DIS	%.2e\n",result[hp548xx_MEAS_VAVG_DIS	]);
printf("VAMPLITUDE	%.2e\n",result[hp548xx_MEAS_VAMPLITUDE	]);
printf("VPP			%.2e\n",result[hp548xx_MEAS_VPP			]);
printf("OVERSHOOT	%.2e\n",result[hp548xx_MEAS_OVERSHOOT	]);
printf("PRESHOOT	%.2e\n",result[hp548xx_MEAS_PRESHOOT	]);
printf("VLOW		%.2e\n",result[hp548xx_MEAS_VLOW		]);
printf("VMID		%.2e\n",result[hp548xx_MEAS_VMID		]);
printf("VUPP		%.2e\n",result[hp548xx_MEAS_VUPP		]);

/*  Close the Instrument 												*/
err_status = hp548xx_close(vi);
check_err (vi, err_status);
printf("\nProgram complete.");
}
