'********************************************************************************************
'* hp548xx Instrument Driver EXAMPLE #6 for Visual Basic                                     
'*
'*To try this example, paste the code into the Declarations section of a form
'*  with a ListBox control named List1 , and  then press F5 and click the form.
'*
'*
'* This program gives some idea of how to use the subsystem functions        
'* to program the instrument.                                                 
'*                                                                    
'* This program uses the following  function:                     
'*                                                                            
'*     hp548xx_MeasureAll_Q                                                          
'*     
'*                                                  
'********************************************************************************************
Private Sub Form_Click ()
	
Dim err_status		 As Long
Dim vi			 As Long
ReDim measresult(24)	 As Double
   
'  Initialize the instrument.
err_status =  hp548xx_init("GPIB0::7::INSTR", 1, 1, vi)

If ((err_status < VI_SUCCESS) Or (vi = VI_NULL)) Then
	msg = "init failed with return code " & err_status
	If (vi <> VI_NULL) Then
		err_status = hp548xx_error_message(vi, err_status, err_msg)
		msg = msg & ",  Error Status: " & err_status
		msg = msg & ",  Error Message: " & err_msg
	End If
	MsgBox msg, vbInformation
	End
End If


'*  This function enables  automatic instrument error checking
err_status = hp548xx_errorQueryDetect(vi, VI_TRUE)
vb_err vi, err_status

'*  This function sets instrument timeout  to 30 seconds.*
err_status = hp548xx_timeOut(vi, 30000)

'*  This function sets to Autoscale
err_status = hp548xx_autoscale(vi)

vb_err vi, err_status

'   Display Message on Instrument Sreen
err_status = hp548xx_displayData(vi, 1, 1,"This is a Measure Subsytem Program")
vb_err vi, err_status

err_status = hp548xx_measureAll_Q(vi, hp548xx_MEAS_SOURCE_CHAN,hp548xx_CH_F_W_1, measresult(0))
vb_err vi, err_status

'  Close the Instrument
err_status = hp548xx_close(vi)
vb_err vi, err_status

MyStr = Format(measresult(hp548xx_MEAS_FREQUENCY), "Scientific")
Entry = "Frequency                   " & MyStr

List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_PERIOD), "Scientific")
Entry = "Period                          " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_PWIDTH), "Scientific")
Entry = "Positive Width              " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_NWIDTH), "Scientific")
Entry = "Negative Width           " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_RISETIME), "Scientific")

Entry = "RiseTime                  " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_FALLTIME), "Scientific")
Entry = "FallTime                       " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_DUTYCYCLE), "Scientific")
Entry = "DutyCycle                       " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VRMS_CYC_AC), "Scientific")
Entry = "Vrms cyc_ac                    " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VRMS_CYC_DC), "Scientific")
Entry = "Vrms cyc_dc                    " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VRMS_DIS_AC), "Scientific")
Entry = "Vrms dis_ac                    " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VRMS_DIS_DC), "Scientific")
Entry = "Vrms dis_dc                    " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VMAX), "Scientific")
Entry = "Vmax                            " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VMIN), "Scientific")
Entry = "Vmin                           " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VTOP), "Scientific")
Entry = "Vtop                           " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VBASE), "Scientific")
Entry = "VBase                          " & MyStr

List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VAVG_CYC), "Scientific")
Entry = "Vavg cyc                        " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VAVG_DIS), "Scientific")
Entry = "Vavg dis                        " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VAMPLITUDE), "Scientific")
Entry = "Vamplitude                     " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VPP), "Scientific")
Entry = "Vpp                            " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_OVERSHOOT), "Scientific")
Entry = "Overshoot                      " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_PRESHOOT), "Scientific")
Entry = "Preshoot                       " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VLOW), "Scientific")
Entry = "Vlow                           " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VMID), "Scientific")
Entry = "Vmid                           " & MyStr
List1.AddItem Entry

MyStr = Format(measresult(hp548xx_MEAS_VUPP), "Scientific")
Entry = "Vupp                           " & MyStr
List1.AddItem Entry

	
End Sub

Sub vb_err (vi As Long, errStatus As Long)

Dim inst_err 		As Long
Dim err_message 	As String * 250
Dim i 			As Long
Dim retStatus 		As Long

Dim nl
nl = Chr(10)

If VI_SUCCESS > errStatus Then

    'Send a device clear to ensure communication with 'the instrument.
    retStatus = hp548xx_dcl(vi)

    
    If (hp548xx_INSTR_ERROR_DETECTED = errStatus) Then

            'query the instrument for the error
	retStatus = hp548xx_error_query(vi, inst_err, err_message)
	retStatus = hp548xx_error_message(vi, inst_err, err_message)

            msg = "CHECK :Instrument Error :" & inst_err & nl & "Error Message = " & err_message
	MsgBox msg
    Else
            'get the driver error message
	retStatus = hp548xx_error_message(vi, errStatus, err_message)
	msg = "CHECK :Driver Error :" & errStatus & nl & "Error MEssage = " & err_message

MsgBox msg
    End If

End If
' optionally reset the instrument, close the instrument handle 

'retStatus=hp548xx_reset(vi)
'retStatus=hp548xx_close(vi)

End Sub
