Attribute VB_Name = "Module1"
'*****************************************************************************
'*  hp548xx.bas                                                              *
'*  Copyright (C) 1997 Hewlett-Packard Company                               *
'*---------------------------------------------------------------------------*
'*  Driver for hp548xx, Hewlett Packard Infiniium Oscilloscopes hp548xx      *
'*  Driver Version: A.00.00                                                  *
'*****************************************************************************

'*****************************************************************************
'*  STANDARD SECTION                                                         *
'*  Constants and function prototypes for HP standard functions.             *
'*****************************************************************************

'        ***************************************************
'        *  Standard constant error conditions returned    *
'        *  by driver functions.                           *
'        *    HP Common Error numbers start at BFFC0D00    *
'        *    The parameter errors extend the number of    *
'        *      errors over the eight defined in VPP 3.4   *
'        ***************************************************

Global Const hp548xx_INSTR_ERROR_NULL_PTR = &HBFFC0D02
Global Const hp548xx_INSTR_ERROR_RESET_FAILED = &HBFFC0D03
Global Const hp548xx_INSTR_ERROR_UNEXPECTED = &HBFFC0D04
Global Const hp548xx_INSTR_ERROR_INV_SESSION = &HBFFC0D05
Global Const hp548xx_INSTR_ERROR_LOOKUP = &HBFFC0D06
Global Const hp548xx_INSTR_ERROR_DETECTED = &HBFFC0D07

Global Const hp548xx_INSTR_ERROR_PARAMETER9 = &HBFFC0D20
Global Const hp548xx_INSTR_ERROR_PARAMETER10 = &HBFFC0D21
Global Const hp548xx_INSTR_ERROR_PARAMETER11 = &HBFFC0D22
Global Const hp548xx_INSTR_ERROR_PARAMETER12 = &HBFFC0D23
Global Const hp548xx_INSTR_ERROR_PARAMETER13 = &HBFFC0D24
Global Const hp548xx_INSTR_ERROR_PARAMETER14 = &HBFFC0D25
Global Const hp548xx_INSTR_ERROR_PARAMETER15 = &HBFFC0D26
Global Const hp548xx_INSTR_ERROR_PARAMETER16 = &HBFFC0D27
Global Const hp548xx_INSTR_ERROR_PARAMETER17 = &HBFFC0D28
Global Const hp548xx_INSTR_ERROR_PARAMETER18 = &HBFFC0D29

'        ***************************************************
'        *  Constants used by function hp548xx_timeOut      *
'        ***************************************************

Global Const hp548xx_TIMEOUT_MAX = 2147483647
Global Const hp548xx_TIMEOUT_MIN = 1&

Global Const hp548xx_CMDINT16ARR_Q_MIN = 1&
Global Const hp548xx_CMDINT16ARR_Q_MAX = 2147483647

Global Const hp548xx_CMDINT32ARR_Q_MIN = 1&
Global Const hp548xx_CMDINT32ARR_Q_MAX = 2147483647

Global Const hp548xx_CMDREAL64ARR_Q_MIN = 1&
Global Const hp548xx_CMDREAL64ARR_Q_MAX = 2147483647


'        ***************************************************
'        *  Required plug and play functions from VPP-3.1  *
'        ***************************************************

Declare Function hp548xx_init Lib "hp548xx_32.dll" (ByVal resourceName As String, ByVal IDQuery As Integer, ByVal resetDevice As Integer, instrumentHandle As Long) As Long

Declare Function hp548xx_close Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hp548xx_reset Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hp548xx_self_test Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, selfTestResult As Integer, ByVal selfTestMessage As String) As Long

Declare Function hp548xx_error_query Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, errorCode As Long, ByVal errorMessage As String) As Long

Declare Function hp548xx_error_message Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal statusCode As Long, ByVal message As String) As Long

Declare Function hp548xx_revision_query Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal instrumentDriverRevision As String, ByVal firmwareRevision As String) As Long


'        ***************************************************
'        *  HP standard utility functions                  *
'        ***************************************************

Declare Function hp548xx_timeOut Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal setTimeOut As Long) As Long

Declare Function hp548xx_timeOut_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, timeOut As Long) As Long

Declare Function hp548xx_errorQueryDetect Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal setErrorQueryDetect As Integer) As Long

Declare Function hp548xx_errorQueryDetect_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, errorQueryDetect As Integer) As Long

Declare Function hp548xx_dcl Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hp548xx_opc_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, instrumentReady As Integer) As Long


'        ***************************************************
'        *  HP standard status functions                   *
'        ***************************************************

Declare Function hp548xx_readStatusByte_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, statusByte As Integer) As Long

'        ***************************************************
'        *  HP standard command passthrough functions      *
'        ***************************************************

Declare Function hp548xx_cmd Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal sendStringCommand As String) As Long

Declare Function hp548xx_cmdString_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal queryStringCommand As String, ByVal stringSize As Long, ByVal stringResult As String) As Long

Declare Function hp548xx_cmdInt Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal sendIntegerCommand As String, ByVal sendInteger As Long) As Long

Declare Function hp548xx_cmdInt16_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal queryI16Command As String, i16Result As Integer) As Long

Declare Function hp548xx_cmdInt32_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal queryI32Command As String, i32Result As Long) As Long

Declare Function hp548xx_cmdInt16Arr_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal queryI16ArrayCommand As String, ByVal i16ArraySize As Long, i16ArrayResult As Integer, i16ArrayCount As Long) As Long

Declare Function hp548xx_cmdInt32Arr_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal queryI32ArrayCommand As String, ByVal i32ArraySize As Long, i32ArrayResult As Long, i32ArrayCount As Long) As Long

Declare Function hp548xx_cmdReal Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal sendRealCommand As String, ByVal sendReal As Double) As Long

Declare Function hp548xx_cmdReal64_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, ByVal queryRealCommand As String, realResult As Double) As Long


'* End of HP standard declarations */
'*---------------------------------------------------------------------------*


'*****************************************************************************
'*  INSTRUMENT SPECIFIC SECTION                                              *
'*  Constants and function prototypes for instrument specific functions.     *
'*****************************************************************************

'        ***************************************************
'        *  Instrument specific constants                  *
'        ***************************************************
Global Const hp548xx_ACQ_AVERAGE_ON = 1
Global Const hp548xx_ACQ_AVERAGE_OFF = 0
Global Const hp548xx_ACQ_COUNT_MIN = 2
Global Const hp548xx_ACQ_COUNT_MAX = 4096
Global Const hp548xx_ACQ_PERCENT_MIN = 0
Global Const hp548xx_ACQ_PERCENT_MAX = 100
Global Const hp548xx_ACQ_MODE_RTIME = 0
Global Const hp548xx_ACQ_MODE_ETIME = 1
Global Const hp548xx_ACQ_MODE_PDETECT = 2
Global Const hp548xx_ACQ_POINTS_AUTO = 0
Global Const hp548xx_ACQ_POINTS_MIN = 16
Global Const hp548xx_ACQ_POINTS_MAX = 65536
Global Const hp548xx_ACQ_RATE_AUTO = 0
Global Const hp548xx_ACQ_RATE_P5 = 1
Global Const hp548xx_ACQ_RATE_1 = 2
Global Const hp548xx_ACQ_RATE_2P5 = 3
Global Const hp548xx_ACQ_RATE_5 = 4
Global Const hp548xx_ACQ_RATE_10 = 5
Global Const hp548xx_ACQ_RATE_25 = 6
Global Const hp548xx_ACQ_RATE_50 = 7
Global Const hp548xx_ACQ_RATE_100 = 8
Global Const hp548xx_ACQ_RATE_250 = 9
Global Const hp548xx_ACQ_RATE_500 = 10
Global Const hp548xx_ACQ_RATE_1K = 11
Global Const hp548xx_ACQ_RATE_2P5K = 12
Global Const hp548xx_ACQ_RATE_5K = 13
Global Const hp548xx_ACQ_RATE_10K = 14
Global Const hp548xx_ACQ_RATE_25K = 15
Global Const hp548xx_ACQ_RATE_50K = 16
Global Const hp548xx_ACQ_RATE_100K = 17
Global Const hp548xx_ACQ_RATE_250K = 18
Global Const hp548xx_ACQ_RATE_500K = 19
Global Const hp548xx_ACQ_RATE_1M = 20
Global Const hp548xx_ACQ_RATE_2P5M = 21
Global Const hp548xx_ACQ_RATE_5M = 22
Global Const hp548xx_ACQ_RATE_10M = 23
Global Const hp548xx_ACQ_RATE_25M = 24
Global Const hp548xx_ACQ_RATE_50M = 25
Global Const hp548xx_ACQ_RATE_100M = 26
Global Const hp548xx_ACQ_RATE_250M = 27
Global Const hp548xx_ACQ_RATE_500M = 28
Global Const hp548xx_ACQ_RATE_1G = 29
Global Const hp548xx_ACQ_RATE_2G = 30
Global Const hp548xx_ACQ_RATE_4G = 31
Global Const hp548xx_ACQ_RATE_8G = 32
Global Const hp548xx_ACQ_CONFIG_2CH = 0
Global Const hp548xx_ACQ_CONFIG_4CH = 1

Global Const hp548xx_CHANN_BWL_ON = 1
Global Const hp548xx_CHANN_BWL_OFF = 0
Global Const hp548xx_CHANN_DISP_ON = 1
Global Const hp548xx_CHANN_DISP_OFF = 0
Global Const hp548xx_CHANN_INPUT_DC = 0
Global Const hp548xx_CHANN_INPUT_DC50 = 1
Global Const hp548xx_CHANN_INPUT_AC = 2
Global Const hp548xx_CHANN_INPUT_LFR1 = 3
Global Const hp548xx_CHANN_INPUT_LFR2 = 4
Global Const hp548xx_CHANN_PROBE_RATIO = 0
Global Const hp548xx_CHANN_PROBE_DECIBEL = 1
Global Const hp548xx_CHANN_ATT_RAT_MIN = 0.0001
Global Const hp548xx_CHANN_ATT_RAT_MAX = 1000000
Global Const hp548xx_CHANN_ATT_DEC_MIN = -80
Global Const hp548xx_CHANN_ATT_DEC_MAX = 120

Global Const hp548xx_OFFSET_MIN = -250
Global Const hp548xx_OFFSET_MAX = 250
Global Const hp548xx_RANGE_MIN = 1E-3
Global Const hp548xx_RANGE_MAX = 5

Global Const hp548xx_COMM_SETUP_SAVE = 0
Global Const hp548xx_COMM_SETUP_RECALL = 1
Global Const hp548xx_COMM_REG0 = 0
Global Const hp548xx_COMM_REG1 = 1
Global Const hp548xx_COMM_REG2 = 2
Global Const hp548xx_COMM_REG3 = 3
Global Const hp548xx_COMM_REG4 = 4
Global Const hp548xx_COMM_REG5 = 5
Global Const hp548xx_COMM_REG6 = 6
Global Const hp548xx_COMM_REG7 = 7
Global Const hp548xx_COMM_REG8 = 8
Global Const hp548xx_COMM_REG9 = 9

Global Const hp548xx_DISK_SETUP = 0
Global Const hp548xx_DISK_WMEM = 1
Global Const hp548xx_DISK_SOURCE_CHAN = 0
Global Const hp548xx_DISK_SOURCE_FUNC = 1
Global Const hp548xx_DISK_SOURCE_WMEM = 2
Global Const hp548xx_DISK_SOURCE_SETUP = 3
Global Const hp548xx_DISK_FMT_INT = 0
Global Const hp548xx_DISK_FMT_TYVAL = 1
Global Const hp548xx_DISK_FMT_TVERB = 2
Global Const hp548xx_DISK_FMT_TXYP = 3

Global Const hp548xx_DISP_ROW_MIN = 0
Global Const hp548xx_DISP_ROW_MAX = 23
Global Const hp548xx_DISP_COL_MIN = 0
Global Const hp548xx_DISP_COL_MAX = 81
Global Const hp548xx_DISP_FTYPE_PCX = 0
Global Const hp548xx_DISP_FTYPE_BMP = 1
Global Const hp548xx_DISP_FTYPE_EPS = 2
Global Const hp548xx_DISP_FTYPE_PS = 3
Global Const hp548xx_DISP_FTYPE_GIF = 4
Global Const hp548xx_DISP_SCRMODE_SCR = 0
Global Const hp548xx_DISP_SCRMODE_GRAT = 1
Global Const hp548xx_DISP_COMP_OFF = 0
Global Const hp548xx_DISP_COMP_ON = 1
Global Const hp548xx_DISP_INV_NORM = 0
Global Const hp548xx_DISP_INV_INV = 1

Global Const hp548xx_FFT_WINDOW_RECTANGULAR = 0
Global Const hp548xx_FFT_WINDOW_HANNING = 1
Global Const hp548xx_FFT_WINDOW_FLATTOP = 2
Global Const hp548xx_FFT_CFREQ_MIN = -1E12
Global Const hp548xx_FFT_CFREQ_MAX = 1E12

Global Const hp548xx_FUNC_DISP_OFF = 0
Global Const hp548xx_FUNC_DISP_ON = 1
Global Const hp548xx_FUNC_HORIZ_AUTO = 0
Global Const hp548xx_FUNC_HORIZ_MANUAL = 1
Global Const hp548xx_FUNC_VERT_AUTO = 0
Global Const hp548xx_FUNC_VERT_MANUAL = 1
Global Const hp548xx_FUNC_OP_ADD = 0
Global Const hp548xx_FUNC_OP_SUB = 1
Global Const hp548xx_FUNC_OP_DIFF = 2
Global Const hp548xx_FUNC_OP_DIV = 3
Global Const hp548xx_FUNC_OP_MULT = 4
Global Const hp548xx_FUNC_OP_VERS = 5

Global Const hp548xx_HCOPY_GRAT = 0
Global Const hp548xx_HCOPY_SCREEN = 1
Global Const hp548xx_HCOPY_FACT_OFF = 0
Global Const hp548xx_HCOPY_FACT_ON = 1
Global Const hp548xx_HCOPY_IMAGE_NORMAL = 0
Global Const hp548xx_HCOPY_IMAGE_INVERT = 1
Global Const hp548xx_HCOPY_IMAGE_MONOC = 2

Global Const hp548xx_MEAS_SOURCE_CHAN = 0
Global Const hp548xx_MEAS_SOURCE_FUNC = 1
Global Const hp548xx_MEAS_SOURCE_WMEM = 2
Global Const hp548xx_MEAS_DISPLAY = 0
Global Const hp548xx_MEAS_CYCLE = 1
Global Const hp548xx_MEAS_AC = 0
Global Const hp548xx_MEAS_DC = 1
Global Const hp548xx_MEAS_FREQUENCY = 0
Global Const hp548xx_MEAS_PERIOD = 1
Global Const hp548xx_MEAS_PWIDTH = 2
Global Const hp548xx_MEAS_NWIDTH = 3
Global Const hp548xx_MEAS_RISETIME = 4
Global Const hp548xx_MEAS_FALLTIME = 5
Global Const hp548xx_MEAS_DUTYCYCLE = 6
Global Const hp548xx_MEAS_VRMS_CYC_AC = 7
Global Const hp548xx_MEAS_VRMS_CYC_DC = 8
Global Const hp548xx_MEAS_VRMS_DIS_AC = 9
Global Const hp548xx_MEAS_VRMS_DIS_DC = 10
Global Const hp548xx_MEAS_VMAX = 11
Global Const hp548xx_MEAS_VMIN = 12
Global Const hp548xx_MEAS_VTOP = 13
Global Const hp548xx_MEAS_VBASE = 14
Global Const hp548xx_MEAS_VAVG_CYC = 15
Global Const hp548xx_MEAS_VAVG_DIS = 16
Global Const hp548xx_MEAS_VAMPLITUDE = 17
Global Const hp548xx_MEAS_VPP = 18
Global Const hp548xx_MEAS_OVERSHOOT = 19
Global Const hp548xx_MEAS_PRESHOOT = 20
Global Const hp548xx_MEAS_VLOW = 21
Global Const hp548xx_MEAS_VMID = 22
Global Const hp548xx_MEAS_VUPP = 23

Global Const hp548xx_BLANK = 0
Global Const hp548xx_VIEW = 1

Global Const hp548xx_TIM_RANGE_MIN = 0.000000001
Global Const hp548xx_TIM_RANGE_MAX = 50
Global Const hp548xx_TIM_POS_MIN = -10
Global Const hp548xx_TIM_POS_MAX = 10
Global Const hp548xx_TIM_REF_LEFT = 0
Global Const hp548xx_TIM_REF_CENTER = 1
Global Const hp548xx_TIM_REF_RIGHT = 2

Global Const hp548xx_TRIG_SWEEP_AUTO = 0
Global Const hp548xx_TRIG_SWEEP_TRIGG = 1
Global Const hp548xx_TRIG_SWEEP_SINGLE = 2
Global Const hp548xx_TRIG_COUP_AC = 0
Global Const hp548xx_TRIG_COUP_DC = 1
Global Const hp548xx_TRIG_COUP_LFR = 2
Global Const hp548xx_TRIG_COUP_HFR = 3
Global Const hp548xx_TRIG_SLOPE_POS = 0
Global Const hp548xx_TRIG_SLOPE_NEG = 1
Global Const hp548xx_TRIG_LEV_AUX = 0
Global Const hp548xx_TRIG_LEV_CHAN1 = 1
Global Const hp548xx_TRIG_LEV_CHAN2 = 2
Global Const hp548xx_TRIG_LEV_CHAN3 = 3
Global Const hp548xx_TRIG_LEV_CHAN4 = 4
Global Const hp548xx_TRIG_LEV_EXT = 5
Global Const hp548xx_TRIG_LEVEL_MIN = -60
Global Const hp548xx_TRIG_LEVEL_MAX = 60
Global Const hp548xx_TRIG_POLARITY_POS = 0
Global Const hp548xx_TRIG_POLARITY_NEG = 1
Global Const hp548xx_TRIG_WIDTH_MIN = 0.0000015
Global Const hp548xx_TRIG_WIDTH_MAX = 0.16

Global Const hp548xx_WAV_POINTS_MIN = 1
Global Const hp548xx_WAV_POINTS_MAX = 262144
Global Const hp548xx_WAV_XINC = 0
Global Const hp548xx_WAV_XOR = 1
Global Const hp548xx_WAV_YINC = 2
Global Const hp548xx_WAV_YOR = 3
Global Const hp548xx_WAV_FORMAT_ASCII = 0
Global Const hp548xx_WAV_FORMAT_BYTE = 1
Global Const hp548xx_WAV_FORMAT_LONG = 2
Global Const hp548xx_WAV_FORMAT_WORD = 3

Global Const hp548xx_WMEM_DISP_OFF = 0
Global Const hp548xx_WMEM_DISP_ON = 1

Global Const hp548xx_CHANNEL = 0
Global Const hp548xx_FUNCTION = 1
Global Const hp548xx_WMEMORY = 2
Global Const hp548xx_CONSTANT = 3

Global Const hp548xx_CH_F_W_1 = 1
Global Const hp548xx_CH_F_W_2 = 2
Global Const hp548xx_CH_F_W_3 = 3
Global Const hp548xx_CH_F_W_4 = 4
Global Const hp548xx_CH1 = 1
Global Const hp548xx_CH2 = 2
Global Const hp548xx_CH3 = 3
Global Const hp548xx_CH4 = 4
Global Const hp548xx_FUNC1 = 1
Global Const hp548xx_FUNC2 = 2
Global Const hp548xx_FUNC3 = 3
Global Const hp548xx_FUNC4 = 4
Global Const hp548xx_WMEM1 = 1
Global Const hp548xx_WMEM2 = 2
Global Const hp548xx_WMEM3 = 3
Global Const hp548xx_WMEM4 = 4

Global Const hp548xx_AUX = 0
Global Const hp548xx_CHAN1 = 1
Global Const hp548xx_CHAN2 = 2
Global Const hp548xx_CHAN3 = 3
Global Const hp548xx_CHAN4 = 4
Global Const hp548xx_EXT = 5
Global Const hp548xx_LINE = 6

Global Const hp548xx_FILE_OPEN_ERROR = &HBFFC0D30
Global Const hp548xx_FILE_READ_ERROR = &HBFFC0D31
Global Const hp548xx_FILE_WRITE_ERROR = &HBFFC0D32
Global Const hp548xx_INSTR_ERROR_CMD_ERROR = -100
Global Const hp548xx_INSTR_ERROR_INV_CHAR = -101
Global Const hp548xx_INSTR_ERROR_SYNTAX = -102
Global Const hp548xx_INSTR_ERROR_INV_SEPARATOR = -103
Global Const hp548xx_INSTR_ERROR_DATA_TYPE = -104
Global Const hp548xx_INSTR_ERROR_GET_ALLOW = -105
Global Const hp548xx_INSTR_ERROR_PARAM_ALLOW = -108
Global Const hp548xx_INSTR_ERROR_MISS_PARAM = -109
Global Const hp548xx_INSTR_ERROR_MNEMONIC_LONG = -112
Global Const hp548xx_INSTR_ERROR_UNDEF_HEADER = -113
Global Const hp548xx_INSTR_ERROR_INV_CHAR_NUM = -121
Global Const hp548xx_INSTR_ERROR_NUM_OVERFLOW = -123
Global Const hp548xx_INSTR_ERROR_TOO_MANY_DIG = -124
Global Const hp548xx_INSTR_ERROR_NUM_DATA_ALLOW = -128
Global Const hp548xx_INSTR_ERROR_INV_SUFFIX = -131
Global Const hp548xx_INSTR_ERROR_SUFFIX_ALLOW = -138
Global Const hp548xx_INSTR_ERROR_INV_CHAR_DATA = -141
Global Const hp548xx_INSTR_ERROR_CHAR_DATA_LONG = -144
Global Const hp548xx_INSTR_ERROR_CHAR_DATA_ALLOW = -148
Global Const hp548xx_INSTR_ERROR_STR_DATA = -150
Global Const hp548xx_INSTR_ERROR_INV_STR_DATA = -151
Global Const hp548xx_INSTR_ERROR_STR_DATA_ALLOW = -158
Global Const hp548xx_INSTR_ERROR_BLOCK_DATA = -160
Global Const hp548xx_INSTR_ERROR_INV_BLOCK_DATA = -161
Global Const hp548xx_INSTR_ERROR_BLOCK_DATA_ALLOW = -168
Global Const hp548xx_INSTR_ERROR_EXPRESSION = -170
Global Const hp548xx_INSTR_ERROR_INV_EXP = -171
Global Const hp548xx_INSTR_ERROR_EXP_DATA_ALLOW = -178
Global Const hp548xx_INSTR_ERROR_EXECUTION = -200
Global Const hp548xx_INSTR_ERROR_DATA_OUT_RANGE = -222
Global Const hp548xx_INSTR_ERROR_TOO_MUCH_DATA = -223
Global Const hp548xx_INSTR_ERROR_ILL_PARAM_VALUE = -224
Global Const hp548xx_INSTR_ERROR_HW_MISING = -241
Global Const hp548xx_INSTR_ERROR_FILE_NFOUND = -256
Global Const hp548xx_INSTR_ERROR_SYSTEM = -310
Global Const hp548xx_INSTR_ERROR_QUEUE_OVERFLOW = -350
Global Const hp548xx_INSTR_ERROR_QUERY = -400
Global Const hp548xx_INSTR_ERROR_Q_INTERRUPTED = -410
Global Const hp548xx_INSTR_ERROR_Q_UNTERMINATED = -420
Global Const hp548xx_INSTR_ERROR_Q_DEADLOCKED = -430
Global Const hp548xx_INSTR_ERROR_Q_UNTERMINATED_R = -440

Global Const hp548xx_MAX_SIZE = 102400


'        ***************************************************
'        *  Instrument specific functions                  *
'        ***************************************************


Declare Function hp548xx_acquireSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal average As Integer, _
                                                ByVal countvalue As Integer, _
                                                ByVal completionpercent As Integer, _
                                                ByVal samplingmode As Integer, _
                                                ByVal memorydepth As Long, _
                                                ByVal sampling_rate As Integer) As Long
Declare Function hp548xx_set54845Aconfig Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal config As Integer) As Long
Declare Function hp548xx_channelScale Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal channel_number As Integer, _
                                                ByVal rangevalue As Double, _
                                                ByVal offsetvalue As Double) As Long
Declare Function hp548xx_channelInputSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal channel_number As Integer, _
                                                ByVal bwlimit As Integer, _
                                                ByVal display As Integer, _
                                                ByVal coupling As Integer, _
                                                ByVal attenuationfactor As Double, _
                                                ByVal attenuation_units As Integer) As Long
Declare Function hp548xx_saveRecallSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal saverecall As Integer, _
                                                ByVal memoryregisternumber As Integer) As Long
Declare Function hp548xx_loadFromDisk Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal filename As String, _
                                                ByVal destination As Integer, _
                                                ByVal destinationnumber As Integer) As Long
Declare Function hp548xx_storeToDisk Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal filename As String, _
                                                ByVal source As Integer, _
                                                ByVal source_number As Integer, _
                                                ByVal format As Integer) As Long
Declare Function hp548xx_displayData Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal row_number As Integer, _
                                                ByVal col_number As Integer, _
                                                ByVal stringargument As String) As Long
Declare Function hp548xx_displayData_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal filename As String, _
                                                ByVal filetype As Integer, _
                                                ByVal screenmode As Integer, _
                                                ByVal compression As Integer, _
                                                ByVal inversion As Integer) As Long
Declare Function hp548xx_funcFftSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal functionnumber As Integer, _
                                                ByVal display As Integer, _
                                                ByVal operandtype As Integer, _
                                                ByVal operand As Double, _
                                                ByVal centerfrequencyvalue As Double, _
                                                ByVal window As Integer) As Long
Declare Function hp548xx_funcOper Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal functionnumber As Integer, _
                                                ByVal display As Integer, _
                                                ByVal operation As Integer, _
                                                ByVal operand1type As Integer, _
                                                ByVal operand1 As Double, _
                                                ByVal operand2type As Integer, _
                                                ByVal operand2 As Double) As Long
Declare Function hp548xx_hardCopySetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal area As Integer, _
                                                ByVal factors As Integer, _
                                                ByVal image As Integer) As Long
Declare Function hp548xx_measureAll_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                ByVal source_number As Integer, _
                                                resultsarray As Double) As Long
Declare Function hp548xx_measureOne_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                ByVal source_number As Integer, _
                                                ByVal measurement As Integer, _
                                                result As Double) As Long
Declare Function hp548xx_autoscale Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long
Declare Function hp548xx_blankView Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal setting As Integer, _
                                                ByVal source As Integer, _
                                                ByVal source_number As Integer) As Long
Declare Function hp548xx_digitize Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                ByVal source_number As Integer) As Long
Declare Function hp548xx_printScreen Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long
Declare Function hp548xx_run Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long
Declare Function hp548xx_stop Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long
Declare Function hp548xx_single Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long) As Long
Declare Function hp548xx_storeWaveform Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                ByVal source_number As Integer, _
                                                ByVal destination As Integer) As Long
Declare Function hp548xx_systemSetup_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal filename As String) As Long
Declare Function hp548xx_systemSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal filename As String) As Long
Declare Function hp548xx_timebaseRange Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal reference As Integer, _
                                                ByVal position As Double, _
                                                ByVal fullscalerange As Double) As Long
Declare Function hp548xx_edgeTriggerSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                ByVal triggerlevel As Double, _
                                                ByVal sweepmode As Integer, _
                                                ByVal coupling As Integer, _
                                                ByVal slope As Integer) As Long
Declare Function hp548xx_glitchTriggerSetup Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                ByVal triggerlevel As Double, _
                                                ByVal sweepmode As Integer, _
                                                ByVal width As Double, _
                                                ByVal polarity As Integer) As Long
Declare Function hp548xx_waveformScaling_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                points As Long, _
                                                data As Double) As Long
Declare Function hp548xx_waveformFormat Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal format As Integer) As Long
Declare Function hp548xx_displayWmem Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal display As Integer, _
                                                ByVal source As Integer) As Long

Declare Function hp548xx_waveformArray_Q Lib "hp548xx_32.dll" (ByVal instrumentHandle As Long, _
                                                ByVal source As Integer, _
                                                points As Long, _
                                                time_value As Double, _
                                                volts As Double) As Long

'* End of instrument specific declarations *
'*---------------------------------------------------------------------------*

