s            I   X                                     hp548xx     hp548xx                                         ViInt16      ViPInt16     
  	ViInt16 []     ViInt32      ViPInt32     
  	ViInt32 []    ViReal64     	 	ViPReal64       
ViReal64 []      ViString     	 	ViBoolean     
 
ViPBoolean      	 ViBoolean []      ViRsrc     	 	ViSession      ViStatus      ViPChar     	  ViChar []      This instrument module provides programming support for the Hewlett Packard: HP548xx Infiniium Oscilloscopes.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Subsystem Functions: (Class)
This class of functions contains all the instrument-specific functions.

(3) Application Functions: (Class)
This class contains high-level, measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(4) Close:
This function takes the instrument offline.        This class contains all the instrument-specific functions divided by subsystem commands.

Functions/SubClasses:

(1) Acquire:
The acquire commands set up conditions for excecuting a DIGitize root level command to acquire waveform data. The commands  in this subsystem select the type of data, the number of averages, and number of data points.

(2) Channel:
The CHAnnel subsystem commands controll all the vertical (Y axis) functions of the oscilloscope.

(3) Common:
Common commands control generic device functions that are common to many different types of instruments.

(4) Disk:
These commands perform the disk load and store operations.

(5) Display:
These functions control the display of data on screen.

(6) Function:
These subsystem functions contain the basic operations to execute over the input channels, waveform memories, or other functions.

(7) Hardcopy:
Hardcopy commands set various parameters for printing the screen.

(8) Measure:
Measure commands are used to make parametric measurements on displayed waveforms. 

(9) Root:
Root level commands control many of the basic operations of the oscilloscope that can be selected by pressing the labeled keys on the front panel.

(10) System:
This class contains the commands that control the way in which query responses are formatted, send and receive setup strings, and enable reading and writting to the advisory line of the oscilloscope.

(11) Timebase:
The TIMebase subsystem function control the horizontal (X axis) oscilloscope functions.

(12) Trigger:
This class contains functions to configure the edge and glitch trigger modes of the oscilloscope.

(13) Waveform:
These functions are used totransfer waveform data between the computer and the oscilloscope.

(14) Wmemory:
This function allows to display a waveform memory on the oscilloscope.
        The acquire commands set up conditions for excecuting a DIGitize root level command to acquire waveform data. The commands  in this subsystem select the type of data, the number of averages, and number of data points.

Functions/SubClasses:

(1) Acquire Setup:
This function sets the acquisition mode, averaging on/off, count and completion.

(2) Set Hp54845A config:
Sets channel mode/memory depth for 54845 A.    E    The CHAnnel subsystem commands controll all the vertical (Y axis) functions of the oscilloscope.

Functions/SubClasses:

(1) Channel Scale:
Sets the vertival range and offset for the specified channel.

(2) Channel Input Setup:
Sets probe attenuation, coupling, bandwith limit, and display on/off for the specified channel.         Common commands control generic device functions that are common 
to many different types of instruments.

Functions/SubClasses:

(1) Save Recall setup:
Saves / Recalls setup to/from the specified register.
         These commands perform the disk load and store operations.

Functions/SubClasses:

(1) Load From Disk:
Loads .wvf, .txt, or .set files from disk.

(2) Store To Disk:
Stores .wvf, .txt, or .set files to disk.
         These functions control the display of data on screen.

Functions/SubClasses:

(1) Display Data:
Displays text line at row and column indicated.

(2) Display Data Query:
Returns information about the captured data.    l    These subsystem functions contain the basic operations to execute over the input channels, waveform memories, or other functions.

Functions/SubClasses:

(1) FFT Setup:
Sets up center frequency and window for FFT.

(2) Oper:
Sets up function selection, horizontal and vertical ranges, and display on/off. Functions included: add, substract, divide, and multiply.         Hardcopy functions set various parameters for printing the screen.

Functions/SubClasses:

(1) Hard Copy Setup:
Sets up area, factors, and image definition for hardcopy.    5    Measure commands are used to make parametric measurements on displayed waveforms. 

Functions/SubClasses:

(1) Measure All Query:
Returns values for: freq, period, +width,-width, risetime, falltime, duty cycle, Vrms, Vmax, Vmin, Vtop, Vbase, Vavg, Vamp, Vpp, overshoot, preshoot, Vlower, Vupper for selected source.

(2) Measure One Query:
Returns values for specific measurement on selected source: freq, period, +width,-width, risetime, falltime, duty cycle, Vrms,Vmax,Vmin, Vtop, Vbase, Vavg, Vamp, Vpp, overshoot, preshoot, Vlower, Vupper for selected source.        Root level commands control many of the basic operations of the oscilloscope that can be selected by pressing the labeled keys on the front panel.

Functions/SubClasses:

(1) Autoscale:
Causes the oscilloscope to evaluate all input signals and find the optimum conditions for displaying the signal.

(2) Blank View:
Turns on/off active channel, function, or waveform memory.

(3) Digitize:
Digitizes the signal.

(4) Print Screen:
Print to hardcopy device using factors set in hardcopy subsystem.

(5) Run:
Starts the oscilloscope running.

(6) Stop:
Stops the acquisition.

(7) Single:
Causes the oscilloscope to make a single acquisition when the next trigger event occurs.

(8) Store Waveform:
Stores a channel, function, or stored waveform to the indicated waveform memory.
        This class contains the commands that control the way in which query responses are formatted, send and receive setup strings, and enable reading and writting to the advisory line of the oscilloscope.

Functions/SubClasses:

(1) System Setup Query:
Performs setup query and stores in the specified filename.
Information is written in a binary block  data format as defined in the IEEE 488.2 standard.

(2) System Setup:
This function puts system setup information in binary IEEE 488.2 format to the instrument from the specified file.         The TIMebase subsystem function control the horizontal (X axis) oscilloscope functions.

Functions/SubClasses:

(1) Timebase Range:
Defines horizontal range, position and reference.    P    This class contains functions to configure the edge and glitch trigger modes of the oscilloscope.

Functions/SubClasses:

(1) Edge Trigger Setup:
Sets trigger mode to EDGE and defines edge trigger source, slope, level, sweep, and coupling.

(2) Glitch Trigger Setup:
Defines source, level, polarity, width, and sweep for glitch mode.
        These functions are used totransfer waveform data between the computer and the oscilloscope.

Functions/SubClasses:

(1) Waveform Scaling Query:
Returns values to calculate x,y values from waveform data. Returns the following: number of points, x increment, y increment, x origin, y origin, x reference, and y reference values.

(2) Waveform Format:
Sets data transmission mode for waveform data.
         This function allows to display a waveform memory on the oscilloscope.

Functions/SubClasses:

(1) Display Waveform Memory:
Displays the indicated waveform memory.         Utility functions perform several standard P&P tasks and a variety of HP utility tasks.  They also include HP's instrument command passthrough functions which allow generic access to the instrument's command set.
         HP's instrument command passthrough functions.

These functions pass commands directly to the instrument, thus allowing generic access to the instrument's command set.
        This class contains high-level, measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions/SubClasses:

(1) Waveform Array Query:
This application function converts waveform data to time and voltage values.

(2) Waveform File Query:
This application function converts waveform data to (time,voltage) pairs and stores to disk in csv format.         The initialize function initializes the software connection to the instrument and optionally verifies that instrument is in the system.  In addition, it may perform any necessary actions to place the instrument in its reset state.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
         [INPUT PARAMETER]

The instrument's VISA resource description.

The default for this instrument is "GPIB0::7::INSTR".  If you change the HPIB address of this instrument, you must change the default resource description as well.
         [INPUT PARAMETER]

If VI_TRUE, perform a revision query to verify that the instrument is the one expected by the driver.

If VI_FALSE, do not perform a revision query.
         [INPUT PARAMETER]

If VI_TRUE, perform a reset operation while initializing the instrument.

If VI_FALSE, do not perform a reset operation.
         [OUTPUT PARAMETER]

The instrument's VISA session handle.  This is VI_NULL if an error occurred during the initialization process.
    #G
o      Status                            %( 7 .        Resource Name                     & 7#        ID Query                          & 7        Reset Device                      '^         Instrument Handle                  	           "GPIB0::7"  % Do Query VI_TRUE Skip Query VI_FALSE  # Reset VI_TRUE Don't Reset VI_FALSE    	            A    Sets acquisition mode, averaging on/off, count, and completion.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.        [INPUT PARAMETER]

This parameter enables or disables averaging mode.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_ACQ_AVERAGE_ON          1  On 
hp548xx_ACQ_AVERAGE_OFF         0  Off    D    [INPUT PARAMETER]

This parameter sets the number of averages for the waveforms. In the average mode, this parameter specifies the number of data values to be averaged for each time bucket before the acquisition is considered complete for that time bucket.

MIN = hp548xx_ACQ_COUNT_MIN  2
MAX = hp548xx_ACQ_COUNT_MAX  4096    }    [INPUT PARAMETER]

It specifies the minimum completion criteria for an acquisition. The parameter determines the percentage of the time buckets that needs to be full before an acquisition is considered complete.

When acquire average is set to OFF, this parameter has the same effect as if it was set to 100%.

MIN = hp548xx_ACQ_PERCENT_MIN  0
MAX = hp548xx_ACQ_PERCENT_MAX  100
        [INPUT PARAMETER]

Selects the type of acquisition mode to be set. Sampling mode can be Equivalent Time (Repetitive), Real Time, or Peak Detect. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_ACQ_MODE_RTIME          0  Real Time
hp548xx_ACQ_MODE_ETIME          1  Equivalent Time
hp548xx_ACQ_MODE_PDETECT        2  Peak Detect    A    [INPUT PARAMETER]

Sets the requested memory depth for an acquisition. This can also be set to AUTO, which allows the oscilloscope to select the number of points based upon the sample rate and time base scale. 

AUTO = hp548xx_ACQ_POINTS_AUTO  0
MIN  = hp548xx_ACQ_POINTS_MIN   16
MAX  = hp548xx_ACQ_POINTS_MAX   65536
        [INPUT PARAMETER]

Sets the acquisition sample rate of the oscilloscope. It is always set to AUTO when the oscilloscope is in the equivalent mode.


 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_ACQ_RATE_AUTO           0  Auto 
hp548xx_ACQ_RATE_P5             1  0.5
hp548xx_ACQ_RATE_1              2  1
hp548xx_ACQ_RATE_2P5            3  2.5 
hp548xx_ACQ_RATE_5              4  5
hp548xx_ACQ_RATE_10             5  10
hp548xx_ACQ_RATE_25             6  25
hp548xx_ACQ_RATE_50             7  50
hp548xx_ACQ_RATE_100            8  100
hp548xx_ACQ_RATE_250            9  250
hp548xx_ACQ_RATE_500           10  500
hp548xx_ACQ_RATE_1K            11  1K
hp548xx_ACQ_RATE_2P5K          12  2.5K
hp548xx_ACQ_RATE_5K            13  5K
hp548xx_ACQ_RATE_10K           14  10K
hp548xx_ACQ_RATE_25K           15  25K
hp548xx_ACQ_RATE_50K           16  50K
hp548xx_ACQ_RATE_100K          17  100K
hp548xx_ACQ_RATE_250K          18  250K
hp548xx_ACQ_RATE_500K          19  500K
hp548xx_ACQ_RATE_1M            20  1M
hp548xx_ACQ_RATE_2P5M          21  2.5M
hp548xx_ACQ_RATE_5M            22  5M
hp548xx_ACQ_RATE_10M           23  10M
hp548xx_ACQ_RATE_25M           24  25M
hp548xx_ACQ_RATE_50M           25  50M
hp548xx_ACQ_RATE_100M          26  100M
hp548xx_ACQ_RATE_250M          27  250M
hp548xx_ACQ_RATE_500M          28  500M
hp548xx_ACQ_RATE_1G            29  1G
hp548xx_ACQ_RATE_2G            30  2G
hp548xx_ACQ_RATE_4G            31  4G
hp548xx_ACQ_RATE_8G            32  8G
    )  )        Instrument Handle                 * r      Status                            + x {        average                           , x        count value                       .F x        completion percent                /         sampling mode                     1a x       memory depth                      2        sampling_rate                      0    	         6  On hp548xx_ACQ_AVERAGE_ON Off hp548xx_ACQ_AVERAGE_OFF                           d       d                      mReal Time hp548xx_ACQ_MODE_RTIME Equivalent Time hp548xx_ACQ_MODE_ETIME Peak Detect hp548xx_ACQ_MODE_PDETECT                                  !  +AUTO hp548xx_ACQ_RATE_AUTO .5 hp548xx_ACQ_RATE_P5 1 hp548xx_ACQ_RATE_1 2.5 hp548xx_ACQ_RATE_2P5 5 hp548xx_ACQ_RATE_5 10 hp548xx_ACQ_RATE_10 25 hp548xx_ACQ_RATE_25 50 hp548xx_ACQ_RATE_50 100 hp548xx_ACQ_RATE_100 250 hp548xx_ACQ_RATE_250 500 hp548xx_ACQ_RATE_500 1K hp548xx_ACQ_RATE_1K 2.5K hp548xx_ACQ_RATE_2P5K 5K hp548xx_ACQ_RATE_5K 10K hp548xx_ACQ_RATE_10K 25K hp548xx_ACQ_RATE_25K 50K hp548xx_ACQ_RATE_50K 100K hp548xx_ACQ_RATE_100K 250K hp548xx_ACQ_RATE_250K 500K hp548xx_ACQ_RATE_500K 1M hp548xx_ACQ_RATE_1M 2.5M hp548xx_ACQ_RATE_2P5M 5M hp548xx_ACQ_RATE_5M 10M hp548xx_ACQ_RATE_10M 25M hp548xx_ACQ_RATE_25M 50M hp548xx_ACQ_RATE_50M 100M hp548xx_ACQ_RATE_100M 250M hp548xx_ACQ_RATE_250M 500M hp548xx_ACQ_RATE_500M 1G hp548xx_ACQ_RATE_1G 2G hp548xx_ACQ_RATE_2G 4G hp548xx_ACQ_RATE_4G 8G hp548xx_ACQ_RATE_8G    0    Sets channel mode for the 54845A oscilloscope.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    +    [INPUT PARAMETER]

Configures the HP 54845A oscilloscope to use 2 or 4 channels for acquisition.  

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_ACQ_CONFIG_2CH          0  2 Channel
hp548xx_ACQ_CONFIG_4CH          1  4 Channel
    >         Instrument Handle                 ?<a      Status                            A          config                             0    	         B  4 Channel hp548xx_ACQ_CONFIG_4CH 2 Channel hp548xx_ACQ_CONFIG_2CH    !    Sets Vertical range and offset.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    W    [INPUT PARAMETER]

Specifies the channel number.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH1                     1  Channel 1 
hp548xx_CH2                     2  Channel 2 
hp548xx_CH3                     3  Channel 3
hp548xx_CH4                     4  Channel 4 

        [INPUT PARAMETER]

Sets the voltage that is represented at the center of the display for the selected channel. 

Offset parameters are probe and vertical scale dependent. It is usually expressed in volts, but could be in other measurement units, such as amperes, if you have specified other units using the  CHANnel:UNITs command. 

MIN = hp548xx_OFFSET_MIN             -250 
MAX = hp548xx_OFFSET_MAX              250  
        [INPUT PARAMETER]

Full-scale voltage of the specified channel number. It sets up acquisition and display hardware to display the waveform at a given range scale. The values represent the full-scale deflection factor of the vertical axis in volts. These values change as the probe attenuation factor is changed.

MIN = hp548xx_RANGE_MIN             1E-3
MAX = hp548xx_RANGE_MAX               5  
    Cm%         Instrument Handle                 C%d      Status                            E P       channel_number                    G         offset value                      H         range value                        0    	                      XChannel 1 hp548xx_CH1 Channel 2 hp548xx_CH2 Channel 3 hp548xx_CH3 Channel 4 hp548xx_CH4 ?      @o@     o@                        ?      @      ?PbM?                    H    Sets probe attenuation, coupling, bandwidth limit, and display on/off.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    V    [INPUT PARAMETER]

Specifies the channel number.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH1                     1  Channel 1 
hp548xx_CH2                     2  Channel 2 
hp548xx_CH3                     3  Channel 3
hp548xx_CH4                     4  Channel 4 
        [INPUT PARAMETER]

Specifies the limits of the low pass filter, except on the HP 54845A oscilloscope, which has no low pass filter. When ON, the bandwidth of the specified channel is limited. It can be used either with AC or DC coupling.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANN_BWL_ON            1  Band width limit ON
hp548xx_CHANN_BWL_OFF           0  Band width limit OFF 
        [INPUT PARAMETER]

Turns the display of the specified channel on or off.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANN_DISP_ON           1  ON
hp548xx_CHANN_DISP_OFF          0  OFF
    [    [INPUT PARAMETER]

Selects the input coupling, impedance, and LF/HF reject for the specified channel. The coupling for each channel can be set to AC, DC, DC50, or DCFifty, or LFR1 or LFR2 (low frequency reject). LFR1 and LFR2 are not available on HP 54845A.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANN_INPUT_DC          0  DC 
hp548xx_CHANN_INPUT_DC50        1  DC 50 ohms 
hp548xx_CHANN_INPUT_AC          2  AC 
hp548xx_CHANN_INPUT_LFR1        3  Low Freq. Reject 1 
hp548xx_CHANN_INPUT_LFR2        4  Low Freq. Reject 2 
    "    [INPUT PARAMETER]

Sets the probe attenuation factor.

When units set to ratio:
MIN = hp548xx_CHANN_ATT_RAT_MIN       100E-6
MAX = hp548xx_CHANN_ATT_RAT_MAX       1E6   

When units set to decibel:
MIN = hp548xx_CHANN_ATT_DEC_MIN       -80   
MAX = hp548xx_CHANN_ATT_DEC_MAX       120   
        [INPUT PARAMETER]

Specifies the mode for probe attenuation. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANN_PROBE_RATIO       0  Ratio units hp548xx_CHANN_PROBE_DECIBEL     1  Decibel units
    Lw%         Instrument Handle                 L%U      Status                            N I       channel_number                    P  d        bwlimit                           Q          display                           R         coupling                          UX $       attenuation factor                V         attenuation_units                  0    	                      XChannel 1 hp548xx_CH1 Channel 2 hp548xx_CH2 Channel 3 hp548xx_CH3 Channel 4 hp548xx_CH4  2  On hp548xx_CHANN_BWL_ON Off hp548xx_CHANN_BWL_OFF  4 On hp548xx_CHANN_DISP_ON Off hp548xx_CHANN_DISP_OFF               DC hp548xx_CHANN_INPUT_DC DC 50 hp548xx_CHANN_INPUT_DC50 AC hp548xx_CHANN_INPUT_AC LFR1 hp548xx_CHANN_INPUT_LFR1 LFR2 hp548xx_CHANN_INPUT_LFR2 ?      A.    ?6C-?                  D  Decibel hp548xx_CHANN_PROBE_DECIBEL Ratio hp548xx_CHANN_PROBE_RATIO    7    Saves / Recalls setup to/from the specified register.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    .    [INPUT PARAMETER]

It specifies the setup to be saved/Recalled from the Instrument register.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_COMM_SETUP_SAVE         0  Save command
hp548xx_COMM_SETUP_RECALL       1  Recall command

        [INPUT PARAMETER]

This parameter specifies the value of the Register(0 to 9), where the setup to/from saved/Recalled.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_COMM_REG0               0  Register 0
hp548xx_COMM_REG1               1  Register 1 
hp548xx_COMM_REG2               2  Register 2
hp548xx_COMM_REG3               3  Register 3
hp548xx_COMM_REG4               4  Register 4
hp548xx_COMM_REG5               5  Register 5
hp548xx_COMM_REG6               6  Register 6
hp548xx_COMM_REG7               7  Register 7
hp548xx_COMM_REG8               8  Register 8
hp548xx_COMM_REG9               9  Register 9
    [q$         Instrument Handle                 [$\      Status                            ]          save recall                       ^        memory register number             0    	         >  Recall hp548xx_COMM_SETUP_RECALL Save hp548xx_COMM_SETUP_SAVE            
   0 hp548xx_COMM_REG0 1 hp548xx_COMM_REG1 2 hp548xx_COMM_REG2 3 hp548xx_COMM_REG3 4 hp548xx_COMM_REG4 5 hp548xx_COMM_REG5 6 hp548xx_COMM_REG6 7 hp548xx_COMM_REG7 8 hp548xx_COMM_REG8 9 hp548xx_COMM_REG9    ,    Loads .wvf, .txt, or .set files from disk.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     T    [INPUT PARAMETER]

Specifies the filename to load data from, including extension.     +    [INPUT PARAMETER]

Specifies whether the load will be made   with the setup or the wmem command.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISK_SETUP              0  Setup
hp548xx_DISK_WMEM               1  Waveform Memory
    {    [INPUT PARAMETER]

Specifies either the w-memory number.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_WMEM1                   1  Waveform Memory 1
hp548xx_WMEM2                   2  Waveform Memory 2
hp548xx_WMEM3                   3  Waveform Memory 3
hp548xx_WMEM4                   4  Waveform Memory 4
    c%         Instrument Handle                 d2%X      Status                            f o         filename                          fn          destination                       g        destination number                 0    	           ""  3  Wmemory hp548xx_DISK_WMEM Setup hp548xx_DISK_SETUP                        2    Stores .wvf, .txt, .csv , or .set files to disk.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     _    [INPUT PARAMETER]

Specifies the name of the file to be stored. It does not include a suffix.    n    [INPUT PARAMETER]

Specifies the source to be stored. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISK_SOURCE_CHAN        0  Channel source
hp548xx_DISK_SOURCE_FUNC        1  Function source
hp548xx_DISK_SOURCE_WMEM        2  W. Memory source
hp548xx_DISK_SOURCE_SETUP       3  Setup source
        [INPUT PARAMETER]

Specifies the format of the destination file.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISK_FMT_INT            0  Internal format
hp548xx_DISK_FMT_TYVAL          1  Text Y values format
hp548xx_DISK_FMT_TVERB          2  Text Verbose format
hp548xx_DISK_FMT_TXYP           3  Text X,Y value pairs format
    z    [INPUT PARAMETER]

Represents the channel, function, or waveform memory number.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH_F_W_1                1  Selection 1
hp548xx_CH_F_W_2                2  Selection 2
hp548xx_CH_F_W_3                3  Selection 3
hp548xx_CH_F_W_4                4  Selection 4
    j$         Instrument Handle                 k+$]      Status                            m T         filename                          mr         source                            n        format                            p        source_number                      0    	           ""               Channel hp548xx_DISK_SOURCE_CHAN Function hp548xx_DISK_SOURCE_FUNC Waveform mem. hp548xx_DISK_SOURCE_WMEM Setup hp548xx_DISK_SOURCE_SETUP               Internal hp548xx_DISK_FMT_INT Text Y values hp548xx_DISK_FMT_TYVAL Text Verbose hp548xx_DISK_FMT_TVERB Text X,Y pairs hp548xx_DISK_FMT_TXYP               L1 hp548xx_CH_F_W_1 2 hp548xx_CH_F_W_2 3 hp548xx_CH_F_W_3 4 hp548xx_CH_F_W_4    1    Displays text line at row and column indicated.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.         [INPUT PARAMETER]

This parameter sets the starting row on the screen for string to be Displayed.

MIN = hp548xx_DISP_ROW_MIN            0   
MAX = hp548xx_DISP_ROW_MAX            23
         [INPUT PARAMETER]

This parameter sets the starting Column on the screen for string to be Displayed.

MIN = hp548xx_DISP_COL_MIN            0   
MAX = hp548xx_DISP_COL_MAX            81 
         [INPUT PARAMETER]

It takes String to be Displayed at location specified by row and col parameters. If the text string is longer than the available space on the current line, the excess characters are ignored.    u' (        Instrument Handle                 u'q      Status                            w_ {        row_number                        x  {       col_number                        x          string argument                    0    	                                    Q                   ""    .    Returns information about the captured data.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     \    [INPUT PARAMETER]

Specifies the filename to store the display data, it includes a suffix.        [INPUT PARAMETER]

Specifies the file type to store data.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISP_FTYPE_PCX          0  PCX file format
hp548xx_DISP_FTYPE_BMP          1  BMP file format
hp548xx_DISP_FTYPE_EPS          2  EPS file format
hp548xx_DISP_FTYPE_PS           3  PS file format
hp548xx_DISP_FTYPE_GIF          4  GIF file format
         [INPUT PARAMETER]

Specifies the display setting.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISP_SCRMODE_SCR        0  Screen 
hp548xx_DISP_SCRMODE_GRAT       1  Graticulate
         [INPUT PARAMETER]

Sets the file compression feature On or Off.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISP_COMP_OFF           0  OFF
hp548xx_DISP_COMP_ON            1  ON
        [INPUT PARAMETER]

Sets the inversion mode of the displayed file.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_DISP_INV_NORM           0  Normal 
hp548xx_DISP_INV_INV            1  Inverted
    {D$         Instrument Handle                 {$b      Status                            } m        filename                          }         file type                                   screen mode                        -        compression                        t        inversion                          0    	           ""               PCX hp548xx_DISP_FTYPE_PCX  BMP hp548xx_DISP_FTYPE_BMP EPS hp548xx_DISP_FTYPE_EPS PS hp548xx_DISP_FTYPE_PS GIF hp548xx_DISP_FTYPE_GIF  <  GRAT hp548xx_DISP_SCRMODE_GRAT SCR hp548xx_DISP_SCRMODE_SCR  2 On hp548xx_DISP_COMP_ON Off hp548xx_DISP_COMP_OFF  ;  Inverted hp548xx_DISP_INV_INV Normal hp548xx_DISP_INV_NORM    .    Sets up center frequency and window for FFT.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    c    [INPUT PARAMETER]

Represents the selected function number. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_FUNC1                   1  Function 1
hp548xx_FUNC2                   2  Function 2
hp548xx_FUNC3                   3  Function 3
hp548xx_FUNC4                   4  Function 4
         [INPUT PARAMETER]

The parameter center_frequency sets the center frequency in Hertz when FFT is selected.

MIN = hp548xx_FFT_CFREQ_MIN           -1E12     
MAX = hp548xx_FFT_CFREQ_MAX           1E12 
    i    [INPUT PARAMETER]

The parameter window allows selection of three windows for the FFT function.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_FFT_WINDOW_RECTANGULAR  0  Rectangular window
hp548xx_FFT_WINDOW_HANNING      1  Hanning window
hp548xx_FFT_WINDOW_FLATTOP      2  Flat Top window
    h    [INPUT PARAMETER]

Selects the operand type for the FFTMagnitude command.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANNEL                 0  Channel
hp548xx_FUNCTION                1  Function
hp548xx_WMEMORY                 2  W. Memory
hp548xx_CONSTANT                3  Constant
         [INPUT PARAMETER]

Sets the operand for the FFTMagnitude command.

Must be 1,2,3, or 4 when operand type is set to one of channel, function, or Waveform Memory.        [INPUT PARAMETER]

Turns the display of the specified channel on or off.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_FUNC_DISP_OFF           0  OFF
hp548xx_FUNC_DISP_ON            1  ON
    #         Instrument Handle                 #d      Status                             h        function number                   \ ;       center frequency value            /        window                                     operand type                               operand                            hC        display                            0    	                      dfunction 1 hp548xx_FUNC1 function 2 hp548xx_FUNC2 function 3 hp548xx_FUNC3 function 4 hp548xx_FUNC4 ?      Bm   m                                   rRectangular hp548xx_FFT_WINDOW_RECTANGULAR Hanning hp548xx_FFT_WINDOW_HANNING Flat Top hp548xx_FFT_WINDOW_FLATTOP               iChannel hp548xx_CHANNEL Function hp548xx_FUNCTION Waveform Mem hp548xx_WMEMORY Constant hp548xx_CONSTANT ?      ~7< u7< u                    2 On hp548xx_FUNC_DISP_ON Off hp548xx_FUNC_DISP_OFF        Sets up function selection, horizontal and vertical ranges, and display on/off. Functions included: add, subtract, divide, and multiply.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    c    [INPUT PARAMETER]

Represents the selected function number. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_FUNC1                   1  Function 1
hp548xx_FUNC2                   2  Function 2
hp548xx_FUNC3                   3  Function 3
hp548xx_FUNC4                   4  Function 4
        [INPUT PARAMETER]

Turns the display of the specified function on or off.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_FUNC_DISP_OFF           0  OFF
hp548xx_FUNC_DISP_ON            1  ON
        [INPUT PARAMETER]

Selects the type of operation to be executed between operand 1 and operand 2.

Differentiate operation only requires operand 1.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_FUNC_OP_ADD             0  Add
hp548xx_FUNC_OP_SUB             1  Subtract
hp548xx_FUNC_OP_DIFF            2  Differentiate
hp548xx_FUNC_OP_DIV             3  Divide
hp548xx_FUNC_OP_MULT            4  Multiply
hp548xx_FUNC_OP_VERS            5  Versus
    L    [INPUT PARAMETER]

Selects the operand 1 type.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANNEL                 0  Channel
hp548xx_FUNCTION                1  Function
hp548xx_WMEMORY                 2  W. Memory
hp548xx_CONSTANT                3  Constant         [INPUT PARAMETER]

Specifies the operand 1 number.

Must be 1,2,3, or 4 when operand type is set to one of channel, function, or Waveform Memory.    L    [INPUT PARAMETER]

Selects the operand 2 type.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANNEL                 0  Channel
hp548xx_FUNCTION                1  Function
hp548xx_WMEMORY                 2  W. Memory
hp548xx_CONSTANT                3  Constant         [INPUT PARAMETER]

Specifies the operand 2 number.

Must be 1,2,3, or 4 when operand type is set to one of channel, function, or Waveform Memory.    %         Instrument Handle                 h%_      Status                            H j        function number                    j         display                            jH       operation                           t       operand1 type                     !         operand1                           e       operand2 type                             operand2                           0    	                      dfunction 1 hp548xx_FUNC1 function 2 hp548xx_FUNC2 function 3 hp548xx_FUNC3 function 4 hp548xx_FUNC4  2 On hp548xx_FUNC_DISP_ON Off hp548xx_FUNC_DISP_OFF               Add hp548xx_FUNC_OP_ADD  Subtract hp548xx_FUNC_OP_SUB  Differentiate hp548xx_FUNC_OP_DIFF Divide hp548xx_FUNC_OP_DIV Multiply hp548xx_FUNC_OP_MULT Versus hp548xx_FUNC_OP_VERS               iChannel hp548xx_CHANNEL Function hp548xx_FUNCTION Waveform Mem hp548xx_WMEMORY Constant hp548xx_CONSTANT ?      ~7< u7< u                                 iChannel hp548xx_CHANNEL Function hp548xx_FUNCTION Waveform Mem hp548xx_WMEMORY Constant hp548xx_CONSTANT ?      ~7< u7< u                      ;    Sets up area, factors, and image definition for hardcopy.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.        [INPUT PARAMETER]

Selects which data from the screen is to be printed.  If area is
hp548xx_HCOPY_SCREEN, then the entire screen is printed. If area is hp548xx_HCOPY_GRAT, then only the graticule area of the
screen is printed. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_HCOPY_GRAT              0  Graticule
hp548xx_HCOPY_SCREEN            1  Screen
    0    [INPUT PARAMETER]

Determines whether the oscilloscope setup factors will be appended to screen or graticule images.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_HCOPY_FACT_OFF          0  OFF
hp548xx_HCOPY_FACT_ON           1  ON
    h    [INPUT PARAMETER]

Determines whether the image will be printed Normal, Invert, or Monochrome mode.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_HCOPY_IMAGE_NORMAL      0  Normal print
hp548xx_HCOPY_IMAGE_INVERT      1  Inverted print
hp548xx_HCOPY_IMAGE_MONOC       2  Monochrome print
    # +        Instrument Handle                 #t      Status                                      area                              y         factors                                   image                              0    	         9 Screen hp548xx_HCOPY_SCREEN Graticule hp548xx_HCOPY_GRAT  4 On hp548xx_HCOPY_FACT_ON Off hp548xx_HCOPY_FACT_OFF               iNormal hp548xx_HCOPY_IMAGE_NORMAL Invert hp548xx_HCOPY_IMAGE_INVERT Monochrome hp548xx_HCOPY_IMAGE_MONOC        Returns values for: freq, period, +width,-width, risetime, falltime, duty cycle, Vrms, Vmax, Vmin, Vtop, Vbase, Vavg, Vamp, Vpp, overshoot, preshoot, Vlower, Vupper for selected source.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    [    [INPUT PARAMETER]

Specifies whether the source will be a channel, a function, or a waveform memory. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_MEAS_SOURCE_CHAN        0  Channel 
hp548xx_MEAS_SOURCE_FUNC        1  Function 
hp548xx_MEAS_SOURCE_WMEM        2  W. Memory 
    }    [INPUT PARAMETER]

Specifies the source for channel, function, or waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH_F_W_1                1  Selection 1
hp548xx_CH_F_W_2                2  Selection 2
hp548xx_CH_F_W_3                3  Selection 3
hp548xx_CH_F_W_4                4  Selection 4
        [OUTPUT PARAMETER]

Array contains the returned values.

A result of 9.99999e-37 on any measurement, indicates that the measurement wasn't available for the oscilloscope.

The index inside the array for each specific measurement is as follows:

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_MEAS_FREQUENCY          0   
hp548xx_MEAS_PERIOD             1   
hp548xx_MEAS_PWIDTH             2   
hp548xx_MEAS_NWIDTH             3   
hp548xx_MEAS_RISETIME           4   
hp548xx_MEAS_FALLTIME           5 
hp548xx_MEAS_DUTYCYCLE          6   
hp548xx_MEAS_VRMS_CYC_AC        7 
hp548xx_MEAS_VRMS_CYC_DC        8 
hp548xx_MEAS_VRMS_DIS_AC        9 
hp548xx_MEAS_VRMS_DIS_DC        10
hp548xx_MEAS_VMAX               11
hp548xx_MEAS_VMIN               12
hp548xx_MEAS_VTOP               13
hp548xx_MEAS_VBASE              14
hp548xx_MEAS_VAVG_CYC           15
hp548xx_MEAS_VAVG_DIS           16
hp548xx_MEAS_VAMPLITUDE         17
hp548xx_MEAS_VPP                18
hp548xx_MEAS_OVERSHOOT          19
hp548xx_MEAS_PRESHOOT           20
hp548xx_MEAS_VLOW               21
hp548xx_MEAS_VMID               22
hp548xx_MEAS_VUPP               23
    % %        Instrument Handle                 I%n      Status                            ) m        source                             mM       source_number                               results array                      0    	                      jChannel hp548xx_DISK_SOURCE_CHAN Function hp548xx_DISK_SOURCE_FUNC Waveform mem. hp548xx_DISK_SOURCE_WMEM               L1 hp548xx_CH_F_W_1 2 hp548xx_CH_F_W_2 3 hp548xx_CH_F_W_3 4 hp548xx_CH_F_W_4    	                Returns values for specific measurement on selected source: freq, period, +width,-width, risetime, falltime, duty cycle, Vrms,Vmax,Vmin, Vtop, Vbase, Vavg, Vamp, Vpp, overshoot, preshoot, Vlower, Vupper for selected source.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    X    [INPUT PARAMETER]

Specifies whether the source will be a channel, a function, or a waveform memory. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_MEAS_SOURCE_CHAN        0  Channel
hp548xx_MEAS_SOURCE_FUNC        1  Function
hp548xx_MEAS_SOURCE_WMEM        2  W. Memory
    }    [INPUT PARAMETER]

Specifies the source for channel, function, or waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH_F_W_1                1  Selection 1
hp548xx_CH_F_W_2                2  Selection 2
hp548xx_CH_F_W_3                3  Selection 3
hp548xx_CH_F_W_4                4  Selection 4
     -    [OUTPUT PARAMETER]

Returns measured value.        [INPUT PARAMETER]

Specify measurement to be performed.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_MEAS_FREQUENCY          0   
hp548xx_MEAS_PERIOD             1   
hp548xx_MEAS_PWIDTH             2   
hp548xx_MEAS_NWIDTH             3   
hp548xx_MEAS_RISETIME           4   
hp548xx_MEAS_FALLTIME           5  
hp548xx_MEAS_DUTYCYCLE          6   
hp548xx_MEAS_VRMS_CYC_AC        7  
hp548xx_MEAS_VRMS_CYC_DC        8  
hp548xx_MEAS_VRMS_DIS_AC        9  
hp548xx_MEAS_VRMS_DIS_DC        10 
hp548xx_MEAS_VMAX               11 
hp548xx_MEAS_VMIN               12 
hp548xx_MEAS_VTOP               13 
hp548xx_MEAS_VBASE              14 
hp548xx_MEAS_VAVG_CYC           15  
hp548xx_MEAS_VAVG_DIS           16  
hp548xx_MEAS_VAMPLITUDE         17  
hp548xx_MEAS_VPP                18  
hp548xx_MEAS_OVERSHOOT          19  
hp548xx_MEAS_PRESHOOT           20 
hp548xx_MEAS_VLOW               21  
hp548xx_MEAS_VMID               22  
hp548xx_MEAS_VUPP               23 
    %         Instrument Handle                 $      Status                             s        source                            R s       source_number                               result                             s\       measurement                        0    	                      jChannel hp548xx_DISK_SOURCE_CHAN Function hp548xx_DISK_SOURCE_FUNC Waveform mem. hp548xx_DISK_SOURCE_WMEM               L1 hp548xx_CH_F_W_1 2 hp548xx_CH_F_W_2 3 hp548xx_CH_F_W_3 4 hp548xx_CH_F_W_4    	                     Frequency hp548xx_MEAS_FREQUENCY Period hp548xx_MEAS_PERIOD P Width hp548xx_MEAS_PWIDTH N Width hp548xx_MEAS_NWIDTH Rise time hp548xx_MEAS_RISETIME Fall time hp548xx_MEAS_FALLTIME Duty cycle hp548xx_MEAS_DUTYCYCLE Vrms Cycle AC hp548xx_MEAS_VRMS_CYC_AC Vrms Cycle DC hp548xx_MEAS_VRMS_CYC_DC Vrms Display AC hp548xx_MEAS_VRMS_DIS_AC Vrms Display DC hp548xx_MEAS_VRMS_DIS_DC Vmax hp548xx_MEAS_VMAX Vmin hp548xx_MEAS_VMIN Vtop hp548xx_MEAS_VTOP Vbase hp548xx_MEAS_VBASE Vavg Cycle hp548xx_MEAS_VAVG_CYC Vavg Display hp548xx_MEAS_VAVG_DIS Vampl hp548xx_MEAS_VAMPLITUDE Vpp hp548xx_MEAS_VPP Overshoot hp548xx_MEAS_OVERSHOOT Preshoot hp548xx_MEAS_PRESHOOT Vlow hp548xx_MEAS_VLOW Vmid hp548xx_MEAS_VMID Vupper hp548xx_MEAS_VUPP   =    Causes the oscilloscope to evaluate all input signals and find the optimum conditions for displaying the signal and find the optimum conditions for viewing the signal. It searches each of the channels for input signals and shutts off channels where no signal is found. It adjusts the vertical gain and offset for each channel that has a signal, and sets the time base on the lowest numbered input channel that has a signal. 

Autoscale sets the following:
    Channel display, Scale and Offset
    Trigger sweep, Mode, Edge Source, Level, Slope, Hysteresis, and Holdoff
    Acquisition sampling rate and memory depth
    Time scale base and position
    Marker mode set to measurement
    Resets completion criteria
Autoscale turns off the following:
    Measurement on sources turned off
    Functions, Windows, and Memories.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    |%         Instrument Handle                 %_      Status                             0    	           <    Turns on/off active channel, function, or waveform memory.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.        [INPUT PARAMETER]

Selects to turn on/off active channel, function, or waveform memory. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_BLANK                   0  Blank
hp548xx_VIEW                    1  View
    4    [INPUT PARAMETER]

Selects channel, function, or waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANNEL                 0  Channel
hp548xx_FUNCTION                1  Function
hp548xx_WMEMORY                 2  W. Memory
    u    [INPUT PARAMETER]

Selects specific channel, function, or waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH_F_W_1                1  Selection 1
hp548xx_CH_F_W_2                2  Selection 2
hp548xx_CH_F_W_3                3  Selection 3
hp548xx_CH_F_W_4                4  Selection 4
    {%         Instrument Handle                 %b      Status                            ϻ U         setting                                    source                             ;       source_number                      0    	         &  View hp548xx_VIEW Blank hp548xx_BLANK               PChannel hp548xx_CHANNEL Function hp548xx_FUNCTION Waveform mem. hp548xx_WMEMORY               L1 hp548xx_CH_F_W_1 2 hp548xx_CH_F_W_2 3 hp548xx_CH_F_W_3 4 hp548xx_CH_F_W_4        Digitizes the signal.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    c    [INPUT PARAMETER]

Selects specific channel or  function.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH_F_W_1                1  Selection 1
hp548xx_CH_F_W_2                2  Selection 2
hp548xx_CH_F_W_3                3  Selection 3
hp548xx_CH_F_W_4                4  Selection 4         [INPUT PARAMETER]

Selects channel or function.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANNEL                 0  Channel
hp548xx_FUNCTION                1  Function    հ$         Instrument Handle                 $f      Status                             G       source_number                     [          source                             0    	                      L1 hp548xx_CH_F_W_1 2 hp548xx_CH_F_W_2 3 hp548xx_CH_F_W_3 4 hp548xx_CH_F_W_4  2  Function hp548xx_FUNCTION Channel hp548xx_CHANNEL    C    Print to hardcopy device using factors set in hardcopy subsystem.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    %         Instrument Handle                 w%g      Status                             0    	           "    Starts the oscilloscope running.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    $         Instrument Handle                 \$_      Status                             0    	               Stops the acquisition.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    $         Instrument Handle                 7$f      Status                             0    	           Z    Causes the oscilloscope to make a single acquisition when the next trigger event occurs.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    %         Instrument Handle                 T%b      Status                             0    	           R    Stores a channel, function, or stored waveform to the indicated waveform memory.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    4    [INPUT PARAMETER]

Selects channel, function, or waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHANNEL                 0  Channel
hp548xx_FUNCTION                1  Function
hp548xx_WMEMORY                 2  W. Memory
    u    [INPUT PARAMETER]

Selects specific channel, function, or waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH_F_W_1                1  Selection 1
hp548xx_CH_F_W_2                2  Selection 2
hp548xx_CH_F_W_3                3  Selection 3
hp548xx_CH_F_W_4                4  Selection 4
    q    [INPUT PARAMETER]

Selects specific waveform memory to store waveform.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_WMEM1                   1  W. Memory 1
hp548xx_WMEM2                   2  W. Memory 2
hp548xx_WMEM3                   3  W. Memory 3
hp548xx_WMEM4                   4  W. Memory 4
    	$         Instrument Handle                 i$g      Status                            I         source                             "       source_number                             destination                        0    	                      PChannel hp548xx_CHANNEL Function hp548xx_FUNCTION Waveform mem. hp548xx_WMEMORY               L1 hp548xx_CH_F_W_1 2 hp548xx_CH_F_W_2 3 hp548xx_CH_F_W_3 4 hp548xx_CH_F_W_4               dW memory 1 hp548xx_WMEM1 W memory 2 hp548xx_WMEM2 W memory 3 hp548xx_WMEM3 W memory 4 hp548xx_WMEM4        Performs setup query and stores in the specified filename.
Information is written in a binary block  data format as defined in the IEEE 488.2 standard.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     S    [INPUT PARAMETER]

Specifies the filename for data destination, including suffix.    d&         Instrument Handle                 &g      Status                                      filename                           0    	           ""    t    This function puts system setup information in binary IEEE 488.2 format to the instrument from the specified file.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     {    [INPUT PARAMETER]

Specifies the binary filename to retrieve the system Setup. This should be a Binary IEEE 488.2 format.    1$         Instrument Handle                 $h      Status                            q          filename                           0    	           ""    3    Defines horizontal range, position and reference.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.         [INPUT PARAMETER]

Sets the time interval between the trigger event and the delay reference point. 

MIN = hp548xx_TIM_POS_MIN             -10  
MAX = hp548xx_TIM_POS_MAX             10   
         [INPUT PARAMETER]

Full scale horizontal range.

MIN = hp548xx_TIM_RANGE_MIN           1E-9 
MAX = hp548xx_TIM_RANGE_MAX           50   

    g    [INPUT PARAMETER]

Sets the delay reference to the left, center, or right side of the display. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_TIM_REF_LEFT            0  Left reference
hp548xx_TIM_REF_CENTER          1  Center reference
hp548xx_TIM_REF_RIGHT           2  Right reference
    %         Instrument Handle                 E%h      Status                            %         position                           P       full scale range                           reference                          0    	        ?      @$      $                         ?      @V     >.&֕?                              TLeft hp548xx_TIM_REF_LEFT Center hp548xx_TIM_REF_CENTER Right hp548xx_TIM_REF_RIGHT    _    Sets trigger mode to EDGE and defines edge trigger source, slope, level, sweep, and coupling.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.        [INPUT PARAMETER]

Selects the source for edge mode triggering.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_AUX                     0  Aux source
hp548xx_CHAN1                   1  Channel 1
hp548xx_CHAN2                   2  Channel 2
hp548xx_CHAN3                   3  Channel 3
hp548xx_CHAN4                   4  Channel 4
hp548xx_EXT                     5  External source
hp548xx_LINE                    6  Line source
         [INPUT PARAMETER]

The trigger level on the specified channel, external trigger, or auxiliary trigger input.

MAX = hp548xx_TRIG_LEVEL_MIN          -60
MIN = hp548xx_TRIG_LEVEL_MAX          60    ;    [INPUT PARAMETER]

Specifies the oscilloscope sweep mode. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_TRIG_SWEEP_AUTO         0  Auto sweep 
hp548xx_TRIG_SWEEP_TRIGG        1  Triggered sweep
hp548xx_TRIG_SWEEP_SINGLE       2  Single sweep
        [INPUT PARAMETER]

Sets the trigger coupling when TRIG:EDGE:SOURCE is set to one of the channels.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_TRIG_COUP_AC            0  AC coupling
hp548xx_TRIG_COUP_DC            1  DC coupling
hp548xx_TRIG_COUP_LFR           2  LFR coupling
hp548xx_TRIG_COUP_HFR           3  HFR coupling
        [INPUT PARAMETER]

Sets the slope for the previously selected source. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_TRIG_SLOPE_POS          0  Positive slope
hp548xx_TRIG_SLOPE_NEG          1  Negative slope
    )%         Instrument Handle                 %`      Status                           i G       source                           c  R       trigger level                    -         sweep mode                       p =       coupling                          f        slope                              0    	                     Aux hp548xx_AUX Channel 1 hp548xx_CHAN1 Channel 2 hp548xx_CHAN2 Channel 3 hp548xx_CHAN3 Channel 4 hp548xx_CHAN4 Ext hp548xx_EXT Line hp548xx_LINE ?      @N      N                                       aAuto hp548xx_TRIG_SWEEP_AUTO Triggered hp548xx_TRIG_SWEEP_TRIGG Single hp548xx_TRIG_SWEEP_SINGLE              dAC hp548xx_TRIG_COUP_AC DC hp548xx_TRIG_COUP_DC LFR hp548xx_TRIG_COUP_LFR HFR hp548xx_TRIG_COUP_HFR  @  Negative hp548xx_TRIG_SLOPE_NEG Positive hp548xx_TRIG_SLOPE_POS    D    Defines source, level, polarity, width, and sweep for glitch mode.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.        [INPUT PARAMETER]

Selects the source for glitch mode triggering.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CHAN1                   1  Channel 1
hp548xx_CHAN2                   2  Channel 2
hp548xx_CHAN3                   3  Channel 3
hp548xx_CHAN4                   4  Channel 4
hp548xx_EXT                     5  Ext source
         [INPUT PARAMETER]

The trigger level on the specified channel, external trigger, or auxiliary trigger input.

MAX = hp548xx_TRIG_LEVEL_MIN          -60
MIN = hp548xx_TRIG_LEVEL_MAX          60    :    [INPUT PARAMETER]

Specifies the oscilloscope sweep mode. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_TRIG_SWEEP_AUTO         0  Auto sweep
hp548xx_TRIG_SWEEP_TRIGG        1  Triggered sweep
hp548xx_TRIG_SWEEP_SINGLE       2  Single sweep
         [INPUT PARAMETER]

Defines the polarity of the glitch. 

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_TRIG_POLARITY_POS       0  Positive
hp548xx_TRIG_POLARITY_NEG       1  Negative
         [INPUT PARAMETER]

Sets the glitch width. The scope will trigger on a pulse whose width is less than the specified width. 

MAX = hp548xx_TRIG_WIDTH_MIN          1.5E-6
MIN = hp548xx_TRIG_WIDTH_MAX          160E-3
   $         Instrument Handle                
I$a      Status                           ) T        source                             Z       trigger level                             sweep mode                        m        polarity                                 width                              0    	                      pChannel 1 hp548xx_CHAN1 Channel 2 hp548xx_CHAN2 Channel 3 hp548xx_CHAN3 Channel 4 hp548xx_CHAN4 Ext hp548xx_EXT ?      @N      N                                       aAuto hp548xx_TRIG_SWEEP_AUTO Triggered hp548xx_TRIG_SWEEP_TRIGG Single hp548xx_TRIG_SWEEP_SINGLE  @  Negative hp548xx_TRIG_SLOPE_NEG Positive hp548xx_TRIG_SLOPE_POS ?6C-?zG{>*sqT>*sqT                  Returns values to calculate x,y values from waveform data. Returns the following: number of points, x increment, y increment, x origin, y origin, x reference, and y reference values.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     Q    [OUTPUT PARAMETER]

Returns the points value in the current waveform preamble.         [OUTPUT PARAMETER]

Returns the Xincrement,Xorigin,Yincrement, and Yorigin data in array format with the following indexes.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_WAV_XINC                0  X increment index
hp548xx_WAV_XOR                 1  X origin index
hp548xx_WAV_YINC                2  Y increment index
hp548xx_WAV_YOR                 3  Y origin index
   $ '        Instrument Handle                $p      Status                                     points                            )        data                               0    	           	            	            0    Sets data transmission mode for waveform data.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    Q    [INPUT PARAMETER]

Sets data transmission mode for waveform data.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_WAV_FORMAT_ASCII        0  ASCII
hp548xx_WAV_FORMAT_BYTE         1  Byte
hp548xx_WAV_FORMAT_LONG         2  Long
hp548xx_WAV_FORMAT_WORD         3  Word
   #         Instrument Handle                o#d      Status                            O "       format                             0    	                      vAscii hp548xx_WAV_FORMAT_ASCII Byte hp548xx_WAV_FORMAT_BYTE Long hp548xx_WAV_FORMAT_LONG Word hp548xx_WAV_FORMAT_WORD    )    Displays the indicated waveform memory.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.        [INPUT PARAMETER]

Enables or disables the viewing of the selected waveform memory.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_WMEM_DISP_OFF           0  OFF
hp548xx_WMEM_DISP_ON            1  ON
    c    [INPUT PARAMETER]

Specifies the waveform memory number.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_WMEM1                   1  W. Memory 1
hp548xx_WMEM2                   2  W. Memory 2
hp548xx_WMEM3                   3  W. Memory 3
hp548xx_WMEM4                   4  W. Memory 4
   #$ ,        Instrument Handle                #n$u      Status                           %N          display                          &e V       source                             0    	         2  On hp548xx_WMEM_DISP_ON Off hp548xx_WMEM_DISP_OFF               dW memory 1 hp548xx_WMEM1 W memory 2 hp548xx_WMEM2 W memory 3 hp548xx_WMEM3 W memory 4 hp548xx_WMEM4   |    The reset function places the instrument in a default state. Before issuing this function, it may be necessary to send a device clear to ensure that the instrument can execute a reset.  A device clear can be issued by invoking hp548xx_dcl().

For the states affected by the reset command, see the instrument manual.

Reset does not affect the status system or clear any errors.         The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
   *
k      Status                           ,
 "        Instrument Handle                  	           0   0    The self-test function causes the instrument to perform a self-test and returns the result of that self-test.  This is used to verify that an instrument is operating properly.  A failure may indicate a potential hardware problem.

For a list of possible self-test errors, consult the instrument manual.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     \    [OUTPUT PARAMETER]

Numeric result from self-test operation.

0 = no error ( test passed)
     T    [OUTPUT PARAMETER]

Self-test status message.  This is limited to 256 characters.
   .o      Status                           0 "        Instrument  Handle               1 1 "       Self Test Result                 1x  "      Self Test Message                  	           0    	            	            r    This function translates the error value returned from an instrument driver function to a user-readable string.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     l    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().  It may be VI_NULL.      P    [INPUT PARAMETER]

The error return value from an instrument driver function.
     P    [OUTPUT PARAMETER]

Error message string.  This is limited to 256 characters.
   3K	q      Status                           5,	 "        Instrument Handle                5 6 "       Status Code                      5  "      Message                            	           0    0    	               This function returns the error numbers and corresponding error messages in the error queue of an instrument.  See the manual for a listing of the instrument error numbers and messages.

Instrument errors may occur when a user attempts to place the instrument in an invalid state such as sending an invalid sequence of coupled commands.

Instrument errors can be detected by polling.  Automatic polling can be accomplished by using the hp548xx_errorQueryDetect() function.

        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     .    [INPUT PARAMETER]

Instrument's error code.
     V    [OUTPUT PARAMETER]

Instrument's error message.  This is limited to 256 characters.
   9*n      Status                           ; "        Instrument Handle                ;k / "       Error Code                       ;  "      Error Message                      	           0    	            	            m    This function returns the revision of the instrument driver and the firmware of the instrument being used.         The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     V    [OUTPUT PARAMETER]

Instrument driver revision.  This is limited to 256 characters.
     X    [OUTPUT PARAMETER]

Instrument firmware revision.  This is limited to 256 characters.
   =q
q      Status                           ?R
 "        Instrument Handle                ? /   ,    Instrument Driver Revision       @    ,    Firmware Revision                  	           0    	            	           W    The timeout function sets the timeout value for driver I/O transactions in milliseconds. The timeout period may vary on computer platforms.

The default timeout period varies by VISA implementation.  For HP VISA, it is 2 seconds.

Some implementations of VISA will only accept a limited number of timeout values.  If you set the VISA timeout to a given value using one of those implementations, and then query the timeout, you may find that the query returns a different value than the one you set.  HP VISA sets the timeout to the precise value you specify, and returns that value when queried. 
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
         [INPUT PARAMETER]

This value sets the I/O timeout for all functions in the driver. It is specified in milliseconds. 

MAX = hp548xx_TIMEOUT_MAX   2147483647
MIN = hp548xx_TIMEOUT_MIN   0
   Ct      Status                           E "        Instrument Handle                F
         Set Time Out                       	           0                           The timeout query function returns the timeout value for driver I/O transactions in milliseconds.  The timeout period may vary on computer platforms.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     y    [OUTPUT PARAMETER]

This value sets the I/O timeout for all functions in the driver. It is specified in milliseconds. 
   H:
r      Status                           J
 "        Instrument Handle                J{ n       Time Out                           	           0    	           +    This function enables or disables automatic instrument error checking.

When automatic instrument error querying is enabled, the driver will query the instrument for an error before returning from each driver function.  This adds the overhead of one instrument query to each driver function call.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
         [INPUT PARAMETER]

A boolean which enables/disables automatic instrument error querying.  

If VI_TRUE, enable automatic instrument error querying.

If VI_FALSE, disable automatic instrument error querying.
   L	t      Status                           N	 "        Instrument Handle                O, }         Set Error Query Detect             	           0     Enable VI_TRUE Disable VI_FALSE   =    This function indicates if automatic instrument error detection is enabled or disabled. 

When automatic instrument error querying is enabled, the driver will query the instrument for an error before returning from each driver function.  This adds the overhead of one instrument query to each driver function call.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
         [OUTPUT PARAMETER]

A boolean which indicates if automatic instrument error querying is enabled or disabled.  

If VI_TRUE, automatic instrument error querying is enabled.

If VI_FALSE, automatic instrument error querying is disabled.
   Rv      Status                           S "        Instrument Handle                T^ 4    d    Error Query Detect                 	           0    	               This function sends a device clear (DCL) to the instrument.

A device clear will abort the current operation and enable the instrument to accept a new command or query.

This is particularly useful in situations where it is not possible to determine the instrument state. In this case, it is customary to send a device clear before issuing a new instrument driver function.  The device clear ensures that the instrument will be able to begin processing the new commands.

        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
   Wu      Status                           Y "        Instrument Handle                  	           0    B    This function sends the *OPC? common command to the instrument.         The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
         [OUTPUT PARAMETER]

If VI_TRUE, all instrument operations are complete.

If VI_FALSE, instrument operations are still pending.

   Zu      Status                           \ "        Instrument Handle                ]8 0         Instrument Ready                   	           0    	            )    This function queries the status byte.         The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     4    [OUTPUT PARAMETER]

The value of the status byte.
   ^v      Status                           ` "        Instrument Handle                ` /    d    StatusByte                         	           0    	            l    This function passes an instrument command to the instrument.  The function does not expect any response.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL terminated C string and may not exceed 256 bytes in length.
   b\s      Status                           d; "        Instrument Handle                d 1 "      Send String Command                	           0    ""       Passes the command string to the instrument.  The function waits for a response which must be a string (character data).

A max of size-1 bytes will be read from the instrument into the string and the string will be NULL terminated (so its length can be found with strlen).

If more than size-1 bytes are generated by the instrument then remaining bytes will be discarded and the instrument's output buffer will be cleared.
         The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
         [INPUT PARAMETER]

The length of result array in bytes. 

MIN = hp548xx_CMDSTRING_Q_MIN   1
MAX = hp548xx_CMDSTRING_Q_MAX   2147483647
     8    [OUTPUT PARAMETER]

The response from the instrument.
   go      Status                           ig "        Instrument Handle                i 0 "      Query String Command             jK r "       String Size                      j  "      String Result                      	           0    " "                     	                This function passes the string in cmd_str followed by a space and then an integer.  Note that either a ViInt16 or 32 can be passed, as the ViInt16 will be promoted.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
         [INPUT PARAMETER]

The integer to be appended to the command string. 

MIN = hp548xx_CMDINT_MIN   -2147483647
MAX = hp548xx_CMDINT_MAX    2147483647
   mt      Status                           n "        Instrument Handle                oO / "      Send Integer Command             o p $       Send Integer                       	           0    ""                     t    Passes the command string to the instrument.  The function expects a 16-bit integer response from the instrument.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
     8    [OUTPUT PARAMETER]

The response from the instrument.
   qq      Status                           s "        Instrument Handle                t/ / "      Query I16 Command                t n "        I16 Result                         	           0    ""    	            t    Passes the command string to the instrument.  The function expects a 32-bit integer response from the instrument.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
     8    [OUTPUT PARAMETER]

The response from the instrument.
   vf
q      Status                           xE
 "        Instrument Handle                x . "      Query I32 Command                y) n "       I32 Result                         	           0    ""    	                Passes the command string to the instrument.  The function expects the instrument to return a definite arbitrary block of 16-bit integers.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require atention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
         [INPUT PARAMETER]

The size (elements) of the result array passed into the function.

MIN = hp548xx_CMDINT16ARR_Q_MIN   1
MAX = hp548xx_CMDINT16ARR_Q_MAX   2147483647
     8    [OUTPUT PARAMETER]

The response from the instrument.
     O    [OUTPUT PARAMETER]

The number of array elements returned by the instrument.
   zs      Status                           | "        Instrument Handle                }3 / "      Query I16 Array Command          } j &       I16 Array Size                   ~h  "       I16 Array Result                 ~         I16 Array Count                    	           0    ""                     	            	                Passes the command string to the instrument.  The function expects the instrument to return a definite arbitrary block of 16-bit integers.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
         [INPUT PARAMETER]

The size (elements) of the result array passed into the function.

MIN = hp548xx_CMDINT16ARR_Q_MIN   1
MAX = hp548xx_CMDINT16ARR_Q_MAX   2147483647
     8    [OUTPUT PARAMETER]

The response from the instrument.
     O    [OUTPUT PARAMETER]

The number of array elements returned by the instrument.
   s      Status                            "        Instrument Handle                W / "      Query I32 Array Command           h &       I32 Array Size                     "       I32 Array Result                          I32 Array Count                    	           0    ""                     	            	                This function passes the string in cmd_str followed by a space and then a real.  Note that either a ViReal32 or 64 can be passed as the ViReal32 will be promoted.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
         [INPUT PARAMETER]

The real number to be appended to the command string. 

MAX = hp548xx_CMDREAL_MAX    1E+300
MIN = hp548xx_CMDREAL_MIN   -1E+300
   Tt      Status                           3 "        Instrument Handle                 0 "      Send Real Command                 o "       Send Real                          	           0    "" }sk;~7< u7< u                      q    Passes the command string to the instrument.  The function expects a 64-bit real response from the instrument.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
     8    [OUTPUT PARAMETER]

The response from the instrument.
   Cq      Status                           " "        Instrument Handle                 . "      Query Real Command                p "        Real Result                        	           0    ""    	           N    This application function converts waveform data to time and voltage values.     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.    f    [INPUT PARAMETER]

Specifies the channel to take measurements from.

 Macro Name                 Value  Description
-----------------------------------------------------------
hp548xx_CH1                     1  Channel 1
hp548xx_CH2                     2  Channel 2
hp548xx_CH3                     3  Channel 3
hp548xx_CH4                     4  Channel 4
     =    [OUTPUT PARAMETER]

Contains the number of returned values.     B    [OUTPUT PARAMETER]

Array contains the returned values for time.     E    [OUTPUT PARAMETER]

Array contains the returned values for voltage.   $ (        Instrument Handle                $q      Status                                    source                           A          points                                    time_value                                volts                              0    	                      `Channel 1 hp548xx_CHAN1 Channel 2 hp548xx_CHAN2 Channel 3 hp548xx_CHAN3 Channel 4 hp548xx_CHAN4    	            	            	                The close function terminates the software connection to the instrument and de-allocates system resources.  It is generally a good programming habit to close the instrument handle when the program is done using the instrument.         The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp548xx_error_message() function to get a textual description of errors and warnings.
     X    [INPUT PARAMETER]

The instrument's VISA session handle returned from hp548xx_init().
   q      Status                            "        Instrument Handle                  	           0          "V  '     K-    init                                     )h  8     K.    acquireSetup                             >  BO     K.    set54845Aconfig                          CD  JP     K.    channelScale                             L'  W     K.    channelInputSetup                        [2  a     K.    saveRecallSetup                          c  i$     K.    loadFromDisk                             j  r     K.    storeToDisk                              t  y     K.    displayData                              {       K.    displayData_Q                            {       K.    funcFftSetup                             v   	    K.    funcOper                                 E  !     K.    hardCopySetup                            &       K.    measureAll_Q                               '     K.    measureOne_Q                             7  ̼     K.    autoscale                                7  Ӕ     K.    blankView                                Ց  W     K.    digitize                                   W     K.    printScreen                                <     K.    run                                             K.    stop                                       4     K.    single                                     {     K.    storeWaveform                                   K.    systemSetup_Q                                   K.    systemSetup                                     K.    timebaseRange                             	'     K.    edgeTriggerSetup                              K.    glitchTriggerSetup                            K.    waveformScaling_Q                        !     K.    waveformFormat                          " '     K.    displayWmem                             )] -!     K-    reset                                   - 1     K-    self_test                               2 6P     K-    error_message                           7F ;     K-    error_query                             < @p     K-    revision_query                          Am F     K-    timeOut                                 G J     K-    timeOut_Q                               K P     K-    errorQueryDetect                        P US     K-    errorQueryDetect_Q                      V Z2     K-    dcl                                     Z ]     K-    opc_Q                                   ^~ a,     K-    readStatusByte_Q                        a e     K-    cmd                                     e k     K-    cmdString_Q                             l` pr     K-    cmdInt                                  qt t     K-    cmdInt16_Q                              u yi     K-    cmdInt32_Q                              z` ~     K-    cmdInt16Arr_Q                            #     K-    cmdInt32Arr_Q                                 K-    cmdReal                                  F     K-    cmdReal64_Q                             =      K.    waveformArray_Q                          -     K-    close                                                                      DInitialize                          |Subsystem functions                 Acquire                              DAcquire Setup                        DSet Hp54845A config                 
FChannel                              DChannel Scale                        DChannel Input Setup                 Common                               DSave Recall Setup                   lDisk                                 DLoad From Disk                       DStore To Disk                       FDisplay                              DDisplay Data                         DDisplay Data Query                  &Function                             DFFT Setup                            DOper                                Hardcopy                             DHard Copy Setup                     MMeasure                              DMeasure All Query                    DMeasure One Query                   Root                                 DAutoscale                            DBlank View                           DDigitize                             DPrint Screen                         DRun                                  DStop                                 DSingle                               DStore Waveform                      System                               DSystem Setup Query                   DSystem Setup                        Timebase                             DTimebase Range                      |Trigger                              DEdge Trigger Setup                   DGlitch Trigger Setup                Waveform                             DWaveform Scaling Query               DWaveform Format                     kWmemory                              DDisplay Waveform Memory             Utility                              DReset                                DSelf-Test                            DError Message                        DError Query                          DRevision Query                       DSet Timeout                          DQuery Timeout                        DSet Error Query Detect               DQuery Error Query Detect             DDevice Clear                         D*OPC?                                DRead Status Byte                    Passthrough Functions                DSend String                          DQuery String                         DSend Integer                         DQuery Int16                          DQuery Int32                          DQuery Int16 Array                    DQuery Int32 Array                    DSend Real                            DQuery Real64                         Applications                         DWaveform Array Query                 DClose                           