/*****************************************************************************/
/*  hp548xx.h                                                                */
/*  Copyright (C) 1997 Hewlett-Packard Company                               */
/*---------------------------------------------------------------------------*/
/*  Driver for hp548xx, Hewlett Packard Infiniium Oscilloscopes hp548xx      */
/*  Driver Version:                                                          */
/*****************************************************************************/

#ifndef hp548xx_INCLUDE 
#define hp548xx_INCLUDE
#include "vpptype.h"

/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*  STANDARD SECTION                                                         */
/*  Constants and function prototypes for HP standard functions.             */
/*****************************************************************************/

        /***************************************************/
        /*  Standard constant error conditions returned    */
        /*  by driver functions.                           */
        /*    HP Common Error numbers start at BFFC0D00    */
        /*    The parameter errors extend the number of    */
        /*      errors over the eight defined in VPP 3.4   */
        /***************************************************/

#define hp548xx_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hp548xx_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hp548xx_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hp548xx_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hp548xx_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hp548xx_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */
#define hp548xx_INSTR_NO_LAST_COMMA       (_VI_ERROR+0x3FFC0D08L) /* 0xBFFC0D08 */ 

#define hp548xx_INSTR_ERROR_PARAMETER9    (_VI_ERROR+0x3FFC0D20L) /* 0xBFFC0D20 */
#define hp548xx_INSTR_ERROR_PARAMETER10   (_VI_ERROR+0x3FFC0D21L) /* 0xBFFC0D21 */
#define hp548xx_INSTR_ERROR_PARAMETER11   (_VI_ERROR+0x3FFC0D22L) /* 0xBFFC0D22 */
#define hp548xx_INSTR_ERROR_PARAMETER12   (_VI_ERROR+0x3FFC0D23L) /* 0xBFFC0D23 */
#define hp548xx_INSTR_ERROR_PARAMETER13   (_VI_ERROR+0x3FFC0D24L) /* 0xBFFC0D24 */
#define hp548xx_INSTR_ERROR_PARAMETER14   (_VI_ERROR+0x3FFC0D25L) /* 0xBFFC0D25 */
#define hp548xx_INSTR_ERROR_PARAMETER15   (_VI_ERROR+0x3FFC0D26L) /* 0xBFFC0D26 */
#define hp548xx_INSTR_ERROR_PARAMETER16   (_VI_ERROR+0x3FFC0D27L) /* 0xBFFC0D27 */
#define hp548xx_INSTR_ERROR_PARAMETER17   (_VI_ERROR+0x3FFC0D28L) /* 0xBFFC0D28 */
#define hp548xx_INSTR_ERROR_PARAMETER18   (_VI_ERROR+0x3FFC0D29L) /* 0xBFFC0D29 */

        /***************************************************/
        /*  Constants used by system status functions      */
        /*    These defines are bit numbers which define   */
        /*    the operation and questionable registers.    */
        /*    They are instrument specific.                */
        /***************************************************/

#define hp548xx_QUES_BIT0          1
#define hp548xx_QUES_BIT1          2
#define hp548xx_QUES_BIT2          4
#define hp548xx_QUES_BIT3          8
#define hp548xx_QUES_BIT4         16
#define hp548xx_QUES_BIT5         32
#define hp548xx_QUES_BIT6         64
#define hp548xx_QUES_BIT7        128
#define hp548xx_QUES_BIT8        256
#define hp548xx_QUES_BIT9        512
#define hp548xx_QUES_BIT10      1024
#define hp548xx_QUES_BIT11      2048
#define hp548xx_QUES_BIT12      4096
#define hp548xx_QUES_BIT13      8192
#define hp548xx_QUES_BIT14     16384
#define hp548xx_QUES_BIT15     32768

#define hp548xx_OPER_BIT0          1
#define hp548xx_OPER_BIT1          2
#define hp548xx_OPER_BIT2          4
#define hp548xx_OPER_BIT3          8
#define hp548xx_OPER_BIT4         16
#define hp548xx_OPER_BIT5         32
#define hp548xx_OPER_BIT6         64
#define hp548xx_OPER_BIT7        128
#define hp548xx_OPER_BIT8        256
#define hp548xx_OPER_BIT9        512
#define hp548xx_OPER_BIT10      1024
#define hp548xx_OPER_BIT11      2048
#define hp548xx_OPER_BIT12      4096
#define hp548xx_OPER_BIT13      8192
#define hp548xx_OPER_BIT14     16384
#define hp548xx_OPER_BIT15     32768

        /***************************************************/
        /*  Constants used by function hp548xx_timeOut      */
        /***************************************************/

#define hp548xx_TIMEOUT_MAX         2147483647L
#define hp548xx_TIMEOUT_MIN         0L

#define hp548xx_CMDINT16ARR_Q_MIN   1L
#define hp548xx_CMDINT16ARR_Q_MAX   2147483647L

#define hp548xx_CMDINT32ARR_Q_MIN   1L
#define hp548xx_CMDINT32ARR_Q_MAX   2147483647L

#define hp548xx_CMDREAL64ARR_Q_MIN  1L
#define hp548xx_CMDREAL64ARR_Q_MAX  2147483647L


        /***************************************************/
        /*  Required plug and play functions from VPP-3.1  */
        /***************************************************/

ViStatus _VI_FUNC hp548xx_init
                        (ViRsrc     resourceName,
                         ViBoolean  IDQuery,
                         ViBoolean  resetDevice,
                         ViPSession instrumentHandle);

ViStatus _VI_FUNC hp548xx_close
                        (ViSession  instrumentHandle);

ViStatus _VI_FUNC hp548xx_reset
                        (ViSession  instrumentHandle);

ViStatus _VI_FUNC hp548xx_self_test
                        (ViSession  instrumentHandle,
                         ViPInt16   selfTestResult,
                         ViPString  selfTestMessage);

ViStatus _VI_FUNC hp548xx_error_query
                        (ViSession  instrumentHandle,
                         ViPInt32   errorCode,
                         ViPString  errorMessage);

ViStatus _VI_FUNC hp548xx_error_message
                        (ViSession  instrumentHandle,
                         ViStatus   statusCode,
                         ViPString  message);

ViStatus _VI_FUNC hp548xx_revision_query
                        (ViSession  instrumentHandle,
                         ViPString  instrumentDriverRevision,
                         ViPString  firmwareRevision);


        /***************************************************/
        /*  HP standard utility functions                  */
        /***************************************************/

ViStatus _VI_FUNC hp548xx_timeOut
                        (ViSession  instrumentHandle,
                         ViInt32    setTimeOut);

ViStatus _VI_FUNC hp548xx_timeOut_Q
                        (ViSession  instrumentHandle,
                         ViPInt32   timeOut);

ViStatus _VI_FUNC hp548xx_errorQueryDetect
                        (ViSession  instrumentHandle,
                         ViBoolean  setErrorQueryDetect);

ViStatus _VI_FUNC hp548xx_errorQueryDetect_Q
                        (ViSession  instrumentHandle,
                         ViPBoolean errorQueryDetect);

ViStatus _VI_FUNC hp548xx_dcl
                        (ViSession  instrumentHandle);

ViStatus _VI_FUNC hp548xx_opc_Q
                        (ViSession  instrumentHandle,
                         ViPBoolean instrumentReady);


        /***************************************************/
        /*  HP standard status functions                   */
        /***************************************************/

ViStatus _VI_FUNC hp548xx_readStatusByte_Q
                        (ViSession  instrumentHandle,
                         ViPInt16   statusByte);

        /***************************************************/
        /*  HP standard command passthrough functions      */
        /***************************************************/

ViStatus _VI_FUNC hp548xx_cmd
                        (ViSession  instrumentHandle,
                         ViString   sendStringCommand);

ViStatus _VI_FUNC hp548xx_cmdString_Q
                        (ViSession  instrumentHandle,
                         ViString   queryStringCommand, 
	                     ViInt32    stringSize,
                         ViPString  stringResult);
	
ViStatus _VI_FUNC hp548xx_cmdInt
                        (ViSession  instrumentHandle,
                         ViString   sendIntegerCommand,
                         ViInt32    sendInteger);

ViStatus _VI_FUNC hp548xx_cmdInt16_Q
                        (ViSession  instrumentHandle,
                         ViString   queryI16Command,
                         ViPInt16   i16Result);

ViStatus _VI_FUNC hp548xx_cmdInt32_Q
                        (ViSession  instrumentHandle,
                         ViString   queryI32Command,
                         ViPInt32   i32Result);
                         
ViStatus _VI_FUNC hp548xx_cmdInt16Arr_Q
                        (ViSession  instrumentHandle,
                         ViString   queryI16ArrayCommand,
                         ViInt32    i16ArraySize,
                         ViInt16 _VI_FAR i16ArrayResult[],
                         ViPInt32   i16ArrayCount);

ViStatus _VI_FUNC hp548xx_cmdInt32Arr_Q
                        (ViSession  instrumentHandle,
                         ViString   queryI32ArrayCommand,
                         ViInt32    i32ArraySize,
                         ViInt32 _VI_FAR i32ArrayResult[],
                         ViPInt32   i32ArrayCount);
    
ViStatus _VI_FUNC hp548xx_cmdReal
                        (ViSession  instrumentHandle,
                         ViString   sendRealCommand,
                         ViReal64   sendReal);

ViStatus _VI_FUNC hp548xx_cmdReal64_Q
                        (ViSession  instrumentHandle,
                         ViString   queryRealCommand,
                         ViPReal64  realResult);


/* End of HP standard declarations */
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
/*  INSTRUMENT SPECIFIC SECTION                                              */
/*  Constants and function prototypes for instrument specific functions.     */
/*****************************************************************************/

        /***************************************************/
        /*  Instrument specific constants                  */
        /***************************************************/

#define hp548xx_ACQ_AVERAGE_ON			1
#define hp548xx_ACQ_AVERAGE_OFF     	0
#define hp548xx_ACQ_COUNT_MIN      		2
#define hp548xx_ACQ_COUNT_MAX      		4096
#define hp548xx_ACQ_PERCENT_MIN      	0
#define hp548xx_ACQ_PERCENT_MAX      	100
#define hp548xx_ACQ_MODE_RTIME      	0
#define hp548xx_ACQ_MODE_ETIME      	1
#define hp548xx_ACQ_MODE_PDETECT      	2
#define hp548xx_ACQ_POINTS_AUTO      	0
#define hp548xx_ACQ_POINTS_MIN      	16
#define hp548xx_ACQ_POINTS_MAX      	65536
#define hp548xx_ACQ_RATE_AUTO      		0
#define hp548xx_ACQ_RATE_P5      		1
#define hp548xx_ACQ_RATE_1      		2
#define hp548xx_ACQ_RATE_2P5      		3
#define hp548xx_ACQ_RATE_5     			4
#define hp548xx_ACQ_RATE_10     		5
#define hp548xx_ACQ_RATE_25     		6
#define hp548xx_ACQ_RATE_50      		7
#define hp548xx_ACQ_RATE_100    		8
#define hp548xx_ACQ_RATE_250      		9
#define hp548xx_ACQ_RATE_500      		10
#define hp548xx_ACQ_RATE_1K      		11
#define hp548xx_ACQ_RATE_2P5K      		12
#define hp548xx_ACQ_RATE_5K      		13
#define hp548xx_ACQ_RATE_10K      		14
#define hp548xx_ACQ_RATE_25K      		15
#define hp548xx_ACQ_RATE_50K      		16
#define hp548xx_ACQ_RATE_100K     		17
#define hp548xx_ACQ_RATE_250K     		18
#define hp548xx_ACQ_RATE_500K     		19
#define hp548xx_ACQ_RATE_1M      		20
#define hp548xx_ACQ_RATE_2P5M		    21
#define hp548xx_ACQ_RATE_5M      		22
#define hp548xx_ACQ_RATE_10M      		23
#define hp548xx_ACQ_RATE_25M      		24
#define hp548xx_ACQ_RATE_50M      		25
#define hp548xx_ACQ_RATE_100M      		26
#define hp548xx_ACQ_RATE_250M      		27
#define hp548xx_ACQ_RATE_500M      		28
#define hp548xx_ACQ_RATE_1G      		29
#define hp548xx_ACQ_RATE_2G      		30
#define hp548xx_ACQ_RATE_4G      		31
#define hp548xx_ACQ_RATE_8G      		32
#define hp548xx_ACQ_CONFIG_2CH      	0
#define hp548xx_ACQ_CONFIG_4CH      	1

#define hp548xx_CHANN_BWL_ON      		1
#define hp548xx_CHANN_BWL_OFF    		0
#define hp548xx_CHANN_DISP_ON      		1
#define hp548xx_CHANN_DISP_OFF      	0
#define hp548xx_CHANN_INPUT_DC	     	0 
#define hp548xx_CHANN_INPUT_DC50      	1
#define hp548xx_CHANN_INPUT_AC      	2
#define hp548xx_CHANN_INPUT_LFR1      	3
#define hp548xx_CHANN_INPUT_LFR2      	4
#define hp548xx_CHANN_PROBE_RATIO      	0
#define hp548xx_CHANN_PROBE_DECIBEL     1
#define hp548xx_CHANN_ATT_RAT_MIN 		100E-6
#define hp548xx_CHANN_ATT_RAT_MAX 		1E6
#define hp548xx_CHANN_ATT_DEC_MIN 		-80
#define hp548xx_CHANN_ATT_DEC_MAX 		120


#define hp548xx_OFFSET_MIN 				-250
#define hp548xx_OFFSET_MAX  			250
#define hp548xx_RANGE_MIN				1E-3
#define hp548xx_RANGE_MAX				5

#define hp548xx_COMM_SETUP_SAVE      	0
#define hp548xx_COMM_SETUP_RECALL      	1
#define hp548xx_COMM_REG0      			0
#define hp548xx_COMM_REG1      			1	
#define hp548xx_COMM_REG2      			2
#define hp548xx_COMM_REG3      			3
#define hp548xx_COMM_REG4      			4
#define hp548xx_COMM_REG5      			5
#define hp548xx_COMM_REG6      			6
#define hp548xx_COMM_REG7      			7
#define hp548xx_COMM_REG8      			8
#define hp548xx_COMM_REG9      			9

#define hp548xx_DISK_SETUP      		0
#define hp548xx_DISK_WMEM      			1
#define hp548xx_DISK_SOURCE_CHAN      	0
#define hp548xx_DISK_SOURCE_FUNC      	1
#define hp548xx_DISK_SOURCE_WMEM      	2
#define hp548xx_DISK_SOURCE_SETUP      	3
#define hp548xx_DISK_FMT_INT      		0 
#define hp548xx_DISK_FMT_TYVAL      	1
#define hp548xx_DISK_FMT_TVERB      	2
#define hp548xx_DISK_FMT_TXYP	      	3

#define hp548xx_DISP_ROW_MIN	     	0	
#define hp548xx_DISP_ROW_MAX	     	23
#define hp548xx_DISP_COL_MIN	     	0	
#define hp548xx_DISP_COL_MAX	     	81
#define hp548xx_DISP_FTYPE_PCX			0
#define hp548xx_DISP_FTYPE_BMP			1
#define hp548xx_DISP_FTYPE_EPS 			2
#define hp548xx_DISP_FTYPE_PS			3
#define hp548xx_DISP_FTYPE_GIF 			4
#define hp548xx_DISP_SCRMODE_SCR		0
#define hp548xx_DISP_SCRMODE_GRAT		1
#define hp548xx_DISP_COMP_OFF 			0
#define hp548xx_DISP_COMP_ON			1
#define hp548xx_DISP_INV_NORM			0
#define hp548xx_DISP_INV_INV			1

#define hp548xx_FFT_WINDOW_RECTANGULAR	0
#define hp548xx_FFT_WINDOW_HANNING      1 
#define hp548xx_FFT_WINDOW_FLATTOP      2
#define hp548xx_FFT_CFREQ_MIN 			-1E12
#define hp548xx_FFT_CFREQ_MAX 			1E12


#define hp548xx_FUNC_DISP_OFF      		0
#define hp548xx_FUNC_DISP_ON      		1
#define hp548xx_FUNC_HORIZ_AUTO      	0
#define hp548xx_FUNC_HORIZ_MANUAL      	1
#define hp548xx_FUNC_VERT_AUTO      	0
#define hp548xx_FUNC_VERT_MANUAL      	1
#define hp548xx_FUNC_OP_ADD      		0
#define hp548xx_FUNC_OP_SUB      		1
#define hp548xx_FUNC_OP_DIFF      		2
#define hp548xx_FUNC_OP_DIV      		3
#define hp548xx_FUNC_OP_MULT      		4
#define hp548xx_FUNC_OP_VERS      		5

#define hp548xx_HCOPY_GRAT      		0
#define hp548xx_HCOPY_SCREEN      		1
#define hp548xx_HCOPY_FACT_OFF      	0
#define hp548xx_HCOPY_FACT_ON      		1
#define hp548xx_HCOPY_IMAGE_NORMAL      0
#define hp548xx_HCOPY_IMAGE_INVERT      1
#define hp548xx_HCOPY_IMAGE_MONOC      	2

#define hp548xx_MEAS_SOURCE_CHAN      	0
#define hp548xx_MEAS_SOURCE_FUNC      	1
#define hp548xx_MEAS_SOURCE_WMEM      	2
#define hp548xx_MEAS_DISPLAY      		0
#define hp548xx_MEAS_CYCLE      		1
#define hp548xx_MEAS_AC      			0
#define hp548xx_MEAS_DC      			1
#define hp548xx_MEAS_FREQUENCY			0	
#define hp548xx_MEAS_PERIOD				1	
#define hp548xx_MEAS_PWIDTH				2	
#define hp548xx_MEAS_NWIDTH				3	
#define hp548xx_MEAS_RISETIME			4		
#define hp548xx_MEAS_FALLTIME			5
#define hp548xx_MEAS_DUTYCYCLE			6	
#define hp548xx_MEAS_VRMS_CYC_AC		7
#define hp548xx_MEAS_VRMS_CYC_DC		8
#define hp548xx_MEAS_VRMS_DIS_AC		9
#define hp548xx_MEAS_VRMS_DIS_DC		10
#define hp548xx_MEAS_VMAX				11
#define hp548xx_MEAS_VMIN				12
#define hp548xx_MEAS_VTOP				13
#define hp548xx_MEAS_VBASE				14
#define hp548xx_MEAS_VAVG_CYC			15	
#define hp548xx_MEAS_VAVG_DIS			16	
#define hp548xx_MEAS_VAMPLITUDE			17	
#define hp548xx_MEAS_VPP				18	
#define hp548xx_MEAS_OVERSHOOT			19	
#define hp548xx_MEAS_PRESHOOT			20
#define hp548xx_MEAS_VLOW				21	
#define hp548xx_MEAS_VMID				22	
#define hp548xx_MEAS_VUPP				23

#define hp548xx_BLANK      				0
#define hp548xx_VIEW      				1

#define hp548xx_TIM_RANGE_MIN      		1E-9
#define hp548xx_TIM_RANGE_MAX      		50
#define hp548xx_TIM_POS_MIN 			-10
#define hp548xx_TIM_POS_MAX 			10
#define hp548xx_TIM_REF_LEFT     		0
#define hp548xx_TIM_REF_CENTER      	1
#define hp548xx_TIM_REF_RIGHT      		2

#define hp548xx_TRIG_SWEEP_AUTO      	0
#define hp548xx_TRIG_SWEEP_TRIGG     	1
#define hp548xx_TRIG_SWEEP_SINGLE      	2
#define hp548xx_TRIG_COUP_AC      		0
#define hp548xx_TRIG_COUP_DC     		1
#define hp548xx_TRIG_COUP_LFR      		2
#define hp548xx_TRIG_COUP_HFR      		3
#define hp548xx_TRIG_SLOPE_POS      	0
#define hp548xx_TRIG_SLOPE_NEG      	1
#define hp548xx_TRIG_LEV_AUX      		0
#define hp548xx_TRIG_LEV_CHAN1      	1
#define hp548xx_TRIG_LEV_CHAN2      	2
#define hp548xx_TRIG_LEV_CHAN3      	3
#define hp548xx_TRIG_LEV_CHAN4      	4
#define hp548xx_TRIG_LEV_EXT      		5
#define hp548xx_TRIG_LEVEL_MIN			-60
#define hp548xx_TRIG_LEVEL_MAX			60
#define hp548xx_TRIG_POLARITY_POS      	0
#define hp548xx_TRIG_POLARITY_NEG      	1
#define hp548xx_TRIG_WIDTH_MIN      	1.5E-6
#define hp548xx_TRIG_WIDTH_MAX      	160E-3

#define hp548xx_WAV_POINTS_MIN      	1
#define hp548xx_WAV_POINTS_MAX      	262144
#define hp548xx_WAV_XINC      			0
#define hp548xx_WAV_XOR      			1 
#define hp548xx_WAV_YINC      			2
#define hp548xx_WAV_YOR      			3
#define hp548xx_WAV_FORMAT_ASCII      	0
#define hp548xx_WAV_FORMAT_BYTE      	1
#define hp548xx_WAV_FORMAT_LONG      	2
#define hp548xx_WAV_FORMAT_WORD      	3

#define hp548xx_WMEM_DISP_OFF			0
#define hp548xx_WMEM_DISP_ON			1

#define hp548xx_CHANNEL      			0
#define hp548xx_FUNCTION      			1
#define hp548xx_WMEMORY      			2
#define hp548xx_CONSTANT				3

#define hp548xx_CH_F_W_1      			1
#define hp548xx_CH_F_W_2      			2
#define hp548xx_CH_F_W_3      			3
#define hp548xx_CH_F_W_4      			4
#define hp548xx_CH1      				1
#define hp548xx_CH2      				2
#define hp548xx_CH3      				3
#define hp548xx_CH4      				4
#define hp548xx_FUNC1     				1
#define hp548xx_FUNC2      				2
#define hp548xx_FUNC3      				3
#define hp548xx_FUNC4      				4
#define hp548xx_WMEM1  				    1
#define hp548xx_WMEM2   				2
#define hp548xx_WMEM3					3
#define hp548xx_WMEM4      				4

#define hp548xx_AUX      				0
#define hp548xx_CHAN1      				1
#define hp548xx_CHAN2      				2
#define hp548xx_CHAN3      				3
#define hp548xx_CHAN4      				4
#define hp548xx_EXT      				5
#define hp548xx_LINE      				6


#define hp548xx_FILE_OPEN_ERROR     	(_VI_ERROR+0x3FFC0D30L) /* 0xBFFC0D30 */
#define hp548xx_FILE_READ_ERROR    		(_VI_ERROR+0x3FFC0D31L) /* 0xBFFC0D31 */
#define hp548xx_FILE_WRITE_ERROR    	(_VI_ERROR+0x3FFC0D32L) /* 0xBFFC0D32 */
#define hp548xx_INSTR_ERROR_CMD_ERROR    	   -100
#define hp548xx_INSTR_ERROR_INV_CHAR 		   -101
#define hp548xx_INSTR_ERROR_SYNTAX   		   -102
#define hp548xx_INSTR_ERROR_INV_SEPARATOR	   -103
#define hp548xx_INSTR_ERROR_DATA_TYPE		   -104
#define hp548xx_INSTR_ERROR_GET_ALLOW		   -105
#define hp548xx_INSTR_ERROR_PARAM_ALLOW        -108
#define hp548xx_INSTR_ERROR_MISS_PARAM   	   -109
#define hp548xx_INSTR_ERROR_MNEMONIC_LONG	   -112
#define hp548xx_INSTR_ERROR_UNDEF_HEADER 	   -113
#define hp548xx_INSTR_ERROR_INV_CHAR_NUM 	   -121
#define hp548xx_INSTR_ERROR_NUM_OVERFLOW 	   -123
#define hp548xx_INSTR_ERROR_TOO_MANY_DIG 	   -124
#define hp548xx_INSTR_ERROR_NUM_DATA_ALLOW     -128
#define hp548xx_INSTR_ERROR_INV_SUFFIX   	   -131
#define hp548xx_INSTR_ERROR_SUFFIX_ALLOW 	   -138
#define hp548xx_INSTR_ERROR_INV_CHAR_DATA	   -141
#define hp548xx_INSTR_ERROR_CHAR_DATA_LONG     -144
#define hp548xx_INSTR_ERROR_CHAR_DATA_ALLOW    -148
#define hp548xx_INSTR_ERROR_STR_DATA 	  	   -150
#define hp548xx_INSTR_ERROR_INV_STR_DATA 	   -151
#define hp548xx_INSTR_ERROR_STR_DATA_ALLOW     -158
#define hp548xx_INSTR_ERROR_BLOCK_DATA   	   -160
#define hp548xx_INSTR_ERROR_INV_BLOCK_DATA     -161
#define hp548xx_INSTR_ERROR_BLOCK_DATA_ALLOW   -168
#define hp548xx_INSTR_ERROR_EXPRESSION   	   -170
#define hp548xx_INSTR_ERROR_INV_EXP  		   -171
#define hp548xx_INSTR_ERROR_EXP_DATA_ALLOW     -178
#define hp548xx_INSTR_ERROR_EXECUTION 		   -200
#define hp548xx_INSTR_ERROR_DATA_OUT_RANGE     -222
#define hp548xx_INSTR_ERROR_TOO_MUCH_DATA	   -223
#define hp548xx_INSTR_ERROR_ILL_PARAM_VALUE    -224
#define hp548xx_INSTR_ERROR_HW_MISING		   -241
#define hp548xx_INSTR_ERROR_FILE_NFOUND  	   -256
#define hp548xx_INSTR_ERROR_SYSTEM	 		   -310
#define hp548xx_INSTR_ERROR_QUEUE_OVERFLOW     -350
#define hp548xx_INSTR_ERROR_QUERY			   -400
#define hp548xx_INSTR_ERROR_Q_INTERRUPTED	   -410
#define hp548xx_INSTR_ERROR_Q_UNTERMINATED     -420
#define hp548xx_INSTR_ERROR_Q_DEADLOCKED 	   -430
#define hp548xx_INSTR_ERROR_Q_UNTERMINATED_R   -440

#define hp548xx_MAX_SIZE				100*1024


        /***************************************************/
        /*  Instrument specific functions                  */
        /***************************************************/

ViStatus _VI_FUNC hp548xx_acquireSetup (ViSession instrumentHandle, 
						ViInt16 average,
						ViInt16 countvalue,
						ViInt16 completionpercent,
						ViInt16 samplingmode,
						ViInt32 memorydepth, 
						ViInt16 sampling_rate);
ViStatus _VI_FUNC hp548xx_set54845Aconfig (ViSession instrumentHandle,
						ViInt16 config);
ViStatus _VI_FUNC hp548xx_channelScale (ViSession instrumentHandle,
						ViInt16 channel_number, 
						ViReal64 rangevalue,
						ViReal64 offsetvalue);
ViStatus _VI_FUNC hp548xx_channelInputSetup (ViSession instrumentHandle,
						ViInt16 channel_number,
						ViInt16 bwlimit, 
						ViInt16 display,
						ViInt16 coupling,
						ViReal64 attenuationfactor,
						ViInt16 attenuation_units);
ViStatus _VI_FUNC hp548xx_saveRecallSetup (ViSession instrumentHandle,
						ViInt16 saverecall,
						ViInt16 memoryregisternumber);
ViStatus _VI_FUNC hp548xx_loadFromDisk (ViSession instrumentHandle,
						ViString filename,
						ViInt16 destination,
						ViInt16 destinationnumber);
ViStatus _VI_FUNC hp548xx_storeToDisk (ViSession instrumentHandle,
						ViString filename, 
						ViInt16 source,
						ViInt16 source_number, 
						ViInt16 format);
ViStatus _VI_FUNC hp548xx_displayData (ViSession instrumentHandle,
						ViInt16 row_number, 
						ViInt16 col_number,
						ViString stringargument);
ViStatus _VI_FUNC hp548xx_displayData_Q (ViSession instrumentHandle,
						ViString filename, 
						ViInt16 filetype,
						ViInt16 screenmode, 
						ViInt16 compression,
						ViInt16 inversion);
ViStatus _VI_FUNC hp548xx_funcFftSetup (ViSession instrumentHandle,
                        ViInt16 functionnumber, 
                        ViInt16 display,
                        ViInt16 operandtype,
                        ViReal64 operand,
                        ViReal64 centerfrequencyvalue,
                        ViInt16 window);
ViStatus _VI_FUNC hp548xx_funcOper (ViSession instrumentHandle,
                        ViInt16 functionnumber, 
                        ViInt16 display,
                        ViInt16 operation, 
                        ViInt16 operand1type,
                        ViReal64 operand1, 
                        ViInt16 operand2type,
                        ViReal64 operand2);
ViStatus _VI_FUNC hp548xx_hardCopySetup (ViSession instrumentHandle, 
						ViInt16 area,
						ViInt16 factors, 
						ViInt16 image);
ViStatus _VI_FUNC hp548xx_measureAll_Q (ViSession instrumentHandle, 
						ViInt16 source,
						ViInt16 source_number,
						ViReal64 _VI_FAR resultsarray []);
ViStatus _VI_FUNC hp548xx_measureOne_Q (ViSession instrumentHandle, 
						ViInt16 source,
						ViInt16 source_number, 
						ViInt16 measurement,
						ViPReal64 result);
ViStatus _VI_FUNC hp548xx_autoscale (ViSession instrumentHandle);
ViStatus _VI_FUNC hp548xx_blankView (ViSession instrumentHandle, 
						ViInt16 setting,
						ViInt16 source, 
						ViInt16 source_number);
ViStatus _VI_FUNC hp548xx_digitize (ViSession instrumentHandle, 
						ViInt16 source,
						ViInt16 source_number);
ViStatus _VI_FUNC hp548xx_printScreen (ViSession instrumentHandle);
ViStatus _VI_FUNC hp548xx_run (ViSession instrumentHandle);
ViStatus _VI_FUNC hp548xx_stop (ViSession instrumentHandle);
ViStatus _VI_FUNC hp548xx_single (ViSession instrumentHandle);
ViStatus _VI_FUNC hp548xx_storeWaveform (ViSession instrumentHandle, 
						ViInt16 source,
						ViInt16 source_number, 
						ViInt16 destination);
ViStatus _VI_FUNC hp548xx_systemSetup_Q (ViSession instrumentHandle,
						ViString filename);
ViStatus _VI_FUNC hp548xx_systemSetup (ViSession instrumentHandle,
						ViString filename);
ViStatus _VI_FUNC hp548xx_timebaseRange (ViSession instrumentHandle,
						ViInt16 reference,
						ViReal64 position, 
						ViReal64 fullscalerange);
ViStatus _VI_FUNC hp548xx_edgeTriggerSetup (ViSession instrumentHandle,
						ViInt16 source, 
						ViReal64 triggerlevel,
						ViInt16 sweepmode, 
						ViInt16 coupling,
						ViInt16 slope);
ViStatus _VI_FUNC hp548xx_glitchTriggerSetup (ViSession instrumentHandle,
						ViInt16 source, 
						ViReal64 triggerlevel,
						ViInt16 sweepmode, 
						ViReal64 width,
						ViInt16 polarity);
ViStatus _VI_FUNC hp548xx_waveformScaling_Q (ViSession instrumentHandle,
						ViPInt32 points,
						ViReal64 _VI_FAR data []);
ViStatus _VI_FUNC hp548xx_waveformFormat (ViSession instrumentHandle,
						ViInt16 format);
ViStatus _VI_FUNC hp548xx_displayWmem (ViSession instrumentHandle, 
						ViInt16 display,
						ViInt16 source);	

ViStatus _VI_FUNC hp548xx_waveformArray_Q (ViSession instrumentHandle,
						ViInt16 source, 
						ViPInt32 points,
						ViReal64 _VI_FAR time_value [],
						ViReal64 _VI_FAR volts []);


/* End of instrument specific declarations */
/*---------------------------------------------------------------------------*/

/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif 

#endif /* hp548xx_INCLUDE */

