#include <stdio.h>

#include "hp605x.h"

void checkStatus(ViSession session,
                 ViStatus status) {
    if (status != VI_SUCCESS)
        fprintf(stderr, "ERROR:%x\n", status);
}

void trigger(ViSession session) {
    ViReal64 current;
    ViStatus status;

    printf("Press the trigger button and then press <enter> to continue...\n");
    while (getchar() != '\n');
    
    status = hp605x_getCurrent(session, HP605X_CURR, &current);
    checkStatus(session, status);

    printf("\nLoad current set to %e A.\n", current);
}


int main() {
    ViSession session;
    ViStatus status;

    /* Initialize the instrument.  The second parameter causes the driver to 
       verify the model number and the third causes a reset. */
    status = hp605x_init("GPIB0::5",
                         VI_TRUE,
                         VI_TRUE,
                         &session);
    checkStatus(session, status);

    /* Set the trigger source to external, the mode to constant current,
       the immediate current to 10A, and the trigger current to 5A. */
    status = hp605x_configureTrigger(session,
                                     HP605X_TRIG_SOUR_EXTERNAL,
                                     HP605X_MODE_CURRENT,
                                     10,
                                     5);
    checkStatus(session, status);
    trigger(session);

    /* Set the trigger current to 2A. */
    status = hp605x_setCurrent(session,
                               HP605X_CURR_TRIG,
                               2);
    checkStatus(session, status);
    trigger(session);

    /* Set the trigger current to 1A. */
    status = hp605x_setCurrent(session,
                               HP605X_CURR_TRIG,
                               1);
    checkStatus(session, status);
    trigger(session);

    /* Set the trigger current to 0A. */
    status = hp605x_setCurrent(session,
                               HP605X_CURR_TRIG,
                               0);
    checkStatus(session, status);
    trigger(session);

    return 0;
}
