#include <stdio.h>

#include "hp605x.h"

void checkStatus(ViSession session,
                 ViStatus status) {
    if (status != VI_SUCCESS)
        fprintf(stderr, "ERROR:%x\n", status);
}

void configureInstrument(ViSession session, 
                         ViInt32 triggerSource,
                         ViReal64 transientTimer) {
    /* At most, a mainframe may have six channels. */
    ViInt32 channels[] = {1, 2, 3, 4, 5, 6};
    ViInt32 maxChannel;
    ViReal64 maxCurrentSlew;
    ViStatus status;

    /* Get the maximum number of channels. */
    status = hp605x_getChannel(session,
                               HP605X_CHAN_MAX, 
                               &maxChannel);
    checkStatus(session, status);

    /* Get the maximum current slew rate. */
    status = hp605x_getCurrent(session,
                               HP605X_CURR_SLEW_MAX,
                               &maxCurrentSlew);
    checkStatus(session, status);

    /* Configure all mainframe channels as parallel loads. */
    status = hp605x_configureParallelLoads(session,
                                           maxChannel,
                                           channels,
                                           maxCurrentSlew,
                                           triggerSource,
                                           transientTimer,
                                           0,
                                           VI_TRUE,
                                           HP605X_TRAN_MODE_TOGGLE,
                                           0,
                                           0.35);
    checkStatus(session, status);
}

int main() {
    ViSession master;
    ViSession slave;
    ViStatus status;

    /* Initialize the instrument.  The second parameter causes the driver to 
       verify the model number and the third causes a reset. */
    status = hp605x_init("GPIB0::6",
                         VI_TRUE,
                         VI_TRUE,
                         &slave);
    checkStatus(slave, status);

    configureInstrument(slave, HP605X_TRIG_SOUR_EXTERNAL, 0);

    /* Initialize the instrument.  The second parameter causes the driver to 
       verify the model number and the third causes a reset. */
    status = hp605x_init("GPIB0::5",
                         VI_TRUE,
                         VI_TRUE,
                         &master);
    checkStatus(master, status);

    configureInstrument(master, HP605X_TRIG_SOUR_TIMER, 1);

    printf("Press <enter> to reset the instruments...\n");
    while (getchar() != '\n');

    status = hp605x_reset(slave);
    checkStatus(slave, status);

    status = hp605x_close(slave);
    checkStatus(slave, status);

    status = hp605x_reset(master);
    checkStatus(master, status);

    status = hp605x_close(master);
    checkStatus(master, status);

    return 0;
}
