#include "Feature.h"

void Display::setDisplay(const Boolean &state, const Int32 &param, const String &text) {
    if (!state)
        write("DISP 0");
    else if (param == DISP_NORMAL)
        write("DISP:STAT 1;MODE NORM");
    else if (param == DISP_TEXT) {
        if (std::string((ViString)text).size() == 0)
            write("DISP:STAT 1;MODE TEXT");
        else
            writeString("DISP:STAT 1;MODE TEXT;TEXT", quote(text));
    } else
        throw param.error;
}

void SaveRecall::recall(const Int32 &location) {
    checkLocation(location);
    writeInt32("*RCL", location);
}

void SaveRecall::save(const Int32 &location) {
    checkLocation(location);
    writeInt32("*SAV", location);
}

void SaveRecallPowerOn::setPowerOnState(const Int32 &state) {
    switch (state) {
    case PON_STATE_RST:
        write("OUTP:PON:STAT RST");
        break;
    case PON_STATE_RCL0:
        write("OUTP:PON:STAT RCL0");
        break;
    default:
        throw state.error;
    };
}
