#ifndef Feature_h
#define Feature_h

#include "Runtime.h"

class Display : virtual public Runtime {
public:
    enum {
        DISP_NORMAL = 1000,
        DISP_TEXT
    };

    virtual void setDisplay(const Boolean &, const Int32 &, const String &);
};

class SaveRecall : virtual public Runtime {
public:
    virtual void recall(const Int32 &);
    virtual void save(const Int32 &);

protected:
    virtual void checkLocation(const Int32 &) = 0;
};

class SaveRecallPowerOn : public SaveRecall {
public:
    enum {
        PON_STATE_RST = 1050,
        PON_STATE_RCL0
    };

    virtual void setPowerOnState(const Int32 &);
};

#endif