
#include <vpptype.h>
#include "hp605x.h"
#include "ElectronicLoad.h"

#define GET_OBJECT(session, object) {                                                       \
    ViStatus status = viGetAttribute(session, VI_ATTR_USER_DATA, (ViPAttrState)object);     \
    if (status < VI_SUCCESS)                                                                \
        return status;                                                                      \
    else                                                                                    \
        (*object)->status(status);                                                          \
}

#define CALL_FUNC(object, func)             \
    try {                                   \
        object->getErrorHandler().reset();  \
        object->func;                       \
    } catch (ViStatus status) {             \
        return status;                      \
    }

#define GET_STATUS(object) object->getStatus()

#define SET_OBJECT(session, object)                                                                         \
    ViStatus status = viSetAttribute(session, VI_ATTR_USER_DATA, reinterpret_cast<ViAttrState>(object));    \
    if (status < VI_SUCCESS)                                                                                \
        return status;                                                                                      \
    else                                                                                                    \
        object->status(status);

typedef Runtime::Boolean Boolean;
typedef Runtime::Int32 Int32;
typedef Runtime::AInt32 AInt32;
typedef Runtime::Real64 Real64;
typedef Runtime::String String;

ViStatus _VI_FUNC hp605x_abort(ViSession session) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, abort());
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_clearInputProtection(ViSession session) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, clearInputProtection());
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_close(ViSession session) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, close());
    ViStatus status = GET_STATUS(object);
    delete object;
    return status;
}

ViStatus _VI_FUNC hp605x_cmd(ViSession session,
                             ViString command) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, cmd(
        String(command, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_cmdInt(ViSession session,
                                ViString command,
                                ViInt32 argument) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, cmdInt(
        String(command, VI_ERROR_PARAMETER2),
        Int32(argument, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_cmdInt_Q(ViSession session,
                                  ViString command,
                                  ViPInt32 response) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, cmdInt_Q(
        String(command, VI_ERROR_PARAMETER2),
        response));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_cmdString_Q(ViSession session,
                                     ViString command,
                                     ViInt32 responseSize,
                                     ViPString response) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, cmdString_Q(
        String(command, VI_ERROR_PARAMETER2),
        Int32(responseSize, VI_ERROR_PARAMETER3),
        response));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_configureContinuousTransient(ViSession session,
                                                      ViReal64 dutyCycle,
                                                      ViReal64 frequency,
                                                      ViInt32 mode,
                                                      ViReal64 immediateLevel,
                                                      ViReal64 transientLevel) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, configureContinuousTransient(
        Real64(dutyCycle, VI_ERROR_PARAMETER2),
        Real64(frequency, VI_ERROR_PARAMETER3),
        Int32(mode, VI_ERROR_PARAMETER4),
        Real64(immediateLevel, VI_ERROR_PARAMETER5),
        Real64(transientLevel, VI_ERROR_PARAMETER6)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_configureInput(ViSession session,
                                        ViInt32 mode,
                                        ViReal64 level) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, configureInput(
        Int32(mode, VI_ERROR_PARAMETER2),
        Real64(level, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_configureParallelLoads(ViSession session,
                                                ViInt32 numChannels,
                                                ViAInt32 channels,
                                                ViReal64 currentSlew,
                                                ViInt32 triggerSource,
                                                ViReal64 triggerTimer,
                                                ViReal64 triggerCurrent,
                                                ViBoolean transientState,
                                                ViInt32 transientMode,
                                                ViReal64 transientPulseWidth,
                                                ViReal64 transientCurrent) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, configureParallelLoads(
        Int32(numChannels, VI_ERROR_PARAMETER2),
        AInt32(channels, VI_ERROR_PARAMETER3),
        Real64(currentSlew, VI_ERROR_PARAMETER4),
        Int32(triggerSource, VI_ERROR_PARAMETER5),
        Real64(triggerTimer, VI_ERROR_PARAMETER6),
        Real64(triggerCurrent, VI_ERROR_PARAMETER7),
        Boolean(transientState, VI_ERROR_PARAMETER8),
        Int32(transientMode, HP605X_INST_ERROR_PARAMETER9),
        Real64(transientPulseWidth, HP605X_INST_ERROR_PARAMETER10),
        Real64(transientCurrent, HP605X_INST_ERROR_PARAMETER11)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_configureTrigger(ViSession session,
                                          ViInt32 triggerSource,
                                          ViInt32 mode,
                                          ViReal64 immediateLevel,
                                          ViReal64 triggerLevel) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, configureTrigger(
        Int32(triggerSource, VI_ERROR_PARAMETER2),
        Int32(mode, VI_ERROR_PARAMETER3),
        Real64(immediateLevel, VI_ERROR_PARAMETER4),
        Real64(triggerLevel, VI_ERROR_PARAMETER5)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_configureTriggeredTransient(ViSession session,
                                                     ViInt32 triggerSource,
                                                     ViInt32 transientMode,
                                                     ViReal64 pulseWidth,
                                                     ViInt32 mode,
                                                     ViReal64 immediateLevel,
                                                     ViReal64 transientLevel) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, configureTriggeredTransient(
        Int32(triggerSource, VI_ERROR_PARAMETER2),
        Int32(transientMode, VI_ERROR_PARAMETER3),
        Real64(pulseWidth, VI_ERROR_PARAMETER4),
        Int32(mode, VI_ERROR_PARAMETER5),
        Real64(immediateLevel, VI_ERROR_PARAMETER6),
        Real64(transientLevel, VI_ERROR_PARAMETER7)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_dcl(ViSession session) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, dcl());
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_doDelay(ViSession session,
                                 ViInt32 milliseconds) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, doDelay(
        Int32(milliseconds, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_error_message(ViSession session,
                                       ViStatus status,
                                       ViPString message) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, error_message(
        status,
        message));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_error_query(ViSession session,
                                     ViPInt32 errorCode,
                                     ViPString errorMessage) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, error_query(
        errorCode,
        errorMessage));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getChannel(ViSession session,
                                    ViInt32 channelType,
                                    ViPInt32 channel) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getChannel(
        Int32(channelType, VI_ERROR_PARAMETER2),
        channel));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getCurrent(ViSession session,
                                    ViInt32 currentType,
                                    ViPReal64 current) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getCurrent(
        Int32(currentType, VI_ERROR_PARAMETER2),
        current));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getCurrentRange(ViSession session,
                                         ViInt32 currentRangeType,
                                         ViPReal64 currentRange) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getCurrentRange(
        Int32(currentRangeType, VI_ERROR_PARAMETER2),
        currentRange));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getMeasTimeout(ViSession session,
                                        ViPInt32 measTimeout) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getMeasTimeout(
        measTimeout));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getRegister(ViSession session,
                                     ViInt32 registerType,
                                     ViPInt32 registerValue) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getRegister(
        Int32(registerType, VI_ERROR_PARAMETER2),
        registerValue));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getResistance(ViSession session,
                                       ViInt32 resistanceType,
                                       ViPReal64 resistanceValue) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getResistance(
        Int32(resistanceType, VI_ERROR_PARAMETER2),
        resistanceValue));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getResistanceRange(ViSession session,
                                            ViInt32 resistanceRangeType,
                                            ViPReal64 resistanceValue) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getResistanceRange(
        Int32(resistanceRangeType, VI_ERROR_PARAMETER2),
        resistanceValue));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getTimeout(ViSession session,
                                    ViPInt32 timeout) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getTimeout(
        timeout));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_getVoltage(ViSession session,
                                    ViInt32 voltageType,
                                    ViPReal64 voltage) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, getVoltage(
        Int32(voltageType, VI_ERROR_PARAMETER2),
        voltage));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_init(ViRsrc resourceId,
                              ViBoolean idQuery,
                              ViBoolean resetInstrument,
                              ViPSession session) {
    *session = VI_NULL;
    std::auto_ptr<ElectronicLoad> object(new ElectronicLoad);
    CALL_FUNC(object, init(
        String(resourceId, VI_ERROR_PARAMETER2),
        Boolean(idQuery, VI_ERROR_PARAMETER3),
        Boolean(resetInstrument, VI_ERROR_PARAMETER4)));
    *session = object->getSessionId();
    SET_OBJECT(*session, object.get());
    return GET_STATUS(object.release());
}

ViStatus _VI_FUNC hp605x_measure(ViSession session,
                                 ViInt32 measurementType,
                                 ViPReal64 measurement) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, measure(
        Int32(measurementType, VI_ERROR_PARAMETER2),
        measurement));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_recall(ViSession session,
                                ViInt32 location) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, recall(
        Int32(location, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_reset(ViSession session) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, reset());
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_revision_query(ViSession session,
                                        ViPString driverRevision,
                                        ViPString instrumentId) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, revision_query(
        driverRevision,
        instrumentId));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_save(ViSession session,
                              ViInt32 location) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, save(
        Int32(location, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_self_test(ViSession session,
                                   ViPInt32 testResult,
                                   ViPString errorMessage) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, self_test(
        testResult,
        errorMessage));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setChannel(ViSession session,
                                    ViInt32 channel) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setChannel(
        ViInt32(channel)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setCurrent(ViSession session,
                                    ViInt32 currentType,
                                    ViReal64 current) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setCurrent(
        Int32(currentType, VI_ERROR_PARAMETER2),
        Real64(current, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setCurrentProtection(ViSession session,
                                              ViBoolean isEnabled,
                                              ViReal64 delay,
                                              ViReal64 currentLimit) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setCurrentProtection(
        Boolean(isEnabled, VI_ERROR_PARAMETER2),
        Real64(delay, VI_ERROR_PARAMETER3),
        Real64(currentLimit, VI_ERROR_PARAMETER4)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setCurrentRange(ViSession session,
                                         ViInt32 currentRangeType,
                                         ViReal64 currentRange) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setCurrentRange(
        Int32(currentRangeType, VI_ERROR_PARAMETER2),
        Real64(currentRange, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setInputShort(ViSession session,
                                       ViBoolean inputShort) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setInputShort(
        Boolean(inputShort, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setInputState(ViSession session,
                                       ViBoolean inputState) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setInputState(
        Boolean(inputState, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setInstrumentErrorDetection(ViSession session,
                                                     ViInt32 errorDetectionMode,
                                                     ViInt32 waitTime) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setInstrumentErrorDetection(
        Int32(errorDetectionMode, VI_ERROR_PARAMETER2),
        Int32(waitTime, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setMeasTimeout(ViSession session,
                                        ViInt32 measTimeout) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setMeasTimeout(
        Int32(measTimeout, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setMode(ViSession session,
                                 ViInt32 mode) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setMode(
        Int32(mode, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setPort(ViSession session,
                                 ViBoolean port) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setPort(
        Boolean(port, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setRegister(ViSession session,
                                     ViInt32 registerType,
                                     ViInt32 registerValue) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setRegister(
        Int32(registerType, VI_ERROR_PARAMETER2),
        Int32(registerValue, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setResistance(ViSession session,
                                       ViInt32 resistanceType,
                                       ViReal64 resistance) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setResistance(
        Int32(resistanceType, VI_ERROR_PARAMETER2),
        Real64(resistance, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setResistanceRange(ViSession session,
                                            ViInt32 resistanceRangeType,
                                            ViReal64 resistanceRange) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setResistanceRange(
        Int32(resistanceRangeType, VI_ERROR_PARAMETER2),
        Real64(resistanceRange, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setTimeout(ViSession session,
                                    ViInt32 timeout) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setTimeout(
        Int32(timeout, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setTransient(ViSession session,
                                      ViBoolean transientState,
                                      ViInt32 transientMode,
                                      ViReal64 dutyCycleOrPulseWidth,
                                      ViReal64 frequency) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setTransient(
        Boolean(transientState, VI_ERROR_PARAMETER2),
        Int32(transientMode, VI_ERROR_PARAMETER3),
        Real64(dutyCycleOrPulseWidth, VI_ERROR_PARAMETER4),
        Real64(frequency, VI_ERROR_PARAMETER5)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setTrigger(ViSession session,
                                    ViInt32 source,
                                    ViReal64 timer) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setTrigger(
        Int32(source, VI_ERROR_PARAMETER2),
        Real64(timer, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_setVoltage(ViSession session,
                                    ViInt32 voltageType,
                                    ViReal64 voltage) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, setVoltage(
        Int32(voltageType, VI_ERROR_PARAMETER2),
        Real64(voltage, VI_ERROR_PARAMETER3)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_trigger(ViSession session,
                                 ViInt32 triggerType) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, trigger(
        Int32(triggerType, VI_ERROR_PARAMETER2)));
    return GET_STATUS(object);
}

ViStatus _VI_FUNC hp605x_wait(ViSession session) {
    ElectronicLoad *object;
    GET_OBJECT(session, &object);
    CALL_FUNC(object, wait());
    return GET_STATUS(object);
}

