#if defined(_DEBUG)
#include <iostream>
#endif

#include <sstream>

#include "VisaSession.h"

bool VisaSession::m_IsLogEnabled = false;

VisaSession::VisaSession(VisaErrorHandler *errorHandler) : m_ErrorHandler(errorHandler) {
#ifdef _DEBUG
    m_Log.open("c:\\temp\\hp68xx.log");
#endif
}

ViStatus VisaSession::callFunc(ViStatus status) {
    m_ErrorHandler->status(status == VI_SUCCESS_MAX_CNT ? VI_SUCCESS : status);
    if (status < VI_SUCCESS)
        throw status;
    return status;
}

void VisaSession::clear() {
    callFunc(viClear(m_SessionId));
}

void VisaSession::close() {
    callFunc(viClose(m_SessionId));
}

void VisaSession::disableEvent(ViEventType eventType, ViUInt16 mechanism) {
    callFunc(viDisableEvent(m_SessionId, eventType, mechanism));
}

void VisaSession::enableEvent(ViEventType eventType, ViUInt16 mechanism, ViEventFilter context) {
    callFunc(viEnableEvent(m_SessionId, eventType, mechanism, context));
}

void VisaSession::enableLog() {
    m_IsLogEnabled = true;
}

void VisaSession::getAttribute(ViAttr attr, ViPAttrState attrState) {
    callFunc(viGetAttribute(m_SessionId, attr, attrState));
}

void VisaSession::open(ViRsrc resourceId) {
    ViSession resourceManager;
    callFunc(viOpenDefaultRM(&resourceManager));
    callFunc(viOpen(resourceManager, resourceId, VI_NULL, VI_NULL, &m_SessionId));
}

void VisaSession::read(std::string &result) {
    ViUInt32 bytesRead = 0;
    ViChar buffer[256];
    ViStatus status;
    std::ostringstream out;
    do {
        status = callFunc(viRead(m_SessionId, (ViBuf)buffer, 256, &bytesRead));
        out << std::string(buffer, bytesRead);
    } while (status == VI_SUCCESS_MAX_CNT);

    result = out.str();
    if (result.size() > 0 && *result.rbegin() == '\n')
        result.resize(result.size() - 1);
#if defined(_DEBUG)
    m_Log << "    > " << result << std::endl;
    std::cerr << "    > " << result << std::endl;
#endif
}

void VisaSession::readSTB(ViPInt16 statusByte) {
    callFunc(viReadSTB(m_SessionId, reinterpret_cast<ViPUInt16>(statusByte)));
}

void VisaSession::setAttribute(const ViAttr attr, const ViAttrState attrState) {
    callFunc(viSetAttribute(m_SessionId, attr, attrState));
}

void VisaSession::statusDesc(ViStatus status, std::string *s) {
    ViChar buffer[256];
    callFunc(viStatusDesc(m_SessionId, status, buffer));
    *s = buffer;
}

void VisaSession::waitOnEvent(ViEventType inEventType, ViUInt32 timeout, ViPEventType outEventType, ViPEvent outContext) {
    ViStatus status = viWaitOnEvent(m_SessionId, inEventType, timeout, outEventType, outContext);
    if (status < VI_SUCCESS)
        throw status;
}

void VisaSession::write(const std::string &command) {
    std::string commandWithNewline(command);
    commandWithNewline.append("\n");
    ViUInt32 bytesWritten;
    callFunc(viWrite(m_SessionId, (ViBuf)commandWithNewline.data(), commandWithNewline.size(), &bytesWritten));
#ifdef _DEBUG
    m_Log  << "    < " << command << std::endl;
    std::cerr << "    < " << command << std::endl;
#endif
}
