#if !defined(VisaSession_h)
#define VisaSession_h

#ifdef _DEBUG
#include <fstream>
#endif
#include <string>
#include <visa.h>

class VisaErrorHandler {
public:
    virtual ViStatus getStatus() const = 0;
    virtual void reset() = 0;
    virtual ViStatus status(ViStatus) = 0;
};

class VisaSession {
public:
    VisaSession(VisaErrorHandler *const);
#ifdef _DEBUG
    ~VisaSession() { m_Log.close(); }
#endif

    ViSession getSessionId() const { return m_SessionId; }

    void clear();
    void close();
    void disableEvent(ViEventType, ViUInt16);
    void enableEvent(ViEventType, ViUInt16, ViEventFilter);
    void getAttribute(ViAttr, ViPAttrState);
    void open(ViRsrc);
    void read(std::string &);
    void readSTB(ViPInt16);
    void setAttribute(ViAttr, ViAttrState);
    void statusDesc(ViStatus, std::string *);
    void waitOnEvent(ViEventType, ViUInt32, ViPEventType, ViPEvent);
    void write(const std::string &);

    static void enableLog();

private:
    ViStatus callFunc(ViStatus);

    VisaErrorHandler *m_ErrorHandler;
#ifdef _DEBUG
    std::ofstream m_Log;
#endif
    ViSession m_SessionId;

    static bool m_IsLogEnabled;
};

#endif
