' Copyright (C) 1997 Agilent Technologies
' VXIplug&play Instrument Driver for the Agilent E1442

'/*===============================*/
'/*           HPE1442             */
'/*===============================*/
'/* Framework Revision: WIN95 4.0 */
'/*                     WINNT 4.0 */
'/* Driver Revision:    A.02.07   */
'/* Firmware Revision:  G.09.00   */
'/*===============================*/

'/*=============================*/
'/* Source Files:               */
'/*=============================*/
'/*   hpe1442.c                 */
'/*   hpe1442.h                 */
'/*=============================*/

'/*=============================*/
'/* WIN Framework Files         */
'/*=============================*/
'/*   hpe1442.def               */
'/*   hpe1442.rc                */
'/*   hpe1442.bas               */
'/*=============================*/

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Common Error numbers start at BFFC0D00

Global Const hpe1442_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1442_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1442_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1442_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1442_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1442_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1442_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Used by Status System Functions
Global Const hpe1442_USER_ERROR_HANDLER                       = -1

Global Const hpe1442_ESR_OPC                                  = 601
Global Const hpe1442_ESR_QUERY_ERROR                          = 603
Global Const hpe1442_ESR_DEVICE_DEPENDENT_ERROR               = 604
Global Const hpe1442_ESR_EXECUTION_ERROR                      = 605
Global Const hpe1442_ESR_COMMAND_ERROR                        = 606

Global Const hpe1442_OPER_SCAN_DONE                           = 809

' Used by Function hpe1442_timeOut
Global Const hpe1442_TIMEOUT_MAX                              = 2147483647&
Global Const hpe1442_TIMEOUT_MIN                              = 0&


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1442_init Lib "hpe1442_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1442_close Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_reset Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_self_test Lib "hpe1442_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1442_error_query Lib "hpe1442_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1442_error_message Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1442_revision_query Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' other standard functions 

Declare Function hpe1442_dcl Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_errorQueryDetect Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function hpe1442_errorQueryDetect_Q Lib "hpe1442_32.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function hpe1442_opc Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_opc_Q Lib "hpe1442_32.dll" (ByVal vi As Long, opc As Integer) As Long

Declare Function hpe1442_readStatusByte_Q Lib "hpe1442_32.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function hpe1442_statCond_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal happening As Long, pCondition As Integer) As Long

Declare Function hpe1442_statEvenClr Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_statEven_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal happening As Long, pEvent As Integer) As Long

Declare Function hpe1442_timeOut Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function hpe1442_timeOut_Q Lib "hpe1442_32.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function hpe1442_trg Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_wai Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1442_armCoun
Global Const hpe1442_ARM_COUN_MAX                         = 32767
Global Const hpe1442_ARM_COUN_MIN                         = 1

' Used by Function hpe1442_closCardChan
Global Const hpe1442_CARD_MAX                             = 99
Global Const hpe1442_CARD_MIN                             = 1
Global Const hpe1442_CHANNEL_NUMBER_MAX                   = 63
Global Const hpe1442_CHANNEL_NUMBER_MIN                   = 0

' Used by Function hpe1442_openCardChan
'    hpe1442_CARD_MAX
'    hpe1442_CARD_MIN
'    hpe1442_CHANNEL_NUMBER_MAX
'    hpe1442_CHANNEL_NUMBER_MIN

' Used by Function hpe1442_outpEcltStat_M
Global Const hpe1442_ECLTNUM_MAX                          = 1
Global Const hpe1442_ECLTNUM_MIN                          = 0

' Used by Function hpe1442_outpEcltStat_M_Q
'    hpe1442_ECLTNUM_MAX
'    hpe1442_ECLTNUM_MIN

' Used by Function hpe1442_outpTtltStat_M
Global Const hpe1442_TTLTNUM_MAX                          = 7
Global Const hpe1442_TTLTNUM_MIN                          = 0

' Used by Function hpe1442_outpTtltStat_M_Q
'    hpe1442_TTLTNUM_MAX
'    hpe1442_TTLTNUM_MIN

' Used by Function hpe1442_routClos
Global Const hpe1442_CHANNEL_MAX                          = 999999
Global Const hpe1442_CHANNEL_MIN                          = 100

' Used by Function hpe1442_routClos_Q
'    hpe1442_CHANNEL_MAX
'    hpe1442_CHANNEL_MIN

' Used by Function hpe1442_routOpen
'    hpe1442_CHANNEL_MAX
'    hpe1442_CHANNEL_MIN

' Used by Function hpe1442_routOpen_Q
'    hpe1442_CHANNEL_MAX
'    hpe1442_CHANNEL_MIN

' Used by Function hpe1442_systCdes_Q
'    hpe1442_CARD_MAX
'    hpe1442_CARD_MIN

' Used by Function hpe1442_systCpon
'    hpe1442_CARD_MAX
'    hpe1442_CARD_MIN

' Used by Function hpe1442_systCtyp_Q
'    hpe1442_CARD_MAX
'    hpe1442_CARD_MIN

' Used by Function hpe1442_trigSour
Global Const hpe1442_TRIG_SOUR_BUS                        = 0
Global Const hpe1442_TRIG_SOUR_ECLT0                      = 1
Global Const hpe1442_TRIG_SOUR_ECLT1                      = 2
Global Const hpe1442_TRIG_SOUR_HOLD                       = 3
Global Const hpe1442_TRIG_SOUR_IMM                        = 4
Global Const hpe1442_TRIG_SOUR_TTLT0                      = 5
Global Const hpe1442_TRIG_SOUR_TTLT1                      = 6
Global Const hpe1442_TRIG_SOUR_TTLT2                      = 7
Global Const hpe1442_TRIG_SOUR_TTLT3                      = 8
Global Const hpe1442_TRIG_SOUR_TTLT4                      = 9
Global Const hpe1442_TRIG_SOUR_TTLT5                      = 10
Global Const hpe1442_TRIG_SOUR_TTLT6                      = 11
Global Const hpe1442_TRIG_SOUR_TTLT7                      = 12
Global Const hpe1442_TRIG_SOUR_EXT                        = 13

' Used by Function hpe1442_trigSour_Q
'    hpe1442_TRIG_SOUR_BUS
'    hpe1442_TRIG_SOUR_ECLT0
'    hpe1442_TRIG_SOUR_ECLT1
'    hpe1442_TRIG_SOUR_HOLD
'    hpe1442_TRIG_SOUR_IMM
'    hpe1442_TRIG_SOUR_TTLT0
'    hpe1442_TRIG_SOUR_TTLT1
'    hpe1442_TRIG_SOUR_TTLT2
'    hpe1442_TRIG_SOUR_TTLT3
'    hpe1442_TRIG_SOUR_TTLT4
'    hpe1442_TRIG_SOUR_TTLT5
'    hpe1442_TRIG_SOUR_TTLT6
'    hpe1442_TRIG_SOUR_TTLT7
'    hpe1442_TRIG_SOUR_EXT


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1442_abor Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_armCoun Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal armCoun As Integer) As Long

Declare Function hpe1442_armCoun_Q Lib "hpe1442_32.dll" (ByVal vi As Long, armCoun As Integer) As Long

Declare Function hpe1442_closCardChan Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Channel As Integer) As Long

Declare Function hpe1442_initCont Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal initCont As Integer) As Long

Declare Function hpe1442_initCont_Q Lib "hpe1442_32.dll" (ByVal vi As Long, initCont As Integer) As Long

Declare Function hpe1442_initImm Lib "hpe1442_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1442_openCardChan Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Channel As Integer) As Long

Declare Function hpe1442_outpEcltStat_M Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, ByVal outpEcltStat As Integer) As Long

Declare Function hpe1442_outpEcltStat_M_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, outpEcltStat As Integer) As Long

Declare Function hpe1442_outpStat Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal outpStat As Integer) As Long

Declare Function hpe1442_outpStat_Q Lib "hpe1442_32.dll" (ByVal vi As Long, outpStat As Integer) As Long

Declare Function hpe1442_outpTtltStat_M Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, ByVal outpTtltStat As Integer) As Long

Declare Function hpe1442_outpTtltStat_M_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, outpTtltStat As Integer) As Long

Declare Function hpe1442_routClos Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1442_routClosList Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1442_routClosList_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routClosList As String) As Long

Declare Function hpe1442_routClos_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channel As Long, routClos As Integer) As Long

Declare Function hpe1442_routOpen Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1442_routOpenList Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1442_routOpenList_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routOpenList As String) As Long

Declare Function hpe1442_routOpen_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channel As Long, routOpen As Integer) As Long

Declare Function hpe1442_routScanList Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1442_systCdes_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCdes As String) As Long

Declare Function hpe1442_systCpon Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal card As Integer) As Long

Declare Function hpe1442_systCtyp_Q Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCtyp As String) As Long

Declare Function hpe1442_trigSour Lib "hpe1442_32.dll" (ByVal vi As Long, ByVal trigSour As Integer) As Long

Declare Function hpe1442_trigSour_Q Lib "hpe1442_32.dll" (ByVal vi As Long, trigSour As Integer) As Long

