/* Copyright (C) 1997-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1442*/

#ifndef hpe1442_INCLUDE 
#define hpe1442_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif
/*===============================*/
/*           HPE1442           */
/*===============================*/
/* Framework Revision: WIN95 4.0 */
/*                     WINNT 4.0 */
/* Driver Revision:    A.02.07   */
/* Firmware Revision:  G.09.00   */
/*===============================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1442.c                 */
/*   hpe1442.h                 */
/*=============================*/

/*=============================*/
/* WIN95/NT Framework Files    */
/*=============================*/
/*   hpe1442.def               */
/*   hpe1442.rc                */
/*   hpe1442.bas               */
/*=============================*/

/******  Returned error status values *****/
/* Common Error numbers start at BFFC0D00 */
#define hpe1442_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1442_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1442_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1442_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1442_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1442_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1442_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */

#define hpe1442_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define hpe1442_STB_MAV				5 

#define hpe1442_ESR_OPC				601
#define hpe1442_ESR_QUERY_ERROR			603
#define hpe1442_ESR_DEVICE_DEPENDENT_ERROR		604
#define hpe1442_ESR_EXECUTION_ERROR			605
#define hpe1442_ESR_COMMAND_ERROR			606

#define hpe1442_OPER_SCAN_DONE			809


/******   Used by Function hpe1442_timeOut   *****/
#define  hpe1442_TIMEOUT_MAX  2147483647
#define  hpe1442_TIMEOUT_MIN  0

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC hpe1442_init (ViRsrc InstrDesc, ViBoolean id_query,
                            ViBoolean do_reset, ViPSession vi );

ViStatus _VI_FUNC hpe1442_close (ViSession vi);

ViStatus _VI_FUNC hpe1442_reset (ViSession vi);

ViStatus _VI_FUNC hpe1442_self_test (ViSession vi, ViPInt16 test_result,
                                 ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC hpe1442_error_query (ViSession vi, ViPInt32 error_number,
                                   ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1442_error_message (ViSession vi, ViStatus error_number,
                                     ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1442_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
                                      ViChar _VI_FAR instr_rev[]);

/* other standard functions */

ViStatus _VI_FUNC hpe1442_dcl(ViSession vi);

ViStatus _VI_FUNC hpe1442_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC hpe1442_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC hpe1442_opc(ViSession vi);

ViStatus _VI_FUNC hpe1442_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC hpe1442_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC hpe1442_statEvenClr(ViSession vi);

ViStatus _VI_FUNC hpe1442_statEven_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  hpe1442_InstrEventHandler)(
        ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC hpe1442_statEvenHdlr(ViSession vi, ViInt32 happening,       
                                   hpe1442_InstrEventHandler eventHandler,
                                   ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR hpe1442_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC hpe1442_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     hpe1442_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC hpe1442_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC hpe1442_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC hpe1442_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC hpe1442_trg(ViSession vi);

ViStatus _VI_FUNC hpe1442_wai(ViSession vi);

/* Instr Specific Functions follow */


/******   Used by Function hpe1442_armCoun   *****/
#define  hpe1442_ARM_COUN_MAX  32767
#define  hpe1442_ARM_COUN_MIN  1


/******   Used by Function hpe1442_closCardChan   *****/
#define  hpe1442_CARD_MAX  99
#define  hpe1442_CARD_MIN  1
#define  hpe1442_CHANNEL_NUMBER_MAX  63
#define  hpe1442_CHANNEL_NUMBER_MIN  0


/******   Used by Function hpe1442_openCardChan   *****/
/*  hpe1442_CARD_MAX  */
/*  hpe1442_CARD_MIN  */
/*  hpe1442_CHANNEL_NUMBER_MAX  */
/*  hpe1442_CHANNEL_NUMBER_MIN  */


/******   Used by Function hpe1442_outpEcltStat_M   *****/
#define  hpe1442_ECLTNUM_MAX  1
#define  hpe1442_ECLTNUM_MIN  0


/******   Used by Function hpe1442_outpEcltStat_M_Q   *****/
/*  hpe1442_ECLTNUM_MAX  */
/*  hpe1442_ECLTNUM_MIN  */


/******   Used by Function hpe1442_outpTtltStat_M   *****/
#define  hpe1442_TTLTNUM_MAX  7
#define  hpe1442_TTLTNUM_MIN  0


/******   Used by Function hpe1442_outpTtltStat_M_Q   *****/
/*  hpe1442_TTLTNUM_MAX  */
/*  hpe1442_TTLTNUM_MIN  */


/******   Used by Function hpe1442_routClos   *****/
#define  hpe1442_CHANNEL_MAX  999999
#define  hpe1442_CHANNEL_MIN  100


/******   Used by Function hpe1442_routClos_Q   *****/
/*  hpe1442_CHANNEL_MAX  */
/*  hpe1442_CHANNEL_MIN  */


/******   Used by Function hpe1442_routOpen   *****/
/*  hpe1442_CHANNEL_MAX  */
/*  hpe1442_CHANNEL_MIN  */


/******   Used by Function hpe1442_routOpen_Q   *****/
/*  hpe1442_CHANNEL_MAX  */
/*  hpe1442_CHANNEL_MIN  */


/******   Used by Function hpe1442_systCdes_Q   *****/
/*  hpe1442_CARD_MAX  */
/*  hpe1442_CARD_MIN  */


/******   Used by Function hpe1442_systCpon   *****/
/*  hpe1442_CARD_MAX  */
/*  hpe1442_CARD_MIN  */


/******   Used by Function hpe1442_systCtyp_Q   *****/
/*  hpe1442_CARD_MAX  */
/*  hpe1442_CARD_MIN  */


/******   Used by Function hpe1442_trigSour   *****/
#define  hpe1442_TRIG_SOUR_BUS  0
#define  hpe1442_TRIG_SOUR_ECLT0  1
#define  hpe1442_TRIG_SOUR_ECLT1  2
#define  hpe1442_TRIG_SOUR_HOLD  3
#define  hpe1442_TRIG_SOUR_IMM  4
#define  hpe1442_TRIG_SOUR_TTLT0  5
#define  hpe1442_TRIG_SOUR_TTLT1  6
#define  hpe1442_TRIG_SOUR_TTLT2  7
#define  hpe1442_TRIG_SOUR_TTLT3  8
#define  hpe1442_TRIG_SOUR_TTLT4  9
#define  hpe1442_TRIG_SOUR_TTLT5  10
#define  hpe1442_TRIG_SOUR_TTLT6  11
#define  hpe1442_TRIG_SOUR_TTLT7  12
#define  hpe1442_TRIG_SOUR_EXT  13


/******   Used by Function hpe1442_trigSour_Q   *****/
/*  hpe1442_TRIG_SOUR_BUS  */
/*  hpe1442_TRIG_SOUR_ECLT0  */
/*  hpe1442_TRIG_SOUR_ECLT1  */
/*  hpe1442_TRIG_SOUR_HOLD  */
/*  hpe1442_TRIG_SOUR_IMM  */
/*  hpe1442_TRIG_SOUR_TTLT0  */
/*  hpe1442_TRIG_SOUR_TTLT1  */
/*  hpe1442_TRIG_SOUR_TTLT2  */
/*  hpe1442_TRIG_SOUR_TTLT3  */
/*  hpe1442_TRIG_SOUR_TTLT4  */
/*  hpe1442_TRIG_SOUR_TTLT5  */
/*  hpe1442_TRIG_SOUR_TTLT6  */
/*  hpe1442_TRIG_SOUR_TTLT7  */
/*  hpe1442_TRIG_SOUR_EXT  */

ViStatus _VI_FUNC hpe1442_abor  (
  ViSession vi);

ViStatus _VI_FUNC hpe1442_armCoun  (
  ViSession vi,
  ViInt16 armCoun);

ViStatus _VI_FUNC hpe1442_armCoun_Q  (
  ViSession vi,
  ViPInt16 armCoun);

ViStatus _VI_FUNC hpe1442_closCardChan  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Channel);

ViStatus _VI_FUNC hpe1442_initCont  (
  ViSession vi,
  ViBoolean initCont);

ViStatus _VI_FUNC hpe1442_initCont_Q  (
  ViSession vi,
  ViPBoolean initCont);

ViStatus _VI_FUNC hpe1442_initImm  (
  ViSession vi);

ViStatus _VI_FUNC hpe1442_openCardChan  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Channel);

ViStatus _VI_FUNC hpe1442_outpEcltStat_M  (
  ViSession vi,
  ViInt16 ecltNum,
  ViBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1442_outpEcltStat_M_Q  (
  ViSession vi,
  ViInt16 ecltNum,
  ViPBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1442_outpStat  (
  ViSession vi,
  ViBoolean outpStat);

ViStatus _VI_FUNC hpe1442_outpStat_Q  (
  ViSession vi,
  ViPBoolean outpStat);

ViStatus _VI_FUNC hpe1442_outpTtltStat_M  (
  ViSession vi,
  ViInt16 ttltNum,
  ViBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1442_outpTtltStat_M_Q  (
  ViSession vi,
  ViInt16 ttltNum,
  ViPBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1442_routClos  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1442_routClosList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1442_routClosList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routClosList[]);

ViStatus _VI_FUNC hpe1442_routClos_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routClos);

ViStatus _VI_FUNC hpe1442_routOpen  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1442_routOpenList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1442_routOpenList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routOpenList[]);

ViStatus _VI_FUNC hpe1442_routOpen_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routOpen);

ViStatus _VI_FUNC hpe1442_routScanList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1442_systCdes_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCdes[]);

ViStatus _VI_FUNC hpe1442_systCpon  (
  ViSession vi,
  ViInt16 card);

ViStatus _VI_FUNC hpe1442_systCtyp_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCtyp[]);

ViStatus _VI_FUNC hpe1442_trigSour  (
  ViSession vi,
  ViInt16 trigSour);

ViStatus _VI_FUNC hpe1442_trigSour_Q  (
  ViSession vi,
  ViPInt16 trigSour);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1442_INCLUDE */

