'               This program is property of
' 
' 
'                    ****   ****  
'                  ***  /_  _  ***     HEWLETT
'                  **  / / /_/  **
'                  ***    /    ***     PACKARD
'                    ****   **** 
' 
' 
'               Copyright (C) 1999 Hewlett-Packard Company






'  File contents : Driver for HPE8311A
'                  Pulse/Pattern-Generator 
'                  Driver Version: A 1.0.2.0
'  Note          : This driver is compatible with the following 
'                  VXIplug&play standards:
'                  WIN32 System Framework revision 4.0
'                  VISA revision 1.0 (does not work with VTL) 
















        '  *************************************************
        '    Standard constant error conditions returned    
        '    by driver functions.                           
        '      HP Common Error numbers start at BFFC0D00    
        '      The parameter errors extend the number of    
        '        errors over the eight defined in VPP 3.4   
        '  *************************************************


Global Const HPE8311A_INSTR_ERROR_NULL_PTR = &HBFFC0D02
Global Const HPE8311A_INSTR_ERROR_RESET_FAILED = &HBFFC0D03
Global Const HPE8311A_INSTR_ERROR_UNEXPECTED = &HBFFC0D04
Global Const HPE8311A_INSTR_ERROR_INV_SESSION = &HBFFC0D05
Global Const HPE8311A_INSTR_ERROR_LOOKUP = &HBFFC0D06
Global Const HPE8311A_INSTR_ERROR_DETECTED = &HBFFC0D07
Global Const HPE8311A_INSTR_NO_LAST_COMMA = &HBFFC0D08


Global Const HPE8311A_INSTR_ERROR_PARAMETER9 = &HBFFC0D20
Global Const HPE8311A_INSTR_ERROR_PARAMETER10 = &HBFFC0D21
Global Const HPE8311A_INSTR_ERROR_PARAMETER11 = &HBFFC0D22
Global Const HPE8311A_INSTR_ERROR_PARAMETER12 = &HBFFC0D23
Global Const HPE8311A_INSTR_ERROR_PARAMETER13 = &HBFFC0D24
Global Const HPE8311A_INSTR_ERROR_PARAMETER14 = &HBFFC0D25
Global Const HPE8311A_INSTR_ERROR_PARAMETER15 = &HBFFC0D26
Global Const HPE8311A_INSTR_ERROR_PARAMETER16 = &HBFFC0D27
Global Const HPE8311A_INSTR_ERROR_PARAMETER17 = &HBFFC0D28
Global Const HPE8311A_INSTR_ERROR_PARAMETER18 = &HBFFC0D29


        '  *************************************************
        '    Constants used by system status functions      
        '      These defines are bit numbers which define   
        '      the operation and questionable registers.    
        '      They are instrument specific.                
        '  *************************************************




Global Const HPE8311A_QUES_BIT0 = 1
Global Const HPE8311A_QUES_BIT1 = 2
Global Const HPE8311A_QUES_BIT2 = 4
Global Const HPE8311A_QUES_BIT3 = 8
Global Const HPE8311A_QUES_BIT4 = 16
Global Const HPE8311A_QUES_BIT5 = 32
Global Const HPE8311A_QUES_BIT6 = 64
Global Const HPE8311A_QUES_BIT7 = 128
Global Const HPE8311A_QUES_BIT8 = 256
Global Const HPE8311A_QUES_BIT9 = 512
Global Const HPE8311A_QUES_BIT10 = 1024
Global Const HPE8311A_QUES_BIT11 = 2048
Global Const HPE8311A_QUES_BIT12 = 4096
Global Const HPE8311A_QUES_BIT13 = 8192
Global Const HPE8311A_QUES_BIT14 = 16384
Global Const HPE8311A_QUES_BIT15 = 32768


Global Const HPE8311A_OPER_BIT0 = 1
Global Const HPE8311A_OPER_BIT1 = 2
Global Const HPE8311A_OPER_BIT2 = 4
Global Const HPE8311A_OPER_BIT3 = 8
Global Const HPE8311A_OPER_BIT4 = 16
Global Const HPE8311A_OPER_BIT5 = 32
Global Const HPE8311A_OPER_BIT6 = 64
Global Const HPE8311A_OPER_BIT7 = 128
Global Const HPE8311A_OPER_BIT8 = 256
Global Const HPE8311A_OPER_BIT9 = 512
Global Const HPE8311A_OPER_BIT10 = 1024
Global Const HPE8311A_OPER_BIT11 = 2048
Global Const HPE8311A_OPER_BIT12 = 4096
Global Const HPE8311A_OPER_BIT13 = 8192
Global Const HPE8311A_OPER_BIT14 = 16384
Global Const HPE8311A_OPER_BIT15 = 32768


        '  *************************************************
        '    Constants used by function hpe8311a_timeOut    
        '  *************************************************


Global Const HPE8311A_TIMEOUT_MAX = 2147483647
Global Const HPE8311A_TIMEOUT_MIN = &0&


Global Const HPE8311A_CMDINT8ARR_Q_MIN = &1&
Global Const HPE8311A_CMDINT8ARR_Q_MAX = 2147483647


Global Const HPE8311A_CMDINT16ARR_Q_MIN = &1&
Global Const HPE8311A_CMDINT16ARR_Q_MAX = 2147483647


Global Const HPE8311A_CMDINT32ARR_Q_MIN = &1&
Global Const HPE8311A_CMDINT32ARR_Q_MAX = 2147483647


Global Const HPE8311A_CMDREAL64ARR_Q_MIN = &1&
Global Const HPE8311A_CMDREAL64ARR_Q_MAX = 2147483647






        '  *************************************************
        '    Instrument specific constants                  
        '  *************************************************


Global Const HPE8311A_INSTR_ERROR_NOT_SUPPORTED_INSTR_TYPE = &HBFFC0D2A
Global Const HPE8311A_INSTR_ERROR_WHILE_GET_ATTRIBUTE = &HBFFC0D2B
Global Const HPE8311A_INSTR_ERROR_POUND_CHAR_NOT_IN_INSTRUMENT_ANSWER = &HBFFC0D2C
Global Const HPE8311A_INSTR_ERROR_LENGTH_BYTE_CONTAINS_INVALID_VALUE = &HBFFC0D2D
Global Const HPE8311A_INSTR_ERROR_OUTPUT_DATA_GREATER_READ_BUFFER = &HBFFC0D2E
Global Const HPE8311A_INSTR_ERROR_CANNOT_OPEN_FILE = &HBFFC0D2F
Global Const HPE8311A_INSTR_ERROR_CANNOT_CLOSE_FILE = &HBFFC0D30
Global Const HPE8311A_INSTR_ERROR_SOURCE_FILE_IS_EMPTY = &HBFFC0D31
Global Const HPE8311A_INSTR_ERROR_WRONG_STATE = &HBFFC0D32
Global Const HPE8311A_INSTR_ERROR_BIOS_FILE_CHECKSUM_ERROR = &HBFFC0D33
Global Const HPE8311A_INSTR_ERROR_CANT_SWAP_ODD_BYTE_QUANTITY = &HBFFC0D34
Global Const HPE8311A_INSTR_ERROR_PROGRAM_BIOS_NOT_SUPPORTED_FOR_GPIB = &HBFFC0D35
Global Const HPE8311A_INSTR_ERROR_SPECIAL_BIOS_NOT_SUPPORTED_FOR_GPIB = &HBFFC0D36
Global Const HPE8311A_INSTR_ERROR_FUNCTION_SPECIAL_BIOS_EXPECTED_URBIOS = &HBFFC0D37
Global Const HPE8311A_INSTR_ERROR_DOR_GREATER_THAN_OUTPUT_BUFFER = &HBFFC0D38
Global Const HPE8311A_INSTR_ERROR_CANNOT_SET_MODULE_TO_READY_STATE = &HBFFC0D39
Global Const HPE8311A_INSTR_ERROR_DRIVER_INTERNAL_TIMEOUT = &HBFFC0D3B
Global Const HPE8311A_INSTR_ERROR_FOUND_MODULE_IN_URBIOS = &HBFFC0D3C
Global Const HPE8311A_INSTR_ERROR_NOT_A_HEWLETT_PACKARD_MODULE = &HBFFC0D3D
Global Const HPE8311A_INSTR_ERROR_INSTRUMENT_ANSWER_NOT_IN_RANGE = &HBFFC0D3E
Global Const HPE8311A_INSTR_ERROR_UNEXPECTED_VALUE_IN_INSTRUMENTS_ANSWER = &HBFFC0D3F
Global Const HPE8311A_INSTR_ERROR_SOURCE_FILE_IS_TOO_LARGE = &HBFFC0D40
Global Const HPE8311A_INSTR_ERROR_CALIBRATION_FAILED = &HBFFC0D41
Global Const HPE8311A_INSTR_ERROR_VARIABLE_OVERFLOW = &HBFFC0D42
Global Const HPE8311A_INSTR_ERROR_STATE_MACHINE_ERROR = &HBFFC0D43
Global Const HPE8311A_INSTR_ERROR_NOT_SUPPORTED_FOR_VXI = &HBFFC0D44
Global Const HPE8311A_INSTR_ERROR_CANNOT_WRITE_TO_FILE = &HBFFC0D45
Global Const HPE8311A_INSTR_ERROR_CANNOT_READ_FROM_FILE = &HBFFC0D46
Global Const HPE8311A_INSTR_ERROR_FILE_CONTENTS_IS_CORRUPT = &HBFFC0D47
Global Const HPE8311A_INSTR_ERROR_DOR_EQUAL_ZERO = &HBFFC0D48
Global Const HPE8311A_INSTR_ERROR_REQUESTED_ERROR_KOMMA_MISSED = &HBFFC0D49
Global Const HPE8311A_INSTR_ERROR_TOO_MANY_ACTIVE_TRIGGER_REPORTED = &HBFFC0D4A
Global Const HPE8311A_INSTR_ERROR_UNSUPPORTED_INTERFACE = &HBFFC0D4B
Global Const HPE8311A_INSTR_ERROR_CANNOT_READ_OPTIONS = &HBFFC0D4C


Global Const TRANSACTION_ERR_BEGIN = (HPE8311A_INSTR_ERROR_CANNOT_READ_OPTIONS+1)
Global Const HPE8311A_INSTR_ERROR_TRANSACTION_IN_PROG = TRANSACTION_ERR_BEGIN
Global Const HPE8311A_INSTR_ERROR_TRANSACTION_NOT_IN_PROG = (TRANSACTION_ERR_BEGIN+1)
Global Const HPE8311A_INSTR_ERROR_TRANSACTION_BUFFER_OVERFLOW = (TRANSACTION_ERR_BEGIN+2)


Global Const HPE8311A_STRING_LENGTH = 256
Global Const HPE8311A_VI_VERSION_1_0 = &H100000
Global Const HPE8311A_VI_VERSION_1_1 = &H100100












'  CONSTANT - DEFINITIONS
'  selects a channel
Global Const HPE8311A_CHANNEL_ALL = 0
Global Const HPE8311A_CHANNEL_1 = 1
Global Const HPE8311A_CHANNEL_2 = 2
'  selects a data-channel
Global Const HPE8311A_DATA_CHANNEL_ALL = 0
Global Const HPE8311A_DATA_CHANNEL_1 = 1
Global Const HPE8311A_DATA_CHANNEL_2 = 2
Global Const HPE8311A_DATA_CHANNEL_3 = 3
'  selects a output
Global Const HPE8311A_OUTPUT_ALL = 0
Global Const HPE8311A_OUTPUT_TRIGGER = 1
Global Const HPE8311A_OUTPUT_STROBE = 2
Global Const HPE8311A_OUTPUT_SAME_AS_STROBE_OUT = 3
'  selects output states
Global Const HPE8311A_OUTPUT_NORMAL_OFF = 0
Global Const HPE8311A_OUTPUT_NORMAL_ON = 1
Global Const HPE8311A_OUTPUT_COMPLEMENT_OFF = 0
Global Const HPE8311A_OUTPUT_COMPLEMENT_ON = 1
Global Const HPE8311A_OUTPUT_POLARITY_NORMAL = 0
Global Const HPE8311A_OUTPUT_POLARITY_INVERTED = 1
'  selects pulse-types
Global Const HPE8311A_SINGLE_PULSES = 1
Global Const HPE8311A_DOUBLE_PULSES = 2
'  selects pattern-types
Global Const HPE8311A_NRZ = 0
Global Const HPE8311A_RZ = 1
'  selects desired setting
Global Const HPE8311A_SETTING_DEFAULT = 0
Global Const HPE8311A_SETTING_1 = 1
Global Const HPE8311A_SETTING_2 = 2
Global Const HPE8311A_SETTING_3 = 3
Global Const HPE8311A_SETTING_4 = 4
Global Const HPE8311A_SETTING_5 = 5
Global Const HPE8311A_SETTING_6 = 6
Global Const HPE8311A_SETTING_7 = 7
Global Const HPE8311A_SETTING_8 = 8
Global Const HPE8311A_SETTING_9 = 9
'  selects units for 
Global Const HPE8311A_UNIT_SEC = 0
Global Const HPE8311A_UNIT_PCT = 1
Global Const HPE8311A_UNIT_DEG = 2
Global Const HPE8311A_UNIT_RAD = 3
'  selects trigger-source or pulse-period
Global Const HPE8311A_INTERNAL_OSCILLATOR = 0
Global Const HPE8311A_INTERNAL_PLL = 1
Global Const HPE8311A_CLOCK_INPUT = 2
Global Const HPE8311A_EXTERNAL_INPUT = 3
Global Const HPE8311A_MANUAL = 4
Global Const HPE8311A_VXI_ECL_0 = 5
Global Const HPE8311A_VXI_ECL_1 = 6
Global Const HPE8311A_VXI_TTL_0 = 7
Global Const HPE8311A_VXI_TTL_1 = 8
Global Const HPE8311A_VXI_TTL_2 = 9
Global Const HPE8311A_VXI_TTL_3 = 10
Global Const HPE8311A_VXI_TTL_4 = 11
Global Const HPE8311A_VXI_TTL_5 = 12
Global Const HPE8311A_VXI_TTL_6 = 13
Global Const HPE8311A_VXI_TTL_7 = 14
Global Const HPE8311A_VXI_TRG_NONE = 15
'  selects hold-mode for delay, double-delay, width and edge
Global Const HPE8311A_HOLD_ABSOLUTE = 1
Global Const HPE8311A_HOLD_RATIO = 2
Global Const HPE8311A_WIDTH = 0
Global Const HPE8311A_DUTY_CYCLE = 1
Global Const HPE8311A_TRAILING_DELAY = 2
'  IMPORTANT; Do NOT change these two sets of values to be different from 
'             each other!!!  Both sets are used in ARM:SLOP commands.


'  selects slope for trigger
Global Const HPE8311A_FALLING = 0
Global Const HPE8311A_RISING = 1
Global Const HPE8311A_BOTH = 2
Global Const HPE8311A_UNTOUCHED = 3


'  selects level for gate
Global Const HPE8311A_LOW_LEVEL = HPE8311A_FALLING
Global Const HPE8311A_HIGH_LEVEL = HPE8311A_RISING
Global Const HPE8311A_ALWAYS = HPE8311A_BOTH
'  selects coupling between leading-edge and trailing-edge
Global Const HPE8311A_COUPLING_OFF = 0
Global Const HPE8311A_COUPLING_ON = 1
Global Const HPE8311A_COUPLING_ONCE = 2
'  selects peroid or frequency subtree
Global Const HPE8311A_VALUE_IS_PERIOD = 0
Global Const HPE8311A_VALUE_IS_FREQUENCY = 1
'  selects volt or ampere subtree
Global Const HPE8311A_LEVELS_VOLT = 0
Global Const HPE8311A_LEVELS_AMPERE = 1
'  selects source for PLL
Global Const HPE8311A_PLL_SOURCE_CLOCK_IN = 0
Global Const HPE8311A_PLL_SOURCE_INTERNAL_1 = 1
Global Const HPE8311A_PLL_SOURCE_INTERNAL_2 = 2
'  selects pattern update mode
Global Const HPE8311A_UPDATE_OFF = 0
Global Const HPE8311A_UPDATE_ONCE = 1
Global Const HPE8311A_UPDATE_CONTINUOUS = 2
'  selects limits enabling
Global Const HPE8311A_LIMITS_ENABLE_OFF = 0
Global Const HPE8311A_LIMITS_ENABLE_ON = 1
'  selects signal
Global Const HPE8311A_TTL = 0
Global Const HPE8311A_ECL = 1
Global Const HPE8311A_STA = 2
'  selects source for trigger
Global Const HPE8311A_COUPLING_OPERATION_MODE = 0
Global Const HPE8311A_TRIGGER_SOURCE_1 = 1
Global Const HPE8311A_TRIGGER_SOURCE_2 = 2
'  selects channel adding
Global Const HPE8311A_MATH_OFF = 0
Global Const HPE8311A_MATH_PLUS = 1
'  selects binary to ascii conversion
Global Const HPE8311A_CONVERT_OFF = 0
Global Const HPE8311A_CONVERT_ON = 1
'  selects PRBS polynomial 2^n-1
Global Const HPE8311A_PRBS_7 = 7
Global Const HPE8311A_PRBS_8 = 8
Global Const HPE8311A_PRBS_9 = 9
Global Const HPE8311A_PRBS_10 = 10
Global Const HPE8311A_PRBS_11 = 11
Global Const HPE8311A_PRBS_12 = 12
Global Const HPE8311A_PRBS_13 = 13
Global Const HPE8311A_PRBS_14 = 14
'  selects input/output impedance
Global Const HPE8311A_50_OHM = 50
Global Const HPE8311A_1K_OHM = 1000
Global Const HPE8311A_10K_OHM = 10000
'  selects external PLL reference frequency
Global Const HPE8311A_5_MHZ = 5e6
Global Const HPE8311A_10_MHZ = 10e6


'  error
Global Const HPE8311A_INVALID_VALUE = 32767






'  REQUIRED plug&play FUNCTIONS FROM VPP-3.1  
Declare Function hpe8311a_init Lib "hpe8311a_32.dll" (ByVal resourceName As String, ByVal IDQuery As Integer, ByVal resetDevice As Integer, instrumentHandle As Long) As Long

Declare Function hpe8311a_close Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hpe8311a_reset Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hpe8311a_self_test Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, selfTestResult As Integer, ByVal selfTestMessage As String) As Long

Declare Function hpe8311a_error_query Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, errorCode As Long, ByVal errorMessage As String) As Long

Declare Function hpe8311a_error_message Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal statusCode As Long, ByVal message As String) As Long

Declare Function hpe8311a_revision_query Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal instrumentDriverRevision As String, ByVal firmwareRevision As String) As Long





'  TRANSACTION FUNCTIONS                  
Declare Function hpe8311a_transactionStart Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hpe8311a_transactionFinish Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hpe8311a_transactionCancel Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hpe8311a_transaction_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, pTransactionInProgress As Integer, pCurrBufferLength As Long) As Long





'  HP STANDARD UTILITY FUNCTIONS                  
Declare Function hpe8311a_timeOut Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal setTimeOut As Long) As Long

Declare Function hpe8311a_timeOut_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, timeOut As Long) As Long

Declare Function hpe8311a_errorQueryDetect Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal setErrorQueryDetect As Integer) As Long

Declare Function hpe8311a_errorQueryDetect_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, errorQueryDetect As Integer) As Long

Declare Function hpe8311a_dcl Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long

Declare Function hpe8311a_opc_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, instrumentReady As Integer) As Long





'  STATUS FUNCTIONS                  
Declare Function hpe8311a_readStatusByte_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, statusByte As Integer) As Long

Declare Function hpe8311a_operEvent_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, operationEventRegister As Long) As Long

Declare Function hpe8311a_operCond_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, operationConditionRegister As Long) As Long

Declare Function hpe8311a_quesEvent_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, questionableEventRegister As Long) As Long

Declare Function hpe8311a_quesCond_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, questionableConditionRegister As Long) As Long





'  COMMAND PASSTHROUGH FUNCTIONS      
Declare Function hpe8311a_cmd Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendStringCommand As String) As Long

Declare Function hpe8311a_cmdWithControlSequence Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendStringCommand As String) As Long

Declare Function hpe8311a_cmdInt Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendIntegerCommand As String, ByVal sendInteger As Long) As Long

Declare Function hpe8311a_cmdInt16_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryI16Command As String, i16Result As Integer) As Long

Declare Function hpe8311a_cmdInt32_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryI32Command As String, i32Result As Long) As Long

Declare Function hpe8311a_cmdUInt Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendUIntegerCommand As String, ByVal sendUInteger As Long) As Long

Declare Function hpe8311a_cmdUInt16_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryUI16Command As String, ui16Result As Integer) As Long

Declare Function hpe8311a_cmdUInt32_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryUI32Command As String, ui32Result As Long) As Long

Declare Function hpe8311a_cmdString Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendStringCommand As String, ByVal sendString As String) As Long

Declare Function hpe8311a_cmdString_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryStringCommand As String, ByVal stringSize As Long, ByVal stringResult As String) As Long

Declare Function hpe8311a_cmdReal Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendRealCommand As String, ByVal sendReal As Double) As Long

Declare Function hpe8311a_cmdReal64_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryRealCommand As String, realResult As Double) As Long

Declare Function hpe8311a_cmdInt8Arr Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal sendI8ArrayCommand As String, sendI8Array As String, ByVal sendI8ArraySize As Long) As Long

Declare Function hpe8311a_cmdInt8Arr_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal queryI8ArrayCommand As String, ByVal i8ArraySize As Long, i8ArrayResult As String, i8ArrayCount As Long) As Long





'  MODE-FUNCTIONS




'  General used
Declare Function hpe8311a_modePulseType Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal pulseType As Integer) As Long

Declare Function hpe8311a_modePulseType_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, pulseType As Integer) As Long

Declare Function hpe8311a_modePatternDataFormat Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal dataFormat As Integer) As Long

Declare Function hpe8311a_modePatternDataFormat_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, dataFormat As Integer) As Long





'  Mode - Continuous
Declare Function hpe8311a_modeContinuousPulses Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer) As Long

Declare Function hpe8311a_modeContinuousBurst Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal burstLength As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer) As Long

Declare Function hpe8311a_modeContinuousPattern Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer) As Long





'  Mode - Triggered
Declare Function hpe8311a_modeTriggeredPulses Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerSource As Integer, ByVal triggerSlope As Integer) As Long

Declare Function hpe8311a_modeTriggeredBurst Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal burstLength As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer, ByVal triggerSource As Integer, ByVal triggerSlope As Integer, ByVal pllPeriodFrequencyFormat As Integer, ByVal pllPeriodFrequencyValue As Double) As Long

Declare Function hpe8311a_modeTriggeredPattern Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer, ByVal triggerSource As Integer, ByVal triggerSlope As Integer, ByVal pllPeriodFrequencyFormat As Integer, ByVal pllPeriodFrequencyValue As Double) As Long





'  Mode - Gated
Declare Function hpe8311a_modeGatedPulses Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer, ByVal gateSource As Integer, ByVal gateLevel As Integer) As Long

Declare Function hpe8311a_modeGatedBurst Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal burstLength As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer, ByVal gateSource As Integer, ByVal gateLevel As Integer) As Long

Declare Function hpe8311a_modeGatedPattern Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal pulsePeriodSource As Integer, ByVal externalClockEdge As Integer, ByVal gateSource As Integer, ByVal gateLevel As Integer) As Long





'  Mode - External Width
Declare Function hpe8311a_modeExternalWidth Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerSource As Integer) As Long







'  TIMING-FUNCTIONS




'  Timing - Period
Declare Function hpe8311a_timePeriod Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal periodValue As Double) As Long

Declare Function hpe8311a_timePeriod_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, periodValue As Double) As Long

Declare Function hpe8311a_timePeriodMeasure Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long





'  Timing - Frequency
Declare Function hpe8311a_timeFrequency Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal frequencyValue As Double) As Long

Declare Function hpe8311a_timeFrequency_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, frequencyValue As Double) As Long

Declare Function hpe8311a_timeFrequencyMeasure Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long





'  Timing - Delay
Declare Function hpe8311a_timeDelay Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal delayUnit As Integer, ByVal delayValue As Double) As Long

Declare Function hpe8311a_timeDelay_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, delayUnit As Integer, delayValue As Double) As Long

Declare Function hpe8311a_timeDelayHold Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal delayHoldMode As Integer) As Long

Declare Function hpe8311a_timeDelayHold_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, delayHoldMode As Integer) As Long





'  Timing - Double-Delay
Declare Function hpe8311a_timeDelayDouble Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal doubleDelayUnit As Integer, ByVal doubleDelayValue As Double) As Long

Declare Function hpe8311a_timeDelayDouble_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, doubleDelayUnit As Integer, doubleDelayValue As Double) As Long

Declare Function hpe8311a_timeDelayDoubleHold Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal doubleDelayHoldMode As Integer) As Long

Declare Function hpe8311a_timeDelayDoubleHold_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, doubleDelayHoldMode As Integer) As Long





'  Timing - Width
Declare Function hpe8311a_timeWidth Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal widthValue As Double) As Long

Declare Function hpe8311a_timeWidth_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, widthValue As Double) As Long

Declare Function hpe8311a_timeWidthDutyCycle Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal dutyCycleValue As Double) As Long

Declare Function hpe8311a_timeWidthDutyCycle_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, dutyCycleValue As Double) As Long

Declare Function hpe8311a_timeWidthTrailingDelay Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal trailingDelayValue As Double) As Long

Declare Function hpe8311a_timeWidthTrailingDelay_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, trailingDelayValue As Double) As Long

Declare Function hpe8311a_timeWidthHold Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal widthHoldMode As Integer) As Long

Declare Function hpe8311a_timeWidthHold_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, widthHoldMode As Integer) As Long





'  Timing - Leading-Edge
Declare Function hpe8311a_timeEdgeLeading Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal leadingEdgeUnit As Integer, ByVal leadingEdgeValue As Double) As Long

Declare Function hpe8311a_timeEdgeLeading_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, leadingEdgeUnit As Integer, leadingEdgeValue As Double) As Long





'  Timing - Trailing-Edge
Declare Function hpe8311a_timeEdgeTrailing Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal trailingEdgeUnit As Integer, ByVal trailingEdgeValue As Double) As Long

Declare Function hpe8311a_timeEdgeTrailing_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, trailingEdgeUnit As Integer, trailingEdgeValue As Double) As Long

Declare Function hpe8311a_timeEdgeTrailingCoupling Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal trailingEdgeCoupling As Integer) As Long

Declare Function hpe8311a_timeEdgeTrailingCoupling_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, trailingEdgeCoupling As Integer) As Long





'  Timing - Edge Hold
Declare Function hpe8311a_timeEdgeHold Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal edgeHoldMode As Integer) As Long

Declare Function hpe8311a_timeEdgeHold_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, edgeHoldMode As Integer) As Long



Declare Function hpe8311a_timeCalibration Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long



'  LEVEL-FUNCTIONS
Declare Function hpe8311a_levelHighLow Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal levelUnit As Integer, ByVal levelValueHigh As Double, ByVal levelValueLow As Double) As Long

Declare Function hpe8311a_levelHighLow_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, levelUnit As Integer, levelValueHigh As Double, levelValueLow As Double) As Long

Declare Function hpe8311a_levelOffsetAmplitude Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal levelUnit As Integer, ByVal levelValueOffset As Double, ByVal levelValueAmplitude As Double) As Long

Declare Function hpe8311a_levelOffsetAmplitude_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, levelUnit As Integer, levelValueOffset As Double, levelValueAmplitude As Double) As Long





'  PATTERN-FUNCTIONS
Declare Function hpe8311a_patternUpdate Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal patternUpdateMode As Integer) As Long

Declare Function hpe8311a_patternUpdate_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, patternUpdateMode As Integer) As Long

Declare Function hpe8311a_patternDataDownloadBuffer Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, dataBuffer As Byte, ByVal patternLength As Long) As Long

Declare Function hpe8311a_patternDataDownloadBuffer_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, dataBuffer As Byte, patternLengthReturned As Long, ByVal bufferSize As Long, ByVal convertBinaryToAscii As Integer) As Long

Declare Function hpe8311a_patternDataDownloadFile Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal fileName As String) As Long

Declare Function hpe8311a_patternDataDownloadFile_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal fileName As String, ByVal convertBinaryToAscii As Integer) As Long

Declare Function hpe8311a_patternDataPreset Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal patternDivider As Long, ByVal patternLength As Long) As Long

Declare Function hpe8311a_patternDataPRBS Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal polynomExponent As Integer, ByVal patternLength As Long) As Long





'  SETTING-FUNCTIONS
Declare Function hpe8311a_settingStore Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal settingNumber As Integer) As Long

Declare Function hpe8311a_settingRecall Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal settingNumber As Integer) As Long

Declare Function hpe8311a_settingFile Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal settingSourceFileName As String) As Long

Declare Function hpe8311a_settingFile_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal settingDestinationFileName As String) As Long





'  LIMIT-FUNCTIONS
Declare Function hpe8311a_limitState Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal limitEnable As Integer) As Long

Declare Function hpe8311a_limitState_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, limitEnable As Integer) As Long

Declare Function hpe8311a_limit Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal limitsVoltageHighLevel As Double, ByVal limitsVoltageLowLevel As Double, ByVal limitsCurrentHighLevel As Double, ByVal limitsCurrentLowLevel As Double) As Long

Declare Function hpe8311a_limit_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, limitsVoltageHighLevel As Double, limitsVoltageLowLevel As Double, limitsCurrentHighLevel As Double, limitsCurrentLowLevel As Double) As Long





'  CONFIG-FUNCTIONS




'  Configuration - Outputs
Declare Function hpe8311a_configOutputImpedance Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal internalImpedance As Double) As Long

Declare Function hpe8311a_configOutputImpedance_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, internalImpedance As Double) As Long

Declare Function hpe8311a_configOutputLoadCompensation Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal loadCompensation As Double) As Long

Declare Function hpe8311a_configOutputLoadCompensation_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, loadCompensation As Double) As Long





'  Configuration - Inputs
Declare Function hpe8311a_configInputExternal Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal inputExternalThreshold As Double, ByVal inputExternalImpedance As Double) As Long

Declare Function hpe8311a_configInputExternal_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, inputExternalThreshold As Double, inputExternalImpedance As Double) As Long

Declare Function hpe8311a_configInputClock Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal inputClockThreshold As Double, ByVal inputClockImpedance As Double) As Long

Declare Function hpe8311a_configInputClock_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, inputClockThreshold As Double, inputClockImpedance As Double) As Long





'  Configuration - PLL
Declare Function hpe8311a_configPllReference Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal pllSourceSelect As Integer, ByVal pllExternalFrequencyValue As Double) As Long

Declare Function hpe8311a_configPllReference_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, pllSourceSelect As Integer, pllExternalFrequencyValue As Double) As Long





'  Configuration - Trigger-Levels




Declare Function hpe8311a_configTriggerOutLevel Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerOuput As Integer, ByVal triggerLevel As Integer) As Long

Declare Function hpe8311a_configTriggerOutLevel_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerOuput As Integer, triggerLevel As Integer) As Long

Declare Function hpe8311a_configTriggerOutSource Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerSource As Integer) As Long

Declare Function hpe8311a_configTriggerOutSource_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, triggerSource As Integer) As Long





'  OUTPUT-FUNCTIONS
Declare Function hpe8311a_outputMath Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal mathMode As Integer) As Long

Declare Function hpe8311a_outputMath_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, mathMode As Integer) As Long

Declare Function hpe8311a_outputStateNormal Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal outputNormalState As Integer) As Long

Declare Function hpe8311a_outputStateNormal_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, outputNormalState As Integer) As Long

Declare Function hpe8311a_outputStateComplement Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal outputComplementState As Integer) As Long

Declare Function hpe8311a_outputStateComplement_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, outputComplementState As Integer) As Long

Declare Function hpe8311a_outputPolarity Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, ByVal outputStatePolarity As Integer) As Long

Declare Function hpe8311a_outputPolarity_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal channel As Integer, outputStatePolarity As Integer) As Long

Declare Function hpe8311a_outputSourceVxiTrigger Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerOutput As Integer) As Long

Declare Function hpe8311a_outputSourceVxiTrigger_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, triggerOutput As Integer) As Long

Declare Function hpe8311a_outputEnableVxiTrigger Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal triggerLine As Integer) As Long

Declare Function hpe8311a_outputEnableVxiTrigger_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, triggerLine As Integer) As Long





'  ARMING FUNCTIONS
Declare Function hpe8311a_armFrequency Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal frequencyValue As Double) As Long

Declare Function hpe8311a_armFrequency_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, frequencyValue As Double) As Long

Declare Function hpe8311a_armPeriod Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal periodValue As Double) As Long

Declare Function hpe8311a_armPeriod_Q Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, periodValue As Double) As Long



'  Undocumented very harmful specific functions
'    Hewlett-Packard recommends not to use them
'    Only good for expert use!
Declare Function hpe8311a_biosProgramFile Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long, ByVal filename As String) As Long

Declare Function hpe8311a_biosSpecial Lib "hpe8311a_32.dll" (ByVal instrumentHandle As Long) As Long











