///////////////////////////////////////////////////////////////////////////////
//              This program is property of
///////////////////////////////////////////////////////////////////////////////
//
//
//                   ****   ****  
//                 ***  /_  _  ***     HEWLETT
//                 **  / / /_/  **
//                 ***    /    ***     PACKARD
//                   ****   **** 
//
//
///////////////////////////////////////////////////////////////////////////////
//              Copyright (C) 1999 Hewlett-Packard Company
///////////////////////////////////////////////////////////////////////////////



//-----------------------------------------------------------------------------
// File contents : Driver for HPE8311A
//                 Pulse/Pattern-Generator 
//                 Driver Version: A 1.0.2.0
//-----------------------------------------------------------------------------
// Note          : This driver is compatible with the following 
//                 VXIplug&play standards:
//                 WIN32 System Framework revision 4.0
//                 VISA revision 1.0 (does not work with VTL) 
//-----------------------------------------------------------------------------



#ifndef HPE8311A_INCLUDE 
#define HPE8311A_INCLUDE

#include <vpptype.h>


#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif


        // *************************************************
        //   Standard constant error conditions returned    
        //   by driver functions.                           
        //     HP Common Error numbers start at BFFC0D00    
        //     The parameter errors extend the number of    
        //       errors over the eight defined in VPP 3.4   
        // *************************************************

#define HPE8311A_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) //  0xBFFC0D02 
#define HPE8311A_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) //  0xBFFC0D03 
#define HPE8311A_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) //  0xBFFC0D04 
#define HPE8311A_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) //  0xBFFC0D05 
#define HPE8311A_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) //  0xBFFC0D06 
#define HPE8311A_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) //  0xBFFC0D07 
#define HPE8311A_INSTR_NO_LAST_COMMA       (_VI_ERROR+0x3FFC0D08L) //  0xBFFC0D08  

#define HPE8311A_INSTR_ERROR_PARAMETER9    (_VI_ERROR+0x3FFC0D20L) //  0xBFFC0D20 
#define HPE8311A_INSTR_ERROR_PARAMETER10   (_VI_ERROR+0x3FFC0D21L) //  0xBFFC0D21 
#define HPE8311A_INSTR_ERROR_PARAMETER11   (_VI_ERROR+0x3FFC0D22L) //  0xBFFC0D22 
#define HPE8311A_INSTR_ERROR_PARAMETER12   (_VI_ERROR+0x3FFC0D23L) //  0xBFFC0D23 
#define HPE8311A_INSTR_ERROR_PARAMETER13   (_VI_ERROR+0x3FFC0D24L) //  0xBFFC0D24 
#define HPE8311A_INSTR_ERROR_PARAMETER14   (_VI_ERROR+0x3FFC0D25L) //  0xBFFC0D25 
#define HPE8311A_INSTR_ERROR_PARAMETER15   (_VI_ERROR+0x3FFC0D26L) //  0xBFFC0D26 
#define HPE8311A_INSTR_ERROR_PARAMETER16   (_VI_ERROR+0x3FFC0D27L) //  0xBFFC0D27 
#define HPE8311A_INSTR_ERROR_PARAMETER17   (_VI_ERROR+0x3FFC0D28L) //  0xBFFC0D28 
#define HPE8311A_INSTR_ERROR_PARAMETER18   (_VI_ERROR+0x3FFC0D29L) //  0xBFFC0D29 

        // *************************************************
        //   Constants used by system status functions      
        //     These defines are bit numbers which define   
        //     the operation and questionable registers.    
        //     They are instrument specific.                
        // *************************************************


#define HPE8311A_QUES_BIT0          1
#define HPE8311A_QUES_BIT1          2
#define HPE8311A_QUES_BIT2          4
#define HPE8311A_QUES_BIT3          8
#define HPE8311A_QUES_BIT4         16
#define HPE8311A_QUES_BIT5         32
#define HPE8311A_QUES_BIT6         64
#define HPE8311A_QUES_BIT7        128
#define HPE8311A_QUES_BIT8        256
#define HPE8311A_QUES_BIT9        512
#define HPE8311A_QUES_BIT10      1024
#define HPE8311A_QUES_BIT11      2048
#define HPE8311A_QUES_BIT12      4096
#define HPE8311A_QUES_BIT13      8192
#define HPE8311A_QUES_BIT14     16384
#define HPE8311A_QUES_BIT15     32768

#define HPE8311A_OPER_BIT0          1
#define HPE8311A_OPER_BIT1          2
#define HPE8311A_OPER_BIT2          4
#define HPE8311A_OPER_BIT3          8
#define HPE8311A_OPER_BIT4         16
#define HPE8311A_OPER_BIT5         32
#define HPE8311A_OPER_BIT6         64
#define HPE8311A_OPER_BIT7        128
#define HPE8311A_OPER_BIT8        256
#define HPE8311A_OPER_BIT9        512
#define HPE8311A_OPER_BIT10      1024
#define HPE8311A_OPER_BIT11      2048
#define HPE8311A_OPER_BIT12      4096
#define HPE8311A_OPER_BIT13      8192
#define HPE8311A_OPER_BIT14     16384
#define HPE8311A_OPER_BIT15     32768

        // *************************************************
        //   Constants used by function hpe8311a_timeOut    
        // *************************************************

#define HPE8311A_TIMEOUT_MAX         2147483647
#define HPE8311A_TIMEOUT_MIN         0L

#define HPE8311A_CMDINT8ARR_Q_MIN   1L
#define HPE8311A_CMDINT8ARR_Q_MAX   2147483647

#define HPE8311A_CMDINT16ARR_Q_MIN   1L
#define HPE8311A_CMDINT16ARR_Q_MAX   2147483647

#define HPE8311A_CMDINT32ARR_Q_MIN   1L
#define HPE8311A_CMDINT32ARR_Q_MAX   2147483647

#define HPE8311A_CMDREAL64ARR_Q_MIN  1L
#define HPE8311A_CMDREAL64ARR_Q_MAX  2147483647



        // *************************************************
        //   Instrument specific constants                  
        // *************************************************

#define HPE8311A_INSTR_ERROR_NOT_SUPPORTED_INSTR_TYPE   (_VI_ERROR+0x3FFC0D2AL) //  0xBFFC0D2A 
#define HPE8311A_INSTR_ERROR_WHILE_GET_ATTRIBUTE        (_VI_ERROR+0x3FFC0D2BL)  //  0xBFFC0D2B 
#define HPE8311A_INSTR_ERROR_POUND_CHAR_NOT_IN_INSTRUMENT_ANSWER  (_VI_ERROR+0x3FFC0D2CL) //  0xBFFC0D2C 
#define HPE8311A_INSTR_ERROR_LENGTH_BYTE_CONTAINS_INVALID_VALUE   (_VI_ERROR+0x3FFC0D2DL) //  0xBFFC0D2D
#define HPE8311A_INSTR_ERROR_OUTPUT_DATA_GREATER_READ_BUFFER      (_VI_ERROR+0x3FFC0D2EL) //  0xBFFC0D2E
#define HPE8311A_INSTR_ERROR_CANNOT_OPEN_FILE (_VI_ERROR+0x3FFC0D2FL) //  0xBFFC0D2F
#define HPE8311A_INSTR_ERROR_CANNOT_CLOSE_FILE (_VI_ERROR+0x3FFC0D30L) //  0xBFFC0D30
#define HPE8311A_INSTR_ERROR_SOURCE_FILE_IS_EMPTY (_VI_ERROR+0x3FFC0D31L) //  0xBFFC0D31
#define HPE8311A_INSTR_ERROR_WRONG_STATE (_VI_ERROR+0x3FFC0D32L) //  0xBFFC0D32
#define HPE8311A_INSTR_ERROR_BIOS_FILE_CHECKSUM_ERROR (_VI_ERROR+0x3FFC0D33L) //  0xBFFC0D33
#define HPE8311A_INSTR_ERROR_CANT_SWAP_ODD_BYTE_QUANTITY (_VI_ERROR+0x3FFC0D34L) //  0xBFFC0D34
#define HPE8311A_INSTR_ERROR_PROGRAM_BIOS_NOT_SUPPORTED_FOR_GPIB (_VI_ERROR+0x3FFC0D35L) //  0xBFFC0D35
#define HPE8311A_INSTR_ERROR_SPECIAL_BIOS_NOT_SUPPORTED_FOR_GPIB (_VI_ERROR+0x3FFC0D36L) //  0xBFFC0D36
#define HPE8311A_INSTR_ERROR_FUNCTION_SPECIAL_BIOS_EXPECTED_URBIOS (_VI_ERROR+0x3FFC0D37L) //  0xBFFC0D37
#define HPE8311A_INSTR_ERROR_DOR_GREATER_THAN_OUTPUT_BUFFER (_VI_ERROR+0x3FFC0D38L) //  0xBFFC0D38
#define HPE8311A_INSTR_ERROR_CANNOT_SET_MODULE_TO_READY_STATE (_VI_ERROR+0x3FFC0D39L) //  0xBFFC0D39
#define HPE8311A_INSTR_ERROR_DRIVER_INTERNAL_TIMEOUT (_VI_ERROR+0x3FFC0D3BL) //  0xBFFC0D3B
#define HPE8311A_INSTR_ERROR_FOUND_MODULE_IN_URBIOS (_VI_ERROR+0x3FFC0D3CL) //  0xBFFC0D3C
#define HPE8311A_INSTR_ERROR_NOT_A_HEWLETT_PACKARD_MODULE (_VI_ERROR+0x3FFC0D3DL) //  0xBFFC0D3D
#define HPE8311A_INSTR_ERROR_INSTRUMENT_ANSWER_NOT_IN_RANGE (_VI_ERROR+0x3FFC0D3EL) //  0xBFFC0D3E
#define HPE8311A_INSTR_ERROR_UNEXPECTED_VALUE_IN_INSTRUMENTS_ANSWER (_VI_ERROR+0x3FFC0D3FL) //  0xBFFC0D3F
#define HPE8311A_INSTR_ERROR_SOURCE_FILE_IS_TOO_LARGE (_VI_ERROR+0x3FFC0D40L) //  0xBFFC0D40
#define HPE8311A_INSTR_ERROR_CALIBRATION_FAILED (_VI_ERROR+0x3FFC0D41L) //  0xBFFC0D41
#define HPE8311A_INSTR_ERROR_VARIABLE_OVERFLOW (_VI_ERROR+0x3FFC0D42L) //  0xBFFC0D42
#define HPE8311A_INSTR_ERROR_STATE_MACHINE_ERROR (_VI_ERROR+0x3FFC0D43L) //  0xBFFC0D43
#define HPE8311A_INSTR_ERROR_NOT_SUPPORTED_FOR_VXI (_VI_ERROR+0x3FFC0D44L) //  0xBFFC0D44
#define HPE8311A_INSTR_ERROR_CANNOT_WRITE_TO_FILE (_VI_ERROR+0x3FFC0D45L) //  0xBFFC0D45
#define HPE8311A_INSTR_ERROR_CANNOT_READ_FROM_FILE (_VI_ERROR+0x3FFC0D46L) //  0xBFFC0D46
#define HPE8311A_INSTR_ERROR_FILE_CONTENTS_IS_CORRUPT (_VI_ERROR+0x3FFC0D47L) //  0xBFFC0D47
#define HPE8311A_INSTR_ERROR_DOR_EQUAL_ZERO (_VI_ERROR+0x3FFC0D48L) //  0xBFFC0D48
#define HPE8311A_INSTR_ERROR_REQUESTED_ERROR_KOMMA_MISSED (_VI_ERROR+0x3FFC0D49L) //  0xBFFC0D49
#define HPE8311A_INSTR_ERROR_TOO_MANY_ACTIVE_TRIGGER_REPORTED (_VI_ERROR+0x3FFC0D4AL) //  0xBFFC0D4A
#define HPE8311A_INSTR_ERROR_UNSUPPORTED_INTERFACE (_VI_ERROR+0x3FFC0D4BL) //  0xBFFC0D4B
#define HPE8311A_INSTR_ERROR_CANNOT_READ_OPTIONS (_VI_ERROR+0x3FFC0D4CL) //  0xBFFC0D4C

#define TRANSACTION_ERR_BEGIN (HPE8311A_INSTR_ERROR_CANNOT_READ_OPTIONS+1)
#define HPE8311A_INSTR_ERROR_TRANSACTION_IN_PROG TRANSACTION_ERR_BEGIN
#define HPE8311A_INSTR_ERROR_TRANSACTION_NOT_IN_PROG (TRANSACTION_ERR_BEGIN+1)
#define HPE8311A_INSTR_ERROR_TRANSACTION_BUFFER_OVERFLOW (TRANSACTION_ERR_BEGIN+2)

#define HPE8311A_STRING_LENGTH 256
#define HPE8311A_VI_VERSION_1_0 0x100000
#define HPE8311A_VI_VERSION_1_1 0x100100






//#############################################################################
// CONSTANT - DEFINITIONS
//#############################################################################
// selects a channel
#define HPE8311A_CHANNEL_ALL 0
#define HPE8311A_CHANNEL_1 1
#define HPE8311A_CHANNEL_2 2
//---------------------------------------------------------------------------
// selects a data-channel
#define HPE8311A_DATA_CHANNEL_ALL  0
#define HPE8311A_DATA_CHANNEL_1    1
#define HPE8311A_DATA_CHANNEL_2    2
#define HPE8311A_DATA_CHANNEL_3    3
//---------------------------------------------------------------------------
// selects a output
#define HPE8311A_OUTPUT_ALL     0
#define HPE8311A_OUTPUT_TRIGGER 1
#define HPE8311A_OUTPUT_STROBE  2
#define HPE8311A_OUTPUT_SAME_AS_STROBE_OUT    3
//---------------------------------------------------------------------------
// selects output states
#define HPE8311A_OUTPUT_NORMAL_OFF        0
#define HPE8311A_OUTPUT_NORMAL_ON         1
#define HPE8311A_OUTPUT_COMPLEMENT_OFF    0
#define HPE8311A_OUTPUT_COMPLEMENT_ON     1
#define HPE8311A_OUTPUT_POLARITY_NORMAL   0
#define HPE8311A_OUTPUT_POLARITY_INVERTED 1
//---------------------------------------------------------------------------
// selects pulse-types
#define HPE8311A_SINGLE_PULSES 1
#define HPE8311A_DOUBLE_PULSES 2
// selects pattern-types
#define HPE8311A_NRZ 0                     // non return to zero
#define HPE8311A_RZ  1                     // return to zero
//---------------------------------------------------------------------------
// selects desired setting
#define HPE8311A_SETTING_DEFAULT 0
#define HPE8311A_SETTING_1 1
#define HPE8311A_SETTING_2 2
#define HPE8311A_SETTING_3 3
#define HPE8311A_SETTING_4 4
#define HPE8311A_SETTING_5 5
#define HPE8311A_SETTING_6 6
#define HPE8311A_SETTING_7 7
#define HPE8311A_SETTING_8 8
#define HPE8311A_SETTING_9 9
//---------------------------------------------------------------------------
// selects units for 
#define HPE8311A_UNIT_SEC 0                // seconds
#define HPE8311A_UNIT_PCT 1                // percent
#define HPE8311A_UNIT_DEG 2                // degrees
#define HPE8311A_UNIT_RAD 3                // radiants
//---------------------------------------------------------------------------
// selects trigger-source or pulse-period
#define HPE8311A_INTERNAL_OSCILLATOR 0
#define HPE8311A_INTERNAL_PLL        1
#define HPE8311A_CLOCK_INPUT         2
#define HPE8311A_EXTERNAL_INPUT      3
#define HPE8311A_MANUAL              4
#define HPE8311A_VXI_ECL_0           5
#define HPE8311A_VXI_ECL_1           6
#define HPE8311A_VXI_TTL_0           7
#define HPE8311A_VXI_TTL_1           8
#define HPE8311A_VXI_TTL_2           9
#define HPE8311A_VXI_TTL_3          10
#define HPE8311A_VXI_TTL_4          11
#define HPE8311A_VXI_TTL_5          12
#define HPE8311A_VXI_TTL_6          13
#define HPE8311A_VXI_TTL_7          14
#define HPE8311A_VXI_TRG_NONE       15
//---------------------------------------------------------------------------
// selects hold-mode for delay, double-delay, width and edge
#define HPE8311A_HOLD_ABSOLUTE   1
#define HPE8311A_HOLD_RATIO      2
#define HPE8311A_WIDTH           0
#define HPE8311A_DUTY_CYCLE      1
#define HPE8311A_TRAILING_DELAY  2
//---------------------------------------------------------------------------
// IMPORTANT; Do NOT change these two sets of values to be different from 
//            each other!!!  Both sets are used in ARM:SLOP commands.

// selects slope for trigger
#define HPE8311A_FALLING   0
#define HPE8311A_RISING    1
#define HPE8311A_BOTH      2
#define HPE8311A_UNTOUCHED 3

// selects level for gate
#define HPE8311A_LOW_LEVEL   HPE8311A_FALLING
#define HPE8311A_HIGH_LEVEL  HPE8311A_RISING
#define HPE8311A_ALWAYS      HPE8311A_BOTH
//---------------------------------------------------------------------------
// selects coupling between leading-edge and trailing-edge
#define HPE8311A_COUPLING_OFF  0
#define HPE8311A_COUPLING_ON   1
#define HPE8311A_COUPLING_ONCE 2
//---------------------------------------------------------------------------
// selects peroid or frequency subtree
#define HPE8311A_VALUE_IS_PERIOD    0
#define HPE8311A_VALUE_IS_FREQUENCY 1
//---------------------------------------------------------------------------
// selects volt or ampere subtree
#define HPE8311A_LEVELS_VOLT   0
#define HPE8311A_LEVELS_AMPERE 1
//---------------------------------------------------------------------------
// selects source for PLL
#define HPE8311A_PLL_SOURCE_CLOCK_IN     0
#define HPE8311A_PLL_SOURCE_INTERNAL_1 1
#define HPE8311A_PLL_SOURCE_INTERNAL_2 2
//---------------------------------------------------------------------------
// selects pattern update mode
#define HPE8311A_UPDATE_OFF        0
#define HPE8311A_UPDATE_ONCE       1
#define HPE8311A_UPDATE_CONTINUOUS 2
//---------------------------------------------------------------------------
// selects limits enabling
#define HPE8311A_LIMITS_ENABLE_OFF 0
#define HPE8311A_LIMITS_ENABLE_ON  1
//---------------------------------------------------------------------------
// selects signal
#define HPE8311A_TTL 0
#define HPE8311A_ECL 1
#define HPE8311A_STA 2
//---------------------------------------------------------------------------
// selects source for trigger
#define HPE8311A_COUPLING_OPERATION_MODE 0
#define HPE8311A_TRIGGER_SOURCE_1      1
#define HPE8311A_TRIGGER_SOURCE_2      2
//---------------------------------------------------------------------------
// selects channel adding
#define HPE8311A_MATH_OFF  0
#define HPE8311A_MATH_PLUS 1
//---------------------------------------------------------------------------
// selects binary to ascii conversion
#define HPE8311A_CONVERT_OFF  0
#define HPE8311A_CONVERT_ON   1
//---------------------------------------------------------------------------
// selects PRBS polynomial 2^n-1
#define HPE8311A_PRBS_7             7
#define HPE8311A_PRBS_8             8
#define HPE8311A_PRBS_9             9
#define HPE8311A_PRBS_10           10
#define HPE8311A_PRBS_11           11
#define HPE8311A_PRBS_12           12
#define HPE8311A_PRBS_13           13
#define HPE8311A_PRBS_14           14
//---------------------------------------------------------------------------
// selects input/output impedance
#define HPE8311A_50_OHM            50
#define HPE8311A_1K_OHM          1000
#define HPE8311A_10K_OHM        10000
//---------------------------------------------------------------------------
// selects external PLL reference frequency
#define HPE8311A_5_MHZ            5e6
#define HPE8311A_10_MHZ          10e6

//---------------------------------------------------------------------------
// error
#define HPE8311A_INVALID_VALUE 32767
//#############################################################################



//00000000000000000000000000000000000000000000000000000000000000000000000000000
// REQUIRED plug&play FUNCTIONS FROM VPP-3.1  
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_init(
  ViRsrc     resourceName,
  ViBoolean  IDQuery,
  ViBoolean  resetDevice,
  ViPSession instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_close(
  ViSession  instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_reset(
  ViSession  instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_self_test(
  ViSession  instrumentHandle,
  ViPInt16   selfTestResult,
  ViPString  selfTestMessage
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_error_query(
  ViSession  instrumentHandle,
  ViPInt32   errorCode,
  ViPString  errorMessage
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_error_message(
  ViSession  instrumentHandle,
  ViStatus   statusCode,
  ViPString  message
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_revision_query(
  ViSession  instrumentHandle,
  ViPString  instrumentDriverRevision,
  ViPString  firmwareRevision
  );
//-------------------------------------------------------------------------

        
//00000000000000000000000000000000000000000000000000000000000000000000000000000
// TRANSACTION FUNCTIONS                  
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_transactionStart(
  ViSession  instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_transactionFinish(
  ViSession  instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_transactionCancel(
  ViSession  instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_transaction_Q(
  ViSession  instrumentHandle,
  ViPBoolean pTransactionInProgress,
  ViPUInt32 pCurrBufferLength
  );


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// HP STANDARD UTILITY FUNCTIONS                  
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_timeOut(
  ViSession  instrumentHandle,
  ViInt32    setTimeOut
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeOut_Q(
  ViSession  instrumentHandle,
  ViPInt32   timeOut
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_errorQueryDetect(
  ViSession  instrumentHandle,
  ViBoolean  setErrorQueryDetect
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_errorQueryDetect_Q(
  ViSession  instrumentHandle,
  ViPBoolean errorQueryDetect
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_dcl(
  ViSession  instrumentHandle
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_opc_Q(
  ViSession  instrumentHandle,
  ViPBoolean instrumentReady
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// STATUS FUNCTIONS                  
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_readStatusByte_Q(
  ViSession  instrumentHandle,
  ViPInt16   statusByte
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_operEvent_Q(
  ViSession  instrumentHandle,
  ViPInt32   operationEventRegister
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_operCond_Q(
  ViSession  instrumentHandle,
  ViPInt32   operationConditionRegister 
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_quesEvent_Q(
  ViSession  instrumentHandle,
  ViPInt32   questionableEventRegister 
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_quesCond_Q(
  ViSession  instrumentHandle,
  ViPInt32   questionableConditionRegister 
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// COMMAND PASSTHROUGH FUNCTIONS      
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_cmd(
  ViSession  instrumentHandle,
  ViString   sendStringCommand
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdWithControlSequence( 
  ViSession instrumentHandle,
  ViString  sendStringCommand
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdInt(
  ViSession  instrumentHandle,
  ViString   sendIntegerCommand,
  ViInt32    sendInteger
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdInt16_Q(
  ViSession  instrumentHandle,
  ViString   queryI16Command,
  ViPInt16   i16Result
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdInt32_Q(
  ViSession  instrumentHandle,
  ViString   queryI32Command,
  ViPInt32   i32Result
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdUInt(
  ViSession  instrumentHandle,
  ViString   sendUIntegerCommand,
  ViUInt32   sendUInteger
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdUInt16_Q(
  ViSession instrumentHandle,
  ViString  queryUI16Command,
  ViPUInt16 ui16Result
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdUInt32_Q(
  ViSession  instrumentHandle,
  ViString   queryUI32Command,
  ViPUInt32  ui32Result
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdString(
  ViSession  instrumentHandle,
  ViString   sendStringCommand, 
  ViString   sendString 
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdString_Q(
  ViSession  instrumentHandle,
  ViString   queryStringCommand, 
  ViInt32    stringSize,
  ViPString  stringResult
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdReal(
  ViSession  instrumentHandle,
  ViString   sendRealCommand,
  ViReal64   sendReal
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdReal64_Q(
  ViSession  instrumentHandle,
  ViString   queryRealCommand,
  ViPReal64  realResult
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdInt8Arr(
  ViSession instrumentHandle,
  ViString  sendI8ArrayCommand,
  ViPChar   sendI8Array,
  ViInt32   sendI8ArraySize
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_cmdInt8Arr_Q(
  ViSession instrumentHandle,
  ViString  queryI8ArrayCommand,
  ViInt32   i8ArraySize,
  ViPChar   i8ArrayResult,
  ViPInt32  i8ArrayCount
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// MODE-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// General used
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_modePulseType( 
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  pulseType
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modePulseType_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 pulseType
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modePatternDataFormat(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  dataFormat
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modePatternDataFormat_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 dataFormat
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Mode - Continuous
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_modeContinuousPulses(
  ViSession instrumentHandle,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modeContinuousBurst(
  ViSession instrumentHandle,
  ViUInt32  burstLength,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modeContinuousPattern(
  ViSession instrumentHandle,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Mode - Triggered
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_modeTriggeredPulses( 
  ViSession instrumentHandle,
  ViUInt16  triggerSource,
  ViUInt16  triggerSlope
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modeTriggeredBurst(
  ViSession instrumentHandle,
  ViUInt32  burstLength,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge,
  ViUInt16  triggerSource,
  ViUInt16  triggerSlope,
  ViUInt16  pllPeriodFrequencyFormat,
  ViReal64  pllPeriodFrequencyValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modeTriggeredPattern( 
  ViSession instrumentHandle,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge,
  ViUInt16  triggerSource,
  ViUInt16  triggerSlope,
  ViUInt16  pllPeriodFrequencyFormat,
  ViReal64  pllPeriodFrequencyValue
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Mode - Gated
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_modeGatedPulses(
  ViSession instrumentHandle,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge,
  ViUInt16  gateSource,
  ViUInt16  gateLevel
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modeGatedBurst(
  ViSession instrumentHandle,
  ViUInt32  burstLength,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge,
  ViUInt16  gateSource,
  ViUInt16  gateLevel
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_modeGatedPattern(
  ViSession instrumentHandle,
  ViUInt16  pulsePeriodSource,
  ViUInt16  externalClockEdge,
  ViUInt16  gateSource,
  ViUInt16  gateLevel
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Mode - External Width
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_modeExternalWidth(
  ViSession instrumentHandle,
  ViUInt16  triggerSource
  );
//-------------------------------------------------------------------------



//00000000000000000000000000000000000000000000000000000000000000000000000000000
// TIMING-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Period
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timePeriod(
  ViSession instrumentHandle,
  ViReal64  periodValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timePeriod_Q(
  ViSession instrumentHandle,
  ViPReal64 periodValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timePeriodMeasure(
  ViSession instrumentHandle
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Frequency
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeFrequency(
  ViSession instrumentHandle,
  ViReal64  frequencyValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeFrequency_Q(
  ViSession instrumentHandle,
  ViPReal64 frequencyValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeFrequencyMeasure(
  ViSession instrumentHandle
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Delay
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeDelay(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  delayUnit,
  ViReal64  delayValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeDelay_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 delayUnit,
  ViPReal64 delayValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeDelayHold(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  delayHoldMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeDelayHold_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 delayHoldMode
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Double-Delay
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeDelayDouble(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  doubleDelayUnit,
  ViReal64  doubleDelayValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeDelayDouble_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 doubleDelayUnit,
  ViPReal64 doubleDelayValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeDelayDoubleHold(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  doubleDelayHoldMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeDelayDoubleHold_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 doubleDelayHoldMode
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Width
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeWidth(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViReal64  widthValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidth_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPReal64 widthValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidthDutyCycle(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViReal64  dutyCycleValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidthDutyCycle_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPReal64 dutyCycleValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidthTrailingDelay(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViReal64  trailingDelayValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidthTrailingDelay_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPReal64 trailingDelayValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidthHold(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  widthHoldMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeWidthHold_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 widthHoldMode
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Leading-Edge
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeEdgeLeading(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  leadingEdgeUnit,
  ViReal64  leadingEdgeValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeEdgeLeading_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 leadingEdgeUnit,
  ViPReal64 leadingEdgeValue
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Trailing-Edge
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeEdgeTrailing(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  trailingEdgeUnit,
  ViReal64  trailingEdgeValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeEdgeTrailing_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 trailingEdgeUnit,
  ViPReal64 trailingEdgeValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeEdgeTrailingCoupling(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  trailingEdgeCoupling
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeEdgeTrailingCoupling_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 trailingEdgeCoupling
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Timing - Edge Hold
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeEdgeHold(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  edgeHoldMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_timeEdgeHold_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 edgeHoldMode
  );
//-------------------------------------------------------------------------

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_timeCalibration(
  ViSession instrumentHandle
  );
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

//00000000000000000000000000000000000000000000000000000000000000000000000000000
// LEVEL-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_levelHighLow(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  levelUnit,
  ViReal64  levelValueHigh,
  ViReal64  levelValueLow
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_levelHighLow_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 levelUnit,
  ViPReal64 levelValueHigh,
  ViPReal64 levelValueLow
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_levelOffsetAmplitude(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  levelUnit,
  ViReal64  levelValueOffset,
  ViReal64  levelValueAmplitude
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_levelOffsetAmplitude_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 levelUnit,
  ViPReal64 levelValueOffset,
  ViPReal64 levelValueAmplitude
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// PATTERN-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_patternUpdate(
  ViSession instrumentHandle,
  ViUInt16  patternUpdateMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternUpdate_Q(
  ViSession instrumentHandle,
  ViPUInt16 patternUpdateMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternDataDownloadBuffer(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt8  dataBuffer,
  ViUInt32  patternLength
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternDataDownloadBuffer_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt8  dataBuffer,
  ViPUInt32 patternLengthReturned,
  ViUInt32  bufferSize,
  ViUInt16  convertBinaryToAscii
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternDataDownloadFile(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViString  fileName
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternDataDownloadFile_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViString  fileName,
  ViUInt16  convertBinaryToAscii
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternDataPreset(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt32  patternDivider,
  ViUInt32  patternLength
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_patternDataPRBS(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  polynomExponent,
  ViUInt32  patternLength
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// SETTING-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_settingStore(
  ViSession instrumentHandle,
  ViUInt16  settingNumber
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_settingRecall(
  ViSession instrumentHandle,
  ViUInt16  settingNumber
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_settingFile(
  ViSession instrumentHandle,
  ViString  settingSourceFileName
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_settingFile_Q(
  ViSession instrumentHandle,
  ViString  settingDestinationFileName
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// LIMIT-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_limitState(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  limitEnable
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_limitState_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 limitEnable
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_limit(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViReal64  limitsVoltageHighLevel,
  ViReal64  limitsVoltageLowLevel,
  ViReal64  limitsCurrentHighLevel,
  ViReal64  limitsCurrentLowLevel
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_limit_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPReal64 limitsVoltageHighLevel,
  ViPReal64 limitsVoltageLowLevel,
  ViPReal64 limitsCurrentHighLevel,
  ViPReal64 limitsCurrentLowLevel
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// CONFIG-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Configuration - Outputs
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_configOutputImpedance(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViReal64  internalImpedance
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configOutputImpedance_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPReal64 internalImpedance
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configOutputLoadCompensation(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViReal64  loadCompensation
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configOutputLoadCompensation_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPReal64 loadCompensation
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Configuration - Inputs
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_configInputExternal(
  ViSession instrumentHandle,
  ViReal64  inputExternalThreshold,
  ViReal64  inputExternalImpedance
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configInputExternal_Q(
  ViSession instrumentHandle,
  ViPReal64 inputExternalThreshold,
  ViPReal64 inputExternalImpedance
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configInputClock(
  ViSession instrumentHandle,
  ViReal64  inputClockThreshold,
  ViReal64  inputClockImpedance
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configInputClock_Q(
  ViSession instrumentHandle,
  ViPReal64 inputClockThreshold,
  ViPReal64 inputClockImpedance
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Configuration - PLL
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ViStatus _VI_FUNC hpe8311a_configPllReference(
  ViSession instrumentHandle,
  ViUInt16  pllSourceSelect,
  ViReal64  pllExternalFrequencyValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configPllReference_Q(
  ViSession instrumentHandle,
  ViPUInt16 pllSourceSelect,
  ViPReal64 pllExternalFrequencyValue
  );
//-------------------------------------------------------------------------


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Configuration - Trigger-Levels
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


ViStatus _VI_FUNC hpe8311a_configTriggerOutLevel(
  ViSession instrumentHandle,
  ViUInt16  triggerOuput,
  ViUInt16  triggerLevel
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configTriggerOutLevel_Q(
  ViSession instrumentHandle,
  ViUInt16  triggerOuput,
  ViPUInt16 triggerLevel
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configTriggerOutSource(
  ViSession instrumentHandle,
  ViUInt16  triggerSource
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_configTriggerOutSource_Q(
  ViSession instrumentHandle,
  ViPUInt16 triggerSource
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// OUTPUT-FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_outputMath(
  ViSession instrumentHandle,
  ViUInt16  mathMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputMath_Q(
  ViSession instrumentHandle,
  ViPUInt16 mathMode
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputStateNormal(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  outputNormalState
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputStateNormal_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 outputNormalState
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputStateComplement(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  outputComplementState
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputStateComplement_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 outputComplementState
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputPolarity(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViUInt16  outputStatePolarity
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputPolarity_Q(
  ViSession instrumentHandle,
  ViUInt16  channel,
  ViPUInt16 outputStatePolarity
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputSourceVxiTrigger(
  ViSession instrumentHandle,
  ViUInt16 triggerOutput
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputSourceVxiTrigger_Q(
  ViSession instrumentHandle,
  ViPUInt16 triggerOutput
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputEnableVxiTrigger(
  ViSession instrumentHandle,
  ViUInt16  triggerLine
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_outputEnableVxiTrigger_Q(
  ViSession instrumentHandle,
  ViPUInt16 triggerLine
  );
//-------------------------------------------------------------------------


//00000000000000000000000000000000000000000000000000000000000000000000000000000
// ARMING FUNCTIONS
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_armFrequency(
  ViSession instrumentHandle,
  ViReal64  frequencyValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_armFrequency_Q(
  ViSession instrumentHandle,
  ViPReal64 frequencyValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_armPeriod(
  ViSession instrumentHandle,
  ViReal64  periodValue
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_armPeriod_Q(
  ViSession instrumentHandle,
  ViPReal64 periodValue
  );
//-------------------------------------------------------------------------

//00000000000000000000000000000000000000000000000000000000000000000000000000000
// Undocumented very harmful specific functions
//   Hewlett-Packard recommends not to use them
//   Only good for expert use!
//00000000000000000000000000000000000000000000000000000000000000000000000000000
ViStatus _VI_FUNC hpe8311a_biosProgramFile(
  ViSession instrumentHandle,
  ViString  filename
  );
//-------------------------------------------------------------------------
ViStatus _VI_FUNC hpe8311a_biosSpecial(
  ViSession instrumentHandle
  );
//-------------------------------------------------------------------------




#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif 

#endif //  HPE8311A_INCLUDE 
